package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContentCategorySchema;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ContentCategorySchemaDao_Impl extends ContentCategorySchemaDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContentCategorySchema> __insertionAdapterOfContentCategorySchema;

  private final EntityDeletionOrUpdateAdapter<ContentCategorySchema> __updateAdapterOfContentCategorySchema;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public ContentCategorySchemaDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContentCategorySchema = new EntityInsertionAdapter<ContentCategorySchema>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ContentCategorySchema` (`contentCategorySchemaUid`,`schemaName`,`schemaUrl`,`contentCategorySchemaLocalChangeSeqNum`,`contentCategorySchemaMasterChangeSeqNum`,`contentCategorySchemaLastChangedBy`,`contentCategorySchemaLct`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentCategorySchema value) {
        stmt.bindLong(1, value.getContentCategorySchemaUid());
        if (value.getSchemaName() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getSchemaName());
        }
        if (value.getSchemaUrl() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getSchemaUrl());
        }
        stmt.bindLong(4, value.getContentCategorySchemaLocalChangeSeqNum());
        stmt.bindLong(5, value.getContentCategorySchemaMasterChangeSeqNum());
        stmt.bindLong(6, value.getContentCategorySchemaLastChangedBy());
        stmt.bindLong(7, value.getContentCategorySchemaLct());
      }
    };
    this.__updateAdapterOfContentCategorySchema = new EntityDeletionOrUpdateAdapter<ContentCategorySchema>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ContentCategorySchema` SET `contentCategorySchemaUid` = ?,`schemaName` = ?,`schemaUrl` = ?,`contentCategorySchemaLocalChangeSeqNum` = ?,`contentCategorySchemaMasterChangeSeqNum` = ?,`contentCategorySchemaLastChangedBy` = ?,`contentCategorySchemaLct` = ? WHERE `contentCategorySchemaUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentCategorySchema value) {
        stmt.bindLong(1, value.getContentCategorySchemaUid());
        if (value.getSchemaName() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getSchemaName());
        }
        if (value.getSchemaUrl() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getSchemaUrl());
        }
        stmt.bindLong(4, value.getContentCategorySchemaLocalChangeSeqNum());
        stmt.bindLong(5, value.getContentCategorySchemaMasterChangeSeqNum());
        stmt.bindLong(6, value.getContentCategorySchemaLastChangedBy());
        stmt.bindLong(7, value.getContentCategorySchemaLct());
        stmt.bindLong(8, value.getContentCategorySchemaUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO ContentCategorySchemaReplicate(ccsPk, ccsDestination)\n"
                + "      SELECT DISTINCT ContentCategorySchema.contentCategorySchemaUid AS ccsPk,\n"
                + "             ? AS ccsDestination\n"
                + "        FROM ContentCategorySchema\n"
                + "       WHERE ContentCategorySchema.contentCategorySchemaLct != COALESCE(\n"
                + "             (SELECT ccsVersionId\n"
                + "                FROM ContentCategorySchemaReplicate\n"
                + "               WHERE ccsPk = ContentCategorySchema.contentCategorySchemaUid\n"
                + "                 AND ccsDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(ccsPk, ccsDestination) DO UPDATE\n"
                + "             SET ccsPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ContentCategorySchemaReplicate(ccsPk, ccsDestination)\n"
                + "  SELECT DISTINCT ContentCategorySchema.contentCategorySchemaUid AS ccsUid,\n"
                + "         UserSession.usClientNodeId AS ccsDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN ContentCategorySchema\n"
                + "             ON ChangeLog.chTableId = 2\n"
                + "                AND ChangeLog.chEntityPk = ContentCategorySchema.contentCategorySchemaUid\n"
                + "         JOIN UserSession ON UserSession.usStatus = 1\n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND ContentCategorySchema.contentCategorySchemaLct != COALESCE(\n"
                + "         (SELECT ccsVersionId\n"
                + "            FROM ContentCategorySchemaReplicate\n"
                + "           WHERE ccsPk = ContentCategorySchema.contentCategorySchemaUid\n"
                + "             AND ccsDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(ccsPk, ccsDestination) DO UPDATE\n"
                + "     SET ccsPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ContentCategorySchema entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfContentCategorySchema.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContentCategorySchema entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfContentCategorySchema.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ContentCategorySchema> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContentCategorySchema.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ContentCategorySchema> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentCategorySchema.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ContentCategorySchema entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentCategorySchema.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public List<ContentCategorySchema> publicContentCategorySchemas() {
    final String _sql = "SELECT ContentCategorySchema.* FROM ContentCategorySchema";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContentCategorySchemaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategorySchemaUid");
      final int _cursorIndexOfSchemaName = CursorUtil.getColumnIndexOrThrow(_cursor, "schemaName");
      final int _cursorIndexOfSchemaUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "schemaUrl");
      final int _cursorIndexOfContentCategorySchemaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategorySchemaLocalChangeSeqNum");
      final int _cursorIndexOfContentCategorySchemaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategorySchemaMasterChangeSeqNum");
      final int _cursorIndexOfContentCategorySchemaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategorySchemaLastChangedBy");
      final int _cursorIndexOfContentCategorySchemaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategorySchemaLct");
      final List<ContentCategorySchema> _result = new ArrayList<ContentCategorySchema>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContentCategorySchema _item;
        _item = new ContentCategorySchema();
        final long _tmpContentCategorySchemaUid;
        _tmpContentCategorySchemaUid = _cursor.getLong(_cursorIndexOfContentCategorySchemaUid);
        _item.setContentCategorySchemaUid(_tmpContentCategorySchemaUid);
        final String _tmpSchemaName;
        if (_cursor.isNull(_cursorIndexOfSchemaName)) {
          _tmpSchemaName = null;
        } else {
          _tmpSchemaName = _cursor.getString(_cursorIndexOfSchemaName);
        }
        _item.setSchemaName(_tmpSchemaName);
        final String _tmpSchemaUrl;
        if (_cursor.isNull(_cursorIndexOfSchemaUrl)) {
          _tmpSchemaUrl = null;
        } else {
          _tmpSchemaUrl = _cursor.getString(_cursorIndexOfSchemaUrl);
        }
        _item.setSchemaUrl(_tmpSchemaUrl);
        final long _tmpContentCategorySchemaLocalChangeSeqNum;
        _tmpContentCategorySchemaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategorySchemaLocalChangeSeqNum);
        _item.setContentCategorySchemaLocalChangeSeqNum(_tmpContentCategorySchemaLocalChangeSeqNum);
        final long _tmpContentCategorySchemaMasterChangeSeqNum;
        _tmpContentCategorySchemaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategorySchemaMasterChangeSeqNum);
        _item.setContentCategorySchemaMasterChangeSeqNum(_tmpContentCategorySchemaMasterChangeSeqNum);
        final int _tmpContentCategorySchemaLastChangedBy;
        _tmpContentCategorySchemaLastChangedBy = _cursor.getInt(_cursorIndexOfContentCategorySchemaLastChangedBy);
        _item.setContentCategorySchemaLastChangedBy(_tmpContentCategorySchemaLastChangedBy);
        final long _tmpContentCategorySchemaLct;
        _tmpContentCategorySchemaLct = _cursor.getLong(_cursorIndexOfContentCategorySchemaLct);
        _item.setContentCategorySchemaLct(_tmpContentCategorySchemaLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public ContentCategorySchema findBySchemaUrl(final String schemaUrl) {
    final String _sql = "SELECT * FROM ContentCategorySchema WHERE schemaUrl = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (schemaUrl == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, schemaUrl);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContentCategorySchemaUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategorySchemaUid");
      final int _cursorIndexOfSchemaName = CursorUtil.getColumnIndexOrThrow(_cursor, "schemaName");
      final int _cursorIndexOfSchemaUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "schemaUrl");
      final int _cursorIndexOfContentCategorySchemaLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategorySchemaLocalChangeSeqNum");
      final int _cursorIndexOfContentCategorySchemaMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategorySchemaMasterChangeSeqNum");
      final int _cursorIndexOfContentCategorySchemaLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategorySchemaLastChangedBy");
      final int _cursorIndexOfContentCategorySchemaLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentCategorySchemaLct");
      final ContentCategorySchema _result;
      if(_cursor.moveToFirst()) {
        _result = new ContentCategorySchema();
        final long _tmpContentCategorySchemaUid;
        _tmpContentCategorySchemaUid = _cursor.getLong(_cursorIndexOfContentCategorySchemaUid);
        _result.setContentCategorySchemaUid(_tmpContentCategorySchemaUid);
        final String _tmpSchemaName;
        if (_cursor.isNull(_cursorIndexOfSchemaName)) {
          _tmpSchemaName = null;
        } else {
          _tmpSchemaName = _cursor.getString(_cursorIndexOfSchemaName);
        }
        _result.setSchemaName(_tmpSchemaName);
        final String _tmpSchemaUrl;
        if (_cursor.isNull(_cursorIndexOfSchemaUrl)) {
          _tmpSchemaUrl = null;
        } else {
          _tmpSchemaUrl = _cursor.getString(_cursorIndexOfSchemaUrl);
        }
        _result.setSchemaUrl(_tmpSchemaUrl);
        final long _tmpContentCategorySchemaLocalChangeSeqNum;
        _tmpContentCategorySchemaLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategorySchemaLocalChangeSeqNum);
        _result.setContentCategorySchemaLocalChangeSeqNum(_tmpContentCategorySchemaLocalChangeSeqNum);
        final long _tmpContentCategorySchemaMasterChangeSeqNum;
        _tmpContentCategorySchemaMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentCategorySchemaMasterChangeSeqNum);
        _result.setContentCategorySchemaMasterChangeSeqNum(_tmpContentCategorySchemaMasterChangeSeqNum);
        final int _tmpContentCategorySchemaLastChangedBy;
        _tmpContentCategorySchemaLastChangedBy = _cursor.getInt(_cursorIndexOfContentCategorySchemaLastChangedBy);
        _result.setContentCategorySchemaLastChangedBy(_tmpContentCategorySchemaLastChangedBy);
        final long _tmpContentCategorySchemaLct;
        _tmpContentCategorySchemaLct = _cursor.getLong(_cursorIndexOfContentCategorySchemaLct);
        _result.setContentCategorySchemaLct(_tmpContentCategorySchemaLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
