package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmission;
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionAttachment;
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionWithAttachment;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class CourseAssignmentSubmissionDao_Impl extends CourseAssignmentSubmissionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CourseAssignmentSubmission> __insertionAdapterOfCourseAssignmentSubmission;

  private final EntityDeletionOrUpdateAdapter<CourseAssignmentSubmission> __updateAdapterOfCourseAssignmentSubmission;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public CourseAssignmentSubmissionDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCourseAssignmentSubmission = new EntityInsertionAdapter<CourseAssignmentSubmission>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `CourseAssignmentSubmission` (`casUid`,`casAssignmentUid`,`casSubmitterUid`,`casSubmitterPersonUid`,`casText`,`casType`,`casTimestamp`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CourseAssignmentSubmission value) {
        stmt.bindLong(1, value.getCasUid());
        stmt.bindLong(2, value.getCasAssignmentUid());
        stmt.bindLong(3, value.getCasSubmitterUid());
        stmt.bindLong(4, value.getCasSubmitterPersonUid());
        if (value.getCasText() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getCasText());
        }
        stmt.bindLong(6, value.getCasType());
        stmt.bindLong(7, value.getCasTimestamp());
      }
    };
    this.__updateAdapterOfCourseAssignmentSubmission = new EntityDeletionOrUpdateAdapter<CourseAssignmentSubmission>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `CourseAssignmentSubmission` SET `casUid` = ?,`casAssignmentUid` = ?,`casSubmitterUid` = ?,`casSubmitterPersonUid` = ?,`casText` = ?,`casType` = ?,`casTimestamp` = ? WHERE `casUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CourseAssignmentSubmission value) {
        stmt.bindLong(1, value.getCasUid());
        stmt.bindLong(2, value.getCasAssignmentUid());
        stmt.bindLong(3, value.getCasSubmitterUid());
        stmt.bindLong(4, value.getCasSubmitterPersonUid());
        if (value.getCasText() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getCasText());
        }
        stmt.bindLong(6, value.getCasType());
        stmt.bindLong(7, value.getCasTimestamp());
        stmt.bindLong(8, value.getCasUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO CourseAssignmentSubmissionReplicate(casPk, casDestination)\n"
                + "      SELECT DISTINCT CourseAssignmentSubmission.casUid AS casPk,\n"
                + "             ? AS casDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember \n"
                + "                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                    8388608 \n"
                + "                    \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "               JOIN ClazzAssignment\n"
                + "                    ON ClazzAssignment.caClazzUid = Clazz.clazzUid                \n"
                + "             JOIN CourseAssignmentSubmission\n"
                + "                    ON CourseAssignmentSubmission.casAssignmentUid = ClazzAssignment.caUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND CourseAssignmentSubmission.casTimestamp != COALESCE(\n"
                + "             (SELECT casVersionId\n"
                + "                FROM CourseAssignmentSubmissionReplicate\n"
                + "               WHERE casPk = CourseAssignmentSubmission.casUid\n"
                + "                 AND casDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(casPk, casDestination) DO UPDATE\n"
                + "             SET casPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO CourseAssignmentSubmissionReplicate(casPk, casDestination)\n"
                + "  SELECT DISTINCT CourseAssignmentSubmission.casUid AS casPk,\n"
                + "         UserSession.usClientNodeId AS casDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN CourseAssignmentSubmission\n"
                + "             ON ChangeLog.chTableId = 522\n"
                + "                AND ChangeLog.chEntityPk = CourseAssignmentSubmission.casUid\n"
                + "             JOIN ClazzAssignment\n"
                + "                    ON CourseAssignmentSubmission.casAssignmentUid = ClazzAssignment.caUid\n"
                + "             JOIN Clazz\n"
                + "                    ON  Clazz.clazzUid = ClazzAssignment.caClazzUid\n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              8388608\n"
                + "              \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "          \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND CourseAssignmentSubmission.casTimestamp != COALESCE(\n"
                + "         (SELECT casVersionId\n"
                + "            FROM CourseAssignmentSubmissionReplicate\n"
                + "           WHERE casPk = CourseAssignmentSubmission.casUid\n"
                + "             AND casDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(casPk, casDestination) DO UPDATE\n"
                + "     SET casPending = true\n"
                + "  */               \n"
                + " ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final CourseAssignmentSubmission entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfCourseAssignmentSubmission.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final CourseAssignmentSubmission entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfCourseAssignmentSubmission.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends CourseAssignmentSubmission> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCourseAssignmentSubmission.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends CourseAssignmentSubmission> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseAssignmentSubmission.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void updateList(final List<? extends CourseAssignmentSubmission> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseAssignmentSubmission.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final CourseAssignmentSubmission entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseAssignmentSubmission.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, CourseAssignmentSubmissionWithAttachment> getAllSubmissionsFromSubmitter(
      final long assignmentUid, final long submitterUid) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM CourseAssignmentSubmission\n"
            + "          \n"
            + "               LEFT JOIN CourseAssignmentSubmissionAttachment\n"
            + "               ON CourseAssignmentSubmissionAttachment.casaSubmissionUid = CourseAssignmentSubmission.casUid\n"
            + "               \n"
            + "         WHERE casAssignmentUid = ?\n"
            + "           AND casSubmitterUid = ?\n"
            + "      ORDER BY casTimestamp DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    return new DataSource.Factory<Integer, CourseAssignmentSubmissionWithAttachment>() {
      @Override
      public LimitOffsetDataSource<CourseAssignmentSubmissionWithAttachment> create() {
        return new LimitOffsetDataSource<CourseAssignmentSubmissionWithAttachment>(__db, _statement, false, true , "CourseAssignmentSubmission", "CourseAssignmentSubmissionAttachment") {
          @Override
          protected List<CourseAssignmentSubmissionWithAttachment> convertRows(Cursor cursor) {
            final int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow(cursor, "casUid");
            final int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow(cursor, "casAssignmentUid");
            final int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "casSubmitterUid");
            final int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "casSubmitterPersonUid");
            final int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow(cursor, "casText");
            final int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow(cursor, "casType");
            final int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow(cursor, "casTimestamp");
            final int _cursorIndexOfCasaUid = CursorUtil.getColumnIndexOrThrow(cursor, "casaUid");
            final int _cursorIndexOfCasaSubmissionUid = CursorUtil.getColumnIndexOrThrow(cursor, "casaSubmissionUid");
            final int _cursorIndexOfCasaMimeType = CursorUtil.getColumnIndexOrThrow(cursor, "casaMimeType");
            final int _cursorIndexOfCasaFileName = CursorUtil.getColumnIndexOrThrow(cursor, "casaFileName");
            final int _cursorIndexOfCasaUri = CursorUtil.getColumnIndexOrThrow(cursor, "casaUri");
            final int _cursorIndexOfCasaMd5 = CursorUtil.getColumnIndexOrThrow(cursor, "casaMd5");
            final int _cursorIndexOfCasaSize = CursorUtil.getColumnIndexOrThrow(cursor, "casaSize");
            final int _cursorIndexOfCasaTimestamp = CursorUtil.getColumnIndexOrThrow(cursor, "casaTimestamp");
            final List<CourseAssignmentSubmissionWithAttachment> _res = new ArrayList<CourseAssignmentSubmissionWithAttachment>(cursor.getCount());
            while(cursor.moveToNext()) {
              final CourseAssignmentSubmissionWithAttachment _item;
              final CourseAssignmentSubmissionAttachment _tmpAttachment;
              if (! (cursor.isNull(_cursorIndexOfCasaUid) && cursor.isNull(_cursorIndexOfCasaSubmissionUid) && cursor.isNull(_cursorIndexOfCasaMimeType) && cursor.isNull(_cursorIndexOfCasaFileName) && cursor.isNull(_cursorIndexOfCasaUri) && cursor.isNull(_cursorIndexOfCasaMd5) && cursor.isNull(_cursorIndexOfCasaSize) && cursor.isNull(_cursorIndexOfCasaTimestamp))) {
                _tmpAttachment = new CourseAssignmentSubmissionAttachment();
                final long _tmpCasaUid;
                _tmpCasaUid = cursor.getLong(_cursorIndexOfCasaUid);
                _tmpAttachment.setCasaUid(_tmpCasaUid);
                final long _tmpCasaSubmissionUid;
                _tmpCasaSubmissionUid = cursor.getLong(_cursorIndexOfCasaSubmissionUid);
                _tmpAttachment.setCasaSubmissionUid(_tmpCasaSubmissionUid);
                final String _tmpCasaMimeType;
                if (cursor.isNull(_cursorIndexOfCasaMimeType)) {
                  _tmpCasaMimeType = null;
                } else {
                  _tmpCasaMimeType = cursor.getString(_cursorIndexOfCasaMimeType);
                }
                _tmpAttachment.setCasaMimeType(_tmpCasaMimeType);
                final String _tmpCasaFileName;
                if (cursor.isNull(_cursorIndexOfCasaFileName)) {
                  _tmpCasaFileName = null;
                } else {
                  _tmpCasaFileName = cursor.getString(_cursorIndexOfCasaFileName);
                }
                _tmpAttachment.setCasaFileName(_tmpCasaFileName);
                final String _tmpCasaUri;
                if (cursor.isNull(_cursorIndexOfCasaUri)) {
                  _tmpCasaUri = null;
                } else {
                  _tmpCasaUri = cursor.getString(_cursorIndexOfCasaUri);
                }
                _tmpAttachment.setCasaUri(_tmpCasaUri);
                final String _tmpCasaMd5;
                if (cursor.isNull(_cursorIndexOfCasaMd5)) {
                  _tmpCasaMd5 = null;
                } else {
                  _tmpCasaMd5 = cursor.getString(_cursorIndexOfCasaMd5);
                }
                _tmpAttachment.setCasaMd5(_tmpCasaMd5);
                final int _tmpCasaSize;
                _tmpCasaSize = cursor.getInt(_cursorIndexOfCasaSize);
                _tmpAttachment.setCasaSize(_tmpCasaSize);
                final long _tmpCasaTimestamp;
                _tmpCasaTimestamp = cursor.getLong(_cursorIndexOfCasaTimestamp);
                _tmpAttachment.setCasaTimestamp(_tmpCasaTimestamp);
              }  else  {
                _tmpAttachment = null;
              }
              _item = new CourseAssignmentSubmissionWithAttachment();
              final long _tmpCasUid;
              _tmpCasUid = cursor.getLong(_cursorIndexOfCasUid);
              _item.setCasUid(_tmpCasUid);
              final long _tmpCasAssignmentUid;
              _tmpCasAssignmentUid = cursor.getLong(_cursorIndexOfCasAssignmentUid);
              _item.setCasAssignmentUid(_tmpCasAssignmentUid);
              final long _tmpCasSubmitterUid;
              _tmpCasSubmitterUid = cursor.getLong(_cursorIndexOfCasSubmitterUid);
              _item.setCasSubmitterUid(_tmpCasSubmitterUid);
              final long _tmpCasSubmitterPersonUid;
              _tmpCasSubmitterPersonUid = cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
              _item.setCasSubmitterPersonUid(_tmpCasSubmitterPersonUid);
              final String _tmpCasText;
              if (cursor.isNull(_cursorIndexOfCasText)) {
                _tmpCasText = null;
              } else {
                _tmpCasText = cursor.getString(_cursorIndexOfCasText);
              }
              _item.setCasText(_tmpCasText);
              final int _tmpCasType;
              _tmpCasType = cursor.getInt(_cursorIndexOfCasType);
              _item.setCasType(_tmpCasType);
              final long _tmpCasTimestamp;
              _tmpCasTimestamp = cursor.getLong(_cursorIndexOfCasTimestamp);
              _item.setCasTimestamp(_tmpCasTimestamp);
              _item.setAttachment(_tmpAttachment);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public Object countFileSubmissionFromStudent(final long assignmentUid, final long submitterUid,
      final Continuation<? super Integer> continuation) {
    final String _sql = "\n"
            + "        SELECT Count(casUid)\n"
            + "          FROM CourseAssignmentSubmission\n"
            + "         WHERE casAssignmentUid = ?\n"
            + "           AND casSubmitterUid = ?\n"
            + "           AND casType = 2\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object countSubmissionsFromSubmitter(final long assignmentUid, final long submitterUid,
      final Continuation<? super Integer> continuation) {
    final String _sql = "\n"
            + "        SELECT Count(casUid)\n"
            + "          FROM CourseAssignmentSubmission\n"
            + "         WHERE casAssignmentUid = ?\n"
            + "           AND casSubmitterUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<Integer> getStatusOfAssignmentForSubmitter(final long assignmentUid,
      final long submitterUid) {
    final String _sql = "\n"
            + "           SELECT COALESCE((\n"
            + "                SELECT (CASE WHEN CourseAssignmentMark.camAssignmentUid IS NOT NULL \n"
            + "                             THEN 2\n"
            + "                             ELSE 1 \n"
            + "                             END) AS status\n"
            + "                  FROM CourseAssignmentSubmission\n"
            + "                       \n"
            + "                       LEFT JOIN CourseAssignmentMark\n"
            + "                       ON CourseAssignmentMark.camAssignmentUid = ?\n"
            + "                       AND CourseAssignmentMark.camSubmitterUid = ?\n"
            + "                       \n"
            + "                 WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "                   AND CourseAssignmentSubmission.casSubmitterUid = ?\n"
            + "                 LIMIT 1\n"
            + "           ),0) AS Status\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, submitterUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"CourseAssignmentSubmission","CourseAssignmentMark"}, false, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findLastSubmissionFromStudent(final long submitterUid, final long assignmentUid,
      final Continuation<? super CourseAssignmentSubmission> continuation) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM CourseAssignmentSubmission\n"
            + "         WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "           AND CourseAssignmentSubmission.casSubmitterUid = ?\n"
            + "      ORDER BY casTimestamp DESC\n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, submitterUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseAssignmentSubmission>() {
      @Override
      public CourseAssignmentSubmission call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCasUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casUid");
          final int _cursorIndexOfCasAssignmentUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casAssignmentUid");
          final int _cursorIndexOfCasSubmitterUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterUid");
          final int _cursorIndexOfCasSubmitterPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "casSubmitterPersonUid");
          final int _cursorIndexOfCasText = CursorUtil.getColumnIndexOrThrow(_cursor, "casText");
          final int _cursorIndexOfCasType = CursorUtil.getColumnIndexOrThrow(_cursor, "casType");
          final int _cursorIndexOfCasTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "casTimestamp");
          final CourseAssignmentSubmission _result;
          if(_cursor.moveToFirst()) {
            _result = new CourseAssignmentSubmission();
            final long _tmpCasUid;
            _tmpCasUid = _cursor.getLong(_cursorIndexOfCasUid);
            _result.setCasUid(_tmpCasUid);
            final long _tmpCasAssignmentUid;
            _tmpCasAssignmentUid = _cursor.getLong(_cursorIndexOfCasAssignmentUid);
            _result.setCasAssignmentUid(_tmpCasAssignmentUid);
            final long _tmpCasSubmitterUid;
            _tmpCasSubmitterUid = _cursor.getLong(_cursorIndexOfCasSubmitterUid);
            _result.setCasSubmitterUid(_tmpCasSubmitterUid);
            final long _tmpCasSubmitterPersonUid;
            _tmpCasSubmitterPersonUid = _cursor.getLong(_cursorIndexOfCasSubmitterPersonUid);
            _result.setCasSubmitterPersonUid(_tmpCasSubmitterPersonUid);
            final String _tmpCasText;
            if (_cursor.isNull(_cursorIndexOfCasText)) {
              _tmpCasText = null;
            } else {
              _tmpCasText = _cursor.getString(_cursorIndexOfCasText);
            }
            _result.setCasText(_tmpCasText);
            final int _tmpCasType;
            _tmpCasType = _cursor.getInt(_cursorIndexOfCasType);
            _result.setCasType(_tmpCasType);
            final long _tmpCasTimestamp;
            _tmpCasTimestamp = _cursor.getLong(_cursorIndexOfCasTimestamp);
            _result.setCasTimestamp(_tmpCasTimestamp);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<Boolean> checkNoSubmissionsMade(final long assignmentUid) {
    final String _sql = "\n"
            + "         SELECT NOT EXISTS(SELECT 1\n"
            + "                        FROM CourseAssignmentSubmission\n"
            + "                       WHERE CourseAssignmentSubmission.casAssignmentUid = ?\n"
            + "                       LIMIT 1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"CourseAssignmentSubmission"}, false, new Callable<Boolean>() {
      @Override
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
