package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.CourseGroupMember;
import com.ustadmobile.lib.db.entities.CourseGroupMemberPerson;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class CourseGroupMemberDao_Impl extends CourseGroupMemberDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CourseGroupMember> __insertionAdapterOfCourseGroupMember;

  private final EntityDeletionOrUpdateAdapter<CourseGroupMember> __updateAdapterOfCourseGroupMember;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public CourseGroupMemberDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCourseGroupMember = new EntityInsertionAdapter<CourseGroupMember>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `CourseGroupMember` (`cgmUid`,`cgmSetUid`,`cgmGroupNumber`,`cgmPersonUid`,`cgmLct`) VALUES (nullif(?, 0),?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CourseGroupMember value) {
        stmt.bindLong(1, value.getCgmUid());
        stmt.bindLong(2, value.getCgmSetUid());
        stmt.bindLong(3, value.getCgmGroupNumber());
        stmt.bindLong(4, value.getCgmPersonUid());
        stmt.bindLong(5, value.getCgmLct());
      }
    };
    this.__updateAdapterOfCourseGroupMember = new EntityDeletionOrUpdateAdapter<CourseGroupMember>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `CourseGroupMember` SET `cgmUid` = ?,`cgmSetUid` = ?,`cgmGroupNumber` = ?,`cgmPersonUid` = ?,`cgmLct` = ? WHERE `cgmUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CourseGroupMember value) {
        stmt.bindLong(1, value.getCgmUid());
        stmt.bindLong(2, value.getCgmSetUid());
        stmt.bindLong(3, value.getCgmGroupNumber());
        stmt.bindLong(4, value.getCgmPersonUid());
        stmt.bindLong(5, value.getCgmLct());
        stmt.bindLong(6, value.getCgmUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO CourseGroupMemberReplicate(cgmPk, cgmDestination)\n"
                + "      SELECT DISTINCT CourseGroupMember.cgmUid AS cgmUid,\n"
                + "             ? AS cgmDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember \n"
                + "                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                    2 \n"
                + "                    \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "             JOIN CourseGroupSet\n"
                + "                    ON CourseGroupSet.cgsClazzUid = Clazz.clazzUid\n"
                + "             JOIN CourseGroupMember\n"
                + "                    ON CourseGroupMember.cgmSetUid = CourseGroupSet.cgsUid       \n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND CourseGroupMember.cgmLct != COALESCE(\n"
                + "             (SELECT cgmVersionId\n"
                + "                FROM CourseGroupMemberReplicate\n"
                + "               WHERE cgmPk = CourseGroupMember.cgmUid\n"
                + "                 AND cgmDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(cgmPk, cgmDestination) DO UPDATE\n"
                + "             SET cgmPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO CourseGroupMemberReplicate(cgmPk, cgmDestination)\n"
                + "  SELECT DISTINCT CourseGroupMember.cgmUid AS cgmUid,\n"
                + "         UserSession.usClientNodeId AS cgmDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN CourseGroupMember\n"
                + "               ON ChangeLog.chTableId = 243\n"
                + "                  AND ChangeLog.chEntityPk = CourseGroupMember.cgmUid\n"
                + "          JOIN CourseGroupSet\n"
                + "               ON CourseGroupSet.cgsUid = CourseGroupMember.cgmSetUid       \n"
                + "          JOIN Clazz \n"
                + "               ON Clazz.clazzUid = CourseGroupSet.cgsClazzUid \n"
                + "          \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              2\n"
                + "              \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "          \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND CourseGroupMember.cgmLct != COALESCE(\n"
                + "         (SELECT cgmVersionId\n"
                + "            FROM CourseGroupMemberReplicate\n"
                + "           WHERE cgmPk = CourseGroupMember.cgmUid\n"
                + "             AND cgmDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(cgmPk, cgmDestination) DO UPDATE\n"
                + "     SET cgmPending = true\n"
                + "  */               \n"
                + " ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final CourseGroupMember entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfCourseGroupMember.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final CourseGroupMember entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfCourseGroupMember.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends CourseGroupMember> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCourseGroupMember.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<CourseGroupMember> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseGroupMember.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void updateList(final List<? extends CourseGroupMember> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseGroupMember.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final CourseGroupMember entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseGroupMember.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateListAsync(final List<CourseGroupMember> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfCourseGroupMember.handleMultiple(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findByGroupSetAsync(final long setUid, final long clazzUid,
      final Continuation<? super List<CourseGroupMemberPerson>> continuation) {
    final String _sql = "\n"
            + "        SELECT Person.*, CourseGroupMember.* \n"
            + "          FROM Person\n"
            + "               JOIN ClazzEnrolment \n"
            + "               ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "               AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "               AND ClazzEnrolment.clazzEnrolmentOutcome = 200\n"
            + "               \n"
            + "               LEFT JOIN CourseGroupMember\n"
            + "               ON CourseGroupMember.cgmPersonUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "               AND CourseGroupMember.cgmSetUid = ?\n"
            + "               \n"
            + "         WHERE clazzEnrolmentClazzUid = ?\n"
            + "      ORDER BY Person.firstNames\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, setUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CourseGroupMemberPerson>>() {
      @Override
      public List<CourseGroupMemberPerson> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmUid");
          final int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmSetUid");
          final int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmGroupNumber");
          final int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmPersonUid");
          final int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmLct");
          final List<CourseGroupMemberPerson> _result = new ArrayList<CourseGroupMemberPerson>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final CourseGroupMemberPerson _item;
            final CourseGroupMember _tmpMember;
            if (! (_cursor.isNull(_cursorIndexOfCgmUid) && _cursor.isNull(_cursorIndexOfCgmSetUid) && _cursor.isNull(_cursorIndexOfCgmGroupNumber) && _cursor.isNull(_cursorIndexOfCgmPersonUid) && _cursor.isNull(_cursorIndexOfCgmLct))) {
              _tmpMember = new CourseGroupMember();
              final long _tmpCgmUid;
              _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
              _tmpMember.setCgmUid(_tmpCgmUid);
              final long _tmpCgmSetUid;
              _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
              _tmpMember.setCgmSetUid(_tmpCgmSetUid);
              final int _tmpCgmGroupNumber;
              _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
              _tmpMember.setCgmGroupNumber(_tmpCgmGroupNumber);
              final long _tmpCgmPersonUid;
              _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
              _tmpMember.setCgmPersonUid(_tmpCgmPersonUid);
              final long _tmpCgmLct;
              _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
              _tmpMember.setCgmLct(_tmpCgmLct);
            }  else  {
              _tmpMember = null;
            }
            _item = new CourseGroupMemberPerson();
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            _item.setPersonUid(_tmpPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            _item.setUsername(_tmpUsername);
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            _item.setFirstNames(_tmpFirstNames);
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            _item.setLastName(_tmpLastName);
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            _item.setEmailAddr(_tmpEmailAddr);
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            _item.setPhoneNum(_tmpPhoneNum);
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            _item.setGender(_tmpGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            _item.setActive(_tmpActive);
            final boolean _tmpAdmin;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_1 != 0;
            _item.setAdmin(_tmpAdmin);
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            _item.setPersonNotes(_tmpPersonNotes);
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            _item.setFatherName(_tmpFatherName);
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            _item.setFatherNumber(_tmpFatherNumber);
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            _item.setMotherName(_tmpMotherName);
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _item.setMotherNum(_tmpMotherNum);
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            _item.setDateOfBirth(_tmpDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            _item.setPersonAddress(_tmpPersonAddress);
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            _item.setPersonOrgId(_tmpPersonOrgId);
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            _item.setPersonGroupUid(_tmpPersonGroupUid);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            _item.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            _item.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            _item.setPersonLastChangedBy(_tmpPersonLastChangedBy);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            _item.setPersonLct(_tmpPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            _item.setPersonCountry(_tmpPersonCountry);
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            _item.setPersonType(_tmpPersonType);
            _item.setMember(_tmpMember);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByGroupSetOrderedAsync(final long setUid, final long clazzUid,
      final Continuation<? super List<CourseGroupMemberPerson>> continuation) {
    final String _sql = "\n"
            + "        SELECT Person.*, CourseGroupMember.* \n"
            + "          FROM Person\n"
            + "               JOIN ClazzEnrolment \n"
            + "               ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "               AND ClazzEnrolment.clazzEnrolmentRole = 1000 \n"
            + "               AND ClazzEnrolment.clazzEnrolmentOutcome = 200\n"
            + "               \n"
            + "               LEFT JOIN CourseGroupMember\n"
            + "               ON CourseGroupMember.cgmPersonUid = ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "               AND CourseGroupMember.cgmSetUid = ?\n"
            + "               \n"
            + "         WHERE clazzEnrolmentClazzUid = ?\n"
            + "      ORDER BY CourseGroupMember.cgmGroupNumber, Person.firstNames\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, setUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CourseGroupMemberPerson>>() {
      @Override
      public List<CourseGroupMemberPerson> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmUid");
          final int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmSetUid");
          final int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmGroupNumber");
          final int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmPersonUid");
          final int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmLct");
          final List<CourseGroupMemberPerson> _result = new ArrayList<CourseGroupMemberPerson>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final CourseGroupMemberPerson _item;
            final CourseGroupMember _tmpMember;
            if (! (_cursor.isNull(_cursorIndexOfCgmUid) && _cursor.isNull(_cursorIndexOfCgmSetUid) && _cursor.isNull(_cursorIndexOfCgmGroupNumber) && _cursor.isNull(_cursorIndexOfCgmPersonUid) && _cursor.isNull(_cursorIndexOfCgmLct))) {
              _tmpMember = new CourseGroupMember();
              final long _tmpCgmUid;
              _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
              _tmpMember.setCgmUid(_tmpCgmUid);
              final long _tmpCgmSetUid;
              _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
              _tmpMember.setCgmSetUid(_tmpCgmSetUid);
              final int _tmpCgmGroupNumber;
              _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
              _tmpMember.setCgmGroupNumber(_tmpCgmGroupNumber);
              final long _tmpCgmPersonUid;
              _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
              _tmpMember.setCgmPersonUid(_tmpCgmPersonUid);
              final long _tmpCgmLct;
              _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
              _tmpMember.setCgmLct(_tmpCgmLct);
            }  else  {
              _tmpMember = null;
            }
            _item = new CourseGroupMemberPerson();
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            _item.setPersonUid(_tmpPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            _item.setUsername(_tmpUsername);
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            _item.setFirstNames(_tmpFirstNames);
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            _item.setLastName(_tmpLastName);
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            _item.setEmailAddr(_tmpEmailAddr);
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            _item.setPhoneNum(_tmpPhoneNum);
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            _item.setGender(_tmpGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            _item.setActive(_tmpActive);
            final boolean _tmpAdmin;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_1 != 0;
            _item.setAdmin(_tmpAdmin);
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            _item.setPersonNotes(_tmpPersonNotes);
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            _item.setFatherName(_tmpFatherName);
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            _item.setFatherNumber(_tmpFatherNumber);
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            _item.setMotherName(_tmpMotherName);
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _item.setMotherNum(_tmpMotherNum);
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            _item.setDateOfBirth(_tmpDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            _item.setPersonAddress(_tmpPersonAddress);
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            _item.setPersonOrgId(_tmpPersonOrgId);
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            _item.setPersonGroupUid(_tmpPersonGroupUid);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            _item.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            _item.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            _item.setPersonLastChangedBy(_tmpPersonLastChangedBy);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            _item.setPersonLct(_tmpPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            _item.setPersonCountry(_tmpPersonCountry);
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            _item.setPersonType(_tmpPersonType);
            _item.setMember(_tmpMember);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByPersonUid(final long groupSetUid, final long studentUid,
      final Continuation<? super CourseGroupMember> continuation) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM CourseGroupMember\n"
            + "         WHERE cgmPersonUid = ? \n"
            + "          AND cgmSetUid = ?\n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, studentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, groupSetUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseGroupMember>() {
      @Override
      public CourseGroupMember call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCgmUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmUid");
          final int _cursorIndexOfCgmSetUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmSetUid");
          final int _cursorIndexOfCgmGroupNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmGroupNumber");
          final int _cursorIndexOfCgmPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmPersonUid");
          final int _cursorIndexOfCgmLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cgmLct");
          final CourseGroupMember _result;
          if(_cursor.moveToFirst()) {
            _result = new CourseGroupMember();
            final long _tmpCgmUid;
            _tmpCgmUid = _cursor.getLong(_cursorIndexOfCgmUid);
            _result.setCgmUid(_tmpCgmUid);
            final long _tmpCgmSetUid;
            _tmpCgmSetUid = _cursor.getLong(_cursorIndexOfCgmSetUid);
            _result.setCgmSetUid(_tmpCgmSetUid);
            final int _tmpCgmGroupNumber;
            _tmpCgmGroupNumber = _cursor.getInt(_cursorIndexOfCgmGroupNumber);
            _result.setCgmGroupNumber(_tmpCgmGroupNumber);
            final long _tmpCgmPersonUid;
            _tmpCgmPersonUid = _cursor.getLong(_cursorIndexOfCgmPersonUid);
            _result.setCgmPersonUid(_tmpCgmPersonUid);
            final long _tmpCgmLct;
            _tmpCgmLct = _cursor.getLong(_cursorIndexOfCgmLct);
            _result.setCgmLct(_tmpCgmLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
