package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.CourseTerminology;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class CourseTerminologyDao_Impl extends CourseTerminologyDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CourseTerminology> __insertionAdapterOfCourseTerminology;

  private final EntityDeletionOrUpdateAdapter<CourseTerminology> __updateAdapterOfCourseTerminology;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public CourseTerminologyDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCourseTerminology = new EntityInsertionAdapter<CourseTerminology>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `CourseTerminology` (`ctUid`,`ctTitle`,`ctTerminology`,`ctLct`) VALUES (nullif(?, 0),?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CourseTerminology value) {
        stmt.bindLong(1, value.getCtUid());
        if (value.getCtTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getCtTitle());
        }
        if (value.getCtTerminology() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCtTerminology());
        }
        stmt.bindLong(4, value.getCtLct());
      }
    };
    this.__updateAdapterOfCourseTerminology = new EntityDeletionOrUpdateAdapter<CourseTerminology>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `CourseTerminology` SET `ctUid` = ?,`ctTitle` = ?,`ctTerminology` = ?,`ctLct` = ? WHERE `ctUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, CourseTerminology value) {
        stmt.bindLong(1, value.getCtUid());
        if (value.getCtTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getCtTitle());
        }
        if (value.getCtTerminology() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCtTerminology());
        }
        stmt.bindLong(4, value.getCtLct());
        stmt.bindLong(5, value.getCtUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO CourseTerminologyReplicate(ctPk, ctDestination)\n"
                + "      SELECT DISTINCT CourseTerminology.ctUid AS ctPk,\n"
                + "             ? AS ctDestination\n"
                + "        FROM CourseTerminology\n"
                + "       WHERE CourseTerminology.ctLct != COALESCE(\n"
                + "             (SELECT ctVersionId\n"
                + "                FROM CourseTerminologyReplicate\n"
                + "               WHERE ctPk = CourseTerminology.ctUid\n"
                + "                 AND ctDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(ctPk, ctDestination) DO UPDATE\n"
                + "             SET ctPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO CourseTerminologyReplicate(ctPk, ctDestination)\n"
                + "  SELECT DISTINCT CourseTerminology.ctUid AS ctUid,\n"
                + "         UserSession.usClientNodeId AS ctDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN CourseTerminology\n"
                + "             ON ChangeLog.chTableId = 450\n"
                + "                AND ChangeLog.chEntityPk = CourseTerminology.ctUid\n"
                + "         JOIN UserSession ON UserSession.usStatus = 1\n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND CourseTerminology.ctLct != COALESCE(\n"
                + "         (SELECT ctVersionId\n"
                + "            FROM CourseTerminologyReplicate\n"
                + "           WHERE ctPk = CourseTerminology.ctUid\n"
                + "             AND ctDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(ctPk, ctDestination) DO UPDATE\n"
                + "     SET ctPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final CourseTerminology entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfCourseTerminology.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final CourseTerminology entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfCourseTerminology.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends CourseTerminology> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfCourseTerminology.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends CourseTerminology> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseTerminology.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final CourseTerminology entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfCourseTerminology.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final CourseTerminology entity,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfCourseTerminology.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, CourseTerminology> findAllCourseTerminology() {
    final String _sql = "\n"
            + "        SELECT *\n"
            + "         FROM CourseTerminology\n"
            + "     ORDER BY ctTitle   \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return new DataSource.Factory<Integer, CourseTerminology>() {
      @Override
      public LimitOffsetDataSource<CourseTerminology> create() {
        return new LimitOffsetDataSource<CourseTerminology>(__db, _statement, false, true , "CourseTerminology") {
          @Override
          protected List<CourseTerminology> convertRows(Cursor cursor) {
            final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(cursor, "ctUid");
            final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(cursor, "ctTitle");
            final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(cursor, "ctTerminology");
            final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(cursor, "ctLct");
            final List<CourseTerminology> _res = new ArrayList<CourseTerminology>(cursor.getCount());
            while(cursor.moveToNext()) {
              final CourseTerminology _item;
              _item = new CourseTerminology();
              final long _tmpCtUid;
              _tmpCtUid = cursor.getLong(_cursorIndexOfCtUid);
              _item.setCtUid(_tmpCtUid);
              final String _tmpCtTitle;
              if (cursor.isNull(_cursorIndexOfCtTitle)) {
                _tmpCtTitle = null;
              } else {
                _tmpCtTitle = cursor.getString(_cursorIndexOfCtTitle);
              }
              _item.setCtTitle(_tmpCtTitle);
              final String _tmpCtTerminology;
              if (cursor.isNull(_cursorIndexOfCtTerminology)) {
                _tmpCtTerminology = null;
              } else {
                _tmpCtTerminology = cursor.getString(_cursorIndexOfCtTerminology);
              }
              _item.setCtTerminology(_tmpCtTerminology);
              final long _tmpCtLct;
              _tmpCtLct = cursor.getLong(_cursorIndexOfCtLct);
              _item.setCtLct(_tmpCtLct);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public List<CourseTerminology> findAllCourseTerminologyList() {
    final String _sql = "\n"
            + "        SELECT *\n"
            + "         FROM CourseTerminology\n"
            + "     ORDER BY ctTitle   \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctUid");
      final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTitle");
      final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTerminology");
      final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ctLct");
      final List<CourseTerminology> _result = new ArrayList<CourseTerminology>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final CourseTerminology _item;
        _item = new CourseTerminology();
        final long _tmpCtUid;
        _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
        _item.setCtUid(_tmpCtUid);
        final String _tmpCtTitle;
        if (_cursor.isNull(_cursorIndexOfCtTitle)) {
          _tmpCtTitle = null;
        } else {
          _tmpCtTitle = _cursor.getString(_cursorIndexOfCtTitle);
        }
        _item.setCtTitle(_tmpCtTitle);
        final String _tmpCtTerminology;
        if (_cursor.isNull(_cursorIndexOfCtTerminology)) {
          _tmpCtTerminology = null;
        } else {
          _tmpCtTerminology = _cursor.getString(_cursorIndexOfCtTerminology);
        }
        _item.setCtTerminology(_tmpCtTerminology);
        final long _tmpCtLct;
        _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
        _item.setCtLct(_tmpCtLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object getTerminologyForClazz(final long clazzUid,
      final Continuation<? super CourseTerminology> continuation) {
    final String _sql = "\n"
            + "        SELECT *\n"
            + "          FROM CourseTerminology\n"
            + "               JOIN Clazz \n"
            + "               ON Clazz.clazzTerminologyUid = CourseTerminology.ctUid\n"
            + "         WHERE Clazz.clazzUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseTerminology>() {
      @Override
      public CourseTerminology call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctUid");
          final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTitle");
          final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTerminology");
          final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ctLct");
          final CourseTerminology _result;
          if(_cursor.moveToFirst()) {
            _result = new CourseTerminology();
            final long _tmpCtUid;
            _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
            _result.setCtUid(_tmpCtUid);
            final String _tmpCtTitle;
            if (_cursor.isNull(_cursorIndexOfCtTitle)) {
              _tmpCtTitle = null;
            } else {
              _tmpCtTitle = _cursor.getString(_cursorIndexOfCtTitle);
            }
            _result.setCtTitle(_tmpCtTitle);
            final String _tmpCtTerminology;
            if (_cursor.isNull(_cursorIndexOfCtTerminology)) {
              _tmpCtTerminology = null;
            } else {
              _tmpCtTerminology = _cursor.getString(_cursorIndexOfCtTerminology);
            }
            _result.setCtTerminology(_tmpCtTerminology);
            final long _tmpCtLct;
            _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
            _result.setCtLct(_tmpCtLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super CourseTerminology> continuation) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "         FROM CourseTerminology \n"
            + "        WHERE ctUid = ?\n"
            + "        ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<CourseTerminology>() {
      @Override
      public CourseTerminology call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctUid");
          final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTitle");
          final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTerminology");
          final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ctLct");
          final CourseTerminology _result;
          if(_cursor.moveToFirst()) {
            _result = new CourseTerminology();
            final long _tmpCtUid;
            _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
            _result.setCtUid(_tmpCtUid);
            final String _tmpCtTitle;
            if (_cursor.isNull(_cursorIndexOfCtTitle)) {
              _tmpCtTitle = null;
            } else {
              _tmpCtTitle = _cursor.getString(_cursorIndexOfCtTitle);
            }
            _result.setCtTitle(_tmpCtTitle);
            final String _tmpCtTerminology;
            if (_cursor.isNull(_cursorIndexOfCtTerminology)) {
              _tmpCtTerminology = null;
            } else {
              _tmpCtTerminology = _cursor.getString(_cursorIndexOfCtTerminology);
            }
            _result.setCtTerminology(_tmpCtTerminology);
            final long _tmpCtLct;
            _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
            _result.setCtLct(_tmpCtLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
