package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ErrorReport;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ErrorReportDao_Impl extends ErrorReportDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ErrorReport> __insertionAdapterOfErrorReport;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public ErrorReportDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfErrorReport = new EntityInsertionAdapter<ErrorReport>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ErrorReport` (`errUid`,`errPcsn`,`errLcsn`,`errLcb`,`errLct`,`severity`,`timestamp`,`presenterUri`,`appVersion`,`versionCode`,`errorCode`,`operatingSys`,`osVersion`,`stackTrace`,`message`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ErrorReport value) {
        stmt.bindLong(1, value.getErrUid());
        stmt.bindLong(2, value.getErrPcsn());
        stmt.bindLong(3, value.getErrLcsn());
        stmt.bindLong(4, value.getErrLcb());
        stmt.bindLong(5, value.getErrLct());
        stmt.bindLong(6, value.getSeverity());
        stmt.bindLong(7, value.getTimestamp());
        if (value.getPresenterUri() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getPresenterUri());
        }
        if (value.getAppVersion() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getAppVersion());
        }
        stmt.bindLong(10, value.getVersionCode());
        stmt.bindLong(11, value.getErrorCode());
        if (value.getOperatingSys() == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindString(12, value.getOperatingSys());
        }
        if (value.getOsVersion() == null) {
          stmt.bindNull(13);
        } else {
          stmt.bindString(13, value.getOsVersion());
        }
        if (value.getStackTrace() == null) {
          stmt.bindNull(14);
        } else {
          stmt.bindString(14, value.getStackTrace());
        }
        if (value.getMessage() == null) {
          stmt.bindNull(15);
        } else {
          stmt.bindString(15, value.getMessage());
        }
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ErrorReportReplicate(erPk, erDestination)\n"
                + "  SELECT DISTINCT ErrorReport.errUid AS erUid,\n"
                + "           UserSession.usClientNodeId AS erDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN ErrorReport\n"
                + "             ON ChangeLog.chTableId = 419\n"
                + "                AND ChangeLog.chEntityPk = ErrorReport.errUid\n"
                + "         JOIN UserSession ON UserSession.usSessionType = 2\n"
                + "    WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND ErrorReport.errLct != COALESCE(\n"
                + "         (SELECT erVersionId\n"
                + "            FROM ErrorReportReplicate\n"
                + "           WHERE erPk = ErrorReport.errUid\n"
                + "             AND erDestination = UserSession.usClientNodeId), 0)\n"
                + "    /*psql ON CONFLICT(erPk, erDestination) DO UPDATE\n"
                + "     SET erPending = true\n"
                + "    */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertAsync(final ErrorReport errorReport,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfErrorReport.insertAndReturnId(errorReport);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidAsync(final long errUid,
      final Continuation<? super ErrorReport> continuation) {
    final String _sql = "\n"
            + "        SELECT ErrorReport.* \n"
            + "          FROM ErrorReport\n"
            + "         WHERE errUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, errUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ErrorReport>() {
      @Override
      public ErrorReport call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfErrUid = CursorUtil.getColumnIndexOrThrow(_cursor, "errUid");
          final int _cursorIndexOfErrPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "errPcsn");
          final int _cursorIndexOfErrLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "errLcsn");
          final int _cursorIndexOfErrLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "errLcb");
          final int _cursorIndexOfErrLct = CursorUtil.getColumnIndexOrThrow(_cursor, "errLct");
          final int _cursorIndexOfSeverity = CursorUtil.getColumnIndexOrThrow(_cursor, "severity");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfPresenterUri = CursorUtil.getColumnIndexOrThrow(_cursor, "presenterUri");
          final int _cursorIndexOfAppVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "appVersion");
          final int _cursorIndexOfVersionCode = CursorUtil.getColumnIndexOrThrow(_cursor, "versionCode");
          final int _cursorIndexOfErrorCode = CursorUtil.getColumnIndexOrThrow(_cursor, "errorCode");
          final int _cursorIndexOfOperatingSys = CursorUtil.getColumnIndexOrThrow(_cursor, "operatingSys");
          final int _cursorIndexOfOsVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "osVersion");
          final int _cursorIndexOfStackTrace = CursorUtil.getColumnIndexOrThrow(_cursor, "stackTrace");
          final int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "message");
          final ErrorReport _result;
          if(_cursor.moveToFirst()) {
            _result = new ErrorReport();
            final long _tmpErrUid;
            _tmpErrUid = _cursor.getLong(_cursorIndexOfErrUid);
            _result.setErrUid(_tmpErrUid);
            final long _tmpErrPcsn;
            _tmpErrPcsn = _cursor.getLong(_cursorIndexOfErrPcsn);
            _result.setErrPcsn(_tmpErrPcsn);
            final long _tmpErrLcsn;
            _tmpErrLcsn = _cursor.getLong(_cursorIndexOfErrLcsn);
            _result.setErrLcsn(_tmpErrLcsn);
            final int _tmpErrLcb;
            _tmpErrLcb = _cursor.getInt(_cursorIndexOfErrLcb);
            _result.setErrLcb(_tmpErrLcb);
            final long _tmpErrLct;
            _tmpErrLct = _cursor.getLong(_cursorIndexOfErrLct);
            _result.setErrLct(_tmpErrLct);
            final int _tmpSeverity;
            _tmpSeverity = _cursor.getInt(_cursorIndexOfSeverity);
            _result.setSeverity(_tmpSeverity);
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            _result.setTimestamp(_tmpTimestamp);
            final String _tmpPresenterUri;
            if (_cursor.isNull(_cursorIndexOfPresenterUri)) {
              _tmpPresenterUri = null;
            } else {
              _tmpPresenterUri = _cursor.getString(_cursorIndexOfPresenterUri);
            }
            _result.setPresenterUri(_tmpPresenterUri);
            final String _tmpAppVersion;
            if (_cursor.isNull(_cursorIndexOfAppVersion)) {
              _tmpAppVersion = null;
            } else {
              _tmpAppVersion = _cursor.getString(_cursorIndexOfAppVersion);
            }
            _result.setAppVersion(_tmpAppVersion);
            final int _tmpVersionCode;
            _tmpVersionCode = _cursor.getInt(_cursorIndexOfVersionCode);
            _result.setVersionCode(_tmpVersionCode);
            final int _tmpErrorCode;
            _tmpErrorCode = _cursor.getInt(_cursorIndexOfErrorCode);
            _result.setErrorCode(_tmpErrorCode);
            final String _tmpOperatingSys;
            if (_cursor.isNull(_cursorIndexOfOperatingSys)) {
              _tmpOperatingSys = null;
            } else {
              _tmpOperatingSys = _cursor.getString(_cursorIndexOfOperatingSys);
            }
            _result.setOperatingSys(_tmpOperatingSys);
            final String _tmpOsVersion;
            if (_cursor.isNull(_cursorIndexOfOsVersion)) {
              _tmpOsVersion = null;
            } else {
              _tmpOsVersion = _cursor.getString(_cursorIndexOfOsVersion);
            }
            _result.setOsVersion(_tmpOsVersion);
            final String _tmpStackTrace;
            if (_cursor.isNull(_cursorIndexOfStackTrace)) {
              _tmpStackTrace = null;
            } else {
              _tmpStackTrace = _cursor.getString(_cursorIndexOfStackTrace);
            }
            _result.setStackTrace(_tmpStackTrace);
            final String _tmpMessage;
            if (_cursor.isNull(_cursorIndexOfMessage)) {
              _tmpMessage = null;
            } else {
              _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
            }
            _result.setMessage(_tmpMessage);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByErrorCode(final int errCode,
      final Continuation<? super List<ErrorReport>> continuation) {
    final String _sql = "\n"
            + "        SELECT ErrorReport.*\n"
            + "          FROM ErrorReport\n"
            + "         WHERE errorCode = ?  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, errCode);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ErrorReport>>() {
      @Override
      public List<ErrorReport> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfErrUid = CursorUtil.getColumnIndexOrThrow(_cursor, "errUid");
          final int _cursorIndexOfErrPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "errPcsn");
          final int _cursorIndexOfErrLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "errLcsn");
          final int _cursorIndexOfErrLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "errLcb");
          final int _cursorIndexOfErrLct = CursorUtil.getColumnIndexOrThrow(_cursor, "errLct");
          final int _cursorIndexOfSeverity = CursorUtil.getColumnIndexOrThrow(_cursor, "severity");
          final int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "timestamp");
          final int _cursorIndexOfPresenterUri = CursorUtil.getColumnIndexOrThrow(_cursor, "presenterUri");
          final int _cursorIndexOfAppVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "appVersion");
          final int _cursorIndexOfVersionCode = CursorUtil.getColumnIndexOrThrow(_cursor, "versionCode");
          final int _cursorIndexOfErrorCode = CursorUtil.getColumnIndexOrThrow(_cursor, "errorCode");
          final int _cursorIndexOfOperatingSys = CursorUtil.getColumnIndexOrThrow(_cursor, "operatingSys");
          final int _cursorIndexOfOsVersion = CursorUtil.getColumnIndexOrThrow(_cursor, "osVersion");
          final int _cursorIndexOfStackTrace = CursorUtil.getColumnIndexOrThrow(_cursor, "stackTrace");
          final int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow(_cursor, "message");
          final List<ErrorReport> _result = new ArrayList<ErrorReport>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ErrorReport _item;
            _item = new ErrorReport();
            final long _tmpErrUid;
            _tmpErrUid = _cursor.getLong(_cursorIndexOfErrUid);
            _item.setErrUid(_tmpErrUid);
            final long _tmpErrPcsn;
            _tmpErrPcsn = _cursor.getLong(_cursorIndexOfErrPcsn);
            _item.setErrPcsn(_tmpErrPcsn);
            final long _tmpErrLcsn;
            _tmpErrLcsn = _cursor.getLong(_cursorIndexOfErrLcsn);
            _item.setErrLcsn(_tmpErrLcsn);
            final int _tmpErrLcb;
            _tmpErrLcb = _cursor.getInt(_cursorIndexOfErrLcb);
            _item.setErrLcb(_tmpErrLcb);
            final long _tmpErrLct;
            _tmpErrLct = _cursor.getLong(_cursorIndexOfErrLct);
            _item.setErrLct(_tmpErrLct);
            final int _tmpSeverity;
            _tmpSeverity = _cursor.getInt(_cursorIndexOfSeverity);
            _item.setSeverity(_tmpSeverity);
            final long _tmpTimestamp;
            _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
            _item.setTimestamp(_tmpTimestamp);
            final String _tmpPresenterUri;
            if (_cursor.isNull(_cursorIndexOfPresenterUri)) {
              _tmpPresenterUri = null;
            } else {
              _tmpPresenterUri = _cursor.getString(_cursorIndexOfPresenterUri);
            }
            _item.setPresenterUri(_tmpPresenterUri);
            final String _tmpAppVersion;
            if (_cursor.isNull(_cursorIndexOfAppVersion)) {
              _tmpAppVersion = null;
            } else {
              _tmpAppVersion = _cursor.getString(_cursorIndexOfAppVersion);
            }
            _item.setAppVersion(_tmpAppVersion);
            final int _tmpVersionCode;
            _tmpVersionCode = _cursor.getInt(_cursorIndexOfVersionCode);
            _item.setVersionCode(_tmpVersionCode);
            final int _tmpErrorCode;
            _tmpErrorCode = _cursor.getInt(_cursorIndexOfErrorCode);
            _item.setErrorCode(_tmpErrorCode);
            final String _tmpOperatingSys;
            if (_cursor.isNull(_cursorIndexOfOperatingSys)) {
              _tmpOperatingSys = null;
            } else {
              _tmpOperatingSys = _cursor.getString(_cursorIndexOfOperatingSys);
            }
            _item.setOperatingSys(_tmpOperatingSys);
            final String _tmpOsVersion;
            if (_cursor.isNull(_cursorIndexOfOsVersion)) {
              _tmpOsVersion = null;
            } else {
              _tmpOsVersion = _cursor.getString(_cursorIndexOfOsVersion);
            }
            _item.setOsVersion(_tmpOsVersion);
            final String _tmpStackTrace;
            if (_cursor.isNull(_cursorIndexOfStackTrace)) {
              _tmpStackTrace = null;
            } else {
              _tmpStackTrace = _cursor.getString(_cursorIndexOfStackTrace);
            }
            _item.setStackTrace(_tmpStackTrace);
            final String _tmpMessage;
            if (_cursor.isNull(_cursorIndexOfMessage)) {
              _tmpMessage = null;
            } else {
              _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
            }
            _item.setMessage(_tmpMessage);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
