package com.ustadmobile.core.db.dao;

import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.GroupLearningSession;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class GroupLearningSessionDao_Impl extends GroupLearningSessionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<GroupLearningSession> __insertionAdapterOfGroupLearningSession;

  private final EntityDeletionOrUpdateAdapter<GroupLearningSession> __updateAdapterOfGroupLearningSession;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public GroupLearningSessionDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfGroupLearningSession = new EntityInsertionAdapter<GroupLearningSession>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `GroupLearningSession` (`groupLearningSessionUid`,`groupLearningSessionContentUid`,`groupLearningSessionLearnerGroupUid`,`groupLearningSessionInactive`,`groupLearningSessionMCSN`,`groupLearningSessionCSN`,`groupLearningSessionLCB`,`groupLearningSessionLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, GroupLearningSession value) {
        stmt.bindLong(1, value.getGroupLearningSessionUid());
        stmt.bindLong(2, value.getGroupLearningSessionContentUid());
        stmt.bindLong(3, value.getGroupLearningSessionLearnerGroupUid());
        final int _tmp = value.getGroupLearningSessionInactive() ? 1 : 0;
        stmt.bindLong(4, _tmp);
        stmt.bindLong(5, value.getGroupLearningSessionMCSN());
        stmt.bindLong(6, value.getGroupLearningSessionCSN());
        stmt.bindLong(7, value.getGroupLearningSessionLCB());
        stmt.bindLong(8, value.getGroupLearningSessionLct());
      }
    };
    this.__updateAdapterOfGroupLearningSession = new EntityDeletionOrUpdateAdapter<GroupLearningSession>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `GroupLearningSession` SET `groupLearningSessionUid` = ?,`groupLearningSessionContentUid` = ?,`groupLearningSessionLearnerGroupUid` = ?,`groupLearningSessionInactive` = ?,`groupLearningSessionMCSN` = ?,`groupLearningSessionCSN` = ?,`groupLearningSessionLCB` = ?,`groupLearningSessionLct` = ? WHERE `groupLearningSessionUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, GroupLearningSession value) {
        stmt.bindLong(1, value.getGroupLearningSessionUid());
        stmt.bindLong(2, value.getGroupLearningSessionContentUid());
        stmt.bindLong(3, value.getGroupLearningSessionLearnerGroupUid());
        final int _tmp = value.getGroupLearningSessionInactive() ? 1 : 0;
        stmt.bindLong(4, _tmp);
        stmt.bindLong(5, value.getGroupLearningSessionMCSN());
        stmt.bindLong(6, value.getGroupLearningSessionCSN());
        stmt.bindLong(7, value.getGroupLearningSessionLCB());
        stmt.bindLong(8, value.getGroupLearningSessionLct());
        stmt.bindLong(9, value.getGroupLearningSessionUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO GroupLearningSessionReplicate(glsPk, glsDestination)\n"
                + "      SELECT DISTINCT GroupLearningSession.groupLearningSessionUid AS glsPk,\n"
                + "             ? AS glsDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember\n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                    AND (ScopedGrant.sgPermissions &\n"
                + "                  64\n"
                + "                  \n"
                + "                                                    ) > 0\n"
                + "            JOIN Person \n"
                + "                 ON \n"
                + "                ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberPersonUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )    \n"
                + "        \n"
                + "        \n"
                + "             JOIN LearnerGroupMember\n"
                + "                  ON LearnerGroupMember.learnerGroupMemberPersonUid = Person.personUid\n"
                + "             JOIN GroupLearningSession\n"
                + "                  ON GroupLearningSession.groupLearningSessionLearnerGroupUid = LearnerGroupMember.learnerGroupMemberLgUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND GroupLearningSession.groupLearningSessionLct != COALESCE(\n"
                + "             (SELECT glsVersionId\n"
                + "                FROM GroupLearningSessionReplicate\n"
                + "               WHERE glsPk = GroupLearningSession.groupLearningSessionUid\n"
                + "                 AND glsDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(glsPk, glsDestination) DO UPDATE\n"
                + "             SET glsPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO GroupLearningSessionReplicate(glsPk, glsDestination)\n"
                + "  SELECT DISTINCT GroupLearningSession.groupLearningSessionUid AS glsUid,\n"
                + "         UserSession.usClientNodeId AS glsDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN GroupLearningSession\n"
                + "              ON ChangeLog.chTableId = 302\n"
                + "                 AND ChangeLog.chEntityPk = GroupLearningSession.groupLearningSessionUid\n"
                + "         JOIN LearnerGroupMember\n"
                + "              ON LearnerGroupMember.learnerGroupMemberLgUid = GroupLearningSession.groupLearningSessionLearnerGroupUid\n"
                + "         JOIN Person\n"
                + "              ON Person.personUid = LearnerGroupMember.learnerGroupMemberPersonUid\n"
                + "         \n"
                + "            JOIN ScopedGrant \n"
                + "                   ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentClazzUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentPersonUid = Person.personUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberSchoolUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberPersonUid = Person.personUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )\n"
                + "        \n"
                + "                   AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              64\n"
                + "              \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND GroupLearningSession.groupLearningSessionLct != COALESCE(\n"
                + "         (SELECT glsVersionId\n"
                + "            FROM GroupLearningSessionReplicate\n"
                + "           WHERE glsPk = GroupLearningSession.groupLearningSessionUid\n"
                + "             AND glsDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(glsPk, glsDestination) DO UPDATE\n"
                + "     SET glsPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final GroupLearningSession entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfGroupLearningSession.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final GroupLearningSession entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfGroupLearningSession.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends GroupLearningSession> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfGroupLearningSession.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends GroupLearningSession> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfGroupLearningSession.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final GroupLearningSession entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfGroupLearningSession.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
