package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.NetworkNode;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class NetworkNodeDao_Impl extends NetworkNodeDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<NetworkNode> __insertionAdapterOfNetworkNode;

  private final EntityDeletionOrUpdateAdapter<NetworkNode> __updateAdapterOfNetworkNode;

  private final SharedSQLiteStatement __preparedStmtOfDeleteByBluetoothAddress;

  private final SharedSQLiteStatement __preparedStmtOfDeleteAllAsync;

  private final SharedSQLiteStatement __preparedStmtOfUpdateRetryCountAsync;

  private final SharedSQLiteStatement __preparedStmtOfUpdateLastSeenAsync;

  private final SharedSQLiteStatement __preparedStmtOfDeleteOldAndBadNode;

  private final SharedSQLiteStatement __preparedStmtOfUpdateNetworkNodeGroupSsid;

  public NetworkNodeDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfNetworkNode = new EntityInsertionAdapter<NetworkNode>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `NetworkNode` (`nodeId`,`bluetoothMacAddress`,`ipAddress`,`wifiDirectMacAddress`,`deviceWifiDirectName`,`endpointUrl`,`lastUpdateTimeStamp`,`networkServiceLastUpdated`,`nsdServiceName`,`port`,`numFailureCount`,`wifiDirectDeviceStatus`,`groupSsid`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, NetworkNode value) {
        stmt.bindLong(1, value.getNodeId());
        if (value.getBluetoothMacAddress() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getBluetoothMacAddress());
        }
        if (value.getIpAddress() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getIpAddress());
        }
        if (value.getWifiDirectMacAddress() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getWifiDirectMacAddress());
        }
        if (value.getDeviceWifiDirectName() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getDeviceWifiDirectName());
        }
        if (value.getEndpointUrl() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getEndpointUrl());
        }
        stmt.bindLong(7, value.getLastUpdateTimeStamp());
        stmt.bindLong(8, value.getNetworkServiceLastUpdated());
        if (value.getNsdServiceName() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getNsdServiceName());
        }
        stmt.bindLong(10, value.getPort());
        stmt.bindLong(11, value.getNumFailureCount());
        stmt.bindLong(12, value.getWifiDirectDeviceStatus());
        if (value.getGroupSsid() == null) {
          stmt.bindNull(13);
        } else {
          stmt.bindString(13, value.getGroupSsid());
        }
      }
    };
    this.__updateAdapterOfNetworkNode = new EntityDeletionOrUpdateAdapter<NetworkNode>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `NetworkNode` SET `nodeId` = ?,`bluetoothMacAddress` = ?,`ipAddress` = ?,`wifiDirectMacAddress` = ?,`deviceWifiDirectName` = ?,`endpointUrl` = ?,`lastUpdateTimeStamp` = ?,`networkServiceLastUpdated` = ?,`nsdServiceName` = ?,`port` = ?,`numFailureCount` = ?,`wifiDirectDeviceStatus` = ?,`groupSsid` = ? WHERE `nodeId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, NetworkNode value) {
        stmt.bindLong(1, value.getNodeId());
        if (value.getBluetoothMacAddress() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getBluetoothMacAddress());
        }
        if (value.getIpAddress() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getIpAddress());
        }
        if (value.getWifiDirectMacAddress() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getWifiDirectMacAddress());
        }
        if (value.getDeviceWifiDirectName() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getDeviceWifiDirectName());
        }
        if (value.getEndpointUrl() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getEndpointUrl());
        }
        stmt.bindLong(7, value.getLastUpdateTimeStamp());
        stmt.bindLong(8, value.getNetworkServiceLastUpdated());
        if (value.getNsdServiceName() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getNsdServiceName());
        }
        stmt.bindLong(10, value.getPort());
        stmt.bindLong(11, value.getNumFailureCount());
        stmt.bindLong(12, value.getWifiDirectDeviceStatus());
        if (value.getGroupSsid() == null) {
          stmt.bindNull(13);
        } else {
          stmt.bindString(13, value.getGroupSsid());
        }
        stmt.bindLong(14, value.getNodeId());
      }
    };
    this.__preparedStmtOfDeleteByBluetoothAddress = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM NetworkNode WHERE bluetoothMacAddress = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteAllAsync = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM NetworkNode";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateRetryCountAsync = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE NetworkNode SET numFailureCount = numFailureCount + 1 WHERE nodeId = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateLastSeenAsync = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE NetworkNode set lastUpdateTimeStamp = ?, numFailureCount = 0 WHERE bluetoothMacAddress = ?";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteOldAndBadNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM NetworkNode WHERE NetworkNode.lastUpdateTimeStamp < ? OR NetworkNode.numFailureCount >= ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateNetworkNodeGroupSsid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "UPDATE NetworkNode SET groupSsid = ?, endpointUrl = ?  WHERE nodeId = ?";
        return _query;
      }
    };
  }

  @Override
  public long replace(final NetworkNode node) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfNetworkNode.insertAndReturnId(node);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final NetworkNode node, final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfNetworkNode.insertAndReturnId(node);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Long[] insertList(final List<? extends NetworkNode> nodeList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      Long[] _result = __insertionAdapterOfNetworkNode.insertAndReturnIdsArrayBox(nodeList);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final NetworkNode node) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfNetworkNode.handle(node);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void deleteByBluetoothAddress(final String bluetoothAddress) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteByBluetoothAddress.acquire();
    int _argIndex = 1;
    if (bluetoothAddress == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, bluetoothAddress);
    }
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfDeleteByBluetoothAddress.release(_stmt);
    }
  }

  @Override
  public Object deleteAllAsync(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteAllAsync.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDeleteAllAsync.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateRetryCountAsync(final long nodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateRetryCountAsync.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, nodeId);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateRetryCountAsync.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateLastSeenAsync(final String bluetoothAddress, final long lastUpdateTimeStamp,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateLastSeenAsync.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, lastUpdateTimeStamp);
        _argIndex = 2;
        if (bluetoothAddress == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, bluetoothAddress);
        }
        __db.beginTransaction();
        try {
          final java.lang.Integer _result = _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateLastSeenAsync.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public void deleteOldAndBadNode(final long minLastSeenTimestamp, final int maxFailuresInPeriod) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteOldAndBadNode.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, minLastSeenTimestamp);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, maxFailuresInPeriod);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfDeleteOldAndBadNode.release(_stmt);
    }
  }

  @Override
  public void updateNetworkNodeGroupSsid(final long nodeId, final String groupSsid,
      final String endpointUrl) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateNetworkNodeGroupSsid.acquire();
    int _argIndex = 1;
    if (groupSsid == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, groupSsid);
    }
    _argIndex = 2;
    if (endpointUrl == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, endpointUrl);
    }
    _argIndex = 3;
    _stmt.bindLong(_argIndex, nodeId);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateNetworkNodeGroupSsid.release(_stmt);
    }
  }

  @Override
  public List<NetworkNode> all() {
    final String _sql = "SELECT * FROM NetworkNode";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "nodeId");
      final int _cursorIndexOfBluetoothMacAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "bluetoothMacAddress");
      final int _cursorIndexOfIpAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "ipAddress");
      final int _cursorIndexOfWifiDirectMacAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "wifiDirectMacAddress");
      final int _cursorIndexOfDeviceWifiDirectName = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceWifiDirectName");
      final int _cursorIndexOfEndpointUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "endpointUrl");
      final int _cursorIndexOfLastUpdateTimeStamp = CursorUtil.getColumnIndexOrThrow(_cursor, "lastUpdateTimeStamp");
      final int _cursorIndexOfNetworkServiceLastUpdated = CursorUtil.getColumnIndexOrThrow(_cursor, "networkServiceLastUpdated");
      final int _cursorIndexOfNsdServiceName = CursorUtil.getColumnIndexOrThrow(_cursor, "nsdServiceName");
      final int _cursorIndexOfPort = CursorUtil.getColumnIndexOrThrow(_cursor, "port");
      final int _cursorIndexOfNumFailureCount = CursorUtil.getColumnIndexOrThrow(_cursor, "numFailureCount");
      final int _cursorIndexOfWifiDirectDeviceStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "wifiDirectDeviceStatus");
      final int _cursorIndexOfGroupSsid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupSsid");
      final List<NetworkNode> _result = new ArrayList<NetworkNode>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final NetworkNode _item;
        _item = new NetworkNode();
        final long _tmpNodeId;
        _tmpNodeId = _cursor.getLong(_cursorIndexOfNodeId);
        _item.setNodeId(_tmpNodeId);
        final String _tmpBluetoothMacAddress;
        if (_cursor.isNull(_cursorIndexOfBluetoothMacAddress)) {
          _tmpBluetoothMacAddress = null;
        } else {
          _tmpBluetoothMacAddress = _cursor.getString(_cursorIndexOfBluetoothMacAddress);
        }
        _item.setBluetoothMacAddress(_tmpBluetoothMacAddress);
        final String _tmpIpAddress;
        if (_cursor.isNull(_cursorIndexOfIpAddress)) {
          _tmpIpAddress = null;
        } else {
          _tmpIpAddress = _cursor.getString(_cursorIndexOfIpAddress);
        }
        _item.setIpAddress(_tmpIpAddress);
        final String _tmpWifiDirectMacAddress;
        if (_cursor.isNull(_cursorIndexOfWifiDirectMacAddress)) {
          _tmpWifiDirectMacAddress = null;
        } else {
          _tmpWifiDirectMacAddress = _cursor.getString(_cursorIndexOfWifiDirectMacAddress);
        }
        _item.setWifiDirectMacAddress(_tmpWifiDirectMacAddress);
        final String _tmpDeviceWifiDirectName;
        if (_cursor.isNull(_cursorIndexOfDeviceWifiDirectName)) {
          _tmpDeviceWifiDirectName = null;
        } else {
          _tmpDeviceWifiDirectName = _cursor.getString(_cursorIndexOfDeviceWifiDirectName);
        }
        _item.setDeviceWifiDirectName(_tmpDeviceWifiDirectName);
        final String _tmpEndpointUrl;
        if (_cursor.isNull(_cursorIndexOfEndpointUrl)) {
          _tmpEndpointUrl = null;
        } else {
          _tmpEndpointUrl = _cursor.getString(_cursorIndexOfEndpointUrl);
        }
        _item.setEndpointUrl(_tmpEndpointUrl);
        final long _tmpLastUpdateTimeStamp;
        _tmpLastUpdateTimeStamp = _cursor.getLong(_cursorIndexOfLastUpdateTimeStamp);
        _item.setLastUpdateTimeStamp(_tmpLastUpdateTimeStamp);
        final long _tmpNetworkServiceLastUpdated;
        _tmpNetworkServiceLastUpdated = _cursor.getLong(_cursorIndexOfNetworkServiceLastUpdated);
        _item.setNetworkServiceLastUpdated(_tmpNetworkServiceLastUpdated);
        final String _tmpNsdServiceName;
        if (_cursor.isNull(_cursorIndexOfNsdServiceName)) {
          _tmpNsdServiceName = null;
        } else {
          _tmpNsdServiceName = _cursor.getString(_cursorIndexOfNsdServiceName);
        }
        _item.setNsdServiceName(_tmpNsdServiceName);
        final int _tmpPort;
        _tmpPort = _cursor.getInt(_cursorIndexOfPort);
        _item.setPort(_tmpPort);
        final int _tmpNumFailureCount;
        _tmpNumFailureCount = _cursor.getInt(_cursorIndexOfNumFailureCount);
        _item.setNumFailureCount(_tmpNumFailureCount);
        final int _tmpWifiDirectDeviceStatus;
        _tmpWifiDirectDeviceStatus = _cursor.getInt(_cursorIndexOfWifiDirectDeviceStatus);
        _item.setWifiDirectDeviceStatus(_tmpWifiDirectDeviceStatus);
        final String _tmpGroupSsid;
        if (_cursor.isNull(_cursorIndexOfGroupSsid)) {
          _tmpGroupSsid = null;
        } else {
          _tmpGroupSsid = _cursor.getString(_cursorIndexOfGroupSsid);
        }
        _item.setGroupSsid(_tmpGroupSsid);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public NetworkNode findNodeByIpAddress(final String ipAddress) {
    final String _sql = "SELECT * From NetworkNode WHERE ipAddress = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (ipAddress == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, ipAddress);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "nodeId");
      final int _cursorIndexOfBluetoothMacAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "bluetoothMacAddress");
      final int _cursorIndexOfIpAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "ipAddress");
      final int _cursorIndexOfWifiDirectMacAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "wifiDirectMacAddress");
      final int _cursorIndexOfDeviceWifiDirectName = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceWifiDirectName");
      final int _cursorIndexOfEndpointUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "endpointUrl");
      final int _cursorIndexOfLastUpdateTimeStamp = CursorUtil.getColumnIndexOrThrow(_cursor, "lastUpdateTimeStamp");
      final int _cursorIndexOfNetworkServiceLastUpdated = CursorUtil.getColumnIndexOrThrow(_cursor, "networkServiceLastUpdated");
      final int _cursorIndexOfNsdServiceName = CursorUtil.getColumnIndexOrThrow(_cursor, "nsdServiceName");
      final int _cursorIndexOfPort = CursorUtil.getColumnIndexOrThrow(_cursor, "port");
      final int _cursorIndexOfNumFailureCount = CursorUtil.getColumnIndexOrThrow(_cursor, "numFailureCount");
      final int _cursorIndexOfWifiDirectDeviceStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "wifiDirectDeviceStatus");
      final int _cursorIndexOfGroupSsid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupSsid");
      final NetworkNode _result;
      if(_cursor.moveToFirst()) {
        _result = new NetworkNode();
        final long _tmpNodeId;
        _tmpNodeId = _cursor.getLong(_cursorIndexOfNodeId);
        _result.setNodeId(_tmpNodeId);
        final String _tmpBluetoothMacAddress;
        if (_cursor.isNull(_cursorIndexOfBluetoothMacAddress)) {
          _tmpBluetoothMacAddress = null;
        } else {
          _tmpBluetoothMacAddress = _cursor.getString(_cursorIndexOfBluetoothMacAddress);
        }
        _result.setBluetoothMacAddress(_tmpBluetoothMacAddress);
        final String _tmpIpAddress;
        if (_cursor.isNull(_cursorIndexOfIpAddress)) {
          _tmpIpAddress = null;
        } else {
          _tmpIpAddress = _cursor.getString(_cursorIndexOfIpAddress);
        }
        _result.setIpAddress(_tmpIpAddress);
        final String _tmpWifiDirectMacAddress;
        if (_cursor.isNull(_cursorIndexOfWifiDirectMacAddress)) {
          _tmpWifiDirectMacAddress = null;
        } else {
          _tmpWifiDirectMacAddress = _cursor.getString(_cursorIndexOfWifiDirectMacAddress);
        }
        _result.setWifiDirectMacAddress(_tmpWifiDirectMacAddress);
        final String _tmpDeviceWifiDirectName;
        if (_cursor.isNull(_cursorIndexOfDeviceWifiDirectName)) {
          _tmpDeviceWifiDirectName = null;
        } else {
          _tmpDeviceWifiDirectName = _cursor.getString(_cursorIndexOfDeviceWifiDirectName);
        }
        _result.setDeviceWifiDirectName(_tmpDeviceWifiDirectName);
        final String _tmpEndpointUrl;
        if (_cursor.isNull(_cursorIndexOfEndpointUrl)) {
          _tmpEndpointUrl = null;
        } else {
          _tmpEndpointUrl = _cursor.getString(_cursorIndexOfEndpointUrl);
        }
        _result.setEndpointUrl(_tmpEndpointUrl);
        final long _tmpLastUpdateTimeStamp;
        _tmpLastUpdateTimeStamp = _cursor.getLong(_cursorIndexOfLastUpdateTimeStamp);
        _result.setLastUpdateTimeStamp(_tmpLastUpdateTimeStamp);
        final long _tmpNetworkServiceLastUpdated;
        _tmpNetworkServiceLastUpdated = _cursor.getLong(_cursorIndexOfNetworkServiceLastUpdated);
        _result.setNetworkServiceLastUpdated(_tmpNetworkServiceLastUpdated);
        final String _tmpNsdServiceName;
        if (_cursor.isNull(_cursorIndexOfNsdServiceName)) {
          _tmpNsdServiceName = null;
        } else {
          _tmpNsdServiceName = _cursor.getString(_cursorIndexOfNsdServiceName);
        }
        _result.setNsdServiceName(_tmpNsdServiceName);
        final int _tmpPort;
        _tmpPort = _cursor.getInt(_cursorIndexOfPort);
        _result.setPort(_tmpPort);
        final int _tmpNumFailureCount;
        _tmpNumFailureCount = _cursor.getInt(_cursorIndexOfNumFailureCount);
        _result.setNumFailureCount(_tmpNumFailureCount);
        final int _tmpWifiDirectDeviceStatus;
        _tmpWifiDirectDeviceStatus = _cursor.getInt(_cursorIndexOfWifiDirectDeviceStatus);
        _result.setWifiDirectDeviceStatus(_tmpWifiDirectDeviceStatus);
        final String _tmpGroupSsid;
        if (_cursor.isNull(_cursorIndexOfGroupSsid)) {
          _tmpGroupSsid = null;
        } else {
          _tmpGroupSsid = _cursor.getString(_cursorIndexOfGroupSsid);
        }
        _result.setGroupSsid(_tmpGroupSsid);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public NetworkNode findNodeById(final long nodeId) {
    final String _sql = "SELECT * From NetworkNode WHERE nodeId = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, nodeId);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "nodeId");
      final int _cursorIndexOfBluetoothMacAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "bluetoothMacAddress");
      final int _cursorIndexOfIpAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "ipAddress");
      final int _cursorIndexOfWifiDirectMacAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "wifiDirectMacAddress");
      final int _cursorIndexOfDeviceWifiDirectName = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceWifiDirectName");
      final int _cursorIndexOfEndpointUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "endpointUrl");
      final int _cursorIndexOfLastUpdateTimeStamp = CursorUtil.getColumnIndexOrThrow(_cursor, "lastUpdateTimeStamp");
      final int _cursorIndexOfNetworkServiceLastUpdated = CursorUtil.getColumnIndexOrThrow(_cursor, "networkServiceLastUpdated");
      final int _cursorIndexOfNsdServiceName = CursorUtil.getColumnIndexOrThrow(_cursor, "nsdServiceName");
      final int _cursorIndexOfPort = CursorUtil.getColumnIndexOrThrow(_cursor, "port");
      final int _cursorIndexOfNumFailureCount = CursorUtil.getColumnIndexOrThrow(_cursor, "numFailureCount");
      final int _cursorIndexOfWifiDirectDeviceStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "wifiDirectDeviceStatus");
      final int _cursorIndexOfGroupSsid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupSsid");
      final NetworkNode _result;
      if(_cursor.moveToFirst()) {
        _result = new NetworkNode();
        final long _tmpNodeId;
        _tmpNodeId = _cursor.getLong(_cursorIndexOfNodeId);
        _result.setNodeId(_tmpNodeId);
        final String _tmpBluetoothMacAddress;
        if (_cursor.isNull(_cursorIndexOfBluetoothMacAddress)) {
          _tmpBluetoothMacAddress = null;
        } else {
          _tmpBluetoothMacAddress = _cursor.getString(_cursorIndexOfBluetoothMacAddress);
        }
        _result.setBluetoothMacAddress(_tmpBluetoothMacAddress);
        final String _tmpIpAddress;
        if (_cursor.isNull(_cursorIndexOfIpAddress)) {
          _tmpIpAddress = null;
        } else {
          _tmpIpAddress = _cursor.getString(_cursorIndexOfIpAddress);
        }
        _result.setIpAddress(_tmpIpAddress);
        final String _tmpWifiDirectMacAddress;
        if (_cursor.isNull(_cursorIndexOfWifiDirectMacAddress)) {
          _tmpWifiDirectMacAddress = null;
        } else {
          _tmpWifiDirectMacAddress = _cursor.getString(_cursorIndexOfWifiDirectMacAddress);
        }
        _result.setWifiDirectMacAddress(_tmpWifiDirectMacAddress);
        final String _tmpDeviceWifiDirectName;
        if (_cursor.isNull(_cursorIndexOfDeviceWifiDirectName)) {
          _tmpDeviceWifiDirectName = null;
        } else {
          _tmpDeviceWifiDirectName = _cursor.getString(_cursorIndexOfDeviceWifiDirectName);
        }
        _result.setDeviceWifiDirectName(_tmpDeviceWifiDirectName);
        final String _tmpEndpointUrl;
        if (_cursor.isNull(_cursorIndexOfEndpointUrl)) {
          _tmpEndpointUrl = null;
        } else {
          _tmpEndpointUrl = _cursor.getString(_cursorIndexOfEndpointUrl);
        }
        _result.setEndpointUrl(_tmpEndpointUrl);
        final long _tmpLastUpdateTimeStamp;
        _tmpLastUpdateTimeStamp = _cursor.getLong(_cursorIndexOfLastUpdateTimeStamp);
        _result.setLastUpdateTimeStamp(_tmpLastUpdateTimeStamp);
        final long _tmpNetworkServiceLastUpdated;
        _tmpNetworkServiceLastUpdated = _cursor.getLong(_cursorIndexOfNetworkServiceLastUpdated);
        _result.setNetworkServiceLastUpdated(_tmpNetworkServiceLastUpdated);
        final String _tmpNsdServiceName;
        if (_cursor.isNull(_cursorIndexOfNsdServiceName)) {
          _tmpNsdServiceName = null;
        } else {
          _tmpNsdServiceName = _cursor.getString(_cursorIndexOfNsdServiceName);
        }
        _result.setNsdServiceName(_tmpNsdServiceName);
        final int _tmpPort;
        _tmpPort = _cursor.getInt(_cursorIndexOfPort);
        _result.setPort(_tmpPort);
        final int _tmpNumFailureCount;
        _tmpNumFailureCount = _cursor.getInt(_cursorIndexOfNumFailureCount);
        _result.setNumFailureCount(_tmpNumFailureCount);
        final int _tmpWifiDirectDeviceStatus;
        _tmpWifiDirectDeviceStatus = _cursor.getInt(_cursorIndexOfWifiDirectDeviceStatus);
        _result.setWifiDirectDeviceStatus(_tmpWifiDirectDeviceStatus);
        final String _tmpGroupSsid;
        if (_cursor.isNull(_cursorIndexOfGroupSsid)) {
          _tmpGroupSsid = null;
        } else {
          _tmpGroupSsid = _cursor.getString(_cursorIndexOfGroupSsid);
        }
        _result.setGroupSsid(_tmpGroupSsid);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public NetworkNode findNodeByIpOrWifiDirectMacAddress(final String ipAddress,
      final String wifiDirectMacAddress) {
    final String _sql = "Select * From NetworkNode Where ((ipAddress = ? AND ipAddress IS NOT NULL) OR (wifiDirectMacAddress = ? AND wifiDirectMacAddress IS NOT NULL))";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    if (ipAddress == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, ipAddress);
    }
    _argIndex = 2;
    if (wifiDirectMacAddress == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, wifiDirectMacAddress);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "nodeId");
      final int _cursorIndexOfBluetoothMacAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "bluetoothMacAddress");
      final int _cursorIndexOfIpAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "ipAddress");
      final int _cursorIndexOfWifiDirectMacAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "wifiDirectMacAddress");
      final int _cursorIndexOfDeviceWifiDirectName = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceWifiDirectName");
      final int _cursorIndexOfEndpointUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "endpointUrl");
      final int _cursorIndexOfLastUpdateTimeStamp = CursorUtil.getColumnIndexOrThrow(_cursor, "lastUpdateTimeStamp");
      final int _cursorIndexOfNetworkServiceLastUpdated = CursorUtil.getColumnIndexOrThrow(_cursor, "networkServiceLastUpdated");
      final int _cursorIndexOfNsdServiceName = CursorUtil.getColumnIndexOrThrow(_cursor, "nsdServiceName");
      final int _cursorIndexOfPort = CursorUtil.getColumnIndexOrThrow(_cursor, "port");
      final int _cursorIndexOfNumFailureCount = CursorUtil.getColumnIndexOrThrow(_cursor, "numFailureCount");
      final int _cursorIndexOfWifiDirectDeviceStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "wifiDirectDeviceStatus");
      final int _cursorIndexOfGroupSsid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupSsid");
      final NetworkNode _result;
      if(_cursor.moveToFirst()) {
        _result = new NetworkNode();
        final long _tmpNodeId;
        _tmpNodeId = _cursor.getLong(_cursorIndexOfNodeId);
        _result.setNodeId(_tmpNodeId);
        final String _tmpBluetoothMacAddress;
        if (_cursor.isNull(_cursorIndexOfBluetoothMacAddress)) {
          _tmpBluetoothMacAddress = null;
        } else {
          _tmpBluetoothMacAddress = _cursor.getString(_cursorIndexOfBluetoothMacAddress);
        }
        _result.setBluetoothMacAddress(_tmpBluetoothMacAddress);
        final String _tmpIpAddress;
        if (_cursor.isNull(_cursorIndexOfIpAddress)) {
          _tmpIpAddress = null;
        } else {
          _tmpIpAddress = _cursor.getString(_cursorIndexOfIpAddress);
        }
        _result.setIpAddress(_tmpIpAddress);
        final String _tmpWifiDirectMacAddress;
        if (_cursor.isNull(_cursorIndexOfWifiDirectMacAddress)) {
          _tmpWifiDirectMacAddress = null;
        } else {
          _tmpWifiDirectMacAddress = _cursor.getString(_cursorIndexOfWifiDirectMacAddress);
        }
        _result.setWifiDirectMacAddress(_tmpWifiDirectMacAddress);
        final String _tmpDeviceWifiDirectName;
        if (_cursor.isNull(_cursorIndexOfDeviceWifiDirectName)) {
          _tmpDeviceWifiDirectName = null;
        } else {
          _tmpDeviceWifiDirectName = _cursor.getString(_cursorIndexOfDeviceWifiDirectName);
        }
        _result.setDeviceWifiDirectName(_tmpDeviceWifiDirectName);
        final String _tmpEndpointUrl;
        if (_cursor.isNull(_cursorIndexOfEndpointUrl)) {
          _tmpEndpointUrl = null;
        } else {
          _tmpEndpointUrl = _cursor.getString(_cursorIndexOfEndpointUrl);
        }
        _result.setEndpointUrl(_tmpEndpointUrl);
        final long _tmpLastUpdateTimeStamp;
        _tmpLastUpdateTimeStamp = _cursor.getLong(_cursorIndexOfLastUpdateTimeStamp);
        _result.setLastUpdateTimeStamp(_tmpLastUpdateTimeStamp);
        final long _tmpNetworkServiceLastUpdated;
        _tmpNetworkServiceLastUpdated = _cursor.getLong(_cursorIndexOfNetworkServiceLastUpdated);
        _result.setNetworkServiceLastUpdated(_tmpNetworkServiceLastUpdated);
        final String _tmpNsdServiceName;
        if (_cursor.isNull(_cursorIndexOfNsdServiceName)) {
          _tmpNsdServiceName = null;
        } else {
          _tmpNsdServiceName = _cursor.getString(_cursorIndexOfNsdServiceName);
        }
        _result.setNsdServiceName(_tmpNsdServiceName);
        final int _tmpPort;
        _tmpPort = _cursor.getInt(_cursorIndexOfPort);
        _result.setPort(_tmpPort);
        final int _tmpNumFailureCount;
        _tmpNumFailureCount = _cursor.getInt(_cursorIndexOfNumFailureCount);
        _result.setNumFailureCount(_tmpNumFailureCount);
        final int _tmpWifiDirectDeviceStatus;
        _tmpWifiDirectDeviceStatus = _cursor.getInt(_cursorIndexOfWifiDirectDeviceStatus);
        _result.setWifiDirectDeviceStatus(_tmpWifiDirectDeviceStatus);
        final String _tmpGroupSsid;
        if (_cursor.isNull(_cursorIndexOfGroupSsid)) {
          _tmpGroupSsid = null;
        } else {
          _tmpGroupSsid = _cursor.getString(_cursorIndexOfGroupSsid);
        }
        _result.setGroupSsid(_tmpGroupSsid);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public NetworkNode findNodeByBluetoothAddress(final String bluetoothAddress) {
    final String _sql = "SELECT * from NetworkNode WHERE bluetoothMacAddress = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (bluetoothAddress == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, bluetoothAddress);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "nodeId");
      final int _cursorIndexOfBluetoothMacAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "bluetoothMacAddress");
      final int _cursorIndexOfIpAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "ipAddress");
      final int _cursorIndexOfWifiDirectMacAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "wifiDirectMacAddress");
      final int _cursorIndexOfDeviceWifiDirectName = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceWifiDirectName");
      final int _cursorIndexOfEndpointUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "endpointUrl");
      final int _cursorIndexOfLastUpdateTimeStamp = CursorUtil.getColumnIndexOrThrow(_cursor, "lastUpdateTimeStamp");
      final int _cursorIndexOfNetworkServiceLastUpdated = CursorUtil.getColumnIndexOrThrow(_cursor, "networkServiceLastUpdated");
      final int _cursorIndexOfNsdServiceName = CursorUtil.getColumnIndexOrThrow(_cursor, "nsdServiceName");
      final int _cursorIndexOfPort = CursorUtil.getColumnIndexOrThrow(_cursor, "port");
      final int _cursorIndexOfNumFailureCount = CursorUtil.getColumnIndexOrThrow(_cursor, "numFailureCount");
      final int _cursorIndexOfWifiDirectDeviceStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "wifiDirectDeviceStatus");
      final int _cursorIndexOfGroupSsid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupSsid");
      final NetworkNode _result;
      if(_cursor.moveToFirst()) {
        _result = new NetworkNode();
        final long _tmpNodeId;
        _tmpNodeId = _cursor.getLong(_cursorIndexOfNodeId);
        _result.setNodeId(_tmpNodeId);
        final String _tmpBluetoothMacAddress;
        if (_cursor.isNull(_cursorIndexOfBluetoothMacAddress)) {
          _tmpBluetoothMacAddress = null;
        } else {
          _tmpBluetoothMacAddress = _cursor.getString(_cursorIndexOfBluetoothMacAddress);
        }
        _result.setBluetoothMacAddress(_tmpBluetoothMacAddress);
        final String _tmpIpAddress;
        if (_cursor.isNull(_cursorIndexOfIpAddress)) {
          _tmpIpAddress = null;
        } else {
          _tmpIpAddress = _cursor.getString(_cursorIndexOfIpAddress);
        }
        _result.setIpAddress(_tmpIpAddress);
        final String _tmpWifiDirectMacAddress;
        if (_cursor.isNull(_cursorIndexOfWifiDirectMacAddress)) {
          _tmpWifiDirectMacAddress = null;
        } else {
          _tmpWifiDirectMacAddress = _cursor.getString(_cursorIndexOfWifiDirectMacAddress);
        }
        _result.setWifiDirectMacAddress(_tmpWifiDirectMacAddress);
        final String _tmpDeviceWifiDirectName;
        if (_cursor.isNull(_cursorIndexOfDeviceWifiDirectName)) {
          _tmpDeviceWifiDirectName = null;
        } else {
          _tmpDeviceWifiDirectName = _cursor.getString(_cursorIndexOfDeviceWifiDirectName);
        }
        _result.setDeviceWifiDirectName(_tmpDeviceWifiDirectName);
        final String _tmpEndpointUrl;
        if (_cursor.isNull(_cursorIndexOfEndpointUrl)) {
          _tmpEndpointUrl = null;
        } else {
          _tmpEndpointUrl = _cursor.getString(_cursorIndexOfEndpointUrl);
        }
        _result.setEndpointUrl(_tmpEndpointUrl);
        final long _tmpLastUpdateTimeStamp;
        _tmpLastUpdateTimeStamp = _cursor.getLong(_cursorIndexOfLastUpdateTimeStamp);
        _result.setLastUpdateTimeStamp(_tmpLastUpdateTimeStamp);
        final long _tmpNetworkServiceLastUpdated;
        _tmpNetworkServiceLastUpdated = _cursor.getLong(_cursorIndexOfNetworkServiceLastUpdated);
        _result.setNetworkServiceLastUpdated(_tmpNetworkServiceLastUpdated);
        final String _tmpNsdServiceName;
        if (_cursor.isNull(_cursorIndexOfNsdServiceName)) {
          _tmpNsdServiceName = null;
        } else {
          _tmpNsdServiceName = _cursor.getString(_cursorIndexOfNsdServiceName);
        }
        _result.setNsdServiceName(_tmpNsdServiceName);
        final int _tmpPort;
        _tmpPort = _cursor.getInt(_cursorIndexOfPort);
        _result.setPort(_tmpPort);
        final int _tmpNumFailureCount;
        _tmpNumFailureCount = _cursor.getInt(_cursorIndexOfNumFailureCount);
        _result.setNumFailureCount(_tmpNumFailureCount);
        final int _tmpWifiDirectDeviceStatus;
        _tmpWifiDirectDeviceStatus = _cursor.getInt(_cursorIndexOfWifiDirectDeviceStatus);
        _result.setWifiDirectDeviceStatus(_tmpWifiDirectDeviceStatus);
        final String _tmpGroupSsid;
        if (_cursor.isNull(_cursorIndexOfGroupSsid)) {
          _tmpGroupSsid = null;
        } else {
          _tmpGroupSsid = _cursor.getString(_cursorIndexOfGroupSsid);
        }
        _result.setGroupSsid(_tmpGroupSsid);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<NetworkNode> findAllActiveNodes(final long lastUpdatedTime, final int maxNumFailure) {
    final String _sql = "Select * From NetworkNode WHERE lastUpdateTimeStamp >= ? AND numFailureCount <= ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, lastUpdatedTime);
    _argIndex = 2;
    _statement.bindLong(_argIndex, maxNumFailure);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfNodeId = CursorUtil.getColumnIndexOrThrow(_cursor, "nodeId");
      final int _cursorIndexOfBluetoothMacAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "bluetoothMacAddress");
      final int _cursorIndexOfIpAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "ipAddress");
      final int _cursorIndexOfWifiDirectMacAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "wifiDirectMacAddress");
      final int _cursorIndexOfDeviceWifiDirectName = CursorUtil.getColumnIndexOrThrow(_cursor, "deviceWifiDirectName");
      final int _cursorIndexOfEndpointUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "endpointUrl");
      final int _cursorIndexOfLastUpdateTimeStamp = CursorUtil.getColumnIndexOrThrow(_cursor, "lastUpdateTimeStamp");
      final int _cursorIndexOfNetworkServiceLastUpdated = CursorUtil.getColumnIndexOrThrow(_cursor, "networkServiceLastUpdated");
      final int _cursorIndexOfNsdServiceName = CursorUtil.getColumnIndexOrThrow(_cursor, "nsdServiceName");
      final int _cursorIndexOfPort = CursorUtil.getColumnIndexOrThrow(_cursor, "port");
      final int _cursorIndexOfNumFailureCount = CursorUtil.getColumnIndexOrThrow(_cursor, "numFailureCount");
      final int _cursorIndexOfWifiDirectDeviceStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "wifiDirectDeviceStatus");
      final int _cursorIndexOfGroupSsid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupSsid");
      final List<NetworkNode> _result = new ArrayList<NetworkNode>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final NetworkNode _item;
        _item = new NetworkNode();
        final long _tmpNodeId;
        _tmpNodeId = _cursor.getLong(_cursorIndexOfNodeId);
        _item.setNodeId(_tmpNodeId);
        final String _tmpBluetoothMacAddress;
        if (_cursor.isNull(_cursorIndexOfBluetoothMacAddress)) {
          _tmpBluetoothMacAddress = null;
        } else {
          _tmpBluetoothMacAddress = _cursor.getString(_cursorIndexOfBluetoothMacAddress);
        }
        _item.setBluetoothMacAddress(_tmpBluetoothMacAddress);
        final String _tmpIpAddress;
        if (_cursor.isNull(_cursorIndexOfIpAddress)) {
          _tmpIpAddress = null;
        } else {
          _tmpIpAddress = _cursor.getString(_cursorIndexOfIpAddress);
        }
        _item.setIpAddress(_tmpIpAddress);
        final String _tmpWifiDirectMacAddress;
        if (_cursor.isNull(_cursorIndexOfWifiDirectMacAddress)) {
          _tmpWifiDirectMacAddress = null;
        } else {
          _tmpWifiDirectMacAddress = _cursor.getString(_cursorIndexOfWifiDirectMacAddress);
        }
        _item.setWifiDirectMacAddress(_tmpWifiDirectMacAddress);
        final String _tmpDeviceWifiDirectName;
        if (_cursor.isNull(_cursorIndexOfDeviceWifiDirectName)) {
          _tmpDeviceWifiDirectName = null;
        } else {
          _tmpDeviceWifiDirectName = _cursor.getString(_cursorIndexOfDeviceWifiDirectName);
        }
        _item.setDeviceWifiDirectName(_tmpDeviceWifiDirectName);
        final String _tmpEndpointUrl;
        if (_cursor.isNull(_cursorIndexOfEndpointUrl)) {
          _tmpEndpointUrl = null;
        } else {
          _tmpEndpointUrl = _cursor.getString(_cursorIndexOfEndpointUrl);
        }
        _item.setEndpointUrl(_tmpEndpointUrl);
        final long _tmpLastUpdateTimeStamp;
        _tmpLastUpdateTimeStamp = _cursor.getLong(_cursorIndexOfLastUpdateTimeStamp);
        _item.setLastUpdateTimeStamp(_tmpLastUpdateTimeStamp);
        final long _tmpNetworkServiceLastUpdated;
        _tmpNetworkServiceLastUpdated = _cursor.getLong(_cursorIndexOfNetworkServiceLastUpdated);
        _item.setNetworkServiceLastUpdated(_tmpNetworkServiceLastUpdated);
        final String _tmpNsdServiceName;
        if (_cursor.isNull(_cursorIndexOfNsdServiceName)) {
          _tmpNsdServiceName = null;
        } else {
          _tmpNsdServiceName = _cursor.getString(_cursorIndexOfNsdServiceName);
        }
        _item.setNsdServiceName(_tmpNsdServiceName);
        final int _tmpPort;
        _tmpPort = _cursor.getInt(_cursorIndexOfPort);
        _item.setPort(_tmpPort);
        final int _tmpNumFailureCount;
        _tmpNumFailureCount = _cursor.getInt(_cursorIndexOfNumFailureCount);
        _item.setNumFailureCount(_tmpNumFailureCount);
        final int _tmpWifiDirectDeviceStatus;
        _tmpWifiDirectDeviceStatus = _cursor.getInt(_cursorIndexOfWifiDirectDeviceStatus);
        _item.setWifiDirectDeviceStatus(_tmpWifiDirectDeviceStatus);
        final String _tmpGroupSsid;
        if (_cursor.isNull(_cursorIndexOfGroupSsid)) {
          _tmpGroupSsid = null;
        } else {
          _tmpGroupSsid = _cursor.getString(_cursorIndexOfGroupSsid);
        }
        _item.setGroupSsid(_tmpGroupSsid);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public String getEndpointUrlByGroupSsid(final String ssid) {
    final String _sql = "SELECT endpointUrl FROM NetworkNode WHERE groupSsid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (ssid == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, ssid);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final String _result;
      if(_cursor.moveToFirst()) {
        if (_cursor.isNull(0)) {
          _result = null;
        } else {
          _result = _cursor.getString(0);
        }
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
