package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.PersonAuth2;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class PersonAuth2Dao_Impl extends PersonAuth2Dao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PersonAuth2> __insertionAdapterOfPersonAuth2;

  private final EntityInsertionAdapter<PersonAuth2> __insertionAdapterOfPersonAuth2_1;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public PersonAuth2Dao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPersonAuth2 = new EntityInsertionAdapter<PersonAuth2>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `PersonAuth2` (`pauthUid`,`pauthMechanism`,`pauthAuth`,`pauthLcsn`,`pauthPcsn`,`pauthLcb`,`pauthLct`) VALUES (?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PersonAuth2 value) {
        stmt.bindLong(1, value.getPauthUid());
        if (value.getPauthMechanism() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getPauthMechanism());
        }
        if (value.getPauthAuth() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getPauthAuth());
        }
        stmt.bindLong(4, value.getPauthLcsn());
        stmt.bindLong(5, value.getPauthPcsn());
        stmt.bindLong(6, value.getPauthLcb());
        stmt.bindLong(7, value.getPauthLct());
      }
    };
    this.__insertionAdapterOfPersonAuth2_1 = new EntityInsertionAdapter<PersonAuth2>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `PersonAuth2` (`pauthUid`,`pauthMechanism`,`pauthAuth`,`pauthLcsn`,`pauthPcsn`,`pauthLcb`,`pauthLct`) VALUES (?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PersonAuth2 value) {
        stmt.bindLong(1, value.getPauthUid());
        if (value.getPauthMechanism() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getPauthMechanism());
        }
        if (value.getPauthAuth() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getPauthAuth());
        }
        stmt.bindLong(4, value.getPauthLcsn());
        stmt.bindLong(5, value.getPauthPcsn());
        stmt.bindLong(6, value.getPauthLcb());
        stmt.bindLong(7, value.getPauthLct());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO PersonAuth2Replicate(paPk, paDestination)\n"
                + "      SELECT DISTINCT PersonAuth2.pauthUid AS paUid,\n"
                + "             ? AS paDestination\n"
                + "        FROM UserSession\n"
                + "        JOIN PersonGroupMember\n"
                + "             ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "        \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                    AND (ScopedGrant.sgPermissions &\n"
                + "                562949953421312\n"
                + "                \n"
                + "                                                    ) > 0\n"
                + "            JOIN Person \n"
                + "                 ON \n"
                + "                ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberPersonUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )    \n"
                + "        \n"
                + "        \n"
                + "        JOIN PersonAuth2\n"
                + "             ON PersonAuth2.pauthUid = Person.personUid\n"
                + "       WHERE UserSession.usClientNodeId = ?      \n"
                + "         AND PersonAuth2.pauthLct != COALESCE(\n"
                + "             (SELECT paVersionId\n"
                + "                FROM PersonAuth2Replicate\n"
                + "               WHERE paPk = PersonAuth2.pauthUid\n"
                + "                 AND paDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(paPk, paDestination) DO UPDATE\n"
                + "             SET paPending = true\n"
                + "      */       \n"
                + " ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonAuth2Replicate(paPk, paDestination)\n"
                + "  SELECT DISTINCT PersonAuth2.pauthUid AS paUid,\n"
                + "         UserSession.usClientNodeId AS paDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN PersonAuth2\n"
                + "             ON ChangeLog.chTableId = 678\n"
                + "                AND ChangeLog.chEntityPk = PersonAuth2.pauthUid\n"
                + "         JOIN Person\n"
                + "              ON Person.personUid = PersonAuth2.pauthUid\n"
                + "         \n"
                + "            JOIN ScopedGrant \n"
                + "                   ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentClazzUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentPersonUid = Person.personUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberSchoolUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberPersonUid = Person.personUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )\n"
                + "        \n"
                + "                   AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              562949953421312\n"
                + "              \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND PersonAuth2.pauthLct != COALESCE(\n"
                + "         (SELECT paVersionId\n"
                + "            FROM PersonAuth2Replicate\n"
                + "           WHERE paPk = PersonAuth2.pauthUid\n"
                + "             AND paDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(paPk, paDestination) DO UPDATE\n"
                + "     SET paPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertListAsync(final List<PersonAuth2> auths,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPersonAuth2.insert(auths);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object insertAsync(final PersonAuth2 auth, final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfPersonAuth2_1.insertAndReturnId(auth);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findByPersonUid(final long personUid,
      final Continuation<? super PersonAuth2> continuation) {
    final String _sql = "\n"
            + "        SELECT PersonAuth2.*\n"
            + "          FROM PersonAuth2\n"
            + "         WHERE PersonAuth2.pauthUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonAuth2>() {
      @Override
      public PersonAuth2 call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPauthUid = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthUid");
          final int _cursorIndexOfPauthMechanism = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthMechanism");
          final int _cursorIndexOfPauthAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthAuth");
          final int _cursorIndexOfPauthLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthLcsn");
          final int _cursorIndexOfPauthPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthPcsn");
          final int _cursorIndexOfPauthLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthLcb");
          final int _cursorIndexOfPauthLct = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthLct");
          final PersonAuth2 _result;
          if(_cursor.moveToFirst()) {
            _result = new PersonAuth2();
            final long _tmpPauthUid;
            _tmpPauthUid = _cursor.getLong(_cursorIndexOfPauthUid);
            _result.setPauthUid(_tmpPauthUid);
            final String _tmpPauthMechanism;
            if (_cursor.isNull(_cursorIndexOfPauthMechanism)) {
              _tmpPauthMechanism = null;
            } else {
              _tmpPauthMechanism = _cursor.getString(_cursorIndexOfPauthMechanism);
            }
            _result.setPauthMechanism(_tmpPauthMechanism);
            final String _tmpPauthAuth;
            if (_cursor.isNull(_cursorIndexOfPauthAuth)) {
              _tmpPauthAuth = null;
            } else {
              _tmpPauthAuth = _cursor.getString(_cursorIndexOfPauthAuth);
            }
            _result.setPauthAuth(_tmpPauthAuth);
            final long _tmpPauthLcsn;
            _tmpPauthLcsn = _cursor.getLong(_cursorIndexOfPauthLcsn);
            _result.setPauthLcsn(_tmpPauthLcsn);
            final long _tmpPauthPcsn;
            _tmpPauthPcsn = _cursor.getLong(_cursorIndexOfPauthPcsn);
            _result.setPauthPcsn(_tmpPauthPcsn);
            final long _tmpPauthLcb;
            _tmpPauthLcb = _cursor.getLong(_cursorIndexOfPauthLcb);
            _result.setPauthLcb(_tmpPauthLcb);
            final long _tmpPauthLct;
            _tmpPauthLct = _cursor.getLong(_cursorIndexOfPauthLct);
            _result.setPauthLct(_tmpPauthLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUsername(final String username,
      final Continuation<? super PersonAuth2> continuation) {
    final String _sql = "\n"
            + "        SELECT PersonAuth2.*\n"
            + "          FROM PersonAuth2\n"
            + "               JOIN Person ON PersonAuth2.pauthUid = Person.personUid\n"
            + "         WHERE Person.username = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (username == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, username);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonAuth2>() {
      @Override
      public PersonAuth2 call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPauthUid = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthUid");
          final int _cursorIndexOfPauthMechanism = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthMechanism");
          final int _cursorIndexOfPauthAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthAuth");
          final int _cursorIndexOfPauthLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthLcsn");
          final int _cursorIndexOfPauthPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthPcsn");
          final int _cursorIndexOfPauthLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthLcb");
          final int _cursorIndexOfPauthLct = CursorUtil.getColumnIndexOrThrow(_cursor, "pauthLct");
          final PersonAuth2 _result;
          if(_cursor.moveToFirst()) {
            _result = new PersonAuth2();
            final long _tmpPauthUid;
            _tmpPauthUid = _cursor.getLong(_cursorIndexOfPauthUid);
            _result.setPauthUid(_tmpPauthUid);
            final String _tmpPauthMechanism;
            if (_cursor.isNull(_cursorIndexOfPauthMechanism)) {
              _tmpPauthMechanism = null;
            } else {
              _tmpPauthMechanism = _cursor.getString(_cursorIndexOfPauthMechanism);
            }
            _result.setPauthMechanism(_tmpPauthMechanism);
            final String _tmpPauthAuth;
            if (_cursor.isNull(_cursorIndexOfPauthAuth)) {
              _tmpPauthAuth = null;
            } else {
              _tmpPauthAuth = _cursor.getString(_cursorIndexOfPauthAuth);
            }
            _result.setPauthAuth(_tmpPauthAuth);
            final long _tmpPauthLcsn;
            _tmpPauthLcsn = _cursor.getLong(_cursorIndexOfPauthLcsn);
            _result.setPauthLcsn(_tmpPauthLcsn);
            final long _tmpPauthPcsn;
            _tmpPauthPcsn = _cursor.getLong(_cursorIndexOfPauthPcsn);
            _result.setPauthPcsn(_tmpPauthPcsn);
            final long _tmpPauthLcb;
            _tmpPauthLcb = _cursor.getLong(_cursorIndexOfPauthLcb);
            _result.setPauthLcb(_tmpPauthLcb);
            final long _tmpPauthLct;
            _tmpPauthLct = _cursor.getLong(_cursorIndexOfPauthLct);
            _result.setPauthLct(_tmpPauthLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
