package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.PersonGroup;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class PersonGroupDao_Impl extends PersonGroupDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PersonGroup> __insertionAdapterOfPersonGroup;

  private final EntityDeletionOrUpdateAdapter<PersonGroup> __updateAdapterOfPersonGroup;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChangeClazzBased;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNodeClazzBased;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChangePersonBased;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNodePersonBased;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChangeSchoolBased;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNodeSchoolBased;

  public PersonGroupDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPersonGroup = new EntityInsertionAdapter<PersonGroup>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `PersonGroup` (`groupUid`,`groupMasterCsn`,`groupLocalCsn`,`groupLastChangedBy`,`groupLct`,`groupName`,`groupActive`,`personGroupFlag`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PersonGroup value) {
        stmt.bindLong(1, value.getGroupUid());
        stmt.bindLong(2, value.getGroupMasterCsn());
        stmt.bindLong(3, value.getGroupLocalCsn());
        stmt.bindLong(4, value.getGroupLastChangedBy());
        stmt.bindLong(5, value.getGroupLct());
        if (value.getGroupName() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getGroupName());
        }
        final int _tmp = value.getGroupActive() ? 1 : 0;
        stmt.bindLong(7, _tmp);
        stmt.bindLong(8, value.getPersonGroupFlag());
      }
    };
    this.__updateAdapterOfPersonGroup = new EntityDeletionOrUpdateAdapter<PersonGroup>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `PersonGroup` SET `groupUid` = ?,`groupMasterCsn` = ?,`groupLocalCsn` = ?,`groupLastChangedBy` = ?,`groupLct` = ?,`groupName` = ?,`groupActive` = ?,`personGroupFlag` = ? WHERE `groupUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PersonGroup value) {
        stmt.bindLong(1, value.getGroupUid());
        stmt.bindLong(2, value.getGroupMasterCsn());
        stmt.bindLong(3, value.getGroupLocalCsn());
        stmt.bindLong(4, value.getGroupLastChangedBy());
        stmt.bindLong(5, value.getGroupLct());
        if (value.getGroupName() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getGroupName());
        }
        final int _tmp = value.getGroupActive() ? 1 : 0;
        stmt.bindLong(7, _tmp);
        stmt.bindLong(8, value.getPersonGroupFlag());
        stmt.bindLong(9, value.getGroupUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n"
                + "      SELECT DISTINCT \n"
                + "      PersonGroup.groupUid AS pgUid\n"
                + "    ,\n"
                + "             ? AS pgDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember\n"
                + "                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                    AND (ScopedGrant.sgPermissions &\n"
                + "                    64\n"
                + "                    \n"
                + "                                                    ) > 0\n"
                + "            JOIN Person \n"
                + "                 ON \n"
                + "                ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberPersonUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )    \n"
                + "        \n"
                + "        \n"
                + "             JOIN PersonGroupMember PersonsWithPerm_GroupMember\n"
                + "                    ON PersonsWithPerm_GroupMember.groupMemberPersonUid = Person.personUid\n"
                + "             JOIN PersonGroup\n"
                + "                    ON PersonGroup.groupUid = PersonsWithPerm_GroupMember.groupMemberGroupUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND \n"
                + "      PersonGroup.groupLct != COALESCE(\n"
                + "         (SELECT pgVersionId\n"
                + "            FROM PersonGroupReplicate\n"
                + "           WHERE pgPk = PersonGroup.groupUid\n"
                + "             AND pgDestination = UserSession.usClientNodeId), 0)\n"
                + "    \n"
                + "      /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n"
                + "             SET pgPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n"
                + "  SELECT DISTINCT \n"
                + "      PersonGroup.groupUid AS pgUid\n"
                + "     ,\n"
                + "         UserSession.usClientNodeId AS pgDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN PersonGroup\n"
                + "              ON ChangeLog.chTableId = 43\n"
                + "                AND ChangeLog.chEntityPk = PersonGroup.groupUid\n"
                + "         JOIN PersonGroupMember\n"
                + "              ON PersonGroupMember.groupMemberGroupUid = PersonGroup.groupUid\n"
                + "         JOIN Person\n"
                + "              ON PersonGroupMember.groupMemberPersonUid = Person.personUid\n"
                + "         \n"
                + "            JOIN ScopedGrant \n"
                + "                   ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentClazzUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentPersonUid = Person.personUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberSchoolUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberPersonUid = Person.personUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )\n"
                + "        \n"
                + "                   AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              64\n"
                + "              \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "                        \n"
                + "   WHERE \n"
                + "            UserSession.usClientNodeId != (\n"
                + "                 SELECT nodeClientId \n"
                + "                   FROM SyncNode\n"
                + "                  LIMIT 1)\n"
                + "        \n"
                + "     AND \n"
                + "      PersonGroup.groupLct != COALESCE(\n"
                + "         (SELECT pgVersionId\n"
                + "            FROM PersonGroupReplicate\n"
                + "           WHERE pgPk = PersonGroup.groupUid\n"
                + "             AND pgDestination = UserSession.usClientNodeId), 0)\n"
                + "    \n"
                + " /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n"
                + "     SET pgPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChangeClazzBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n"
                + "       SELECT DISTINCT PersonGroup.groupUid AS pgUid,\n"
                + "              UserSession.usClientNodeId AS pgDestination\n"
                + "         FROM ChangeLog\n"
                + "              JOIN PersonGroup\n"
                + "                   ON ChangeLog.chTableId = 43\n"
                + "                      AND ChangeLog.chEntityPk = PersonGroup.groupUid     \n"
                + "         JOIN ScopedGrant ScopedGrantEntity\n"
                + "              ON PersonGroup.groupUid = ScopedGrantEntity.sgGroupUid\n"
                + "         JOIN Clazz \n"
                + "              ON ScopedGrantEntity.sgTableId = 6\n"
                + "                 AND ScopedGrantEntity.sgEntityUid = Clazz.clazzUid\n"
                + "              \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                 2\n"
                + "                 \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "              \n"
                + "        WHERE UserSession.usClientNodeId != (\n"
                + "                SELECT nodeClientId \n"
                + "                  FROM SyncNode\n"
                + "                 LIMIT 1)\n"
                + "          AND PersonGroup.groupLct != COALESCE(\n"
                + "              (SELECT pgVersionId\n"
                + "                 FROM PersonGroupReplicate\n"
                + "                WHERE pgPk = PersonGroup.groupUid\n"
                + "                  AND pgDestination = UserSession.usClientNodeId), 0)\n"
                + "    /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n"
                + "     SET pgPending = true\n"
                + "    */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnNewNodeClazzBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n"
                + "  SELECT DISTINCT \n"
                + "      PersonGroup.groupUid AS pgUid\n"
                + "     ,\n"
                + "         UserSession.usClientNodeId AS pgDestination\n"
                + "    FROM UserSession\n"
                + "         JOIN PersonGroupMember \n"
                + "              ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "         \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              2 \n"
                + "              \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "         JOIN ScopedGrant ScopedGrantEntity\n"
                + "              ON Clazz.clazzUid = ScopedGrantEntity.sgEntityUid\n"
                + "                 AND ScopedGrantEntity.sgTableId = 6\n"
                + "         JOIN PersonGroup\n"
                + "              ON ScopedGrantEntity.sgGroupUid = PersonGroup.groupUid\n"
                + "   WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND PersonGroup.groupLct != COALESCE(\n"
                + "              (SELECT pgVersionId\n"
                + "                 FROM PersonGroupReplicate\n"
                + "                WHERE pgPk = PersonGroup.groupUid\n"
                + "                  AND pgDestination = UserSession.usClientNodeId), 0) \n"
                + "      /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n"
                + "             SET pgPending = true\n"
                + "      */      \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChangePersonBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n"
                + "       SELECT DISTINCT PersonGroup.groupUid AS pgUid,\n"
                + "              UserSession.usClientNodeId AS pgDestination\n"
                + "         FROM ChangeLog\n"
                + "              JOIN PersonGroup\n"
                + "                   ON ChangeLog.chTableId = 43\n"
                + "                      AND ChangeLog.chEntityPk = PersonGroup.groupUid     \n"
                + "         JOIN ScopedGrant ScopedGrantEntity\n"
                + "              ON PersonGroup.groupUid = ScopedGrantEntity.sgGroupUid\n"
                + "         JOIN Person \n"
                + "              ON ScopedGrantEntity.sgTableId = 9\n"
                + "                 AND ScopedGrantEntity.sgEntityUid = Person.personUid\n"
                + "         \n"
                + "            JOIN ScopedGrant \n"
                + "                   ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentClazzUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentPersonUid = Person.personUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberSchoolUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberPersonUid = Person.personUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )\n"
                + "        \n"
                + "                   AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              64\n"
                + "              \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "                        \n"
                + "        WHERE UserSession.usClientNodeId != (\n"
                + "                SELECT nodeClientId \n"
                + "                  FROM SyncNode\n"
                + "                 LIMIT 1)\n"
                + "          AND PersonGroup.groupLct != COALESCE(\n"
                + "              (SELECT pgVersionId\n"
                + "                 FROM PersonGroupReplicate\n"
                + "                WHERE pgPk = PersonGroup.groupUid\n"
                + "                  AND pgDestination = UserSession.usClientNodeId), 0)\n"
                + "    /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n"
                + "     SET pgPending = true\n"
                + "    */                     \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnNewNodePersonBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n"
                + "  SELECT DISTINCT \n"
                + "      PersonGroup.groupUid AS pgUid\n"
                + "     ,\n"
                + "         UserSession.usClientNodeId AS pgDestination\n"
                + "    FROM UserSession\n"
                + "         JOIN PersonGroupMember \n"
                + "              ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                    AND (ScopedGrant.sgPermissions &\n"
                + "              64\n"
                + "              \n"
                + "                                                    ) > 0\n"
                + "            JOIN Person \n"
                + "                 ON \n"
                + "                ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberPersonUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )    \n"
                + "        \n"
                + "        \n"
                + "         JOIN ScopedGrant ScopedGrantEntity\n"
                + "              ON Person.personUid = ScopedGrantEntity.sgEntityUid\n"
                + "                 AND ScopedGrantEntity.sgTableId = 9\n"
                + "         JOIN PersonGroup\n"
                + "              ON ScopedGrantEntity.sgGroupUid = PersonGroup.groupUid\n"
                + "   WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND PersonGroup.groupLct != COALESCE(\n"
                + "              (SELECT pgVersionId\n"
                + "                 FROM PersonGroupReplicate\n"
                + "                WHERE pgPk = PersonGroup.groupUid\n"
                + "                  AND pgDestination = UserSession.usClientNodeId), 0) \n"
                + "      /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n"
                + "             SET pgPending = true\n"
                + "      */      \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChangeSchoolBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n"
                + "       SELECT DISTINCT PersonGroup.groupUid AS pgUid,\n"
                + "              UserSession.usClientNodeId AS pgDestination\n"
                + "         FROM ChangeLog\n"
                + "              JOIN PersonGroup\n"
                + "                   ON ChangeLog.chTableId = 43\n"
                + "                      AND ChangeLog.chEntityPk = PersonGroup.groupUid     \n"
                + "         JOIN ScopedGrant ScopedGrantEntity\n"
                + "              ON PersonGroup.groupUid = ScopedGrantEntity.sgGroupUid\n"
                + "         JOIN School \n"
                + "              ON ScopedGrantEntity.sgTableId = 164\n"
                + "                 AND ScopedGrantEntity.sgEntityUid = School.schoolUid\n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n"
                + "        \n"
                + "                        AND (SCopedGrant.sgPermissions &\n"
                + "        \n"
                + "              536870912\n"
                + "              \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "                      \n"
                + "                        \n"
                + "        WHERE UserSession.usClientNodeId != (\n"
                + "                SELECT nodeClientId \n"
                + "                  FROM SyncNode\n"
                + "                 LIMIT 1)\n"
                + "          AND PersonGroup.groupLct != COALESCE(\n"
                + "              (SELECT pgVersionId\n"
                + "                 FROM PersonGroupReplicate\n"
                + "                WHERE pgPk = PersonGroup.groupUid\n"
                + "                  AND pgDestination = UserSession.usClientNodeId), 0)\n"
                + "    /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n"
                + "     SET pgPending = true\n"
                + "    */                     \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnNewNodeSchoolBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonGroupReplicate(pgPk, pgDestination)\n"
                + "  SELECT DISTINCT \n"
                + "      PersonGroup.groupUid AS pgUid\n"
                + "     ,\n"
                + "         UserSession.usClientNodeId AS pgDestination\n"
                + "    FROM UserSession\n"
                + "         JOIN PersonGroupMember \n"
                + "              ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "         \n"
                + "            JOIN ScopedGrant \n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions &\n"
                + "                 \n"
                + "        \n"
                + "              536870912\n"
                + "              \n"
                + "                    ) > 0\n"
                + "            JOIN School\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n"
                + "        \n"
                + "        \n"
                + "         JOIN ScopedGrant ScopedGrantEntity\n"
                + "              ON School.schoolUid = ScopedGrantEntity.sgEntityUid\n"
                + "                 AND ScopedGrantEntity.sgTableId = 9\n"
                + "         JOIN PersonGroup\n"
                + "              ON ScopedGrantEntity.sgGroupUid = PersonGroup.groupUid\n"
                + "   WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND PersonGroup.groupLct != COALESCE(\n"
                + "              (SELECT pgVersionId\n"
                + "                 FROM PersonGroupReplicate\n"
                + "                WHERE pgPk = PersonGroup.groupUid\n"
                + "                  AND pgDestination = UserSession.usClientNodeId), 0) \n"
                + "      /*psql ON CONFLICT(pgPk, pgDestination) DO UPDATE\n"
                + "             SET pgPending = true\n"
                + "      */      \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final PersonGroup entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfPersonGroup.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final PersonGroup entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfPersonGroup.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends PersonGroup> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfPersonGroup.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends PersonGroup> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfPersonGroup.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final PersonGroup entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfPersonGroup.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final PersonGroup entity,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfPersonGroup.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChangeClazzBased(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChangeClazzBased.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChangeClazzBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNodeClazzBased(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNodeClazzBased.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNodeClazzBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChangePersonBased(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChangePersonBased.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChangePersonBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNodePersonBased(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNodePersonBased.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNodePersonBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChangeSchoolBased(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChangeSchoolBased.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChangeSchoolBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNodeSchoolBased(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNodeSchoolBased.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNodeSchoolBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public PersonGroup findByUid(final long uid) {
    final String _sql = "SELECT * FROM PersonGroup WHERE groupUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupUid");
      final int _cursorIndexOfGroupMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMasterCsn");
      final int _cursorIndexOfGroupLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLocalCsn");
      final int _cursorIndexOfGroupLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLastChangedBy");
      final int _cursorIndexOfGroupLct = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLct");
      final int _cursorIndexOfGroupName = CursorUtil.getColumnIndexOrThrow(_cursor, "groupName");
      final int _cursorIndexOfGroupActive = CursorUtil.getColumnIndexOrThrow(_cursor, "groupActive");
      final int _cursorIndexOfPersonGroupFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupFlag");
      final PersonGroup _result;
      if(_cursor.moveToFirst()) {
        _result = new PersonGroup();
        final long _tmpGroupUid;
        _tmpGroupUid = _cursor.getLong(_cursorIndexOfGroupUid);
        _result.setGroupUid(_tmpGroupUid);
        final long _tmpGroupMasterCsn;
        _tmpGroupMasterCsn = _cursor.getLong(_cursorIndexOfGroupMasterCsn);
        _result.setGroupMasterCsn(_tmpGroupMasterCsn);
        final long _tmpGroupLocalCsn;
        _tmpGroupLocalCsn = _cursor.getLong(_cursorIndexOfGroupLocalCsn);
        _result.setGroupLocalCsn(_tmpGroupLocalCsn);
        final int _tmpGroupLastChangedBy;
        _tmpGroupLastChangedBy = _cursor.getInt(_cursorIndexOfGroupLastChangedBy);
        _result.setGroupLastChangedBy(_tmpGroupLastChangedBy);
        final long _tmpGroupLct;
        _tmpGroupLct = _cursor.getLong(_cursorIndexOfGroupLct);
        _result.setGroupLct(_tmpGroupLct);
        final String _tmpGroupName;
        if (_cursor.isNull(_cursorIndexOfGroupName)) {
          _tmpGroupName = null;
        } else {
          _tmpGroupName = _cursor.getString(_cursorIndexOfGroupName);
        }
        _result.setGroupName(_tmpGroupName);
        final boolean _tmpGroupActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfGroupActive);
        _tmpGroupActive = _tmp != 0;
        _result.setGroupActive(_tmpGroupActive);
        final int _tmpPersonGroupFlag;
        _tmpPersonGroupFlag = _cursor.getInt(_cursorIndexOfPersonGroupFlag);
        _result.setPersonGroupFlag(_tmpPersonGroupFlag);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super PersonGroup> continuation) {
    final String _sql = "SELECT * FROM PersonGroup WHERE groupUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonGroup>() {
      @Override
      public PersonGroup call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupUid");
          final int _cursorIndexOfGroupMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMasterCsn");
          final int _cursorIndexOfGroupLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLocalCsn");
          final int _cursorIndexOfGroupLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLastChangedBy");
          final int _cursorIndexOfGroupLct = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLct");
          final int _cursorIndexOfGroupName = CursorUtil.getColumnIndexOrThrow(_cursor, "groupName");
          final int _cursorIndexOfGroupActive = CursorUtil.getColumnIndexOrThrow(_cursor, "groupActive");
          final int _cursorIndexOfPersonGroupFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupFlag");
          final PersonGroup _result;
          if(_cursor.moveToFirst()) {
            _result = new PersonGroup();
            final long _tmpGroupUid;
            _tmpGroupUid = _cursor.getLong(_cursorIndexOfGroupUid);
            _result.setGroupUid(_tmpGroupUid);
            final long _tmpGroupMasterCsn;
            _tmpGroupMasterCsn = _cursor.getLong(_cursorIndexOfGroupMasterCsn);
            _result.setGroupMasterCsn(_tmpGroupMasterCsn);
            final long _tmpGroupLocalCsn;
            _tmpGroupLocalCsn = _cursor.getLong(_cursorIndexOfGroupLocalCsn);
            _result.setGroupLocalCsn(_tmpGroupLocalCsn);
            final int _tmpGroupLastChangedBy;
            _tmpGroupLastChangedBy = _cursor.getInt(_cursorIndexOfGroupLastChangedBy);
            _result.setGroupLastChangedBy(_tmpGroupLastChangedBy);
            final long _tmpGroupLct;
            _tmpGroupLct = _cursor.getLong(_cursorIndexOfGroupLct);
            _result.setGroupLct(_tmpGroupLct);
            final String _tmpGroupName;
            if (_cursor.isNull(_cursorIndexOfGroupName)) {
              _tmpGroupName = null;
            } else {
              _tmpGroupName = _cursor.getString(_cursorIndexOfGroupName);
            }
            _result.setGroupName(_tmpGroupName);
            final boolean _tmpGroupActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfGroupActive);
            _tmpGroupActive = _tmp != 0;
            _result.setGroupActive(_tmpGroupActive);
            final int _tmpPersonGroupFlag;
            _tmpPersonGroupFlag = _cursor.getInt(_cursorIndexOfPersonGroupFlag);
            _result.setPersonGroupFlag(_tmpPersonGroupFlag);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<PersonGroup> findByUidLive(final long uid) {
    final String _sql = "SELECT * FROM PersonGroup WHERE groupUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"PersonGroup"}, false, new Callable<PersonGroup>() {
      @Override
      public PersonGroup call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupUid");
          final int _cursorIndexOfGroupMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMasterCsn");
          final int _cursorIndexOfGroupLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLocalCsn");
          final int _cursorIndexOfGroupLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLastChangedBy");
          final int _cursorIndexOfGroupLct = CursorUtil.getColumnIndexOrThrow(_cursor, "groupLct");
          final int _cursorIndexOfGroupName = CursorUtil.getColumnIndexOrThrow(_cursor, "groupName");
          final int _cursorIndexOfGroupActive = CursorUtil.getColumnIndexOrThrow(_cursor, "groupActive");
          final int _cursorIndexOfPersonGroupFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupFlag");
          final PersonGroup _result;
          if(_cursor.moveToFirst()) {
            _result = new PersonGroup();
            final long _tmpGroupUid;
            _tmpGroupUid = _cursor.getLong(_cursorIndexOfGroupUid);
            _result.setGroupUid(_tmpGroupUid);
            final long _tmpGroupMasterCsn;
            _tmpGroupMasterCsn = _cursor.getLong(_cursorIndexOfGroupMasterCsn);
            _result.setGroupMasterCsn(_tmpGroupMasterCsn);
            final long _tmpGroupLocalCsn;
            _tmpGroupLocalCsn = _cursor.getLong(_cursorIndexOfGroupLocalCsn);
            _result.setGroupLocalCsn(_tmpGroupLocalCsn);
            final int _tmpGroupLastChangedBy;
            _tmpGroupLastChangedBy = _cursor.getInt(_cursorIndexOfGroupLastChangedBy);
            _result.setGroupLastChangedBy(_tmpGroupLastChangedBy);
            final long _tmpGroupLct;
            _tmpGroupLct = _cursor.getLong(_cursorIndexOfGroupLct);
            _result.setGroupLct(_tmpGroupLct);
            final String _tmpGroupName;
            if (_cursor.isNull(_cursorIndexOfGroupName)) {
              _tmpGroupName = null;
            } else {
              _tmpGroupName = _cursor.getString(_cursorIndexOfGroupName);
            }
            _result.setGroupName(_tmpGroupName);
            final boolean _tmpGroupActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfGroupActive);
            _tmpGroupActive = _tmp != 0;
            _result.setGroupActive(_tmpGroupActive);
            final int _tmpPersonGroupFlag;
            _tmpPersonGroupFlag = _cursor.getInt(_cursorIndexOfPersonGroupFlag);
            _result.setPersonGroupFlag(_tmpPersonGroupFlag);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findNameByGroupUid(final long groupUid,
      final Continuation<? super String> continuation) {
    final String _sql = "\n"
            + "        Select CASE\n"
            + "               WHEN Person.firstNames IS NOT NULL THEN Person.firstNames\n"
            + "               ELSE PersonGroup.groupName \n"
            + "               END AS name\n"
            + "          FROM PersonGroup\n"
            + "               LEFT JOIN Person\n"
            + "                         ON Person.personGroupUid = PersonGroup.groupUid\n"
            + "         WHERE PersonGroup.groupUid = ?\n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, groupUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<String>() {
      @Override
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if(_cursor.moveToFirst()) {
            final String _tmp;
            if (_cursor.isNull(0)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(0);
            }
            _result = _tmp;
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
