package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ParentEnrolmentRequired;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonParentJoin;
import com.ustadmobile.lib.db.entities.PersonParentJoinWithMinorPerson;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class PersonParentJoinDao_Impl extends PersonParentJoinDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PersonParentJoin> __insertionAdapterOfPersonParentJoin;

  private final EntityDeletionOrUpdateAdapter<PersonParentJoin> __updateAdapterOfPersonParentJoin;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public PersonParentJoinDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPersonParentJoin = new EntityInsertionAdapter<PersonParentJoin>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `PersonParentJoin` (`ppjUid`,`ppjPcsn`,`ppjLcsn`,`ppjLcb`,`ppjLct`,`ppjParentPersonUid`,`ppjMinorPersonUid`,`ppjRelationship`,`ppjEmail`,`ppjPhone`,`ppjInactive`,`ppjStatus`,`ppjApprovalTiemstamp`,`ppjApprovalIpAddr`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PersonParentJoin value) {
        stmt.bindLong(1, value.getPpjUid());
        stmt.bindLong(2, value.getPpjPcsn());
        stmt.bindLong(3, value.getPpjLcsn());
        stmt.bindLong(4, value.getPpjLcb());
        stmt.bindLong(5, value.getPpjLct());
        stmt.bindLong(6, value.getPpjParentPersonUid());
        stmt.bindLong(7, value.getPpjMinorPersonUid());
        stmt.bindLong(8, value.getPpjRelationship());
        if (value.getPpjEmail() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getPpjEmail());
        }
        if (value.getPpjPhone() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getPpjPhone());
        }
        final int _tmp = value.getPpjInactive() ? 1 : 0;
        stmt.bindLong(11, _tmp);
        stmt.bindLong(12, value.getPpjStatus());
        stmt.bindLong(13, value.getPpjApprovalTiemstamp());
        if (value.getPpjApprovalIpAddr() == null) {
          stmt.bindNull(14);
        } else {
          stmt.bindString(14, value.getPpjApprovalIpAddr());
        }
      }
    };
    this.__updateAdapterOfPersonParentJoin = new EntityDeletionOrUpdateAdapter<PersonParentJoin>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `PersonParentJoin` SET `ppjUid` = ?,`ppjPcsn` = ?,`ppjLcsn` = ?,`ppjLcb` = ?,`ppjLct` = ?,`ppjParentPersonUid` = ?,`ppjMinorPersonUid` = ?,`ppjRelationship` = ?,`ppjEmail` = ?,`ppjPhone` = ?,`ppjInactive` = ?,`ppjStatus` = ?,`ppjApprovalTiemstamp` = ?,`ppjApprovalIpAddr` = ? WHERE `ppjUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PersonParentJoin value) {
        stmt.bindLong(1, value.getPpjUid());
        stmt.bindLong(2, value.getPpjPcsn());
        stmt.bindLong(3, value.getPpjLcsn());
        stmt.bindLong(4, value.getPpjLcb());
        stmt.bindLong(5, value.getPpjLct());
        stmt.bindLong(6, value.getPpjParentPersonUid());
        stmt.bindLong(7, value.getPpjMinorPersonUid());
        stmt.bindLong(8, value.getPpjRelationship());
        if (value.getPpjEmail() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getPpjEmail());
        }
        if (value.getPpjPhone() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getPpjPhone());
        }
        final int _tmp = value.getPpjInactive() ? 1 : 0;
        stmt.bindLong(11, _tmp);
        stmt.bindLong(12, value.getPpjStatus());
        stmt.bindLong(13, value.getPpjApprovalTiemstamp());
        if (value.getPpjApprovalIpAddr() == null) {
          stmt.bindNull(14);
        } else {
          stmt.bindString(14, value.getPpjApprovalIpAddr());
        }
        stmt.bindLong(15, value.getPpjUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO PersonParentJoinReplicate(ppjPk, ppjDestination)\n"
                + "      SELECT DISTINCT PersonParentJoin.ppjUid AS ppjPk,\n"
                + "             ? AS ppjDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember\n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                    AND (ScopedGrant.sgPermissions &\n"
                + "                  64\n"
                + "                  \n"
                + "                                                    ) > 0\n"
                + "            JOIN Person \n"
                + "                 ON \n"
                + "                ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberPersonUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )    \n"
                + "        \n"
                + "        \n"
                + "             JOIN PersonParentJoin\n"
                + "                  ON PersonParentJoin.ppjParentPersonUid = Person.personUid       \n"
                + "       WHERE UserSession.usStatus = 1\n"
                + "         AND PersonParentJoin.ppjLct != COALESCE(\n"
                + "             (SELECT ppjVersionId\n"
                + "                FROM PersonParentJoinReplicate\n"
                + "               WHERE ppjPk = PersonParentJoin.ppjUid\n"
                + "                 AND ppjDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(ppjPk, ppjDestination) DO UPDATE\n"
                + "             SET ppjPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonParentJoinReplicate(ppjPk, ppjDestination)\n"
                + "  SELECT DISTINCT PersonParentJoin.ppjUid AS ppjUid,\n"
                + "         UserSession.usClientNodeId AS ppjDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN PersonParentJoin\n"
                + "             ON ChangeLog.chTableId = 512\n"
                + "                AND ChangeLog.chEntityPk = PersonParentJoin.ppjUid\n"
                + "         JOIN Person\n"
                + "              ON PersonParentJoin.ppjParentPersonUid = Person.personUid\n"
                + "         \n"
                + "            JOIN ScopedGrant \n"
                + "                   ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentClazzUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentPersonUid = Person.personUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberSchoolUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberPersonUid = Person.personUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )\n"
                + "        \n"
                + "                   AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              64\n"
                + "              \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "               \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId\n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND PersonParentJoin.ppjLct != COALESCE(\n"
                + "         (SELECT ppjVersionId\n"
                + "            FROM PersonParentJoinReplicate\n"
                + "           WHERE ppjPk = PersonParentJoin.ppjUid\n"
                + "             AND ppjDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(ppjPk, ppjDestination) DO UPDATE\n"
                + "     SET ppjPending = true\n"
                + "  */\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertAsync(final PersonParentJoin entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfPersonParentJoin.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object updateAsync(final PersonParentJoin personParentJoin,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfPersonParentJoin.handle(personParentJoin);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidWithMinorAsync(final long uid,
      final Continuation<? super PersonParentJoinWithMinorPerson> continuation) {
    final String _sql = "\n"
            + "        SELECT PersonParentJoin.*, Person.*\n"
            + "          FROM PersonParentJoin\n"
            + "     LEFT JOIN Person ON Person.personUid = PersonParentJoin.ppjMinorPersonUid    \n"
            + "         WHERE PersonParentJoin.ppjUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonParentJoinWithMinorPerson>() {
      @Override
      public PersonParentJoinWithMinorPerson call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPpjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjUid");
          final int _cursorIndexOfPpjPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPcsn");
          final int _cursorIndexOfPpjLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcsn");
          final int _cursorIndexOfPpjLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcb");
          final int _cursorIndexOfPpjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLct");
          final int _cursorIndexOfPpjParentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjParentPersonUid");
          final int _cursorIndexOfPpjMinorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjMinorPersonUid");
          final int _cursorIndexOfPpjRelationship = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjRelationship");
          final int _cursorIndexOfPpjEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjEmail");
          final int _cursorIndexOfPpjPhone = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPhone");
          final int _cursorIndexOfPpjInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjInactive");
          final int _cursorIndexOfPpjStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjStatus");
          final int _cursorIndexOfPpjApprovalTiemstamp = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalTiemstamp");
          final int _cursorIndexOfPpjApprovalIpAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalIpAddr");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final PersonParentJoinWithMinorPerson _result;
          if(_cursor.moveToFirst()) {
            final Person _tmpMinorPerson;
            if (! (_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType))) {
              _tmpMinorPerson = new Person();
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              _tmpMinorPerson.setPersonUid(_tmpPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              _tmpMinorPerson.setUsername(_tmpUsername);
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              _tmpMinorPerson.setFirstNames(_tmpFirstNames);
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              _tmpMinorPerson.setLastName(_tmpLastName);
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              _tmpMinorPerson.setEmailAddr(_tmpEmailAddr);
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              _tmpMinorPerson.setPhoneNum(_tmpPhoneNum);
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              _tmpMinorPerson.setGender(_tmpGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              _tmpMinorPerson.setActive(_tmpActive);
              final boolean _tmpAdmin;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_1 != 0;
              _tmpMinorPerson.setAdmin(_tmpAdmin);
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              _tmpMinorPerson.setPersonNotes(_tmpPersonNotes);
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              _tmpMinorPerson.setFatherName(_tmpFatherName);
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              _tmpMinorPerson.setFatherNumber(_tmpFatherNumber);
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              _tmpMinorPerson.setMotherName(_tmpMotherName);
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpMinorPerson.setMotherNum(_tmpMotherNum);
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              _tmpMinorPerson.setDateOfBirth(_tmpDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              _tmpMinorPerson.setPersonAddress(_tmpPersonAddress);
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              _tmpMinorPerson.setPersonOrgId(_tmpPersonOrgId);
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              _tmpMinorPerson.setPersonGroupUid(_tmpPersonGroupUid);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              _tmpMinorPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              _tmpMinorPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              _tmpMinorPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              _tmpMinorPerson.setPersonLct(_tmpPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              _tmpMinorPerson.setPersonCountry(_tmpPersonCountry);
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              _tmpMinorPerson.setPersonType(_tmpPersonType);
            }  else  {
              _tmpMinorPerson = null;
            }
            _result = new PersonParentJoinWithMinorPerson();
            final long _tmpPpjUid;
            _tmpPpjUid = _cursor.getLong(_cursorIndexOfPpjUid);
            _result.setPpjUid(_tmpPpjUid);
            final long _tmpPpjPcsn;
            _tmpPpjPcsn = _cursor.getLong(_cursorIndexOfPpjPcsn);
            _result.setPpjPcsn(_tmpPpjPcsn);
            final long _tmpPpjLcsn;
            _tmpPpjLcsn = _cursor.getLong(_cursorIndexOfPpjLcsn);
            _result.setPpjLcsn(_tmpPpjLcsn);
            final int _tmpPpjLcb;
            _tmpPpjLcb = _cursor.getInt(_cursorIndexOfPpjLcb);
            _result.setPpjLcb(_tmpPpjLcb);
            final long _tmpPpjLct;
            _tmpPpjLct = _cursor.getLong(_cursorIndexOfPpjLct);
            _result.setPpjLct(_tmpPpjLct);
            final long _tmpPpjParentPersonUid;
            _tmpPpjParentPersonUid = _cursor.getLong(_cursorIndexOfPpjParentPersonUid);
            _result.setPpjParentPersonUid(_tmpPpjParentPersonUid);
            final long _tmpPpjMinorPersonUid;
            _tmpPpjMinorPersonUid = _cursor.getLong(_cursorIndexOfPpjMinorPersonUid);
            _result.setPpjMinorPersonUid(_tmpPpjMinorPersonUid);
            final int _tmpPpjRelationship;
            _tmpPpjRelationship = _cursor.getInt(_cursorIndexOfPpjRelationship);
            _result.setPpjRelationship(_tmpPpjRelationship);
            final String _tmpPpjEmail;
            if (_cursor.isNull(_cursorIndexOfPpjEmail)) {
              _tmpPpjEmail = null;
            } else {
              _tmpPpjEmail = _cursor.getString(_cursorIndexOfPpjEmail);
            }
            _result.setPpjEmail(_tmpPpjEmail);
            final String _tmpPpjPhone;
            if (_cursor.isNull(_cursorIndexOfPpjPhone)) {
              _tmpPpjPhone = null;
            } else {
              _tmpPpjPhone = _cursor.getString(_cursorIndexOfPpjPhone);
            }
            _result.setPpjPhone(_tmpPpjPhone);
            final boolean _tmpPpjInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfPpjInactive);
            _tmpPpjInactive = _tmp_2 != 0;
            _result.setPpjInactive(_tmpPpjInactive);
            final int _tmpPpjStatus;
            _tmpPpjStatus = _cursor.getInt(_cursorIndexOfPpjStatus);
            _result.setPpjStatus(_tmpPpjStatus);
            final long _tmpPpjApprovalTiemstamp;
            _tmpPpjApprovalTiemstamp = _cursor.getLong(_cursorIndexOfPpjApprovalTiemstamp);
            _result.setPpjApprovalTiemstamp(_tmpPpjApprovalTiemstamp);
            final String _tmpPpjApprovalIpAddr;
            if (_cursor.isNull(_cursorIndexOfPpjApprovalIpAddr)) {
              _tmpPpjApprovalIpAddr = null;
            } else {
              _tmpPpjApprovalIpAddr = _cursor.getString(_cursorIndexOfPpjApprovalIpAddr);
            }
            _result.setPpjApprovalIpAddr(_tmpPpjApprovalIpAddr);
            _result.setMinorPerson(_tmpMinorPerson);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidWithMinorAsyncFromWeb(final long uid,
      final Continuation<? super PersonParentJoinWithMinorPerson> continuation) {
    final String _sql = "\n"
            + "        SELECT PersonParentJoin.*, Person.*\n"
            + "          FROM PersonParentJoin\n"
            + "     LEFT JOIN Person ON Person.personUid = PersonParentJoin.ppjMinorPersonUid    \n"
            + "         WHERE PersonParentJoin.ppjUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonParentJoinWithMinorPerson>() {
      @Override
      public PersonParentJoinWithMinorPerson call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPpjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjUid");
          final int _cursorIndexOfPpjPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPcsn");
          final int _cursorIndexOfPpjLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcsn");
          final int _cursorIndexOfPpjLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcb");
          final int _cursorIndexOfPpjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLct");
          final int _cursorIndexOfPpjParentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjParentPersonUid");
          final int _cursorIndexOfPpjMinorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjMinorPersonUid");
          final int _cursorIndexOfPpjRelationship = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjRelationship");
          final int _cursorIndexOfPpjEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjEmail");
          final int _cursorIndexOfPpjPhone = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPhone");
          final int _cursorIndexOfPpjInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjInactive");
          final int _cursorIndexOfPpjStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjStatus");
          final int _cursorIndexOfPpjApprovalTiemstamp = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalTiemstamp");
          final int _cursorIndexOfPpjApprovalIpAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalIpAddr");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final PersonParentJoinWithMinorPerson _result;
          if(_cursor.moveToFirst()) {
            final Person _tmpMinorPerson;
            if (! (_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType))) {
              _tmpMinorPerson = new Person();
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              _tmpMinorPerson.setPersonUid(_tmpPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              _tmpMinorPerson.setUsername(_tmpUsername);
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              _tmpMinorPerson.setFirstNames(_tmpFirstNames);
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              _tmpMinorPerson.setLastName(_tmpLastName);
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              _tmpMinorPerson.setEmailAddr(_tmpEmailAddr);
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              _tmpMinorPerson.setPhoneNum(_tmpPhoneNum);
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              _tmpMinorPerson.setGender(_tmpGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              _tmpMinorPerson.setActive(_tmpActive);
              final boolean _tmpAdmin;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_1 != 0;
              _tmpMinorPerson.setAdmin(_tmpAdmin);
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              _tmpMinorPerson.setPersonNotes(_tmpPersonNotes);
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              _tmpMinorPerson.setFatherName(_tmpFatherName);
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              _tmpMinorPerson.setFatherNumber(_tmpFatherNumber);
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              _tmpMinorPerson.setMotherName(_tmpMotherName);
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpMinorPerson.setMotherNum(_tmpMotherNum);
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              _tmpMinorPerson.setDateOfBirth(_tmpDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              _tmpMinorPerson.setPersonAddress(_tmpPersonAddress);
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              _tmpMinorPerson.setPersonOrgId(_tmpPersonOrgId);
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              _tmpMinorPerson.setPersonGroupUid(_tmpPersonGroupUid);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              _tmpMinorPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              _tmpMinorPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              _tmpMinorPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              _tmpMinorPerson.setPersonLct(_tmpPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              _tmpMinorPerson.setPersonCountry(_tmpPersonCountry);
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              _tmpMinorPerson.setPersonType(_tmpPersonType);
            }  else  {
              _tmpMinorPerson = null;
            }
            _result = new PersonParentJoinWithMinorPerson();
            final long _tmpPpjUid;
            _tmpPpjUid = _cursor.getLong(_cursorIndexOfPpjUid);
            _result.setPpjUid(_tmpPpjUid);
            final long _tmpPpjPcsn;
            _tmpPpjPcsn = _cursor.getLong(_cursorIndexOfPpjPcsn);
            _result.setPpjPcsn(_tmpPpjPcsn);
            final long _tmpPpjLcsn;
            _tmpPpjLcsn = _cursor.getLong(_cursorIndexOfPpjLcsn);
            _result.setPpjLcsn(_tmpPpjLcsn);
            final int _tmpPpjLcb;
            _tmpPpjLcb = _cursor.getInt(_cursorIndexOfPpjLcb);
            _result.setPpjLcb(_tmpPpjLcb);
            final long _tmpPpjLct;
            _tmpPpjLct = _cursor.getLong(_cursorIndexOfPpjLct);
            _result.setPpjLct(_tmpPpjLct);
            final long _tmpPpjParentPersonUid;
            _tmpPpjParentPersonUid = _cursor.getLong(_cursorIndexOfPpjParentPersonUid);
            _result.setPpjParentPersonUid(_tmpPpjParentPersonUid);
            final long _tmpPpjMinorPersonUid;
            _tmpPpjMinorPersonUid = _cursor.getLong(_cursorIndexOfPpjMinorPersonUid);
            _result.setPpjMinorPersonUid(_tmpPpjMinorPersonUid);
            final int _tmpPpjRelationship;
            _tmpPpjRelationship = _cursor.getInt(_cursorIndexOfPpjRelationship);
            _result.setPpjRelationship(_tmpPpjRelationship);
            final String _tmpPpjEmail;
            if (_cursor.isNull(_cursorIndexOfPpjEmail)) {
              _tmpPpjEmail = null;
            } else {
              _tmpPpjEmail = _cursor.getString(_cursorIndexOfPpjEmail);
            }
            _result.setPpjEmail(_tmpPpjEmail);
            final String _tmpPpjPhone;
            if (_cursor.isNull(_cursorIndexOfPpjPhone)) {
              _tmpPpjPhone = null;
            } else {
              _tmpPpjPhone = _cursor.getString(_cursorIndexOfPpjPhone);
            }
            _result.setPpjPhone(_tmpPpjPhone);
            final boolean _tmpPpjInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfPpjInactive);
            _tmpPpjInactive = _tmp_2 != 0;
            _result.setPpjInactive(_tmpPpjInactive);
            final int _tmpPpjStatus;
            _tmpPpjStatus = _cursor.getInt(_cursorIndexOfPpjStatus);
            _result.setPpjStatus(_tmpPpjStatus);
            final long _tmpPpjApprovalTiemstamp;
            _tmpPpjApprovalTiemstamp = _cursor.getLong(_cursorIndexOfPpjApprovalTiemstamp);
            _result.setPpjApprovalTiemstamp(_tmpPpjApprovalTiemstamp);
            final String _tmpPpjApprovalIpAddr;
            if (_cursor.isNull(_cursorIndexOfPpjApprovalIpAddr)) {
              _tmpPpjApprovalIpAddr = null;
            } else {
              _tmpPpjApprovalIpAddr = _cursor.getString(_cursorIndexOfPpjApprovalIpAddr);
            }
            _result.setPpjApprovalIpAddr(_tmpPpjApprovalIpAddr);
            _result.setMinorPerson(_tmpMinorPerson);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByMinorPersonUid(final long minorPersonUid,
      final Continuation<? super List<? extends PersonParentJoin>> continuation) {
    final String _sql = "\n"
            + "        SELECT PersonParentJoin.*\n"
            + "          FROM PersonParentJoin\n"
            + "         WHERE ppjMinorPersonUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, minorPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PersonParentJoin>>() {
      @Override
      public List<PersonParentJoin> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPpjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjUid");
          final int _cursorIndexOfPpjPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPcsn");
          final int _cursorIndexOfPpjLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcsn");
          final int _cursorIndexOfPpjLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLcb");
          final int _cursorIndexOfPpjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjLct");
          final int _cursorIndexOfPpjParentPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjParentPersonUid");
          final int _cursorIndexOfPpjMinorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjMinorPersonUid");
          final int _cursorIndexOfPpjRelationship = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjRelationship");
          final int _cursorIndexOfPpjEmail = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjEmail");
          final int _cursorIndexOfPpjPhone = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjPhone");
          final int _cursorIndexOfPpjInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjInactive");
          final int _cursorIndexOfPpjStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjStatus");
          final int _cursorIndexOfPpjApprovalTiemstamp = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalTiemstamp");
          final int _cursorIndexOfPpjApprovalIpAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "ppjApprovalIpAddr");
          final List<PersonParentJoin> _result = new ArrayList<PersonParentJoin>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final PersonParentJoin _item;
            _item = new PersonParentJoin();
            final long _tmpPpjUid;
            _tmpPpjUid = _cursor.getLong(_cursorIndexOfPpjUid);
            _item.setPpjUid(_tmpPpjUid);
            final long _tmpPpjPcsn;
            _tmpPpjPcsn = _cursor.getLong(_cursorIndexOfPpjPcsn);
            _item.setPpjPcsn(_tmpPpjPcsn);
            final long _tmpPpjLcsn;
            _tmpPpjLcsn = _cursor.getLong(_cursorIndexOfPpjLcsn);
            _item.setPpjLcsn(_tmpPpjLcsn);
            final int _tmpPpjLcb;
            _tmpPpjLcb = _cursor.getInt(_cursorIndexOfPpjLcb);
            _item.setPpjLcb(_tmpPpjLcb);
            final long _tmpPpjLct;
            _tmpPpjLct = _cursor.getLong(_cursorIndexOfPpjLct);
            _item.setPpjLct(_tmpPpjLct);
            final long _tmpPpjParentPersonUid;
            _tmpPpjParentPersonUid = _cursor.getLong(_cursorIndexOfPpjParentPersonUid);
            _item.setPpjParentPersonUid(_tmpPpjParentPersonUid);
            final long _tmpPpjMinorPersonUid;
            _tmpPpjMinorPersonUid = _cursor.getLong(_cursorIndexOfPpjMinorPersonUid);
            _item.setPpjMinorPersonUid(_tmpPpjMinorPersonUid);
            final int _tmpPpjRelationship;
            _tmpPpjRelationship = _cursor.getInt(_cursorIndexOfPpjRelationship);
            _item.setPpjRelationship(_tmpPpjRelationship);
            final String _tmpPpjEmail;
            if (_cursor.isNull(_cursorIndexOfPpjEmail)) {
              _tmpPpjEmail = null;
            } else {
              _tmpPpjEmail = _cursor.getString(_cursorIndexOfPpjEmail);
            }
            _item.setPpjEmail(_tmpPpjEmail);
            final String _tmpPpjPhone;
            if (_cursor.isNull(_cursorIndexOfPpjPhone)) {
              _tmpPpjPhone = null;
            } else {
              _tmpPpjPhone = _cursor.getString(_cursorIndexOfPpjPhone);
            }
            _item.setPpjPhone(_tmpPpjPhone);
            final boolean _tmpPpjInactive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfPpjInactive);
            _tmpPpjInactive = _tmp != 0;
            _item.setPpjInactive(_tmpPpjInactive);
            final int _tmpPpjStatus;
            _tmpPpjStatus = _cursor.getInt(_cursorIndexOfPpjStatus);
            _item.setPpjStatus(_tmpPpjStatus);
            final long _tmpPpjApprovalTiemstamp;
            _tmpPpjApprovalTiemstamp = _cursor.getLong(_cursorIndexOfPpjApprovalTiemstamp);
            _item.setPpjApprovalTiemstamp(_tmpPpjApprovalTiemstamp);
            final String _tmpPpjApprovalIpAddr;
            if (_cursor.isNull(_cursorIndexOfPpjApprovalIpAddr)) {
              _tmpPpjApprovalIpAddr = null;
            } else {
              _tmpPpjApprovalIpAddr = _cursor.getString(_cursorIndexOfPpjApprovalIpAddr);
            }
            _item.setPpjApprovalIpAddr(_tmpPpjApprovalIpAddr);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByMinorPersonUidWhereParentNotEnrolledInClazz(final long minorPersonUid,
      final long clazzUidFilter,
      final Continuation<? super List<ParentEnrolmentRequired>> continuation) {
    final String _sql = "\n"
            + "        SELECT PersonParentJoin.ppjParentPersonUid AS parentPersonUid,\n"
            + "               ChildEnrolment.clazzEnrolmentClazzUid AS clazzUid\n"
            + "          FROM PersonParentJoin\n"
            + "               JOIN ClazzEnrolment ChildEnrolment \n"
            + "                    ON ChildEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                   AND (? = 0 OR ChildEnrolment.clazzEnrolmentClazzUid = ?)\n"
            + "         WHERE PersonParentJoin.ppjMinorPersonUid = ?\n"
            + "           AND PersonParentJoin.ppjParentPersonUid != 0\n"
            + "           AND NOT EXISTS(\n"
            + "               SELECT clazzEnrolmentUid \n"
            + "                 FROM ClazzEnrolment\n"
            + "                WHERE ClazzEnrolment.clazzEnrolmentPersonUid = PersonParentJoin.ppjParentPersonUid\n"
            + "                  AND ClazzEnrolment.clazzEnrolmentClazzUid = ChildEnrolment.clazzEnrolmentClazzUid\n"
            + "                  AND ClazzEnrolment.clazzEnrolmentRole = 1003\n"
            + "                  AND CAST(ClazzEnrolment.clazzEnrolmentActive AS INTEGER) = 1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, minorPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUidFilter);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzUidFilter);
    _argIndex = 4;
    _statement.bindLong(_argIndex, minorPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ParentEnrolmentRequired>>() {
      @Override
      public List<ParentEnrolmentRequired> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfParentPersonUid = 0;
          final int _cursorIndexOfClazzUid = 1;
          final List<ParentEnrolmentRequired> _result = new ArrayList<ParentEnrolmentRequired>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ParentEnrolmentRequired _item;
            final long _tmpParentPersonUid;
            _tmpParentPersonUid = _cursor.getLong(_cursorIndexOfParentPersonUid);
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _item = new ParentEnrolmentRequired(_tmpParentPersonUid,_tmpClazzUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object isParentOf(final long userPersonUid, final long minorPersonUid,
      final Continuation<? super Boolean> continuation) {
    final String _sql = "\n"
            + "        SELECT EXISTS(\n"
            + "               SELECT ppjUid\n"
            + "                 FROM PersonParentJoin\n"
            + "                WHERE ppjMinorPersonUid = ?\n"
            + "                      AND ppjParentPersonUid = ?\n"
            + "                      AND CAST(ppjInactive AS INTEGER) = 0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, minorPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, userPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object isMinorApproved(final long minorPersonUid,
      final Continuation<? super Boolean> continuation) {
    final String _sql = "\n"
            + "        SELECT EXISTS(\n"
            + "               SELECT ppjUid\n"
            + "                 FROM PersonParentJoin\n"
            + "                WHERE ppjMinorPersonUid = ?\n"
            + "                  AND CAST(ppjInactive AS INTEGER) = 0\n"
            + "                  AND ppjStatus = 1)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, minorPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
