package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.HolidayCalendar;
import com.ustadmobile.lib.db.entities.School;
import com.ustadmobile.lib.db.entities.SchoolWithHolidayCalendar;
import com.ustadmobile.lib.db.entities.SchoolWithMemberCountAndLocation;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class SchoolDao_Impl extends SchoolDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<School> __insertionAdapterOfSchool;

  private final EntityDeletionOrUpdateAdapter<School> __updateAdapterOfSchool;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public SchoolDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfSchool = new EntityInsertionAdapter<School>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `School` (`schoolUid`,`schoolName`,`schoolDesc`,`schoolAddress`,`schoolActive`,`schoolPhoneNumber`,`schoolGender`,`schoolHolidayCalendarUid`,`schoolFeatures`,`schoolLocationLong`,`schoolLocationLatt`,`schoolEmailAddress`,`schoolTeachersPersonGroupUid`,`schoolStudentsPersonGroupUid`,`schoolPendingStudentsPersonGroupUid`,`schoolCode`,`schoolMasterChangeSeqNum`,`schoolLocalChangeSeqNum`,`schoolLastChangedBy`,`schoolLct`,`schoolTimeZone`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, School value) {
        stmt.bindLong(1, value.getSchoolUid());
        if (value.getSchoolName() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getSchoolName());
        }
        if (value.getSchoolDesc() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getSchoolDesc());
        }
        if (value.getSchoolAddress() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getSchoolAddress());
        }
        final int _tmp = value.getSchoolActive() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        if (value.getSchoolPhoneNumber() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getSchoolPhoneNumber());
        }
        stmt.bindLong(7, value.getSchoolGender());
        stmt.bindLong(8, value.getSchoolHolidayCalendarUid());
        stmt.bindLong(9, value.getSchoolFeatures());
        stmt.bindDouble(10, value.getSchoolLocationLong());
        stmt.bindDouble(11, value.getSchoolLocationLatt());
        if (value.getSchoolEmailAddress() == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindString(12, value.getSchoolEmailAddress());
        }
        stmt.bindLong(13, value.getSchoolTeachersPersonGroupUid());
        stmt.bindLong(14, value.getSchoolStudentsPersonGroupUid());
        stmt.bindLong(15, value.getSchoolPendingStudentsPersonGroupUid());
        if (value.getSchoolCode() == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindString(16, value.getSchoolCode());
        }
        stmt.bindLong(17, value.getSchoolMasterChangeSeqNum());
        stmt.bindLong(18, value.getSchoolLocalChangeSeqNum());
        stmt.bindLong(19, value.getSchoolLastChangedBy());
        stmt.bindLong(20, value.getSchoolLct());
        if (value.getSchoolTimeZone() == null) {
          stmt.bindNull(21);
        } else {
          stmt.bindString(21, value.getSchoolTimeZone());
        }
      }
    };
    this.__updateAdapterOfSchool = new EntityDeletionOrUpdateAdapter<School>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `School` SET `schoolUid` = ?,`schoolName` = ?,`schoolDesc` = ?,`schoolAddress` = ?,`schoolActive` = ?,`schoolPhoneNumber` = ?,`schoolGender` = ?,`schoolHolidayCalendarUid` = ?,`schoolFeatures` = ?,`schoolLocationLong` = ?,`schoolLocationLatt` = ?,`schoolEmailAddress` = ?,`schoolTeachersPersonGroupUid` = ?,`schoolStudentsPersonGroupUid` = ?,`schoolPendingStudentsPersonGroupUid` = ?,`schoolCode` = ?,`schoolMasterChangeSeqNum` = ?,`schoolLocalChangeSeqNum` = ?,`schoolLastChangedBy` = ?,`schoolLct` = ?,`schoolTimeZone` = ? WHERE `schoolUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, School value) {
        stmt.bindLong(1, value.getSchoolUid());
        if (value.getSchoolName() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getSchoolName());
        }
        if (value.getSchoolDesc() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getSchoolDesc());
        }
        if (value.getSchoolAddress() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getSchoolAddress());
        }
        final int _tmp = value.getSchoolActive() ? 1 : 0;
        stmt.bindLong(5, _tmp);
        if (value.getSchoolPhoneNumber() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getSchoolPhoneNumber());
        }
        stmt.bindLong(7, value.getSchoolGender());
        stmt.bindLong(8, value.getSchoolHolidayCalendarUid());
        stmt.bindLong(9, value.getSchoolFeatures());
        stmt.bindDouble(10, value.getSchoolLocationLong());
        stmt.bindDouble(11, value.getSchoolLocationLatt());
        if (value.getSchoolEmailAddress() == null) {
          stmt.bindNull(12);
        } else {
          stmt.bindString(12, value.getSchoolEmailAddress());
        }
        stmt.bindLong(13, value.getSchoolTeachersPersonGroupUid());
        stmt.bindLong(14, value.getSchoolStudentsPersonGroupUid());
        stmt.bindLong(15, value.getSchoolPendingStudentsPersonGroupUid());
        if (value.getSchoolCode() == null) {
          stmt.bindNull(16);
        } else {
          stmt.bindString(16, value.getSchoolCode());
        }
        stmt.bindLong(17, value.getSchoolMasterChangeSeqNum());
        stmt.bindLong(18, value.getSchoolLocalChangeSeqNum());
        stmt.bindLong(19, value.getSchoolLastChangedBy());
        stmt.bindLong(20, value.getSchoolLct());
        if (value.getSchoolTimeZone() == null) {
          stmt.bindNull(21);
        } else {
          stmt.bindString(21, value.getSchoolTimeZone());
        }
        stmt.bindLong(22, value.getSchoolUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO SchoolReplicate(schoolPk, schoolDestination)\n"
                + "      SELECT DISTINCT School.schoolUid AS schoolPk,\n"
                + "             ? AS schoolDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember\n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "            JOIN ScopedGrant \n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions &\n"
                + "                 \n"
                + "        \n"
                + "                  536870912\n"
                + "                  \n"
                + "                    ) > 0\n"
                + "            JOIN School\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n"
                + "        \n"
                + "        \n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND School.schoolLct != COALESCE(\n"
                + "             (SELECT schoolVersionId\n"
                + "                FROM SchoolReplicate\n"
                + "               WHERE schoolPk = School.schoolUid\n"
                + "                 AND schoolDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(schoolPk, schoolDestination) DO UPDATE\n"
                + "             SET schoolPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO SchoolReplicate(schoolPk, schoolDestination)\n"
                + "  SELECT DISTINCT School.schoolUid AS schoolUid,\n"
                + "         UserSession.usClientNodeId AS schoolDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN School\n"
                + "              ON ChangeLog.chTableId = 164\n"
                + "                  AND ChangeLog.chEntityPk = School.schoolUid\n"
                + "              \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n"
                + "        \n"
                + "                        AND (SCopedGrant.sgPermissions &\n"
                + "        \n"
                + "                  536870912\n"
                + "                  \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "                      \n"
                + "        \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND School.schoolLct != COALESCE(\n"
                + "         (SELECT schoolVersionId\n"
                + "            FROM SchoolReplicate\n"
                + "           WHERE schoolPk = School.schoolUid\n"
                + "             AND schoolDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(schoolPk, schoolDestination) DO UPDATE\n"
                + "     SET schoolPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final School entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfSchool.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final School entity, final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfSchool.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends School> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfSchool.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends School> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfSchool.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final School entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfSchool.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final School entity, final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfSchool.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidAsync(final long schoolUid,
      final Continuation<? super School> continuation) {
    final String _sql = "SELECT * FROM School WHERE schoolUid = ? AND CAST(schoolActive AS INTEGER) = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, schoolUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<School>() {
      @Override
      public School call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolUid");
          final int _cursorIndexOfSchoolName = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolName");
          final int _cursorIndexOfSchoolDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolDesc");
          final int _cursorIndexOfSchoolAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolAddress");
          final int _cursorIndexOfSchoolActive = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolActive");
          final int _cursorIndexOfSchoolPhoneNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPhoneNumber");
          final int _cursorIndexOfSchoolGender = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolGender");
          final int _cursorIndexOfSchoolHolidayCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolHolidayCalendarUid");
          final int _cursorIndexOfSchoolFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolFeatures");
          final int _cursorIndexOfSchoolLocationLong = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLong");
          final int _cursorIndexOfSchoolLocationLatt = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLatt");
          final int _cursorIndexOfSchoolEmailAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolEmailAddress");
          final int _cursorIndexOfSchoolTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTeachersPersonGroupUid");
          final int _cursorIndexOfSchoolStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolStudentsPersonGroupUid");
          final int _cursorIndexOfSchoolPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPendingStudentsPersonGroupUid");
          final int _cursorIndexOfSchoolCode = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolCode");
          final int _cursorIndexOfSchoolMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMasterChangeSeqNum");
          final int _cursorIndexOfSchoolLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocalChangeSeqNum");
          final int _cursorIndexOfSchoolLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLastChangedBy");
          final int _cursorIndexOfSchoolLct = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLct");
          final int _cursorIndexOfSchoolTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTimeZone");
          final School _result;
          if(_cursor.moveToFirst()) {
            _result = new School();
            final long _tmpSchoolUid;
            _tmpSchoolUid = _cursor.getLong(_cursorIndexOfSchoolUid);
            _result.setSchoolUid(_tmpSchoolUid);
            final String _tmpSchoolName;
            if (_cursor.isNull(_cursorIndexOfSchoolName)) {
              _tmpSchoolName = null;
            } else {
              _tmpSchoolName = _cursor.getString(_cursorIndexOfSchoolName);
            }
            _result.setSchoolName(_tmpSchoolName);
            final String _tmpSchoolDesc;
            if (_cursor.isNull(_cursorIndexOfSchoolDesc)) {
              _tmpSchoolDesc = null;
            } else {
              _tmpSchoolDesc = _cursor.getString(_cursorIndexOfSchoolDesc);
            }
            _result.setSchoolDesc(_tmpSchoolDesc);
            final String _tmpSchoolAddress;
            if (_cursor.isNull(_cursorIndexOfSchoolAddress)) {
              _tmpSchoolAddress = null;
            } else {
              _tmpSchoolAddress = _cursor.getString(_cursorIndexOfSchoolAddress);
            }
            _result.setSchoolAddress(_tmpSchoolAddress);
            final boolean _tmpSchoolActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSchoolActive);
            _tmpSchoolActive = _tmp != 0;
            _result.setSchoolActive(_tmpSchoolActive);
            final String _tmpSchoolPhoneNumber;
            if (_cursor.isNull(_cursorIndexOfSchoolPhoneNumber)) {
              _tmpSchoolPhoneNumber = null;
            } else {
              _tmpSchoolPhoneNumber = _cursor.getString(_cursorIndexOfSchoolPhoneNumber);
            }
            _result.setSchoolPhoneNumber(_tmpSchoolPhoneNumber);
            final int _tmpSchoolGender;
            _tmpSchoolGender = _cursor.getInt(_cursorIndexOfSchoolGender);
            _result.setSchoolGender(_tmpSchoolGender);
            final long _tmpSchoolHolidayCalendarUid;
            _tmpSchoolHolidayCalendarUid = _cursor.getLong(_cursorIndexOfSchoolHolidayCalendarUid);
            _result.setSchoolHolidayCalendarUid(_tmpSchoolHolidayCalendarUid);
            final long _tmpSchoolFeatures;
            _tmpSchoolFeatures = _cursor.getLong(_cursorIndexOfSchoolFeatures);
            _result.setSchoolFeatures(_tmpSchoolFeatures);
            final double _tmpSchoolLocationLong;
            _tmpSchoolLocationLong = _cursor.getDouble(_cursorIndexOfSchoolLocationLong);
            _result.setSchoolLocationLong(_tmpSchoolLocationLong);
            final double _tmpSchoolLocationLatt;
            _tmpSchoolLocationLatt = _cursor.getDouble(_cursorIndexOfSchoolLocationLatt);
            _result.setSchoolLocationLatt(_tmpSchoolLocationLatt);
            final String _tmpSchoolEmailAddress;
            if (_cursor.isNull(_cursorIndexOfSchoolEmailAddress)) {
              _tmpSchoolEmailAddress = null;
            } else {
              _tmpSchoolEmailAddress = _cursor.getString(_cursorIndexOfSchoolEmailAddress);
            }
            _result.setSchoolEmailAddress(_tmpSchoolEmailAddress);
            final long _tmpSchoolTeachersPersonGroupUid;
            _tmpSchoolTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolTeachersPersonGroupUid);
            _result.setSchoolTeachersPersonGroupUid(_tmpSchoolTeachersPersonGroupUid);
            final long _tmpSchoolStudentsPersonGroupUid;
            _tmpSchoolStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolStudentsPersonGroupUid);
            _result.setSchoolStudentsPersonGroupUid(_tmpSchoolStudentsPersonGroupUid);
            final long _tmpSchoolPendingStudentsPersonGroupUid;
            _tmpSchoolPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolPendingStudentsPersonGroupUid);
            _result.setSchoolPendingStudentsPersonGroupUid(_tmpSchoolPendingStudentsPersonGroupUid);
            final String _tmpSchoolCode;
            if (_cursor.isNull(_cursorIndexOfSchoolCode)) {
              _tmpSchoolCode = null;
            } else {
              _tmpSchoolCode = _cursor.getString(_cursorIndexOfSchoolCode);
            }
            _result.setSchoolCode(_tmpSchoolCode);
            final long _tmpSchoolMasterChangeSeqNum;
            _tmpSchoolMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolMasterChangeSeqNum);
            _result.setSchoolMasterChangeSeqNum(_tmpSchoolMasterChangeSeqNum);
            final long _tmpSchoolLocalChangeSeqNum;
            _tmpSchoolLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolLocalChangeSeqNum);
            _result.setSchoolLocalChangeSeqNum(_tmpSchoolLocalChangeSeqNum);
            final int _tmpSchoolLastChangedBy;
            _tmpSchoolLastChangedBy = _cursor.getInt(_cursorIndexOfSchoolLastChangedBy);
            _result.setSchoolLastChangedBy(_tmpSchoolLastChangedBy);
            final long _tmpSchoolLct;
            _tmpSchoolLct = _cursor.getLong(_cursorIndexOfSchoolLct);
            _result.setSchoolLct(_tmpSchoolLct);
            final String _tmpSchoolTimeZone;
            if (_cursor.isNull(_cursorIndexOfSchoolTimeZone)) {
              _tmpSchoolTimeZone = null;
            } else {
              _tmpSchoolTimeZone = _cursor.getString(_cursorIndexOfSchoolTimeZone);
            }
            _result.setSchoolTimeZone(_tmpSchoolTimeZone);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidWithHolidayCalendarAsync(final long uid,
      final Continuation<? super SchoolWithHolidayCalendar> continuation) {
    final String _sql = "SELECT School.*, HolidayCalendar.* FROM School \n"
            + "            LEFT JOIN HolidayCalendar ON School.schoolHolidayCalendarUid = HolidayCalendar.umCalendarUid\n"
            + "            WHERE School.schoolUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<SchoolWithHolidayCalendar>() {
      @Override
      public SchoolWithHolidayCalendar call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolUid");
          final int _cursorIndexOfSchoolName = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolName");
          final int _cursorIndexOfSchoolDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolDesc");
          final int _cursorIndexOfSchoolAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolAddress");
          final int _cursorIndexOfSchoolActive = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolActive");
          final int _cursorIndexOfSchoolPhoneNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPhoneNumber");
          final int _cursorIndexOfSchoolGender = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolGender");
          final int _cursorIndexOfSchoolHolidayCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolHolidayCalendarUid");
          final int _cursorIndexOfSchoolFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolFeatures");
          final int _cursorIndexOfSchoolLocationLong = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLong");
          final int _cursorIndexOfSchoolLocationLatt = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLatt");
          final int _cursorIndexOfSchoolEmailAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolEmailAddress");
          final int _cursorIndexOfSchoolTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTeachersPersonGroupUid");
          final int _cursorIndexOfSchoolStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolStudentsPersonGroupUid");
          final int _cursorIndexOfSchoolPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPendingStudentsPersonGroupUid");
          final int _cursorIndexOfSchoolCode = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolCode");
          final int _cursorIndexOfSchoolMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMasterChangeSeqNum");
          final int _cursorIndexOfSchoolLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocalChangeSeqNum");
          final int _cursorIndexOfSchoolLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLastChangedBy");
          final int _cursorIndexOfSchoolLct = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLct");
          final int _cursorIndexOfSchoolTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTimeZone");
          final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
          final int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarName");
          final int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarCategory");
          final int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarActive");
          final int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarMasterChangeSeqNum");
          final int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLocalChangeSeqNum");
          final int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLastChangedBy");
          final int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLct");
          final SchoolWithHolidayCalendar _result;
          if(_cursor.moveToFirst()) {
            final HolidayCalendar _tmpHolidayCalendar;
            if (! (_cursor.isNull(_cursorIndexOfUmCalendarUid) && _cursor.isNull(_cursorIndexOfUmCalendarName) && _cursor.isNull(_cursorIndexOfUmCalendarCategory) && _cursor.isNull(_cursorIndexOfUmCalendarActive) && _cursor.isNull(_cursorIndexOfUmCalendarMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLastChangedBy) && _cursor.isNull(_cursorIndexOfUmCalendarLct))) {
              _tmpHolidayCalendar = new HolidayCalendar();
              final long _tmpUmCalendarUid;
              _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
              _tmpHolidayCalendar.setUmCalendarUid(_tmpUmCalendarUid);
              final String _tmpUmCalendarName;
              if (_cursor.isNull(_cursorIndexOfUmCalendarName)) {
                _tmpUmCalendarName = null;
              } else {
                _tmpUmCalendarName = _cursor.getString(_cursorIndexOfUmCalendarName);
              }
              _tmpHolidayCalendar.setUmCalendarName(_tmpUmCalendarName);
              final int _tmpUmCalendarCategory;
              _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
              _tmpHolidayCalendar.setUmCalendarCategory(_tmpUmCalendarCategory);
              final boolean _tmpUmCalendarActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfUmCalendarActive);
              _tmpUmCalendarActive = _tmp != 0;
              _tmpHolidayCalendar.setUmCalendarActive(_tmpUmCalendarActive);
              final long _tmpUmCalendarMasterChangeSeqNum;
              _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
              _tmpHolidayCalendar.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
              final long _tmpUmCalendarLocalChangeSeqNum;
              _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
              _tmpHolidayCalendar.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
              final int _tmpUmCalendarLastChangedBy;
              _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
              _tmpHolidayCalendar.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
              final long _tmpUmCalendarLct;
              _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
              _tmpHolidayCalendar.setUmCalendarLct(_tmpUmCalendarLct);
            }  else  {
              _tmpHolidayCalendar = null;
            }
            _result = new SchoolWithHolidayCalendar();
            final long _tmpSchoolUid;
            _tmpSchoolUid = _cursor.getLong(_cursorIndexOfSchoolUid);
            _result.setSchoolUid(_tmpSchoolUid);
            final String _tmpSchoolName;
            if (_cursor.isNull(_cursorIndexOfSchoolName)) {
              _tmpSchoolName = null;
            } else {
              _tmpSchoolName = _cursor.getString(_cursorIndexOfSchoolName);
            }
            _result.setSchoolName(_tmpSchoolName);
            final String _tmpSchoolDesc;
            if (_cursor.isNull(_cursorIndexOfSchoolDesc)) {
              _tmpSchoolDesc = null;
            } else {
              _tmpSchoolDesc = _cursor.getString(_cursorIndexOfSchoolDesc);
            }
            _result.setSchoolDesc(_tmpSchoolDesc);
            final String _tmpSchoolAddress;
            if (_cursor.isNull(_cursorIndexOfSchoolAddress)) {
              _tmpSchoolAddress = null;
            } else {
              _tmpSchoolAddress = _cursor.getString(_cursorIndexOfSchoolAddress);
            }
            _result.setSchoolAddress(_tmpSchoolAddress);
            final boolean _tmpSchoolActive;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfSchoolActive);
            _tmpSchoolActive = _tmp_1 != 0;
            _result.setSchoolActive(_tmpSchoolActive);
            final String _tmpSchoolPhoneNumber;
            if (_cursor.isNull(_cursorIndexOfSchoolPhoneNumber)) {
              _tmpSchoolPhoneNumber = null;
            } else {
              _tmpSchoolPhoneNumber = _cursor.getString(_cursorIndexOfSchoolPhoneNumber);
            }
            _result.setSchoolPhoneNumber(_tmpSchoolPhoneNumber);
            final int _tmpSchoolGender;
            _tmpSchoolGender = _cursor.getInt(_cursorIndexOfSchoolGender);
            _result.setSchoolGender(_tmpSchoolGender);
            final long _tmpSchoolHolidayCalendarUid;
            _tmpSchoolHolidayCalendarUid = _cursor.getLong(_cursorIndexOfSchoolHolidayCalendarUid);
            _result.setSchoolHolidayCalendarUid(_tmpSchoolHolidayCalendarUid);
            final long _tmpSchoolFeatures;
            _tmpSchoolFeatures = _cursor.getLong(_cursorIndexOfSchoolFeatures);
            _result.setSchoolFeatures(_tmpSchoolFeatures);
            final double _tmpSchoolLocationLong;
            _tmpSchoolLocationLong = _cursor.getDouble(_cursorIndexOfSchoolLocationLong);
            _result.setSchoolLocationLong(_tmpSchoolLocationLong);
            final double _tmpSchoolLocationLatt;
            _tmpSchoolLocationLatt = _cursor.getDouble(_cursorIndexOfSchoolLocationLatt);
            _result.setSchoolLocationLatt(_tmpSchoolLocationLatt);
            final String _tmpSchoolEmailAddress;
            if (_cursor.isNull(_cursorIndexOfSchoolEmailAddress)) {
              _tmpSchoolEmailAddress = null;
            } else {
              _tmpSchoolEmailAddress = _cursor.getString(_cursorIndexOfSchoolEmailAddress);
            }
            _result.setSchoolEmailAddress(_tmpSchoolEmailAddress);
            final long _tmpSchoolTeachersPersonGroupUid;
            _tmpSchoolTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolTeachersPersonGroupUid);
            _result.setSchoolTeachersPersonGroupUid(_tmpSchoolTeachersPersonGroupUid);
            final long _tmpSchoolStudentsPersonGroupUid;
            _tmpSchoolStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolStudentsPersonGroupUid);
            _result.setSchoolStudentsPersonGroupUid(_tmpSchoolStudentsPersonGroupUid);
            final long _tmpSchoolPendingStudentsPersonGroupUid;
            _tmpSchoolPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolPendingStudentsPersonGroupUid);
            _result.setSchoolPendingStudentsPersonGroupUid(_tmpSchoolPendingStudentsPersonGroupUid);
            final String _tmpSchoolCode;
            if (_cursor.isNull(_cursorIndexOfSchoolCode)) {
              _tmpSchoolCode = null;
            } else {
              _tmpSchoolCode = _cursor.getString(_cursorIndexOfSchoolCode);
            }
            _result.setSchoolCode(_tmpSchoolCode);
            final long _tmpSchoolMasterChangeSeqNum;
            _tmpSchoolMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolMasterChangeSeqNum);
            _result.setSchoolMasterChangeSeqNum(_tmpSchoolMasterChangeSeqNum);
            final long _tmpSchoolLocalChangeSeqNum;
            _tmpSchoolLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolLocalChangeSeqNum);
            _result.setSchoolLocalChangeSeqNum(_tmpSchoolLocalChangeSeqNum);
            final int _tmpSchoolLastChangedBy;
            _tmpSchoolLastChangedBy = _cursor.getInt(_cursorIndexOfSchoolLastChangedBy);
            _result.setSchoolLastChangedBy(_tmpSchoolLastChangedBy);
            final long _tmpSchoolLct;
            _tmpSchoolLct = _cursor.getLong(_cursorIndexOfSchoolLct);
            _result.setSchoolLct(_tmpSchoolLct);
            final String _tmpSchoolTimeZone;
            if (_cursor.isNull(_cursorIndexOfSchoolTimeZone)) {
              _tmpSchoolTimeZone = null;
            } else {
              _tmpSchoolTimeZone = _cursor.getString(_cursorIndexOfSchoolTimeZone);
            }
            _result.setSchoolTimeZone(_tmpSchoolTimeZone);
            _result.setHolidayCalendar(_tmpHolidayCalendar);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findBySchoolCode(final String code,
      final Continuation<? super School> continuation) {
    final String _sql = "SELECT * FROM School WHERE schoolCode = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (code == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, code);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<School>() {
      @Override
      public School call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolUid");
          final int _cursorIndexOfSchoolName = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolName");
          final int _cursorIndexOfSchoolDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolDesc");
          final int _cursorIndexOfSchoolAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolAddress");
          final int _cursorIndexOfSchoolActive = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolActive");
          final int _cursorIndexOfSchoolPhoneNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPhoneNumber");
          final int _cursorIndexOfSchoolGender = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolGender");
          final int _cursorIndexOfSchoolHolidayCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolHolidayCalendarUid");
          final int _cursorIndexOfSchoolFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolFeatures");
          final int _cursorIndexOfSchoolLocationLong = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLong");
          final int _cursorIndexOfSchoolLocationLatt = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLatt");
          final int _cursorIndexOfSchoolEmailAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolEmailAddress");
          final int _cursorIndexOfSchoolTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTeachersPersonGroupUid");
          final int _cursorIndexOfSchoolStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolStudentsPersonGroupUid");
          final int _cursorIndexOfSchoolPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPendingStudentsPersonGroupUid");
          final int _cursorIndexOfSchoolCode = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolCode");
          final int _cursorIndexOfSchoolMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMasterChangeSeqNum");
          final int _cursorIndexOfSchoolLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocalChangeSeqNum");
          final int _cursorIndexOfSchoolLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLastChangedBy");
          final int _cursorIndexOfSchoolLct = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLct");
          final int _cursorIndexOfSchoolTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTimeZone");
          final School _result;
          if(_cursor.moveToFirst()) {
            _result = new School();
            final long _tmpSchoolUid;
            _tmpSchoolUid = _cursor.getLong(_cursorIndexOfSchoolUid);
            _result.setSchoolUid(_tmpSchoolUid);
            final String _tmpSchoolName;
            if (_cursor.isNull(_cursorIndexOfSchoolName)) {
              _tmpSchoolName = null;
            } else {
              _tmpSchoolName = _cursor.getString(_cursorIndexOfSchoolName);
            }
            _result.setSchoolName(_tmpSchoolName);
            final String _tmpSchoolDesc;
            if (_cursor.isNull(_cursorIndexOfSchoolDesc)) {
              _tmpSchoolDesc = null;
            } else {
              _tmpSchoolDesc = _cursor.getString(_cursorIndexOfSchoolDesc);
            }
            _result.setSchoolDesc(_tmpSchoolDesc);
            final String _tmpSchoolAddress;
            if (_cursor.isNull(_cursorIndexOfSchoolAddress)) {
              _tmpSchoolAddress = null;
            } else {
              _tmpSchoolAddress = _cursor.getString(_cursorIndexOfSchoolAddress);
            }
            _result.setSchoolAddress(_tmpSchoolAddress);
            final boolean _tmpSchoolActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSchoolActive);
            _tmpSchoolActive = _tmp != 0;
            _result.setSchoolActive(_tmpSchoolActive);
            final String _tmpSchoolPhoneNumber;
            if (_cursor.isNull(_cursorIndexOfSchoolPhoneNumber)) {
              _tmpSchoolPhoneNumber = null;
            } else {
              _tmpSchoolPhoneNumber = _cursor.getString(_cursorIndexOfSchoolPhoneNumber);
            }
            _result.setSchoolPhoneNumber(_tmpSchoolPhoneNumber);
            final int _tmpSchoolGender;
            _tmpSchoolGender = _cursor.getInt(_cursorIndexOfSchoolGender);
            _result.setSchoolGender(_tmpSchoolGender);
            final long _tmpSchoolHolidayCalendarUid;
            _tmpSchoolHolidayCalendarUid = _cursor.getLong(_cursorIndexOfSchoolHolidayCalendarUid);
            _result.setSchoolHolidayCalendarUid(_tmpSchoolHolidayCalendarUid);
            final long _tmpSchoolFeatures;
            _tmpSchoolFeatures = _cursor.getLong(_cursorIndexOfSchoolFeatures);
            _result.setSchoolFeatures(_tmpSchoolFeatures);
            final double _tmpSchoolLocationLong;
            _tmpSchoolLocationLong = _cursor.getDouble(_cursorIndexOfSchoolLocationLong);
            _result.setSchoolLocationLong(_tmpSchoolLocationLong);
            final double _tmpSchoolLocationLatt;
            _tmpSchoolLocationLatt = _cursor.getDouble(_cursorIndexOfSchoolLocationLatt);
            _result.setSchoolLocationLatt(_tmpSchoolLocationLatt);
            final String _tmpSchoolEmailAddress;
            if (_cursor.isNull(_cursorIndexOfSchoolEmailAddress)) {
              _tmpSchoolEmailAddress = null;
            } else {
              _tmpSchoolEmailAddress = _cursor.getString(_cursorIndexOfSchoolEmailAddress);
            }
            _result.setSchoolEmailAddress(_tmpSchoolEmailAddress);
            final long _tmpSchoolTeachersPersonGroupUid;
            _tmpSchoolTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolTeachersPersonGroupUid);
            _result.setSchoolTeachersPersonGroupUid(_tmpSchoolTeachersPersonGroupUid);
            final long _tmpSchoolStudentsPersonGroupUid;
            _tmpSchoolStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolStudentsPersonGroupUid);
            _result.setSchoolStudentsPersonGroupUid(_tmpSchoolStudentsPersonGroupUid);
            final long _tmpSchoolPendingStudentsPersonGroupUid;
            _tmpSchoolPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolPendingStudentsPersonGroupUid);
            _result.setSchoolPendingStudentsPersonGroupUid(_tmpSchoolPendingStudentsPersonGroupUid);
            final String _tmpSchoolCode;
            if (_cursor.isNull(_cursorIndexOfSchoolCode)) {
              _tmpSchoolCode = null;
            } else {
              _tmpSchoolCode = _cursor.getString(_cursorIndexOfSchoolCode);
            }
            _result.setSchoolCode(_tmpSchoolCode);
            final long _tmpSchoolMasterChangeSeqNum;
            _tmpSchoolMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolMasterChangeSeqNum);
            _result.setSchoolMasterChangeSeqNum(_tmpSchoolMasterChangeSeqNum);
            final long _tmpSchoolLocalChangeSeqNum;
            _tmpSchoolLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolLocalChangeSeqNum);
            _result.setSchoolLocalChangeSeqNum(_tmpSchoolLocalChangeSeqNum);
            final int _tmpSchoolLastChangedBy;
            _tmpSchoolLastChangedBy = _cursor.getInt(_cursorIndexOfSchoolLastChangedBy);
            _result.setSchoolLastChangedBy(_tmpSchoolLastChangedBy);
            final long _tmpSchoolLct;
            _tmpSchoolLct = _cursor.getLong(_cursorIndexOfSchoolLct);
            _result.setSchoolLct(_tmpSchoolLct);
            final String _tmpSchoolTimeZone;
            if (_cursor.isNull(_cursorIndexOfSchoolTimeZone)) {
              _tmpSchoolTimeZone = null;
            } else {
              _tmpSchoolTimeZone = _cursor.getString(_cursorIndexOfSchoolTimeZone);
            }
            _result.setSchoolTimeZone(_tmpSchoolTimeZone);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findBySchoolCodeFromWeb(final String code,
      final Continuation<? super School> continuation) {
    final String _sql = "SELECT * FROM School WHERE schoolCode = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (code == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, code);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<School>() {
      @Override
      public School call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolUid");
          final int _cursorIndexOfSchoolName = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolName");
          final int _cursorIndexOfSchoolDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolDesc");
          final int _cursorIndexOfSchoolAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolAddress");
          final int _cursorIndexOfSchoolActive = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolActive");
          final int _cursorIndexOfSchoolPhoneNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPhoneNumber");
          final int _cursorIndexOfSchoolGender = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolGender");
          final int _cursorIndexOfSchoolHolidayCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolHolidayCalendarUid");
          final int _cursorIndexOfSchoolFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolFeatures");
          final int _cursorIndexOfSchoolLocationLong = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLong");
          final int _cursorIndexOfSchoolLocationLatt = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLatt");
          final int _cursorIndexOfSchoolEmailAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolEmailAddress");
          final int _cursorIndexOfSchoolTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTeachersPersonGroupUid");
          final int _cursorIndexOfSchoolStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolStudentsPersonGroupUid");
          final int _cursorIndexOfSchoolPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPendingStudentsPersonGroupUid");
          final int _cursorIndexOfSchoolCode = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolCode");
          final int _cursorIndexOfSchoolMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMasterChangeSeqNum");
          final int _cursorIndexOfSchoolLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocalChangeSeqNum");
          final int _cursorIndexOfSchoolLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLastChangedBy");
          final int _cursorIndexOfSchoolLct = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLct");
          final int _cursorIndexOfSchoolTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTimeZone");
          final School _result;
          if(_cursor.moveToFirst()) {
            _result = new School();
            final long _tmpSchoolUid;
            _tmpSchoolUid = _cursor.getLong(_cursorIndexOfSchoolUid);
            _result.setSchoolUid(_tmpSchoolUid);
            final String _tmpSchoolName;
            if (_cursor.isNull(_cursorIndexOfSchoolName)) {
              _tmpSchoolName = null;
            } else {
              _tmpSchoolName = _cursor.getString(_cursorIndexOfSchoolName);
            }
            _result.setSchoolName(_tmpSchoolName);
            final String _tmpSchoolDesc;
            if (_cursor.isNull(_cursorIndexOfSchoolDesc)) {
              _tmpSchoolDesc = null;
            } else {
              _tmpSchoolDesc = _cursor.getString(_cursorIndexOfSchoolDesc);
            }
            _result.setSchoolDesc(_tmpSchoolDesc);
            final String _tmpSchoolAddress;
            if (_cursor.isNull(_cursorIndexOfSchoolAddress)) {
              _tmpSchoolAddress = null;
            } else {
              _tmpSchoolAddress = _cursor.getString(_cursorIndexOfSchoolAddress);
            }
            _result.setSchoolAddress(_tmpSchoolAddress);
            final boolean _tmpSchoolActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfSchoolActive);
            _tmpSchoolActive = _tmp != 0;
            _result.setSchoolActive(_tmpSchoolActive);
            final String _tmpSchoolPhoneNumber;
            if (_cursor.isNull(_cursorIndexOfSchoolPhoneNumber)) {
              _tmpSchoolPhoneNumber = null;
            } else {
              _tmpSchoolPhoneNumber = _cursor.getString(_cursorIndexOfSchoolPhoneNumber);
            }
            _result.setSchoolPhoneNumber(_tmpSchoolPhoneNumber);
            final int _tmpSchoolGender;
            _tmpSchoolGender = _cursor.getInt(_cursorIndexOfSchoolGender);
            _result.setSchoolGender(_tmpSchoolGender);
            final long _tmpSchoolHolidayCalendarUid;
            _tmpSchoolHolidayCalendarUid = _cursor.getLong(_cursorIndexOfSchoolHolidayCalendarUid);
            _result.setSchoolHolidayCalendarUid(_tmpSchoolHolidayCalendarUid);
            final long _tmpSchoolFeatures;
            _tmpSchoolFeatures = _cursor.getLong(_cursorIndexOfSchoolFeatures);
            _result.setSchoolFeatures(_tmpSchoolFeatures);
            final double _tmpSchoolLocationLong;
            _tmpSchoolLocationLong = _cursor.getDouble(_cursorIndexOfSchoolLocationLong);
            _result.setSchoolLocationLong(_tmpSchoolLocationLong);
            final double _tmpSchoolLocationLatt;
            _tmpSchoolLocationLatt = _cursor.getDouble(_cursorIndexOfSchoolLocationLatt);
            _result.setSchoolLocationLatt(_tmpSchoolLocationLatt);
            final String _tmpSchoolEmailAddress;
            if (_cursor.isNull(_cursorIndexOfSchoolEmailAddress)) {
              _tmpSchoolEmailAddress = null;
            } else {
              _tmpSchoolEmailAddress = _cursor.getString(_cursorIndexOfSchoolEmailAddress);
            }
            _result.setSchoolEmailAddress(_tmpSchoolEmailAddress);
            final long _tmpSchoolTeachersPersonGroupUid;
            _tmpSchoolTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolTeachersPersonGroupUid);
            _result.setSchoolTeachersPersonGroupUid(_tmpSchoolTeachersPersonGroupUid);
            final long _tmpSchoolStudentsPersonGroupUid;
            _tmpSchoolStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolStudentsPersonGroupUid);
            _result.setSchoolStudentsPersonGroupUid(_tmpSchoolStudentsPersonGroupUid);
            final long _tmpSchoolPendingStudentsPersonGroupUid;
            _tmpSchoolPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolPendingStudentsPersonGroupUid);
            _result.setSchoolPendingStudentsPersonGroupUid(_tmpSchoolPendingStudentsPersonGroupUid);
            final String _tmpSchoolCode;
            if (_cursor.isNull(_cursorIndexOfSchoolCode)) {
              _tmpSchoolCode = null;
            } else {
              _tmpSchoolCode = _cursor.getString(_cursorIndexOfSchoolCode);
            }
            _result.setSchoolCode(_tmpSchoolCode);
            final long _tmpSchoolMasterChangeSeqNum;
            _tmpSchoolMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolMasterChangeSeqNum);
            _result.setSchoolMasterChangeSeqNum(_tmpSchoolMasterChangeSeqNum);
            final long _tmpSchoolLocalChangeSeqNum;
            _tmpSchoolLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolLocalChangeSeqNum);
            _result.setSchoolLocalChangeSeqNum(_tmpSchoolLocalChangeSeqNum);
            final int _tmpSchoolLastChangedBy;
            _tmpSchoolLastChangedBy = _cursor.getInt(_cursorIndexOfSchoolLastChangedBy);
            _result.setSchoolLastChangedBy(_tmpSchoolLastChangedBy);
            final long _tmpSchoolLct;
            _tmpSchoolLct = _cursor.getLong(_cursorIndexOfSchoolLct);
            _result.setSchoolLct(_tmpSchoolLct);
            final String _tmpSchoolTimeZone;
            if (_cursor.isNull(_cursorIndexOfSchoolTimeZone)) {
              _tmpSchoolTimeZone = null;
            } else {
              _tmpSchoolTimeZone = _cursor.getString(_cursorIndexOfSchoolTimeZone);
            }
            _result.setSchoolTimeZone(_tmpSchoolTimeZone);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object personHasPermissionWithSchool(final long accountPersonUid, final long schoolUid,
      final long permission, final Continuation<? super Boolean> continuation) {
    final String _sql = "\n"
            + "    Select EXISTS(\n"
            + "           SELECT School.schoolUid \n"
            + "             FROM School\n"
            + "                  \n"
            + "            JOIN ScopedGrant\n"
            + "                 ON \n"
            + "            ((ScopedGrant.sgTableId = -2\n"
            + "                    AND ScopedGrant.sgEntityUid = -2)\n"
            + "                OR (ScopedGrant.sgTableId = 164\n"
            + "                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n"
            + "        \n"
            + "                        AND (SCopedGrant.sgPermissions &\n"
            + "         ?) > 0\n"
            + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
            + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
            + "                      AND PrsGrpMbr.groupMemberPersonUid = ?\n"
            + "            WHERE School.schoolUid = ?)      \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, permission);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, schoolUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, SchoolWithMemberCountAndLocation> findAllActiveSchoolWithMemberCountAndLocationName(
      final String searchBit, final long personUid, final long permission, final int sortOrder) {
    final String _sql = "\n"
            + "       SELECT School.*, \n"
            + "              (SELECT COUNT(*) \n"
            + "                  FROM SchoolMember \n"
            + "                 WHERE SchoolMember.schoolMemberSchoolUid = School.schoolUid \n"
            + "                   AND CAST(SchoolMember.schoolMemberActive AS INTEGER) = 1 \n"
            + "                   AND SchoolMember.schoolMemberRole = 1003) as numStudents,\n"
            + "              (SELECT COUNT(*) \n"
            + "                 FROM SchoolMember \n"
            + "                WHERE SchoolMember.schoolMemberSchoolUid = School.schoolUid \n"
            + "                  AND CAST(SchoolMember.schoolMemberActive AS INTEGER) = 1 \n"
            + "                  AND SchoolMember.schoolMemberRole = 1004) as numTeachers, \n"
            + "               '' as locationName,\n"
            + "              (SELECT COUNT(*) \n"
            + "                 FROM Clazz \n"
            + "                WHERE Clazz.clazzSchoolUid = School.schoolUid \n"
            + "                  AND CAST(Clazz.clazzUid AS INTEGER) = 1 ) as clazzCount\n"
            + "         FROM PersonGroupMember\n"
            + "              \n"
            + "            JOIN ScopedGrant \n"
            + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
            + "                        AND (ScopedGrant.sgPermissions &\n"
            + "                 \n"
            + "        \n"
            + "                    ?\n"
            + "                    \n"
            + "                    ) > 0\n"
            + "            JOIN School\n"
            + "                 ON \n"
            + "            ((ScopedGrant.sgTableId = -2\n"
            + "                    AND ScopedGrant.sgEntityUid = -2)\n"
            + "                OR (ScopedGrant.sgTableId = 164\n"
            + "                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n"
            + "        \n"
            + "        \n"
            + "        WHERE PersonGroupMember.groupMemberPersonUid = ?\n"
            + "          AND PersonGroupMember.groupMemberActive \n"
            + "          AND CAST(schoolActive AS INTEGER) = 1\n"
            + "          AND schoolName LIKE ?\n"
            + "     GROUP BY School.schoolUid\n"
            + "     ORDER BY CASE(?)\n"
            + "              WHEN 1 THEN School.schoolName\n"
            + "              ELSE ''\n"
            + "              END ASC,\n"
            + "              CASE(?)\n"
            + "              WHEN 2 THEN School.schoolName\n"
            + "              ELSE ''\n"
            + "              END DESC";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 5);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, permission);
    _argIndex = 2;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 3;
    if (searchBit == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchBit);
    }
    _argIndex = 4;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 5;
    _statement.bindLong(_argIndex, sortOrder);
    return new DataSource.Factory<Integer, SchoolWithMemberCountAndLocation>() {
      @Override
      public LimitOffsetDataSource<SchoolWithMemberCountAndLocation> create() {
        return new LimitOffsetDataSource<SchoolWithMemberCountAndLocation>(__db, _statement, false, true , "SchoolMember", "Clazz", "PersonGroupMember", "ScopedGrant", "School") {
          @Override
          protected List<SchoolWithMemberCountAndLocation> convertRows(Cursor cursor) {
            final int _cursorIndexOfSchoolUid = CursorUtil.getColumnIndexOrThrow(cursor, "schoolUid");
            final int _cursorIndexOfSchoolName = CursorUtil.getColumnIndexOrThrow(cursor, "schoolName");
            final int _cursorIndexOfSchoolDesc = CursorUtil.getColumnIndexOrThrow(cursor, "schoolDesc");
            final int _cursorIndexOfSchoolAddress = CursorUtil.getColumnIndexOrThrow(cursor, "schoolAddress");
            final int _cursorIndexOfSchoolActive = CursorUtil.getColumnIndexOrThrow(cursor, "schoolActive");
            final int _cursorIndexOfSchoolPhoneNumber = CursorUtil.getColumnIndexOrThrow(cursor, "schoolPhoneNumber");
            final int _cursorIndexOfSchoolGender = CursorUtil.getColumnIndexOrThrow(cursor, "schoolGender");
            final int _cursorIndexOfSchoolHolidayCalendarUid = CursorUtil.getColumnIndexOrThrow(cursor, "schoolHolidayCalendarUid");
            final int _cursorIndexOfSchoolFeatures = CursorUtil.getColumnIndexOrThrow(cursor, "schoolFeatures");
            final int _cursorIndexOfSchoolLocationLong = CursorUtil.getColumnIndexOrThrow(cursor, "schoolLocationLong");
            final int _cursorIndexOfSchoolLocationLatt = CursorUtil.getColumnIndexOrThrow(cursor, "schoolLocationLatt");
            final int _cursorIndexOfSchoolEmailAddress = CursorUtil.getColumnIndexOrThrow(cursor, "schoolEmailAddress");
            final int _cursorIndexOfSchoolTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "schoolTeachersPersonGroupUid");
            final int _cursorIndexOfSchoolStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "schoolStudentsPersonGroupUid");
            final int _cursorIndexOfSchoolPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "schoolPendingStudentsPersonGroupUid");
            final int _cursorIndexOfSchoolCode = CursorUtil.getColumnIndexOrThrow(cursor, "schoolCode");
            final int _cursorIndexOfSchoolMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "schoolMasterChangeSeqNum");
            final int _cursorIndexOfSchoolLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "schoolLocalChangeSeqNum");
            final int _cursorIndexOfSchoolLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "schoolLastChangedBy");
            final int _cursorIndexOfSchoolLct = CursorUtil.getColumnIndexOrThrow(cursor, "schoolLct");
            final int _cursorIndexOfSchoolTimeZone = CursorUtil.getColumnIndexOrThrow(cursor, "schoolTimeZone");
            final int _cursorIndexOfNumStudents = CursorUtil.getColumnIndexOrThrow(cursor, "numStudents");
            final int _cursorIndexOfNumTeachers = CursorUtil.getColumnIndexOrThrow(cursor, "numTeachers");
            final int _cursorIndexOfLocationName = CursorUtil.getColumnIndexOrThrow(cursor, "locationName");
            final int _cursorIndexOfClazzCount = CursorUtil.getColumnIndexOrThrow(cursor, "clazzCount");
            final List<SchoolWithMemberCountAndLocation> _res = new ArrayList<SchoolWithMemberCountAndLocation>(cursor.getCount());
            while(cursor.moveToNext()) {
              final SchoolWithMemberCountAndLocation _item;
              _item = new SchoolWithMemberCountAndLocation();
              final long _tmpSchoolUid;
              _tmpSchoolUid = cursor.getLong(_cursorIndexOfSchoolUid);
              _item.setSchoolUid(_tmpSchoolUid);
              final String _tmpSchoolName;
              if (cursor.isNull(_cursorIndexOfSchoolName)) {
                _tmpSchoolName = null;
              } else {
                _tmpSchoolName = cursor.getString(_cursorIndexOfSchoolName);
              }
              _item.setSchoolName(_tmpSchoolName);
              final String _tmpSchoolDesc;
              if (cursor.isNull(_cursorIndexOfSchoolDesc)) {
                _tmpSchoolDesc = null;
              } else {
                _tmpSchoolDesc = cursor.getString(_cursorIndexOfSchoolDesc);
              }
              _item.setSchoolDesc(_tmpSchoolDesc);
              final String _tmpSchoolAddress;
              if (cursor.isNull(_cursorIndexOfSchoolAddress)) {
                _tmpSchoolAddress = null;
              } else {
                _tmpSchoolAddress = cursor.getString(_cursorIndexOfSchoolAddress);
              }
              _item.setSchoolAddress(_tmpSchoolAddress);
              final boolean _tmpSchoolActive;
              final int _tmp;
              _tmp = cursor.getInt(_cursorIndexOfSchoolActive);
              _tmpSchoolActive = _tmp != 0;
              _item.setSchoolActive(_tmpSchoolActive);
              final String _tmpSchoolPhoneNumber;
              if (cursor.isNull(_cursorIndexOfSchoolPhoneNumber)) {
                _tmpSchoolPhoneNumber = null;
              } else {
                _tmpSchoolPhoneNumber = cursor.getString(_cursorIndexOfSchoolPhoneNumber);
              }
              _item.setSchoolPhoneNumber(_tmpSchoolPhoneNumber);
              final int _tmpSchoolGender;
              _tmpSchoolGender = cursor.getInt(_cursorIndexOfSchoolGender);
              _item.setSchoolGender(_tmpSchoolGender);
              final long _tmpSchoolHolidayCalendarUid;
              _tmpSchoolHolidayCalendarUid = cursor.getLong(_cursorIndexOfSchoolHolidayCalendarUid);
              _item.setSchoolHolidayCalendarUid(_tmpSchoolHolidayCalendarUid);
              final long _tmpSchoolFeatures;
              _tmpSchoolFeatures = cursor.getLong(_cursorIndexOfSchoolFeatures);
              _item.setSchoolFeatures(_tmpSchoolFeatures);
              final double _tmpSchoolLocationLong;
              _tmpSchoolLocationLong = cursor.getDouble(_cursorIndexOfSchoolLocationLong);
              _item.setSchoolLocationLong(_tmpSchoolLocationLong);
              final double _tmpSchoolLocationLatt;
              _tmpSchoolLocationLatt = cursor.getDouble(_cursorIndexOfSchoolLocationLatt);
              _item.setSchoolLocationLatt(_tmpSchoolLocationLatt);
              final String _tmpSchoolEmailAddress;
              if (cursor.isNull(_cursorIndexOfSchoolEmailAddress)) {
                _tmpSchoolEmailAddress = null;
              } else {
                _tmpSchoolEmailAddress = cursor.getString(_cursorIndexOfSchoolEmailAddress);
              }
              _item.setSchoolEmailAddress(_tmpSchoolEmailAddress);
              final long _tmpSchoolTeachersPersonGroupUid;
              _tmpSchoolTeachersPersonGroupUid = cursor.getLong(_cursorIndexOfSchoolTeachersPersonGroupUid);
              _item.setSchoolTeachersPersonGroupUid(_tmpSchoolTeachersPersonGroupUid);
              final long _tmpSchoolStudentsPersonGroupUid;
              _tmpSchoolStudentsPersonGroupUid = cursor.getLong(_cursorIndexOfSchoolStudentsPersonGroupUid);
              _item.setSchoolStudentsPersonGroupUid(_tmpSchoolStudentsPersonGroupUid);
              final long _tmpSchoolPendingStudentsPersonGroupUid;
              _tmpSchoolPendingStudentsPersonGroupUid = cursor.getLong(_cursorIndexOfSchoolPendingStudentsPersonGroupUid);
              _item.setSchoolPendingStudentsPersonGroupUid(_tmpSchoolPendingStudentsPersonGroupUid);
              final String _tmpSchoolCode;
              if (cursor.isNull(_cursorIndexOfSchoolCode)) {
                _tmpSchoolCode = null;
              } else {
                _tmpSchoolCode = cursor.getString(_cursorIndexOfSchoolCode);
              }
              _item.setSchoolCode(_tmpSchoolCode);
              final long _tmpSchoolMasterChangeSeqNum;
              _tmpSchoolMasterChangeSeqNum = cursor.getLong(_cursorIndexOfSchoolMasterChangeSeqNum);
              _item.setSchoolMasterChangeSeqNum(_tmpSchoolMasterChangeSeqNum);
              final long _tmpSchoolLocalChangeSeqNum;
              _tmpSchoolLocalChangeSeqNum = cursor.getLong(_cursorIndexOfSchoolLocalChangeSeqNum);
              _item.setSchoolLocalChangeSeqNum(_tmpSchoolLocalChangeSeqNum);
              final int _tmpSchoolLastChangedBy;
              _tmpSchoolLastChangedBy = cursor.getInt(_cursorIndexOfSchoolLastChangedBy);
              _item.setSchoolLastChangedBy(_tmpSchoolLastChangedBy);
              final long _tmpSchoolLct;
              _tmpSchoolLct = cursor.getLong(_cursorIndexOfSchoolLct);
              _item.setSchoolLct(_tmpSchoolLct);
              final String _tmpSchoolTimeZone;
              if (cursor.isNull(_cursorIndexOfSchoolTimeZone)) {
                _tmpSchoolTimeZone = null;
              } else {
                _tmpSchoolTimeZone = cursor.getString(_cursorIndexOfSchoolTimeZone);
              }
              _item.setSchoolTimeZone(_tmpSchoolTimeZone);
              final int _tmpNumStudents;
              _tmpNumStudents = cursor.getInt(_cursorIndexOfNumStudents);
              _item.setNumStudents(_tmpNumStudents);
              final int _tmpNumTeachers;
              _tmpNumTeachers = cursor.getInt(_cursorIndexOfNumTeachers);
              _item.setNumTeachers(_tmpNumTeachers);
              final String _tmpLocationName;
              if (cursor.isNull(_cursorIndexOfLocationName)) {
                _tmpLocationName = null;
              } else {
                _tmpLocationName = cursor.getString(_cursorIndexOfLocationName);
              }
              _item.setLocationName(_tmpLocationName);
              final int _tmpClazzCount;
              _tmpClazzCount = cursor.getInt(_cursorIndexOfClazzCount);
              _item.setClazzCount(_tmpClazzCount);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
