package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ScopedGrant;
import com.ustadmobile.lib.db.entities.ScopedGrantAndName;
import com.ustadmobile.lib.db.entities.ScopedGrantWithName;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ScopedGrantDao_Impl extends ScopedGrantDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ScopedGrant> __insertionAdapterOfScopedGrant;

  private final EntityDeletionOrUpdateAdapter<ScopedGrant> __updateAdapterOfScopedGrant;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChangeClazzBased;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNodeClazzBased;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChangePersonBased;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNodePersonBased;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChangeSchoolBased;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNodeSchoolBased;

  public ScopedGrantDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfScopedGrant = new EntityInsertionAdapter<ScopedGrant>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ScopedGrant` (`sgUid`,`sgPcsn`,`sgLcsn`,`sgLcb`,`sgLct`,`sgTableId`,`sgEntityUid`,`sgPermissions`,`sgGroupUid`,`sgIndex`,`sgFlags`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ScopedGrant value) {
        stmt.bindLong(1, value.getSgUid());
        stmt.bindLong(2, value.getSgPcsn());
        stmt.bindLong(3, value.getSgLcsn());
        stmt.bindLong(4, value.getSgLcb());
        stmt.bindLong(5, value.getSgLct());
        stmt.bindLong(6, value.getSgTableId());
        stmt.bindLong(7, value.getSgEntityUid());
        stmt.bindLong(8, value.getSgPermissions());
        stmt.bindLong(9, value.getSgGroupUid());
        stmt.bindLong(10, value.getSgIndex());
        stmt.bindLong(11, value.getSgFlags());
      }
    };
    this.__updateAdapterOfScopedGrant = new EntityDeletionOrUpdateAdapter<ScopedGrant>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ScopedGrant` SET `sgUid` = ?,`sgPcsn` = ?,`sgLcsn` = ?,`sgLcb` = ?,`sgLct` = ?,`sgTableId` = ?,`sgEntityUid` = ?,`sgPermissions` = ?,`sgGroupUid` = ?,`sgIndex` = ?,`sgFlags` = ? WHERE `sgUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ScopedGrant value) {
        stmt.bindLong(1, value.getSgUid());
        stmt.bindLong(2, value.getSgPcsn());
        stmt.bindLong(3, value.getSgLcsn());
        stmt.bindLong(4, value.getSgLcb());
        stmt.bindLong(5, value.getSgLct());
        stmt.bindLong(6, value.getSgTableId());
        stmt.bindLong(7, value.getSgEntityUid());
        stmt.bindLong(8, value.getSgPermissions());
        stmt.bindLong(9, value.getSgGroupUid());
        stmt.bindLong(10, value.getSgIndex());
        stmt.bindLong(11, value.getSgFlags());
        stmt.bindLong(12, value.getSgUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n"
                + "      SELECT DISTINCT ScopedGrantWithPerm.sgUid AS sgPk,\n"
                + "             ? AS sgDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember\n"
                + "                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "               \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                    AND (ScopedGrant.sgPermissions &\n"
                + "                    64\n"
                + "                    \n"
                + "                                                    ) > 0\n"
                + "            JOIN Person \n"
                + "                 ON \n"
                + "                ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberPersonUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )    \n"
                + "        \n"
                + "        \n"
                + "             JOIN PersonGroupMember PersonsWithPerm_GroupMember\n"
                + "                    ON PersonsWithPerm_GroupMember.groupMemberPersonUid = Person.personUid\n"
                + "             JOIN ScopedGrant ScopedGrantWithPerm\n"
                + "                    ON PersonsWithPerm_GroupMember.groupMemberGroupUid = ScopedGrantWithPerm.sgGroupUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND ScopedGrantWithPerm.sgLct != COALESCE(\n"
                + "             (SELECT sgVersionId\n"
                + "                FROM ScopedGrantReplicate\n"
                + "               WHERE sgPk = ScopedGrantWithPerm.sgUid\n"
                + "                 AND sgDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n"
                + "             SET sgPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n"
                + "  SELECT DISTINCT ScopedGrantEntity.sgUid AS sgPk,\n"
                + "         UserSession.usClientNodeId AS sgDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN ScopedGrant ScopedGrantEntity\n"
                + "             ON ChangeLog.chTableId = 48\n"
                + "                AND ChangeLog.chEntityPk = ScopedGrantEntity.sgUid\n"
                + "         JOIN PersonGroupMember\n"
                + "              ON PersonGroupMember.groupMemberGroupUid = ScopedGrantEntity.sgGroupUid\n"
                + "         JOIN Person\n"
                + "              ON PersonGroupMember.groupMemberPersonUid = Person.personUid\n"
                + "         \n"
                + "            JOIN ScopedGrant \n"
                + "                   ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentClazzUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentPersonUid = Person.personUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberSchoolUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberPersonUid = Person.personUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )\n"
                + "        \n"
                + "                   AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              64\n"
                + "              \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND ScopedGrantEntity.sgLct != COALESCE(\n"
                + "         (SELECT sgVersionId\n"
                + "            FROM ScopedGrantReplicate\n"
                + "           WHERE sgPk = ScopedGrantEntity.sgUid\n"
                + "             AND sgDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n"
                + "     SET sgPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChangeClazzBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n"
                + "  SELECT DISTINCT ScopedGrantEntity.sgUid AS sgPk,\n"
                + "         UserSession.usClientNodeId AS sgDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN ScopedGrant ScopedGrantEntity\n"
                + "              ON ChangeLog.chTableId = 48\n"
                + "                 AND ChangeLog.chEntityPk = ScopedGrantEntity.sgUid\n"
                + "         JOIN Clazz \n"
                + "              ON ScopedGrantEntity.sgTableId = 6\n"
                + "                 AND ScopedGrantEntity.sgEntityUid = Clazz.clazzUid\n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              2\n"
                + "              \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "                \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND ScopedGrantEntity.sgLct != COALESCE(\n"
                + "         (SELECT sgVersionId\n"
                + "            FROM ScopedGrantReplicate\n"
                + "           WHERE sgPk = ScopedGrantEntity.sgUid\n"
                + "             AND sgDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n"
                + "     SET sgPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnNewNodeClazzBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n"
                + "      SELECT DISTINCT ScopedGrantEntity.sgUid AS sgPk,\n"
                + "             ? AS sgDestination\n"
                + "        FROM UserSession\n"
                + "               JOIN PersonGroupMember \n"
                + "                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "               \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                    2 \n"
                + "                    \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "               JOIN ScopedGrant ScopedGrantEntity\n"
                + "                    ON Clazz.clazzUid = ScopedGrantEntity.sgEntityUid\n"
                + "                       AND ScopedGrantEntity.sgTableId = 6\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND ScopedGrantEntity.sgLct != COALESCE(\n"
                + "             (SELECT sgVersionId\n"
                + "                FROM ScopedGrantReplicate\n"
                + "               WHERE sgPk = ScopedGrantEntity.sgUid\n"
                + "                 AND sgDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n"
                + "             SET sgPending = true\n"
                + "      */\n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChangePersonBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n"
                + "  SELECT DISTINCT ScopedGrantEntity.sgUid AS sgPk,\n"
                + "         UserSession.usClientNodeId AS sgDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN ScopedGrant ScopedGrantEntity\n"
                + "              ON ChangeLog.chTableId = 48\n"
                + "                 AND ChangeLog.chEntityPk = ScopedGrantEntity.sgUid\n"
                + "         JOIN Person\n"
                + "              ON ScopedGrantEntity.sgTableId = 9\n"
                + "                 AND ScopedGrantEntity.sgEntityUid = Person.personUid\n"
                + "         \n"
                + "            JOIN ScopedGrant \n"
                + "                   ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentClazzUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentPersonUid = Person.personUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberSchoolUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberPersonUid = Person.personUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )\n"
                + "        \n"
                + "                   AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "            64\n"
                + "            \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "             \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND ScopedGrantEntity.sgLct != COALESCE(\n"
                + "         (SELECT sgVersionId\n"
                + "            FROM ScopedGrantReplicate\n"
                + "           WHERE sgPk = ScopedGrantEntity.sgUid\n"
                + "             AND sgDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n"
                + "     SET sgPending = true\n"
                + "  */                    \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnNewNodePersonBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n"
                + "      SELECT DISTINCT ScopedGrantEntity.sgUid AS sgPk,\n"
                + "             ? AS sgDestination\n"
                + "        FROM UserSession\n"
                + "               JOIN PersonGroupMember \n"
                + "                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "               \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                    AND (ScopedGrant.sgPermissions &\n"
                + "                    64\n"
                + "                    \n"
                + "                                                    ) > 0\n"
                + "            JOIN Person \n"
                + "                 ON \n"
                + "                ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberPersonUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )    \n"
                + "        \n"
                + "        \n"
                + "               JOIN ScopedGrant ScopedGrantEntity\n"
                + "                    ON ScopedGrantEntity.sgTableId = 9\n"
                + "                       AND ScopedGrantEntity.sgEntityUid = Person.personUid \n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1 \n"
                + "         AND ScopedGrantEntity.sgLct != COALESCE(\n"
                + "             (SELECT sgVersionId\n"
                + "                FROM ScopedGrantReplicate\n"
                + "               WHERE sgPk = ScopedGrantEntity.sgUid\n"
                + "                 AND sgDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n"
                + "     SET sgPending = true\n"
                + "  */                                                       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChangeSchoolBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n"
                + "  SELECT DISTINCT ScopedGrantEntity.sgUid AS sgPk,\n"
                + "         UserSession.usClientNodeId AS sgDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN ScopedGrant ScopedGrantEntity\n"
                + "              ON ChangeLog.chTableId = 48\n"
                + "                 AND ChangeLog.chEntityPk = ScopedGrantEntity.sgUid\n"
                + "         JOIN School\n"
                + "              ON ScopedGrantEntity.sgTableId = 164\n"
                + "                 AND ScopedGrantEntity.sgEntityUid = School.schoolUid\n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n"
                + "        \n"
                + "                        AND (SCopedGrant.sgPermissions &\n"
                + "        \n"
                + "                  536870912\n"
                + "                  \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "                      \n"
                + "              \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "             SELECT nodeClientId \n"
                + "               FROM SyncNode\n"
                + "              LIMIT 1)\n"
                + "     AND ScopedGrantEntity.sgLct != COALESCE(\n"
                + "             (SELECT sgVersionId\n"
                + "                FROM ScopedGrantReplicate\n"
                + "               WHERE sgPk = ScopedGrantEntity.sgUid\n"
                + "                 AND sgDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n"
                + "     SET sgPending = true\n"
                + "  */                 \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnNewNodeSchoolBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ScopedGrantReplicate(sgPk, sgDestination)\n"
                + "      SELECT DISTINCT ScopedGrantEntity.sgUid AS sgPk,\n"
                + "             ? AS sgDestination\n"
                + "        FROM UserSession\n"
                + "               JOIN PersonGroupMember\n"
                + "                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "               \n"
                + "            JOIN ScopedGrant \n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions &\n"
                + "                 \n"
                + "        \n"
                + "                    536870912\n"
                + "                    \n"
                + "                    ) > 0\n"
                + "            JOIN School\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n"
                + "        \n"
                + "        \n"
                + "               JOIN ScopedGrant ScopedGrantEntity\n"
                + "                    ON ScopedGrantEntity.sgTableId = 164\n"
                + "                       AND ScopedGrantEntity.sgEntityUid = School.schoolUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1 \n"
                + "         AND ScopedGrantEntity.sgLct != COALESCE(\n"
                + "             (SELECT sgVersionId\n"
                + "                FROM ScopedGrantReplicate\n"
                + "               WHERE sgPk = ScopedGrantEntity.sgUid\n"
                + "                 AND sgDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(sgPk, sgDestination) DO UPDATE\n"
                + "     SET sgPending = true\n"
                + "  */                                                                                 \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertAsync(final ScopedGrant scopedGrant,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfScopedGrant.insertAndReturnId(scopedGrant);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object insertListAsync(final List<? extends ScopedGrant> scopedGrantList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfScopedGrant.insert(scopedGrantList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object updateAsync(final ScopedGrant scopedGrant,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfScopedGrant.handle(scopedGrant);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object updateListAsync(final List<? extends ScopedGrant> scopedGrantList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfScopedGrant.handleMultiple(scopedGrantList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChangeClazzBased(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChangeClazzBased.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChangeClazzBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNodeClazzBased(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNodeClazzBased.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNodeClazzBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChangePersonBased(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChangePersonBased.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChangePersonBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNodePersonBased(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNodePersonBased.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNodePersonBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChangeSchoolBased(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChangeSchoolBased.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChangeSchoolBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNodeSchoolBased(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNodeSchoolBased.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNodeSchoolBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findByTableIdAndEntityUid(final int tableId, final long entityUid,
      final Continuation<? super List<ScopedGrantAndName>> continuation) {
    final String _sql = "\n"
            + "        SELECT ScopedGrant.*,\n"
            + "               CASE\n"
            + "               WHEN Person.firstNames IS NOT NULL THEN Person.firstNames\n"
            + "               ELSE PersonGroup.groupName \n"
            + "               END AS name\n"
            + "          FROM ScopedGrant\n"
            + "               JOIN PersonGroup \n"
            + "                    ON ScopedGrant.sgGroupUid = PersonGroup.groupUid\n"
            + "               LEFT JOIN Person\n"
            + "                         ON Person.personGroupUid = PersonGroup.groupUid\n"
            + "         WHERE ScopedGrant.sgTableId = ?\n"
            + "               AND ScopedGrant.sgEntityUid = ?  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, tableId);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entityUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ScopedGrantAndName>>() {
      @Override
      public List<ScopedGrantAndName> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSgUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sgUid");
          final int _cursorIndexOfSgPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sgPcsn");
          final int _cursorIndexOfSgLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sgLcsn");
          final int _cursorIndexOfSgLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "sgLcb");
          final int _cursorIndexOfSgLct = CursorUtil.getColumnIndexOrThrow(_cursor, "sgLct");
          final int _cursorIndexOfSgTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "sgTableId");
          final int _cursorIndexOfSgEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sgEntityUid");
          final int _cursorIndexOfSgPermissions = CursorUtil.getColumnIndexOrThrow(_cursor, "sgPermissions");
          final int _cursorIndexOfSgGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sgGroupUid");
          final int _cursorIndexOfSgIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "sgIndex");
          final int _cursorIndexOfSgFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "sgFlags");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final List<ScopedGrantAndName> _result = new ArrayList<ScopedGrantAndName>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ScopedGrantAndName _item;
            final ScopedGrant _tmpScopedGrant;
            if (! (_cursor.isNull(_cursorIndexOfSgUid) && _cursor.isNull(_cursorIndexOfSgPcsn) && _cursor.isNull(_cursorIndexOfSgLcsn) && _cursor.isNull(_cursorIndexOfSgLcb) && _cursor.isNull(_cursorIndexOfSgLct) && _cursor.isNull(_cursorIndexOfSgTableId) && _cursor.isNull(_cursorIndexOfSgEntityUid) && _cursor.isNull(_cursorIndexOfSgPermissions) && _cursor.isNull(_cursorIndexOfSgGroupUid) && _cursor.isNull(_cursorIndexOfSgIndex) && _cursor.isNull(_cursorIndexOfSgFlags))) {
              _tmpScopedGrant = new ScopedGrant();
              final long _tmpSgUid;
              _tmpSgUid = _cursor.getLong(_cursorIndexOfSgUid);
              _tmpScopedGrant.setSgUid(_tmpSgUid);
              final long _tmpSgPcsn;
              _tmpSgPcsn = _cursor.getLong(_cursorIndexOfSgPcsn);
              _tmpScopedGrant.setSgPcsn(_tmpSgPcsn);
              final long _tmpSgLcsn;
              _tmpSgLcsn = _cursor.getLong(_cursorIndexOfSgLcsn);
              _tmpScopedGrant.setSgLcsn(_tmpSgLcsn);
              final int _tmpSgLcb;
              _tmpSgLcb = _cursor.getInt(_cursorIndexOfSgLcb);
              _tmpScopedGrant.setSgLcb(_tmpSgLcb);
              final long _tmpSgLct;
              _tmpSgLct = _cursor.getLong(_cursorIndexOfSgLct);
              _tmpScopedGrant.setSgLct(_tmpSgLct);
              final int _tmpSgTableId;
              _tmpSgTableId = _cursor.getInt(_cursorIndexOfSgTableId);
              _tmpScopedGrant.setSgTableId(_tmpSgTableId);
              final long _tmpSgEntityUid;
              _tmpSgEntityUid = _cursor.getLong(_cursorIndexOfSgEntityUid);
              _tmpScopedGrant.setSgEntityUid(_tmpSgEntityUid);
              final long _tmpSgPermissions;
              _tmpSgPermissions = _cursor.getLong(_cursorIndexOfSgPermissions);
              _tmpScopedGrant.setSgPermissions(_tmpSgPermissions);
              final long _tmpSgGroupUid;
              _tmpSgGroupUid = _cursor.getLong(_cursorIndexOfSgGroupUid);
              _tmpScopedGrant.setSgGroupUid(_tmpSgGroupUid);
              final int _tmpSgIndex;
              _tmpSgIndex = _cursor.getInt(_cursorIndexOfSgIndex);
              _tmpScopedGrant.setSgIndex(_tmpSgIndex);
              final int _tmpSgFlags;
              _tmpSgFlags = _cursor.getInt(_cursorIndexOfSgFlags);
              _tmpScopedGrant.setSgFlags(_tmpSgFlags);
            }  else  {
              _tmpScopedGrant = null;
            }
            _item = new ScopedGrantAndName();
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            _item.setName(_tmpName);
            _item.setScopedGrant(_tmpScopedGrant);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, ScopedGrantWithName> findByTableIdAndEntityUidWithNameAsDataSource(
      final int tableId, final long entityUid) {
    final String _sql = "\n"
            + "        SELECT ScopedGrant.*,\n"
            + "               CASE\n"
            + "               WHEN Person.firstNames IS NOT NULL THEN Person.firstNames\n"
            + "               ELSE PersonGroup.groupName \n"
            + "               END AS name\n"
            + "          FROM ScopedGrant\n"
            + "               JOIN PersonGroup \n"
            + "                    ON ScopedGrant.sgGroupUid = PersonGroup.groupUid\n"
            + "               LEFT JOIN Person\n"
            + "                         ON Person.personGroupUid = PersonGroup.groupUid\n"
            + "         WHERE ScopedGrant.sgTableId = ?\n"
            + "               AND ScopedGrant.sgEntityUid = ?  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, tableId);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entityUid);
    return new DataSource.Factory<Integer, ScopedGrantWithName>() {
      @Override
      public LimitOffsetDataSource<ScopedGrantWithName> create() {
        return new LimitOffsetDataSource<ScopedGrantWithName>(__db, _statement, false, true , "ScopedGrant", "PersonGroup", "Person") {
          @Override
          protected List<ScopedGrantWithName> convertRows(Cursor cursor) {
            final int _cursorIndexOfSgUid = CursorUtil.getColumnIndexOrThrow(cursor, "sgUid");
            final int _cursorIndexOfSgPcsn = CursorUtil.getColumnIndexOrThrow(cursor, "sgPcsn");
            final int _cursorIndexOfSgLcsn = CursorUtil.getColumnIndexOrThrow(cursor, "sgLcsn");
            final int _cursorIndexOfSgLcb = CursorUtil.getColumnIndexOrThrow(cursor, "sgLcb");
            final int _cursorIndexOfSgLct = CursorUtil.getColumnIndexOrThrow(cursor, "sgLct");
            final int _cursorIndexOfSgTableId = CursorUtil.getColumnIndexOrThrow(cursor, "sgTableId");
            final int _cursorIndexOfSgEntityUid = CursorUtil.getColumnIndexOrThrow(cursor, "sgEntityUid");
            final int _cursorIndexOfSgPermissions = CursorUtil.getColumnIndexOrThrow(cursor, "sgPermissions");
            final int _cursorIndexOfSgGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "sgGroupUid");
            final int _cursorIndexOfSgIndex = CursorUtil.getColumnIndexOrThrow(cursor, "sgIndex");
            final int _cursorIndexOfSgFlags = CursorUtil.getColumnIndexOrThrow(cursor, "sgFlags");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(cursor, "name");
            final List<ScopedGrantWithName> _res = new ArrayList<ScopedGrantWithName>(cursor.getCount());
            while(cursor.moveToNext()) {
              final ScopedGrantWithName _item;
              _item = new ScopedGrantWithName();
              final long _tmpSgUid;
              _tmpSgUid = cursor.getLong(_cursorIndexOfSgUid);
              _item.setSgUid(_tmpSgUid);
              final long _tmpSgPcsn;
              _tmpSgPcsn = cursor.getLong(_cursorIndexOfSgPcsn);
              _item.setSgPcsn(_tmpSgPcsn);
              final long _tmpSgLcsn;
              _tmpSgLcsn = cursor.getLong(_cursorIndexOfSgLcsn);
              _item.setSgLcsn(_tmpSgLcsn);
              final int _tmpSgLcb;
              _tmpSgLcb = cursor.getInt(_cursorIndexOfSgLcb);
              _item.setSgLcb(_tmpSgLcb);
              final long _tmpSgLct;
              _tmpSgLct = cursor.getLong(_cursorIndexOfSgLct);
              _item.setSgLct(_tmpSgLct);
              final int _tmpSgTableId;
              _tmpSgTableId = cursor.getInt(_cursorIndexOfSgTableId);
              _item.setSgTableId(_tmpSgTableId);
              final long _tmpSgEntityUid;
              _tmpSgEntityUid = cursor.getLong(_cursorIndexOfSgEntityUid);
              _item.setSgEntityUid(_tmpSgEntityUid);
              final long _tmpSgPermissions;
              _tmpSgPermissions = cursor.getLong(_cursorIndexOfSgPermissions);
              _item.setSgPermissions(_tmpSgPermissions);
              final long _tmpSgGroupUid;
              _tmpSgGroupUid = cursor.getLong(_cursorIndexOfSgGroupUid);
              _item.setSgGroupUid(_tmpSgGroupUid);
              final int _tmpSgIndex;
              _tmpSgIndex = cursor.getInt(_cursorIndexOfSgIndex);
              _item.setSgIndex(_tmpSgIndex);
              final int _tmpSgFlags;
              _tmpSgFlags = cursor.getInt(_cursorIndexOfSgFlags);
              _item.setSgFlags(_tmpSgFlags);
              final String _tmpName;
              if (cursor.isNull(_cursorIndexOfName)) {
                _tmpName = null;
              } else {
                _tmpName = cursor.getString(_cursorIndexOfName);
              }
              _item.setName(_tmpName);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public List<ScopedGrant> findByTableIdAndEntityIdSync(final int tableId, final long entityUid) {
    final String _sql = "\n"
            + "        SELECT ScopedGrant.*\n"
            + "          FROM ScopedGrant\n"
            + "         WHERE sgTableId = ?\n"
            + "           AND sgEntityUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, tableId);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entityUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfSgUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sgUid");
      final int _cursorIndexOfSgPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sgPcsn");
      final int _cursorIndexOfSgLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sgLcsn");
      final int _cursorIndexOfSgLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "sgLcb");
      final int _cursorIndexOfSgLct = CursorUtil.getColumnIndexOrThrow(_cursor, "sgLct");
      final int _cursorIndexOfSgTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "sgTableId");
      final int _cursorIndexOfSgEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sgEntityUid");
      final int _cursorIndexOfSgPermissions = CursorUtil.getColumnIndexOrThrow(_cursor, "sgPermissions");
      final int _cursorIndexOfSgGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sgGroupUid");
      final int _cursorIndexOfSgIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "sgIndex");
      final int _cursorIndexOfSgFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "sgFlags");
      final List<ScopedGrant> _result = new ArrayList<ScopedGrant>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ScopedGrant _item;
        _item = new ScopedGrant();
        final long _tmpSgUid;
        _tmpSgUid = _cursor.getLong(_cursorIndexOfSgUid);
        _item.setSgUid(_tmpSgUid);
        final long _tmpSgPcsn;
        _tmpSgPcsn = _cursor.getLong(_cursorIndexOfSgPcsn);
        _item.setSgPcsn(_tmpSgPcsn);
        final long _tmpSgLcsn;
        _tmpSgLcsn = _cursor.getLong(_cursorIndexOfSgLcsn);
        _item.setSgLcsn(_tmpSgLcsn);
        final int _tmpSgLcb;
        _tmpSgLcb = _cursor.getInt(_cursorIndexOfSgLcb);
        _item.setSgLcb(_tmpSgLcb);
        final long _tmpSgLct;
        _tmpSgLct = _cursor.getLong(_cursorIndexOfSgLct);
        _item.setSgLct(_tmpSgLct);
        final int _tmpSgTableId;
        _tmpSgTableId = _cursor.getInt(_cursorIndexOfSgTableId);
        _item.setSgTableId(_tmpSgTableId);
        final long _tmpSgEntityUid;
        _tmpSgEntityUid = _cursor.getLong(_cursorIndexOfSgEntityUid);
        _item.setSgEntityUid(_tmpSgEntityUid);
        final long _tmpSgPermissions;
        _tmpSgPermissions = _cursor.getLong(_cursorIndexOfSgPermissions);
        _item.setSgPermissions(_tmpSgPermissions);
        final long _tmpSgGroupUid;
        _tmpSgGroupUid = _cursor.getLong(_cursorIndexOfSgGroupUid);
        _item.setSgGroupUid(_tmpSgGroupUid);
        final int _tmpSgIndex;
        _tmpSgIndex = _cursor.getInt(_cursorIndexOfSgIndex);
        _item.setSgIndex(_tmpSgIndex);
        final int _tmpSgFlags;
        _tmpSgFlags = _cursor.getInt(_cursorIndexOfSgFlags);
        _item.setSgFlags(_tmpSgFlags);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByUid(final long sgUid, final Continuation<? super ScopedGrant> continuation) {
    final String _sql = "\n"
            + "        SELECT ScopedGrant.*\n"
            + "          FROM ScopedGrant\n"
            + "         WHERE sgUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, sgUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ScopedGrant>() {
      @Override
      public ScopedGrant call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSgUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sgUid");
          final int _cursorIndexOfSgPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sgPcsn");
          final int _cursorIndexOfSgLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sgLcsn");
          final int _cursorIndexOfSgLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "sgLcb");
          final int _cursorIndexOfSgLct = CursorUtil.getColumnIndexOrThrow(_cursor, "sgLct");
          final int _cursorIndexOfSgTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "sgTableId");
          final int _cursorIndexOfSgEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sgEntityUid");
          final int _cursorIndexOfSgPermissions = CursorUtil.getColumnIndexOrThrow(_cursor, "sgPermissions");
          final int _cursorIndexOfSgGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sgGroupUid");
          final int _cursorIndexOfSgIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "sgIndex");
          final int _cursorIndexOfSgFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "sgFlags");
          final ScopedGrant _result;
          if(_cursor.moveToFirst()) {
            _result = new ScopedGrant();
            final long _tmpSgUid;
            _tmpSgUid = _cursor.getLong(_cursorIndexOfSgUid);
            _result.setSgUid(_tmpSgUid);
            final long _tmpSgPcsn;
            _tmpSgPcsn = _cursor.getLong(_cursorIndexOfSgPcsn);
            _result.setSgPcsn(_tmpSgPcsn);
            final long _tmpSgLcsn;
            _tmpSgLcsn = _cursor.getLong(_cursorIndexOfSgLcsn);
            _result.setSgLcsn(_tmpSgLcsn);
            final int _tmpSgLcb;
            _tmpSgLcb = _cursor.getInt(_cursorIndexOfSgLcb);
            _result.setSgLcb(_tmpSgLcb);
            final long _tmpSgLct;
            _tmpSgLct = _cursor.getLong(_cursorIndexOfSgLct);
            _result.setSgLct(_tmpSgLct);
            final int _tmpSgTableId;
            _tmpSgTableId = _cursor.getInt(_cursorIndexOfSgTableId);
            _result.setSgTableId(_tmpSgTableId);
            final long _tmpSgEntityUid;
            _tmpSgEntityUid = _cursor.getLong(_cursorIndexOfSgEntityUid);
            _result.setSgEntityUid(_tmpSgEntityUid);
            final long _tmpSgPermissions;
            _tmpSgPermissions = _cursor.getLong(_cursorIndexOfSgPermissions);
            _result.setSgPermissions(_tmpSgPermissions);
            final long _tmpSgGroupUid;
            _tmpSgGroupUid = _cursor.getLong(_cursorIndexOfSgGroupUid);
            _result.setSgGroupUid(_tmpSgGroupUid);
            final int _tmpSgIndex;
            _tmpSgIndex = _cursor.getInt(_cursorIndexOfSgIndex);
            _result.setSgIndex(_tmpSgIndex);
            final int _tmpSgFlags;
            _tmpSgFlags = _cursor.getInt(_cursorIndexOfSgFlags);
            _result.setSgFlags(_tmpSgFlags);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<ScopedGrantWithName> findByUidLiveWithName(final long sgUid) {
    final String _sql = "\n"
            + "        SELECT ScopedGrant.*, \n"
            + "               CASE\n"
            + "               WHEN Person.firstNames IS NOT NULL THEN Person.firstNames\n"
            + "               ELSE PersonGroup.groupName \n"
            + "               END AS name\n"
            + "          FROM ScopedGrant\n"
            + "               LEFT JOIN PersonGroup \n"
            + "                    ON ScopedGrant.sgGroupUid = PersonGroup.groupUid\n"
            + "               LEFT JOIN Person\n"
            + "                    ON Person.personGroupUid = PersonGroup.groupUid\n"
            + "         WHERE ScopedGrant.sgUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, sgUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ScopedGrant","PersonGroup","Person"}, false, new Callable<ScopedGrantWithName>() {
      @Override
      public ScopedGrantWithName call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSgUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sgUid");
          final int _cursorIndexOfSgPcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sgPcsn");
          final int _cursorIndexOfSgLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sgLcsn");
          final int _cursorIndexOfSgLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "sgLcb");
          final int _cursorIndexOfSgLct = CursorUtil.getColumnIndexOrThrow(_cursor, "sgLct");
          final int _cursorIndexOfSgTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "sgTableId");
          final int _cursorIndexOfSgEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sgEntityUid");
          final int _cursorIndexOfSgPermissions = CursorUtil.getColumnIndexOrThrow(_cursor, "sgPermissions");
          final int _cursorIndexOfSgGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "sgGroupUid");
          final int _cursorIndexOfSgIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "sgIndex");
          final int _cursorIndexOfSgFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "sgFlags");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final ScopedGrantWithName _result;
          if(_cursor.moveToFirst()) {
            _result = new ScopedGrantWithName();
            final long _tmpSgUid;
            _tmpSgUid = _cursor.getLong(_cursorIndexOfSgUid);
            _result.setSgUid(_tmpSgUid);
            final long _tmpSgPcsn;
            _tmpSgPcsn = _cursor.getLong(_cursorIndexOfSgPcsn);
            _result.setSgPcsn(_tmpSgPcsn);
            final long _tmpSgLcsn;
            _tmpSgLcsn = _cursor.getLong(_cursorIndexOfSgLcsn);
            _result.setSgLcsn(_tmpSgLcsn);
            final int _tmpSgLcb;
            _tmpSgLcb = _cursor.getInt(_cursorIndexOfSgLcb);
            _result.setSgLcb(_tmpSgLcb);
            final long _tmpSgLct;
            _tmpSgLct = _cursor.getLong(_cursorIndexOfSgLct);
            _result.setSgLct(_tmpSgLct);
            final int _tmpSgTableId;
            _tmpSgTableId = _cursor.getInt(_cursorIndexOfSgTableId);
            _result.setSgTableId(_tmpSgTableId);
            final long _tmpSgEntityUid;
            _tmpSgEntityUid = _cursor.getLong(_cursorIndexOfSgEntityUid);
            _result.setSgEntityUid(_tmpSgEntityUid);
            final long _tmpSgPermissions;
            _tmpSgPermissions = _cursor.getLong(_cursorIndexOfSgPermissions);
            _result.setSgPermissions(_tmpSgPermissions);
            final long _tmpSgGroupUid;
            _tmpSgGroupUid = _cursor.getLong(_cursorIndexOfSgGroupUid);
            _result.setSgGroupUid(_tmpSgGroupUid);
            final int _tmpSgIndex;
            _tmpSgIndex = _cursor.getInt(_cursorIndexOfSgIndex);
            _result.setSgIndex(_tmpSgIndex);
            final int _tmpSgFlags;
            _tmpSgFlags = _cursor.getInt(_cursorIndexOfSgFlags);
            _result.setSgFlags(_tmpSgFlags);
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            _result.setName(_tmpName);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
