package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.XLangMapEntry;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class XLangMapEntryDao_Impl extends XLangMapEntryDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<XLangMapEntry> __insertionAdapterOfXLangMapEntry;

  private final EntityDeletionOrUpdateAdapter<XLangMapEntry> __updateAdapterOfXLangMapEntry;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public XLangMapEntryDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfXLangMapEntry = new EntityInsertionAdapter<XLangMapEntry>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `XLangMapEntry` (`verbLangMapUid`,`objectLangMapUid`,`languageLangMapUid`,`languageVariantLangMapUid`,`valueLangMap`,`statementLangMapMasterCsn`,`statementLangMapLocalCsn`,`statementLangMapLcb`,`statementLangMapLct`,`statementLangMapUid`) VALUES (?,?,?,?,?,?,?,?,?,nullif(?, 0))";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, XLangMapEntry value) {
        stmt.bindLong(1, value.getVerbLangMapUid());
        stmt.bindLong(2, value.getObjectLangMapUid());
        stmt.bindLong(3, value.getLanguageLangMapUid());
        stmt.bindLong(4, value.getLanguageVariantLangMapUid());
        if (value.getValueLangMap() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getValueLangMap());
        }
        stmt.bindLong(6, value.getStatementLangMapMasterCsn());
        stmt.bindLong(7, value.getStatementLangMapLocalCsn());
        stmt.bindLong(8, value.getStatementLangMapLcb());
        stmt.bindLong(9, value.getStatementLangMapLct());
        stmt.bindLong(10, value.getStatementLangMapUid());
      }
    };
    this.__updateAdapterOfXLangMapEntry = new EntityDeletionOrUpdateAdapter<XLangMapEntry>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `XLangMapEntry` SET `verbLangMapUid` = ?,`objectLangMapUid` = ?,`languageLangMapUid` = ?,`languageVariantLangMapUid` = ?,`valueLangMap` = ?,`statementLangMapMasterCsn` = ?,`statementLangMapLocalCsn` = ?,`statementLangMapLcb` = ?,`statementLangMapLct` = ?,`statementLangMapUid` = ? WHERE `statementLangMapUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, XLangMapEntry value) {
        stmt.bindLong(1, value.getVerbLangMapUid());
        stmt.bindLong(2, value.getObjectLangMapUid());
        stmt.bindLong(3, value.getLanguageLangMapUid());
        stmt.bindLong(4, value.getLanguageVariantLangMapUid());
        if (value.getValueLangMap() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getValueLangMap());
        }
        stmt.bindLong(6, value.getStatementLangMapMasterCsn());
        stmt.bindLong(7, value.getStatementLangMapLocalCsn());
        stmt.bindLong(8, value.getStatementLangMapLcb());
        stmt.bindLong(9, value.getStatementLangMapLct());
        stmt.bindLong(10, value.getStatementLangMapUid());
        stmt.bindLong(11, value.getStatementLangMapUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "         REPLACE INTO XLangMapEntryReplicate(xlmePk, xlmeDestination)\n"
                + "          SELECT DISTINCT XLangMapEntry.statementLangMapUid AS xlmePk,\n"
                + "                 ? AS xlmeDestination\n"
                + "            FROM XLangMapEntry\n"
                + "                 JOIN UserSession ON UserSession.usClientNodeId = ?\n"
                + "             --notpsql      \n"
                + "             WHERE XLangMapEntry.statementLangMapLct != COALESCE(\n"
                + "                 (SELECT xlmeVersionId\n"
                + "                    FROM XLangMapEntryReplicate\n"
                + "                   WHERE xlmePk = XLangMapEntry.statementLangMapUid\n"
                + "                     AND xlmeDestination = UserSession.usClientNodeId), 0)\n"
                + "             --endnotpsql         \n"
                + "          /*psql ON CONFLICT(xlmePk, xlmeDestination) DO UPDATE\n"
                + "                 SET xlmePending = (SELECT XLangMapEntry.statementLangMapLct\n"
                + "                                      FROM XLangmapEntry\n"
                + "                                     WHERE XLangmapEntry.statementLangMapUid = EXCLUDED.xlmePk)\n"
                + "                                        != XLangMapEntryReplicate.xlmeVersionId\n"
                + "          */       \n"
                + "     ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO XLangMapEntryReplicate(xlmePk, xlmeDestination)\n"
                + "  SELECT DISTINCT XLangMapEntry.statementLangMapUid AS xlmeUid,\n"
                + "         UserSession.usClientNodeId AS xlmeDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN XLangMapEntry\n"
                + "             ON ChangeLog.chTableId = 74\n"
                + "                AND ChangeLog.chEntityPk = XLangMapEntry.statementLangMapUid\n"
                + "         JOIN UserSession ON UserSession.usStatus = 1\n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND XLangMapEntry.statementLangMapLct != COALESCE(\n"
                + "         (SELECT xlmeVersionId\n"
                + "            FROM XLangMapEntryReplicate\n"
                + "           WHERE xlmePk = XLangMapEntry.statementLangMapUid\n"
                + "             AND xlmeDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(xlmePk, xlmeDestination) DO UPDATE\n"
                + "     SET xlmePending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final XLangMapEntry entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfXLangMapEntry.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final XLangMapEntry entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfXLangMapEntry.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends XLangMapEntry> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfXLangMapEntry.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends XLangMapEntry> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfXLangMapEntry.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final XLangMapEntry entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfXLangMapEntry.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object getValuesWithListOfId(final List<Integer> ids,
      final Continuation<? super List<XLangMapEntry>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT * FROM XLangMapEntry WHERE objectLangMapUid IN (");
    final int _inputSize = ids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (int _item : ids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<XLangMapEntry>>() {
      @Override
      public List<XLangMapEntry> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfVerbLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "verbLangMapUid");
          final int _cursorIndexOfObjectLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "objectLangMapUid");
          final int _cursorIndexOfLanguageLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageLangMapUid");
          final int _cursorIndexOfLanguageVariantLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantLangMapUid");
          final int _cursorIndexOfValueLangMap = CursorUtil.getColumnIndexOrThrow(_cursor, "valueLangMap");
          final int _cursorIndexOfStatementLangMapMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapMasterCsn");
          final int _cursorIndexOfStatementLangMapLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapLocalCsn");
          final int _cursorIndexOfStatementLangMapLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapLcb");
          final int _cursorIndexOfStatementLangMapLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapLct");
          final int _cursorIndexOfStatementLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapUid");
          final List<XLangMapEntry> _result = new ArrayList<XLangMapEntry>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final XLangMapEntry _item_1;
            final long _tmpVerbLangMapUid;
            _tmpVerbLangMapUid = _cursor.getLong(_cursorIndexOfVerbLangMapUid);
            final long _tmpObjectLangMapUid;
            _tmpObjectLangMapUid = _cursor.getLong(_cursorIndexOfObjectLangMapUid);
            final long _tmpLanguageLangMapUid;
            _tmpLanguageLangMapUid = _cursor.getLong(_cursorIndexOfLanguageLangMapUid);
            final long _tmpLanguageVariantLangMapUid;
            _tmpLanguageVariantLangMapUid = _cursor.getLong(_cursorIndexOfLanguageVariantLangMapUid);
            final String _tmpValueLangMap;
            if (_cursor.isNull(_cursorIndexOfValueLangMap)) {
              _tmpValueLangMap = null;
            } else {
              _tmpValueLangMap = _cursor.getString(_cursorIndexOfValueLangMap);
            }
            final int _tmpStatementLangMapMasterCsn;
            _tmpStatementLangMapMasterCsn = _cursor.getInt(_cursorIndexOfStatementLangMapMasterCsn);
            final int _tmpStatementLangMapLocalCsn;
            _tmpStatementLangMapLocalCsn = _cursor.getInt(_cursorIndexOfStatementLangMapLocalCsn);
            final int _tmpStatementLangMapLcb;
            _tmpStatementLangMapLcb = _cursor.getInt(_cursorIndexOfStatementLangMapLcb);
            final long _tmpStatementLangMapLct;
            _tmpStatementLangMapLct = _cursor.getLong(_cursorIndexOfStatementLangMapLct);
            _item_1 = new XLangMapEntry(_tmpVerbLangMapUid,_tmpObjectLangMapUid,_tmpLanguageLangMapUid,_tmpLanguageVariantLangMapUid,_tmpValueLangMap,_tmpStatementLangMapMasterCsn,_tmpStatementLangMapLocalCsn,_tmpStatementLangMapLcb,_tmpStatementLangMapLct);
            final long _tmpStatementLangMapUid;
            _tmpStatementLangMapUid = _cursor.getLong(_cursorIndexOfStatementLangMapUid);
            _item_1.setStatementLangMapUid(_tmpStatementLangMapUid);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public XLangMapEntry getXLangMapFromVerb(final long verbUid, final long langMapUid) {
    final String _sql = "SELECT * FROM XLangMapEntry WHERE \n"
            + "            verbLangMapUid = ? AND languageLangMapUid = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, verbUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, langMapUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfVerbLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "verbLangMapUid");
      final int _cursorIndexOfObjectLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "objectLangMapUid");
      final int _cursorIndexOfLanguageLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageLangMapUid");
      final int _cursorIndexOfLanguageVariantLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantLangMapUid");
      final int _cursorIndexOfValueLangMap = CursorUtil.getColumnIndexOrThrow(_cursor, "valueLangMap");
      final int _cursorIndexOfStatementLangMapMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapMasterCsn");
      final int _cursorIndexOfStatementLangMapLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapLocalCsn");
      final int _cursorIndexOfStatementLangMapLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapLcb");
      final int _cursorIndexOfStatementLangMapLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapLct");
      final int _cursorIndexOfStatementLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapUid");
      final XLangMapEntry _result;
      if(_cursor.moveToFirst()) {
        final long _tmpVerbLangMapUid;
        _tmpVerbLangMapUid = _cursor.getLong(_cursorIndexOfVerbLangMapUid);
        final long _tmpObjectLangMapUid;
        _tmpObjectLangMapUid = _cursor.getLong(_cursorIndexOfObjectLangMapUid);
        final long _tmpLanguageLangMapUid;
        _tmpLanguageLangMapUid = _cursor.getLong(_cursorIndexOfLanguageLangMapUid);
        final long _tmpLanguageVariantLangMapUid;
        _tmpLanguageVariantLangMapUid = _cursor.getLong(_cursorIndexOfLanguageVariantLangMapUid);
        final String _tmpValueLangMap;
        if (_cursor.isNull(_cursorIndexOfValueLangMap)) {
          _tmpValueLangMap = null;
        } else {
          _tmpValueLangMap = _cursor.getString(_cursorIndexOfValueLangMap);
        }
        final int _tmpStatementLangMapMasterCsn;
        _tmpStatementLangMapMasterCsn = _cursor.getInt(_cursorIndexOfStatementLangMapMasterCsn);
        final int _tmpStatementLangMapLocalCsn;
        _tmpStatementLangMapLocalCsn = _cursor.getInt(_cursorIndexOfStatementLangMapLocalCsn);
        final int _tmpStatementLangMapLcb;
        _tmpStatementLangMapLcb = _cursor.getInt(_cursorIndexOfStatementLangMapLcb);
        final long _tmpStatementLangMapLct;
        _tmpStatementLangMapLct = _cursor.getLong(_cursorIndexOfStatementLangMapLct);
        _result = new XLangMapEntry(_tmpVerbLangMapUid,_tmpObjectLangMapUid,_tmpLanguageLangMapUid,_tmpLanguageVariantLangMapUid,_tmpValueLangMap,_tmpStatementLangMapMasterCsn,_tmpStatementLangMapLocalCsn,_tmpStatementLangMapLcb,_tmpStatementLangMapLct);
        final long _tmpStatementLangMapUid;
        _tmpStatementLangMapUid = _cursor.getLong(_cursorIndexOfStatementLangMapUid);
        _result.setStatementLangMapUid(_tmpStatementLangMapUid);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public XLangMapEntry getXLangMapFromObject(final long objectUid, final long langMapUid) {
    final String _sql = "SELECT * FROM XLangMapEntry WHERE \n"
            + "            objectLangMapUid = ? AND languageLangMapUid = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, objectUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, langMapUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfVerbLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "verbLangMapUid");
      final int _cursorIndexOfObjectLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "objectLangMapUid");
      final int _cursorIndexOfLanguageLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageLangMapUid");
      final int _cursorIndexOfLanguageVariantLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantLangMapUid");
      final int _cursorIndexOfValueLangMap = CursorUtil.getColumnIndexOrThrow(_cursor, "valueLangMap");
      final int _cursorIndexOfStatementLangMapMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapMasterCsn");
      final int _cursorIndexOfStatementLangMapLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapLocalCsn");
      final int _cursorIndexOfStatementLangMapLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapLcb");
      final int _cursorIndexOfStatementLangMapLct = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapLct");
      final int _cursorIndexOfStatementLangMapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "statementLangMapUid");
      final XLangMapEntry _result;
      if(_cursor.moveToFirst()) {
        final long _tmpVerbLangMapUid;
        _tmpVerbLangMapUid = _cursor.getLong(_cursorIndexOfVerbLangMapUid);
        final long _tmpObjectLangMapUid;
        _tmpObjectLangMapUid = _cursor.getLong(_cursorIndexOfObjectLangMapUid);
        final long _tmpLanguageLangMapUid;
        _tmpLanguageLangMapUid = _cursor.getLong(_cursorIndexOfLanguageLangMapUid);
        final long _tmpLanguageVariantLangMapUid;
        _tmpLanguageVariantLangMapUid = _cursor.getLong(_cursorIndexOfLanguageVariantLangMapUid);
        final String _tmpValueLangMap;
        if (_cursor.isNull(_cursorIndexOfValueLangMap)) {
          _tmpValueLangMap = null;
        } else {
          _tmpValueLangMap = _cursor.getString(_cursorIndexOfValueLangMap);
        }
        final int _tmpStatementLangMapMasterCsn;
        _tmpStatementLangMapMasterCsn = _cursor.getInt(_cursorIndexOfStatementLangMapMasterCsn);
        final int _tmpStatementLangMapLocalCsn;
        _tmpStatementLangMapLocalCsn = _cursor.getInt(_cursorIndexOfStatementLangMapLocalCsn);
        final int _tmpStatementLangMapLcb;
        _tmpStatementLangMapLcb = _cursor.getInt(_cursorIndexOfStatementLangMapLcb);
        final long _tmpStatementLangMapLct;
        _tmpStatementLangMapLct = _cursor.getLong(_cursorIndexOfStatementLangMapLct);
        _result = new XLangMapEntry(_tmpVerbLangMapUid,_tmpObjectLangMapUid,_tmpLanguageLangMapUid,_tmpLanguageVariantLangMapUid,_tmpValueLangMap,_tmpStatementLangMapMasterCsn,_tmpStatementLangMapLocalCsn,_tmpStatementLangMapLcb,_tmpStatementLangMapLct);
        final long _tmpStatementLangMapUid;
        _tmpStatementLangMapUid = _cursor.getLong(_cursorIndexOfStatementLangMapUid);
        _result.setStatementLangMapUid(_tmpStatementLangMapUid);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
