package com.ustadmobile.core.db

import com.ustadmobile.door.DoorDatabaseCallbackSync
import com.ustadmobile.door.DoorSqlDatabase
import kotlin.Unit

public class UmAppDatabase_AndroidReplicationCallback : DoorDatabaseCallbackSync {
  public override fun onCreate(db: DoorSqlDatabase): Unit {
    val _stmtList = mutableListOf<String>()
    _stmtList +=
        " CREATE TRIGGER ch_ins_14 AFTER INSERT ON ClazzLog BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 14 AS chTableId, NEW.clazzLogUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 14 AND chEntityPk = NEW.clazzLogUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_14 AFTER UPDATE ON ClazzLog BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 14 AS chTableId, NEW.clazzLogUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 14 AND chEntityPk = NEW.clazzLogUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_14 AFTER DELETE ON ClazzLog BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 14 AS chTableId, OLD.clazzLogUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 14 AND chEntityPk = OLD.clazzLogUid); END "
    _stmtList +=
        "CREATE VIEW ClazzLog_ReceiveView AS  SELECT ClazzLog.*, ClazzLogReplicate.* FROM ClazzLog LEFT JOIN ClazzLogReplicate ON ClazzLogReplicate.clPk = ClazzLog.clazzLogUid "
    _stmtList +=
        " CREATE TRIGGER clazzlog_remote_insert_ins INSTEAD OF INSERT ON ClazzLog_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ClazzLog(clazzLogUid, clazzLogClazzUid, logDate, timeRecorded, clazzLogDone, cancellationNote, clazzLogCancelled, clazzLogNumPresent, clazzLogNumAbsent, clazzLogNumPartial, clazzLogScheduleUid, clazzLogStatusFlag, clazzLogMSQN, clazzLogLCSN, clazzLogLCB, clazzLogLastChangedTime) VALUES (NEW.clazzLogUid, NEW.clazzLogClazzUid, NEW.logDate, NEW.timeRecorded, NEW.clazzLogDone, NEW.cancellationNote, NEW.clazzLogCancelled, NEW.clazzLogNumPresent, NEW.clazzLogNumAbsent, NEW.clazzLogNumPartial, NEW.clazzLogScheduleUid, NEW.clazzLogStatusFlag, NEW.clazzLogMSQN, NEW.clazzLogLCSN, NEW.clazzLogLCB, NEW.clazzLogLastChangedTime) /*psql ON CONFLICT (clazzLogUid) DO UPDATE SET clazzLogClazzUid = EXCLUDED.clazzLogClazzUid, logDate = EXCLUDED.logDate, timeRecorded = EXCLUDED.timeRecorded, clazzLogDone = EXCLUDED.clazzLogDone, cancellationNote = EXCLUDED.cancellationNote, clazzLogCancelled = EXCLUDED.clazzLogCancelled, clazzLogNumPresent = EXCLUDED.clazzLogNumPresent, clazzLogNumAbsent = EXCLUDED.clazzLogNumAbsent, clazzLogNumPartial = EXCLUDED.clazzLogNumPartial, clazzLogScheduleUid = EXCLUDED.clazzLogScheduleUid, clazzLogStatusFlag = EXCLUDED.clazzLogStatusFlag, clazzLogMSQN = EXCLUDED.clazzLogMSQN, clazzLogLCSN = EXCLUDED.clazzLogLCSN, clazzLogLCB = EXCLUDED.clazzLogLCB, clazzLogLastChangedTime = EXCLUDED.clazzLogLastChangedTime */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_15 AFTER INSERT ON ClazzLogAttendanceRecord BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 15 AS chTableId, NEW.clazzLogAttendanceRecordUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 15 AND chEntityPk = NEW.clazzLogAttendanceRecordUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_15 AFTER UPDATE ON ClazzLogAttendanceRecord BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 15 AS chTableId, NEW.clazzLogAttendanceRecordUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 15 AND chEntityPk = NEW.clazzLogAttendanceRecordUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_15 AFTER DELETE ON ClazzLogAttendanceRecord BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 15 AS chTableId, OLD.clazzLogAttendanceRecordUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 15 AND chEntityPk = OLD.clazzLogAttendanceRecordUid); END "
    _stmtList +=
        "CREATE VIEW ClazzLogAttendanceRecord_ReceiveView AS  SELECT ClazzLogAttendanceRecord.*, ClazzLogAttendanceRecordReplicate.* FROM ClazzLogAttendanceRecord LEFT JOIN ClazzLogAttendanceRecordReplicate ON ClazzLogAttendanceRecordReplicate.clarPk = ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid "
    _stmtList +=
        " CREATE TRIGGER clazzlogattendancerecord_remote_insert_ins INSTEAD OF INSERT ON ClazzLogAttendanceRecord_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ClazzLogAttendanceRecord(clazzLogAttendanceRecordUid, clazzLogAttendanceRecordClazzLogUid, clazzLogAttendanceRecordPersonUid, attendanceStatus, clazzLogAttendanceRecordMasterChangeSeqNum, clazzLogAttendanceRecordLocalChangeSeqNum, clazzLogAttendanceRecordLastChangedBy, clazzLogAttendanceRecordLastChangedTime) VALUES (NEW.clazzLogAttendanceRecordUid, NEW.clazzLogAttendanceRecordClazzLogUid, NEW.clazzLogAttendanceRecordPersonUid, NEW.attendanceStatus, NEW.clazzLogAttendanceRecordMasterChangeSeqNum, NEW.clazzLogAttendanceRecordLocalChangeSeqNum, NEW.clazzLogAttendanceRecordLastChangedBy, NEW.clazzLogAttendanceRecordLastChangedTime) /*psql ON CONFLICT (clazzLogAttendanceRecordUid) DO UPDATE SET clazzLogAttendanceRecordClazzLogUid = EXCLUDED.clazzLogAttendanceRecordClazzLogUid, clazzLogAttendanceRecordPersonUid = EXCLUDED.clazzLogAttendanceRecordPersonUid, attendanceStatus = EXCLUDED.attendanceStatus, clazzLogAttendanceRecordMasterChangeSeqNum = EXCLUDED.clazzLogAttendanceRecordMasterChangeSeqNum, clazzLogAttendanceRecordLocalChangeSeqNum = EXCLUDED.clazzLogAttendanceRecordLocalChangeSeqNum, clazzLogAttendanceRecordLastChangedBy = EXCLUDED.clazzLogAttendanceRecordLastChangedBy, clazzLogAttendanceRecordLastChangedTime = EXCLUDED.clazzLogAttendanceRecordLastChangedTime */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_21 AFTER INSERT ON Schedule BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 21 AS chTableId, NEW.scheduleUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 21 AND chEntityPk = NEW.scheduleUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_21 AFTER UPDATE ON Schedule BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 21 AS chTableId, NEW.scheduleUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 21 AND chEntityPk = NEW.scheduleUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_21 AFTER DELETE ON Schedule BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 21 AS chTableId, OLD.scheduleUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 21 AND chEntityPk = OLD.scheduleUid); END "
    _stmtList +=
        "CREATE VIEW Schedule_ReceiveView AS  SELECT Schedule.*, ScheduleReplicate.* FROM Schedule LEFT JOIN ScheduleReplicate ON ScheduleReplicate.schedulePk = Schedule.scheduleUid "
    _stmtList +=
        " CREATE TRIGGER schedule_remote_insert_ins INSTEAD OF INSERT ON Schedule_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Schedule(scheduleUid, sceduleStartTime, scheduleEndTime, scheduleDay, scheduleMonth, scheduleFrequency, umCalendarUid, scheduleClazzUid, scheduleMasterChangeSeqNum, scheduleLocalChangeSeqNum, scheduleLastChangedBy, scheduleLastChangedTime, scheduleActive) VALUES (NEW.scheduleUid, NEW.sceduleStartTime, NEW.scheduleEndTime, NEW.scheduleDay, NEW.scheduleMonth, NEW.scheduleFrequency, NEW.umCalendarUid, NEW.scheduleClazzUid, NEW.scheduleMasterChangeSeqNum, NEW.scheduleLocalChangeSeqNum, NEW.scheduleLastChangedBy, NEW.scheduleLastChangedTime, NEW.scheduleActive) /*psql ON CONFLICT (scheduleUid) DO UPDATE SET sceduleStartTime = EXCLUDED.sceduleStartTime, scheduleEndTime = EXCLUDED.scheduleEndTime, scheduleDay = EXCLUDED.scheduleDay, scheduleMonth = EXCLUDED.scheduleMonth, scheduleFrequency = EXCLUDED.scheduleFrequency, umCalendarUid = EXCLUDED.umCalendarUid, scheduleClazzUid = EXCLUDED.scheduleClazzUid, scheduleMasterChangeSeqNum = EXCLUDED.scheduleMasterChangeSeqNum, scheduleLocalChangeSeqNum = EXCLUDED.scheduleLocalChangeSeqNum, scheduleLastChangedBy = EXCLUDED.scheduleLastChangedBy, scheduleLastChangedTime = EXCLUDED.scheduleLastChangedTime, scheduleActive = EXCLUDED.scheduleActive */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_28 AFTER INSERT ON HolidayCalendar BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 28 AS chTableId, NEW.umCalendarUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 28 AND chEntityPk = NEW.umCalendarUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_28 AFTER UPDATE ON HolidayCalendar BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 28 AS chTableId, NEW.umCalendarUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 28 AND chEntityPk = NEW.umCalendarUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_28 AFTER DELETE ON HolidayCalendar BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 28 AS chTableId, OLD.umCalendarUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 28 AND chEntityPk = OLD.umCalendarUid); END "
    _stmtList +=
        "CREATE VIEW HolidayCalendar_ReceiveView AS  SELECT HolidayCalendar.*, HolidayCalendarReplicate.* FROM HolidayCalendar LEFT JOIN HolidayCalendarReplicate ON HolidayCalendarReplicate.hcPk = HolidayCalendar.umCalendarUid "
    _stmtList +=
        " CREATE TRIGGER holidaycalendar_remote_insert_ins INSTEAD OF INSERT ON HolidayCalendar_ReceiveView FOR EACH ROW BEGIN REPLACE INTO HolidayCalendar(umCalendarUid, umCalendarName, umCalendarCategory, umCalendarActive, umCalendarMasterChangeSeqNum, umCalendarLocalChangeSeqNum, umCalendarLastChangedBy, umCalendarLct) VALUES (NEW.umCalendarUid, NEW.umCalendarName, NEW.umCalendarCategory, NEW.umCalendarActive, NEW.umCalendarMasterChangeSeqNum, NEW.umCalendarLocalChangeSeqNum, NEW.umCalendarLastChangedBy, NEW.umCalendarLct) /*psql ON CONFLICT (umCalendarUid) DO UPDATE SET umCalendarName = EXCLUDED.umCalendarName, umCalendarCategory = EXCLUDED.umCalendarCategory, umCalendarActive = EXCLUDED.umCalendarActive, umCalendarMasterChangeSeqNum = EXCLUDED.umCalendarMasterChangeSeqNum, umCalendarLocalChangeSeqNum = EXCLUDED.umCalendarLocalChangeSeqNum, umCalendarLastChangedBy = EXCLUDED.umCalendarLastChangedBy, umCalendarLct = EXCLUDED.umCalendarLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_99 AFTER INSERT ON Holiday BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 99 AS chTableId, NEW.holUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 99 AND chEntityPk = NEW.holUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_99 AFTER UPDATE ON Holiday BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 99 AS chTableId, NEW.holUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 99 AND chEntityPk = NEW.holUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_99 AFTER DELETE ON Holiday BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 99 AS chTableId, OLD.holUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 99 AND chEntityPk = OLD.holUid); END "
    _stmtList +=
        "CREATE VIEW Holiday_ReceiveView AS  SELECT Holiday.*, HolidayReplicate.* FROM Holiday LEFT JOIN HolidayReplicate ON HolidayReplicate.holidayPk = Holiday.holUid "
    _stmtList +=
        " CREATE TRIGGER holiday_remote_insert_ins INSTEAD OF INSERT ON Holiday_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Holiday(holUid, holMasterCsn, holLocalCsn, holLastModBy, holLct, holActive, holHolidayCalendarUid, holStartTime, holEndTime, holName) VALUES (NEW.holUid, NEW.holMasterCsn, NEW.holLocalCsn, NEW.holLastModBy, NEW.holLct, NEW.holActive, NEW.holHolidayCalendarUid, NEW.holStartTime, NEW.holEndTime, NEW.holName) /*psql ON CONFLICT (holUid) DO UPDATE SET holMasterCsn = EXCLUDED.holMasterCsn, holLocalCsn = EXCLUDED.holLocalCsn, holLastModBy = EXCLUDED.holLastModBy, holLct = EXCLUDED.holLct, holActive = EXCLUDED.holActive, holHolidayCalendarUid = EXCLUDED.holHolidayCalendarUid, holStartTime = EXCLUDED.holStartTime, holEndTime = EXCLUDED.holEndTime, holName = EXCLUDED.holName */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_9 AFTER INSERT ON Person BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 9 AS chTableId, NEW.personUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 9 AND chEntityPk = NEW.personUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_9 AFTER UPDATE ON Person BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 9 AS chTableId, NEW.personUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 9 AND chEntityPk = NEW.personUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_9 AFTER DELETE ON Person BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 9 AS chTableId, OLD.personUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 9 AND chEntityPk = OLD.personUid); END "
    _stmtList +=
        "CREATE VIEW Person_ReceiveView AS  SELECT Person.*, PersonReplicate.* FROM Person LEFT JOIN PersonReplicate ON PersonReplicate.personPk = Person.personUid "
    _stmtList +=
        " CREATE TRIGGER person_remote_insert_ins INSTEAD OF INSERT ON Person_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Person(personUid, username, firstNames, lastName, emailAddr, phoneNum, gender, active, admin, personNotes, fatherName, fatherNumber, motherName, motherNum, dateOfBirth, personAddress, personOrgId, personGroupUid, personMasterChangeSeqNum, personLocalChangeSeqNum, personLastChangedBy, personLct, personCountry, personType) VALUES (NEW.personUid, NEW.username, NEW.firstNames, NEW.lastName, NEW.emailAddr, NEW.phoneNum, NEW.gender, NEW.active, NEW.admin, NEW.personNotes, NEW.fatherName, NEW.fatherNumber, NEW.motherName, NEW.motherNum, NEW.dateOfBirth, NEW.personAddress, NEW.personOrgId, NEW.personGroupUid, NEW.personMasterChangeSeqNum, NEW.personLocalChangeSeqNum, NEW.personLastChangedBy, NEW.personLct, NEW.personCountry, NEW.personType) /*psql ON CONFLICT (personUid) DO UPDATE SET username = EXCLUDED.username, firstNames = EXCLUDED.firstNames, lastName = EXCLUDED.lastName, emailAddr = EXCLUDED.emailAddr, phoneNum = EXCLUDED.phoneNum, gender = EXCLUDED.gender, active = EXCLUDED.active, admin = EXCLUDED.admin, personNotes = EXCLUDED.personNotes, fatherName = EXCLUDED.fatherName, fatherNumber = EXCLUDED.fatherNumber, motherName = EXCLUDED.motherName, motherNum = EXCLUDED.motherNum, dateOfBirth = EXCLUDED.dateOfBirth, personAddress = EXCLUDED.personAddress, personOrgId = EXCLUDED.personOrgId, personGroupUid = EXCLUDED.personGroupUid, personMasterChangeSeqNum = EXCLUDED.personMasterChangeSeqNum, personLocalChangeSeqNum = EXCLUDED.personLocalChangeSeqNum, personLastChangedBy = EXCLUDED.personLastChangedBy, personLct = EXCLUDED.personLct, personCountry = EXCLUDED.personCountry, personType = EXCLUDED.personType */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_6 AFTER INSERT ON Clazz BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 6 AS chTableId, NEW.clazzUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 6 AND chEntityPk = NEW.clazzUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_6 AFTER UPDATE ON Clazz BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 6 AS chTableId, NEW.clazzUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 6 AND chEntityPk = NEW.clazzUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_6 AFTER DELETE ON Clazz BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 6 AS chTableId, OLD.clazzUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 6 AND chEntityPk = OLD.clazzUid); END "
    _stmtList +=
        "CREATE VIEW Clazz_ReceiveView AS  SELECT Clazz.*, ClazzReplicate.* FROM Clazz LEFT JOIN ClazzReplicate ON ClazzReplicate.clazzPk = Clazz.clazzUid "
    _stmtList +=
        " CREATE TRIGGER clazz_remote_insert_ins INSTEAD OF INSERT ON Clazz_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Clazz(clazzUid, clazzName, clazzDesc, attendanceAverage, clazzHolidayUMCalendarUid, clazzScheuleUMCalendarUid, isClazzActive, clazzLocationUid, clazzStartTime, clazzEndTime, clazzFeatures, clazzSchoolUid, clazzEnrolmentPolicy, clazzTerminologyUid, clazzMasterChangeSeqNum, clazzLocalChangeSeqNum, clazzLastChangedBy, clazzLct, clazzTimeZone, clazzStudentsPersonGroupUid, clazzTeachersPersonGroupUid, clazzPendingStudentsPersonGroupUid, clazzParentsPersonGroupUid, clazzCode) VALUES (NEW.clazzUid, NEW.clazzName, NEW.clazzDesc, NEW.attendanceAverage, NEW.clazzHolidayUMCalendarUid, NEW.clazzScheuleUMCalendarUid, NEW.isClazzActive, NEW.clazzLocationUid, NEW.clazzStartTime, NEW.clazzEndTime, NEW.clazzFeatures, NEW.clazzSchoolUid, NEW.clazzEnrolmentPolicy, NEW.clazzTerminologyUid, NEW.clazzMasterChangeSeqNum, NEW.clazzLocalChangeSeqNum, NEW.clazzLastChangedBy, NEW.clazzLct, NEW.clazzTimeZone, NEW.clazzStudentsPersonGroupUid, NEW.clazzTeachersPersonGroupUid, NEW.clazzPendingStudentsPersonGroupUid, NEW.clazzParentsPersonGroupUid, NEW.clazzCode) /*psql ON CONFLICT (clazzUid) DO UPDATE SET clazzName = EXCLUDED.clazzName, clazzDesc = EXCLUDED.clazzDesc, attendanceAverage = EXCLUDED.attendanceAverage, clazzHolidayUMCalendarUid = EXCLUDED.clazzHolidayUMCalendarUid, clazzScheuleUMCalendarUid = EXCLUDED.clazzScheuleUMCalendarUid, isClazzActive = EXCLUDED.isClazzActive, clazzLocationUid = EXCLUDED.clazzLocationUid, clazzStartTime = EXCLUDED.clazzStartTime, clazzEndTime = EXCLUDED.clazzEndTime, clazzFeatures = EXCLUDED.clazzFeatures, clazzSchoolUid = EXCLUDED.clazzSchoolUid, clazzEnrolmentPolicy = EXCLUDED.clazzEnrolmentPolicy, clazzTerminologyUid = EXCLUDED.clazzTerminologyUid, clazzMasterChangeSeqNum = EXCLUDED.clazzMasterChangeSeqNum, clazzLocalChangeSeqNum = EXCLUDED.clazzLocalChangeSeqNum, clazzLastChangedBy = EXCLUDED.clazzLastChangedBy, clazzLct = EXCLUDED.clazzLct, clazzTimeZone = EXCLUDED.clazzTimeZone, clazzStudentsPersonGroupUid = EXCLUDED.clazzStudentsPersonGroupUid, clazzTeachersPersonGroupUid = EXCLUDED.clazzTeachersPersonGroupUid, clazzPendingStudentsPersonGroupUid = EXCLUDED.clazzPendingStudentsPersonGroupUid, clazzParentsPersonGroupUid = EXCLUDED.clazzParentsPersonGroupUid, clazzCode = EXCLUDED.clazzCode */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_65 AFTER INSERT ON ClazzEnrolment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 65 AS chTableId, NEW.clazzEnrolmentUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 65 AND chEntityPk = NEW.clazzEnrolmentUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_65 AFTER UPDATE ON ClazzEnrolment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 65 AS chTableId, NEW.clazzEnrolmentUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 65 AND chEntityPk = NEW.clazzEnrolmentUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_65 AFTER DELETE ON ClazzEnrolment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 65 AS chTableId, OLD.clazzEnrolmentUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 65 AND chEntityPk = OLD.clazzEnrolmentUid); END "
    _stmtList +=
        "CREATE VIEW ClazzEnrolment_ReceiveView AS  SELECT ClazzEnrolment.*, ClazzEnrolmentReplicate.* FROM ClazzEnrolment LEFT JOIN ClazzEnrolmentReplicate ON ClazzEnrolmentReplicate.cePk = ClazzEnrolment.clazzEnrolmentUid "
    _stmtList +=
        " CREATE TRIGGER clazzenrolment_remote_insert_ins INSTEAD OF INSERT ON ClazzEnrolment_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ClazzEnrolment(clazzEnrolmentUid, clazzEnrolmentPersonUid, clazzEnrolmentClazzUid, clazzEnrolmentDateJoined, clazzEnrolmentDateLeft, clazzEnrolmentRole, clazzEnrolmentAttendancePercentage, clazzEnrolmentActive, clazzEnrolmentLeavingReasonUid, clazzEnrolmentOutcome, clazzEnrolmentLocalChangeSeqNum, clazzEnrolmentMasterChangeSeqNum, clazzEnrolmentLastChangedBy, clazzEnrolmentLct) VALUES (NEW.clazzEnrolmentUid, NEW.clazzEnrolmentPersonUid, NEW.clazzEnrolmentClazzUid, NEW.clazzEnrolmentDateJoined, NEW.clazzEnrolmentDateLeft, NEW.clazzEnrolmentRole, NEW.clazzEnrolmentAttendancePercentage, NEW.clazzEnrolmentActive, NEW.clazzEnrolmentLeavingReasonUid, NEW.clazzEnrolmentOutcome, NEW.clazzEnrolmentLocalChangeSeqNum, NEW.clazzEnrolmentMasterChangeSeqNum, NEW.clazzEnrolmentLastChangedBy, NEW.clazzEnrolmentLct) /*psql ON CONFLICT (clazzEnrolmentUid) DO UPDATE SET clazzEnrolmentPersonUid = EXCLUDED.clazzEnrolmentPersonUid, clazzEnrolmentClazzUid = EXCLUDED.clazzEnrolmentClazzUid, clazzEnrolmentDateJoined = EXCLUDED.clazzEnrolmentDateJoined, clazzEnrolmentDateLeft = EXCLUDED.clazzEnrolmentDateLeft, clazzEnrolmentRole = EXCLUDED.clazzEnrolmentRole, clazzEnrolmentAttendancePercentage = EXCLUDED.clazzEnrolmentAttendancePercentage, clazzEnrolmentActive = EXCLUDED.clazzEnrolmentActive, clazzEnrolmentLeavingReasonUid = EXCLUDED.clazzEnrolmentLeavingReasonUid, clazzEnrolmentOutcome = EXCLUDED.clazzEnrolmentOutcome, clazzEnrolmentLocalChangeSeqNum = EXCLUDED.clazzEnrolmentLocalChangeSeqNum, clazzEnrolmentMasterChangeSeqNum = EXCLUDED.clazzEnrolmentMasterChangeSeqNum, clazzEnrolmentLastChangedBy = EXCLUDED.clazzEnrolmentLastChangedBy, clazzEnrolmentLct = EXCLUDED.clazzEnrolmentLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_410 AFTER INSERT ON LeavingReason BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 410 AS chTableId, NEW.leavingReasonUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 410 AND chEntityPk = NEW.leavingReasonUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_410 AFTER UPDATE ON LeavingReason BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 410 AS chTableId, NEW.leavingReasonUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 410 AND chEntityPk = NEW.leavingReasonUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_410 AFTER DELETE ON LeavingReason BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 410 AS chTableId, OLD.leavingReasonUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 410 AND chEntityPk = OLD.leavingReasonUid); END "
    _stmtList +=
        "CREATE VIEW LeavingReason_ReceiveView AS  SELECT LeavingReason.*, LeavingReasonReplicate.* FROM LeavingReason LEFT JOIN LeavingReasonReplicate ON LeavingReasonReplicate.lrPk = LeavingReason.leavingReasonUid "
    _stmtList +=
        " CREATE TRIGGER leavingreason_remote_insert_ins INSTEAD OF INSERT ON LeavingReason_ReceiveView FOR EACH ROW BEGIN REPLACE INTO LeavingReason(leavingReasonUid, leavingReasonTitle, leavingReasonMCSN, leavingReasonCSN, leavingReasonLCB, leavingReasonLct) VALUES (NEW.leavingReasonUid, NEW.leavingReasonTitle, NEW.leavingReasonMCSN, NEW.leavingReasonCSN, NEW.leavingReasonLCB, NEW.leavingReasonLct) /*psql ON CONFLICT (leavingReasonUid) DO UPDATE SET leavingReasonTitle = EXCLUDED.leavingReasonTitle, leavingReasonMCSN = EXCLUDED.leavingReasonMCSN, leavingReasonCSN = EXCLUDED.leavingReasonCSN, leavingReasonLCB = EXCLUDED.leavingReasonLCB, leavingReasonLct = EXCLUDED.leavingReasonLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_42 AFTER INSERT ON ContentEntry BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 42 AS chTableId, NEW.contentEntryUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 42 AND chEntityPk = NEW.contentEntryUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_42 AFTER UPDATE ON ContentEntry BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 42 AS chTableId, NEW.contentEntryUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 42 AND chEntityPk = NEW.contentEntryUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_42 AFTER DELETE ON ContentEntry BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 42 AS chTableId, OLD.contentEntryUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 42 AND chEntityPk = OLD.contentEntryUid); END "
    _stmtList +=
        "CREATE VIEW ContentEntry_ReceiveView AS  SELECT ContentEntry.*, ContentEntryReplicate.* FROM ContentEntry LEFT JOIN ContentEntryReplicate ON ContentEntryReplicate.cePk = ContentEntry.contentEntryUid "
    _stmtList +=
        " CREATE TRIGGER contententry_remote_insert_ins INSTEAD OF INSERT ON ContentEntry_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContentEntry(contentEntryUid, title, description, entryId, author, publisher, licenseType, licenseName, licenseUrl, sourceUrl, thumbnailUrl, lastModified, primaryLanguageUid, languageVariantUid, contentFlags, leaf, publik, ceInactive, completionCriteria, minScore, contentTypeFlag, contentOwner, contentEntryLocalChangeSeqNum, contentEntryMasterChangeSeqNum, contentEntryLastChangedBy, contentEntryLct) VALUES (NEW.contentEntryUid, NEW.title, NEW.description, NEW.entryId, NEW.author, NEW.publisher, NEW.licenseType, NEW.licenseName, NEW.licenseUrl, NEW.sourceUrl, NEW.thumbnailUrl, NEW.lastModified, NEW.primaryLanguageUid, NEW.languageVariantUid, NEW.contentFlags, NEW.leaf, NEW.publik, NEW.ceInactive, NEW.completionCriteria, NEW.minScore, NEW.contentTypeFlag, NEW.contentOwner, NEW.contentEntryLocalChangeSeqNum, NEW.contentEntryMasterChangeSeqNum, NEW.contentEntryLastChangedBy, NEW.contentEntryLct) /*psql ON CONFLICT (contentEntryUid) DO UPDATE SET title = EXCLUDED.title, description = EXCLUDED.description, entryId = EXCLUDED.entryId, author = EXCLUDED.author, publisher = EXCLUDED.publisher, licenseType = EXCLUDED.licenseType, licenseName = EXCLUDED.licenseName, licenseUrl = EXCLUDED.licenseUrl, sourceUrl = EXCLUDED.sourceUrl, thumbnailUrl = EXCLUDED.thumbnailUrl, lastModified = EXCLUDED.lastModified, primaryLanguageUid = EXCLUDED.primaryLanguageUid, languageVariantUid = EXCLUDED.languageVariantUid, contentFlags = EXCLUDED.contentFlags, leaf = EXCLUDED.leaf, publik = EXCLUDED.publik, ceInactive = EXCLUDED.ceInactive, completionCriteria = EXCLUDED.completionCriteria, minScore = EXCLUDED.minScore, contentTypeFlag = EXCLUDED.contentTypeFlag, contentOwner = EXCLUDED.contentOwner, contentEntryLocalChangeSeqNum = EXCLUDED.contentEntryLocalChangeSeqNum, contentEntryMasterChangeSeqNum = EXCLUDED.contentEntryMasterChangeSeqNum, contentEntryLastChangedBy = EXCLUDED.contentEntryLastChangedBy, contentEntryLct = EXCLUDED.contentEntryLct*/; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_3 AFTER INSERT ON ContentEntryContentCategoryJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 3 AS chTableId, NEW.ceccjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 3 AND chEntityPk = NEW.ceccjUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_3 AFTER UPDATE ON ContentEntryContentCategoryJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 3 AS chTableId, NEW.ceccjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 3 AND chEntityPk = NEW.ceccjUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_3 AFTER DELETE ON ContentEntryContentCategoryJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 3 AS chTableId, OLD.ceccjUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 3 AND chEntityPk = OLD.ceccjUid); END "
    _stmtList +=
        "CREATE VIEW ContentEntryContentCategoryJoin_ReceiveView AS  SELECT ContentEntryContentCategoryJoin.*, ContentEntryContentCategoryJoinReplicate.* FROM ContentEntryContentCategoryJoin LEFT JOIN ContentEntryContentCategoryJoinReplicate ON ContentEntryContentCategoryJoinReplicate.ceccjPk = ContentEntryContentCategoryJoin.ceccjUid "
    _stmtList +=
        " CREATE TRIGGER contententrycontentcategoryjoin_remote_insert_ins INSTEAD OF INSERT ON ContentEntryContentCategoryJoin_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContentEntryContentCategoryJoin(ceccjUid, ceccjContentEntryUid, ceccjContentCategoryUid, ceccjLocalChangeSeqNum, ceccjMasterChangeSeqNum, ceccjLastChangedBy, ceccjLct) VALUES (NEW.ceccjUid, NEW.ceccjContentEntryUid, NEW.ceccjContentCategoryUid, NEW.ceccjLocalChangeSeqNum, NEW.ceccjMasterChangeSeqNum, NEW.ceccjLastChangedBy, NEW.ceccjLct) /*psql ON CONFLICT (ceccjUid) DO UPDATE SET ceccjContentEntryUid = EXCLUDED.ceccjContentEntryUid, ceccjContentCategoryUid = EXCLUDED.ceccjContentCategoryUid, ceccjLocalChangeSeqNum = EXCLUDED.ceccjLocalChangeSeqNum, ceccjMasterChangeSeqNum = EXCLUDED.ceccjMasterChangeSeqNum, ceccjLastChangedBy = EXCLUDED.ceccjLastChangedBy, ceccjLct = EXCLUDED.ceccjLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_7 AFTER INSERT ON ContentEntryParentChildJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 7 AS chTableId, NEW.cepcjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 7 AND chEntityPk = NEW.cepcjUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_7 AFTER UPDATE ON ContentEntryParentChildJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 7 AS chTableId, NEW.cepcjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 7 AND chEntityPk = NEW.cepcjUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_7 AFTER DELETE ON ContentEntryParentChildJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 7 AS chTableId, OLD.cepcjUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 7 AND chEntityPk = OLD.cepcjUid); END "
    _stmtList +=
        "CREATE VIEW ContentEntryParentChildJoin_ReceiveView AS  SELECT ContentEntryParentChildJoin.*, ContentEntryParentChildJoinReplicate.* FROM ContentEntryParentChildJoin LEFT JOIN ContentEntryParentChildJoinReplicate ON ContentEntryParentChildJoinReplicate.cepcjPk = ContentEntryParentChildJoin.cepcjUid "
    _stmtList +=
        " CREATE TRIGGER contententryparentchildjoin_remote_insert_ins INSTEAD OF INSERT ON ContentEntryParentChildJoin_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContentEntryParentChildJoin(cepcjParentContentEntryUid, cepcjChildContentEntryUid, childIndex, cepcjUid, cepcjLocalChangeSeqNum, cepcjMasterChangeSeqNum, cepcjLastChangedBy, cepcjLct) VALUES (NEW.cepcjParentContentEntryUid, NEW.cepcjChildContentEntryUid, NEW.childIndex, NEW.cepcjUid, NEW.cepcjLocalChangeSeqNum, NEW.cepcjMasterChangeSeqNum, NEW.cepcjLastChangedBy, NEW.cepcjLct) /*psql ON CONFLICT (cepcjUid) DO UPDATE SET cepcjParentContentEntryUid = EXCLUDED.cepcjParentContentEntryUid, cepcjChildContentEntryUid = EXCLUDED.cepcjChildContentEntryUid, childIndex = EXCLUDED.childIndex, cepcjLocalChangeSeqNum = EXCLUDED.cepcjLocalChangeSeqNum, cepcjMasterChangeSeqNum = EXCLUDED.cepcjMasterChangeSeqNum, cepcjLastChangedBy = EXCLUDED.cepcjLastChangedBy, cepcjLct = EXCLUDED.cepcjLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_8 AFTER INSERT ON ContentEntryRelatedEntryJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 8 AS chTableId, NEW.cerejUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 8 AND chEntityPk = NEW.cerejUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_8 AFTER UPDATE ON ContentEntryRelatedEntryJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 8 AS chTableId, NEW.cerejUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 8 AND chEntityPk = NEW.cerejUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_8 AFTER DELETE ON ContentEntryRelatedEntryJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 8 AS chTableId, OLD.cerejUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 8 AND chEntityPk = OLD.cerejUid); END "
    _stmtList +=
        "CREATE VIEW ContentEntryRelatedEntryJoin_ReceiveView AS  SELECT ContentEntryRelatedEntryJoin.*, ContentEntryRelatedEntryJoinReplicate.* FROM ContentEntryRelatedEntryJoin LEFT JOIN ContentEntryRelatedEntryJoinReplicate ON ContentEntryRelatedEntryJoinReplicate.cerejPk = ContentEntryRelatedEntryJoin.cerejUid "
    _stmtList +=
        " CREATE TRIGGER contententryrelatedentryjoin_remote_insert_ins INSTEAD OF INSERT ON ContentEntryRelatedEntryJoin_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContentEntryRelatedEntryJoin(cerejUid, cerejContentEntryUid, cerejRelatedEntryUid, cerejLastChangedBy, relType, comment, cerejRelLanguageUid, cerejLocalChangeSeqNum, cerejMasterChangeSeqNum, cerejLct) VALUES (NEW.cerejUid, NEW.cerejContentEntryUid, NEW.cerejRelatedEntryUid, NEW.cerejLastChangedBy, NEW.relType, NEW.comment, NEW.cerejRelLanguageUid, NEW.cerejLocalChangeSeqNum, NEW.cerejMasterChangeSeqNum, NEW.cerejLct) /*psql ON CONFLICT (cerejUid) DO UPDATE SET cerejContentEntryUid = EXCLUDED.cerejContentEntryUid, cerejRelatedEntryUid = EXCLUDED.cerejRelatedEntryUid, cerejLastChangedBy = EXCLUDED.cerejLastChangedBy, relType = EXCLUDED.relType, comment = EXCLUDED.comment, cerejRelLanguageUid = EXCLUDED.cerejRelLanguageUid, cerejLocalChangeSeqNum = EXCLUDED.cerejLocalChangeSeqNum, cerejMasterChangeSeqNum = EXCLUDED.cerejMasterChangeSeqNum, cerejLct = EXCLUDED.cerejLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_2 AFTER INSERT ON ContentCategorySchema BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 2 AS chTableId, NEW.contentCategorySchemaUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 2 AND chEntityPk = NEW.contentCategorySchemaUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_2 AFTER UPDATE ON ContentCategorySchema BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 2 AS chTableId, NEW.contentCategorySchemaUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 2 AND chEntityPk = NEW.contentCategorySchemaUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_2 AFTER DELETE ON ContentCategorySchema BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 2 AS chTableId, OLD.contentCategorySchemaUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 2 AND chEntityPk = OLD.contentCategorySchemaUid); END "
    _stmtList +=
        "CREATE VIEW ContentCategorySchema_ReceiveView AS  SELECT ContentCategorySchema.*, ContentCategorySchemaReplicate.* FROM ContentCategorySchema LEFT JOIN ContentCategorySchemaReplicate ON ContentCategorySchemaReplicate.ccsPk = ContentCategorySchema.contentCategorySchemaUid "
    _stmtList +=
        " CREATE TRIGGER contentcategoryschema_remote_insert_ins INSTEAD OF INSERT ON ContentCategorySchema_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContentCategorySchema(contentCategorySchemaUid, schemaName, schemaUrl, contentCategorySchemaLocalChangeSeqNum, contentCategorySchemaMasterChangeSeqNum, contentCategorySchemaLastChangedBy, contentCategorySchemaLct) VALUES (NEW.contentCategorySchemaUid, NEW.schemaName, NEW.schemaUrl, NEW.contentCategorySchemaLocalChangeSeqNum, NEW.contentCategorySchemaMasterChangeSeqNum, NEW.contentCategorySchemaLastChangedBy, NEW.contentCategorySchemaLct) /*psql ON CONFLICT (contentCategorySchemaUid) DO UPDATE SET schemaName = EXCLUDED.schemaName, schemaUrl = EXCLUDED.schemaUrl, contentCategorySchemaLocalChangeSeqNum = EXCLUDED.contentCategorySchemaLocalChangeSeqNum, contentCategorySchemaMasterChangeSeqNum = EXCLUDED.contentCategorySchemaMasterChangeSeqNum, contentCategorySchemaLastChangedBy = EXCLUDED.contentCategorySchemaLastChangedBy, contentCategorySchemaLct = EXCLUDED.contentCategorySchemaLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_1 AFTER INSERT ON ContentCategory BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 1 AS chTableId, NEW.contentCategoryUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 1 AND chEntityPk = NEW.contentCategoryUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_1 AFTER UPDATE ON ContentCategory BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 1 AS chTableId, NEW.contentCategoryUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 1 AND chEntityPk = NEW.contentCategoryUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_1 AFTER DELETE ON ContentCategory BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 1 AS chTableId, OLD.contentCategoryUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 1 AND chEntityPk = OLD.contentCategoryUid); END "
    _stmtList +=
        "CREATE VIEW ContentCategory_ReceiveView AS  SELECT ContentCategory.*, ContentCategoryReplicate.* FROM ContentCategory LEFT JOIN ContentCategoryReplicate ON ContentCategoryReplicate.ccPk = ContentCategory.contentCategoryUid "
    _stmtList +=
        " CREATE TRIGGER contentcategory_remote_insert_ins INSTEAD OF INSERT ON ContentCategory_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContentCategory(contentCategoryUid, ctnCatContentCategorySchemaUid, name, contentCategoryLocalChangeSeqNum, contentCategoryMasterChangeSeqNum, contentCategoryLastChangedBy, contentCategoryLct) VALUES (NEW.contentCategoryUid, NEW.ctnCatContentCategorySchemaUid, NEW.name, NEW.contentCategoryLocalChangeSeqNum, NEW.contentCategoryMasterChangeSeqNum, NEW.contentCategoryLastChangedBy, NEW.contentCategoryLct) /*psql ON CONFLICT (contentCategoryUid) DO UPDATE SET ctnCatContentCategorySchemaUid = EXCLUDED.ctnCatContentCategorySchemaUid, name = EXCLUDED.name, contentCategoryLocalChangeSeqNum = EXCLUDED.contentCategoryLocalChangeSeqNum, contentCategoryMasterChangeSeqNum = EXCLUDED.contentCategoryMasterChangeSeqNum, contentCategoryLastChangedBy = EXCLUDED.contentCategoryLastChangedBy, contentCategoryLct = EXCLUDED.contentCategoryLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_13 AFTER INSERT ON Language BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 13 AS chTableId, NEW.langUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 13 AND chEntityPk = NEW.langUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_13 AFTER UPDATE ON Language BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 13 AS chTableId, NEW.langUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 13 AND chEntityPk = NEW.langUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_13 AFTER DELETE ON Language BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 13 AS chTableId, OLD.langUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 13 AND chEntityPk = OLD.langUid); END "
    _stmtList +=
        "CREATE VIEW Language_ReceiveView AS  SELECT Language.*, LanguageReplicate.* FROM Language LEFT JOIN LanguageReplicate ON LanguageReplicate.languagePk = Language.langUid "
    _stmtList +=
        " CREATE TRIGGER language_remote_insert_ins INSTEAD OF INSERT ON Language_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Language(langUid, name, iso_639_1_standard, iso_639_2_standard, iso_639_3_standard, Language_Type, languageActive, langLocalChangeSeqNum, langMasterChangeSeqNum, langLastChangedBy, langLct) VALUES (NEW.langUid, NEW.name, NEW.iso_639_1_standard, NEW.iso_639_2_standard, NEW.iso_639_3_standard, NEW.Language_Type, NEW.languageActive, NEW.langLocalChangeSeqNum, NEW.langMasterChangeSeqNum, NEW.langLastChangedBy, NEW.langLct) /*psql ON CONFLICT (langUid) DO UPDATE SET name = EXCLUDED.name, iso_639_1_standard = EXCLUDED.iso_639_1_standard, iso_639_2_standard = EXCLUDED.iso_639_2_standard, iso_639_3_standard = EXCLUDED.iso_639_3_standard, Language_Type = EXCLUDED.Language_Type, languageActive = EXCLUDED.languageActive, langLocalChangeSeqNum = EXCLUDED.langLocalChangeSeqNum, langMasterChangeSeqNum = EXCLUDED.langMasterChangeSeqNum, langLastChangedBy = EXCLUDED.langLastChangedBy, langLct = EXCLUDED.langLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_10 AFTER INSERT ON LanguageVariant BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 10 AS chTableId, NEW.langVariantUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 10 AND chEntityPk = NEW.langVariantUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_10 AFTER UPDATE ON LanguageVariant BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 10 AS chTableId, NEW.langVariantUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 10 AND chEntityPk = NEW.langVariantUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_10 AFTER DELETE ON LanguageVariant BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 10 AS chTableId, OLD.langVariantUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 10 AND chEntityPk = OLD.langVariantUid); END "
    _stmtList +=
        "CREATE VIEW LanguageVariant_ReceiveView AS  SELECT LanguageVariant.*, LanguageVariantReplicate.* FROM LanguageVariant LEFT JOIN LanguageVariantReplicate ON LanguageVariantReplicate.lvPk = LanguageVariant.langVariantUid "
    _stmtList +=
        " CREATE TRIGGER languagevariant_remote_insert_ins INSTEAD OF INSERT ON LanguageVariant_ReceiveView FOR EACH ROW BEGIN REPLACE INTO LanguageVariant(langVariantUid, langUid, countryCode, name, langVariantLocalChangeSeqNum, langVariantMasterChangeSeqNum, langVariantLastChangedBy, langVariantLct) VALUES (NEW.langVariantUid, NEW.langUid, NEW.countryCode, NEW.name, NEW.langVariantLocalChangeSeqNum, NEW.langVariantMasterChangeSeqNum, NEW.langVariantLastChangedBy, NEW.langVariantLct) /*psql ON CONFLICT (langVariantUid) DO UPDATE SET langUid = EXCLUDED.langUid, countryCode = EXCLUDED.countryCode, name = EXCLUDED.name, langVariantLocalChangeSeqNum = EXCLUDED.langVariantLocalChangeSeqNum, langVariantMasterChangeSeqNum = EXCLUDED.langVariantMasterChangeSeqNum, langVariantLastChangedBy = EXCLUDED.langVariantLastChangedBy, langVariantLct = EXCLUDED.langVariantLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_43 AFTER INSERT ON PersonGroup BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 43 AS chTableId, NEW.groupUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 43 AND chEntityPk = NEW.groupUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_43 AFTER UPDATE ON PersonGroup BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 43 AS chTableId, NEW.groupUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 43 AND chEntityPk = NEW.groupUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_43 AFTER DELETE ON PersonGroup BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 43 AS chTableId, OLD.groupUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 43 AND chEntityPk = OLD.groupUid); END "
    _stmtList +=
        "CREATE VIEW PersonGroup_ReceiveView AS  SELECT PersonGroup.*, PersonGroupReplicate.* FROM PersonGroup LEFT JOIN PersonGroupReplicate ON PersonGroupReplicate.pgPk = PersonGroup.groupUid "
    _stmtList +=
        " CREATE TRIGGER persongroup_remote_insert_ins INSTEAD OF INSERT ON PersonGroup_ReceiveView FOR EACH ROW BEGIN REPLACE INTO PersonGroup(groupUid, groupMasterCsn, groupLocalCsn, groupLastChangedBy, groupLct, groupName, groupActive, personGroupFlag) VALUES (NEW.groupUid, NEW.groupMasterCsn, NEW.groupLocalCsn, NEW.groupLastChangedBy, NEW.groupLct, NEW.groupName, NEW.groupActive, NEW.personGroupFlag) /*psql ON CONFLICT (groupUid) DO UPDATE SET groupMasterCsn = EXCLUDED.groupMasterCsn, groupLocalCsn = EXCLUDED.groupLocalCsn, groupLastChangedBy = EXCLUDED.groupLastChangedBy, groupLct = EXCLUDED.groupLct, groupName = EXCLUDED.groupName, groupActive = EXCLUDED.groupActive, personGroupFlag = EXCLUDED.personGroupFlag */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_44 AFTER INSERT ON PersonGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 44 AS chTableId, NEW.groupMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 44 AND chEntityPk = NEW.groupMemberUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_44 AFTER UPDATE ON PersonGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 44 AS chTableId, NEW.groupMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 44 AND chEntityPk = NEW.groupMemberUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_44 AFTER DELETE ON PersonGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 44 AS chTableId, OLD.groupMemberUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 44 AND chEntityPk = OLD.groupMemberUid); END "
    _stmtList +=
        "CREATE VIEW PersonGroupMember_ReceiveView AS  SELECT PersonGroupMember.*, PersonGroupMemberReplicate.* FROM PersonGroupMember LEFT JOIN PersonGroupMemberReplicate ON PersonGroupMemberReplicate.pgmPk = PersonGroupMember.groupMemberUid "
    _stmtList +=
        " CREATE TRIGGER persongroupmember_remote_insert_ins INSTEAD OF INSERT ON PersonGroupMember_ReceiveView FOR EACH ROW BEGIN REPLACE INTO PersonGroupMember(groupMemberUid, groupMemberActive, groupMemberPersonUid, groupMemberGroupUid, groupMemberMasterCsn, groupMemberLocalCsn, groupMemberLastChangedBy, groupMemberLct) VALUES (NEW.groupMemberUid, NEW.groupMemberActive, NEW.groupMemberPersonUid, NEW.groupMemberGroupUid, NEW.groupMemberMasterCsn, NEW.groupMemberLocalCsn, NEW.groupMemberLastChangedBy, NEW.groupMemberLct) /*psql ON CONFLICT (groupMemberUid) DO UPDATE SET groupMemberActive = EXCLUDED.groupMemberActive, groupMemberPersonUid = EXCLUDED.groupMemberPersonUid, groupMemberGroupUid = EXCLUDED.groupMemberGroupUid, groupMemberMasterCsn = EXCLUDED.groupMemberMasterCsn, groupMemberLocalCsn = EXCLUDED.groupMemberLocalCsn, groupMemberLastChangedBy = EXCLUDED.groupMemberLastChangedBy, groupMemberLct = EXCLUDED.groupMemberLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_50 AFTER INSERT ON PersonPicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 50 AS chTableId, NEW.personPictureUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 50 AND chEntityPk = NEW.personPictureUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_50 AFTER UPDATE ON PersonPicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 50 AS chTableId, NEW.personPictureUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 50 AND chEntityPk = NEW.personPictureUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_50 AFTER DELETE ON PersonPicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 50 AS chTableId, OLD.personPictureUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 50 AND chEntityPk = OLD.personPictureUid); END "
    _stmtList +=
        "CREATE VIEW PersonPicture_ReceiveView AS  SELECT PersonPicture.*, PersonPictureReplicate.* FROM PersonPicture LEFT JOIN PersonPictureReplicate ON PersonPictureReplicate.ppPk = PersonPicture.personPictureUid "
    _stmtList +=
        " CREATE TRIGGER personpicture_remote_insert_ins INSTEAD OF INSERT ON PersonPicture_ReceiveView FOR EACH ROW BEGIN REPLACE INTO PersonPicture(personPictureUid, personPicturePersonUid, personPictureMasterCsn, personPictureLocalCsn, personPictureLastChangedBy, personPictureLct, personPictureUri, personPictureMd5, fileSize, picTimestamp, mimeType, personPictureActive) VALUES (NEW.personPictureUid, NEW.personPicturePersonUid, NEW.personPictureMasterCsn, NEW.personPictureLocalCsn, NEW.personPictureLastChangedBy, NEW.personPictureLct, NEW.personPictureUri, NEW.personPictureMd5, NEW.fileSize, NEW.picTimestamp, NEW.mimeType, NEW.personPictureActive) /*psql ON CONFLICT (personPictureUid) DO UPDATE SET personPicturePersonUid = EXCLUDED.personPicturePersonUid, personPictureMasterCsn = EXCLUDED.personPictureMasterCsn, personPictureLocalCsn = EXCLUDED.personPictureLocalCsn, personPictureLastChangedBy = EXCLUDED.personPictureLastChangedBy, personPictureLct = EXCLUDED.personPictureLct, personPictureUri = EXCLUDED.personPictureUri, personPictureMd5 = EXCLUDED.personPictureMd5, fileSize = EXCLUDED.fileSize, picTimestamp = EXCLUDED.picTimestamp, mimeType = EXCLUDED.mimeType, personPictureActive = EXCLUDED.personPictureActive */; END "
    _stmtList += """
    |
    |        CREATE TRIGGER ATTUPD_PersonPicture
    |        AFTER UPDATE ON PersonPicture FOR EACH ROW WHEN
    |        OLD.personPictureMd5 IS NOT NULL
    |        BEGIN
    |        
    |        INSERT INTO ZombieAttachmentData(zaUri) 
    |        SELECT OLD.personPictureUri AS zaUri
    |          FROM PersonPicture   
    |         WHERE PersonPicture.personPictureUid = OLD.personPictureUid
    |           AND (SELECT COUNT(*) 
    |                  FROM PersonPicture
    |                 WHERE personPictureMd5 = OLD.personPictureMd5) = 0
    |    ; 
    |        END
    |    
    """.trimMargin()
    _stmtList +=
        " CREATE TRIGGER ch_ins_51 AFTER INSERT ON Container BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 51 AS chTableId, NEW.containerUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 51 AND chEntityPk = NEW.containerUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_51 AFTER UPDATE ON Container BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 51 AS chTableId, NEW.containerUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 51 AND chEntityPk = NEW.containerUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_51 AFTER DELETE ON Container BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 51 AS chTableId, OLD.containerUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 51 AND chEntityPk = OLD.containerUid); END "
    _stmtList +=
        "CREATE VIEW Container_ReceiveView AS  SELECT Container.*, ContainerReplicate.* FROM Container LEFT JOIN ContainerReplicate ON ContainerReplicate.containerPk = Container.containerUid "
    _stmtList +=
        " CREATE TRIGGER container_remote_insert_ins INSTEAD OF INSERT ON Container_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Container(containerUid, cntLocalCsn, cntMasterCsn, cntLastModBy, cntLct, fileSize, containerContentEntryUid, cntLastModified, mimeType, remarks, mobileOptimized, cntNumEntries) SELECT NEW.containerUid, NEW.cntLocalCsn, NEW.cntMasterCsn, NEW.cntLastModBy, NEW.cntLct, NEW.fileSize, NEW.containerContentEntryUid, NEW.cntLastModified, NEW.mimeType, NEW.remarks, NEW.mobileOptimized, NEW.cntNumEntries WHERE NEW.cntLct > (SELECT COALESCE( (SELECT ContainerInt.cntLct FROM Container ContainerInt WHERE ContainerInt.containerUid = NEW.containerUid), 0)) /*psql ON CONFLICT (containerUid) DO UPDATE SET cntLocalCsn = EXCLUDED.cntLocalCsn, cntMasterCsn = EXCLUDED.cntMasterCsn, cntLastModBy = EXCLUDED.cntLastModBy, cntLct = EXCLUDED.cntLct, fileSize = EXCLUDED.fileSize, containerContentEntryUid = EXCLUDED.containerContentEntryUid, cntLastModified = EXCLUDED.cntLastModified, mimeType = EXCLUDED.mimeType, remarks = EXCLUDED.remarks, mobileOptimized = EXCLUDED.mobileOptimized, cntNumEntries = EXCLUDED.cntNumEntries */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_62 AFTER INSERT ON VerbEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 62 AS chTableId, NEW.verbUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 62 AND chEntityPk = NEW.verbUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_62 AFTER UPDATE ON VerbEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 62 AS chTableId, NEW.verbUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 62 AND chEntityPk = NEW.verbUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_62 AFTER DELETE ON VerbEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 62 AS chTableId, OLD.verbUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 62 AND chEntityPk = OLD.verbUid); END "
    _stmtList +=
        "CREATE VIEW VerbEntity_ReceiveView AS  SELECT VerbEntity.*, VerbEntityReplicate.* FROM VerbEntity LEFT JOIN VerbEntityReplicate ON VerbEntityReplicate.vePk = VerbEntity.verbUid "
    _stmtList +=
        " CREATE TRIGGER verbentity_remote_insert_ins INSTEAD OF INSERT ON VerbEntity_ReceiveView FOR EACH ROW BEGIN REPLACE INTO VerbEntity(verbUid, urlId, verbInActive, verbMasterChangeSeqNum, verbLocalChangeSeqNum, verbLastChangedBy, verbLct) VALUES (NEW.verbUid, NEW.urlId, NEW.verbInActive, NEW.verbMasterChangeSeqNum, NEW.verbLocalChangeSeqNum, NEW.verbLastChangedBy, NEW.verbLct) /*psql ON CONFLICT (verbUid) DO UPDATE SET urlId = EXCLUDED.urlId, verbInActive = EXCLUDED.verbInActive, verbMasterChangeSeqNum = EXCLUDED.verbMasterChangeSeqNum, verbLocalChangeSeqNum = EXCLUDED.verbLocalChangeSeqNum, verbLastChangedBy = EXCLUDED.verbLastChangedBy, verbLct = EXCLUDED.verbLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_64 AFTER INSERT ON XObjectEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 64 AS chTableId, NEW.xObjectUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 64 AND chEntityPk = NEW.xObjectUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_64 AFTER UPDATE ON XObjectEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 64 AS chTableId, NEW.xObjectUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 64 AND chEntityPk = NEW.xObjectUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_64 AFTER DELETE ON XObjectEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 64 AS chTableId, OLD.xObjectUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 64 AND chEntityPk = OLD.xObjectUid); END "
    _stmtList +=
        "CREATE VIEW XObjectEntity_ReceiveView AS  SELECT XObjectEntity.*, XObjectEntityReplicate.* FROM XObjectEntity LEFT JOIN XObjectEntityReplicate ON XObjectEntityReplicate.xoePk = XObjectEntity.xObjectUid "
    _stmtList +=
        " CREATE TRIGGER xobjectentity_remote_insert_ins INSTEAD OF INSERT ON XObjectEntity_ReceiveView FOR EACH ROW BEGIN REPLACE INTO XObjectEntity(xObjectUid, objectType, objectId, definitionType, interactionType, correctResponsePattern, objectContentEntryUid, objectStatementRefUid, xObjectMasterChangeSeqNum, xObjectocalChangeSeqNum, xObjectLastChangedBy, xObjectLct) VALUES (NEW.xObjectUid, NEW.objectType, NEW.objectId, NEW.definitionType, NEW.interactionType, NEW.correctResponsePattern, NEW.objectContentEntryUid, NEW.objectStatementRefUid, NEW.xObjectMasterChangeSeqNum, NEW.xObjectocalChangeSeqNum, NEW.xObjectLastChangedBy, NEW.xObjectLct) /*psql ON CONFLICT (xObjectUid) DO UPDATE SET objectType = EXCLUDED.objectType, objectId = EXCLUDED.objectId, definitionType = EXCLUDED.definitionType, interactionType = EXCLUDED.interactionType, correctResponsePattern = EXCLUDED.correctResponsePattern, objectContentEntryUid = EXCLUDED.objectContentEntryUid,objectStatementRefUid = EXCLUDED.objectStatementRefUid, xObjectMasterChangeSeqNum = EXCLUDED.xObjectMasterChangeSeqNum, xObjectocalChangeSeqNum = EXCLUDED.xObjectocalChangeSeqNum, xObjectLastChangedBy = EXCLUDED.xObjectLastChangedBy, xObjectLct = EXCLUDED.xObjectLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_60 AFTER INSERT ON StatementEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 60 AS chTableId, NEW.statementUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 60 AND chEntityPk = NEW.statementUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_60 AFTER UPDATE ON StatementEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 60 AS chTableId, NEW.statementUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 60 AND chEntityPk = NEW.statementUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_60 AFTER DELETE ON StatementEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 60 AS chTableId, OLD.statementUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 60 AND chEntityPk = OLD.statementUid); END "
    _stmtList +=
        "CREATE VIEW StatementEntity_ReceiveView AS  SELECT StatementEntity.*, StatementEntityReplicate.* FROM StatementEntity LEFT JOIN StatementEntityReplicate ON StatementEntityReplicate.sePk = StatementEntity.statementUid "
    _stmtList +=
        " CREATE TRIGGER statemententity_remote_insert_ins INSTEAD OF INSERT ON StatementEntity_ReceiveView FOR EACH ROW BEGIN REPLACE INTO StatementEntity(statementUid, statementId, statementPersonUid, statementVerbUid, xObjectUid, subStatementActorUid, substatementVerbUid, subStatementObjectUid, agentUid, instructorUid, authorityUid, teamUid, resultCompletion, resultSuccess, resultScoreScaled, resultScoreRaw, resultScoreMin, resultScoreMax, resultDuration, resultResponse, timestamp, stored, contextRegistration, contextPlatform, contextStatementId, fullStatement, statementMasterChangeSeqNum, statementLocalChangeSeqNum, statementLastChangedBy, statementLct, extensionProgress, contentEntryRoot, statementContentEntryUid, statementLearnerGroupUid, statementClazzUid) VALUES (NEW.statementUid, NEW.statementId, NEW.statementPersonUid, NEW.statementVerbUid, NEW.xObjectUid, NEW.subStatementActorUid, NEW.substatementVerbUid, NEW.subStatementObjectUid, NEW.agentUid, NEW.instructorUid, NEW.authorityUid, NEW.teamUid, NEW.resultCompletion, NEW.resultSuccess, NEW.resultScoreScaled, NEW.resultScoreRaw, NEW.resultScoreMin, NEW.resultScoreMax, NEW.resultDuration, NEW.resultResponse, NEW.timestamp, NEW.stored, NEW.contextRegistration, NEW.contextPlatform, NEW.contextStatementId, NEW.fullStatement, NEW.statementMasterChangeSeqNum, NEW.statementLocalChangeSeqNum, NEW.statementLastChangedBy, NEW.statementLct, NEW.extensionProgress, NEW.contentEntryRoot, NEW.statementContentEntryUid, NEW.statementLearnerGroupUid, NEW.statementClazzUid) /*psql ON CONFLICT (statementUid) DO UPDATE SET statementId = EXCLUDED.statementId, statementPersonUid = EXCLUDED.statementPersonUid, statementVerbUid = EXCLUDED.statementVerbUid, xObjectUid = EXCLUDED.xObjectUid, subStatementActorUid = EXCLUDED.subStatementActorUid, substatementVerbUid = EXCLUDED.substatementVerbUid, subStatementObjectUid = EXCLUDED.subStatementObjectUid, agentUid = EXCLUDED.agentUid, instructorUid = EXCLUDED.instructorUid, authorityUid = EXCLUDED.authorityUid, teamUid = EXCLUDED.teamUid, resultCompletion = EXCLUDED.resultCompletion, resultSuccess = EXCLUDED.resultSuccess, resultScoreScaled = EXCLUDED.resultScoreScaled, resultScoreRaw = EXCLUDED.resultScoreRaw, resultScoreMin = EXCLUDED.resultScoreMin, resultScoreMax = EXCLUDED.resultScoreMax, resultDuration = EXCLUDED.resultDuration, resultResponse = EXCLUDED.resultResponse, timestamp = EXCLUDED.timestamp, stored = EXCLUDED.stored, contextRegistration = EXCLUDED.contextRegistration, contextPlatform = EXCLUDED.contextPlatform, contextStatementId = EXCLUDED.contextStatementId, fullStatement = EXCLUDED.fullStatement, statementMasterChangeSeqNum = EXCLUDED.statementMasterChangeSeqNum, statementLocalChangeSeqNum = EXCLUDED.statementLocalChangeSeqNum, statementLastChangedBy = EXCLUDED.statementLastChangedBy, statementLct = EXCLUDED.statementLct, extensionProgress = EXCLUDED.extensionProgress, contentEntryRoot = EXCLUDED.contentEntryRoot, statementContentEntryUid = EXCLUDED.statementContentEntryUid, statementLearnerGroupUid = EXCLUDED.statementLearnerGroupUid, statementClazzUid = EXCLUDED.statementClazzUid */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_66 AFTER INSERT ON ContextXObjectStatementJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 66 AS chTableId, NEW.contextXObjectStatementJoinUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 66 AND chEntityPk = NEW.contextXObjectStatementJoinUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_66 AFTER UPDATE ON ContextXObjectStatementJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 66 AS chTableId, NEW.contextXObjectStatementJoinUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 66 AND chEntityPk = NEW.contextXObjectStatementJoinUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_66 AFTER DELETE ON ContextXObjectStatementJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 66 AS chTableId, OLD.contextXObjectStatementJoinUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 66 AND chEntityPk = OLD.contextXObjectStatementJoinUid); END "
    _stmtList +=
        "CREATE VIEW ContextXObjectStatementJoin_ReceiveView AS  SELECT ContextXObjectStatementJoin.*, ContextXObjectStatementJoinReplicate.* FROM ContextXObjectStatementJoin LEFT JOIN ContextXObjectStatementJoinReplicate ON ContextXObjectStatementJoinReplicate.cxosjPk = ContextXObjectStatementJoin.contextXObjectStatementJoinUid "
    _stmtList +=
        " CREATE TRIGGER contextxobjectstatementjoin_remote_insert_ins INSTEAD OF INSERT ON ContextXObjectStatementJoin_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContextXObjectStatementJoin(contextXObjectStatementJoinUid, contextActivityFlag, contextStatementUid, contextXObjectUid, verbMasterChangeSeqNum, verbLocalChangeSeqNum, verbLastChangedBy, contextXObjectLct) VALUES (NEW.contextXObjectStatementJoinUid, NEW.contextActivityFlag, NEW.contextStatementUid, NEW.contextXObjectUid, NEW.verbMasterChangeSeqNum, NEW.verbLocalChangeSeqNum, NEW.verbLastChangedBy, NEW.contextXObjectLct) /*psql ON CONFLICT (contextXObjectStatementJoinUid) DO UPDATE SET contextActivityFlag = EXCLUDED.contextActivityFlag, contextStatementUid = EXCLUDED.contextStatementUid, contextXObjectUid = EXCLUDED.contextXObjectUid, verbMasterChangeSeqNum = EXCLUDED.verbMasterChangeSeqNum, verbLocalChangeSeqNum = EXCLUDED.verbLocalChangeSeqNum, verbLastChangedBy = EXCLUDED.verbLastChangedBy, contextXObjectLct = EXCLUDED.contextXObjectLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_68 AFTER INSERT ON AgentEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 68 AS chTableId, NEW.agentUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 68 AND chEntityPk = NEW.agentUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_68 AFTER UPDATE ON AgentEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 68 AS chTableId, NEW.agentUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 68 AND chEntityPk = NEW.agentUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_68 AFTER DELETE ON AgentEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 68 AS chTableId, OLD.agentUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 68 AND chEntityPk = OLD.agentUid); END "
    _stmtList +=
        "CREATE VIEW AgentEntity_ReceiveView AS  SELECT AgentEntity.*, AgentEntityReplicate.* FROM AgentEntity LEFT JOIN AgentEntityReplicate ON AgentEntityReplicate.aePk = AgentEntity.agentUid "
    _stmtList +=
        " CREATE TRIGGER agententity_remote_insert_ins INSTEAD OF INSERT ON AgentEntity_ReceiveView FOR EACH ROW BEGIN REPLACE INTO AgentEntity(agentUid, agentMbox, agentMbox_sha1sum, agentOpenid, agentAccountName, agentHomePage, agentPersonUid, statementMasterChangeSeqNum, statementLocalChangeSeqNum, statementLastChangedBy, agentLct) VALUES (NEW.agentUid, NEW.agentMbox, NEW.agentMbox_sha1sum, NEW.agentOpenid, NEW.agentAccountName, NEW.agentHomePage, NEW.agentPersonUid, NEW.statementMasterChangeSeqNum, NEW.statementLocalChangeSeqNum, NEW.statementLastChangedBy, NEW.agentLct) /*psql ON CONFLICT (agentUid) DO UPDATE SET agentMbox = EXCLUDED.agentMbox, agentMbox_sha1sum = EXCLUDED.agentMbox_sha1sum, agentOpenid = EXCLUDED.agentOpenid, agentAccountName = EXCLUDED.agentAccountName, agentHomePage = EXCLUDED.agentHomePage, agentPersonUid = EXCLUDED.agentPersonUid, statementMasterChangeSeqNum = EXCLUDED.statementMasterChangeSeqNum, statementLocalChangeSeqNum = EXCLUDED.statementLocalChangeSeqNum, statementLastChangedBy = EXCLUDED.statementLastChangedBy, agentLct = EXCLUDED.agentLct*/; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_70 AFTER INSERT ON StateEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 70 AS chTableId, NEW.stateUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 70 AND chEntityPk = NEW.stateUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_70 AFTER UPDATE ON StateEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 70 AS chTableId, NEW.stateUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 70 AND chEntityPk = NEW.stateUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_70 AFTER DELETE ON StateEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 70 AS chTableId, OLD.stateUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 70 AND chEntityPk = OLD.stateUid); END "
    _stmtList +=
        "CREATE VIEW StateEntity_ReceiveView AS  SELECT StateEntity.*, StateEntityReplicate.* FROM StateEntity LEFT JOIN StateEntityReplicate ON StateEntityReplicate.sePk = StateEntity.stateUid "
    _stmtList +=
        " CREATE TRIGGER stateentity_remote_insert_ins INSTEAD OF INSERT ON StateEntity_ReceiveView FOR EACH ROW BEGIN REPLACE INTO StateEntity(stateUid, stateId, agentUid, activityId, registration, isIsactive, timestamp, stateMasterChangeSeqNum, stateLocalChangeSeqNum, stateLastChangedBy, stateLct) VALUES (NEW.stateUid, NEW.stateId, NEW.agentUid, NEW.activityId, NEW.registration, NEW.isIsactive, NEW.timestamp, NEW.stateMasterChangeSeqNum, NEW.stateLocalChangeSeqNum, NEW.stateLastChangedBy, NEW.stateLct) /*psql ON CONFLICT (stateUid) DO UPDATE SET stateId = EXCLUDED.stateId, agentUid = EXCLUDED.agentUid, activityId = EXCLUDED.activityId, registration = EXCLUDED.registration, isIsactive = EXCLUDED.isIsactive, timestamp = EXCLUDED.timestamp, stateMasterChangeSeqNum = EXCLUDED.stateMasterChangeSeqNum, stateLocalChangeSeqNum = EXCLUDED.stateLocalChangeSeqNum, stateLastChangedBy = EXCLUDED.stateLastChangedBy, stateLct = EXCLUDED.stateLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_72 AFTER INSERT ON StateContentEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 72 AS chTableId, NEW.stateContentUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 72 AND chEntityPk = NEW.stateContentUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_72 AFTER UPDATE ON StateContentEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 72 AS chTableId, NEW.stateContentUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 72 AND chEntityPk = NEW.stateContentUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_72 AFTER DELETE ON StateContentEntity BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 72 AS chTableId, OLD.stateContentUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 72 AND chEntityPk = OLD.stateContentUid); END "
    _stmtList +=
        "CREATE VIEW StateContentEntity_ReceiveView AS  SELECT StateContentEntity.*, StateContentEntityReplicate.* FROM StateContentEntity LEFT JOIN StateContentEntityReplicate ON StateContentEntityReplicate.scePk = StateContentEntity.stateContentUid "
    _stmtList +=
        " CREATE TRIGGER statecontententity_remote_insert_ins INSTEAD OF INSERT ON StateContentEntity_ReceiveView FOR EACH ROW BEGIN REPLACE INTO StateContentEntity(stateContentUid, stateContentStateUid, stateContentKey, stateContentValue, isIsactive, stateContentMasterChangeSeqNum, stateContentLocalChangeSeqNum, stateContentLastChangedBy, stateContentLct) VALUES (NEW.stateContentUid, NEW.stateContentStateUid, NEW.stateContentKey, NEW.stateContentValue, NEW.isIsactive, NEW.stateContentMasterChangeSeqNum, NEW.stateContentLocalChangeSeqNum, NEW.stateContentLastChangedBy, NEW.stateContentLct) /*psql ON CONFLICT (stateContentUid) DO UPDATE SET stateContentStateUid = EXCLUDED.stateContentStateUid, stateContentKey = EXCLUDED.stateContentKey, stateContentValue = EXCLUDED.stateContentValue, isIsactive = EXCLUDED.isIsactive, stateContentMasterChangeSeqNum = EXCLUDED.stateContentMasterChangeSeqNum, stateContentLocalChangeSeqNum = EXCLUDED.stateContentLocalChangeSeqNum, stateContentLastChangedBy = EXCLUDED.stateContentLastChangedBy, stateContentLct = EXCLUDED.stateContentLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_74 AFTER INSERT ON XLangMapEntry BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 74 AS chTableId, NEW.statementLangMapUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 74 AND chEntityPk = NEW.statementLangMapUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_74 AFTER UPDATE ON XLangMapEntry BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 74 AS chTableId, NEW.statementLangMapUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 74 AND chEntityPk = NEW.statementLangMapUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_74 AFTER DELETE ON XLangMapEntry BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 74 AS chTableId, OLD.statementLangMapUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 74 AND chEntityPk = OLD.statementLangMapUid); END "
    _stmtList +=
        "CREATE VIEW XLangMapEntry_ReceiveView AS  SELECT XLangMapEntry.*, XLangMapEntryReplicate.* FROM XLangMapEntry LEFT JOIN XLangMapEntryReplicate ON XLangMapEntryReplicate.xlmePk = XLangMapEntry.statementLangMapUid "
    _stmtList +=
        " CREATE TRIGGER xlangmapentry_remote_insert_ins INSTEAD OF INSERT ON XLangMapEntry_ReceiveView FOR EACH ROW BEGIN REPLACE INTO XLangMapEntry(verbLangMapUid, objectLangMapUid, languageLangMapUid, languageVariantLangMapUid, valueLangMap, statementLangMapMasterCsn, statementLangMapLocalCsn, statementLangMapLcb, statementLangMapLct, statementLangMapUid) VALUES (NEW.verbLangMapUid, NEW.objectLangMapUid, NEW.languageLangMapUid, NEW.languageVariantLangMapUid, NEW.valueLangMap, NEW.statementLangMapMasterCsn, NEW.statementLangMapLocalCsn, NEW.statementLangMapLcb, NEW.statementLangMapLct, NEW.statementLangMapUid) /*psql ON CONFLICT (statementLangMapUid) DO UPDATE SET verbLangMapUid = EXCLUDED.verbLangMapUid, objectLangMapUid = EXCLUDED.objectLangMapUid, languageLangMapUid = EXCLUDED.languageLangMapUid, languageVariantLangMapUid = EXCLUDED.languageVariantLangMapUid, valueLangMap = EXCLUDED.valueLangMap, statementLangMapMasterCsn = EXCLUDED.statementLangMapMasterCsn, statementLangMapLocalCsn = EXCLUDED.statementLangMapLocalCsn, statementLangMapLcb = EXCLUDED.statementLangMapLcb, statementLangMapLct = EXCLUDED.statementLangMapLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_164 AFTER INSERT ON School BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 164 AS chTableId, NEW.schoolUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 164 AND chEntityPk = NEW.schoolUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_164 AFTER UPDATE ON School BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 164 AS chTableId, NEW.schoolUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 164 AND chEntityPk = NEW.schoolUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_164 AFTER DELETE ON School BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 164 AS chTableId, OLD.schoolUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 164 AND chEntityPk = OLD.schoolUid); END "
    _stmtList +=
        "CREATE VIEW School_ReceiveView AS  SELECT School.*, SchoolReplicate.* FROM School LEFT JOIN SchoolReplicate ON SchoolReplicate.schoolPk = School.schoolUid "
    _stmtList +=
        " CREATE TRIGGER school_remote_insert_ins INSTEAD OF INSERT ON School_ReceiveView FOR EACH ROW BEGIN REPLACE INTO School(schoolUid, schoolName, schoolDesc, schoolAddress, schoolActive, schoolPhoneNumber, schoolGender, schoolHolidayCalendarUid, schoolFeatures, schoolLocationLong, schoolLocationLatt, schoolEmailAddress, schoolTeachersPersonGroupUid, schoolStudentsPersonGroupUid, schoolPendingStudentsPersonGroupUid, schoolCode, schoolMasterChangeSeqNum, schoolLocalChangeSeqNum, schoolLastChangedBy, schoolLct, schoolTimeZone) VALUES (NEW.schoolUid, NEW.schoolName, NEW.schoolDesc, NEW.schoolAddress, NEW.schoolActive, NEW.schoolPhoneNumber, NEW.schoolGender, NEW.schoolHolidayCalendarUid, NEW.schoolFeatures, NEW.schoolLocationLong, NEW.schoolLocationLatt, NEW.schoolEmailAddress, NEW.schoolTeachersPersonGroupUid, NEW.schoolStudentsPersonGroupUid, NEW.schoolPendingStudentsPersonGroupUid, NEW.schoolCode, NEW.schoolMasterChangeSeqNum, NEW.schoolLocalChangeSeqNum, NEW.schoolLastChangedBy, NEW.schoolLct, NEW.schoolTimeZone) /*psql ON CONFLICT (schoolUid) DO UPDATE SET schoolName = EXCLUDED.schoolName, schoolDesc = EXCLUDED.schoolDesc, schoolAddress = EXCLUDED.schoolAddress, schoolActive = EXCLUDED.schoolActive, schoolPhoneNumber = EXCLUDED.schoolPhoneNumber, schoolGender = EXCLUDED.schoolGender, schoolHolidayCalendarUid = EXCLUDED.schoolHolidayCalendarUid, schoolFeatures = EXCLUDED.schoolFeatures, schoolLocationLong = EXCLUDED.schoolLocationLong, schoolLocationLatt = EXCLUDED.schoolLocationLatt, schoolEmailAddress = EXCLUDED.schoolEmailAddress, schoolTeachersPersonGroupUid = EXCLUDED.schoolTeachersPersonGroupUid, schoolStudentsPersonGroupUid = EXCLUDED.schoolStudentsPersonGroupUid, schoolPendingStudentsPersonGroupUid = EXCLUDED.schoolPendingStudentsPersonGroupUid, schoolCode = EXCLUDED.schoolCode, schoolMasterChangeSeqNum = EXCLUDED.schoolMasterChangeSeqNum, schoolLocalChangeSeqNum = EXCLUDED.schoolLocalChangeSeqNum, schoolLastChangedBy = EXCLUDED.schoolLastChangedBy, schoolLct = EXCLUDED.schoolLct, schoolTimeZone = EXCLUDED.schoolTimeZone */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_200 AFTER INSERT ON SchoolMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 200 AS chTableId, NEW.schoolMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 200 AND chEntityPk = NEW.schoolMemberUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_200 AFTER UPDATE ON SchoolMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 200 AS chTableId, NEW.schoolMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 200 AND chEntityPk = NEW.schoolMemberUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_200 AFTER DELETE ON SchoolMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 200 AS chTableId, OLD.schoolMemberUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 200 AND chEntityPk = OLD.schoolMemberUid); END "
    _stmtList +=
        "CREATE VIEW SchoolMember_ReceiveView AS  SELECT SchoolMember.*, SchoolMemberReplicate.* FROM SchoolMember LEFT JOIN SchoolMemberReplicate ON SchoolMemberReplicate.smPk = SchoolMember.schoolMemberUid "
    _stmtList +=
        " CREATE TRIGGER schoolmember_remote_insert_ins INSTEAD OF INSERT ON SchoolMember_ReceiveView FOR EACH ROW BEGIN REPLACE INTO SchoolMember(schoolMemberUid, schoolMemberPersonUid, schoolMemberSchoolUid, schoolMemberJoinDate, schoolMemberLeftDate, schoolMemberRole, schoolMemberActive, schoolMemberLocalChangeSeqNum, schoolMemberMasterChangeSeqNum, schoolMemberLastChangedBy, schoolMemberLct) VALUES (NEW.schoolMemberUid, NEW.schoolMemberPersonUid, NEW.schoolMemberSchoolUid, NEW.schoolMemberJoinDate, NEW.schoolMemberLeftDate, NEW.schoolMemberRole, NEW.schoolMemberActive, NEW.schoolMemberLocalChangeSeqNum, NEW.schoolMemberMasterChangeSeqNum, NEW.schoolMemberLastChangedBy, NEW.schoolMemberLct) /*psql ON CONFLICT (schoolMemberUid) DO UPDATE SET schoolMemberPersonUid = EXCLUDED.schoolMemberPersonUid, schoolMemberSchoolUid = EXCLUDED.schoolMemberSchoolUid, schoolMemberJoinDate = EXCLUDED.schoolMemberJoinDate, schoolMemberLeftDate = EXCLUDED.schoolMemberLeftDate, schoolMemberRole = EXCLUDED.schoolMemberRole, schoolMemberActive = EXCLUDED.schoolMemberActive, schoolMemberLocalChangeSeqNum = EXCLUDED.schoolMemberLocalChangeSeqNum, schoolMemberMasterChangeSeqNum = EXCLUDED.schoolMemberMasterChangeSeqNum, schoolMemberLastChangedBy = EXCLUDED.schoolMemberLastChangedBy, schoolMemberLct = EXCLUDED.schoolMemberLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_208 AFTER INSERT ON Comments BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 208 AS chTableId, NEW.commentsUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 208 AND chEntityPk = NEW.commentsUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_208 AFTER UPDATE ON Comments BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 208 AS chTableId, NEW.commentsUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 208 AND chEntityPk = NEW.commentsUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_208 AFTER DELETE ON Comments BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 208 AS chTableId, OLD.commentsUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 208 AND chEntityPk = OLD.commentsUid); END "
    _stmtList +=
        "CREATE VIEW Comments_ReceiveView AS  SELECT Comments.*, CommentsReplicate.* FROM Comments LEFT JOIN CommentsReplicate ON CommentsReplicate.commentsPk = Comments.commentsUid "
    _stmtList +=
        " CREATE TRIGGER comments_remote_insert_ins INSTEAD OF INSERT ON Comments_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Comments(commentsUid, commentsText, commentsEntityType, commentsEntityUid, commentsPublic, commentsStatus, commentsPersonUid, commentsToPersonUid, commentSubmitterUid, commentsFlagged, commentsInActive, commentsDateTimeAdded, commentsDateTimeUpdated, commentsMCSN, commentsLCSN, commentsLCB, commentsLct) VALUES (NEW.commentsUid, NEW.commentsText, NEW.commentsEntityType, NEW.commentsEntityUid, NEW.commentsPublic, NEW.commentsStatus, NEW.commentsPersonUid, NEW.commentsToPersonUid, NEW.commentSubmitterUid, NEW.commentsFlagged, NEW.commentsInActive, NEW.commentsDateTimeAdded, NEW.commentsDateTimeUpdated, NEW.commentsMCSN, NEW.commentsLCSN, NEW.commentsLCB, NEW.commentsLct) /*psql ON CONFLICT (commentsUid) DO UPDATE SET commentsText = EXCLUDED.commentsText, commentsEntityType = EXCLUDED.commentsEntityType, commentsEntityUid = EXCLUDED.commentsEntityUid, commentsPublic = EXCLUDED.commentsPublic, commentsStatus = EXCLUDED.commentsStatus, commentsPersonUid = EXCLUDED.commentsPersonUid, commentsToPersonUid = EXCLUDED.commentsToPersonUid, commentSubmitterUid = EXCLUDED.commentSubmitterUid, commentsFlagged = EXCLUDED.commentsFlagged, commentsInActive = EXCLUDED.commentsInActive, commentsDateTimeAdded = EXCLUDED.commentsDateTimeAdded, commentsDateTimeUpdated = EXCLUDED.commentsDateTimeUpdated, commentsMCSN = EXCLUDED.commentsMCSN, commentsLCSN = EXCLUDED.commentsLCSN, commentsLCB = EXCLUDED.commentsLCB, commentsLct = EXCLUDED.commentsLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_101 AFTER INSERT ON Report BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 101 AS chTableId, NEW.reportUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 101 AND chEntityPk = NEW.reportUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_101 AFTER UPDATE ON Report BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 101 AS chTableId, NEW.reportUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 101 AND chEntityPk = NEW.reportUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_101 AFTER DELETE ON Report BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 101 AS chTableId, OLD.reportUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 101 AND chEntityPk = OLD.reportUid); END "
    _stmtList +=
        "CREATE VIEW Report_ReceiveView AS  SELECT Report.*, ReportReplicate.* FROM Report LEFT JOIN ReportReplicate ON ReportReplicate.reportPk = Report.reportUid "
    _stmtList +=
        " CREATE TRIGGER report_remote_insert_ins INSTEAD OF INSERT ON Report_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Report(reportUid, reportOwnerUid, xAxis, reportDateRangeSelection, fromDate, fromRelTo, fromRelOffSet, fromRelUnit, toDate, toRelTo, toRelOffSet, toRelUnit, reportTitle, reportDescription, reportSeries, reportInactive, isTemplate, priority, reportTitleId, reportDescId, reportMasterChangeSeqNum, reportLocalChangeSeqNum, reportLastChangedBy, reportLct) VALUES (NEW.reportUid, NEW.reportOwnerUid, NEW.xAxis, NEW.reportDateRangeSelection, NEW.fromDate, NEW.fromRelTo, NEW.fromRelOffSet, NEW.fromRelUnit, NEW.toDate, NEW.toRelTo, NEW.toRelOffSet, NEW.toRelUnit, NEW.reportTitle, NEW.reportDescription, NEW.reportSeries, NEW.reportInactive, NEW.isTemplate, NEW.priority, NEW.reportTitleId, NEW.reportDescId, NEW.reportMasterChangeSeqNum, NEW.reportLocalChangeSeqNum, NEW.reportLastChangedBy, NEW.reportLct) /*psql ON CONFLICT (reportUid) DO UPDATE SET reportOwnerUid = EXCLUDED.reportOwnerUid, xAxis = EXCLUDED.xAxis, reportDateRangeSelection = EXCLUDED.reportDateRangeSelection, fromDate = EXCLUDED.fromDate, fromRelTo = EXCLUDED.fromRelTo, fromRelOffSet = EXCLUDED.fromRelOffSet, fromRelUnit = EXCLUDED.fromRelUnit, toDate = EXCLUDED.toDate, toRelTo = EXCLUDED.toRelTo, toRelOffSet = EXCLUDED.toRelOffSet, toRelUnit = EXCLUDED.toRelUnit, reportTitle = EXCLUDED.reportTitle, reportDescription = EXCLUDED.reportDescription, reportSeries = EXCLUDED.reportSeries, reportInactive = EXCLUDED.reportInactive, isTemplate = EXCLUDED.isTemplate, priority = EXCLUDED.priority, reportTitleId = EXCLUDED.reportTitleId, reportDescId = EXCLUDED.reportDescId, reportMasterChangeSeqNum = EXCLUDED.reportMasterChangeSeqNum, reportLocalChangeSeqNum = EXCLUDED.reportLocalChangeSeqNum, reportLastChangedBy = EXCLUDED.reportLastChangedBy, reportLct = EXCLUDED.reportLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_189 AFTER INSERT ON Site BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 189 AS chTableId, NEW.siteUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 189 AND chEntityPk = NEW.siteUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_189 AFTER UPDATE ON Site BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 189 AS chTableId, NEW.siteUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 189 AND chEntityPk = NEW.siteUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_189 AFTER DELETE ON Site BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 189 AS chTableId, OLD.siteUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 189 AND chEntityPk = OLD.siteUid); END "
    _stmtList +=
        "CREATE VIEW Site_ReceiveView AS  SELECT Site.*, SiteReplicate.* FROM Site LEFT JOIN SiteReplicate ON SiteReplicate.sitePk = Site.siteUid "
    _stmtList +=
        " CREATE TRIGGER site_remote_insert_ins INSTEAD OF INSERT ON Site_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Site(siteUid, sitePcsn, siteLcsn, siteLcb, siteLct, siteName, guestLogin, registrationAllowed, authSalt) VALUES (NEW.siteUid, NEW.sitePcsn, NEW.siteLcsn, NEW.siteLcb, NEW.siteLct, NEW.siteName, NEW.guestLogin, NEW.registrationAllowed, NEW.authSalt) /*psql ON CONFLICT (siteUid) DO UPDATE SET sitePcsn = EXCLUDED.sitePcsn, siteLcsn = EXCLUDED.siteLcsn, siteLcb = EXCLUDED.siteLcb, siteLct = EXCLUDED.siteLct, siteName = EXCLUDED.siteName, guestLogin = EXCLUDED.guestLogin, registrationAllowed = EXCLUDED.registrationAllowed, authSalt = EXCLUDED.authSalt*/; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_301 AFTER INSERT ON LearnerGroup BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 301 AS chTableId, NEW.learnerGroupUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 301 AND chEntityPk = NEW.learnerGroupUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_301 AFTER UPDATE ON LearnerGroup BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 301 AS chTableId, NEW.learnerGroupUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 301 AND chEntityPk = NEW.learnerGroupUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_301 AFTER DELETE ON LearnerGroup BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 301 AS chTableId, OLD.learnerGroupUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 301 AND chEntityPk = OLD.learnerGroupUid); END "
    _stmtList +=
        "CREATE VIEW LearnerGroup_ReceiveView AS  SELECT LearnerGroup.*, LearnerGroupReplicate.* FROM LearnerGroup LEFT JOIN LearnerGroupReplicate ON LearnerGroupReplicate.lgPk = LearnerGroup.learnerGroupUid "
    _stmtList +=
        " CREATE TRIGGER learnergroup_remote_insert_ins INSTEAD OF INSERT ON LearnerGroup_ReceiveView FOR EACH ROW BEGIN REPLACE INTO LearnerGroup(learnerGroupUid, learnerGroupName, learnerGroupDescription, learnerGroupActive, learnerGroupMCSN, learnerGroupCSN, learnerGroupLCB, learnerGroupLct) VALUES (NEW.learnerGroupUid, NEW.learnerGroupName, NEW.learnerGroupDescription, NEW.learnerGroupActive, NEW.learnerGroupMCSN, NEW.learnerGroupCSN, NEW.learnerGroupLCB, NEW.learnerGroupLct) /*psql ON CONFLICT (learnerGroupUid) DO UPDATE SET learnerGroupName = EXCLUDED.learnerGroupName, learnerGroupDescription = EXCLUDED.learnerGroupDescription, learnerGroupActive = EXCLUDED.learnerGroupActive, learnerGroupMCSN = EXCLUDED.learnerGroupMCSN, learnerGroupCSN = EXCLUDED.learnerGroupCSN, learnerGroupLCB = EXCLUDED.learnerGroupLCB, learnerGroupLct = EXCLUDED.learnerGroupLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_300 AFTER INSERT ON LearnerGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 300 AS chTableId, NEW.learnerGroupMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 300 AND chEntityPk = NEW.learnerGroupMemberUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_300 AFTER UPDATE ON LearnerGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 300 AS chTableId, NEW.learnerGroupMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 300 AND chEntityPk = NEW.learnerGroupMemberUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_300 AFTER DELETE ON LearnerGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 300 AS chTableId, OLD.learnerGroupMemberUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 300 AND chEntityPk = OLD.learnerGroupMemberUid); END "
    _stmtList +=
        "CREATE VIEW LearnerGroupMember_ReceiveView AS  SELECT LearnerGroupMember.*, LearnerGroupMemberReplicate.* FROM LearnerGroupMember LEFT JOIN LearnerGroupMemberReplicate ON LearnerGroupMemberReplicate.lgmPk = LearnerGroupMember.learnerGroupMemberUid "
    _stmtList +=
        " CREATE TRIGGER learnergroupmember_remote_insert_ins INSTEAD OF INSERT ON LearnerGroupMember_ReceiveView FOR EACH ROW BEGIN REPLACE INTO LearnerGroupMember(learnerGroupMemberUid, learnerGroupMemberPersonUid, learnerGroupMemberLgUid, learnerGroupMemberRole, learnerGroupMemberActive, learnerGroupMemberMCSN, learnerGroupMemberCSN, learnerGroupMemberLCB, learnerGroupMemberLct) VALUES (NEW.learnerGroupMemberUid, NEW.learnerGroupMemberPersonUid, NEW.learnerGroupMemberLgUid, NEW.learnerGroupMemberRole, NEW.learnerGroupMemberActive, NEW.learnerGroupMemberMCSN, NEW.learnerGroupMemberCSN, NEW.learnerGroupMemberLCB, NEW.learnerGroupMemberLct) /*psql ON CONFLICT (learnerGroupMemberUid) DO UPDATE SET learnerGroupMemberPersonUid = EXCLUDED.learnerGroupMemberPersonUid, learnerGroupMemberLgUid = EXCLUDED.learnerGroupMemberLgUid, learnerGroupMemberRole = EXCLUDED.learnerGroupMemberRole, learnerGroupMemberActive = EXCLUDED.learnerGroupMemberActive, learnerGroupMemberMCSN = EXCLUDED.learnerGroupMemberMCSN, learnerGroupMemberCSN = EXCLUDED.learnerGroupMemberCSN, learnerGroupMemberLCB = EXCLUDED.learnerGroupMemberLCB, learnerGroupMemberLct = EXCLUDED.learnerGroupMemberLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_302 AFTER INSERT ON GroupLearningSession BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 302 AS chTableId, NEW.groupLearningSessionUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 302 AND chEntityPk = NEW.groupLearningSessionUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_302 AFTER UPDATE ON GroupLearningSession BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 302 AS chTableId, NEW.groupLearningSessionUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 302 AND chEntityPk = NEW.groupLearningSessionUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_302 AFTER DELETE ON GroupLearningSession BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 302 AS chTableId, OLD.groupLearningSessionUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 302 AND chEntityPk = OLD.groupLearningSessionUid); END "
    _stmtList +=
        "CREATE VIEW GroupLearningSession_ReceiveView AS  SELECT GroupLearningSession.*, GroupLearningSessionReplicate.* FROM GroupLearningSession LEFT JOIN GroupLearningSessionReplicate ON GroupLearningSessionReplicate.glsPk = GroupLearningSession.groupLearningSessionUid "
    _stmtList +=
        " CREATE TRIGGER grouplearningsession_remote_insert_ins INSTEAD OF INSERT ON GroupLearningSession_ReceiveView FOR EACH ROW BEGIN REPLACE INTO GroupLearningSession(groupLearningSessionUid, groupLearningSessionContentUid, groupLearningSessionLearnerGroupUid, groupLearningSessionInactive, groupLearningSessionMCSN, groupLearningSessionCSN, groupLearningSessionLCB, groupLearningSessionLct) VALUES (NEW.groupLearningSessionUid, NEW.groupLearningSessionContentUid, NEW.groupLearningSessionLearnerGroupUid, NEW.groupLearningSessionInactive, NEW.groupLearningSessionMCSN, NEW.groupLearningSessionCSN, NEW.groupLearningSessionLCB, NEW.groupLearningSessionLct) /*psql ON CONFLICT (groupLearningSessionUid) DO UPDATE SET groupLearningSessionContentUid = EXCLUDED.groupLearningSessionContentUid, groupLearningSessionLearnerGroupUid = EXCLUDED.groupLearningSessionLearnerGroupUid, groupLearningSessionInactive = EXCLUDED.groupLearningSessionInactive, groupLearningSessionMCSN = EXCLUDED.groupLearningSessionMCSN, groupLearningSessionCSN = EXCLUDED.groupLearningSessionCSN, groupLearningSessionLCB = EXCLUDED.groupLearningSessionLCB, groupLearningSessionLct = EXCLUDED.groupLearningSessionLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_272 AFTER INSERT ON SiteTerms BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 272 AS chTableId, NEW.sTermsUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 272 AND chEntityPk = NEW.sTermsUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_272 AFTER UPDATE ON SiteTerms BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 272 AS chTableId, NEW.sTermsUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 272 AND chEntityPk = NEW.sTermsUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_272 AFTER DELETE ON SiteTerms BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 272 AS chTableId, OLD.sTermsUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 272 AND chEntityPk = OLD.sTermsUid); END "
    _stmtList +=
        "CREATE VIEW SiteTerms_ReceiveView AS  SELECT SiteTerms.*, SiteTermsReplicate.* FROM SiteTerms LEFT JOIN SiteTermsReplicate ON SiteTermsReplicate.stPk = SiteTerms.sTermsUid "
    _stmtList +=
        " CREATE TRIGGER siteterms_remote_insert_ins INSTEAD OF INSERT ON SiteTerms_ReceiveView FOR EACH ROW BEGIN REPLACE INTO SiteTerms(sTermsUid, termsHtml, sTermsLang, sTermsLangUid, sTermsActive, sTermsLastChangedBy, sTermsPrimaryCsn, sTermsLocalCsn, sTermsLct) VALUES (NEW.sTermsUid, NEW.termsHtml, NEW.sTermsLang, NEW.sTermsLangUid, NEW.sTermsActive, NEW.sTermsLastChangedBy, NEW.sTermsPrimaryCsn, NEW.sTermsLocalCsn, NEW.sTermsLct) /*psql ON CONFLICT (sTermsUid) DO UPDATE SET termsHtml = EXCLUDED.termsHtml, sTermsLang = EXCLUDED.sTermsLang, sTermsLangUid = EXCLUDED.sTermsLangUid, sTermsActive = EXCLUDED.sTermsActive, sTermsLastChangedBy = EXCLUDED.sTermsLastChangedBy, sTermsPrimaryCsn = EXCLUDED.sTermsPrimaryCsn, sTermsLocalCsn = EXCLUDED.sTermsLocalCsn, sTermsLct = EXCLUDED.sTermsLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_134 AFTER INSERT ON ClazzContentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 134 AS chTableId, NEW.ccjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 134 AND chEntityPk = NEW.ccjUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_134 AFTER UPDATE ON ClazzContentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 134 AS chTableId, NEW.ccjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 134 AND chEntityPk = NEW.ccjUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_134 AFTER DELETE ON ClazzContentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 134 AS chTableId, OLD.ccjUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 134 AND chEntityPk = OLD.ccjUid); END "
    _stmtList +=
        "CREATE VIEW ClazzContentJoin_ReceiveView AS  SELECT ClazzContentJoin.*, ClazzContentJoinReplicate.* FROM ClazzContentJoin LEFT JOIN ClazzContentJoinReplicate ON ClazzContentJoinReplicate.ccjPk = ClazzContentJoin.ccjUid "
    _stmtList +=
        " CREATE TRIGGER clazzcontentjoin_remote_insert_ins INSTEAD OF INSERT ON ClazzContentJoin_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ClazzContentJoin(ccjUid, ccjContentEntryUid, ccjClazzUid, ccjActive, ccjLocalChangeSeqNum, ccjMasterChangeSeqNum, ccjLastChangedBy, ccjLct) VALUES (NEW.ccjUid, NEW.ccjContentEntryUid, NEW.ccjClazzUid, NEW.ccjActive, NEW.ccjLocalChangeSeqNum, NEW.ccjMasterChangeSeqNum, NEW.ccjLastChangedBy, NEW.ccjLct) /*psql ON CONFLICT (ccjUid) DO UPDATE SET ccjContentEntryUid = EXCLUDED.ccjContentEntryUid, ccjClazzUid = EXCLUDED.ccjClazzUid, ccjActive = EXCLUDED.ccjActive, ccjLocalChangeSeqNum = EXCLUDED.ccjLocalChangeSeqNum, ccjMasterChangeSeqNum = EXCLUDED.ccjMasterChangeSeqNum, ccjLastChangedBy = EXCLUDED.ccjLastChangedBy, ccjLct = EXCLUDED.ccjLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_512 AFTER INSERT ON PersonParentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 512 AS chTableId, NEW.ppjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 512 AND chEntityPk = NEW.ppjUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_512 AFTER UPDATE ON PersonParentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 512 AS chTableId, NEW.ppjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 512 AND chEntityPk = NEW.ppjUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_512 AFTER DELETE ON PersonParentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 512 AS chTableId, OLD.ppjUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 512 AND chEntityPk = OLD.ppjUid); END "
    _stmtList +=
        "CREATE VIEW PersonParentJoin_ReceiveView AS  SELECT PersonParentJoin.*, PersonParentJoinReplicate.* FROM PersonParentJoin LEFT JOIN PersonParentJoinReplicate ON PersonParentJoinReplicate.ppjPk = PersonParentJoin.ppjUid "
    _stmtList +=
        " CREATE TRIGGER personparentjoin_remote_insert_ins INSTEAD OF INSERT ON PersonParentJoin_ReceiveView FOR EACH ROW BEGIN REPLACE INTO PersonParentJoin(ppjUid, ppjPcsn, ppjLcsn, ppjLcb, ppjLct, ppjParentPersonUid, ppjMinorPersonUid, ppjRelationship, ppjEmail, ppjPhone, ppjInactive, ppjStatus, ppjApprovalTiemstamp, ppjApprovalIpAddr) VALUES (NEW.ppjUid, NEW.ppjPcsn, NEW.ppjLcsn, NEW.ppjLcb, NEW.ppjLct, NEW.ppjParentPersonUid, NEW.ppjMinorPersonUid, NEW.ppjRelationship, NEW.ppjEmail, NEW.ppjPhone, NEW.ppjInactive, NEW.ppjStatus, NEW.ppjApprovalTiemstamp, NEW.ppjApprovalIpAddr) /*psql ON CONFLICT (ppjUid) DO UPDATE SET ppjPcsn = EXCLUDED.ppjPcsn, ppjLcsn = EXCLUDED.ppjLcsn, ppjLcb = EXCLUDED.ppjLcb, ppjLct = EXCLUDED.ppjLct, ppjParentPersonUid = EXCLUDED.ppjParentPersonUid, ppjMinorPersonUid = EXCLUDED.ppjMinorPersonUid, ppjRelationship = EXCLUDED.ppjRelationship, ppjEmail = EXCLUDED.ppjEmail, ppjPhone = EXCLUDED.ppjPhone, ppjInactive = EXCLUDED.ppjInactive, ppjStatus = EXCLUDED.ppjStatus, ppjApprovalTiemstamp = EXCLUDED.ppjApprovalTiemstamp, ppjApprovalIpAddr = EXCLUDED.ppjApprovalIpAddr */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_48 AFTER INSERT ON ScopedGrant BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 48 AS chTableId, NEW.sgUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 48 AND chEntityPk = NEW.sgUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_48 AFTER UPDATE ON ScopedGrant BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 48 AS chTableId, NEW.sgUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 48 AND chEntityPk = NEW.sgUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_48 AFTER DELETE ON ScopedGrant BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 48 AS chTableId, OLD.sgUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 48 AND chEntityPk = OLD.sgUid); END "
    _stmtList +=
        "CREATE VIEW ScopedGrant_ReceiveView AS  SELECT ScopedGrant.*, ScopedGrantReplicate.* FROM ScopedGrant LEFT JOIN ScopedGrantReplicate ON ScopedGrantReplicate.sgPk = ScopedGrant.sgUid "
    _stmtList +=
        " CREATE TRIGGER sg_remote_insert_ins INSTEAD OF INSERT ON ScopedGrant_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ScopedGrant(sgUid, sgPcsn, sgLcsn, sgLcb, sgLct, sgTableId, sgEntityUid, sgPermissions, sgGroupUid, sgIndex, sgFlags) VALUES (NEW.sgUid, NEW.sgPcsn, NEW.sgLcsn, NEW.sgLcb, NEW.sgLct, NEW.sgTableId, NEW.sgEntityUid, NEW.sgPermissions, NEW.sgGroupUid, NEW.sgIndex, NEW.sgFlags) /*psql ON CONFLICT(sgUid) DO UPDATE SET sgLct = EXCLUDED.sgLct, sgPermissions = EXCLUDED.sgPermissions */ ; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_419 AFTER INSERT ON ErrorReport BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 419 AS chTableId, NEW.errUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 419 AND chEntityPk = NEW.errUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_419 AFTER UPDATE ON ErrorReport BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 419 AS chTableId, NEW.errUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 419 AND chEntityPk = NEW.errUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_419 AFTER DELETE ON ErrorReport BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 419 AS chTableId, OLD.errUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 419 AND chEntityPk = OLD.errUid); END "
    _stmtList +=
        "CREATE VIEW ErrorReport_ReceiveView AS  SELECT ErrorReport.*, ErrorReportReplicate.* FROM ErrorReport LEFT JOIN ErrorReportReplicate ON ErrorReportReplicate.erPk = ErrorReport.errUid "
    _stmtList +=
        " CREATE TRIGGER errorreport_remote_insert_ins INSTEAD OF INSERT ON ErrorReport_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ErrorReport(errUid, errPcsn, errLcsn, errLcb, errLct, severity, timestamp, presenterUri, appVersion, versionCode, errorCode, operatingSys, osVersion, stackTrace, message) VALUES (NEW.errUid, NEW.errPcsn, NEW.errLcsn, NEW.errLcb, NEW.errLct, NEW.severity, NEW.timestamp, NEW.presenterUri, NEW.appVersion, NEW.versionCode, NEW.errorCode, NEW.operatingSys, NEW.osVersion, NEW.stackTrace, NEW.message) /*psql ON CONFLICT (errUid) DO UPDATE SET errPcsn = EXCLUDED.errPcsn, errLcsn = EXCLUDED.errLcsn, errLcb = EXCLUDED.errLcb, errLct = EXCLUDED.errLct, severity = EXCLUDED.severity, timestamp = EXCLUDED.timestamp, presenterUri = EXCLUDED.presenterUri, appVersion = EXCLUDED.appVersion, versionCode = EXCLUDED.versionCode, errorCode = EXCLUDED.errorCode, operatingSys = EXCLUDED.operatingSys, osVersion = EXCLUDED.osVersion, stackTrace = EXCLUDED.stackTrace, message = EXCLUDED.message */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_520 AFTER INSERT ON ClazzAssignment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 520 AS chTableId, NEW.caUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 520 AND chEntityPk = NEW.caUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_520 AFTER UPDATE ON ClazzAssignment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 520 AS chTableId, NEW.caUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 520 AND chEntityPk = NEW.caUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_520 AFTER DELETE ON ClazzAssignment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 520 AS chTableId, OLD.caUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 520 AND chEntityPk = OLD.caUid); END "
    _stmtList +=
        "CREATE VIEW ClazzAssignment_ReceiveView AS  SELECT ClazzAssignment.*, ClazzAssignmentReplicate.* FROM ClazzAssignment LEFT JOIN ClazzAssignmentReplicate ON ClazzAssignmentReplicate.caPk = ClazzAssignment.caUid "
    _stmtList +=
        " CREATE TRIGGER clazzassignment_remote_insert_ins INSTEAD OF INSERT ON ClazzAssignment_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ClazzAssignment(caUid, caTitle, caDescription, caGroupUid, caActive, caClassCommentEnabled, caPrivateCommentsEnabled, caRequireFileSubmission, caFileType, caSizeLimit, caNumberOfFiles, caSubmissionPolicy, caMarkingType, caRequireTextSubmission, caTextLimitType, caTextLimit, caXObjectUid, caClazzUid, caLocalChangeSeqNum, caMasterChangeSeqNum, caLastChangedBy, caLct) VALUES (NEW.caUid, NEW.caTitle, NEW.caDescription, NEW.caGroupUid, NEW.caActive, NEW.caClassCommentEnabled, NEW.caPrivateCommentsEnabled, NEW.caRequireFileSubmission, NEW.caFileType, NEW.caSizeLimit, NEW.caNumberOfFiles, NEW.caSubmissionPolicy, NEW.caMarkingType,NEW.caRequireTextSubmission, NEW.caTextLimitType, NEW.caTextLimit, NEW.caXObjectUid, NEW.caClazzUid, NEW.caLocalChangeSeqNum, NEW.caMasterChangeSeqNum, NEW.caLastChangedBy, NEW.caLct) /*psql ON CONFLICT (caUid) DO UPDATE SET caTitle = EXCLUDED.caTitle, caDescription = EXCLUDED.caDescription, caGroupUid = EXCLUDED.caGroupUid, caActive = EXCLUDED.caActive, caClassCommentEnabled = EXCLUDED.caClassCommentEnabled, caPrivateCommentsEnabled = EXCLUDED.caPrivateCommentsEnabled, caRequireFileSubmission = EXCLUDED.caRequireFileSubmission, caFileType = EXCLUDED.caFileType, caSizeLimit = EXCLUDED.caSizeLimit, caNumberOfFiles = EXCLUDED.caNumberOfFiles, caSubmissionPolicy = EXCLUDED.caSubmissionPolicy, caMarkingType = EXCLUDED.caMarkingType, caRequireTextSubmission = EXCLUDED.caRequireTextSubmission, caTextLimitType = EXCLUDED.caTextLimitType, caTextLimit = EXCLUDED.caTextLimit, caXObjectUid = EXCLUDED.caXObjectUid, caClazzUid = EXCLUDED.caClazzUid, caLocalChangeSeqNum = EXCLUDED.caLocalChangeSeqNum, caMasterChangeSeqNum = EXCLUDED.caMasterChangeSeqNum, caLastChangedBy = EXCLUDED.caLastChangedBy, caLct = EXCLUDED.caLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_521 AFTER INSERT ON ClazzAssignmentContentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 521 AS chTableId, NEW.cacjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 521 AND chEntityPk = NEW.cacjUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_521 AFTER UPDATE ON ClazzAssignmentContentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 521 AS chTableId, NEW.cacjUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 521 AND chEntityPk = NEW.cacjUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_521 AFTER DELETE ON ClazzAssignmentContentJoin BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 521 AS chTableId, OLD.cacjUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 521 AND chEntityPk = OLD.cacjUid); END "
    _stmtList +=
        "CREATE VIEW ClazzAssignmentContentJoin_ReceiveView AS  SELECT ClazzAssignmentContentJoin.*, ClazzAssignmentContentJoinReplicate.* FROM ClazzAssignmentContentJoin LEFT JOIN ClazzAssignmentContentJoinReplicate ON ClazzAssignmentContentJoinReplicate.cacjPk = ClazzAssignmentContentJoin.cacjUid "
    _stmtList +=
        " CREATE TRIGGER clazzassignmentcontentjoin_remote_insert_ins INSTEAD OF INSERT ON ClazzAssignmentContentJoin_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ClazzAssignmentContentJoin(cacjUid, cacjContentUid, cacjAssignmentUid, cacjActive,cacjWeight, cacjMCSN, cacjLCSN, cacjLCB, cacjLct) VALUES (NEW.cacjUid, NEW.cacjContentUid, NEW.cacjAssignmentUid, NEW.cacjActive, NEW.cacjWeight, NEW.cacjMCSN, NEW.cacjLCSN, NEW.cacjLCB, NEW.cacjLct) /*psql ON CONFLICT (cacjUid) DO UPDATE SET cacjContentUid = EXCLUDED.cacjContentUid, cacjAssignmentUid = EXCLUDED.cacjAssignmentUid, cacjActive = EXCLUDED.cacjActive, cacjWeight = EXCLUDED.cacjWeight, cacjMCSN = EXCLUDED.cacjMCSN, cacjLCSN = EXCLUDED.cacjLCSN, cacjLCB = EXCLUDED.cacjLCB, cacjLct = EXCLUDED.cacjLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_522 AFTER INSERT ON CourseAssignmentSubmission BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 522 AS chTableId, NEW.casUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 522 AND chEntityPk = NEW.casUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_522 AFTER UPDATE ON CourseAssignmentSubmission BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 522 AS chTableId, NEW.casUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 522 AND chEntityPk = NEW.casUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_522 AFTER DELETE ON CourseAssignmentSubmission BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 522 AS chTableId, OLD.casUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 522 AND chEntityPk = OLD.casUid); END "
    _stmtList +=
        "CREATE VIEW CourseAssignmentSubmission_ReceiveView AS  SELECT CourseAssignmentSubmission.*, CourseAssignmentSubmissionReplicate.* FROM CourseAssignmentSubmission LEFT JOIN CourseAssignmentSubmissionReplicate ON CourseAssignmentSubmissionReplicate.casPk = CourseAssignmentSubmission.casUid "
    _stmtList +=
        " CREATE TRIGGER courseassignmentsubmission_remote_insert_ins INSTEAD OF INSERT ON CourseAssignmentSubmission_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseAssignmentSubmission(casUid, casAssignmentUid, casSubmitterUid, casSubmitterPersonUid, casText, casType, casTimestamp) VALUES (NEW.casUid, NEW.casAssignmentUid, NEW.casSubmitterUid, NEW.casSubmitterPersonUid, NEW.casText, NEW.casType, NEW.casTimestamp) /*psql ON CONFLICT (casUid) DO UPDATE SET casAssignmentUid = EXCLUDED.casAssignmentUid, casSubmitterUid = EXCLUDED.casSubmitterUid, casSubmitterPersonUid = EXCLUDED.casSubmitterPersonUid, casText = EXCLUDED.casText, casType = EXCLUDED.casType, casTimestamp = EXCLUDED.casTimestamp */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_90 AFTER INSERT ON CourseAssignmentSubmissionAttachment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 90 AS chTableId, NEW.casaUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 90 AND chEntityPk = NEW.casaUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_90 AFTER UPDATE ON CourseAssignmentSubmissionAttachment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 90 AS chTableId, NEW.casaUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 90 AND chEntityPk = NEW.casaUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_90 AFTER DELETE ON CourseAssignmentSubmissionAttachment BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 90 AS chTableId, OLD.casaUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 90 AND chEntityPk = OLD.casaUid); END "
    _stmtList +=
        "CREATE VIEW CourseAssignmentSubmissionAttachment_ReceiveView AS  SELECT CourseAssignmentSubmissionAttachment.*, CourseAssignmentSubmissionAttachmentReplicate.* FROM CourseAssignmentSubmissionAttachment LEFT JOIN CourseAssignmentSubmissionAttachmentReplicate ON CourseAssignmentSubmissionAttachmentReplicate.casaPk = CourseAssignmentSubmissionAttachment.casaUid "
    _stmtList +=
        " CREATE TRIGGER courseassignmentsubmissionattachment_remote_insert_ins INSTEAD OF INSERT ON CourseAssignmentSubmissionAttachment_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseAssignmentSubmissionAttachment(casaUid, casaSubmissionUid, casaMimeType,casaFileName, casaUri, casaMd5, casaSize, casaTimestamp) VALUES (NEW.casaUid, NEW.casaSubmissionUid, NEW.casaMimeType, NEW.casaFileName, NEW.casaUri, NEW.casaMd5, NEW.casaSize, NEW.casaTimestamp) /*psql ON CONFLICT (casaUid) DO UPDATE SET casaSubmissionUid = EXCLUDED.casaSubmissionUid, casaMimeType = EXCLUDED.casaMimeType, casaFileName = EXCLUDED.casaFileName, casaUri = EXCLUDED.casaUri, casaMd5 = EXCLUDED.casaMd5, casaSize = EXCLUDED.casaSize, casaTimestamp = EXCLUDED.casaTimestamp */; END "
    _stmtList += """
    |
    |        CREATE TRIGGER ATTUPD_CourseAssignmentSubmissionAttachment
    |        AFTER UPDATE ON CourseAssignmentSubmissionAttachment FOR EACH ROW WHEN
    |        OLD.casaMd5 IS NOT NULL
    |        BEGIN
    |        
    |        INSERT INTO ZombieAttachmentData(zaUri) 
    |        SELECT OLD.casaUri AS zaUri
    |          FROM CourseAssignmentSubmissionAttachment   
    |         WHERE CourseAssignmentSubmissionAttachment.casaUid = OLD.casaUid
    |           AND (SELECT COUNT(*) 
    |                  FROM CourseAssignmentSubmissionAttachment
    |                 WHERE casaMd5 = OLD.casaMd5) = 0
    |    ; 
    |        END
    |    
    """.trimMargin()
    _stmtList +=
        " CREATE TRIGGER ch_ins_523 AFTER INSERT ON CourseAssignmentMark BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 523 AS chTableId, NEW.camUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 523 AND chEntityPk = NEW.camUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_523 AFTER UPDATE ON CourseAssignmentMark BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 523 AS chTableId, NEW.camUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 523 AND chEntityPk = NEW.camUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_523 AFTER DELETE ON CourseAssignmentMark BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 523 AS chTableId, OLD.camUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 523 AND chEntityPk = OLD.camUid); END "
    _stmtList +=
        "CREATE VIEW CourseAssignmentMark_ReceiveView AS  SELECT CourseAssignmentMark.*, CourseAssignmentMarkReplicate.* FROM CourseAssignmentMark LEFT JOIN CourseAssignmentMarkReplicate ON CourseAssignmentMarkReplicate.camPk = CourseAssignmentMark.camUid "
    _stmtList +=
        " CREATE TRIGGER courseassignmentmark_remote_insert_ins INSTEAD OF INSERT ON CourseAssignmentMark_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseAssignmentMark(camUid, camAssignmentUid, camSubmitterUid, camMark, camPenalty, camLct) VALUES (NEW.camUid, NEW.camAssignmentUid, NEW.camSubmitterUid, NEW.camMark, NEW.camPenalty, NEW.camLct) /*psql ON CONFLICT (camUid) DO UPDATE SET camAssignmentUid = EXCLUDED.camAssignmentUid, camSubmitterUid = EXCLUDED.camSubmitterUid, camMark = EXCLUDED.camMark, camPenalty = EXCLUDED.camPenalty, camLct = EXCLUDED.camLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_678 AFTER INSERT ON PersonAuth2 BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 678 AS chTableId, NEW.pauthUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 678 AND chEntityPk = NEW.pauthUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_678 AFTER UPDATE ON PersonAuth2 BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 678 AS chTableId, NEW.pauthUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 678 AND chEntityPk = NEW.pauthUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_678 AFTER DELETE ON PersonAuth2 BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 678 AS chTableId, OLD.pauthUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 678 AND chEntityPk = OLD.pauthUid); END "
    _stmtList +=
        "CREATE VIEW PersonAuth2_ReceiveView AS  SELECT PersonAuth2.*, PersonAuth2Replicate.* FROM PersonAuth2 LEFT JOIN PersonAuth2Replicate ON PersonAuth2Replicate.paPk = PersonAuth2.pauthUid "
    _stmtList +=
        " CREATE TRIGGER personauth2_remote_insert_ins INSTEAD OF INSERT ON PersonAuth2_ReceiveView FOR EACH ROW BEGIN REPLACE INTO PersonAuth2(pauthUid, pauthMechanism, pauthAuth, pauthLcsn, pauthPcsn, pauthLcb, pauthLct) VALUES (NEW.pauthUid, NEW.pauthMechanism, NEW.pauthAuth, NEW.pauthLcsn, NEW.pauthPcsn, NEW.pauthLcb, NEW.pauthLct) /*psql ON CONFLICT (pauthUid) DO UPDATE SET pauthMechanism = EXCLUDED.pauthMechanism, pauthAuth = EXCLUDED.pauthAuth, pauthLcsn = EXCLUDED.pauthLcsn, pauthPcsn = EXCLUDED.pauthPcsn, pauthLcb = EXCLUDED.pauthLcb, pauthLct = EXCLUDED.pauthLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_679 AFTER INSERT ON UserSession BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 679 AS chTableId, NEW.usUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 679 AND chEntityPk = NEW.usUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_679 AFTER UPDATE ON UserSession BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 679 AS chTableId, NEW.usUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 679 AND chEntityPk = NEW.usUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_679 AFTER DELETE ON UserSession BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 679 AS chTableId, OLD.usUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 679 AND chEntityPk = OLD.usUid); END "
    _stmtList +=
        "CREATE VIEW UserSession_ReceiveView AS  SELECT UserSession.*, UserSessionReplicate.* FROM UserSession LEFT JOIN UserSessionReplicate ON UserSessionReplicate.usPk = UserSession.usUid "
    _stmtList +=
        " CREATE TRIGGER usersession_remote_insert_ins INSTEAD OF INSERT ON UserSession_ReceiveView FOR EACH ROW BEGIN REPLACE INTO UserSession(usUid, usPcsn, usLcsn, usLcb, usLct, usPersonUid, usClientNodeId, usStartTime, usEndTime, usStatus, usReason, usAuth, usSessionType) VALUES (NEW.usUid, NEW.usPcsn, NEW.usLcsn, NEW.usLcb, NEW.usLct, NEW.usPersonUid, NEW.usClientNodeId, NEW.usStartTime, NEW.usEndTime, NEW.usStatus, NEW.usReason, NEW.usAuth, NEW.usSessionType) /*psql ON CONFLICT (usUid) DO UPDATE SET usPcsn = EXCLUDED.usPcsn, usLcsn = EXCLUDED.usLcsn, usLcb = EXCLUDED.usLcb, usLct = EXCLUDED.usLct, usPersonUid = EXCLUDED.usPersonUid, usClientNodeId = EXCLUDED.usClientNodeId, usStartTime = EXCLUDED.usStartTime, usEndTime = EXCLUDED.usEndTime, usStatus = EXCLUDED.usStatus, usReason = EXCLUDED.usReason, usAuth = EXCLUDED.usAuth, usSessionType = EXCLUDED.usSessionType */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_124 AFTER INSERT ON CourseBlock BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 124 AS chTableId, NEW.cbUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 124 AND chEntityPk = NEW.cbUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_124 AFTER UPDATE ON CourseBlock BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 124 AS chTableId, NEW.cbUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 124 AND chEntityPk = NEW.cbUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_124 AFTER DELETE ON CourseBlock BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 124 AS chTableId, OLD.cbUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 124 AND chEntityPk = OLD.cbUid); END "
    _stmtList +=
        "CREATE VIEW CourseBlock_ReceiveView AS  SELECT CourseBlock.*, CourseBlockReplicate.* FROM CourseBlock LEFT JOIN CourseBlockReplicate ON CourseBlockReplicate.cbPk = CourseBlock.cbUid "
    _stmtList +=
        " CREATE TRIGGER courseblock_remote_insert_ins INSTEAD OF INSERT ON CourseBlock_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseBlock(cbUid, cbType, cbIndentLevel, cbModuleParentBlockUid, cbTitle, cbDescription, cbCompletionCriteria, cbHideUntilDate, cbDeadlineDate, cbLateSubmissionPenalty, cbGracePeriodDate, cbMaxPoints,cbMinPoints, cbIndex, cbClazzUid, cbActive,cbHidden, cbEntityUid, cbLct) VALUES (NEW.cbUid, NEW.cbType, NEW.cbIndentLevel, NEW.cbModuleParentBlockUid, NEW.cbTitle, NEW.cbDescription, NEW.cbCompletionCriteria, NEW.cbHideUntilDate, NEW.cbDeadlineDate, NEW.cbLateSubmissionPenalty, NEW.cbGracePeriodDate, NEW.cbMaxPoints,NEW.cbMinPoints, NEW.cbIndex, NEW.cbClazzUid,NEW.cbActive, NEW.cbHidden, NEW.cbEntityUid, NEW.cbLct) /*psql ON CONFLICT (cbUid) DO UPDATE SET cbType = EXCLUDED.cbType, cbIndentLevel = EXCLUDED.cbIndentLevel, cbModuleParentBlockUid = EXCLUDED.cbModuleParentBlockUid, cbTitle = EXCLUDED.cbTitle, cbDescription = EXCLUDED.cbDescription, cbCompletionCriteria = EXCLUDED.cbCompletionCriteria, cbHideUntilDate = EXCLUDED.cbHideUntilDate,cbDeadlineDate = EXCLUDED.cbDeadlineDate, cbLateSubmissionPenalty = EXCLUDED.cbLateSubmissionPenalty, cbGracePeriodDate= EXCLUDED.cbGracePeriodDate, cbMaxPoints = EXCLUDED.cbMaxPoints, cbMinPoints = EXCLUDED.cbMinPoints, cbIndex = EXCLUDED.cbIndex,cbClazzUid = EXCLUDED.cbClazzUid, cbActive = EXCLUDED.cbActive, cbHidden = EXCLUDED.cbHidden, cbEntityUid = EXCLUDED.cbEntityUid, cbLct = EXCLUDED.cbLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_450 AFTER INSERT ON CourseTerminology BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 450 AS chTableId, NEW.ctUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 450 AND chEntityPk = NEW.ctUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_450 AFTER UPDATE ON CourseTerminology BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 450 AS chTableId, NEW.ctUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 450 AND chEntityPk = NEW.ctUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_450 AFTER DELETE ON CourseTerminology BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 450 AS chTableId, OLD.ctUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 450 AND chEntityPk = OLD.ctUid); END "
    _stmtList +=
        "CREATE VIEW CourseTerminology_ReceiveView AS  SELECT CourseTerminology.*, CourseTerminologyReplicate.* FROM CourseTerminology LEFT JOIN CourseTerminologyReplicate ON CourseTerminologyReplicate.ctPk = CourseTerminology.ctUid "
    _stmtList +=
        " CREATE TRIGGER courseterminology_remote_insert_ins INSTEAD OF INSERT ON CourseTerminology_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseTerminology(ctUid, ctTitle, ctTerminology, ctLct) VALUES (NEW.ctUid, NEW.ctTitle, NEW.ctTerminology, NEW.ctLct) /*psql ON CONFLICT (ctUid) DO UPDATE SET ctTitle = EXCLUDED.ctTitle, ctTerminology = EXCLUDED.ctTerminology, ctLct = EXCLUDED.ctLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_242 AFTER INSERT ON CourseGroupSet BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 242 AS chTableId, NEW.cgsUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 242 AND chEntityPk = NEW.cgsUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_242 AFTER UPDATE ON CourseGroupSet BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 242 AS chTableId, NEW.cgsUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 242 AND chEntityPk = NEW.cgsUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_242 AFTER DELETE ON CourseGroupSet BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 242 AS chTableId, OLD.cgsUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 242 AND chEntityPk = OLD.cgsUid); END "
    _stmtList +=
        "CREATE VIEW CourseGroupSet_ReceiveView AS  SELECT CourseGroupSet.*, CourseGroupSetReplicate.* FROM CourseGroupSet LEFT JOIN CourseGroupSetReplicate ON CourseGroupSetReplicate.cgsPk = CourseGroupSet.cgsUid "
    _stmtList +=
        " CREATE TRIGGER coursegroupset_remote_insert_ins INSTEAD OF INSERT ON CourseGroupSet_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseGroupSet(cgsUid, cgsName, cgsTotalGroups, cgsActive, cgsClazzUid, cgsLct) VALUES (NEW.cgsUid, NEW.cgsName, NEW.cgsTotalGroups, NEW.cgsActive, NEW.cgsClazzUid, NEW.cgsLct) /*psql ON CONFLICT (cgsUid) DO UPDATE SET cgsName = EXCLUDED.cgsName, cgsTotalGroups = EXCLUDED.cgsTotalGroups, cgsActive = EXCLUDED.cgsActive, cgsClazzUid = EXCLUDED.cgsClazzUid, cgsLct = EXCLUDED.cgsLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_243 AFTER INSERT ON CourseGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 243 AS chTableId, NEW.cgmUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 243 AND chEntityPk = NEW.cgmUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_243 AFTER UPDATE ON CourseGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 243 AS chTableId, NEW.cgmUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 243 AND chEntityPk = NEW.cgmUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_243 AFTER DELETE ON CourseGroupMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 243 AS chTableId, OLD.cgmUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 243 AND chEntityPk = OLD.cgmUid); END "
    _stmtList +=
        "CREATE VIEW CourseGroupMember_ReceiveView AS  SELECT CourseGroupMember.*, CourseGroupMemberReplicate.* FROM CourseGroupMember LEFT JOIN CourseGroupMemberReplicate ON CourseGroupMemberReplicate.cgmPk = CourseGroupMember.cgmUid "
    _stmtList +=
        " CREATE TRIGGER coursegroupmember_remote_insert_ins INSTEAD OF INSERT ON CourseGroupMember_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseGroupMember(cgmUid, cgmSetUid, cgmGroupNumber, cgmPersonUid, cgmLct) VALUES (NEW.cgmUid, NEW.cgmSetUid, NEW.cgmGroupNumber, NEW.cgmPersonUid, NEW.cgmLct) /*psql ON CONFLICT (cgmUid) DO UPDATE SET cgmSetUid = EXCLUDED.cgmSetUid, cgmGroupNumber = EXCLUDED.cgmGroupNumber, cgmPersonUid = EXCLUDED.cgmPersonUid, cgmLct = EXCLUDED.cgmLct */; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_125 AFTER INSERT ON CoursePicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 125 AS chTableId, NEW.coursePictureUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 125 AND chEntityPk = NEW.coursePictureUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_125 AFTER UPDATE ON CoursePicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 125 AS chTableId, NEW.coursePictureUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 125 AND chEntityPk = NEW.coursePictureUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_125 AFTER DELETE ON CoursePicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 125 AS chTableId, OLD.coursePictureUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 125 AND chEntityPk = OLD.coursePictureUid); END "
    _stmtList +=
        "CREATE VIEW CoursePicture_ReceiveView AS  SELECT CoursePicture.*, CoursePictureReplicate.* FROM CoursePicture LEFT JOIN CoursePictureReplicate ON CoursePictureReplicate.cpPk = CoursePicture.coursePictureUid "
    _stmtList +=
        " CREATE TRIGGER coursepicture_remote_insert_ins INSTEAD OF INSERT ON CoursePicture_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CoursePicture(coursePictureUid, coursePictureClazzUid, coursePictureMasterCsn, coursePictureLocalCsn, coursePictureLastChangedBy, coursePictureLct, coursePictureUri, coursePictureMd5, coursePictureFileSize, coursePictureTimestamp, coursePictureMimeType, coursePictureActive) VALUES (NEW.coursePictureUid, NEW.coursePictureClazzUid, NEW.coursePictureMasterCsn, NEW.coursePictureLocalCsn, NEW.coursePictureLastChangedBy, NEW.coursePictureLct, NEW.coursePictureUri, NEW.coursePictureMd5, NEW.coursePictureFileSize, NEW.coursePictureTimestamp, NEW.coursePictureMimeType, NEW.coursePictureActive) /*psql ON CONFLICT (coursePictureUid) DO UPDATE SET coursePictureClazzUid = EXCLUDED.coursePictureClazzUid, coursePictureMasterCsn = EXCLUDED.coursePictureMasterCsn, coursePictureLocalCsn = EXCLUDED.coursePictureLocalCsn, coursePictureLastChangedBy = EXCLUDED.coursePictureLastChangedBy, coursePictureLct = EXCLUDED.coursePictureLct, coursePictureUri = EXCLUDED.coursePictureUri, coursePictureMd5 = EXCLUDED.coursePictureMd5, coursePictureFileSize = EXCLUDED.coursePictureFileSize, coursePictureTimestamp = EXCLUDED.coursePictureTimestamp, coursePictureMimeType = EXCLUDED.coursePictureMimeType, coursePictureActive = EXCLUDED.coursePictureActive */; END "
    _stmtList += """
    |
    |        CREATE TRIGGER ATTUPD_CoursePicture
    |        AFTER UPDATE ON CoursePicture FOR EACH ROW WHEN
    |        OLD.coursePictureMd5 IS NOT NULL
    |        BEGIN
    |        
    |        INSERT INTO ZombieAttachmentData(zaUri) 
    |        SELECT OLD.coursePictureUri AS zaUri
    |          FROM CoursePicture   
    |         WHERE CoursePicture.coursePictureUid = OLD.coursePictureUid
    |           AND (SELECT COUNT(*) 
    |                  FROM CoursePicture
    |                 WHERE coursePictureMd5 = OLD.coursePictureMd5) = 0
    |    ; 
    |        END
    |    
    """.trimMargin()
    _stmtList +=
        " CREATE TRIGGER ch_ins_138 AFTER INSERT ON ContentEntryPicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 138 AS chTableId, NEW.cepUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 138 AND chEntityPk = NEW.cepUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_138 AFTER UPDATE ON ContentEntryPicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 138 AS chTableId, NEW.cepUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 138 AND chEntityPk = NEW.cepUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_138 AFTER DELETE ON ContentEntryPicture BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 138 AS chTableId, OLD.cepUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 138 AND chEntityPk = OLD.cepUid); END "
    _stmtList +=
        "CREATE VIEW ContentEntryPicture_ReceiveView AS  SELECT ContentEntryPicture.*, ContentEntryPictureReplicate.* FROM ContentEntryPicture LEFT JOIN ContentEntryPictureReplicate ON ContentEntryPictureReplicate.cepPk = ContentEntryPicture.cepUid "
    _stmtList +=
        " CREATE TRIGGER ceppicture_remote_insert_ins INSTEAD OF INSERT ON ContentEntryPicture_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ContentEntryPicture(cepUid, cepContentEntryUid, cepUri, cepMd5, cepFileSize, cepTimestamp, cepMimeType, cepActive) VALUES (NEW.cepUid, NEW.cepContentEntryUid, NEW.cepUri, NEW.cepMd5, NEW.cepFileSize, NEW.cepTimestamp, NEW.cepMimeType, NEW.cepActive) /*psql ON CONFLICT (cepUid) DO UPDATE SET cepContentEntryUid = EXCLUDED.cepContentEntryUid, cepUri = EXCLUDED.cepUri, cepMd5 = EXCLUDED.cepMd5, cepFileSize = EXCLUDED.cepFileSize, cepTimestamp = EXCLUDED.cepTimestamp, cepMimeType = EXCLUDED.cepMimeType, cepActive = EXCLUDED.cepActive */; END "
    _stmtList += """
    |
    |        CREATE TRIGGER ATTUPD_ContentEntryPicture
    |        AFTER UPDATE ON ContentEntryPicture FOR EACH ROW WHEN
    |        OLD.cepMd5 IS NOT NULL
    |        BEGIN
    |        
    |        INSERT INTO ZombieAttachmentData(zaUri) 
    |        SELECT OLD.cepUri AS zaUri
    |          FROM ContentEntryPicture   
    |         WHERE ContentEntryPicture.cepUid = OLD.cepUid
    |           AND (SELECT COUNT(*) 
    |                  FROM ContentEntryPicture
    |                 WHERE cepMd5 = OLD.cepMd5) = 0
    |    ; 
    |        END
    |    
    """.trimMargin()
    _stmtList +=
        " CREATE TRIGGER ch_ins_127 AFTER INSERT ON Chat BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 127 AS chTableId, NEW.chatUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 127 AND chEntityPk = NEW.chatUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_127 AFTER UPDATE ON Chat BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 127 AS chTableId, NEW.chatUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 127 AND chEntityPk = NEW.chatUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_127 AFTER DELETE ON Chat BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 127 AS chTableId, OLD.chatUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 127 AND chEntityPk = OLD.chatUid); END "
    _stmtList +=
        "CREATE VIEW Chat_ReceiveView AS  SELECT Chat.*, ChatReplicate.* FROM Chat LEFT JOIN ChatReplicate ON ChatReplicate.chatPk = Chat.chatUid "
    _stmtList +=
        " CREATE TRIGGER chat_remote_insert_ins INSTEAD OF INSERT ON Chat_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Chat(chatUid, chatStartDate, chatTitle, chatGroup, chatLct) VALUES(NEW.chatUid, NEW.chatStartDate, NEW.chatTitle, NEW.chatGroup, NEW.chatLct) /*psql ON CONFLICT (chatUid) DO UPDATE SET chatStartDate = EXCLUDED.chatStartDate, chatTitle = EXCLUDED.chatTitle, chatGroup = EXCLUDED.chatGroup, chatLct = EXCLUDED.chatLct */ ; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_128 AFTER INSERT ON ChatMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 128 AS chTableId, NEW.chatMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 128 AND chEntityPk = NEW.chatMemberUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_128 AFTER UPDATE ON ChatMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 128 AS chTableId, NEW.chatMemberUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 128 AND chEntityPk = NEW.chatMemberUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_128 AFTER DELETE ON ChatMember BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 128 AS chTableId, OLD.chatMemberUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 128 AND chEntityPk = OLD.chatMemberUid); END "
    _stmtList +=
        "CREATE VIEW ChatMember_ReceiveView AS  SELECT ChatMember.*, ChatMemberReplicate.* FROM ChatMember LEFT JOIN ChatMemberReplicate ON ChatMemberReplicate.chatMemberPk = ChatMember.chatMemberUid "
    _stmtList +=
        " CREATE TRIGGER chatmember_remote_insert_ins INSTEAD OF INSERT ON ChatMember_ReceiveView FOR EACH ROW BEGIN REPLACE INTO ChatMember(chatMemberUid, chatMemberChatUid, chatMemberPersonUid, chatMemberJoinedDate, chatMemberLeftDate, chatMemberLct) VALUES(NEW.chatMemberUid, NEW.chatMemberChatUid, NEW.chatMemberPersonUid, NEW.chatMemberJoinedDate, NEW.chatMemberLeftDate, NEW.chatMemberLct) /*psql ON CONFLICT (chatMemberUid) DO UPDATE SET chatMemberChatUid = EXCLUDED.chatMemberChatUid, chatMemberPersonUid = EXCLUDED.chatMemberPersonUid, chatMemberJoinedDate = EXCLUDED.chatMemberJoinedDate, chatMemberLeftDate = EXCLUDED.chatMemberLeftDate, chatMemberLct = EXCLUDED.chatMemberLct */ ; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_126 AFTER INSERT ON Message BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 126 AS chTableId, NEW.messageUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 126 AND chEntityPk = NEW.messageUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_126 AFTER UPDATE ON Message BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 126 AS chTableId, NEW.messageUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 126 AND chEntityPk = NEW.messageUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_126 AFTER DELETE ON Message BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 126 AS chTableId, OLD.messageUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 126 AND chEntityPk = OLD.messageUid); END "
    _stmtList +=
        "CREATE VIEW Message_ReceiveView AS  SELECT Message.*, MessageReplicate.* FROM Message LEFT JOIN MessageReplicate ON MessageReplicate.messagePk = Message.messageUid "
    _stmtList +=
        " CREATE TRIGGER message_remote_insert_ins INSTEAD OF INSERT ON Message_ReceiveView FOR EACH ROW BEGIN REPLACE INTO Message(messageUid, messageSenderPersonUid, messageTableId, messageEntityUid, messageText, messageTimestamp, messageClazzUid, messageLct) VALUES(NEW.messageUid, NEW.messageSenderPersonUid, NEW.messageTableId, NEW.messageEntityUid, NEW.messageText, NEW.messageTimestamp, NEW.messageClazzUid, NEW.messageLct) /*psql ON CONFLICT (messageUid) DO UPDATE SET messageSenderPersonUid = EXCLUDED.messageSenderPersonUid, messageTableId = EXCLUDED.messageTableId, messageEntityUid = EXCLUDED.messageEntityUid, messageText = EXCLUDED.messageText, messageTimestamp = EXCLUDED.messageTimestamp, messageClazzUid = EXCLUDED.messageClazzUid, messageLct = EXCLUDED.messageLct */ ; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_129 AFTER INSERT ON MessageRead BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 129 AS chTableId, NEW.messageReadUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 129 AND chEntityPk = NEW.messageReadUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_129 AFTER UPDATE ON MessageRead BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 129 AS chTableId, NEW.messageReadUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 129 AND chEntityPk = NEW.messageReadUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_129 AFTER DELETE ON MessageRead BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 129 AS chTableId, OLD.messageReadUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 129 AND chEntityPk = OLD.messageReadUid); END "
    _stmtList +=
        "CREATE VIEW MessageRead_ReceiveView AS  SELECT MessageRead.*, MessageReadReplicate.* FROM MessageRead LEFT JOIN MessageReadReplicate ON MessageReadReplicate.messageReadPk = MessageRead.messageReadUid "
    _stmtList +=
        " CREATE TRIGGER messageread_remote_insert_ins INSTEAD OF INSERT ON MessageRead_ReceiveView FOR EACH ROW BEGIN REPLACE INTO MessageRead(messageReadUid, messageReadPersonUid, messageReadMessageUid, messageReadEntityUid, messageReadLct) VALUES(NEW.messageReadUid, NEW.messageReadPersonUid, NEW.messageReadMessageUid, NEW.messageReadEntityUid, NEW.messageReadLct) /*psql ON CONFLICT (messageReadUid) DO UPDATE SET messageReadPersonUid = EXCLUDED.messageReadPersonUid, messageReadMessageUid = EXCLUDED.messageReadMessageUid, messageReadEntityUid = EXCLUDED.messageReadEntityUid, messageReadLct = EXCLUDED.messageReadLct */ ; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_130 AFTER INSERT ON CourseDiscussion BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 130 AS chTableId, NEW.courseDiscussionUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 130 AND chEntityPk = NEW.courseDiscussionUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_130 AFTER UPDATE ON CourseDiscussion BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 130 AS chTableId, NEW.courseDiscussionUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 130 AND chEntityPk = NEW.courseDiscussionUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_130 AFTER DELETE ON CourseDiscussion BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 130 AS chTableId, OLD.courseDiscussionUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 130 AND chEntityPk = OLD.courseDiscussionUid); END "
    _stmtList +=
        "CREATE VIEW CourseDiscussion_ReceiveView AS  SELECT CourseDiscussion.*, CourseDiscussionReplicate.* FROM CourseDiscussion LEFT JOIN CourseDiscussionReplicate ON CourseDiscussionReplicate.courseDiscussionPk = CourseDiscussion.courseDiscussionUid "
    _stmtList +=
        " CREATE TRIGGER coursediscussion_remote_insert_ins INSTEAD OF INSERT ON CourseDiscussion_ReceiveView FOR EACH ROW BEGIN REPLACE INTO CourseDiscussion(courseDiscussionUid, courseDiscussionActive, courseDiscussionTitle, courseDiscussionDesc, courseDiscussionClazzUid, courseDiscussionLct) VALUES(NEW.courseDiscussionUid, NEW.courseDiscussionActive, NEW.courseDiscussionTitle, NEW.courseDiscussionDesc, NEW.courseDiscussionClazzUid, NEW.courseDiscussionLct) /*psql ON CONFLICT (courseDiscussionUid) DO UPDATE SET courseDiscussionActive = EXCLUDED.courseDiscussionActive, courseDiscussionTitle = EXCLUDED.courseDiscussionTitle, courseDiscussionDesc = EXCLUDED.courseDiscussionDesc, courseDiscussionClazzUid = EXCLUDED.courseDiscussionClazzUid, courseDiscussionLct = EXCLUDED.courseDiscussionLct */ ; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_131 AFTER INSERT ON DiscussionTopic BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 131 AS chTableId, NEW.discussionTopicUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 131 AND chEntityPk = NEW.discussionTopicUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_131 AFTER UPDATE ON DiscussionTopic BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 131 AS chTableId, NEW.discussionTopicUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 131 AND chEntityPk = NEW.discussionTopicUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_131 AFTER DELETE ON DiscussionTopic BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 131 AS chTableId, OLD.discussionTopicUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 131 AND chEntityPk = OLD.discussionTopicUid); END "
    _stmtList +=
        "CREATE VIEW DiscussionTopic_ReceiveView AS  SELECT DiscussionTopic.*, DiscussionTopicReplicate.* FROM DiscussionTopic LEFT JOIN DiscussionTopicReplicate ON DiscussionTopicReplicate.discussionTopicPk = DiscussionTopic.discussionTopicUid "
    _stmtList +=
        " CREATE TRIGGER discussiontopic_remote_insert_ins INSTEAD OF INSERT ON DiscussionTopic_ReceiveView FOR EACH ROW BEGIN REPLACE INTO DiscussionTopic(discussionTopicUid, discussionTopicTitle, discussionTopicDesc, discussionTopicStartDate, discussionTopicCourseDiscussionUid, discussionTopicVisible, discussionTopicArchive, discussionTopicIndex, discussionTopicClazzUid, discussionTopicLct) VALUES(NEW.discussionTopicUid, NEW.discussionTopicTitle, NEW.discussionTopicDesc, NEW.discussionTopicStartDate, NEW.discussionTopicCourseDiscussionUid, NEW.discussionTopicVisible, NEW.discussionTopicArchive, NEW.discussionTopicIndex, NEW.discussionTopicClazzUid, NEW.discussionTopicLct) /*psql ON CONFLICT (discussionTopicUid) DO UPDATE SET discussionTopicTitle = EXCLUDED.discussionTopicTitle, discussionTopicDesc = EXCLUDED.discussionTopicDesc, discussionTopicStartDate = EXCLUDED.discussionTopicStartDate, discussionTopicCourseDiscussionUid = EXCLUDED.discussionTopicCourseDiscussionUid, discussionTopicVisible = EXCLUDED.discussionTopicVisible, discussionTopicArchive = EXCLUDED.discussionTopicArchive, discussionTopicIndex = EXCLUDED.discussionTopicIndex, discussionTopicClazzUid = EXCLUDED.discussionTopicClazzUid, discussionTopicLct = EXCLUDED.discussionTopicLct */ ; END "
    _stmtList +=
        " CREATE TRIGGER ch_ins_132 AFTER INSERT ON DiscussionPost BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 132 AS chTableId, NEW.discussionPostUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 132 AND chEntityPk = NEW.discussionPostUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_upd_132 AFTER UPDATE ON DiscussionPost BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 132 AS chTableId, NEW.discussionPostUid AS chEntityPk, 1 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 132 AND chEntityPk = NEW.discussionPostUid); END "
    _stmtList +=
        " CREATE TRIGGER ch_del_132 AFTER DELETE ON DiscussionPost BEGIN INSERT INTO ChangeLog(chTableId, chEntityPk, chType) SELECT 132 AS chTableId, OLD.discussionPostUid AS chEntityPk, 2 AS chType WHERE NOT EXISTS( SELECT chTableId FROM ChangeLog WHERE chTableId = 132 AND chEntityPk = OLD.discussionPostUid); END "
    _stmtList +=
        "CREATE VIEW DiscussionPost_ReceiveView AS  SELECT DiscussionPost.*, DiscussionPostReplicate.* FROM DiscussionPost LEFT JOIN DiscussionPostReplicate ON DiscussionPostReplicate.discussionPostPk = DiscussionPost.discussionPostUid "
    _stmtList +=
        " CREATE TRIGGER discussionpost_remote_insert_ins INSTEAD OF INSERT ON DiscussionPost_ReceiveView FOR EACH ROW BEGIN REPLACE INTO DiscussionPost(discussionPostUid, discussionPostTitle, discussionPostMessage, discussionPostStartDate, discussionPostDiscussionTopicUid, discussionPostVisible, discussionPostArchive, discussionPostStartedPersonUid, discussionPostClazzUid, discussionPostLct) VALUES(NEW.discussionPostUid, NEW.discussionPostTitle, NEW.discussionPostMessage, NEW.discussionPostStartDate, NEW.discussionPostDiscussionTopicUid, NEW.discussionPostVisible, NEW.discussionPostArchive, NEW.discussionPostStartedPersonUid, NEW.discussionPostClazzUid, NEW.discussionPostLct) /*psql ON CONFLICT (discussionPostUid) DO UPDATE SET discussionPostTitle = EXCLUDED.discussionPostTitle , discussionPostMessage = EXCLUDED.discussionPostMessage , discussionPostStartDate = EXCLUDED.discussionPostStartDate , discussionPostDiscussionTopicUid = EXCLUDED.discussionPostDiscussionTopicUid, discussionPostVisible = EXCLUDED.discussionPostVisible , discussionPostArchive = EXCLUDED.discussionPostArchive , discussionPostStartedPersonUid = EXCLUDED.discussionPostStartedPersonUid , discussionPostClazzUid = EXCLUDED.discussionPostClazzUid, discussionPostLct = EXCLUDED.discussionPostLct */ ; END "
    _stmtList.forEach {
      db.execSQL(it)
    }
  }

  public override fun onOpen(db: DoorSqlDatabase): Unit {
  }
}
