package com.ustadmobile.core.db.dao

import androidx.paging.DataSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.Chat
import com.ustadmobile.lib.db.entities.ChatWithLatestMessageAndCount
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.List

public class ChatDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: ChatDao,
) : ChatDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun findAllChatsForUser(searchBit: String, personUid: Long):
      DataSource.Factory<Int, ChatWithLatestMessageAndCount> = _dao.findAllChatsForUser(searchBit,
      personUid)

  public override suspend fun getTitleChat(chatUid: Long, personUid: Long): String? =
      _dao.getTitleChat(chatUid, personUid)

  public override suspend fun getChatByOtherPerson(otherPersonUid: Long, loggedInPersonUid: Long):
      Chat? = _dao.getChatByOtherPerson(otherPersonUid, loggedInPersonUid)

  public override fun insert(entity: Chat): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.chatUid == 0L) {
      val _newPk = _pkManager.nextId(127)
      entity.chatUid = _newPk
    }
    entity.chatLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.chatUid
  }

  public override suspend fun insertAsync(entity: Chat): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.chatUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(127)
      entity.chatUid = _newPk
    }
    entity.chatLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.chatUid
  }

  public override fun insertList(entityList: List<Chat>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.chatUid == 0L) {
        val _newPk = _pkManager.nextId(127)
        it.chatUid = _newPk
        _generatedPks += _newPk
      }
      it.chatLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<Chat>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.chatLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: Chat): Unit {
    entity.chatLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
