package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Query
import com.ustadmobile.lib.db.entities.ChatMember
import kotlin.Long
import kotlin.Unit

@Dao
public actual abstract class ChatMemberDao : BaseDao<ChatMember> {
  @Query(`value` =
      "\n     REPLACE INTO chatMemberReplicate(chatMemberPk, chatMemberDestination)\n      SELECT DISTINCT ChatMember.chatMemberUid AS chatMemberPk,\n             :newNodeId AS chatMemberDestination\n             \n        FROM UserSession\n            JOIN ChatMember \n                 ON ((ChatMember.chatMemberChatUid IN\n                      (SELECT chatMemberInternal.chatMemberChatUid \n                         FROM ChatMember chatMemberInternal\n                        WHERE chatMemberInternal.chatMemberPersonUid = UserSession.usPersonUid))\n                     OR UserSession.usSessionType = 2)\n                 AND UserSession.usStatus = 1 \n       WHERE ChatMember.chatMemberLct != COALESCE(\n             (SELECT chatMemberVersionId\n                FROM chatMemberReplicate\n               WHERE chatMemberPk = ChatMember.chatMemberUid\n                 AND chatMemberDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(chatMemberPk, chatMemberDestination) DO UPDATE\n             SET chatMemberPending = true\n      */       \n    ")
  public actual abstract suspend fun replicateOnNewNode(newNodeId: Long): Unit

  @Query(`value` =
      "\n         REPLACE INTO chatMemberReplicate(chatMemberPk, chatMemberDestination)\n          SELECT DISTINCT ChatMember.chatMemberUid AS chatMemberUid,\n                 UserSession.usClientNodeId AS chatMemberDestination\n            FROM ChangeLog\n                 JOIN chatMember\n                     ON ChangeLog.chTableId = 128\n                        AND ChangeLog.chEntityPk = ChatMember.chatMemberUid\n                        \n                 JOIN UserSession ON \n                      (UserSession.usSessionType = 2\n                      OR (UserSession.usPersonUid IN \n                           (SELECT ChatMember.chatMemberPersonUid \n                              FROM ChatMember \n                             WHERE ChatMember.chatMemberChatUid IN \n                                   (SELECT ChatMemberInternal.chatMemberChatUid \n                                      FROM ChatMember ChatMemberInternal\n                                     WHERE ChatMemberInternal.chatMemberPersonUid = \n                                           UserSession.usPersonUid))))\n                      AND UserSession.usStatus = 1\n                      \n                \n           WHERE UserSession.usClientNodeId != (\n                 SELECT nodeClientId \n                   FROM SyncNode\n                  LIMIT 1)\n             AND ChatMember.chatMemberLct != COALESCE(\n                 (SELECT chatMemberVersionId\n                    FROM chatMemberReplicate\n                   WHERE chatMemberPk = ChatMember.chatMemberUid\n                     AND chatMemberDestination = UserSession.usClientNodeId), 0)\n         /*psql ON CONFLICT(chatMemberPk, chatMemberDestination) DO UPDATE\n             SET chatMemberPending = true\n          */               \n    ")
  public actual abstract suspend fun replicateOnChange(): Unit
}
