package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.ChatMember
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

public class ChatMemberDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: ChatMemberDao,
) : ChatMemberDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun insert(entity: ChatMember): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.chatMemberUid == 0L) {
      val _newPk = _pkManager.nextId(128)
      entity.chatMemberUid = _newPk
    }
    entity.chatMemberLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.chatMemberUid
  }

  public override suspend fun insertAsync(entity: ChatMember): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.chatMemberUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(128)
      entity.chatMemberUid = _newPk
    }
    entity.chatMemberLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.chatMemberUid
  }

  public override fun insertList(entityList: List<ChatMember>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.chatMemberUid == 0L) {
        val _newPk = _pkManager.nextId(128)
        it.chatMemberUid = _newPk
        _generatedPks += _newPk
      }
      it.chatMemberLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<ChatMember>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.chatMemberLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: ChatMember): Unit {
    entity.chatMemberLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
