package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.ClazzAssignmentRollUp
import io.ktor.client.HttpClient
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class ClazzAssignmentRollUpDao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: ClazzAssignmentRollUpDao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : ClazzAssignmentRollUpDao() {
  public override suspend fun cacheBestStatements(
    clazzUid: Long,
    assignmentUid: Long,
    personUid: Long,
  ): Unit {
    _dao.cacheBestStatements(clazzUid, assignmentUid, personUid)
  }

  public override suspend fun deleteCachedInactiveContent(caUid: Long): Unit {
    _dao.deleteCachedInactiveContent(caUid)
  }

  public override suspend fun invalidateCacheByAssignment(changedAssignmentUid: Long): Unit {
    _dao.invalidateCacheByAssignment(changedAssignmentUid)
  }

  public override suspend fun invalidateCacheByAssignmentList(changedAssignmentUid: List<Long>):
      Unit {
    _dao.invalidateCacheByAssignmentList(changedAssignmentUid)
  }

  public override fun insert(entity: ClazzAssignmentRollUp): Long {
    val _result = _dao.insert(entity)
    return _result
  }

  public override suspend fun insertAsync(entity: ClazzAssignmentRollUp): Long {
    val _result = _dao.insertAsync(entity)
    return _result
  }

  public override fun insertList(entityList: List<ClazzAssignmentRollUp>): Unit {
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<ClazzAssignmentRollUp>): Unit {
    _dao.updateList(entityList)
  }

  public override fun update(entity: ClazzAssignmentRollUp): Unit {
    _dao.update(entity)
  }
}
