package com.ustadmobile.core.db.dao

import androidx.lifecycle.LiveData
import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.ConnectivityStatus
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Unit

@Dao
public actual abstract class ConnectivityStatusDao {
  @Query(`value` = "SELECT ConnectivityStatus.* FROM ConnectivityStatus LIMIT 1")
  public actual abstract fun statusLive(): LiveData<ConnectivityStatus?>

  @Query(`value` = "SELECT ConnectivityStatus.* FROM ConnectivityStatus LIMIT 1")
  public actual abstract fun status(): ConnectivityStatus?

  @Insert(onConflict = 1)
  public actual abstract fun insert(connectivityStatus: ConnectivityStatus): Long

  @Insert(onConflict = 1)
  public actual abstract suspend fun insertAsync(connectivityStatus: ConnectivityStatus): Long

  @Query(`value` = "UPDATE ConnectivityStatus SET connectivityState = :connectivityState")
  public actual abstract suspend fun updateStateAsync(connectivityState: Int): Unit

  @Query(`value` =
      "UPDATE ConnectivityStatus SET connectivityState = :connectivityState , wifiSsid = :wifiSsid")
  public actual abstract suspend fun updateState(connectivityState: Int, wifiSsid: String): Unit

  @Query(`value` =
      "UPDATE ConnectivityStatus SET connectivityState = :connectivityState , wifiSsid = :wifiSsid")
  public actual abstract fun updateStateSync(connectivityState: Int, wifiSsid: String): Unit
}
