package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionAttachment
import io.ktor.client.HttpClient
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class CourseAssignmentSubmissionAttachmentDao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: CourseAssignmentSubmissionAttachmentDao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : CourseAssignmentSubmissionAttachmentDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override suspend
      fun insertListAsync(entityList: List<CourseAssignmentSubmissionAttachment>): Unit {
    _dao.insertListAsync(entityList)
  }

  public override fun insert(entity: CourseAssignmentSubmissionAttachment): Long {
    val _result = _dao.insert(entity)
    return _result
  }

  public override suspend fun insertAsync(entity: CourseAssignmentSubmissionAttachment): Long {
    val _result = _dao.insertAsync(entity)
    return _result
  }

  public override fun insertList(entityList: List<CourseAssignmentSubmissionAttachment>): Unit {
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<CourseAssignmentSubmissionAttachment>): Unit {
    _dao.updateList(entityList)
  }

  public override fun update(entity: CourseAssignmentSubmissionAttachment): Unit {
    _dao.update(entity)
  }
}
