package com.ustadmobile.core.db.dao

import androidx.lifecycle.LiveData
import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.CourseDiscussion
import kotlin.Boolean
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

@Dao
public actual abstract class CourseDiscussionDao : BaseDao<CourseDiscussion>,
    OneToManyJoinDao<CourseDiscussion> {
  @Query(`value` =
      "\n     REPLACE INTO CourseDiscussionReplicate(courseDiscussionPk, courseDiscussionDestination)\n      SELECT DISTINCT CourseDiscussion.courseDiscussionUid AS courseDiscussionPk,\n             :newNodeId AS courseDiscussionDestination\n             \n       FROM UserSession\n             JOIN PersonGroupMember \n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                  2 \n                  \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n                  \n             JOIN CourseDiscussion \n                  ON CourseDiscussion.courseDiscussionClazzUid = Clazz.clazzUid\n                  \n       WHERE CourseDiscussion.courseDiscussionLct != COALESCE(\n             (SELECT courseDiscussionVersionId\n                FROM courseDiscussionReplicate\n               WHERE courseDiscussionPk = CourseDiscussion.courseDiscussionUid\n                 AND courseDiscussionDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(courseDiscussionPk, courseDiscussionDestination) DO UPDATE\n             SET courseDiscussionPending = true\n      */       \n    ")
  public actual abstract suspend fun replicateOnNewNode(newNodeId: Long): Unit

  @Query(`value` =
      "\n        REPLACE INTO CourseDiscussionReplicate(courseDiscussionPk, courseDiscussionDestination)\n          SELECT DISTINCT CourseDiscussion.courseDiscussionUid AS courseDiscussionUid,\n                 UserSession.usClientNodeId AS courseDiscussionDestination\n            FROM ChangeLog\n                 JOIN CourseDiscussion\n                     ON ChangeLog.chTableId = 130\n                        AND ChangeLog.chEntityPk = CourseDiscussion.courseDiscussionUid\n                 JOIN Clazz\n                      ON Clazz.clazzUid = CourseDiscussion.courseDiscussionClazzUid\n                 \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n                  2\n                 \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n                 \n           WHERE UserSession.usClientNodeId != (\n                 SELECT nodeClientId \n                   FROM SyncNode\n                  LIMIT 1)\n             AND CourseDiscussion.courseDiscussionLct != COALESCE(\n                 (SELECT courseDiscussionVersionId\n                    FROM courseDiscussionReplicate\n                   WHERE courseDiscussionPk = CourseDiscussion.courseDiscussionUid\n                     AND courseDiscussionDestination = UserSession.usClientNodeId), 0)\n         /*psql ON CONFLICT(courseDiscussionPk, courseDiscussionDestination) DO UPDATE\n             SET courseDiscussionPending = true\n          */               \n    ")
  public actual abstract suspend fun replicateOnChange(): Unit

  @Query(`value` =
      "\n        UPDATE CourseDiscussion \n           SET courseDiscussionActive = :active, \n               courseDiscussionLct = :changeTime\n         WHERE courseDiscussionUid = :cbUid")
  public actual abstract suspend fun updateActiveByUid(
    cbUid: Long,
    active: Boolean,
    changeTime: Long,
  ): Unit

  @Query(`value` =
      "\n        SELECT CourseDiscussion.* \n          FROM CourseDiscussion\n         WHERE CourseDiscussion.courseDiscussionUid = :courseDiscussionUid \n           AND CAST(CourseDiscussion.courseDiscussionActive AS INTEGER) = 1 \n         \n         ")
  public actual abstract fun getCourseDiscussionByUid(courseDiscussionUid: Long):
      LiveData<CourseDiscussion?>

  @Insert(onConflict = 1)
  public actual abstract suspend fun replaceListAsync(list: List<CourseDiscussion>): Unit
}
