package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.GroupLearningSession
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

public class GroupLearningSessionDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: GroupLearningSessionDao,
) : GroupLearningSessionDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun insert(entity: GroupLearningSession): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.groupLearningSessionUid == 0L) {
      val _newPk = _pkManager.nextId(302)
      entity.groupLearningSessionUid = _newPk
    }
    entity.groupLearningSessionLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.groupLearningSessionUid
  }

  public override suspend fun insertAsync(entity: GroupLearningSession): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.groupLearningSessionUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(302)
      entity.groupLearningSessionUid = _newPk
    }
    entity.groupLearningSessionLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.groupLearningSessionUid
  }

  public override fun insertList(entityList: List<GroupLearningSession>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.groupLearningSessionUid == 0L) {
        val _newPk = _pkManager.nextId(302)
        it.groupLearningSessionUid = _newPk
        _generatedPks += _newPk
      }
      it.groupLearningSessionLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<GroupLearningSession>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.groupLearningSessionLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: GroupLearningSession): Unit {
    entity.groupLearningSessionLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
