package com.ustadmobile.core.db.dao

import androidx.lifecycle.LiveData
import androidx.paging.DataSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.HolidayCalendar
import com.ustadmobile.lib.db.entities.HolidayCalendarWithNumEntries
import kotlin.Int
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

public class HolidayCalendarDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: HolidayCalendarDao,
) : HolidayCalendarDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun findAllHolidaysWithEntriesCount():
      DataSource.Factory<Int, HolidayCalendarWithNumEntries> =
      _dao.findAllHolidaysWithEntriesCount()

  public override fun replaceList(list: List<HolidayCalendar>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    list.iterator().forEach  {
      if(it.umCalendarUid == 0L) {
        val _newPk = _pkManager.nextId(28)
        it.umCalendarUid = _newPk
        _generatedPks += _newPk
      }
      it.umCalendarLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.replaceList(list)
  }

  public override fun findAllHolidaysLiveData(): LiveData<List<HolidayCalendar>> =
      _dao.findAllHolidaysLiveData()

  public override fun findByUidLive(uid: Long): LiveData<HolidayCalendar?> = _dao.findByUidLive(uid)

  public override suspend fun updateAsync(entity: HolidayCalendar): Int {
    entity.umCalendarLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    return _dao.updateAsync(entity)
  }

  public override suspend fun findByUid(uid: Long): HolidayCalendar? = _dao.findByUid(uid)

  public override suspend fun findByUidAsync(uid: Long): HolidayCalendar? = _dao.findByUidAsync(uid)

  public override fun insert(entity: HolidayCalendar): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.umCalendarUid == 0L) {
      val _newPk = _pkManager.nextId(28)
      entity.umCalendarUid = _newPk
    }
    entity.umCalendarLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.umCalendarUid
  }

  public override suspend fun insertAsync(entity: HolidayCalendar): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.umCalendarUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(28)
      entity.umCalendarUid = _newPk
    }
    entity.umCalendarLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.umCalendarUid
  }

  public override fun insertList(entityList: List<HolidayCalendar>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.umCalendarUid == 0L) {
        val _newPk = _pkManager.nextId(28)
        it.umCalendarUid = _newPk
        _generatedPks += _newPk
      }
      it.umCalendarLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<HolidayCalendar>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.umCalendarLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: HolidayCalendar): Unit {
    entity.umCalendarLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
