package com.ustadmobile.core.db.dao

import androidx.paging.DataSource
import androidx.room.Dao
import androidx.room.Query
import com.ustadmobile.lib.db.entities.LearnerGroup
import kotlin.Int
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

@Dao
public actual abstract class LearnerGroupDao : BaseDao<LearnerGroup> {
  @Query(`value` =
      "\n     REPLACE INTO LearnerGroupReplicate(lgPk, lgDestination)\n      SELECT DISTINCT LearnerGroup.learnerGroupUid AS lgPk,\n             :newNodeId AS lgDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                  64\n                  \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n             JOIN LearnerGroupMember\n                  ON LearnerGroupMember.learnerGroupMemberPersonUid = Person.personUid\n             JOIN LearnerGroup\n                  ON LearnerGroup.learnerGroupUid = LearnerGroupMember.learnerGroupMemberLgUid\n            WHERE UserSession.usClientNodeId = :newNodeId\n              AND UserSession.usStatus = 1\n              AND LearnerGroup.learnerGroupLct != COALESCE(\n                  (SELECT lgVersionId\n                     FROM LearnerGroupReplicate\n                    WHERE lgPk = LearnerGroup.learnerGroupUid\n                      AND lgDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(lgPk, lgDestination) DO UPDATE\n             SET lgPending = true\n      */       \n ")
  public actual abstract suspend fun replicateOnNewNode(newNodeId: Long): Unit

  @Query(`value` =
      "\n REPLACE INTO LearnerGroupReplicate(lgPk, lgDestination)\n  SELECT DISTINCT LearnerGroup.learnerGroupUid AS lgUid,\n         UserSession.usClientNodeId AS lgDestination\n    FROM ChangeLog\n         JOIN LearnerGroup\n              ON ChangeLog.chTableId = 301\n                 AND ChangeLog.chEntityPk = LearnerGroup.learnerGroupUid\n         JOIN LearnerGroupMember\n              ON LearnerGroupMember.learnerGroupMemberLgUid = LearnerGroup.learnerGroupUid\n         JOIN Person\n              ON Person.personUid = LearnerGroupMember.learnerGroupMemberPersonUid\n         \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n              64\n              \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n /*psql ON CONFLICT(lgPk, lgDestination) DO UPDATE\n     SET lgPending = true\n  */               \n    ")
  public actual abstract suspend fun replicateOnChange(): Unit

  @Query(`value` =
      "SELECT LearnerGroup.* FROM LearnerGroup \n            LEFT JOIN GroupLearningSession ON \n            GroupLearningSession.groupLearningSessionLearnerGroupUid = LearnerGroup.learnerGroupUid \n            WHERE GroupLearningSession.groupLearningSessionContentUid = :contentEntryUid")
  public actual abstract fun findGroupsForEntryAsync(contentEntryUid: Long):
      DataSource.Factory<Int, LearnerGroup>

  @Query(`value` =
      "SELECT LearnerGroup.* FROM LearnerGroup \n            LEFT JOIN GroupLearningSession ON \n            GroupLearningSession.groupLearningSessionLearnerGroupUid = LearnerGroup.learnerGroupUid \n            WHERE GroupLearningSession.groupLearningSessionContentUid = :contentEntryUid")
  public actual abstract fun findGroupListForEntry(contentEntryUid: Long): List<LearnerGroup>
}
