package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.PersonAuth2
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.List

@Dao
public actual abstract class PersonAuth2Dao {
  @Query(`value` =
      "\n     REPLACE INTO PersonAuth2Replicate(paPk, paDestination)\n      SELECT DISTINCT PersonAuth2.pauthUid AS paUid,\n             :newNodeId AS paDestination\n        FROM UserSession\n        JOIN PersonGroupMember\n             ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n        \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                562949953421312\n                \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n        JOIN PersonAuth2\n             ON PersonAuth2.pauthUid = Person.personUid\n       WHERE UserSession.usClientNodeId = :newNodeId      \n         AND PersonAuth2.pauthLct != COALESCE(\n             (SELECT paVersionId\n                FROM PersonAuth2Replicate\n               WHERE paPk = PersonAuth2.pauthUid\n                 AND paDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(paPk, paDestination) DO UPDATE\n             SET paPending = true\n      */       \n ")
  public actual abstract suspend fun replicateOnNewNode(newNodeId: Long): Unit

  @Query(`value` =
      "\n REPLACE INTO PersonAuth2Replicate(paPk, paDestination)\n  SELECT DISTINCT PersonAuth2.pauthUid AS paUid,\n         UserSession.usClientNodeId AS paDestination\n    FROM ChangeLog\n         JOIN PersonAuth2\n             ON ChangeLog.chTableId = 678\n                AND ChangeLog.chEntityPk = PersonAuth2.pauthUid\n         JOIN Person\n              ON Person.personUid = PersonAuth2.pauthUid\n         \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n              562949953421312\n              \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND PersonAuth2.pauthLct != COALESCE(\n         (SELECT paVersionId\n            FROM PersonAuth2Replicate\n           WHERE paPk = PersonAuth2.pauthUid\n             AND paDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(paPk, paDestination) DO UPDATE\n     SET paPending = true\n  */               \n    ")
  public actual abstract suspend fun replicateOnChange(): Unit

  @Insert(onConflict = 3)
  public actual abstract suspend fun insertListAsync(auths: List<PersonAuth2>): Unit

  @Insert(onConflict = 1)
  public actual abstract suspend fun insertAsync(auth: PersonAuth2): Long

  @Query(`value` =
      "\n        SELECT PersonAuth2.*\n          FROM PersonAuth2\n         WHERE PersonAuth2.pauthUid = :personUid \n    ")
  public actual abstract suspend fun findByPersonUid(personUid: Long): PersonAuth2?

  @Query(`value` =
      "\n        SELECT PersonAuth2.*\n          FROM PersonAuth2\n               JOIN Person ON PersonAuth2.pauthUid = Person.personUid\n         WHERE Person.username = :username\n    ")
  public actual abstract suspend fun findByUsername(username: String): PersonAuth2?
}
