package com.ustadmobile.core.db.dao

import androidx.paging.DataSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.SchoolMember
import com.ustadmobile.lib.db.entities.SchoolMemberWithPerson
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.List

public class SchoolMemberDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: SchoolMemberDao,
) : SchoolMemberDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun findByUidAsync(schoolMemberUid: Long): SchoolMember? =
      _dao.findByUidAsync(schoolMemberUid)

  public override suspend fun updateAsync(entity: SchoolMember): Int {
    entity.schoolMemberLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    return _dao.updateAsync(entity)
  }

  public override suspend fun findBySchoolAndPersonAndRole(
    schoolUid: Long,
    personUid: Long,
    role: Int,
    timeFilter: Long,
  ): List<SchoolMember> = _dao.findBySchoolAndPersonAndRole(schoolUid, personUid, role, timeFilter)

  public override fun findAllActiveMembersBySchoolAndRoleUid(
    schoolUid: Long,
    role: Int,
    sortOrder: Int,
    searchQuery: String,
    accountPersonUid: Long,
  ): DataSource.Factory<Int, SchoolMemberWithPerson> =
      _dao.findAllActiveMembersBySchoolAndRoleUid(schoolUid, role, sortOrder, searchQuery,
      accountPersonUid)

  public override suspend fun findAllTest(
    schoolUid: Long,
    role: Int,
    searchQuery: String,
  ): List<SchoolMemberWithPerson> = _dao.findAllTest(schoolUid, role, searchQuery)

  public override fun insert(entity: SchoolMember): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.schoolMemberUid == 0L) {
      val _newPk = _pkManager.nextId(200)
      entity.schoolMemberUid = _newPk
    }
    entity.schoolMemberLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.schoolMemberUid
  }

  public override suspend fun insertAsync(entity: SchoolMember): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.schoolMemberUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(200)
      entity.schoolMemberUid = _newPk
    }
    entity.schoolMemberLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.schoolMemberUid
  }

  public override fun insertList(entityList: List<SchoolMember>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.schoolMemberUid == 0L) {
        val _newPk = _pkManager.nextId(200)
        it.schoolMemberUid = _newPk
        _generatedPks += _newPk
      }
      it.schoolMemberLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<SchoolMember>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.schoolMemberLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: SchoolMember): Unit {
    entity.schoolMemberLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
