package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.StateEntity
import kotlin.Boolean
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.List

public class StateDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: StateDao,
) : StateDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun findByStateId(
    id: String?,
    agentUid: Long,
    activityId: String?,
    registration: String?,
  ): StateEntity? = _dao.findByStateId(id, agentUid, activityId, registration)

  public override fun findStateIdByAgentAndActivity(
    agentUid: Long,
    activityId: String,
    registration: String,
    since: String,
  ): List<StateEntity> = _dao.findStateIdByAgentAndActivity(agentUid, activityId, registration,
      since)

  public override fun updateStateToInActive(
    agentUid: Long,
    activityId: String,
    registration: String,
    isActive: Boolean,
    updateTime: Long,
  ): Unit {
    _dao.updateStateToInActive(agentUid, activityId, registration, isActive, updateTime)
  }

  public override fun setStateInActive(
    stateId: String,
    agentUid: Long,
    activityId: String,
    registration: String,
    isActive: Boolean,
    updateTime: Long,
  ): Unit {
    _dao.setStateInActive(stateId, agentUid, activityId, registration, isActive, updateTime)
  }

  public override fun insert(entity: StateEntity): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.stateUid == 0L) {
      val _newPk = _pkManager.nextId(70)
      entity.stateUid = _newPk
    }
    entity.stateLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.stateUid
  }

  public override suspend fun insertAsync(entity: StateEntity): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.stateUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(70)
      entity.stateUid = _newPk
    }
    entity.stateLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.stateUid
  }

  public override fun insertList(entityList: List<StateEntity>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.stateUid == 0L) {
        val _newPk = _pkManager.nextId(70)
        it.stateUid = _newPk
        _generatedPks += _newPk
      }
      it.stateLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<StateEntity>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.stateLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: StateEntity): Unit {
    entity.stateLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
