package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Query
import com.ustadmobile.lib.db.entities.XLangMapEntry
import kotlin.Int
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

@Dao
public actual abstract class XLangMapEntryDao : BaseDao<XLangMapEntry> {
  @Query(`value` =
      "\n         REPLACE INTO XLangMapEntryReplicate(xlmePk, xlmeDestination)\n          SELECT DISTINCT XLangMapEntry.statementLangMapUid AS xlmePk,\n                 :newNodeId AS xlmeDestination\n            FROM XLangMapEntry\n                 JOIN UserSession ON UserSession.usClientNodeId = :newNodeId\n             --notpsql      \n             WHERE XLangMapEntry.statementLangMapLct != COALESCE(\n                 (SELECT xlmeVersionId\n                    FROM XLangMapEntryReplicate\n                   WHERE xlmePk = XLangMapEntry.statementLangMapUid\n                     AND xlmeDestination = UserSession.usClientNodeId), 0)\n             --endnotpsql         \n          /*psql ON CONFLICT(xlmePk, xlmeDestination) DO UPDATE\n                 SET xlmePending = (SELECT XLangMapEntry.statementLangMapLct\n                                      FROM XLangmapEntry\n                                     WHERE XLangmapEntry.statementLangMapUid = EXCLUDED.xlmePk)\n                                        != XLangMapEntryReplicate.xlmeVersionId\n          */       \n     ")
  public actual abstract suspend fun replicateOnNewNode(newNodeId: Long): Unit

  @Query(`value` =
      "\n REPLACE INTO XLangMapEntryReplicate(xlmePk, xlmeDestination)\n  SELECT DISTINCT XLangMapEntry.statementLangMapUid AS xlmeUid,\n         UserSession.usClientNodeId AS xlmeDestination\n    FROM ChangeLog\n         JOIN XLangMapEntry\n             ON ChangeLog.chTableId = 74\n                AND ChangeLog.chEntityPk = XLangMapEntry.statementLangMapUid\n         JOIN UserSession ON UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND XLangMapEntry.statementLangMapLct != COALESCE(\n         (SELECT xlmeVersionId\n            FROM XLangMapEntryReplicate\n           WHERE xlmePk = XLangMapEntry.statementLangMapUid\n             AND xlmeDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(xlmePk, xlmeDestination) DO UPDATE\n     SET xlmePending = true\n  */               \n    ")
  public actual abstract suspend fun replicateOnChange(): Unit

  @Query(`value` = "SELECT * FROM XLangMapEntry WHERE objectLangMapUid IN (:ids)")
  public actual abstract suspend fun getValuesWithListOfId(ids: List<Int>): List<XLangMapEntry>

  @Query(`value` =
      "SELECT * FROM XLangMapEntry WHERE \n            verbLangMapUid = :verbUid AND languageLangMapUid = :langMapUid LIMIT 1")
  public actual abstract fun getXLangMapFromVerb(verbUid: Long, langMapUid: Long): XLangMapEntry?

  @Query(`value` =
      "SELECT * FROM XLangMapEntry WHERE \n            objectLangMapUid = :objectUid AND languageLangMapUid = :langMapUid LIMIT 1")
  public actual abstract fun getXLangMapFromObject(objectUid: Long, langMapUid: Long):
      XLangMapEntry?
}
