package com.ustadmobile.core.db.dao

import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.XObjectEntity
import io.ktor.client.HttpClient
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class XObjectDao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: XObjectDao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : XObjectDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun findByObjectId(id: String?): XObjectEntity? {
    val _result = _dao.findByObjectId(id)
    return _result
  }

  public override fun findByXobjectUid(xObjectUid: Long): XObjectEntity? {
    val _result = _dao.findByXobjectUid(xObjectUid)
    return _result
  }

  public override fun insert(entity: XObjectEntity): Long {
    val _result = _dao.insert(entity)
    return _result
  }

  public override suspend fun insertAsync(entity: XObjectEntity): Long {
    val _result = _dao.insertAsync(entity)
    return _result
  }

  public override fun insertList(entityList: List<XObjectEntity>): Unit {
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<XObjectEntity>): Unit {
    _dao.updateList(entityList)
  }

  public override fun update(entity: XObjectEntity): Unit {
    _dao.update(entity)
  }
}
