package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Chat;
import com.ustadmobile.lib.db.entities.ChatWithLatestMessageAndCount;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ChatDao_Impl extends ChatDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Chat> __insertionAdapterOfChat;

  private final EntityDeletionOrUpdateAdapter<Chat> __updateAdapterOfChat;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public ChatDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfChat = new EntityInsertionAdapter<Chat>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `Chat` (`chatUid`,`chatStartDate`,`chatTitle`,`chatGroup`,`chatLct`) VALUES (nullif(?, 0),?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Chat value) {
        stmt.bindLong(1, value.getChatUid());
        stmt.bindLong(2, value.getChatStartDate());
        if (value.getChatTitle() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getChatTitle());
        }
        final int _tmp = value.getChatGroup() ? 1 : 0;
        stmt.bindLong(4, _tmp);
        stmt.bindLong(5, value.getChatLct());
      }
    };
    this.__updateAdapterOfChat = new EntityDeletionOrUpdateAdapter<Chat>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `Chat` SET `chatUid` = ?,`chatStartDate` = ?,`chatTitle` = ?,`chatGroup` = ?,`chatLct` = ? WHERE `chatUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Chat value) {
        stmt.bindLong(1, value.getChatUid());
        stmt.bindLong(2, value.getChatStartDate());
        if (value.getChatTitle() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getChatTitle());
        }
        final int _tmp = value.getChatGroup() ? 1 : 0;
        stmt.bindLong(4, _tmp);
        stmt.bindLong(5, value.getChatLct());
        stmt.bindLong(6, value.getChatUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO chatReplicate(chatPk, chatDestination)\n"
                + "      SELECT DISTINCT Chat.chatUid AS chatPk,\n"
                + "             ? AS chatDestination\n"
                + "        FROM UserSession \n"
                + "             JOIN Chat ON \n"
                + "                  ((Chat.chatUid IN \n"
                + "                       (SELECT ChatMember.chatMemberChatUid \n"
                + "                          FROM ChatMember\n"
                + "                         WHERE ChatMember.chatMemberPersonUid = UserSession.usPersonUid))\n"
                + "                   OR UserSession.usSessionType = 2)\n"
                + "                  AND UserSession.usStatus = 1 \n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND Chat.chatLct != COALESCE(\n"
                + "             (SELECT chatVersionId\n"
                + "                FROM chatReplicate\n"
                + "               WHERE chatPk = Chat.chatUid\n"
                + "                 AND chatDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(chatPk, chatDestination) DO UPDATE\n"
                + "             SET chatPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "         REPLACE INTO chatReplicate(chatPk, chatDestination)\n"
                + "          SELECT DISTINCT Chat.chatUid AS chatUid,\n"
                + "                 UserSession.usClientNodeId AS chatDestination\n"
                + "            FROM ChangeLog\n"
                + "                 JOIN Chat\n"
                + "                      ON ChangeLog.chTableId = 127\n"
                + "                         AND ChangeLog.chEntityPk = Chat.chatUid\n"
                + "                 JOIN UserSession ON \n"
                + "                      ((UserSession.usPersonUid IN \n"
                + "                           (SELECT ChatMember.chatMemberPersonUid \n"
                + "                              FROM ChatMember \n"
                + "                             WHERE ChatMember.chatMemberChatUid = Chat.chatUid))\n"
                + "                       OR UserSession.usSessionType = 2 )\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "           WHERE UserSession.usClientNodeId != (\n"
                + "                 SELECT nodeClientId \n"
                + "                   FROM SyncNode\n"
                + "                  LIMIT 1)\n"
                + "             AND Chat.chatLct != COALESCE(\n"
                + "                 (SELECT chatVersionId\n"
                + "                    FROM chatReplicate\n"
                + "                   WHERE chatPk = Chat.chatUid\n"
                + "                     AND chatDestination = UserSession.usClientNodeId), 0)\n"
                + "         /*psql ON CONFLICT(chatPk, chatDestination) DO UPDATE\n"
                + "             SET chatPending = true\n"
                + "          */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final Chat entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfChat.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final Chat entity, final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfChat.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends Chat> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfChat.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends Chat> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfChat.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final Chat entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfChat.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, ChatWithLatestMessageAndCount> findAllChatsForUser(
      final String searchBit, final long personUid) {
    final String _sql = "\n"
            + "        SELECT Chat.*,\n"
            + "               Message.messageText AS latestMessage,\n"
            + "               Message.messageTimestamp AS latestMessageTimestamp,\n"
            + "               op.personUid AS otherPersonUid,\n"
            + "               op.firstNames AS otherPersonFirstNames,\n"
            + "               op.lastName AS otherPersonLastName,\n"
            + "               (\n"
            + "\t\t\t\tSELECT COUNT(*) \n"
            + "\t\t\t\t  FROM Message \n"
            + "\t\t\t\t WHERE Message.messageTableId = 127 \n"
            + "\t\t\t\t   AND Message.messageEntityUid = Chat.chatUid \n"
            + "\t\t\t\t   AND Message.messageSenderPersonUid != ?\n"
            + "\t\t\t\t   AND Message.messageTimestamp > coalesce((\n"
            + "\t\t\t\t\t\tSELECT MessageRead.messageReadLct FROM MessageRead \n"
            + "\t\t\t\t\t\tWHERE MessageRead.messageReadPersonUid = ?\n"
            + "\t\t\t\t\t\tAND MessageRead.messageReadMessageUid = Message.messageUid \n"
            + "\t\t\t\t      ), 0)\n"
            + "\t\t\t\t\t\n"
            + "\t\t\t\t\n"
            + "\t\t\t   ) AS unreadMessageCount,\n"
            + "        \n"
            + "               (SELECT COUNT(*)\n"
            + "                  FROM ChatMember mm\n"
            + "                  WHERE mm.chatMemberChatUid = Chat.chatUid ) AS numMembers\n"
            + "          FROM ChatMember\n"
            + "               LEFT JOIN Chat \n"
            + "                    ON Chat.chatUid = ChatMember.chatMemberChatUid\n"
            + "               LEFT JOIN Message \n"
            + "                    ON Message.messageUid =\n"
            + "                        (SELECT messageUid\n"
            + "                           FROM Message\n"
            + "                          WHERE messageEntityUid = Chat.chatUid\n"
            + "                            AND messageTableId = 127\n"
            + "                       ORDER BY messageTimestamp DESC\n"
            + "                          LIMIT 1)\n"
            + "               LEFT JOIN Person op \n"
            + "                    ON op.personUid =\n"
            + "                       (SELECT pp.personUid\n"
            + "                          FROM ChatMember cm\n"
            + "                               LEFT JOIN Person pp \n"
            + "                                    ON pp.personUid = cm.chatMemberPersonUid\n"
            + "                         WHERE cm.chatMemberChatUid = Chat.chatUid\n"
            + "                           AND cm.chatMemberPersonUid != ?\n"
            + "                           AND cm.chatMemberLeftDate = 9223372036854775807\n"
            + "                         LIMIT 1)\n"
            + "         WHERE ChatMember.chatMemberPersonUid = ?\n"
            + "           AND ChatMember.chatMemberLeftDate = 9223372036854775807\n"
            + "           AND Chat.chatUid != 0 \n"
            + "           AND op.firstNames||' '||op.lastName LIKE ? \n"
            + "        -- When in search mode we need to add all Persons who match the search to the list, even if\n"
            + "        -- no chat has started\n"
            + "        UNION\n"
            + "        SELECT Chat.*,\n"
            + "               '' AS latestMessage,\n"
            + "                    0 AS latestMessageTimestamp,\n"
            + "                    Person.personUid AS otherPersonUid,\n"
            + "                    Person.firstNames AS otherPersonFirstNames,\n"
            + "                    Person.lastName AS otherPersonLastName,\n"
            + "                    0 AS unreadMessageCount,\n"
            + "                    0 AS numMembers\n"
            + "                              \n"
            + "          FROM PersonGroupMember\n"
            + "             \n"
            + "            JOIN ScopedGrant\n"
            + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
            + "                    AND (ScopedGrant.sgPermissions &\n"
            + "                    64\n"
            + "                    \n"
            + "                                                    ) > 0\n"
            + "            JOIN Person \n"
            + "                 ON \n"
            + "                ((ScopedGrant.sgTableId = -2\n"
            + "                    AND ScopedGrant.sgEntityUid = -2)\n"
            + "                 OR (ScopedGrant.sgTableId = 9\n"
            + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
            + "                 OR (ScopedGrant.sgTableId = 6       \n"
            + "                    AND Person.personUid IN (\n"
            + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
            + "                          FROM ClazzEnrolment\n"
            + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
            + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
            + "                 OR (ScopedGrant.sgTableId = 164\n"
            + "                    AND Person.personUid IN (\n"
            + "                        SELECT DISTINCT schoolMemberPersonUid\n"
            + "                          FROM SchoolMember\n"
            + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
            + "                           AND schoolMemberActive))\n"
            + "                           )    \n"
            + "        \n"
            + "        \n"
            + "\t\t  \n"
            + "               LEFT JOIN Chat\n"
            + "                    ON Chat.chatUid = 0\n"
            + "         WHERE ? != '%'\n"
            + "           AND PersonGroupMember.groupMemberPersonUid = ?\n"
            + "           AND Person.personUid != ?\n"
            + "        \n"
            + "           AND Person.personUid NOT IN\n"
            + "\t\t\t   (\n"
            + "\t\t\t\tSELECT chatpeople.personUid \n"
            + "\t\t\t\t  FROM ChatMember cmm\n"
            + "\t\t\t\t\t   LEFT JOIN Chat cc \n"
            + "\t\t\t\t\t\t\t  ON cc.chatUid = cmm.chatMemberChatUid \n"
            + "\t\t\t   \n"
            + "\t\t\t\t LEFT JOIN Person chatpeople \n"
            + "                    ON chatpeople.personUid =\n"
            + "                       (SELECT chatpeopleother.personUid\n"
            + "                          FROM ChatMember cm\n"
            + "                               LEFT JOIN Person chatpeopleother \n"
            + "                                    ON chatpeopleother.personUid = cm.chatMemberPersonUid\n"
            + "                         WHERE cm.chatMemberChatUid = cc.chatUid\n"
            + "                           AND cm.chatMemberPersonUid != ?\n"
            + "                         LIMIT 1)\n"
            + "\t\t\t\t\t\t \n"
            + "\t\t\t\t WHERE cc.chatUid != 0 \n"
            + "\t\t\t\t   AND cmm.chatMemberPersonUid = ?\n"
            + "\t\t\t\t )\n"
            + "                            \n"
            + "           AND Person.firstNames||' '||Person.lastName LIKE ? \n"
            + "         ORDER BY latestMessageTimestamp DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 11);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 5;
    if (searchBit == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchBit);
    }
    _argIndex = 6;
    if (searchBit == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchBit);
    }
    _argIndex = 7;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 11;
    if (searchBit == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchBit);
    }
    return new DataSource.Factory<Integer, ChatWithLatestMessageAndCount>() {
      @Override
      public LimitOffsetDataSource<ChatWithLatestMessageAndCount> create() {
        return new LimitOffsetDataSource<ChatWithLatestMessageAndCount>(__db, _statement, false, true , "Message", "MessageRead", "ChatMember", "Chat", "Person", "PersonGroupMember", "ScopedGrant", "ClazzEnrolment", "SchoolMember") {
          @Override
          protected List<ChatWithLatestMessageAndCount> convertRows(Cursor cursor) {
            final int _cursorIndexOfChatUid = CursorUtil.getColumnIndexOrThrow(cursor, "chatUid");
            final int _cursorIndexOfChatStartDate = CursorUtil.getColumnIndexOrThrow(cursor, "chatStartDate");
            final int _cursorIndexOfChatTitle = CursorUtil.getColumnIndexOrThrow(cursor, "chatTitle");
            final int _cursorIndexOfChatGroup = CursorUtil.getColumnIndexOrThrow(cursor, "chatGroup");
            final int _cursorIndexOfChatLct = CursorUtil.getColumnIndexOrThrow(cursor, "chatLct");
            final int _cursorIndexOfLatestMessage = CursorUtil.getColumnIndexOrThrow(cursor, "latestMessage");
            final int _cursorIndexOfLatestMessageTimestamp = CursorUtil.getColumnIndexOrThrow(cursor, "latestMessageTimestamp");
            final int _cursorIndexOfOtherPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "otherPersonUid");
            final int _cursorIndexOfOtherPersonFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "otherPersonFirstNames");
            final int _cursorIndexOfOtherPersonLastName = CursorUtil.getColumnIndexOrThrow(cursor, "otherPersonLastName");
            final int _cursorIndexOfUnreadMessageCount = CursorUtil.getColumnIndexOrThrow(cursor, "unreadMessageCount");
            final List<ChatWithLatestMessageAndCount> _res = new ArrayList<ChatWithLatestMessageAndCount>(cursor.getCount());
            while(cursor.moveToNext()) {
              final ChatWithLatestMessageAndCount _item;
              _item = new ChatWithLatestMessageAndCount();
              final long _tmpChatUid;
              _tmpChatUid = cursor.getLong(_cursorIndexOfChatUid);
              _item.setChatUid(_tmpChatUid);
              final long _tmpChatStartDate;
              _tmpChatStartDate = cursor.getLong(_cursorIndexOfChatStartDate);
              _item.setChatStartDate(_tmpChatStartDate);
              final String _tmpChatTitle;
              if (cursor.isNull(_cursorIndexOfChatTitle)) {
                _tmpChatTitle = null;
              } else {
                _tmpChatTitle = cursor.getString(_cursorIndexOfChatTitle);
              }
              _item.setChatTitle(_tmpChatTitle);
              final boolean _tmpChatGroup;
              final int _tmp;
              _tmp = cursor.getInt(_cursorIndexOfChatGroup);
              _tmpChatGroup = _tmp != 0;
              _item.setChatGroup(_tmpChatGroup);
              final long _tmpChatLct;
              _tmpChatLct = cursor.getLong(_cursorIndexOfChatLct);
              _item.setChatLct(_tmpChatLct);
              final String _tmpLatestMessage;
              if (cursor.isNull(_cursorIndexOfLatestMessage)) {
                _tmpLatestMessage = null;
              } else {
                _tmpLatestMessage = cursor.getString(_cursorIndexOfLatestMessage);
              }
              _item.setLatestMessage(_tmpLatestMessage);
              final long _tmpLatestMessageTimestamp;
              _tmpLatestMessageTimestamp = cursor.getLong(_cursorIndexOfLatestMessageTimestamp);
              _item.setLatestMessageTimestamp(_tmpLatestMessageTimestamp);
              final long _tmpOtherPersonUid;
              _tmpOtherPersonUid = cursor.getLong(_cursorIndexOfOtherPersonUid);
              _item.setOtherPersonUid(_tmpOtherPersonUid);
              final String _tmpOtherPersonFirstNames;
              if (cursor.isNull(_cursorIndexOfOtherPersonFirstNames)) {
                _tmpOtherPersonFirstNames = null;
              } else {
                _tmpOtherPersonFirstNames = cursor.getString(_cursorIndexOfOtherPersonFirstNames);
              }
              _item.setOtherPersonFirstNames(_tmpOtherPersonFirstNames);
              final String _tmpOtherPersonLastName;
              if (cursor.isNull(_cursorIndexOfOtherPersonLastName)) {
                _tmpOtherPersonLastName = null;
              } else {
                _tmpOtherPersonLastName = cursor.getString(_cursorIndexOfOtherPersonLastName);
              }
              _item.setOtherPersonLastName(_tmpOtherPersonLastName);
              final int _tmpUnreadMessageCount;
              _tmpUnreadMessageCount = cursor.getInt(_cursorIndexOfUnreadMessageCount);
              _item.setUnreadMessageCount(_tmpUnreadMessageCount);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public Object getTitleChat(final long chatUid, final long personUid,
      final Continuation<? super String> continuation) {
    final String _sql = "\n"
            + "        SELECT CASE\n"
            + "                   WHEN Chat.chatGroup THEN Chat.chatTitle\n"
            + "                   ELSE Person.firstNames||' '||Person.lastName\n"
            + "               END AS title\n"
            + "        FROM Chat\n"
            + "        LEFT JOIN Person \n"
            + "        ON CAST(Chat.chatGroup AS INTEGER) = 0\n"
            + "           AND Person.personUid =\n"
            + "          (SELECT pp.personUid\n"
            + "           FROM ChatMember cm\n"
            + "           LEFT JOIN Person pp ON pp.personUid = cm.chatMemberPersonUid\n"
            + "           WHERE cm.chatMemberChatUid = Chat.chatUid\n"
            + "             AND cm.chatMemberPersonUid != ?\n"
            + "             AND cm.chatMemberLeftDate = 9223372036854775807\n"
            + "           LIMIT 1)\n"
            + "        WHERE Chat.chatUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, chatUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<String>() {
      @Override
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if(_cursor.moveToFirst()) {
            final String _tmp;
            if (_cursor.isNull(0)) {
              _tmp = null;
            } else {
              _tmp = _cursor.getString(0);
            }
            _result = _tmp;
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object getChatByOtherPerson(final long otherPersonUid, final long loggedInPersonUid,
      final Continuation<? super Chat> continuation) {
    final String _sql = "\n"
            + "        SELECT Chat.*\n"
            + "          FROM ChatMember\n"
            + "          LEFT JOIN Chat ON Chat.chatUid = ChatMember.chatMemberChatUid\n"
            + "         WHERE ChatMember.chatMemberPersonUid = ?\n"
            + "           AND CAST(Chat.chatGroup AS INTEGER) = 0\n"
            + "           AND Chat.chatUid IN \n"
            + "               (\n"
            + "                SELECT ChatMember.chatMemberChatUid\n"
            + "                  FROM ChatMember\n"
            + "                 WHERE ChatMember.chatMemberChatUid = Chat.chatUid\n"
            + "                   AND ChatMember.chatMemberPersonUid = ? \n"
            + "               ) \n"
            + "           AND ? != ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 4);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, loggedInPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, otherPersonUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, loggedInPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Chat>() {
      @Override
      public Chat call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfChatUid = CursorUtil.getColumnIndexOrThrow(_cursor, "chatUid");
          final int _cursorIndexOfChatStartDate = CursorUtil.getColumnIndexOrThrow(_cursor, "chatStartDate");
          final int _cursorIndexOfChatTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "chatTitle");
          final int _cursorIndexOfChatGroup = CursorUtil.getColumnIndexOrThrow(_cursor, "chatGroup");
          final int _cursorIndexOfChatLct = CursorUtil.getColumnIndexOrThrow(_cursor, "chatLct");
          final Chat _result;
          if(_cursor.moveToFirst()) {
            _result = new Chat();
            final long _tmpChatUid;
            _tmpChatUid = _cursor.getLong(_cursorIndexOfChatUid);
            _result.setChatUid(_tmpChatUid);
            final long _tmpChatStartDate;
            _tmpChatStartDate = _cursor.getLong(_cursorIndexOfChatStartDate);
            _result.setChatStartDate(_tmpChatStartDate);
            final String _tmpChatTitle;
            if (_cursor.isNull(_cursorIndexOfChatTitle)) {
              _tmpChatTitle = null;
            } else {
              _tmpChatTitle = _cursor.getString(_cursorIndexOfChatTitle);
            }
            _result.setChatTitle(_tmpChatTitle);
            final boolean _tmpChatGroup;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfChatGroup);
            _tmpChatGroup = _tmp != 0;
            _result.setChatGroup(_tmpChatGroup);
            final long _tmpChatLct;
            _tmpChatLct = _cursor.getLong(_cursorIndexOfChatLct);
            _result.setChatLct(_tmpChatLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
