package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Clazz;
import com.ustadmobile.lib.db.entities.ClazzEnrolment;
import com.ustadmobile.lib.db.entities.ClazzWithDisplayDetails;
import com.ustadmobile.lib.db.entities.ClazzWithHolidayCalendarAndSchoolAndTerminology;
import com.ustadmobile.lib.db.entities.ClazzWithListDisplayDetails;
import com.ustadmobile.lib.db.entities.ClazzWithSchool;
import com.ustadmobile.lib.db.entities.CourseTerminology;
import com.ustadmobile.lib.db.entities.HolidayCalendar;
import com.ustadmobile.lib.db.entities.School;
import com.ustadmobile.lib.db.entities.UidAndLabel;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ClazzDao_Impl extends ClazzDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Clazz> __insertionAdapterOfClazz;

  private final EntityDeletionOrUpdateAdapter<Clazz> __updateAdapterOfClazz;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfUpdateClazzAttendanceAverageAsync;

  public ClazzDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfClazz = new EntityInsertionAdapter<Clazz>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `Clazz` (`clazzUid`,`clazzName`,`clazzDesc`,`attendanceAverage`,`clazzHolidayUMCalendarUid`,`clazzScheuleUMCalendarUid`,`isClazzActive`,`clazzLocationUid`,`clazzStartTime`,`clazzEndTime`,`clazzFeatures`,`clazzSchoolUid`,`clazzEnrolmentPolicy`,`clazzTerminologyUid`,`clazzMasterChangeSeqNum`,`clazzLocalChangeSeqNum`,`clazzLastChangedBy`,`clazzLct`,`clazzTimeZone`,`clazzStudentsPersonGroupUid`,`clazzTeachersPersonGroupUid`,`clazzPendingStudentsPersonGroupUid`,`clazzParentsPersonGroupUid`,`clazzCode`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Clazz value) {
        stmt.bindLong(1, value.getClazzUid());
        if (value.getClazzName() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getClazzName());
        }
        if (value.getClazzDesc() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getClazzDesc());
        }
        stmt.bindDouble(4, value.getAttendanceAverage());
        stmt.bindLong(5, value.getClazzHolidayUMCalendarUid());
        stmt.bindLong(6, value.getClazzScheuleUMCalendarUid());
        final int _tmp = value.isClazzActive() ? 1 : 0;
        stmt.bindLong(7, _tmp);
        stmt.bindLong(8, value.getClazzLocationUid());
        stmt.bindLong(9, value.getClazzStartTime());
        stmt.bindLong(10, value.getClazzEndTime());
        stmt.bindLong(11, value.getClazzFeatures());
        stmt.bindLong(12, value.getClazzSchoolUid());
        stmt.bindLong(13, value.getClazzEnrolmentPolicy());
        stmt.bindLong(14, value.getClazzTerminologyUid());
        stmt.bindLong(15, value.getClazzMasterChangeSeqNum());
        stmt.bindLong(16, value.getClazzLocalChangeSeqNum());
        stmt.bindLong(17, value.getClazzLastChangedBy());
        stmt.bindLong(18, value.getClazzLct());
        if (value.getClazzTimeZone() == null) {
          stmt.bindNull(19);
        } else {
          stmt.bindString(19, value.getClazzTimeZone());
        }
        stmt.bindLong(20, value.getClazzStudentsPersonGroupUid());
        stmt.bindLong(21, value.getClazzTeachersPersonGroupUid());
        stmt.bindLong(22, value.getClazzPendingStudentsPersonGroupUid());
        stmt.bindLong(23, value.getClazzParentsPersonGroupUid());
        if (value.getClazzCode() == null) {
          stmt.bindNull(24);
        } else {
          stmt.bindString(24, value.getClazzCode());
        }
      }
    };
    this.__updateAdapterOfClazz = new EntityDeletionOrUpdateAdapter<Clazz>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `Clazz` SET `clazzUid` = ?,`clazzName` = ?,`clazzDesc` = ?,`attendanceAverage` = ?,`clazzHolidayUMCalendarUid` = ?,`clazzScheuleUMCalendarUid` = ?,`isClazzActive` = ?,`clazzLocationUid` = ?,`clazzStartTime` = ?,`clazzEndTime` = ?,`clazzFeatures` = ?,`clazzSchoolUid` = ?,`clazzEnrolmentPolicy` = ?,`clazzTerminologyUid` = ?,`clazzMasterChangeSeqNum` = ?,`clazzLocalChangeSeqNum` = ?,`clazzLastChangedBy` = ?,`clazzLct` = ?,`clazzTimeZone` = ?,`clazzStudentsPersonGroupUid` = ?,`clazzTeachersPersonGroupUid` = ?,`clazzPendingStudentsPersonGroupUid` = ?,`clazzParentsPersonGroupUid` = ?,`clazzCode` = ? WHERE `clazzUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Clazz value) {
        stmt.bindLong(1, value.getClazzUid());
        if (value.getClazzName() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getClazzName());
        }
        if (value.getClazzDesc() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getClazzDesc());
        }
        stmt.bindDouble(4, value.getAttendanceAverage());
        stmt.bindLong(5, value.getClazzHolidayUMCalendarUid());
        stmt.bindLong(6, value.getClazzScheuleUMCalendarUid());
        final int _tmp = value.isClazzActive() ? 1 : 0;
        stmt.bindLong(7, _tmp);
        stmt.bindLong(8, value.getClazzLocationUid());
        stmt.bindLong(9, value.getClazzStartTime());
        stmt.bindLong(10, value.getClazzEndTime());
        stmt.bindLong(11, value.getClazzFeatures());
        stmt.bindLong(12, value.getClazzSchoolUid());
        stmt.bindLong(13, value.getClazzEnrolmentPolicy());
        stmt.bindLong(14, value.getClazzTerminologyUid());
        stmt.bindLong(15, value.getClazzMasterChangeSeqNum());
        stmt.bindLong(16, value.getClazzLocalChangeSeqNum());
        stmt.bindLong(17, value.getClazzLastChangedBy());
        stmt.bindLong(18, value.getClazzLct());
        if (value.getClazzTimeZone() == null) {
          stmt.bindNull(19);
        } else {
          stmt.bindString(19, value.getClazzTimeZone());
        }
        stmt.bindLong(20, value.getClazzStudentsPersonGroupUid());
        stmt.bindLong(21, value.getClazzTeachersPersonGroupUid());
        stmt.bindLong(22, value.getClazzPendingStudentsPersonGroupUid());
        stmt.bindLong(23, value.getClazzParentsPersonGroupUid());
        if (value.getClazzCode() == null) {
          stmt.bindNull(24);
        } else {
          stmt.bindString(24, value.getClazzCode());
        }
        stmt.bindLong(25, value.getClazzUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO ClazzReplicate(clazzPk, clazzDestination)\n"
                + "      SELECT DISTINCT Clazz.clazzUid AS clazzUid,\n"
                + "             ? AS clazzDestination\n"
                + "        FROM UserSession\n"
                + "               JOIN PersonGroupMember \n"
                + "                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "               \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                    2 \n"
                + "                    \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "       WHERE UserSession.usClientNodeId = ? \n"
                + "         AND Clazz.clazzLct != COALESCE(\n"
                + "             (SELECT clazzVersionId\n"
                + "                FROM ClazzReplicate\n"
                + "               WHERE clazzPk = Clazz.clazzUid\n"
                + "                 AND clazzDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(clazzPk, clazzDestination) DO UPDATE\n"
                + "             SET clazzPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ClazzReplicate(clazzPk, clazzDestination)\n"
                + "  SELECT DISTINCT Clazz.clazzUid AS clazzUid,\n"
                + "         UserSession.usClientNodeId AS clazzDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN Clazz\n"
                + "             ON ChangeLog.chTableId = 6\n"
                + "                AND ChangeLog.chEntityPk = Clazz.clazzUid\n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                    2\n"
                + "                    \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND Clazz.clazzLct != COALESCE(\n"
                + "         (SELECT clazzVersionId\n"
                + "            FROM ClazzReplicate\n"
                + "           WHERE clazzPk = Clazz.clazzUid\n"
                + "             AND clazzDestination = UserSession.usClientNodeId), 0)\n"
                + "  /*psql ON CONFLICT(clazzPk, clazzDestination) DO UPDATE\n"
                + "      SET clazzPending = true\n"
                + "   */               \n"
                + " ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateClazzAttendanceAverageAsync = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE Clazz \n"
                + "           SET attendanceAverage = \n"
                + "               COALESCE(CAST(\n"
                + "                    (SELECT SUM(clazzLogNumPresent) \n"
                + "                       FROM ClazzLog \n"
                + "                      WHERE clazzLogClazzUid = ?\n"
                + "                       AND clazzLogStatusFlag = 4) AS REAL) /\n"
                + "                    \n"
                + "                    CAST(MAX(1.0, \n"
                + "                        (SELECT SUM(clazzLogNumPresent) + SUM(clazzLogNumPartial) + SUM(clazzLogNumAbsent)\n"
                + "                        FROM ClazzLog \n"
                + "                       WHERE clazzLogClazzUid = ? \n"
                + "                        AND clazzLogStatusFlag = 4)) AS REAL), 0),\n"
                + "               clazzLct = ?         \n"
                + "         WHERE clazzUid = ?\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final Clazz entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfClazz.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final Clazz entity, final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfClazz.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends Clazz> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfClazz.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends Clazz> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazz.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final Clazz entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazz.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final Clazz entity, final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfClazz.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateClazzAttendanceAverageAsync(final long clazzUid, final long timeChanged,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateClazzAttendanceAverageAsync.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, clazzUid);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, clazzUid);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, timeChanged);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, clazzUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateClazzAttendanceAverageAsync.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Clazz findByUid(final long uid) {
    final String _sql = "SELECT * FROM Clazz WHERE clazzUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
      final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
      final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
      final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
      final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
      final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
      final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
      final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
      final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
      final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
      final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
      final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
      final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
      final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
      final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
      final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
      final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
      final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
      final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
      final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
      final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
      final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
      final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
      final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
      final Clazz _result;
      if(_cursor.moveToFirst()) {
        _result = new Clazz();
        final long _tmpClazzUid;
        _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
        _result.setClazzUid(_tmpClazzUid);
        final String _tmpClazzName;
        if (_cursor.isNull(_cursorIndexOfClazzName)) {
          _tmpClazzName = null;
        } else {
          _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
        }
        _result.setClazzName(_tmpClazzName);
        final String _tmpClazzDesc;
        if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
          _tmpClazzDesc = null;
        } else {
          _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
        }
        _result.setClazzDesc(_tmpClazzDesc);
        final float _tmpAttendanceAverage;
        _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
        _result.setAttendanceAverage(_tmpAttendanceAverage);
        final long _tmpClazzHolidayUMCalendarUid;
        _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
        _result.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
        final long _tmpClazzScheuleUMCalendarUid;
        _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
        _result.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
        final boolean _tmpIsClazzActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
        _tmpIsClazzActive = _tmp != 0;
        _result.setClazzActive(_tmpIsClazzActive);
        final long _tmpClazzLocationUid;
        _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
        _result.setClazzLocationUid(_tmpClazzLocationUid);
        final long _tmpClazzStartTime;
        _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
        _result.setClazzStartTime(_tmpClazzStartTime);
        final long _tmpClazzEndTime;
        _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
        _result.setClazzEndTime(_tmpClazzEndTime);
        final long _tmpClazzFeatures;
        _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
        _result.setClazzFeatures(_tmpClazzFeatures);
        final long _tmpClazzSchoolUid;
        _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
        _result.setClazzSchoolUid(_tmpClazzSchoolUid);
        final int _tmpClazzEnrolmentPolicy;
        _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
        _result.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
        final long _tmpClazzTerminologyUid;
        _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
        _result.setClazzTerminologyUid(_tmpClazzTerminologyUid);
        final long _tmpClazzMasterChangeSeqNum;
        _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
        _result.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
        final long _tmpClazzLocalChangeSeqNum;
        _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
        _result.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
        final int _tmpClazzLastChangedBy;
        _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
        _result.setClazzLastChangedBy(_tmpClazzLastChangedBy);
        final long _tmpClazzLct;
        _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
        _result.setClazzLct(_tmpClazzLct);
        final String _tmpClazzTimeZone;
        if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
          _tmpClazzTimeZone = null;
        } else {
          _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
        }
        _result.setClazzTimeZone(_tmpClazzTimeZone);
        final long _tmpClazzStudentsPersonGroupUid;
        _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
        _result.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
        final long _tmpClazzTeachersPersonGroupUid;
        _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
        _result.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
        final long _tmpClazzPendingStudentsPersonGroupUid;
        _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
        _result.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
        final long _tmpClazzParentsPersonGroupUid;
        _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
        _result.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
        final String _tmpClazzCode;
        if (_cursor.isNull(_cursorIndexOfClazzCode)) {
          _tmpClazzCode = null;
        } else {
          _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
        }
        _result.setClazzCode(_tmpClazzCode);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public LiveData<Clazz> findByUidLive(final long uid) {
    final String _sql = "SELECT * From Clazz WHERE clazzUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"Clazz"}, false, new Callable<Clazz>() {
      @Override
      public Clazz call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final Clazz _result;
          if(_cursor.moveToFirst()) {
            _result = new Clazz();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _result.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _result.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _result.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _result.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _result.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _result.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp != 0;
            _result.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _result.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _result.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _result.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _result.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _result.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _result.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _result.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _result.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _result.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _result.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _result.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _result.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _result.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _result.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _result.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _result.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _result.setClazzCode(_tmpClazzCode);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findByClazzCode(final String code, final Continuation<? super Clazz> continuation) {
    final String _sql = "SELECT * FROM Clazz WHERE clazzCode = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (code == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, code);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Clazz>() {
      @Override
      public Clazz call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final Clazz _result;
          if(_cursor.moveToFirst()) {
            _result = new Clazz();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _result.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _result.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _result.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _result.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _result.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _result.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp != 0;
            _result.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _result.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _result.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _result.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _result.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _result.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _result.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _result.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _result.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _result.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _result.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _result.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _result.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _result.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _result.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _result.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _result.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _result.setClazzCode(_tmpClazzCode);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByClazzCodeFromWeb(final String code,
      final Continuation<? super Clazz> continuation) {
    final String _sql = "SELECT * FROM Clazz WHERE clazzCode = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (code == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, code);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Clazz>() {
      @Override
      public Clazz call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final Clazz _result;
          if(_cursor.moveToFirst()) {
            _result = new Clazz();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _result.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _result.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _result.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _result.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _result.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _result.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp != 0;
            _result.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _result.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _result.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _result.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _result.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _result.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _result.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _result.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _result.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _result.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _result.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _result.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _result.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _result.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _result.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _result.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _result.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _result.setClazzCode(_tmpClazzCode);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<List<Clazz>> findAllLive() {
    final String _sql = "SELECT * FROM Clazz WHERE CAST(isClazzActive AS INTEGER) = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[]{"Clazz"}, false, new Callable<List<Clazz>>() {
      @Override
      public List<Clazz> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final List<Clazz> _result = new ArrayList<Clazz>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Clazz _item;
            _item = new Clazz();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _item.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _item.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _item.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _item.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp != 0;
            _item.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _item.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _item.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _item.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _item.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _item.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _item.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _item.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _item.setClazzCode(_tmpClazzCode);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public List<Clazz> findAll() {
    final String _sql = "SELECT * FROM Clazz WHERE CAST(isClazzActive AS INTEGER) = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
      final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
      final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
      final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
      final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
      final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
      final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
      final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
      final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
      final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
      final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
      final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
      final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
      final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
      final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
      final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
      final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
      final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
      final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
      final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
      final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
      final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
      final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
      final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
      final List<Clazz> _result = new ArrayList<Clazz>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final Clazz _item;
        _item = new Clazz();
        final long _tmpClazzUid;
        _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
        _item.setClazzUid(_tmpClazzUid);
        final String _tmpClazzName;
        if (_cursor.isNull(_cursorIndexOfClazzName)) {
          _tmpClazzName = null;
        } else {
          _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
        }
        _item.setClazzName(_tmpClazzName);
        final String _tmpClazzDesc;
        if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
          _tmpClazzDesc = null;
        } else {
          _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
        }
        _item.setClazzDesc(_tmpClazzDesc);
        final float _tmpAttendanceAverage;
        _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
        _item.setAttendanceAverage(_tmpAttendanceAverage);
        final long _tmpClazzHolidayUMCalendarUid;
        _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
        _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
        final long _tmpClazzScheuleUMCalendarUid;
        _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
        _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
        final boolean _tmpIsClazzActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
        _tmpIsClazzActive = _tmp != 0;
        _item.setClazzActive(_tmpIsClazzActive);
        final long _tmpClazzLocationUid;
        _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
        _item.setClazzLocationUid(_tmpClazzLocationUid);
        final long _tmpClazzStartTime;
        _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
        _item.setClazzStartTime(_tmpClazzStartTime);
        final long _tmpClazzEndTime;
        _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
        _item.setClazzEndTime(_tmpClazzEndTime);
        final long _tmpClazzFeatures;
        _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
        _item.setClazzFeatures(_tmpClazzFeatures);
        final long _tmpClazzSchoolUid;
        _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
        _item.setClazzSchoolUid(_tmpClazzSchoolUid);
        final int _tmpClazzEnrolmentPolicy;
        _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
        _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
        final long _tmpClazzTerminologyUid;
        _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
        _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
        final long _tmpClazzMasterChangeSeqNum;
        _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
        _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
        final long _tmpClazzLocalChangeSeqNum;
        _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
        _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
        final int _tmpClazzLastChangedBy;
        _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
        _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
        final long _tmpClazzLct;
        _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
        _item.setClazzLct(_tmpClazzLct);
        final String _tmpClazzTimeZone;
        if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
          _tmpClazzTimeZone = null;
        } else {
          _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
        }
        _item.setClazzTimeZone(_tmpClazzTimeZone);
        final long _tmpClazzStudentsPersonGroupUid;
        _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
        _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
        final long _tmpClazzTeachersPersonGroupUid;
        _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
        _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
        final long _tmpClazzPendingStudentsPersonGroupUid;
        _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
        _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
        final long _tmpClazzParentsPersonGroupUid;
        _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
        _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
        final String _tmpClazzCode;
        if (_cursor.isNull(_cursorIndexOfClazzCode)) {
          _tmpClazzCode = null;
        } else {
          _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
        }
        _item.setClazzCode(_tmpClazzCode);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByUidAsync(final long uid, final Continuation<? super Clazz> continuation) {
    final String _sql = "SELECT * FROM Clazz WHERE clazzUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Clazz>() {
      @Override
      public Clazz call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final Clazz _result;
          if(_cursor.moveToFirst()) {
            _result = new Clazz();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _result.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _result.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _result.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _result.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _result.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _result.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp != 0;
            _result.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _result.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _result.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _result.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _result.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _result.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _result.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _result.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _result.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _result.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _result.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _result.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _result.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _result.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _result.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _result.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _result.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _result.setClazzCode(_tmpClazzCode);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidWithHolidayCalendarAsync(final long uid,
      final Continuation<? super ClazzWithHolidayCalendarAndSchoolAndTerminology> continuation) {
    final String _sql = "\n"
            + "        SELECT Clazz.*, \n"
            + "               HolidayCalendar.*, \n"
            + "               School.*,\n"
            + "               CourseTerminology.*\n"
            + "          FROM Clazz \n"
            + "               LEFT JOIN HolidayCalendar \n"
            + "               ON Clazz.clazzHolidayUMCalendarUid = HolidayCalendar.umCalendarUid\n"
            + "               \n"
            + "               LEFT JOIN School \n"
            + "               ON School.schoolUid = Clazz.clazzSchoolUid\n"
            + "               \n"
            + "               LEFT JOIN CourseTerminology\n"
            + "               ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n"
            + "         WHERE Clazz.clazzUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzWithHolidayCalendarAndSchoolAndTerminology>() {
      @Override
      public ClazzWithHolidayCalendarAndSchoolAndTerminology call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
          final int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarName");
          final int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarCategory");
          final int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarActive");
          final int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarMasterChangeSeqNum");
          final int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLocalChangeSeqNum");
          final int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLastChangedBy");
          final int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLct");
          final int _cursorIndexOfSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolUid");
          final int _cursorIndexOfSchoolName = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolName");
          final int _cursorIndexOfSchoolDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolDesc");
          final int _cursorIndexOfSchoolAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolAddress");
          final int _cursorIndexOfSchoolActive = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolActive");
          final int _cursorIndexOfSchoolPhoneNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPhoneNumber");
          final int _cursorIndexOfSchoolGender = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolGender");
          final int _cursorIndexOfSchoolHolidayCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolHolidayCalendarUid");
          final int _cursorIndexOfSchoolFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolFeatures");
          final int _cursorIndexOfSchoolLocationLong = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLong");
          final int _cursorIndexOfSchoolLocationLatt = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLatt");
          final int _cursorIndexOfSchoolEmailAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolEmailAddress");
          final int _cursorIndexOfSchoolTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTeachersPersonGroupUid");
          final int _cursorIndexOfSchoolStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolStudentsPersonGroupUid");
          final int _cursorIndexOfSchoolPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPendingStudentsPersonGroupUid");
          final int _cursorIndexOfSchoolCode = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolCode");
          final int _cursorIndexOfSchoolMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMasterChangeSeqNum");
          final int _cursorIndexOfSchoolLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocalChangeSeqNum");
          final int _cursorIndexOfSchoolLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLastChangedBy");
          final int _cursorIndexOfSchoolLct = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLct");
          final int _cursorIndexOfSchoolTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTimeZone");
          final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctUid");
          final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTitle");
          final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTerminology");
          final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ctLct");
          final ClazzWithHolidayCalendarAndSchoolAndTerminology _result;
          if(_cursor.moveToFirst()) {
            final HolidayCalendar _tmpHolidayCalendar;
            if (! (_cursor.isNull(_cursorIndexOfUmCalendarUid) && _cursor.isNull(_cursorIndexOfUmCalendarName) && _cursor.isNull(_cursorIndexOfUmCalendarCategory) && _cursor.isNull(_cursorIndexOfUmCalendarActive) && _cursor.isNull(_cursorIndexOfUmCalendarMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLastChangedBy) && _cursor.isNull(_cursorIndexOfUmCalendarLct))) {
              _tmpHolidayCalendar = new HolidayCalendar();
              final long _tmpUmCalendarUid;
              _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
              _tmpHolidayCalendar.setUmCalendarUid(_tmpUmCalendarUid);
              final String _tmpUmCalendarName;
              if (_cursor.isNull(_cursorIndexOfUmCalendarName)) {
                _tmpUmCalendarName = null;
              } else {
                _tmpUmCalendarName = _cursor.getString(_cursorIndexOfUmCalendarName);
              }
              _tmpHolidayCalendar.setUmCalendarName(_tmpUmCalendarName);
              final int _tmpUmCalendarCategory;
              _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
              _tmpHolidayCalendar.setUmCalendarCategory(_tmpUmCalendarCategory);
              final boolean _tmpUmCalendarActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfUmCalendarActive);
              _tmpUmCalendarActive = _tmp != 0;
              _tmpHolidayCalendar.setUmCalendarActive(_tmpUmCalendarActive);
              final long _tmpUmCalendarMasterChangeSeqNum;
              _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
              _tmpHolidayCalendar.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
              final long _tmpUmCalendarLocalChangeSeqNum;
              _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
              _tmpHolidayCalendar.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
              final int _tmpUmCalendarLastChangedBy;
              _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
              _tmpHolidayCalendar.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
              final long _tmpUmCalendarLct;
              _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
              _tmpHolidayCalendar.setUmCalendarLct(_tmpUmCalendarLct);
            }  else  {
              _tmpHolidayCalendar = null;
            }
            final School _tmpSchool;
            if (! (_cursor.isNull(_cursorIndexOfSchoolUid) && _cursor.isNull(_cursorIndexOfSchoolName) && _cursor.isNull(_cursorIndexOfSchoolDesc) && _cursor.isNull(_cursorIndexOfSchoolAddress) && _cursor.isNull(_cursorIndexOfSchoolActive) && _cursor.isNull(_cursorIndexOfSchoolPhoneNumber) && _cursor.isNull(_cursorIndexOfSchoolGender) && _cursor.isNull(_cursorIndexOfSchoolHolidayCalendarUid) && _cursor.isNull(_cursorIndexOfSchoolFeatures) && _cursor.isNull(_cursorIndexOfSchoolLocationLong) && _cursor.isNull(_cursorIndexOfSchoolLocationLatt) && _cursor.isNull(_cursorIndexOfSchoolEmailAddress) && _cursor.isNull(_cursorIndexOfSchoolTeachersPersonGroupUid) && _cursor.isNull(_cursorIndexOfSchoolStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfSchoolPendingStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfSchoolCode) && _cursor.isNull(_cursorIndexOfSchoolMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfSchoolLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfSchoolLastChangedBy) && _cursor.isNull(_cursorIndexOfSchoolLct) && _cursor.isNull(_cursorIndexOfSchoolTimeZone))) {
              _tmpSchool = new School();
              final long _tmpSchoolUid;
              _tmpSchoolUid = _cursor.getLong(_cursorIndexOfSchoolUid);
              _tmpSchool.setSchoolUid(_tmpSchoolUid);
              final String _tmpSchoolName;
              if (_cursor.isNull(_cursorIndexOfSchoolName)) {
                _tmpSchoolName = null;
              } else {
                _tmpSchoolName = _cursor.getString(_cursorIndexOfSchoolName);
              }
              _tmpSchool.setSchoolName(_tmpSchoolName);
              final String _tmpSchoolDesc;
              if (_cursor.isNull(_cursorIndexOfSchoolDesc)) {
                _tmpSchoolDesc = null;
              } else {
                _tmpSchoolDesc = _cursor.getString(_cursorIndexOfSchoolDesc);
              }
              _tmpSchool.setSchoolDesc(_tmpSchoolDesc);
              final String _tmpSchoolAddress;
              if (_cursor.isNull(_cursorIndexOfSchoolAddress)) {
                _tmpSchoolAddress = null;
              } else {
                _tmpSchoolAddress = _cursor.getString(_cursorIndexOfSchoolAddress);
              }
              _tmpSchool.setSchoolAddress(_tmpSchoolAddress);
              final boolean _tmpSchoolActive;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfSchoolActive);
              _tmpSchoolActive = _tmp_1 != 0;
              _tmpSchool.setSchoolActive(_tmpSchoolActive);
              final String _tmpSchoolPhoneNumber;
              if (_cursor.isNull(_cursorIndexOfSchoolPhoneNumber)) {
                _tmpSchoolPhoneNumber = null;
              } else {
                _tmpSchoolPhoneNumber = _cursor.getString(_cursorIndexOfSchoolPhoneNumber);
              }
              _tmpSchool.setSchoolPhoneNumber(_tmpSchoolPhoneNumber);
              final int _tmpSchoolGender;
              _tmpSchoolGender = _cursor.getInt(_cursorIndexOfSchoolGender);
              _tmpSchool.setSchoolGender(_tmpSchoolGender);
              final long _tmpSchoolHolidayCalendarUid;
              _tmpSchoolHolidayCalendarUid = _cursor.getLong(_cursorIndexOfSchoolHolidayCalendarUid);
              _tmpSchool.setSchoolHolidayCalendarUid(_tmpSchoolHolidayCalendarUid);
              final long _tmpSchoolFeatures;
              _tmpSchoolFeatures = _cursor.getLong(_cursorIndexOfSchoolFeatures);
              _tmpSchool.setSchoolFeatures(_tmpSchoolFeatures);
              final double _tmpSchoolLocationLong;
              _tmpSchoolLocationLong = _cursor.getDouble(_cursorIndexOfSchoolLocationLong);
              _tmpSchool.setSchoolLocationLong(_tmpSchoolLocationLong);
              final double _tmpSchoolLocationLatt;
              _tmpSchoolLocationLatt = _cursor.getDouble(_cursorIndexOfSchoolLocationLatt);
              _tmpSchool.setSchoolLocationLatt(_tmpSchoolLocationLatt);
              final String _tmpSchoolEmailAddress;
              if (_cursor.isNull(_cursorIndexOfSchoolEmailAddress)) {
                _tmpSchoolEmailAddress = null;
              } else {
                _tmpSchoolEmailAddress = _cursor.getString(_cursorIndexOfSchoolEmailAddress);
              }
              _tmpSchool.setSchoolEmailAddress(_tmpSchoolEmailAddress);
              final long _tmpSchoolTeachersPersonGroupUid;
              _tmpSchoolTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolTeachersPersonGroupUid);
              _tmpSchool.setSchoolTeachersPersonGroupUid(_tmpSchoolTeachersPersonGroupUid);
              final long _tmpSchoolStudentsPersonGroupUid;
              _tmpSchoolStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolStudentsPersonGroupUid);
              _tmpSchool.setSchoolStudentsPersonGroupUid(_tmpSchoolStudentsPersonGroupUid);
              final long _tmpSchoolPendingStudentsPersonGroupUid;
              _tmpSchoolPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolPendingStudentsPersonGroupUid);
              _tmpSchool.setSchoolPendingStudentsPersonGroupUid(_tmpSchoolPendingStudentsPersonGroupUid);
              final String _tmpSchoolCode;
              if (_cursor.isNull(_cursorIndexOfSchoolCode)) {
                _tmpSchoolCode = null;
              } else {
                _tmpSchoolCode = _cursor.getString(_cursorIndexOfSchoolCode);
              }
              _tmpSchool.setSchoolCode(_tmpSchoolCode);
              final long _tmpSchoolMasterChangeSeqNum;
              _tmpSchoolMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolMasterChangeSeqNum);
              _tmpSchool.setSchoolMasterChangeSeqNum(_tmpSchoolMasterChangeSeqNum);
              final long _tmpSchoolLocalChangeSeqNum;
              _tmpSchoolLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolLocalChangeSeqNum);
              _tmpSchool.setSchoolLocalChangeSeqNum(_tmpSchoolLocalChangeSeqNum);
              final int _tmpSchoolLastChangedBy;
              _tmpSchoolLastChangedBy = _cursor.getInt(_cursorIndexOfSchoolLastChangedBy);
              _tmpSchool.setSchoolLastChangedBy(_tmpSchoolLastChangedBy);
              final long _tmpSchoolLct;
              _tmpSchoolLct = _cursor.getLong(_cursorIndexOfSchoolLct);
              _tmpSchool.setSchoolLct(_tmpSchoolLct);
              final String _tmpSchoolTimeZone;
              if (_cursor.isNull(_cursorIndexOfSchoolTimeZone)) {
                _tmpSchoolTimeZone = null;
              } else {
                _tmpSchoolTimeZone = _cursor.getString(_cursorIndexOfSchoolTimeZone);
              }
              _tmpSchool.setSchoolTimeZone(_tmpSchoolTimeZone);
            }  else  {
              _tmpSchool = null;
            }
            final CourseTerminology _tmpTerminology;
            if (! (_cursor.isNull(_cursorIndexOfCtUid) && _cursor.isNull(_cursorIndexOfCtTitle) && _cursor.isNull(_cursorIndexOfCtTerminology) && _cursor.isNull(_cursorIndexOfCtLct))) {
              _tmpTerminology = new CourseTerminology();
              final long _tmpCtUid;
              _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
              _tmpTerminology.setCtUid(_tmpCtUid);
              final String _tmpCtTitle;
              if (_cursor.isNull(_cursorIndexOfCtTitle)) {
                _tmpCtTitle = null;
              } else {
                _tmpCtTitle = _cursor.getString(_cursorIndexOfCtTitle);
              }
              _tmpTerminology.setCtTitle(_tmpCtTitle);
              final String _tmpCtTerminology;
              if (_cursor.isNull(_cursorIndexOfCtTerminology)) {
                _tmpCtTerminology = null;
              } else {
                _tmpCtTerminology = _cursor.getString(_cursorIndexOfCtTerminology);
              }
              _tmpTerminology.setCtTerminology(_tmpCtTerminology);
              final long _tmpCtLct;
              _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
              _tmpTerminology.setCtLct(_tmpCtLct);
            }  else  {
              _tmpTerminology = null;
            }
            _result = new ClazzWithHolidayCalendarAndSchoolAndTerminology();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _result.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _result.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _result.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _result.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _result.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _result.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp_2 != 0;
            _result.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _result.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _result.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _result.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _result.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _result.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _result.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _result.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _result.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _result.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _result.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _result.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _result.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _result.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _result.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _result.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _result.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _result.setClazzCode(_tmpClazzCode);
            _result.setHolidayCalendar(_tmpHolidayCalendar);
            _result.setSchool(_tmpSchool);
            _result.setTerminology(_tmpTerminology);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findAllClazzesBySchool(final long schoolUid,
      final Continuation<? super List<? extends Clazz>> continuation) {
    final String _sql = "SELECT * FROM Clazz WHERE clazzSchoolUid = ? AND CAST(isClazzActive AS INTEGER) = 1 ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, schoolUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Clazz>>() {
      @Override
      public List<Clazz> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final List<Clazz> _result = new ArrayList<Clazz>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Clazz _item;
            _item = new Clazz();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _item.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _item.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _item.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _item.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp != 0;
            _item.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _item.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _item.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _item.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _item.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _item.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _item.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _item.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _item.setClazzCode(_tmpClazzCode);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, Clazz> findAllClazzesBySchoolLive(final long schoolUid) {
    final String _sql = "SELECT * FROM Clazz WHERE clazzSchoolUid = ? AND CAST(isClazzActive AS INTEGER) = 1 ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, schoolUid);
    return new DataSource.Factory<Integer, Clazz>() {
      @Override
      public LimitOffsetDataSource<Clazz> create() {
        return new LimitOffsetDataSource<Clazz>(__db, _statement, false, true , "Clazz") {
          @Override
          protected List<Clazz> convertRows(Cursor cursor) {
            final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzUid");
            final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(cursor, "clazzName");
            final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(cursor, "clazzDesc");
            final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(cursor, "attendanceAverage");
            final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzHolidayUMCalendarUid");
            final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzScheuleUMCalendarUid");
            final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(cursor, "isClazzActive");
            final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLocationUid");
            final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(cursor, "clazzStartTime");
            final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEndTime");
            final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(cursor, "clazzFeatures");
            final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzSchoolUid");
            final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentPolicy");
            final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzTerminologyUid");
            final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzMasterChangeSeqNum");
            final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLocalChangeSeqNum");
            final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLastChangedBy");
            final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLct");
            final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(cursor, "clazzTimeZone");
            final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzStudentsPersonGroupUid");
            final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzTeachersPersonGroupUid");
            final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzPendingStudentsPersonGroupUid");
            final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzParentsPersonGroupUid");
            final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(cursor, "clazzCode");
            final List<Clazz> _res = new ArrayList<Clazz>(cursor.getCount());
            while(cursor.moveToNext()) {
              final Clazz _item;
              _item = new Clazz();
              final long _tmpClazzUid;
              _tmpClazzUid = cursor.getLong(_cursorIndexOfClazzUid);
              _item.setClazzUid(_tmpClazzUid);
              final String _tmpClazzName;
              if (cursor.isNull(_cursorIndexOfClazzName)) {
                _tmpClazzName = null;
              } else {
                _tmpClazzName = cursor.getString(_cursorIndexOfClazzName);
              }
              _item.setClazzName(_tmpClazzName);
              final String _tmpClazzDesc;
              if (cursor.isNull(_cursorIndexOfClazzDesc)) {
                _tmpClazzDesc = null;
              } else {
                _tmpClazzDesc = cursor.getString(_cursorIndexOfClazzDesc);
              }
              _item.setClazzDesc(_tmpClazzDesc);
              final float _tmpAttendanceAverage;
              _tmpAttendanceAverage = cursor.getFloat(_cursorIndexOfAttendanceAverage);
              _item.setAttendanceAverage(_tmpAttendanceAverage);
              final long _tmpClazzHolidayUMCalendarUid;
              _tmpClazzHolidayUMCalendarUid = cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
              _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
              final long _tmpClazzScheuleUMCalendarUid;
              _tmpClazzScheuleUMCalendarUid = cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
              _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
              final boolean _tmpIsClazzActive;
              final int _tmp;
              _tmp = cursor.getInt(_cursorIndexOfIsClazzActive);
              _tmpIsClazzActive = _tmp != 0;
              _item.setClazzActive(_tmpIsClazzActive);
              final long _tmpClazzLocationUid;
              _tmpClazzLocationUid = cursor.getLong(_cursorIndexOfClazzLocationUid);
              _item.setClazzLocationUid(_tmpClazzLocationUid);
              final long _tmpClazzStartTime;
              _tmpClazzStartTime = cursor.getLong(_cursorIndexOfClazzStartTime);
              _item.setClazzStartTime(_tmpClazzStartTime);
              final long _tmpClazzEndTime;
              _tmpClazzEndTime = cursor.getLong(_cursorIndexOfClazzEndTime);
              _item.setClazzEndTime(_tmpClazzEndTime);
              final long _tmpClazzFeatures;
              _tmpClazzFeatures = cursor.getLong(_cursorIndexOfClazzFeatures);
              _item.setClazzFeatures(_tmpClazzFeatures);
              final long _tmpClazzSchoolUid;
              _tmpClazzSchoolUid = cursor.getLong(_cursorIndexOfClazzSchoolUid);
              _item.setClazzSchoolUid(_tmpClazzSchoolUid);
              final int _tmpClazzEnrolmentPolicy;
              _tmpClazzEnrolmentPolicy = cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
              _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
              final long _tmpClazzTerminologyUid;
              _tmpClazzTerminologyUid = cursor.getLong(_cursorIndexOfClazzTerminologyUid);
              _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
              final long _tmpClazzMasterChangeSeqNum;
              _tmpClazzMasterChangeSeqNum = cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
              _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
              final long _tmpClazzLocalChangeSeqNum;
              _tmpClazzLocalChangeSeqNum = cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
              _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
              final int _tmpClazzLastChangedBy;
              _tmpClazzLastChangedBy = cursor.getInt(_cursorIndexOfClazzLastChangedBy);
              _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
              final long _tmpClazzLct;
              _tmpClazzLct = cursor.getLong(_cursorIndexOfClazzLct);
              _item.setClazzLct(_tmpClazzLct);
              final String _tmpClazzTimeZone;
              if (cursor.isNull(_cursorIndexOfClazzTimeZone)) {
                _tmpClazzTimeZone = null;
              } else {
                _tmpClazzTimeZone = cursor.getString(_cursorIndexOfClazzTimeZone);
              }
              _item.setClazzTimeZone(_tmpClazzTimeZone);
              final long _tmpClazzStudentsPersonGroupUid;
              _tmpClazzStudentsPersonGroupUid = cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
              _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
              final long _tmpClazzTeachersPersonGroupUid;
              _tmpClazzTeachersPersonGroupUid = cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
              _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
              final long _tmpClazzPendingStudentsPersonGroupUid;
              _tmpClazzPendingStudentsPersonGroupUid = cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
              _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
              final long _tmpClazzParentsPersonGroupUid;
              _tmpClazzParentsPersonGroupUid = cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
              _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
              final String _tmpClazzCode;
              if (cursor.isNull(_cursorIndexOfClazzCode)) {
                _tmpClazzCode = null;
              } else {
                _tmpClazzCode = cursor.getString(_cursorIndexOfClazzCode);
              }
              _item.setClazzCode(_tmpClazzCode);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public DataSource.Factory<Integer, ClazzWithListDisplayDetails> findClazzesWithPermission(
      final String searchQuery, final long accountPersonUid,
      final List<Long> excludeSelectedClazzList, final long excludeSchoolUid, final int sortOrder,
      final int filter, final long currentTime, final long permission, final long selectedSchool) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT Clazz.*, ClazzEnrolment.*,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               (SELECT COUNT(*) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  FROM ClazzEnrolment ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   AND clazzEnrolmentRole = 1000 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   AND ");
    _stringBuilder.append("?");
    _stringBuilder.append(" BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numStudents,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               (SELECT COUNT(*) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  FROM ClazzEnrolment ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   AND clazzEnrolmentRole = 1001");
    _stringBuilder.append("\n");
    _stringBuilder.append("                   AND ");
    _stringBuilder.append("?");
    _stringBuilder.append(" BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numTeachers,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               '' AS teacherNames,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               0 AS lastRecorded,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               CourseTerminology.*");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM PersonGroupMember");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               JOIN ScopedGrant");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("                        AND (ScopedGrant.sgPermissions & ");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       ) > 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("               JOIN Clazz ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ON ");
    _stringBuilder.append("\n");
    _stringBuilder.append("            ((ScopedGrant.sgTableId = -2");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                AND ScopedGrant.sgEntityUid = -2)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            OR (ScopedGrant.sgTableId = 6");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                            OR (ScopedGrant.sgTableId = 164");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))");
    _stringBuilder.append("\n");
    _stringBuilder.append("        ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("               LEFT JOIN ClazzEnrolment ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    ON ClazzEnrolment.clazzEnrolmentUid =");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       COALESCE(");
    _stringBuilder.append("\n");
    _stringBuilder.append("                       (SELECT ClazzEnrolment.clazzEnrolmentUid ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                          FROM ClazzEnrolment");
    _stringBuilder.append("\n");
    _stringBuilder.append("                         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           AND ClazzEnrolment.clazzEnrolmentActive");
    _stringBuilder.append("\n");
    _stringBuilder.append("                           AND ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid LIMIT 1), 0)");
    _stringBuilder.append("\n");
    _stringBuilder.append("                LEFT JOIN CourseTerminology   ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid           ");
    _stringBuilder.append("\n");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE PersonGroupMember.groupMemberPersonUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND PersonGroupMember.groupMemberActive ");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND CAST(Clazz.isClazzActive AS INTEGER) = 1");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND Clazz.clazzName like ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND (Clazz.clazzUid NOT IN (");
    final int _inputSize = excludeSelectedClazzList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append("))");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND ( ");
    _stringBuilder.append("?");
    _stringBuilder.append(" = 0 OR Clazz.clazzUid NOT IN (SELECT cl.clazzUid FROM Clazz AS cl WHERE cl.clazzSchoolUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append(") ) ");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND ( ");
    _stringBuilder.append("?");
    _stringBuilder.append(" = 0 OR Clazz.clazzSchoolUid = 0 )");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND ( ");
    _stringBuilder.append("?");
    _stringBuilder.append(" = 0 OR (CASE WHEN ");
    _stringBuilder.append("?");
    _stringBuilder.append(" = 5 ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      THEN ");
    _stringBuilder.append("?");
    _stringBuilder.append(" BETWEEN Clazz.clazzStartTime AND Clazz.clazzEndTime");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      ELSE ");
    _stringBuilder.append("?");
    _stringBuilder.append(" > Clazz.clazzEndTime ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                                      END))");
    _stringBuilder.append("\n");
    _stringBuilder.append("           AND ( ");
    _stringBuilder.append("?");
    _stringBuilder.append(" = 0 OR Clazz.clazzSchoolUid = ");
    _stringBuilder.append("?");
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("      GROUP BY Clazz.clazzUid, ClazzEnrolment.clazzEnrolmentUid, CourseTerminology.ctUid");
    _stringBuilder.append("\n");
    _stringBuilder.append("      ORDER BY CASE ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 3 THEN Clazz.attendanceAverage");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END ASC,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               CASE ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 1 THEN Clazz.clazzName");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE ''");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END ASC,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               CASE ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 4 THEN Clazz.attendanceAverage");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE 0");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END DESC,");
    _stringBuilder.append("\n");
    _stringBuilder.append("               CASE ");
    _stringBuilder.append("?");
    _stringBuilder.append("\n");
    _stringBuilder.append("               WHEN 2 THEN clazz.Clazzname");
    _stringBuilder.append("\n");
    _stringBuilder.append("               ELSE ''");
    _stringBuilder.append("\n");
    _stringBuilder.append("               END DESC");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 19 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 2;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 3;
    _statement.bindLong(_argIndex, permission);
    _argIndex = 4;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    if (searchQuery == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, searchQuery);
    }
    _argIndex = 7;
    for (long _item : excludeSelectedClazzList) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    _argIndex = 7 + _inputSize;
    _statement.bindLong(_argIndex, excludeSchoolUid);
    _argIndex = 8 + _inputSize;
    _statement.bindLong(_argIndex, excludeSchoolUid);
    _argIndex = 9 + _inputSize;
    _statement.bindLong(_argIndex, excludeSchoolUid);
    _argIndex = 10 + _inputSize;
    _statement.bindLong(_argIndex, filter);
    _argIndex = 11 + _inputSize;
    _statement.bindLong(_argIndex, filter);
    _argIndex = 12 + _inputSize;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 13 + _inputSize;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 14 + _inputSize;
    _statement.bindLong(_argIndex, selectedSchool);
    _argIndex = 15 + _inputSize;
    _statement.bindLong(_argIndex, selectedSchool);
    _argIndex = 16 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 17 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 18 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 19 + _inputSize;
    _statement.bindLong(_argIndex, sortOrder);
    return new DataSource.Factory<Integer, ClazzWithListDisplayDetails>() {
      @Override
      public LimitOffsetDataSource<ClazzWithListDisplayDetails> create() {
        return new LimitOffsetDataSource<ClazzWithListDisplayDetails>(__db, _statement, false, true , "ClazzEnrolment", "PersonGroupMember", "ScopedGrant", "Clazz", "CourseTerminology") {
          @Override
          protected List<ClazzWithListDisplayDetails> convertRows(Cursor cursor) {
            final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzUid");
            final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(cursor, "clazzName");
            final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(cursor, "clazzDesc");
            final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(cursor, "attendanceAverage");
            final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzHolidayUMCalendarUid");
            final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzScheuleUMCalendarUid");
            final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(cursor, "isClazzActive");
            final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLocationUid");
            final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(cursor, "clazzStartTime");
            final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEndTime");
            final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(cursor, "clazzFeatures");
            final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzSchoolUid");
            final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentPolicy");
            final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzTerminologyUid");
            final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzMasterChangeSeqNum");
            final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLocalChangeSeqNum");
            final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLastChangedBy");
            final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(cursor, "clazzLct");
            final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(cursor, "clazzTimeZone");
            final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzStudentsPersonGroupUid");
            final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzTeachersPersonGroupUid");
            final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzPendingStudentsPersonGroupUid");
            final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzParentsPersonGroupUid");
            final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(cursor, "clazzCode");
            final int _cursorIndexOfClazzEnrolmentUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentUid");
            final int _cursorIndexOfClazzEnrolmentPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentPersonUid");
            final int _cursorIndexOfClazzEnrolmentClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentClazzUid");
            final int _cursorIndexOfClazzEnrolmentDateJoined = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentDateJoined");
            final int _cursorIndexOfClazzEnrolmentDateLeft = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentDateLeft");
            final int _cursorIndexOfClazzEnrolmentRole = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentRole");
            final int _cursorIndexOfClazzEnrolmentAttendancePercentage = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentAttendancePercentage");
            final int _cursorIndexOfClazzEnrolmentActive = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentActive");
            final int _cursorIndexOfClazzEnrolmentLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLeavingReasonUid");
            final int _cursorIndexOfClazzEnrolmentOutcome = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentOutcome");
            final int _cursorIndexOfClazzEnrolmentLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLocalChangeSeqNum");
            final int _cursorIndexOfClazzEnrolmentMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentMasterChangeSeqNum");
            final int _cursorIndexOfClazzEnrolmentLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLastChangedBy");
            final int _cursorIndexOfClazzEnrolmentLct = CursorUtil.getColumnIndexOrThrow(cursor, "clazzEnrolmentLct");
            final int _cursorIndexOfNumStudents = CursorUtil.getColumnIndexOrThrow(cursor, "numStudents");
            final int _cursorIndexOfNumTeachers = CursorUtil.getColumnIndexOrThrow(cursor, "numTeachers");
            final int _cursorIndexOfTeacherNames = CursorUtil.getColumnIndexOrThrow(cursor, "teacherNames");
            final int _cursorIndexOfLastRecorded = CursorUtil.getColumnIndexOrThrow(cursor, "lastRecorded");
            final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(cursor, "ctUid");
            final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(cursor, "ctTitle");
            final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(cursor, "ctTerminology");
            final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(cursor, "ctLct");
            final List<ClazzWithListDisplayDetails> _res = new ArrayList<ClazzWithListDisplayDetails>(cursor.getCount());
            while(cursor.moveToNext()) {
              final ClazzWithListDisplayDetails _item_1;
              final ClazzEnrolment _tmpClazzActiveEnrolment;
              if (! (cursor.isNull(_cursorIndexOfClazzEnrolmentUid) && cursor.isNull(_cursorIndexOfClazzEnrolmentPersonUid) && cursor.isNull(_cursorIndexOfClazzEnrolmentClazzUid) && cursor.isNull(_cursorIndexOfClazzEnrolmentDateJoined) && cursor.isNull(_cursorIndexOfClazzEnrolmentDateLeft) && cursor.isNull(_cursorIndexOfClazzEnrolmentRole) && cursor.isNull(_cursorIndexOfClazzEnrolmentAttendancePercentage) && cursor.isNull(_cursorIndexOfClazzEnrolmentActive) && cursor.isNull(_cursorIndexOfClazzEnrolmentLeavingReasonUid) && cursor.isNull(_cursorIndexOfClazzEnrolmentOutcome) && cursor.isNull(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfClazzEnrolmentLastChangedBy) && cursor.isNull(_cursorIndexOfClazzEnrolmentLct))) {
                _tmpClazzActiveEnrolment = new ClazzEnrolment();
                final long _tmpClazzEnrolmentUid;
                _tmpClazzEnrolmentUid = cursor.getLong(_cursorIndexOfClazzEnrolmentUid);
                _tmpClazzActiveEnrolment.setClazzEnrolmentUid(_tmpClazzEnrolmentUid);
                final long _tmpClazzEnrolmentPersonUid;
                _tmpClazzEnrolmentPersonUid = cursor.getLong(_cursorIndexOfClazzEnrolmentPersonUid);
                _tmpClazzActiveEnrolment.setClazzEnrolmentPersonUid(_tmpClazzEnrolmentPersonUid);
                final long _tmpClazzEnrolmentClazzUid;
                _tmpClazzEnrolmentClazzUid = cursor.getLong(_cursorIndexOfClazzEnrolmentClazzUid);
                _tmpClazzActiveEnrolment.setClazzEnrolmentClazzUid(_tmpClazzEnrolmentClazzUid);
                final long _tmpClazzEnrolmentDateJoined;
                _tmpClazzEnrolmentDateJoined = cursor.getLong(_cursorIndexOfClazzEnrolmentDateJoined);
                _tmpClazzActiveEnrolment.setClazzEnrolmentDateJoined(_tmpClazzEnrolmentDateJoined);
                final long _tmpClazzEnrolmentDateLeft;
                _tmpClazzEnrolmentDateLeft = cursor.getLong(_cursorIndexOfClazzEnrolmentDateLeft);
                _tmpClazzActiveEnrolment.setClazzEnrolmentDateLeft(_tmpClazzEnrolmentDateLeft);
                final int _tmpClazzEnrolmentRole;
                _tmpClazzEnrolmentRole = cursor.getInt(_cursorIndexOfClazzEnrolmentRole);
                _tmpClazzActiveEnrolment.setClazzEnrolmentRole(_tmpClazzEnrolmentRole);
                final float _tmpClazzEnrolmentAttendancePercentage;
                _tmpClazzEnrolmentAttendancePercentage = cursor.getFloat(_cursorIndexOfClazzEnrolmentAttendancePercentage);
                _tmpClazzActiveEnrolment.setClazzEnrolmentAttendancePercentage(_tmpClazzEnrolmentAttendancePercentage);
                final boolean _tmpClazzEnrolmentActive;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfClazzEnrolmentActive);
                _tmpClazzEnrolmentActive = _tmp != 0;
                _tmpClazzActiveEnrolment.setClazzEnrolmentActive(_tmpClazzEnrolmentActive);
                final long _tmpClazzEnrolmentLeavingReasonUid;
                _tmpClazzEnrolmentLeavingReasonUid = cursor.getLong(_cursorIndexOfClazzEnrolmentLeavingReasonUid);
                _tmpClazzActiveEnrolment.setClazzEnrolmentLeavingReasonUid(_tmpClazzEnrolmentLeavingReasonUid);
                final int _tmpClazzEnrolmentOutcome;
                _tmpClazzEnrolmentOutcome = cursor.getInt(_cursorIndexOfClazzEnrolmentOutcome);
                _tmpClazzActiveEnrolment.setClazzEnrolmentOutcome(_tmpClazzEnrolmentOutcome);
                final long _tmpClazzEnrolmentLocalChangeSeqNum;
                _tmpClazzEnrolmentLocalChangeSeqNum = cursor.getLong(_cursorIndexOfClazzEnrolmentLocalChangeSeqNum);
                _tmpClazzActiveEnrolment.setClazzEnrolmentLocalChangeSeqNum(_tmpClazzEnrolmentLocalChangeSeqNum);
                final long _tmpClazzEnrolmentMasterChangeSeqNum;
                _tmpClazzEnrolmentMasterChangeSeqNum = cursor.getLong(_cursorIndexOfClazzEnrolmentMasterChangeSeqNum);
                _tmpClazzActiveEnrolment.setClazzEnrolmentMasterChangeSeqNum(_tmpClazzEnrolmentMasterChangeSeqNum);
                final int _tmpClazzEnrolmentLastChangedBy;
                _tmpClazzEnrolmentLastChangedBy = cursor.getInt(_cursorIndexOfClazzEnrolmentLastChangedBy);
                _tmpClazzActiveEnrolment.setClazzEnrolmentLastChangedBy(_tmpClazzEnrolmentLastChangedBy);
                final long _tmpClazzEnrolmentLct;
                _tmpClazzEnrolmentLct = cursor.getLong(_cursorIndexOfClazzEnrolmentLct);
                _tmpClazzActiveEnrolment.setClazzEnrolmentLct(_tmpClazzEnrolmentLct);
              }  else  {
                _tmpClazzActiveEnrolment = null;
              }
              final CourseTerminology _tmpTerminology;
              if (! (cursor.isNull(_cursorIndexOfCtUid) && cursor.isNull(_cursorIndexOfCtTitle) && cursor.isNull(_cursorIndexOfCtTerminology) && cursor.isNull(_cursorIndexOfCtLct))) {
                _tmpTerminology = new CourseTerminology();
                final long _tmpCtUid;
                _tmpCtUid = cursor.getLong(_cursorIndexOfCtUid);
                _tmpTerminology.setCtUid(_tmpCtUid);
                final String _tmpCtTitle;
                if (cursor.isNull(_cursorIndexOfCtTitle)) {
                  _tmpCtTitle = null;
                } else {
                  _tmpCtTitle = cursor.getString(_cursorIndexOfCtTitle);
                }
                _tmpTerminology.setCtTitle(_tmpCtTitle);
                final String _tmpCtTerminology;
                if (cursor.isNull(_cursorIndexOfCtTerminology)) {
                  _tmpCtTerminology = null;
                } else {
                  _tmpCtTerminology = cursor.getString(_cursorIndexOfCtTerminology);
                }
                _tmpTerminology.setCtTerminology(_tmpCtTerminology);
                final long _tmpCtLct;
                _tmpCtLct = cursor.getLong(_cursorIndexOfCtLct);
                _tmpTerminology.setCtLct(_tmpCtLct);
              }  else  {
                _tmpTerminology = null;
              }
              _item_1 = new ClazzWithListDisplayDetails();
              final long _tmpClazzUid;
              _tmpClazzUid = cursor.getLong(_cursorIndexOfClazzUid);
              _item_1.setClazzUid(_tmpClazzUid);
              final String _tmpClazzName;
              if (cursor.isNull(_cursorIndexOfClazzName)) {
                _tmpClazzName = null;
              } else {
                _tmpClazzName = cursor.getString(_cursorIndexOfClazzName);
              }
              _item_1.setClazzName(_tmpClazzName);
              final String _tmpClazzDesc;
              if (cursor.isNull(_cursorIndexOfClazzDesc)) {
                _tmpClazzDesc = null;
              } else {
                _tmpClazzDesc = cursor.getString(_cursorIndexOfClazzDesc);
              }
              _item_1.setClazzDesc(_tmpClazzDesc);
              final float _tmpAttendanceAverage;
              _tmpAttendanceAverage = cursor.getFloat(_cursorIndexOfAttendanceAverage);
              _item_1.setAttendanceAverage(_tmpAttendanceAverage);
              final long _tmpClazzHolidayUMCalendarUid;
              _tmpClazzHolidayUMCalendarUid = cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
              _item_1.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
              final long _tmpClazzScheuleUMCalendarUid;
              _tmpClazzScheuleUMCalendarUid = cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
              _item_1.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
              final boolean _tmpIsClazzActive;
              final int _tmp_1;
              _tmp_1 = cursor.getInt(_cursorIndexOfIsClazzActive);
              _tmpIsClazzActive = _tmp_1 != 0;
              _item_1.setClazzActive(_tmpIsClazzActive);
              final long _tmpClazzLocationUid;
              _tmpClazzLocationUid = cursor.getLong(_cursorIndexOfClazzLocationUid);
              _item_1.setClazzLocationUid(_tmpClazzLocationUid);
              final long _tmpClazzStartTime;
              _tmpClazzStartTime = cursor.getLong(_cursorIndexOfClazzStartTime);
              _item_1.setClazzStartTime(_tmpClazzStartTime);
              final long _tmpClazzEndTime;
              _tmpClazzEndTime = cursor.getLong(_cursorIndexOfClazzEndTime);
              _item_1.setClazzEndTime(_tmpClazzEndTime);
              final long _tmpClazzFeatures;
              _tmpClazzFeatures = cursor.getLong(_cursorIndexOfClazzFeatures);
              _item_1.setClazzFeatures(_tmpClazzFeatures);
              final long _tmpClazzSchoolUid;
              _tmpClazzSchoolUid = cursor.getLong(_cursorIndexOfClazzSchoolUid);
              _item_1.setClazzSchoolUid(_tmpClazzSchoolUid);
              final int _tmpClazzEnrolmentPolicy;
              _tmpClazzEnrolmentPolicy = cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
              _item_1.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
              final long _tmpClazzTerminologyUid;
              _tmpClazzTerminologyUid = cursor.getLong(_cursorIndexOfClazzTerminologyUid);
              _item_1.setClazzTerminologyUid(_tmpClazzTerminologyUid);
              final long _tmpClazzMasterChangeSeqNum;
              _tmpClazzMasterChangeSeqNum = cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
              _item_1.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
              final long _tmpClazzLocalChangeSeqNum;
              _tmpClazzLocalChangeSeqNum = cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
              _item_1.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
              final int _tmpClazzLastChangedBy;
              _tmpClazzLastChangedBy = cursor.getInt(_cursorIndexOfClazzLastChangedBy);
              _item_1.setClazzLastChangedBy(_tmpClazzLastChangedBy);
              final long _tmpClazzLct;
              _tmpClazzLct = cursor.getLong(_cursorIndexOfClazzLct);
              _item_1.setClazzLct(_tmpClazzLct);
              final String _tmpClazzTimeZone;
              if (cursor.isNull(_cursorIndexOfClazzTimeZone)) {
                _tmpClazzTimeZone = null;
              } else {
                _tmpClazzTimeZone = cursor.getString(_cursorIndexOfClazzTimeZone);
              }
              _item_1.setClazzTimeZone(_tmpClazzTimeZone);
              final long _tmpClazzStudentsPersonGroupUid;
              _tmpClazzStudentsPersonGroupUid = cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
              _item_1.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
              final long _tmpClazzTeachersPersonGroupUid;
              _tmpClazzTeachersPersonGroupUid = cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
              _item_1.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
              final long _tmpClazzPendingStudentsPersonGroupUid;
              _tmpClazzPendingStudentsPersonGroupUid = cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
              _item_1.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
              final long _tmpClazzParentsPersonGroupUid;
              _tmpClazzParentsPersonGroupUid = cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
              _item_1.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
              final String _tmpClazzCode;
              if (cursor.isNull(_cursorIndexOfClazzCode)) {
                _tmpClazzCode = null;
              } else {
                _tmpClazzCode = cursor.getString(_cursorIndexOfClazzCode);
              }
              _item_1.setClazzCode(_tmpClazzCode);
              final int _tmpNumStudents;
              _tmpNumStudents = cursor.getInt(_cursorIndexOfNumStudents);
              _item_1.setNumStudents(_tmpNumStudents);
              final int _tmpNumTeachers;
              _tmpNumTeachers = cursor.getInt(_cursorIndexOfNumTeachers);
              _item_1.setNumTeachers(_tmpNumTeachers);
              final String _tmpTeacherNames;
              if (cursor.isNull(_cursorIndexOfTeacherNames)) {
                _tmpTeacherNames = null;
              } else {
                _tmpTeacherNames = cursor.getString(_cursorIndexOfTeacherNames);
              }
              _item_1.setTeacherNames(_tmpTeacherNames);
              final long _tmpLastRecorded;
              _tmpLastRecorded = cursor.getLong(_cursorIndexOfLastRecorded);
              _item_1.setLastRecorded(_tmpLastRecorded);
              _item_1.setClazzActiveEnrolment(_tmpClazzActiveEnrolment);
              _item_1.setTerminology(_tmpTerminology);
              _res.add(_item_1);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public Object getClassNamesFromListOfIds(final List<Long> ids,
      final Continuation<? super List<UidAndLabel>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT Clazz.clazzUid AS uid, Clazz.clazzName AS labelName From Clazz WHERE clazzUid IN (");
    final int _inputSize = ids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : ids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<UidAndLabel>>() {
      @Override
      public List<UidAndLabel> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUid = 0;
          final int _cursorIndexOfLabelName = 1;
          final List<UidAndLabel> _result = new ArrayList<UidAndLabel>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final UidAndLabel _item_1;
            _item_1 = new UidAndLabel();
            final long _tmpUid;
            _tmpUid = _cursor.getLong(_cursorIndexOfUid);
            _item_1.setUid(_tmpUid);
            final String _tmpLabelName;
            if (_cursor.isNull(_cursorIndexOfLabelName)) {
              _tmpLabelName = null;
            } else {
              _tmpLabelName = _cursor.getString(_cursorIndexOfLabelName);
            }
            _item_1.setLabelName(_tmpLabelName);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public List<Clazz> findByClazzName(final String name) {
    final String _sql = "SELECT * FROM Clazz WHERE clazzName = ? and CAST(isClazzActive AS INTEGER) = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (name == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, name);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
      final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
      final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
      final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
      final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
      final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
      final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
      final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
      final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
      final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
      final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
      final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
      final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
      final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
      final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
      final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
      final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
      final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
      final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
      final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
      final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
      final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
      final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
      final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
      final List<Clazz> _result = new ArrayList<Clazz>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final Clazz _item;
        _item = new Clazz();
        final long _tmpClazzUid;
        _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
        _item.setClazzUid(_tmpClazzUid);
        final String _tmpClazzName;
        if (_cursor.isNull(_cursorIndexOfClazzName)) {
          _tmpClazzName = null;
        } else {
          _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
        }
        _item.setClazzName(_tmpClazzName);
        final String _tmpClazzDesc;
        if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
          _tmpClazzDesc = null;
        } else {
          _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
        }
        _item.setClazzDesc(_tmpClazzDesc);
        final float _tmpAttendanceAverage;
        _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
        _item.setAttendanceAverage(_tmpAttendanceAverage);
        final long _tmpClazzHolidayUMCalendarUid;
        _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
        _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
        final long _tmpClazzScheuleUMCalendarUid;
        _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
        _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
        final boolean _tmpIsClazzActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfIsClazzActive);
        _tmpIsClazzActive = _tmp != 0;
        _item.setClazzActive(_tmpIsClazzActive);
        final long _tmpClazzLocationUid;
        _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
        _item.setClazzLocationUid(_tmpClazzLocationUid);
        final long _tmpClazzStartTime;
        _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
        _item.setClazzStartTime(_tmpClazzStartTime);
        final long _tmpClazzEndTime;
        _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
        _item.setClazzEndTime(_tmpClazzEndTime);
        final long _tmpClazzFeatures;
        _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
        _item.setClazzFeatures(_tmpClazzFeatures);
        final long _tmpClazzSchoolUid;
        _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
        _item.setClazzSchoolUid(_tmpClazzSchoolUid);
        final int _tmpClazzEnrolmentPolicy;
        _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
        _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
        final long _tmpClazzTerminologyUid;
        _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
        _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
        final long _tmpClazzMasterChangeSeqNum;
        _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
        _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
        final long _tmpClazzLocalChangeSeqNum;
        _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
        _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
        final int _tmpClazzLastChangedBy;
        _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
        _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
        final long _tmpClazzLct;
        _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
        _item.setClazzLct(_tmpClazzLct);
        final String _tmpClazzTimeZone;
        if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
          _tmpClazzTimeZone = null;
        } else {
          _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
        }
        _item.setClazzTimeZone(_tmpClazzTimeZone);
        final long _tmpClazzStudentsPersonGroupUid;
        _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
        _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
        final long _tmpClazzTeachersPersonGroupUid;
        _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
        _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
        final long _tmpClazzPendingStudentsPersonGroupUid;
        _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
        _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
        final long _tmpClazzParentsPersonGroupUid;
        _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
        _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
        final String _tmpClazzCode;
        if (_cursor.isNull(_cursorIndexOfClazzCode)) {
          _tmpClazzCode = null;
        } else {
          _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
        }
        _item.setClazzCode(_tmpClazzCode);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object personHasPermissionWithClazz(final long accountPersonUid, final long clazzUid,
      final long permission, final Continuation<? super Boolean> continuation) {
    final String _sql = "\n"
            + "        SELECT EXISTS( \n"
            + "               SELECT PrsGrpMbr.groupMemberPersonUid\n"
            + "                  FROM Clazz\n"
            + "                       \n"
            + "            JOIN ScopedGrant\n"
            + "                 ON \n"
            + "            ((ScopedGrant.sgTableId = -2\n"
            + "                                AND ScopedGrant.sgEntityUid = -2)\n"
            + "                            OR (ScopedGrant.sgTableId = 6\n"
            + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
            + "                            OR (ScopedGrant.sgTableId = 164\n"
            + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
            + "        \n"
            + "                    AND (ScopedGrant.sgPermissions & \n"
            + "        \n"
            + "                          ?\n"
            + "                          \n"
            + "                                                       ) > 0\n"
            + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
            + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
            + "        \n"
            + "                 WHERE Clazz.clazzUid = ?\n"
            + "                   AND PrsGrpMbr.groupMemberPersonUid = ?)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, permission);
    _argIndex = 2;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object selectDelegatablePermissions(final long accountPersonUid, final long clazzUid,
      final Continuation<? super List<Long>> continuation) {
    final String _sql = "\n"
            + "        SELECT ScopedGrant.sgPermissions\n"
            + "          FROM Clazz\n"
            + "               JOIN ScopedGrant\n"
            + "                    ON \n"
            + "            ((ScopedGrant.sgTableId = -2\n"
            + "                                AND ScopedGrant.sgEntityUid = -2)\n"
            + "                            OR (ScopedGrant.sgTableId = 6\n"
            + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
            + "                            OR (ScopedGrant.sgTableId = 164\n"
            + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
            + "        \n"
            + "               JOIN PersonGroupMember AS PrsGrpMbr\n"
            + "                    ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
            + "         WHERE Clazz.clazzUid = ?\n"
            + "           AND (ScopedGrant.sgPermissions & 4294967296) > 0\n"
            + "           AND PrsGrpMbr.groupMemberPersonUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Long>>() {
      @Override
      public List<Long> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Long _item;
            _item = _cursor.getLong(0);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<ClazzWithDisplayDetails> getClazzWithDisplayDetails(final long clazzUid,
      final long currentTime) {
    final String _sql = "\n"
            + "        SELECT Clazz.*, \n"
            + "               HolidayCalendar.*, \n"
            + "               School.*,\n"
            + "               (SELECT COUNT(*) \n"
            + "                  FROM ClazzEnrolment \n"
            + "                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n"
            + "                   AND clazzEnrolmentRole = 1000 \n"
            + "                   AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n"
            + "                        AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numStudents,\n"
            + "               (SELECT COUNT(*) \n"
            + "                  FROM ClazzEnrolment \n"
            + "                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n"
            + "                   AND clazzEnrolmentRole = 1001 \n"
            + "                   AND ? BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n"
            + "                       AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numTeachers,\n"
            + "                CourseTerminology.*      \n"
            + "         FROM Clazz \n"
            + "              LEFT JOIN HolidayCalendar \n"
            + "              ON Clazz.clazzHolidayUMCalendarUid = HolidayCalendar.umCalendarUid\n"
            + "              LEFT JOIN School \n"
            + "              ON School.schoolUid = Clazz.clazzSchoolUid\n"
            + "              LEFT JOIN CourseTerminology\n"
            + "              ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n"
            + "        WHERE Clazz.clazzUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 2;
    _statement.bindLong(_argIndex, currentTime);
    _argIndex = 3;
    _statement.bindLong(_argIndex, clazzUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ClazzEnrolment","Clazz","HolidayCalendar","School","CourseTerminology"}, false, new Callable<ClazzWithDisplayDetails>() {
      @Override
      public ClazzWithDisplayDetails call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
          final int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarName");
          final int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarCategory");
          final int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarActive");
          final int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarMasterChangeSeqNum");
          final int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLocalChangeSeqNum");
          final int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLastChangedBy");
          final int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLct");
          final int _cursorIndexOfSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolUid");
          final int _cursorIndexOfSchoolName = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolName");
          final int _cursorIndexOfSchoolDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolDesc");
          final int _cursorIndexOfSchoolAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolAddress");
          final int _cursorIndexOfSchoolActive = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolActive");
          final int _cursorIndexOfSchoolPhoneNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPhoneNumber");
          final int _cursorIndexOfSchoolGender = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolGender");
          final int _cursorIndexOfSchoolHolidayCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolHolidayCalendarUid");
          final int _cursorIndexOfSchoolFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolFeatures");
          final int _cursorIndexOfSchoolLocationLong = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLong");
          final int _cursorIndexOfSchoolLocationLatt = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLatt");
          final int _cursorIndexOfSchoolEmailAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolEmailAddress");
          final int _cursorIndexOfSchoolTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTeachersPersonGroupUid");
          final int _cursorIndexOfSchoolStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolStudentsPersonGroupUid");
          final int _cursorIndexOfSchoolPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPendingStudentsPersonGroupUid");
          final int _cursorIndexOfSchoolCode = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolCode");
          final int _cursorIndexOfSchoolMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMasterChangeSeqNum");
          final int _cursorIndexOfSchoolLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocalChangeSeqNum");
          final int _cursorIndexOfSchoolLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLastChangedBy");
          final int _cursorIndexOfSchoolLct = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLct");
          final int _cursorIndexOfSchoolTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTimeZone");
          final int _cursorIndexOfNumStudents = CursorUtil.getColumnIndexOrThrow(_cursor, "numStudents");
          final int _cursorIndexOfNumTeachers = CursorUtil.getColumnIndexOrThrow(_cursor, "numTeachers");
          final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctUid");
          final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTitle");
          final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTerminology");
          final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ctLct");
          final ClazzWithDisplayDetails _result;
          if(_cursor.moveToFirst()) {
            final HolidayCalendar _tmpClazzHolidayCalendar;
            if (! (_cursor.isNull(_cursorIndexOfUmCalendarUid) && _cursor.isNull(_cursorIndexOfUmCalendarName) && _cursor.isNull(_cursorIndexOfUmCalendarCategory) && _cursor.isNull(_cursorIndexOfUmCalendarActive) && _cursor.isNull(_cursorIndexOfUmCalendarMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLastChangedBy) && _cursor.isNull(_cursorIndexOfUmCalendarLct))) {
              _tmpClazzHolidayCalendar = new HolidayCalendar();
              final long _tmpUmCalendarUid;
              _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
              _tmpClazzHolidayCalendar.setUmCalendarUid(_tmpUmCalendarUid);
              final String _tmpUmCalendarName;
              if (_cursor.isNull(_cursorIndexOfUmCalendarName)) {
                _tmpUmCalendarName = null;
              } else {
                _tmpUmCalendarName = _cursor.getString(_cursorIndexOfUmCalendarName);
              }
              _tmpClazzHolidayCalendar.setUmCalendarName(_tmpUmCalendarName);
              final int _tmpUmCalendarCategory;
              _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
              _tmpClazzHolidayCalendar.setUmCalendarCategory(_tmpUmCalendarCategory);
              final boolean _tmpUmCalendarActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfUmCalendarActive);
              _tmpUmCalendarActive = _tmp != 0;
              _tmpClazzHolidayCalendar.setUmCalendarActive(_tmpUmCalendarActive);
              final long _tmpUmCalendarMasterChangeSeqNum;
              _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
              _tmpClazzHolidayCalendar.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
              final long _tmpUmCalendarLocalChangeSeqNum;
              _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
              _tmpClazzHolidayCalendar.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
              final int _tmpUmCalendarLastChangedBy;
              _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
              _tmpClazzHolidayCalendar.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
              final long _tmpUmCalendarLct;
              _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
              _tmpClazzHolidayCalendar.setUmCalendarLct(_tmpUmCalendarLct);
            }  else  {
              _tmpClazzHolidayCalendar = null;
            }
            final School _tmpClazzSchool;
            if (! (_cursor.isNull(_cursorIndexOfSchoolUid) && _cursor.isNull(_cursorIndexOfSchoolName) && _cursor.isNull(_cursorIndexOfSchoolDesc) && _cursor.isNull(_cursorIndexOfSchoolAddress) && _cursor.isNull(_cursorIndexOfSchoolActive) && _cursor.isNull(_cursorIndexOfSchoolPhoneNumber) && _cursor.isNull(_cursorIndexOfSchoolGender) && _cursor.isNull(_cursorIndexOfSchoolHolidayCalendarUid) && _cursor.isNull(_cursorIndexOfSchoolFeatures) && _cursor.isNull(_cursorIndexOfSchoolLocationLong) && _cursor.isNull(_cursorIndexOfSchoolLocationLatt) && _cursor.isNull(_cursorIndexOfSchoolEmailAddress) && _cursor.isNull(_cursorIndexOfSchoolTeachersPersonGroupUid) && _cursor.isNull(_cursorIndexOfSchoolStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfSchoolPendingStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfSchoolCode) && _cursor.isNull(_cursorIndexOfSchoolMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfSchoolLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfSchoolLastChangedBy) && _cursor.isNull(_cursorIndexOfSchoolLct) && _cursor.isNull(_cursorIndexOfSchoolTimeZone))) {
              _tmpClazzSchool = new School();
              final long _tmpSchoolUid;
              _tmpSchoolUid = _cursor.getLong(_cursorIndexOfSchoolUid);
              _tmpClazzSchool.setSchoolUid(_tmpSchoolUid);
              final String _tmpSchoolName;
              if (_cursor.isNull(_cursorIndexOfSchoolName)) {
                _tmpSchoolName = null;
              } else {
                _tmpSchoolName = _cursor.getString(_cursorIndexOfSchoolName);
              }
              _tmpClazzSchool.setSchoolName(_tmpSchoolName);
              final String _tmpSchoolDesc;
              if (_cursor.isNull(_cursorIndexOfSchoolDesc)) {
                _tmpSchoolDesc = null;
              } else {
                _tmpSchoolDesc = _cursor.getString(_cursorIndexOfSchoolDesc);
              }
              _tmpClazzSchool.setSchoolDesc(_tmpSchoolDesc);
              final String _tmpSchoolAddress;
              if (_cursor.isNull(_cursorIndexOfSchoolAddress)) {
                _tmpSchoolAddress = null;
              } else {
                _tmpSchoolAddress = _cursor.getString(_cursorIndexOfSchoolAddress);
              }
              _tmpClazzSchool.setSchoolAddress(_tmpSchoolAddress);
              final boolean _tmpSchoolActive;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfSchoolActive);
              _tmpSchoolActive = _tmp_1 != 0;
              _tmpClazzSchool.setSchoolActive(_tmpSchoolActive);
              final String _tmpSchoolPhoneNumber;
              if (_cursor.isNull(_cursorIndexOfSchoolPhoneNumber)) {
                _tmpSchoolPhoneNumber = null;
              } else {
                _tmpSchoolPhoneNumber = _cursor.getString(_cursorIndexOfSchoolPhoneNumber);
              }
              _tmpClazzSchool.setSchoolPhoneNumber(_tmpSchoolPhoneNumber);
              final int _tmpSchoolGender;
              _tmpSchoolGender = _cursor.getInt(_cursorIndexOfSchoolGender);
              _tmpClazzSchool.setSchoolGender(_tmpSchoolGender);
              final long _tmpSchoolHolidayCalendarUid;
              _tmpSchoolHolidayCalendarUid = _cursor.getLong(_cursorIndexOfSchoolHolidayCalendarUid);
              _tmpClazzSchool.setSchoolHolidayCalendarUid(_tmpSchoolHolidayCalendarUid);
              final long _tmpSchoolFeatures;
              _tmpSchoolFeatures = _cursor.getLong(_cursorIndexOfSchoolFeatures);
              _tmpClazzSchool.setSchoolFeatures(_tmpSchoolFeatures);
              final double _tmpSchoolLocationLong;
              _tmpSchoolLocationLong = _cursor.getDouble(_cursorIndexOfSchoolLocationLong);
              _tmpClazzSchool.setSchoolLocationLong(_tmpSchoolLocationLong);
              final double _tmpSchoolLocationLatt;
              _tmpSchoolLocationLatt = _cursor.getDouble(_cursorIndexOfSchoolLocationLatt);
              _tmpClazzSchool.setSchoolLocationLatt(_tmpSchoolLocationLatt);
              final String _tmpSchoolEmailAddress;
              if (_cursor.isNull(_cursorIndexOfSchoolEmailAddress)) {
                _tmpSchoolEmailAddress = null;
              } else {
                _tmpSchoolEmailAddress = _cursor.getString(_cursorIndexOfSchoolEmailAddress);
              }
              _tmpClazzSchool.setSchoolEmailAddress(_tmpSchoolEmailAddress);
              final long _tmpSchoolTeachersPersonGroupUid;
              _tmpSchoolTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolTeachersPersonGroupUid);
              _tmpClazzSchool.setSchoolTeachersPersonGroupUid(_tmpSchoolTeachersPersonGroupUid);
              final long _tmpSchoolStudentsPersonGroupUid;
              _tmpSchoolStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolStudentsPersonGroupUid);
              _tmpClazzSchool.setSchoolStudentsPersonGroupUid(_tmpSchoolStudentsPersonGroupUid);
              final long _tmpSchoolPendingStudentsPersonGroupUid;
              _tmpSchoolPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolPendingStudentsPersonGroupUid);
              _tmpClazzSchool.setSchoolPendingStudentsPersonGroupUid(_tmpSchoolPendingStudentsPersonGroupUid);
              final String _tmpSchoolCode;
              if (_cursor.isNull(_cursorIndexOfSchoolCode)) {
                _tmpSchoolCode = null;
              } else {
                _tmpSchoolCode = _cursor.getString(_cursorIndexOfSchoolCode);
              }
              _tmpClazzSchool.setSchoolCode(_tmpSchoolCode);
              final long _tmpSchoolMasterChangeSeqNum;
              _tmpSchoolMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolMasterChangeSeqNum);
              _tmpClazzSchool.setSchoolMasterChangeSeqNum(_tmpSchoolMasterChangeSeqNum);
              final long _tmpSchoolLocalChangeSeqNum;
              _tmpSchoolLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolLocalChangeSeqNum);
              _tmpClazzSchool.setSchoolLocalChangeSeqNum(_tmpSchoolLocalChangeSeqNum);
              final int _tmpSchoolLastChangedBy;
              _tmpSchoolLastChangedBy = _cursor.getInt(_cursorIndexOfSchoolLastChangedBy);
              _tmpClazzSchool.setSchoolLastChangedBy(_tmpSchoolLastChangedBy);
              final long _tmpSchoolLct;
              _tmpSchoolLct = _cursor.getLong(_cursorIndexOfSchoolLct);
              _tmpClazzSchool.setSchoolLct(_tmpSchoolLct);
              final String _tmpSchoolTimeZone;
              if (_cursor.isNull(_cursorIndexOfSchoolTimeZone)) {
                _tmpSchoolTimeZone = null;
              } else {
                _tmpSchoolTimeZone = _cursor.getString(_cursorIndexOfSchoolTimeZone);
              }
              _tmpClazzSchool.setSchoolTimeZone(_tmpSchoolTimeZone);
            }  else  {
              _tmpClazzSchool = null;
            }
            final CourseTerminology _tmpTerminology;
            if (! (_cursor.isNull(_cursorIndexOfCtUid) && _cursor.isNull(_cursorIndexOfCtTitle) && _cursor.isNull(_cursorIndexOfCtTerminology) && _cursor.isNull(_cursorIndexOfCtLct))) {
              _tmpTerminology = new CourseTerminology();
              final long _tmpCtUid;
              _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
              _tmpTerminology.setCtUid(_tmpCtUid);
              final String _tmpCtTitle;
              if (_cursor.isNull(_cursorIndexOfCtTitle)) {
                _tmpCtTitle = null;
              } else {
                _tmpCtTitle = _cursor.getString(_cursorIndexOfCtTitle);
              }
              _tmpTerminology.setCtTitle(_tmpCtTitle);
              final String _tmpCtTerminology;
              if (_cursor.isNull(_cursorIndexOfCtTerminology)) {
                _tmpCtTerminology = null;
              } else {
                _tmpCtTerminology = _cursor.getString(_cursorIndexOfCtTerminology);
              }
              _tmpTerminology.setCtTerminology(_tmpCtTerminology);
              final long _tmpCtLct;
              _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
              _tmpTerminology.setCtLct(_tmpCtLct);
            }  else  {
              _tmpTerminology = null;
            }
            _result = new ClazzWithDisplayDetails();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _result.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _result.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _result.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _result.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _result.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _result.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp_2 != 0;
            _result.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _result.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _result.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _result.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _result.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _result.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _result.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _result.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _result.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _result.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _result.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _result.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _result.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _result.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _result.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _result.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _result.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _result.setClazzCode(_tmpClazzCode);
            final int _tmpNumStudents;
            _tmpNumStudents = _cursor.getInt(_cursorIndexOfNumStudents);
            _result.setNumStudents(_tmpNumStudents);
            final int _tmpNumTeachers;
            _tmpNumTeachers = _cursor.getInt(_cursorIndexOfNumTeachers);
            _result.setNumTeachers(_tmpNumTeachers);
            _result.setClazzHolidayCalendar(_tmpClazzHolidayCalendar);
            _result.setClazzSchool(_tmpClazzSchool);
            _result.setTerminology(_tmpTerminology);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public List<ClazzWithHolidayCalendarAndSchoolAndTerminology> findClazzesWithEffectiveHolidayCalendarAndFilter(
      final long filterUid) {
    final String _sql = "\n"
            + "        SELECT Clazz.*, \n"
            + "               HolidayCalendar.*, \n"
            + "               School.*,\n"
            + "               CourseTerminology.*\n"
            + "         FROM Clazz \n"
            + "              LEFT JOIN HolidayCalendar \n"
            + "              ON ((clazz.clazzHolidayUMCalendarUid != 0 \n"
            + "                AND HolidayCalendar.umCalendarUid = clazz.clazzHolidayUMCalendarUid)\n"
            + "                OR clazz.clazzHolidayUMCalendarUid = 0 AND clazz.clazzSchoolUid = 0 \n"
            + "                AND HolidayCalendar.umCalendarUid = (SELECT schoolHolidayCalendarUid \n"
            + "                                                       FROM School \n"
            + "                                                      WHERE schoolUid = clazz.clazzSchoolUid))\n"
            + "              LEFT JOIN School \n"
            + "              ON School.schoolUid = Clazz.clazzSchoolUid\n"
            + "              \n"
            + "              LEFT JOIN CourseTerminology\n"
            + "              ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n"
            + "                \n"
            + "        WHERE ? = 0 \n"
            + "           OR Clazz.clazzUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, filterUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, filterUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
      final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
      final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
      final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
      final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
      final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
      final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
      final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
      final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
      final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
      final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
      final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
      final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
      final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
      final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
      final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
      final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
      final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
      final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
      final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
      final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
      final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
      final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
      final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
      final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
      final int _cursorIndexOfUmCalendarName = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarName");
      final int _cursorIndexOfUmCalendarCategory = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarCategory");
      final int _cursorIndexOfUmCalendarActive = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarActive");
      final int _cursorIndexOfUmCalendarMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarMasterChangeSeqNum");
      final int _cursorIndexOfUmCalendarLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLocalChangeSeqNum");
      final int _cursorIndexOfUmCalendarLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLastChangedBy");
      final int _cursorIndexOfUmCalendarLct = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarLct");
      final int _cursorIndexOfSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolUid");
      final int _cursorIndexOfSchoolName = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolName");
      final int _cursorIndexOfSchoolDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolDesc");
      final int _cursorIndexOfSchoolAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolAddress");
      final int _cursorIndexOfSchoolActive = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolActive");
      final int _cursorIndexOfSchoolPhoneNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPhoneNumber");
      final int _cursorIndexOfSchoolGender = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolGender");
      final int _cursorIndexOfSchoolHolidayCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolHolidayCalendarUid");
      final int _cursorIndexOfSchoolFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolFeatures");
      final int _cursorIndexOfSchoolLocationLong = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLong");
      final int _cursorIndexOfSchoolLocationLatt = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLatt");
      final int _cursorIndexOfSchoolEmailAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolEmailAddress");
      final int _cursorIndexOfSchoolTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTeachersPersonGroupUid");
      final int _cursorIndexOfSchoolStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolStudentsPersonGroupUid");
      final int _cursorIndexOfSchoolPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPendingStudentsPersonGroupUid");
      final int _cursorIndexOfSchoolCode = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolCode");
      final int _cursorIndexOfSchoolMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMasterChangeSeqNum");
      final int _cursorIndexOfSchoolLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocalChangeSeqNum");
      final int _cursorIndexOfSchoolLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLastChangedBy");
      final int _cursorIndexOfSchoolLct = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLct");
      final int _cursorIndexOfSchoolTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTimeZone");
      final int _cursorIndexOfCtUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ctUid");
      final int _cursorIndexOfCtTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTitle");
      final int _cursorIndexOfCtTerminology = CursorUtil.getColumnIndexOrThrow(_cursor, "ctTerminology");
      final int _cursorIndexOfCtLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ctLct");
      final List<ClazzWithHolidayCalendarAndSchoolAndTerminology> _result = new ArrayList<ClazzWithHolidayCalendarAndSchoolAndTerminology>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ClazzWithHolidayCalendarAndSchoolAndTerminology _item;
        final HolidayCalendar _tmpHolidayCalendar;
        if (! (_cursor.isNull(_cursorIndexOfUmCalendarUid) && _cursor.isNull(_cursorIndexOfUmCalendarName) && _cursor.isNull(_cursorIndexOfUmCalendarCategory) && _cursor.isNull(_cursorIndexOfUmCalendarActive) && _cursor.isNull(_cursorIndexOfUmCalendarMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfUmCalendarLastChangedBy) && _cursor.isNull(_cursorIndexOfUmCalendarLct))) {
          _tmpHolidayCalendar = new HolidayCalendar();
          final long _tmpUmCalendarUid;
          _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
          _tmpHolidayCalendar.setUmCalendarUid(_tmpUmCalendarUid);
          final String _tmpUmCalendarName;
          if (_cursor.isNull(_cursorIndexOfUmCalendarName)) {
            _tmpUmCalendarName = null;
          } else {
            _tmpUmCalendarName = _cursor.getString(_cursorIndexOfUmCalendarName);
          }
          _tmpHolidayCalendar.setUmCalendarName(_tmpUmCalendarName);
          final int _tmpUmCalendarCategory;
          _tmpUmCalendarCategory = _cursor.getInt(_cursorIndexOfUmCalendarCategory);
          _tmpHolidayCalendar.setUmCalendarCategory(_tmpUmCalendarCategory);
          final boolean _tmpUmCalendarActive;
          final int _tmp;
          _tmp = _cursor.getInt(_cursorIndexOfUmCalendarActive);
          _tmpUmCalendarActive = _tmp != 0;
          _tmpHolidayCalendar.setUmCalendarActive(_tmpUmCalendarActive);
          final long _tmpUmCalendarMasterChangeSeqNum;
          _tmpUmCalendarMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarMasterChangeSeqNum);
          _tmpHolidayCalendar.setUmCalendarMasterChangeSeqNum(_tmpUmCalendarMasterChangeSeqNum);
          final long _tmpUmCalendarLocalChangeSeqNum;
          _tmpUmCalendarLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfUmCalendarLocalChangeSeqNum);
          _tmpHolidayCalendar.setUmCalendarLocalChangeSeqNum(_tmpUmCalendarLocalChangeSeqNum);
          final int _tmpUmCalendarLastChangedBy;
          _tmpUmCalendarLastChangedBy = _cursor.getInt(_cursorIndexOfUmCalendarLastChangedBy);
          _tmpHolidayCalendar.setUmCalendarLastChangedBy(_tmpUmCalendarLastChangedBy);
          final long _tmpUmCalendarLct;
          _tmpUmCalendarLct = _cursor.getLong(_cursorIndexOfUmCalendarLct);
          _tmpHolidayCalendar.setUmCalendarLct(_tmpUmCalendarLct);
        }  else  {
          _tmpHolidayCalendar = null;
        }
        final School _tmpSchool;
        if (! (_cursor.isNull(_cursorIndexOfSchoolUid) && _cursor.isNull(_cursorIndexOfSchoolName) && _cursor.isNull(_cursorIndexOfSchoolDesc) && _cursor.isNull(_cursorIndexOfSchoolAddress) && _cursor.isNull(_cursorIndexOfSchoolActive) && _cursor.isNull(_cursorIndexOfSchoolPhoneNumber) && _cursor.isNull(_cursorIndexOfSchoolGender) && _cursor.isNull(_cursorIndexOfSchoolHolidayCalendarUid) && _cursor.isNull(_cursorIndexOfSchoolFeatures) && _cursor.isNull(_cursorIndexOfSchoolLocationLong) && _cursor.isNull(_cursorIndexOfSchoolLocationLatt) && _cursor.isNull(_cursorIndexOfSchoolEmailAddress) && _cursor.isNull(_cursorIndexOfSchoolTeachersPersonGroupUid) && _cursor.isNull(_cursorIndexOfSchoolStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfSchoolPendingStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfSchoolCode) && _cursor.isNull(_cursorIndexOfSchoolMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfSchoolLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfSchoolLastChangedBy) && _cursor.isNull(_cursorIndexOfSchoolLct) && _cursor.isNull(_cursorIndexOfSchoolTimeZone))) {
          _tmpSchool = new School();
          final long _tmpSchoolUid;
          _tmpSchoolUid = _cursor.getLong(_cursorIndexOfSchoolUid);
          _tmpSchool.setSchoolUid(_tmpSchoolUid);
          final String _tmpSchoolName;
          if (_cursor.isNull(_cursorIndexOfSchoolName)) {
            _tmpSchoolName = null;
          } else {
            _tmpSchoolName = _cursor.getString(_cursorIndexOfSchoolName);
          }
          _tmpSchool.setSchoolName(_tmpSchoolName);
          final String _tmpSchoolDesc;
          if (_cursor.isNull(_cursorIndexOfSchoolDesc)) {
            _tmpSchoolDesc = null;
          } else {
            _tmpSchoolDesc = _cursor.getString(_cursorIndexOfSchoolDesc);
          }
          _tmpSchool.setSchoolDesc(_tmpSchoolDesc);
          final String _tmpSchoolAddress;
          if (_cursor.isNull(_cursorIndexOfSchoolAddress)) {
            _tmpSchoolAddress = null;
          } else {
            _tmpSchoolAddress = _cursor.getString(_cursorIndexOfSchoolAddress);
          }
          _tmpSchool.setSchoolAddress(_tmpSchoolAddress);
          final boolean _tmpSchoolActive;
          final int _tmp_1;
          _tmp_1 = _cursor.getInt(_cursorIndexOfSchoolActive);
          _tmpSchoolActive = _tmp_1 != 0;
          _tmpSchool.setSchoolActive(_tmpSchoolActive);
          final String _tmpSchoolPhoneNumber;
          if (_cursor.isNull(_cursorIndexOfSchoolPhoneNumber)) {
            _tmpSchoolPhoneNumber = null;
          } else {
            _tmpSchoolPhoneNumber = _cursor.getString(_cursorIndexOfSchoolPhoneNumber);
          }
          _tmpSchool.setSchoolPhoneNumber(_tmpSchoolPhoneNumber);
          final int _tmpSchoolGender;
          _tmpSchoolGender = _cursor.getInt(_cursorIndexOfSchoolGender);
          _tmpSchool.setSchoolGender(_tmpSchoolGender);
          final long _tmpSchoolHolidayCalendarUid;
          _tmpSchoolHolidayCalendarUid = _cursor.getLong(_cursorIndexOfSchoolHolidayCalendarUid);
          _tmpSchool.setSchoolHolidayCalendarUid(_tmpSchoolHolidayCalendarUid);
          final long _tmpSchoolFeatures;
          _tmpSchoolFeatures = _cursor.getLong(_cursorIndexOfSchoolFeatures);
          _tmpSchool.setSchoolFeatures(_tmpSchoolFeatures);
          final double _tmpSchoolLocationLong;
          _tmpSchoolLocationLong = _cursor.getDouble(_cursorIndexOfSchoolLocationLong);
          _tmpSchool.setSchoolLocationLong(_tmpSchoolLocationLong);
          final double _tmpSchoolLocationLatt;
          _tmpSchoolLocationLatt = _cursor.getDouble(_cursorIndexOfSchoolLocationLatt);
          _tmpSchool.setSchoolLocationLatt(_tmpSchoolLocationLatt);
          final String _tmpSchoolEmailAddress;
          if (_cursor.isNull(_cursorIndexOfSchoolEmailAddress)) {
            _tmpSchoolEmailAddress = null;
          } else {
            _tmpSchoolEmailAddress = _cursor.getString(_cursorIndexOfSchoolEmailAddress);
          }
          _tmpSchool.setSchoolEmailAddress(_tmpSchoolEmailAddress);
          final long _tmpSchoolTeachersPersonGroupUid;
          _tmpSchoolTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolTeachersPersonGroupUid);
          _tmpSchool.setSchoolTeachersPersonGroupUid(_tmpSchoolTeachersPersonGroupUid);
          final long _tmpSchoolStudentsPersonGroupUid;
          _tmpSchoolStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolStudentsPersonGroupUid);
          _tmpSchool.setSchoolStudentsPersonGroupUid(_tmpSchoolStudentsPersonGroupUid);
          final long _tmpSchoolPendingStudentsPersonGroupUid;
          _tmpSchoolPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolPendingStudentsPersonGroupUid);
          _tmpSchool.setSchoolPendingStudentsPersonGroupUid(_tmpSchoolPendingStudentsPersonGroupUid);
          final String _tmpSchoolCode;
          if (_cursor.isNull(_cursorIndexOfSchoolCode)) {
            _tmpSchoolCode = null;
          } else {
            _tmpSchoolCode = _cursor.getString(_cursorIndexOfSchoolCode);
          }
          _tmpSchool.setSchoolCode(_tmpSchoolCode);
          final long _tmpSchoolMasterChangeSeqNum;
          _tmpSchoolMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolMasterChangeSeqNum);
          _tmpSchool.setSchoolMasterChangeSeqNum(_tmpSchoolMasterChangeSeqNum);
          final long _tmpSchoolLocalChangeSeqNum;
          _tmpSchoolLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolLocalChangeSeqNum);
          _tmpSchool.setSchoolLocalChangeSeqNum(_tmpSchoolLocalChangeSeqNum);
          final int _tmpSchoolLastChangedBy;
          _tmpSchoolLastChangedBy = _cursor.getInt(_cursorIndexOfSchoolLastChangedBy);
          _tmpSchool.setSchoolLastChangedBy(_tmpSchoolLastChangedBy);
          final long _tmpSchoolLct;
          _tmpSchoolLct = _cursor.getLong(_cursorIndexOfSchoolLct);
          _tmpSchool.setSchoolLct(_tmpSchoolLct);
          final String _tmpSchoolTimeZone;
          if (_cursor.isNull(_cursorIndexOfSchoolTimeZone)) {
            _tmpSchoolTimeZone = null;
          } else {
            _tmpSchoolTimeZone = _cursor.getString(_cursorIndexOfSchoolTimeZone);
          }
          _tmpSchool.setSchoolTimeZone(_tmpSchoolTimeZone);
        }  else  {
          _tmpSchool = null;
        }
        final CourseTerminology _tmpTerminology;
        if (! (_cursor.isNull(_cursorIndexOfCtUid) && _cursor.isNull(_cursorIndexOfCtTitle) && _cursor.isNull(_cursorIndexOfCtTerminology) && _cursor.isNull(_cursorIndexOfCtLct))) {
          _tmpTerminology = new CourseTerminology();
          final long _tmpCtUid;
          _tmpCtUid = _cursor.getLong(_cursorIndexOfCtUid);
          _tmpTerminology.setCtUid(_tmpCtUid);
          final String _tmpCtTitle;
          if (_cursor.isNull(_cursorIndexOfCtTitle)) {
            _tmpCtTitle = null;
          } else {
            _tmpCtTitle = _cursor.getString(_cursorIndexOfCtTitle);
          }
          _tmpTerminology.setCtTitle(_tmpCtTitle);
          final String _tmpCtTerminology;
          if (_cursor.isNull(_cursorIndexOfCtTerminology)) {
            _tmpCtTerminology = null;
          } else {
            _tmpCtTerminology = _cursor.getString(_cursorIndexOfCtTerminology);
          }
          _tmpTerminology.setCtTerminology(_tmpCtTerminology);
          final long _tmpCtLct;
          _tmpCtLct = _cursor.getLong(_cursorIndexOfCtLct);
          _tmpTerminology.setCtLct(_tmpCtLct);
        }  else  {
          _tmpTerminology = null;
        }
        _item = new ClazzWithHolidayCalendarAndSchoolAndTerminology();
        final long _tmpClazzUid;
        _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
        _item.setClazzUid(_tmpClazzUid);
        final String _tmpClazzName;
        if (_cursor.isNull(_cursorIndexOfClazzName)) {
          _tmpClazzName = null;
        } else {
          _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
        }
        _item.setClazzName(_tmpClazzName);
        final String _tmpClazzDesc;
        if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
          _tmpClazzDesc = null;
        } else {
          _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
        }
        _item.setClazzDesc(_tmpClazzDesc);
        final float _tmpAttendanceAverage;
        _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
        _item.setAttendanceAverage(_tmpAttendanceAverage);
        final long _tmpClazzHolidayUMCalendarUid;
        _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
        _item.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
        final long _tmpClazzScheuleUMCalendarUid;
        _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
        _item.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
        final boolean _tmpIsClazzActive;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfIsClazzActive);
        _tmpIsClazzActive = _tmp_2 != 0;
        _item.setClazzActive(_tmpIsClazzActive);
        final long _tmpClazzLocationUid;
        _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
        _item.setClazzLocationUid(_tmpClazzLocationUid);
        final long _tmpClazzStartTime;
        _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
        _item.setClazzStartTime(_tmpClazzStartTime);
        final long _tmpClazzEndTime;
        _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
        _item.setClazzEndTime(_tmpClazzEndTime);
        final long _tmpClazzFeatures;
        _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
        _item.setClazzFeatures(_tmpClazzFeatures);
        final long _tmpClazzSchoolUid;
        _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
        _item.setClazzSchoolUid(_tmpClazzSchoolUid);
        final int _tmpClazzEnrolmentPolicy;
        _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
        _item.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
        final long _tmpClazzTerminologyUid;
        _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
        _item.setClazzTerminologyUid(_tmpClazzTerminologyUid);
        final long _tmpClazzMasterChangeSeqNum;
        _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
        _item.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
        final long _tmpClazzLocalChangeSeqNum;
        _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
        _item.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
        final int _tmpClazzLastChangedBy;
        _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
        _item.setClazzLastChangedBy(_tmpClazzLastChangedBy);
        final long _tmpClazzLct;
        _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
        _item.setClazzLct(_tmpClazzLct);
        final String _tmpClazzTimeZone;
        if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
          _tmpClazzTimeZone = null;
        } else {
          _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
        }
        _item.setClazzTimeZone(_tmpClazzTimeZone);
        final long _tmpClazzStudentsPersonGroupUid;
        _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
        _item.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
        final long _tmpClazzTeachersPersonGroupUid;
        _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
        _item.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
        final long _tmpClazzPendingStudentsPersonGroupUid;
        _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
        _item.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
        final long _tmpClazzParentsPersonGroupUid;
        _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
        _item.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
        final String _tmpClazzCode;
        if (_cursor.isNull(_cursorIndexOfClazzCode)) {
          _tmpClazzCode = null;
        } else {
          _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
        }
        _item.setClazzCode(_tmpClazzCode);
        _item.setHolidayCalendar(_tmpHolidayCalendar);
        _item.setSchool(_tmpSchool);
        _item.setTerminology(_tmpTerminology);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object getClazzWithSchool(final long clazzUid,
      final Continuation<? super ClazzWithSchool> continuation) {
    final String _sql = "SELECT Clazz.*, School.* FROM Clazz LEFT JOIN School ON School.schoolUid = Clazz.clazzSchoolUid WHERE clazz.clazzUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ClazzWithSchool>() {
      @Override
      public ClazzWithSchool call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzUid");
          final int _cursorIndexOfClazzName = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzName");
          final int _cursorIndexOfClazzDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzDesc");
          final int _cursorIndexOfAttendanceAverage = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceAverage");
          final int _cursorIndexOfClazzHolidayUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzHolidayUMCalendarUid");
          final int _cursorIndexOfClazzScheuleUMCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzScheuleUMCalendarUid");
          final int _cursorIndexOfIsClazzActive = CursorUtil.getColumnIndexOrThrow(_cursor, "isClazzActive");
          final int _cursorIndexOfClazzLocationUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocationUid");
          final int _cursorIndexOfClazzStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStartTime");
          final int _cursorIndexOfClazzEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEndTime");
          final int _cursorIndexOfClazzFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzFeatures");
          final int _cursorIndexOfClazzSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzSchoolUid");
          final int _cursorIndexOfClazzEnrolmentPolicy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzEnrolmentPolicy");
          final int _cursorIndexOfClazzTerminologyUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTerminologyUid");
          final int _cursorIndexOfClazzMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzMasterChangeSeqNum");
          final int _cursorIndexOfClazzLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLocalChangeSeqNum");
          final int _cursorIndexOfClazzLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLastChangedBy");
          final int _cursorIndexOfClazzLct = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLct");
          final int _cursorIndexOfClazzTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTimeZone");
          final int _cursorIndexOfClazzStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzStudentsPersonGroupUid");
          final int _cursorIndexOfClazzTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzTeachersPersonGroupUid");
          final int _cursorIndexOfClazzPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzPendingStudentsPersonGroupUid");
          final int _cursorIndexOfClazzParentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzParentsPersonGroupUid");
          final int _cursorIndexOfClazzCode = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzCode");
          final int _cursorIndexOfSchoolUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolUid");
          final int _cursorIndexOfSchoolName = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolName");
          final int _cursorIndexOfSchoolDesc = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolDesc");
          final int _cursorIndexOfSchoolAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolAddress");
          final int _cursorIndexOfSchoolActive = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolActive");
          final int _cursorIndexOfSchoolPhoneNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPhoneNumber");
          final int _cursorIndexOfSchoolGender = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolGender");
          final int _cursorIndexOfSchoolHolidayCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolHolidayCalendarUid");
          final int _cursorIndexOfSchoolFeatures = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolFeatures");
          final int _cursorIndexOfSchoolLocationLong = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLong");
          final int _cursorIndexOfSchoolLocationLatt = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocationLatt");
          final int _cursorIndexOfSchoolEmailAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolEmailAddress");
          final int _cursorIndexOfSchoolTeachersPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTeachersPersonGroupUid");
          final int _cursorIndexOfSchoolStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolStudentsPersonGroupUid");
          final int _cursorIndexOfSchoolPendingStudentsPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolPendingStudentsPersonGroupUid");
          final int _cursorIndexOfSchoolCode = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolCode");
          final int _cursorIndexOfSchoolMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolMasterChangeSeqNum");
          final int _cursorIndexOfSchoolLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLocalChangeSeqNum");
          final int _cursorIndexOfSchoolLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLastChangedBy");
          final int _cursorIndexOfSchoolLct = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolLct");
          final int _cursorIndexOfSchoolTimeZone = CursorUtil.getColumnIndexOrThrow(_cursor, "schoolTimeZone");
          final ClazzWithSchool _result;
          if(_cursor.moveToFirst()) {
            final School _tmpSchool;
            if (! (_cursor.isNull(_cursorIndexOfSchoolUid) && _cursor.isNull(_cursorIndexOfSchoolName) && _cursor.isNull(_cursorIndexOfSchoolDesc) && _cursor.isNull(_cursorIndexOfSchoolAddress) && _cursor.isNull(_cursorIndexOfSchoolActive) && _cursor.isNull(_cursorIndexOfSchoolPhoneNumber) && _cursor.isNull(_cursorIndexOfSchoolGender) && _cursor.isNull(_cursorIndexOfSchoolHolidayCalendarUid) && _cursor.isNull(_cursorIndexOfSchoolFeatures) && _cursor.isNull(_cursorIndexOfSchoolLocationLong) && _cursor.isNull(_cursorIndexOfSchoolLocationLatt) && _cursor.isNull(_cursorIndexOfSchoolEmailAddress) && _cursor.isNull(_cursorIndexOfSchoolTeachersPersonGroupUid) && _cursor.isNull(_cursorIndexOfSchoolStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfSchoolPendingStudentsPersonGroupUid) && _cursor.isNull(_cursorIndexOfSchoolCode) && _cursor.isNull(_cursorIndexOfSchoolMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfSchoolLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfSchoolLastChangedBy) && _cursor.isNull(_cursorIndexOfSchoolLct) && _cursor.isNull(_cursorIndexOfSchoolTimeZone))) {
              _tmpSchool = new School();
              final long _tmpSchoolUid;
              _tmpSchoolUid = _cursor.getLong(_cursorIndexOfSchoolUid);
              _tmpSchool.setSchoolUid(_tmpSchoolUid);
              final String _tmpSchoolName;
              if (_cursor.isNull(_cursorIndexOfSchoolName)) {
                _tmpSchoolName = null;
              } else {
                _tmpSchoolName = _cursor.getString(_cursorIndexOfSchoolName);
              }
              _tmpSchool.setSchoolName(_tmpSchoolName);
              final String _tmpSchoolDesc;
              if (_cursor.isNull(_cursorIndexOfSchoolDesc)) {
                _tmpSchoolDesc = null;
              } else {
                _tmpSchoolDesc = _cursor.getString(_cursorIndexOfSchoolDesc);
              }
              _tmpSchool.setSchoolDesc(_tmpSchoolDesc);
              final String _tmpSchoolAddress;
              if (_cursor.isNull(_cursorIndexOfSchoolAddress)) {
                _tmpSchoolAddress = null;
              } else {
                _tmpSchoolAddress = _cursor.getString(_cursorIndexOfSchoolAddress);
              }
              _tmpSchool.setSchoolAddress(_tmpSchoolAddress);
              final boolean _tmpSchoolActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfSchoolActive);
              _tmpSchoolActive = _tmp != 0;
              _tmpSchool.setSchoolActive(_tmpSchoolActive);
              final String _tmpSchoolPhoneNumber;
              if (_cursor.isNull(_cursorIndexOfSchoolPhoneNumber)) {
                _tmpSchoolPhoneNumber = null;
              } else {
                _tmpSchoolPhoneNumber = _cursor.getString(_cursorIndexOfSchoolPhoneNumber);
              }
              _tmpSchool.setSchoolPhoneNumber(_tmpSchoolPhoneNumber);
              final int _tmpSchoolGender;
              _tmpSchoolGender = _cursor.getInt(_cursorIndexOfSchoolGender);
              _tmpSchool.setSchoolGender(_tmpSchoolGender);
              final long _tmpSchoolHolidayCalendarUid;
              _tmpSchoolHolidayCalendarUid = _cursor.getLong(_cursorIndexOfSchoolHolidayCalendarUid);
              _tmpSchool.setSchoolHolidayCalendarUid(_tmpSchoolHolidayCalendarUid);
              final long _tmpSchoolFeatures;
              _tmpSchoolFeatures = _cursor.getLong(_cursorIndexOfSchoolFeatures);
              _tmpSchool.setSchoolFeatures(_tmpSchoolFeatures);
              final double _tmpSchoolLocationLong;
              _tmpSchoolLocationLong = _cursor.getDouble(_cursorIndexOfSchoolLocationLong);
              _tmpSchool.setSchoolLocationLong(_tmpSchoolLocationLong);
              final double _tmpSchoolLocationLatt;
              _tmpSchoolLocationLatt = _cursor.getDouble(_cursorIndexOfSchoolLocationLatt);
              _tmpSchool.setSchoolLocationLatt(_tmpSchoolLocationLatt);
              final String _tmpSchoolEmailAddress;
              if (_cursor.isNull(_cursorIndexOfSchoolEmailAddress)) {
                _tmpSchoolEmailAddress = null;
              } else {
                _tmpSchoolEmailAddress = _cursor.getString(_cursorIndexOfSchoolEmailAddress);
              }
              _tmpSchool.setSchoolEmailAddress(_tmpSchoolEmailAddress);
              final long _tmpSchoolTeachersPersonGroupUid;
              _tmpSchoolTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolTeachersPersonGroupUid);
              _tmpSchool.setSchoolTeachersPersonGroupUid(_tmpSchoolTeachersPersonGroupUid);
              final long _tmpSchoolStudentsPersonGroupUid;
              _tmpSchoolStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolStudentsPersonGroupUid);
              _tmpSchool.setSchoolStudentsPersonGroupUid(_tmpSchoolStudentsPersonGroupUid);
              final long _tmpSchoolPendingStudentsPersonGroupUid;
              _tmpSchoolPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfSchoolPendingStudentsPersonGroupUid);
              _tmpSchool.setSchoolPendingStudentsPersonGroupUid(_tmpSchoolPendingStudentsPersonGroupUid);
              final String _tmpSchoolCode;
              if (_cursor.isNull(_cursorIndexOfSchoolCode)) {
                _tmpSchoolCode = null;
              } else {
                _tmpSchoolCode = _cursor.getString(_cursorIndexOfSchoolCode);
              }
              _tmpSchool.setSchoolCode(_tmpSchoolCode);
              final long _tmpSchoolMasterChangeSeqNum;
              _tmpSchoolMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolMasterChangeSeqNum);
              _tmpSchool.setSchoolMasterChangeSeqNum(_tmpSchoolMasterChangeSeqNum);
              final long _tmpSchoolLocalChangeSeqNum;
              _tmpSchoolLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfSchoolLocalChangeSeqNum);
              _tmpSchool.setSchoolLocalChangeSeqNum(_tmpSchoolLocalChangeSeqNum);
              final int _tmpSchoolLastChangedBy;
              _tmpSchoolLastChangedBy = _cursor.getInt(_cursorIndexOfSchoolLastChangedBy);
              _tmpSchool.setSchoolLastChangedBy(_tmpSchoolLastChangedBy);
              final long _tmpSchoolLct;
              _tmpSchoolLct = _cursor.getLong(_cursorIndexOfSchoolLct);
              _tmpSchool.setSchoolLct(_tmpSchoolLct);
              final String _tmpSchoolTimeZone;
              if (_cursor.isNull(_cursorIndexOfSchoolTimeZone)) {
                _tmpSchoolTimeZone = null;
              } else {
                _tmpSchoolTimeZone = _cursor.getString(_cursorIndexOfSchoolTimeZone);
              }
              _tmpSchool.setSchoolTimeZone(_tmpSchoolTimeZone);
            }  else  {
              _tmpSchool = null;
            }
            _result = new ClazzWithSchool();
            final long _tmpClazzUid;
            _tmpClazzUid = _cursor.getLong(_cursorIndexOfClazzUid);
            _result.setClazzUid(_tmpClazzUid);
            final String _tmpClazzName;
            if (_cursor.isNull(_cursorIndexOfClazzName)) {
              _tmpClazzName = null;
            } else {
              _tmpClazzName = _cursor.getString(_cursorIndexOfClazzName);
            }
            _result.setClazzName(_tmpClazzName);
            final String _tmpClazzDesc;
            if (_cursor.isNull(_cursorIndexOfClazzDesc)) {
              _tmpClazzDesc = null;
            } else {
              _tmpClazzDesc = _cursor.getString(_cursorIndexOfClazzDesc);
            }
            _result.setClazzDesc(_tmpClazzDesc);
            final float _tmpAttendanceAverage;
            _tmpAttendanceAverage = _cursor.getFloat(_cursorIndexOfAttendanceAverage);
            _result.setAttendanceAverage(_tmpAttendanceAverage);
            final long _tmpClazzHolidayUMCalendarUid;
            _tmpClazzHolidayUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzHolidayUMCalendarUid);
            _result.setClazzHolidayUMCalendarUid(_tmpClazzHolidayUMCalendarUid);
            final long _tmpClazzScheuleUMCalendarUid;
            _tmpClazzScheuleUMCalendarUid = _cursor.getLong(_cursorIndexOfClazzScheuleUMCalendarUid);
            _result.setClazzScheuleUMCalendarUid(_tmpClazzScheuleUMCalendarUid);
            final boolean _tmpIsClazzActive;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfIsClazzActive);
            _tmpIsClazzActive = _tmp_1 != 0;
            _result.setClazzActive(_tmpIsClazzActive);
            final long _tmpClazzLocationUid;
            _tmpClazzLocationUid = _cursor.getLong(_cursorIndexOfClazzLocationUid);
            _result.setClazzLocationUid(_tmpClazzLocationUid);
            final long _tmpClazzStartTime;
            _tmpClazzStartTime = _cursor.getLong(_cursorIndexOfClazzStartTime);
            _result.setClazzStartTime(_tmpClazzStartTime);
            final long _tmpClazzEndTime;
            _tmpClazzEndTime = _cursor.getLong(_cursorIndexOfClazzEndTime);
            _result.setClazzEndTime(_tmpClazzEndTime);
            final long _tmpClazzFeatures;
            _tmpClazzFeatures = _cursor.getLong(_cursorIndexOfClazzFeatures);
            _result.setClazzFeatures(_tmpClazzFeatures);
            final long _tmpClazzSchoolUid;
            _tmpClazzSchoolUid = _cursor.getLong(_cursorIndexOfClazzSchoolUid);
            _result.setClazzSchoolUid(_tmpClazzSchoolUid);
            final int _tmpClazzEnrolmentPolicy;
            _tmpClazzEnrolmentPolicy = _cursor.getInt(_cursorIndexOfClazzEnrolmentPolicy);
            _result.setClazzEnrolmentPolicy(_tmpClazzEnrolmentPolicy);
            final long _tmpClazzTerminologyUid;
            _tmpClazzTerminologyUid = _cursor.getLong(_cursorIndexOfClazzTerminologyUid);
            _result.setClazzTerminologyUid(_tmpClazzTerminologyUid);
            final long _tmpClazzMasterChangeSeqNum;
            _tmpClazzMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzMasterChangeSeqNum);
            _result.setClazzMasterChangeSeqNum(_tmpClazzMasterChangeSeqNum);
            final long _tmpClazzLocalChangeSeqNum;
            _tmpClazzLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLocalChangeSeqNum);
            _result.setClazzLocalChangeSeqNum(_tmpClazzLocalChangeSeqNum);
            final int _tmpClazzLastChangedBy;
            _tmpClazzLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLastChangedBy);
            _result.setClazzLastChangedBy(_tmpClazzLastChangedBy);
            final long _tmpClazzLct;
            _tmpClazzLct = _cursor.getLong(_cursorIndexOfClazzLct);
            _result.setClazzLct(_tmpClazzLct);
            final String _tmpClazzTimeZone;
            if (_cursor.isNull(_cursorIndexOfClazzTimeZone)) {
              _tmpClazzTimeZone = null;
            } else {
              _tmpClazzTimeZone = _cursor.getString(_cursorIndexOfClazzTimeZone);
            }
            _result.setClazzTimeZone(_tmpClazzTimeZone);
            final long _tmpClazzStudentsPersonGroupUid;
            _tmpClazzStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzStudentsPersonGroupUid);
            _result.setClazzStudentsPersonGroupUid(_tmpClazzStudentsPersonGroupUid);
            final long _tmpClazzTeachersPersonGroupUid;
            _tmpClazzTeachersPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzTeachersPersonGroupUid);
            _result.setClazzTeachersPersonGroupUid(_tmpClazzTeachersPersonGroupUid);
            final long _tmpClazzPendingStudentsPersonGroupUid;
            _tmpClazzPendingStudentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzPendingStudentsPersonGroupUid);
            _result.setClazzPendingStudentsPersonGroupUid(_tmpClazzPendingStudentsPersonGroupUid);
            final long _tmpClazzParentsPersonGroupUid;
            _tmpClazzParentsPersonGroupUid = _cursor.getLong(_cursorIndexOfClazzParentsPersonGroupUid);
            _result.setClazzParentsPersonGroupUid(_tmpClazzParentsPersonGroupUid);
            final String _tmpClazzCode;
            if (_cursor.isNull(_cursorIndexOfClazzCode)) {
              _tmpClazzCode = null;
            } else {
              _tmpClazzCode = _cursor.getString(_cursorIndexOfClazzCode);
            }
            _result.setClazzCode(_tmpClazzCode);
            _result.setSchool(_tmpSchool);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
