package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Container;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.ContentEntryButtonModel;
import com.ustadmobile.lib.db.entities.ContentEntryContentJobItemParams;
import com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin;
import com.ustadmobile.lib.db.entities.ContentEntryStatementScoreProgress;
import com.ustadmobile.lib.db.entities.ContentEntryWithBlockAndLanguage;
import com.ustadmobile.lib.db.entities.ContentEntryWithLanguage;
import com.ustadmobile.lib.db.entities.ContentEntryWithMostRecentContainer;
import com.ustadmobile.lib.db.entities.ContentEntryWithParentChildJoinAndMostRecentContainer;
import com.ustadmobile.lib.db.entities.ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer;
import com.ustadmobile.lib.db.entities.ContentJobItemProgressAndStatus;
import com.ustadmobile.lib.db.entities.CourseBlock;
import com.ustadmobile.lib.db.entities.DistinctCategorySchema;
import com.ustadmobile.lib.db.entities.DownloadJobSizeInfo;
import com.ustadmobile.lib.db.entities.LangUidAndName;
import com.ustadmobile.lib.db.entities.Language;
import com.ustadmobile.lib.db.entities.UidAndLabel;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ContentEntryDao_Impl extends ContentEntryDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContentEntry> __insertionAdapterOfContentEntry;

  private final EntityInsertionAdapter<ContentEntry> __insertionAdapterOfContentEntry_1;

  private final EntityDeletionOrUpdateAdapter<ContentEntry> __updateAdapterOfContentEntry;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfUpdateContentEntryInActive;

  private final SharedSQLiteStatement __preparedStmtOfUpdateContentEntryContentFlag;

  private final SharedSQLiteStatement __preparedStmtOfUpdateContentEntryActiveByContentJobUid;

  public ContentEntryDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContentEntry = new EntityInsertionAdapter<ContentEntry>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ContentEntry` (`contentEntryUid`,`title`,`description`,`entryId`,`author`,`publisher`,`licenseType`,`licenseName`,`licenseUrl`,`sourceUrl`,`thumbnailUrl`,`lastModified`,`primaryLanguageUid`,`languageVariantUid`,`contentFlags`,`leaf`,`publik`,`ceInactive`,`completionCriteria`,`minScore`,`contentTypeFlag`,`contentOwner`,`contentEntryLocalChangeSeqNum`,`contentEntryMasterChangeSeqNum`,`contentEntryLastChangedBy`,`contentEntryLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentEntry value) {
        stmt.bindLong(1, value.getContentEntryUid());
        if (value.getTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getTitle());
        }
        if (value.getDescription() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getDescription());
        }
        if (value.getEntryId() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getEntryId());
        }
        if (value.getAuthor() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getAuthor());
        }
        if (value.getPublisher() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getPublisher());
        }
        stmt.bindLong(7, value.getLicenseType());
        if (value.getLicenseName() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getLicenseName());
        }
        if (value.getLicenseUrl() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getLicenseUrl());
        }
        if (value.getSourceUrl() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getSourceUrl());
        }
        if (value.getThumbnailUrl() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindString(11, value.getThumbnailUrl());
        }
        stmt.bindLong(12, value.getLastModified());
        stmt.bindLong(13, value.getPrimaryLanguageUid());
        stmt.bindLong(14, value.getLanguageVariantUid());
        stmt.bindLong(15, value.getContentFlags());
        final int _tmp = value.getLeaf() ? 1 : 0;
        stmt.bindLong(16, _tmp);
        final int _tmp_1 = value.getPublik() ? 1 : 0;
        stmt.bindLong(17, _tmp_1);
        final int _tmp_2 = value.getCeInactive() ? 1 : 0;
        stmt.bindLong(18, _tmp_2);
        stmt.bindLong(19, value.getCompletionCriteria());
        stmt.bindLong(20, value.getMinScore());
        stmt.bindLong(21, value.getContentTypeFlag());
        stmt.bindLong(22, value.getContentOwner());
        stmt.bindLong(23, value.getContentEntryLocalChangeSeqNum());
        stmt.bindLong(24, value.getContentEntryMasterChangeSeqNum());
        stmt.bindLong(25, value.getContentEntryLastChangedBy());
        stmt.bindLong(26, value.getContentEntryLct());
      }
    };
    this.__insertionAdapterOfContentEntry_1 = new EntityInsertionAdapter<ContentEntry>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `ContentEntry` (`contentEntryUid`,`title`,`description`,`entryId`,`author`,`publisher`,`licenseType`,`licenseName`,`licenseUrl`,`sourceUrl`,`thumbnailUrl`,`lastModified`,`primaryLanguageUid`,`languageVariantUid`,`contentFlags`,`leaf`,`publik`,`ceInactive`,`completionCriteria`,`minScore`,`contentTypeFlag`,`contentOwner`,`contentEntryLocalChangeSeqNum`,`contentEntryMasterChangeSeqNum`,`contentEntryLastChangedBy`,`contentEntryLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentEntry value) {
        stmt.bindLong(1, value.getContentEntryUid());
        if (value.getTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getTitle());
        }
        if (value.getDescription() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getDescription());
        }
        if (value.getEntryId() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getEntryId());
        }
        if (value.getAuthor() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getAuthor());
        }
        if (value.getPublisher() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getPublisher());
        }
        stmt.bindLong(7, value.getLicenseType());
        if (value.getLicenseName() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getLicenseName());
        }
        if (value.getLicenseUrl() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getLicenseUrl());
        }
        if (value.getSourceUrl() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getSourceUrl());
        }
        if (value.getThumbnailUrl() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindString(11, value.getThumbnailUrl());
        }
        stmt.bindLong(12, value.getLastModified());
        stmt.bindLong(13, value.getPrimaryLanguageUid());
        stmt.bindLong(14, value.getLanguageVariantUid());
        stmt.bindLong(15, value.getContentFlags());
        final int _tmp = value.getLeaf() ? 1 : 0;
        stmt.bindLong(16, _tmp);
        final int _tmp_1 = value.getPublik() ? 1 : 0;
        stmt.bindLong(17, _tmp_1);
        final int _tmp_2 = value.getCeInactive() ? 1 : 0;
        stmt.bindLong(18, _tmp_2);
        stmt.bindLong(19, value.getCompletionCriteria());
        stmt.bindLong(20, value.getMinScore());
        stmt.bindLong(21, value.getContentTypeFlag());
        stmt.bindLong(22, value.getContentOwner());
        stmt.bindLong(23, value.getContentEntryLocalChangeSeqNum());
        stmt.bindLong(24, value.getContentEntryMasterChangeSeqNum());
        stmt.bindLong(25, value.getContentEntryLastChangedBy());
        stmt.bindLong(26, value.getContentEntryLct());
      }
    };
    this.__updateAdapterOfContentEntry = new EntityDeletionOrUpdateAdapter<ContentEntry>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ContentEntry` SET `contentEntryUid` = ?,`title` = ?,`description` = ?,`entryId` = ?,`author` = ?,`publisher` = ?,`licenseType` = ?,`licenseName` = ?,`licenseUrl` = ?,`sourceUrl` = ?,`thumbnailUrl` = ?,`lastModified` = ?,`primaryLanguageUid` = ?,`languageVariantUid` = ?,`contentFlags` = ?,`leaf` = ?,`publik` = ?,`ceInactive` = ?,`completionCriteria` = ?,`minScore` = ?,`contentTypeFlag` = ?,`contentOwner` = ?,`contentEntryLocalChangeSeqNum` = ?,`contentEntryMasterChangeSeqNum` = ?,`contentEntryLastChangedBy` = ?,`contentEntryLct` = ? WHERE `contentEntryUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentEntry value) {
        stmt.bindLong(1, value.getContentEntryUid());
        if (value.getTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getTitle());
        }
        if (value.getDescription() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getDescription());
        }
        if (value.getEntryId() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getEntryId());
        }
        if (value.getAuthor() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getAuthor());
        }
        if (value.getPublisher() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getPublisher());
        }
        stmt.bindLong(7, value.getLicenseType());
        if (value.getLicenseName() == null) {
          stmt.bindNull(8);
        } else {
          stmt.bindString(8, value.getLicenseName());
        }
        if (value.getLicenseUrl() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getLicenseUrl());
        }
        if (value.getSourceUrl() == null) {
          stmt.bindNull(10);
        } else {
          stmt.bindString(10, value.getSourceUrl());
        }
        if (value.getThumbnailUrl() == null) {
          stmt.bindNull(11);
        } else {
          stmt.bindString(11, value.getThumbnailUrl());
        }
        stmt.bindLong(12, value.getLastModified());
        stmt.bindLong(13, value.getPrimaryLanguageUid());
        stmt.bindLong(14, value.getLanguageVariantUid());
        stmt.bindLong(15, value.getContentFlags());
        final int _tmp = value.getLeaf() ? 1 : 0;
        stmt.bindLong(16, _tmp);
        final int _tmp_1 = value.getPublik() ? 1 : 0;
        stmt.bindLong(17, _tmp_1);
        final int _tmp_2 = value.getCeInactive() ? 1 : 0;
        stmt.bindLong(18, _tmp_2);
        stmt.bindLong(19, value.getCompletionCriteria());
        stmt.bindLong(20, value.getMinScore());
        stmt.bindLong(21, value.getContentTypeFlag());
        stmt.bindLong(22, value.getContentOwner());
        stmt.bindLong(23, value.getContentEntryLocalChangeSeqNum());
        stmt.bindLong(24, value.getContentEntryMasterChangeSeqNum());
        stmt.bindLong(25, value.getContentEntryLastChangedBy());
        stmt.bindLong(26, value.getContentEntryLct());
        stmt.bindLong(27, value.getContentEntryUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        REPLACE INTO ContentEntryReplicate(cePk, ceDestination)\n"
                + "         SELECT DISTINCT contentEntryUid AS ceUid,\n"
                + "                ? AS siteDestination\n"
                + "           FROM ContentEntry\n"
                + "          WHERE ContentEntry.contentEntryLct != COALESCE(\n"
                + "                (SELECT ceVersionId\n"
                + "                   FROM ContentEntryReplicate\n"
                + "                  WHERE cePk = ContentEntry.contentEntryUid\n"
                + "                    AND ceDestination = ?), -1) \n"
                + "         /*psql ON CONFLICT(cePk, ceDestination) DO UPDATE\n"
                + "                SET cePending = true\n"
                + "         */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        REPLACE INTO ContentEntryReplicate(cePk, ceDestination)\n"
                + "         SELECT DISTINCT ContentEntry.contentEntryUid AS cePk,\n"
                + "                UserSession.usClientNodeId AS siteDestination\n"
                + "           FROM ChangeLog\n"
                + "                JOIN ContentEntry\n"
                + "                    ON ChangeLog.chTableId = 42\n"
                + "                       AND ChangeLog.chEntityPk = ContentEntry.contentEntryUid\n"
                + "                JOIN UserSession ON UserSession.usStatus = 1\n"
                + "          WHERE UserSession.usClientNodeId != (\n"
                + "                SELECT nodeClientId \n"
                + "                  FROM SyncNode\n"
                + "                 LIMIT 1)\n"
                + "            AND ContentEntry.contentEntryLct != COALESCE(\n"
                + "                (SELECT ceVersionId\n"
                + "                   FROM ContentEntryReplicate\n"
                + "                  WHERE cePk = ContentEntry.contentEntryUid\n"
                + "                    AND ceDestination = UserSession.usClientNodeId), 0)     \n"
                + "        /*psql ON CONFLICT(cePk, ceDestination) DO UPDATE\n"
                + "            SET cePending = true\n"
                + "         */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateContentEntryInActive = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "            UPDATE ContentEntry \n"
                + "               SET ceInactive = ?,\n"
                + "                   contentEntryLct = ?        \n"
                + "            WHERE ContentEntry.contentEntryUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateContentEntryContentFlag = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentEntry \n"
                + "           SET contentTypeFlag = ?,\n"
                + "               contentEntryLct = ? \n"
                + "         WHERE ContentEntry.contentEntryUid = ?";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateContentEntryActiveByContentJobUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentEntry\n"
                + "           SET ceInactive = ?,\n"
                + "               contentEntryLct = ?\n"
                + "         WHERE contentEntryUid IN \n"
                + "               (SELECT cjiContentEntryUid \n"
                + "                  FROM ContentJobItem\n"
                + "                 WHERE cjiJobUid = ?\n"
                + "                   AND CAST(ContentJobItem.cjiContentDeletedOnCancellation AS INTEGER) = 1)\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ContentEntry entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfContentEntry.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContentEntry entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfContentEntry.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ContentEntry> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContentEntry.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends ContentEntry> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfContentEntry.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void replaceList(final List<? extends ContentEntry> entries) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContentEntry_1.insert(entries);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void insertWithReplace(final ContentEntry entry) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContentEntry_1.insert(entry);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ContentEntry> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentEntry.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ContentEntry entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentEntry.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final ContentEntry entity,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfContentEntry.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public void updateContentEntryInActive(final long contentEntryUid, final boolean ceInactive,
      final long changedTime) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateContentEntryInActive.acquire();
    int _argIndex = 1;
    final int _tmp = ceInactive ? 1 : 0;
    _stmt.bindLong(_argIndex, _tmp);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, changedTime);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, contentEntryUid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateContentEntryInActive.release(_stmt);
    }
  }

  @Override
  public void updateContentEntryContentFlag(final int contentFlag, final long contentEntryUid,
      final long changedTime) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateContentEntryContentFlag.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, contentFlag);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, changedTime);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, contentEntryUid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateContentEntryContentFlag.release(_stmt);
    }
  }

  @Override
  public Object updateContentEntryActiveByContentJobUid(final long jobId, final boolean inactive,
      final long changedTime, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateContentEntryActiveByContentJobUid.acquire();
        int _argIndex = 1;
        final int _tmp = inactive ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changedTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, jobId);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateContentEntryActiveByContentJobUid.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findEntryWithLanguageByEntryIdAsync(final long entryUuid,
      final Continuation<? super ContentEntryWithLanguage> continuation) {
    final String _sql = "SELECT ContentEntry.*, Language.* FROM ContentEntry LEFT JOIN Language ON Language.langUid = ContentEntry.primaryLanguageUid WHERE ContentEntry.contentEntryUid=?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entryUuid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryWithLanguage>() {
      @Override
      public ContentEntryWithLanguage call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
          final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
          final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
          final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
          final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
          final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
          final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
          final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
          final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
          final ContentEntryWithLanguage _result;
          if(_cursor.moveToFirst()) {
            final Language _tmpLanguage;
            if (! (_cursor.isNull(_cursorIndexOfLangUid) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfIso6391Standard) && _cursor.isNull(_cursorIndexOfIso6392Standard) && _cursor.isNull(_cursorIndexOfIso6393Standard) && _cursor.isNull(_cursorIndexOfLanguageType) && _cursor.isNull(_cursorIndexOfLanguageActive) && _cursor.isNull(_cursorIndexOfLangLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangLastChangedBy) && _cursor.isNull(_cursorIndexOfLangLct))) {
              _tmpLanguage = new Language();
              final long _tmpLangUid;
              _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
              _tmpLanguage.setLangUid(_tmpLangUid);
              final String _tmpName;
              if (_cursor.isNull(_cursorIndexOfName)) {
                _tmpName = null;
              } else {
                _tmpName = _cursor.getString(_cursorIndexOfName);
              }
              _tmpLanguage.setName(_tmpName);
              final String _tmpIso_639_1_standard;
              if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
                _tmpIso_639_1_standard = null;
              } else {
                _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
              }
              _tmpLanguage.setIso_639_1_standard(_tmpIso_639_1_standard);
              final String _tmpIso_639_2_standard;
              if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
                _tmpIso_639_2_standard = null;
              } else {
                _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
              }
              _tmpLanguage.setIso_639_2_standard(_tmpIso_639_2_standard);
              final String _tmpIso_639_3_standard;
              if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
                _tmpIso_639_3_standard = null;
              } else {
                _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
              }
              _tmpLanguage.setIso_639_3_standard(_tmpIso_639_3_standard);
              final String _tmpLanguage_Type;
              if (_cursor.isNull(_cursorIndexOfLanguageType)) {
                _tmpLanguage_Type = null;
              } else {
                _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
              }
              _tmpLanguage.setLanguage_Type(_tmpLanguage_Type);
              final boolean _tmpLanguageActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
              _tmpLanguageActive = _tmp != 0;
              _tmpLanguage.setLanguageActive(_tmpLanguageActive);
              final long _tmpLangLocalChangeSeqNum;
              _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
              _tmpLanguage.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
              final long _tmpLangMasterChangeSeqNum;
              _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
              _tmpLanguage.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
              final int _tmpLangLastChangedBy;
              _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
              _tmpLanguage.setLangLastChangedBy(_tmpLangLastChangedBy);
              final long _tmpLangLct;
              _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
              _tmpLanguage.setLangLct(_tmpLangLct);
            }  else  {
              _tmpLanguage = null;
            }
            _result = new ContentEntryWithLanguage();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp_1 != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_2 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_3 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
            _result.setLanguage(_tmpLanguage);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findEntryWithBlockAndLanguageByUidAsync(final long entityUid,
      final Continuation<? super ContentEntryWithBlockAndLanguage> continuation) {
    final String _sql = "\n"
            + "        SELECT ContentEntry.*, \n"
            + "               Language.*,\n"
            + "               CourseBlock.*\n"
            + "          FROM ContentEntry\n"
            + "               LEFT JOIN Language \n"
            + "               ON Language.langUid = ContentEntry.primaryLanguageUid \n"
            + "               \n"
            + "               LEFT JOIN CourseBlock\n"
            + "               ON CourseBlock.cbType = 104\n"
            + "               AND CourseBlock.cbEntityUid = ?\n"
            + "               \n"
            + "         WHERE ContentEntry.contentEntryUid = ?       \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entityUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entityUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryWithBlockAndLanguage>() {
      @Override
      public ContentEntryWithBlockAndLanguage call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
          final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
          final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
          final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
          final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
          final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
          final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
          final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
          final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
          final int _cursorIndexOfCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbUid");
          final int _cursorIndexOfCbType = CursorUtil.getColumnIndexOrThrow(_cursor, "cbType");
          final int _cursorIndexOfCbIndentLevel = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndentLevel");
          final int _cursorIndexOfCbModuleParentBlockUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbModuleParentBlockUid");
          final int _cursorIndexOfCbTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cbTitle");
          final int _cursorIndexOfCbDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDescription");
          final int _cursorIndexOfCbCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "cbCompletionCriteria");
          final int _cursorIndexOfCbHideUntilDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHideUntilDate");
          final int _cursorIndexOfCbDeadlineDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbDeadlineDate");
          final int _cursorIndexOfCbLateSubmissionPenalty = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLateSubmissionPenalty");
          final int _cursorIndexOfCbGracePeriodDate = CursorUtil.getColumnIndexOrThrow(_cursor, "cbGracePeriodDate");
          final int _cursorIndexOfCbMaxPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMaxPoints");
          final int _cursorIndexOfCbMinPoints = CursorUtil.getColumnIndexOrThrow(_cursor, "cbMinPoints");
          final int _cursorIndexOfCbIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "cbIndex");
          final int _cursorIndexOfCbClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbClazzUid");
          final int _cursorIndexOfCbActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cbActive");
          final int _cursorIndexOfCbHidden = CursorUtil.getColumnIndexOrThrow(_cursor, "cbHidden");
          final int _cursorIndexOfCbEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cbEntityUid");
          final int _cursorIndexOfCbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cbLct");
          final ContentEntryWithBlockAndLanguage _result;
          if(_cursor.moveToFirst()) {
            final Language _tmpLanguage;
            if (! (_cursor.isNull(_cursorIndexOfLangUid) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfIso6391Standard) && _cursor.isNull(_cursorIndexOfIso6392Standard) && _cursor.isNull(_cursorIndexOfIso6393Standard) && _cursor.isNull(_cursorIndexOfLanguageType) && _cursor.isNull(_cursorIndexOfLanguageActive) && _cursor.isNull(_cursorIndexOfLangLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangLastChangedBy) && _cursor.isNull(_cursorIndexOfLangLct))) {
              _tmpLanguage = new Language();
              final long _tmpLangUid;
              _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
              _tmpLanguage.setLangUid(_tmpLangUid);
              final String _tmpName;
              if (_cursor.isNull(_cursorIndexOfName)) {
                _tmpName = null;
              } else {
                _tmpName = _cursor.getString(_cursorIndexOfName);
              }
              _tmpLanguage.setName(_tmpName);
              final String _tmpIso_639_1_standard;
              if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
                _tmpIso_639_1_standard = null;
              } else {
                _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
              }
              _tmpLanguage.setIso_639_1_standard(_tmpIso_639_1_standard);
              final String _tmpIso_639_2_standard;
              if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
                _tmpIso_639_2_standard = null;
              } else {
                _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
              }
              _tmpLanguage.setIso_639_2_standard(_tmpIso_639_2_standard);
              final String _tmpIso_639_3_standard;
              if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
                _tmpIso_639_3_standard = null;
              } else {
                _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
              }
              _tmpLanguage.setIso_639_3_standard(_tmpIso_639_3_standard);
              final String _tmpLanguage_Type;
              if (_cursor.isNull(_cursorIndexOfLanguageType)) {
                _tmpLanguage_Type = null;
              } else {
                _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
              }
              _tmpLanguage.setLanguage_Type(_tmpLanguage_Type);
              final boolean _tmpLanguageActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
              _tmpLanguageActive = _tmp != 0;
              _tmpLanguage.setLanguageActive(_tmpLanguageActive);
              final long _tmpLangLocalChangeSeqNum;
              _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
              _tmpLanguage.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
              final long _tmpLangMasterChangeSeqNum;
              _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
              _tmpLanguage.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
              final int _tmpLangLastChangedBy;
              _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
              _tmpLanguage.setLangLastChangedBy(_tmpLangLastChangedBy);
              final long _tmpLangLct;
              _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
              _tmpLanguage.setLangLct(_tmpLangLct);
            }  else  {
              _tmpLanguage = null;
            }
            final CourseBlock _tmpBlock;
            if (! (_cursor.isNull(_cursorIndexOfCbUid) && _cursor.isNull(_cursorIndexOfCbType) && _cursor.isNull(_cursorIndexOfCbIndentLevel) && _cursor.isNull(_cursorIndexOfCbModuleParentBlockUid) && _cursor.isNull(_cursorIndexOfCbTitle) && _cursor.isNull(_cursorIndexOfCbDescription) && _cursor.isNull(_cursorIndexOfCbCompletionCriteria) && _cursor.isNull(_cursorIndexOfCbHideUntilDate) && _cursor.isNull(_cursorIndexOfCbDeadlineDate) && _cursor.isNull(_cursorIndexOfCbLateSubmissionPenalty) && _cursor.isNull(_cursorIndexOfCbGracePeriodDate) && _cursor.isNull(_cursorIndexOfCbMaxPoints) && _cursor.isNull(_cursorIndexOfCbMinPoints) && _cursor.isNull(_cursorIndexOfCbIndex) && _cursor.isNull(_cursorIndexOfCbClazzUid) && _cursor.isNull(_cursorIndexOfCbActive) && _cursor.isNull(_cursorIndexOfCbHidden) && _cursor.isNull(_cursorIndexOfCbEntityUid) && _cursor.isNull(_cursorIndexOfCbLct))) {
              _tmpBlock = new CourseBlock();
              final long _tmpCbUid;
              _tmpCbUid = _cursor.getLong(_cursorIndexOfCbUid);
              _tmpBlock.setCbUid(_tmpCbUid);
              final int _tmpCbType;
              _tmpCbType = _cursor.getInt(_cursorIndexOfCbType);
              _tmpBlock.setCbType(_tmpCbType);
              final int _tmpCbIndentLevel;
              _tmpCbIndentLevel = _cursor.getInt(_cursorIndexOfCbIndentLevel);
              _tmpBlock.setCbIndentLevel(_tmpCbIndentLevel);
              final long _tmpCbModuleParentBlockUid;
              _tmpCbModuleParentBlockUid = _cursor.getLong(_cursorIndexOfCbModuleParentBlockUid);
              _tmpBlock.setCbModuleParentBlockUid(_tmpCbModuleParentBlockUid);
              final String _tmpCbTitle;
              if (_cursor.isNull(_cursorIndexOfCbTitle)) {
                _tmpCbTitle = null;
              } else {
                _tmpCbTitle = _cursor.getString(_cursorIndexOfCbTitle);
              }
              _tmpBlock.setCbTitle(_tmpCbTitle);
              final String _tmpCbDescription;
              if (_cursor.isNull(_cursorIndexOfCbDescription)) {
                _tmpCbDescription = null;
              } else {
                _tmpCbDescription = _cursor.getString(_cursorIndexOfCbDescription);
              }
              _tmpBlock.setCbDescription(_tmpCbDescription);
              final int _tmpCbCompletionCriteria;
              _tmpCbCompletionCriteria = _cursor.getInt(_cursorIndexOfCbCompletionCriteria);
              _tmpBlock.setCbCompletionCriteria(_tmpCbCompletionCriteria);
              final long _tmpCbHideUntilDate;
              _tmpCbHideUntilDate = _cursor.getLong(_cursorIndexOfCbHideUntilDate);
              _tmpBlock.setCbHideUntilDate(_tmpCbHideUntilDate);
              final long _tmpCbDeadlineDate;
              _tmpCbDeadlineDate = _cursor.getLong(_cursorIndexOfCbDeadlineDate);
              _tmpBlock.setCbDeadlineDate(_tmpCbDeadlineDate);
              final int _tmpCbLateSubmissionPenalty;
              _tmpCbLateSubmissionPenalty = _cursor.getInt(_cursorIndexOfCbLateSubmissionPenalty);
              _tmpBlock.setCbLateSubmissionPenalty(_tmpCbLateSubmissionPenalty);
              final long _tmpCbGracePeriodDate;
              _tmpCbGracePeriodDate = _cursor.getLong(_cursorIndexOfCbGracePeriodDate);
              _tmpBlock.setCbGracePeriodDate(_tmpCbGracePeriodDate);
              final int _tmpCbMaxPoints;
              _tmpCbMaxPoints = _cursor.getInt(_cursorIndexOfCbMaxPoints);
              _tmpBlock.setCbMaxPoints(_tmpCbMaxPoints);
              final int _tmpCbMinPoints;
              _tmpCbMinPoints = _cursor.getInt(_cursorIndexOfCbMinPoints);
              _tmpBlock.setCbMinPoints(_tmpCbMinPoints);
              final int _tmpCbIndex;
              _tmpCbIndex = _cursor.getInt(_cursorIndexOfCbIndex);
              _tmpBlock.setCbIndex(_tmpCbIndex);
              final long _tmpCbClazzUid;
              _tmpCbClazzUid = _cursor.getLong(_cursorIndexOfCbClazzUid);
              _tmpBlock.setCbClazzUid(_tmpCbClazzUid);
              final boolean _tmpCbActive;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfCbActive);
              _tmpCbActive = _tmp_1 != 0;
              _tmpBlock.setCbActive(_tmpCbActive);
              final boolean _tmpCbHidden;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfCbHidden);
              _tmpCbHidden = _tmp_2 != 0;
              _tmpBlock.setCbHidden(_tmpCbHidden);
              final long _tmpCbEntityUid;
              _tmpCbEntityUid = _cursor.getLong(_cursorIndexOfCbEntityUid);
              _tmpBlock.setCbEntityUid(_tmpCbEntityUid);
              final long _tmpCbLct;
              _tmpCbLct = _cursor.getLong(_cursorIndexOfCbLct);
              _tmpBlock.setCbLct(_tmpCbLct);
            }  else  {
              _tmpBlock = null;
            }
            _result = new ContentEntryWithBlockAndLanguage();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp_3 != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_4 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_5;
            _tmp_5 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_5 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
            _result.setLanguage(_tmpLanguage);
            _result.setBlock(_tmpBlock);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findEntryWithContainerByEntryId(final long entryUuid,
      final Continuation<? super ContentEntryWithMostRecentContainer> continuation) {
    final String _sql = "\n"
            + "            SELECT ContentEntry.*, Container.* FROM ContentEntry LEFT \n"
            + "                JOIN Container ON Container.containerUid = (\n"
            + "                    SELECT containerUid FROM Container WHERE containerContentEntryUid =  ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1) \n"
            + "            WHERE ContentEntry.contentEntryUid=?\n"
            + "            ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entryUuid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryWithMostRecentContainer>() {
      @Override
      public ContentEntryWithMostRecentContainer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerUid");
          final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLocalCsn");
          final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntMasterCsn");
          final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModBy");
          final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLct");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerContentEntryUid");
          final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModified");
          final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
          final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(_cursor, "remarks");
          final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(_cursor, "mobileOptimized");
          final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(_cursor, "cntNumEntries");
          final ContentEntryWithMostRecentContainer _result;
          if(_cursor.moveToFirst()) {
            final Container _tmpContainer;
            if (! (_cursor.isNull(_cursorIndexOfContainerUid) && _cursor.isNull(_cursorIndexOfCntLocalCsn) && _cursor.isNull(_cursorIndexOfCntMasterCsn) && _cursor.isNull(_cursorIndexOfCntLastModBy) && _cursor.isNull(_cursorIndexOfCntLct) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfContainerContentEntryUid) && _cursor.isNull(_cursorIndexOfCntLastModified) && _cursor.isNull(_cursorIndexOfMimeType) && _cursor.isNull(_cursorIndexOfRemarks) && _cursor.isNull(_cursorIndexOfMobileOptimized) && _cursor.isNull(_cursorIndexOfCntNumEntries))) {
              _tmpContainer = new Container();
              final long _tmpContainerUid;
              _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
              _tmpContainer.setContainerUid(_tmpContainerUid);
              final long _tmpCntLocalCsn;
              _tmpCntLocalCsn = _cursor.getLong(_cursorIndexOfCntLocalCsn);
              _tmpContainer.setCntLocalCsn(_tmpCntLocalCsn);
              final long _tmpCntMasterCsn;
              _tmpCntMasterCsn = _cursor.getLong(_cursorIndexOfCntMasterCsn);
              _tmpContainer.setCntMasterCsn(_tmpCntMasterCsn);
              final int _tmpCntLastModBy;
              _tmpCntLastModBy = _cursor.getInt(_cursorIndexOfCntLastModBy);
              _tmpContainer.setCntLastModBy(_tmpCntLastModBy);
              final long _tmpCntLct;
              _tmpCntLct = _cursor.getLong(_cursorIndexOfCntLct);
              _tmpContainer.setCntLct(_tmpCntLct);
              final long _tmpFileSize;
              _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
              _tmpContainer.setFileSize(_tmpFileSize);
              final long _tmpContainerContentEntryUid;
              _tmpContainerContentEntryUid = _cursor.getLong(_cursorIndexOfContainerContentEntryUid);
              _tmpContainer.setContainerContentEntryUid(_tmpContainerContentEntryUid);
              final long _tmpCntLastModified;
              _tmpCntLastModified = _cursor.getLong(_cursorIndexOfCntLastModified);
              _tmpContainer.setCntLastModified(_tmpCntLastModified);
              final String _tmpMimeType;
              if (_cursor.isNull(_cursorIndexOfMimeType)) {
                _tmpMimeType = null;
              } else {
                _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
              }
              _tmpContainer.setMimeType(_tmpMimeType);
              final String _tmpRemarks;
              if (_cursor.isNull(_cursorIndexOfRemarks)) {
                _tmpRemarks = null;
              } else {
                _tmpRemarks = _cursor.getString(_cursorIndexOfRemarks);
              }
              _tmpContainer.setRemarks(_tmpRemarks);
              final boolean _tmpMobileOptimized;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfMobileOptimized);
              _tmpMobileOptimized = _tmp != 0;
              _tmpContainer.setMobileOptimized(_tmpMobileOptimized);
              final int _tmpCntNumEntries;
              _tmpCntNumEntries = _cursor.getInt(_cursorIndexOfCntNumEntries);
              _tmpContainer.setCntNumEntries(_tmpCntNumEntries);
            }  else  {
              _tmpContainer = null;
            }
            _result = new ContentEntryWithMostRecentContainer();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp_1 != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_2 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_3 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
            _result.setContainer(_tmpContainer);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<ContentEntryWithMostRecentContainer> findEntryWithContainerByEntryIdLive(
      final long entryUuid) {
    final String _sql = "\n"
            + "            SELECT ContentEntry.*, Container.* FROM ContentEntry LEFT \n"
            + "                JOIN Container ON Container.containerUid = (\n"
            + "                    SELECT containerUid FROM Container WHERE containerContentEntryUid =  ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1) \n"
            + "            WHERE ContentEntry.contentEntryUid=?\n"
            + "            ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entryUuid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ContentEntry","Container"}, false, new Callable<ContentEntryWithMostRecentContainer>() {
      @Override
      public ContentEntryWithMostRecentContainer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerUid");
          final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLocalCsn");
          final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntMasterCsn");
          final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModBy");
          final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLct");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerContentEntryUid");
          final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModified");
          final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
          final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(_cursor, "remarks");
          final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(_cursor, "mobileOptimized");
          final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(_cursor, "cntNumEntries");
          final ContentEntryWithMostRecentContainer _result;
          if(_cursor.moveToFirst()) {
            final Container _tmpContainer;
            if (! (_cursor.isNull(_cursorIndexOfContainerUid) && _cursor.isNull(_cursorIndexOfCntLocalCsn) && _cursor.isNull(_cursorIndexOfCntMasterCsn) && _cursor.isNull(_cursorIndexOfCntLastModBy) && _cursor.isNull(_cursorIndexOfCntLct) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfContainerContentEntryUid) && _cursor.isNull(_cursorIndexOfCntLastModified) && _cursor.isNull(_cursorIndexOfMimeType) && _cursor.isNull(_cursorIndexOfRemarks) && _cursor.isNull(_cursorIndexOfMobileOptimized) && _cursor.isNull(_cursorIndexOfCntNumEntries))) {
              _tmpContainer = new Container();
              final long _tmpContainerUid;
              _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
              _tmpContainer.setContainerUid(_tmpContainerUid);
              final long _tmpCntLocalCsn;
              _tmpCntLocalCsn = _cursor.getLong(_cursorIndexOfCntLocalCsn);
              _tmpContainer.setCntLocalCsn(_tmpCntLocalCsn);
              final long _tmpCntMasterCsn;
              _tmpCntMasterCsn = _cursor.getLong(_cursorIndexOfCntMasterCsn);
              _tmpContainer.setCntMasterCsn(_tmpCntMasterCsn);
              final int _tmpCntLastModBy;
              _tmpCntLastModBy = _cursor.getInt(_cursorIndexOfCntLastModBy);
              _tmpContainer.setCntLastModBy(_tmpCntLastModBy);
              final long _tmpCntLct;
              _tmpCntLct = _cursor.getLong(_cursorIndexOfCntLct);
              _tmpContainer.setCntLct(_tmpCntLct);
              final long _tmpFileSize;
              _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
              _tmpContainer.setFileSize(_tmpFileSize);
              final long _tmpContainerContentEntryUid;
              _tmpContainerContentEntryUid = _cursor.getLong(_cursorIndexOfContainerContentEntryUid);
              _tmpContainer.setContainerContentEntryUid(_tmpContainerContentEntryUid);
              final long _tmpCntLastModified;
              _tmpCntLastModified = _cursor.getLong(_cursorIndexOfCntLastModified);
              _tmpContainer.setCntLastModified(_tmpCntLastModified);
              final String _tmpMimeType;
              if (_cursor.isNull(_cursorIndexOfMimeType)) {
                _tmpMimeType = null;
              } else {
                _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
              }
              _tmpContainer.setMimeType(_tmpMimeType);
              final String _tmpRemarks;
              if (_cursor.isNull(_cursorIndexOfRemarks)) {
                _tmpRemarks = null;
              } else {
                _tmpRemarks = _cursor.getString(_cursorIndexOfRemarks);
              }
              _tmpContainer.setRemarks(_tmpRemarks);
              final boolean _tmpMobileOptimized;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfMobileOptimized);
              _tmpMobileOptimized = _tmp != 0;
              _tmpContainer.setMobileOptimized(_tmpMobileOptimized);
              final int _tmpCntNumEntries;
              _tmpCntNumEntries = _cursor.getInt(_cursorIndexOfCntNumEntries);
              _tmpContainer.setCntNumEntries(_tmpCntNumEntries);
            }  else  {
              _tmpContainer = null;
            }
            _result = new ContentEntryWithMostRecentContainer();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp_1 != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_2 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_3 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
            _result.setContainer(_tmpContainer);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public ContentEntry findBySourceUrl(final String sourceUrl) {
    final String _sql = "SELECT * FROM ContentEntry WHERE sourceUrl = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (sourceUrl == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, sourceUrl);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
      final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
      final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
      final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
      final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
      final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
      final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
      final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
      final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
      final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
      final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
      final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
      final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
      final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
      final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
      final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
      final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
      final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
      final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
      final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
      final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
      final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
      final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
      final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
      final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
      final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
      final ContentEntry _result;
      if(_cursor.moveToFirst()) {
        _result = new ContentEntry();
        final long _tmpContentEntryUid;
        _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
        _result.setContentEntryUid(_tmpContentEntryUid);
        final String _tmpTitle;
        if (_cursor.isNull(_cursorIndexOfTitle)) {
          _tmpTitle = null;
        } else {
          _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
        }
        _result.setTitle(_tmpTitle);
        final String _tmpDescription;
        if (_cursor.isNull(_cursorIndexOfDescription)) {
          _tmpDescription = null;
        } else {
          _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
        }
        _result.setDescription(_tmpDescription);
        final String _tmpEntryId;
        if (_cursor.isNull(_cursorIndexOfEntryId)) {
          _tmpEntryId = null;
        } else {
          _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
        }
        _result.setEntryId(_tmpEntryId);
        final String _tmpAuthor;
        if (_cursor.isNull(_cursorIndexOfAuthor)) {
          _tmpAuthor = null;
        } else {
          _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
        }
        _result.setAuthor(_tmpAuthor);
        final String _tmpPublisher;
        if (_cursor.isNull(_cursorIndexOfPublisher)) {
          _tmpPublisher = null;
        } else {
          _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
        }
        _result.setPublisher(_tmpPublisher);
        final int _tmpLicenseType;
        _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
        _result.setLicenseType(_tmpLicenseType);
        final String _tmpLicenseName;
        if (_cursor.isNull(_cursorIndexOfLicenseName)) {
          _tmpLicenseName = null;
        } else {
          _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
        }
        _result.setLicenseName(_tmpLicenseName);
        final String _tmpLicenseUrl;
        if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
          _tmpLicenseUrl = null;
        } else {
          _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
        }
        _result.setLicenseUrl(_tmpLicenseUrl);
        final String _tmpSourceUrl;
        if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
          _tmpSourceUrl = null;
        } else {
          _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
        }
        _result.setSourceUrl(_tmpSourceUrl);
        final String _tmpThumbnailUrl;
        if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
          _tmpThumbnailUrl = null;
        } else {
          _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
        }
        _result.setThumbnailUrl(_tmpThumbnailUrl);
        final long _tmpLastModified;
        _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
        _result.setLastModified(_tmpLastModified);
        final long _tmpPrimaryLanguageUid;
        _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
        _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
        final long _tmpLanguageVariantUid;
        _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
        _result.setLanguageVariantUid(_tmpLanguageVariantUid);
        final int _tmpContentFlags;
        _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
        _result.setContentFlags(_tmpContentFlags);
        final boolean _tmpLeaf;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfLeaf);
        _tmpLeaf = _tmp != 0;
        _result.setLeaf(_tmpLeaf);
        final boolean _tmpPublik;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
        _tmpPublik = _tmp_1 != 0;
        _result.setPublik(_tmpPublik);
        final boolean _tmpCeInactive;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
        _tmpCeInactive = _tmp_2 != 0;
        _result.setCeInactive(_tmpCeInactive);
        final int _tmpCompletionCriteria;
        _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
        _result.setCompletionCriteria(_tmpCompletionCriteria);
        final int _tmpMinScore;
        _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
        _result.setMinScore(_tmpMinScore);
        final int _tmpContentTypeFlag;
        _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
        _result.setContentTypeFlag(_tmpContentTypeFlag);
        final long _tmpContentOwner;
        _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
        _result.setContentOwner(_tmpContentOwner);
        final long _tmpContentEntryLocalChangeSeqNum;
        _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
        _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
        final long _tmpContentEntryMasterChangeSeqNum;
        _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
        _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
        final int _tmpContentEntryLastChangedBy;
        _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
        _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
        final long _tmpContentEntryLct;
        _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
        _result.setContentEntryLct(_tmpContentEntryLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findTitleByUidAsync(final long contentEntryUid,
      final Continuation<? super String> continuation) {
    final String _sql = "SELECT title FROM ContentEntry WHERE contentEntryUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<String>() {
      @Override
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if(_cursor.moveToFirst()) {
            if (_cursor.isNull(0)) {
              _result = null;
            } else {
              _result = _cursor.getString(0);
            }
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, ContentEntry> getChildrenByParentUid(final long parentUid) {
    final String _sql = "SELECT ContentEntry.* FROM ContentEntry LEFT Join ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    return new DataSource.Factory<Integer, ContentEntry>() {
      @Override
      public LimitOffsetDataSource<ContentEntry> create() {
        return new LimitOffsetDataSource<ContentEntry>(__db, _statement, false, true , "ContentEntry", "ContentEntryParentChildJoin") {
          @Override
          protected List<ContentEntry> convertRows(Cursor cursor) {
            final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryUid");
            final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(cursor, "title");
            final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(cursor, "description");
            final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(cursor, "entryId");
            final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(cursor, "author");
            final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(cursor, "publisher");
            final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(cursor, "licenseType");
            final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(cursor, "licenseName");
            final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(cursor, "licenseUrl");
            final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(cursor, "sourceUrl");
            final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(cursor, "thumbnailUrl");
            final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "lastModified");
            final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(cursor, "primaryLanguageUid");
            final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(cursor, "languageVariantUid");
            final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(cursor, "contentFlags");
            final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(cursor, "leaf");
            final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(cursor, "publik");
            final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(cursor, "ceInactive");
            final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(cursor, "completionCriteria");
            final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(cursor, "minScore");
            final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(cursor, "contentTypeFlag");
            final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwner");
            final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLocalChangeSeqNum");
            final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryMasterChangeSeqNum");
            final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLastChangedBy");
            final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLct");
            final List<ContentEntry> _res = new ArrayList<ContentEntry>(cursor.getCount());
            while(cursor.moveToNext()) {
              final ContentEntry _item;
              _item = new ContentEntry();
              final long _tmpContentEntryUid;
              _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
              _item.setContentEntryUid(_tmpContentEntryUid);
              final String _tmpTitle;
              if (cursor.isNull(_cursorIndexOfTitle)) {
                _tmpTitle = null;
              } else {
                _tmpTitle = cursor.getString(_cursorIndexOfTitle);
              }
              _item.setTitle(_tmpTitle);
              final String _tmpDescription;
              if (cursor.isNull(_cursorIndexOfDescription)) {
                _tmpDescription = null;
              } else {
                _tmpDescription = cursor.getString(_cursorIndexOfDescription);
              }
              _item.setDescription(_tmpDescription);
              final String _tmpEntryId;
              if (cursor.isNull(_cursorIndexOfEntryId)) {
                _tmpEntryId = null;
              } else {
                _tmpEntryId = cursor.getString(_cursorIndexOfEntryId);
              }
              _item.setEntryId(_tmpEntryId);
              final String _tmpAuthor;
              if (cursor.isNull(_cursorIndexOfAuthor)) {
                _tmpAuthor = null;
              } else {
                _tmpAuthor = cursor.getString(_cursorIndexOfAuthor);
              }
              _item.setAuthor(_tmpAuthor);
              final String _tmpPublisher;
              if (cursor.isNull(_cursorIndexOfPublisher)) {
                _tmpPublisher = null;
              } else {
                _tmpPublisher = cursor.getString(_cursorIndexOfPublisher);
              }
              _item.setPublisher(_tmpPublisher);
              final int _tmpLicenseType;
              _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
              _item.setLicenseType(_tmpLicenseType);
              final String _tmpLicenseName;
              if (cursor.isNull(_cursorIndexOfLicenseName)) {
                _tmpLicenseName = null;
              } else {
                _tmpLicenseName = cursor.getString(_cursorIndexOfLicenseName);
              }
              _item.setLicenseName(_tmpLicenseName);
              final String _tmpLicenseUrl;
              if (cursor.isNull(_cursorIndexOfLicenseUrl)) {
                _tmpLicenseUrl = null;
              } else {
                _tmpLicenseUrl = cursor.getString(_cursorIndexOfLicenseUrl);
              }
              _item.setLicenseUrl(_tmpLicenseUrl);
              final String _tmpSourceUrl;
              if (cursor.isNull(_cursorIndexOfSourceUrl)) {
                _tmpSourceUrl = null;
              } else {
                _tmpSourceUrl = cursor.getString(_cursorIndexOfSourceUrl);
              }
              _item.setSourceUrl(_tmpSourceUrl);
              final String _tmpThumbnailUrl;
              if (cursor.isNull(_cursorIndexOfThumbnailUrl)) {
                _tmpThumbnailUrl = null;
              } else {
                _tmpThumbnailUrl = cursor.getString(_cursorIndexOfThumbnailUrl);
              }
              _item.setThumbnailUrl(_tmpThumbnailUrl);
              final long _tmpLastModified;
              _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
              _item.setLastModified(_tmpLastModified);
              final long _tmpPrimaryLanguageUid;
              _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
              _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
              final long _tmpLanguageVariantUid;
              _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
              _item.setLanguageVariantUid(_tmpLanguageVariantUid);
              final int _tmpContentFlags;
              _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
              _item.setContentFlags(_tmpContentFlags);
              final boolean _tmpLeaf;
              final int _tmp;
              _tmp = cursor.getInt(_cursorIndexOfLeaf);
              _tmpLeaf = _tmp != 0;
              _item.setLeaf(_tmpLeaf);
              final boolean _tmpPublik;
              final int _tmp_1;
              _tmp_1 = cursor.getInt(_cursorIndexOfPublik);
              _tmpPublik = _tmp_1 != 0;
              _item.setPublik(_tmpPublik);
              final boolean _tmpCeInactive;
              final int _tmp_2;
              _tmp_2 = cursor.getInt(_cursorIndexOfCeInactive);
              _tmpCeInactive = _tmp_2 != 0;
              _item.setCeInactive(_tmpCeInactive);
              final int _tmpCompletionCriteria;
              _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
              _item.setCompletionCriteria(_tmpCompletionCriteria);
              final int _tmpMinScore;
              _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
              _item.setMinScore(_tmpMinScore);
              final int _tmpContentTypeFlag;
              _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
              _item.setContentTypeFlag(_tmpContentTypeFlag);
              final long _tmpContentOwner;
              _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
              _item.setContentOwner(_tmpContentOwner);
              final long _tmpContentEntryLocalChangeSeqNum;
              _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
              _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
              final long _tmpContentEntryMasterChangeSeqNum;
              _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
              _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
              final int _tmpContentEntryLastChangedBy;
              _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
              _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
              final long _tmpContentEntryLct;
              _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
              _item.setContentEntryLct(_tmpContentEntryLct);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public Object getChildrenByParentAsync(final long parentUid,
      final Continuation<? super List<? extends ContentEntry>> continuation) {
    final String _sql = "\n"
            + "        SELECT ContentEntry.*\n"
            + "          FROM ContentEntryParentChildJoin\n"
            + "               JOIN ContentEntry \n"
            + "                    ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid\n"
            + "         WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContentEntry>>() {
      @Override
      public List<ContentEntry> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final List<ContentEntry> _result = new ArrayList<ContentEntry>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContentEntry _item;
            _item = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _item.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _item.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _item.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _item.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _item.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _item.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _item.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _item.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _item.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _item.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _item.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _item.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _item.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _item.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _item.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _item.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _item.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _item.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _item.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _item.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _item.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _item.setContentEntryLct(_tmpContentEntryLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object getContentJobItemParamsByParentUid(final long parentUid, final int limit,
      final int offset,
      final Continuation<? super List<ContentEntryContentJobItemParams>> continuation) {
    final String _sql = "\n"
            + "        SELECT ContentEntry.contentEntryUid AS contentEntryUid, ContentEntry.leaf AS leaf, \n"
            + "               COALESCE(Container.containerUid, 0) AS mostRecentContainerUid,\n"
            + "               COALESCE(Container.fileSize, 0) AS mostRecentContainerSize\n"
            + "          FROM ContentEntryParentChildJoin\n"
            + "               JOIN ContentEntry \n"
            + "                    ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid\n"
            + "               LEFT JOIN Container\n"
            + "                    ON containerUid = \n"
            + "                        (SELECT COALESCE((\n"
            + "                                SELECT Container.containerUid \n"
            + "                                  FROM Container\n"
            + "                                 WHERE Container.containerContentEntryUid = ContentEntry.contentEntryUid\n"
            + "                              ORDER BY Container.cntLastModified DESC\n"
            + "                                 LIMIT 1),0))\n"
            + "         WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?\n"
            + "         LIMIT ?\n"
            + "        OFFSET ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, limit);
    _argIndex = 3;
    _statement.bindLong(_argIndex, offset);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContentEntryContentJobItemParams>>() {
      @Override
      public List<ContentEntryContentJobItemParams> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = 0;
          final int _cursorIndexOfLeaf = 1;
          final int _cursorIndexOfMostRecentContainerUid = 2;
          final int _cursorIndexOfMostRecentContainerSize = 3;
          final List<ContentEntryContentJobItemParams> _result = new ArrayList<ContentEntryContentJobItemParams>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContentEntryContentJobItemParams _item;
            _item = new ContentEntryContentJobItemParams();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _item.setContentEntryUid(_tmpContentEntryUid);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _item.setLeaf(_tmpLeaf);
            final long _tmpMostRecentContainerUid;
            _tmpMostRecentContainerUid = _cursor.getLong(_cursorIndexOfMostRecentContainerUid);
            _item.setMostRecentContainerUid(_tmpMostRecentContainerUid);
            final long _tmpMostRecentContainerSize;
            _tmpMostRecentContainerSize = _cursor.getLong(_cursorIndexOfMostRecentContainerSize);
            _item.setMostRecentContainerSize(_tmpMostRecentContainerSize);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object getCountNumberOfChildrenByParentUUidAsync(final long parentUid,
      final Continuation<? super Integer> continuation) {
    final String _sql = "SELECT COUNT(*) FROM ContentEntry LEFT Join ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Integer _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp;
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object getContentByUuidAsync(final long parentUid,
      final Continuation<? super ContentEntry> continuation) {
    final String _sql = "SELECT * FROM ContentEntry where contentEntryUid = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntry>() {
      @Override
      public ContentEntry call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final ContentEntry _result;
          if(_cursor.moveToFirst()) {
            _result = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findAllLanguageRelatedEntriesAsync(final long entryUuid,
      final Continuation<? super List<? extends ContentEntry>> continuation) {
    final String _sql = "SELECT ContentEntry.* FROM ContentEntry LEFT JOIN ContentEntryRelatedEntryJoin ON ContentEntryRelatedEntryJoin.cerejRelatedEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryRelatedEntryJoin.relType = 1 AND ContentEntryRelatedEntryJoin.cerejRelatedEntryUid != ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entryUuid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContentEntry>>() {
      @Override
      public List<ContentEntry> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final List<ContentEntry> _result = new ArrayList<ContentEntry>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContentEntry _item;
            _item = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _item.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _item.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _item.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _item.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _item.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _item.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _item.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _item.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _item.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _item.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _item.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _item.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _item.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _item.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _item.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _item.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _item.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _item.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _item.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _item.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _item.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _item.setContentEntryLct(_tmpContentEntryLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findListOfCategoriesAsync(final long parentUid,
      final Continuation<? super List<DistinctCategorySchema>> continuation) {
    final String _sql = "SELECT DISTINCT ContentCategory.contentCategoryUid, ContentCategory.name AS categoryName, ContentCategorySchema.contentCategorySchemaUid, ContentCategorySchema.schemaName FROM ContentEntry LEFT JOIN ContentEntryContentCategoryJoin ON ContentEntryContentCategoryJoin.ceccjContentEntryUid = ContentEntry.contentEntryUid LEFT JOIN ContentCategory ON ContentCategory.contentCategoryUid = ContentEntryContentCategoryJoin.ceccjContentCategoryUid LEFT JOIN ContentCategorySchema ON ContentCategorySchema.contentCategorySchemaUid = ContentCategory.ctnCatContentCategorySchemaUid LEFT JOIN ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ? AND ContentCategory.contentCategoryUid != 0 ORDER BY ContentCategory.name";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<DistinctCategorySchema>>() {
      @Override
      public List<DistinctCategorySchema> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentCategoryUid = 0;
          final int _cursorIndexOfCategoryName = 1;
          final int _cursorIndexOfContentCategorySchemaUid = 2;
          final int _cursorIndexOfSchemaName = 3;
          final List<DistinctCategorySchema> _result = new ArrayList<DistinctCategorySchema>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final DistinctCategorySchema _item;
            _item = new DistinctCategorySchema();
            final long _tmpContentCategoryUid;
            _tmpContentCategoryUid = _cursor.getLong(_cursorIndexOfContentCategoryUid);
            _item.setContentCategoryUid(_tmpContentCategoryUid);
            final String _tmpCategoryName;
            if (_cursor.isNull(_cursorIndexOfCategoryName)) {
              _tmpCategoryName = null;
            } else {
              _tmpCategoryName = _cursor.getString(_cursorIndexOfCategoryName);
            }
            _item.setCategoryName(_tmpCategoryName);
            final long _tmpContentCategorySchemaUid;
            _tmpContentCategorySchemaUid = _cursor.getLong(_cursorIndexOfContentCategorySchemaUid);
            _item.setContentCategorySchemaUid(_tmpContentCategorySchemaUid);
            final String _tmpSchemaName;
            if (_cursor.isNull(_cursorIndexOfSchemaName)) {
              _tmpSchemaName = null;
            } else {
              _tmpSchemaName = _cursor.getString(_cursorIndexOfSchemaName);
            }
            _item.setSchemaName(_tmpSchemaName);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findUniqueLanguagesInListAsync(final long parentUid,
      final Continuation<? super List<Language>> continuation) {
    final String _sql = "SELECT DISTINCT Language.* from Language LEFT JOIN ContentEntry ON ContentEntry.primaryLanguageUid = Language.langUid LEFT JOIN ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ? ORDER BY Language.name";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Language>>() {
      @Override
      public List<Language> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
          final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
          final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
          final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
          final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
          final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
          final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
          final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
          final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
          final List<Language> _result = new ArrayList<Language>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Language _item;
            _item = new Language();
            final long _tmpLangUid;
            _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
            _item.setLangUid(_tmpLangUid);
            final String _tmpName;
            if (_cursor.isNull(_cursorIndexOfName)) {
              _tmpName = null;
            } else {
              _tmpName = _cursor.getString(_cursorIndexOfName);
            }
            _item.setName(_tmpName);
            final String _tmpIso_639_1_standard;
            if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
              _tmpIso_639_1_standard = null;
            } else {
              _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
            }
            _item.setIso_639_1_standard(_tmpIso_639_1_standard);
            final String _tmpIso_639_2_standard;
            if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
              _tmpIso_639_2_standard = null;
            } else {
              _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
            }
            _item.setIso_639_2_standard(_tmpIso_639_2_standard);
            final String _tmpIso_639_3_standard;
            if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
              _tmpIso_639_3_standard = null;
            } else {
              _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
            }
            _item.setIso_639_3_standard(_tmpIso_639_3_standard);
            final String _tmpLanguage_Type;
            if (_cursor.isNull(_cursorIndexOfLanguageType)) {
              _tmpLanguage_Type = null;
            } else {
              _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
            }
            _item.setLanguage_Type(_tmpLanguage_Type);
            final boolean _tmpLanguageActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
            _tmpLanguageActive = _tmp != 0;
            _item.setLanguageActive(_tmpLanguageActive);
            final long _tmpLangLocalChangeSeqNum;
            _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
            _item.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
            final long _tmpLangMasterChangeSeqNum;
            _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
            _item.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
            final int _tmpLangLastChangedBy;
            _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
            _item.setLangLastChangedBy(_tmpLangLastChangedBy);
            final long _tmpLangLct;
            _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
            _item.setLangLct(_tmpLangLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findUniqueLanguageWithParentUid(final long parentUid,
      final Continuation<? super List<LangUidAndName>> continuation) {
    final String _sql = "SELECT DISTINCT Language.langUid, Language.name AS langName from Language\n"
            + "        LEFT JOIN ContentEntry ON ContentEntry.primaryLanguageUid = Language.langUid\n"
            + "        LEFT JOIN ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid \n"
            + "        WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ? ORDER BY Language.name";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<LangUidAndName>>() {
      @Override
      public List<LangUidAndName> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfLangUid = 0;
          final int _cursorIndexOfLangName = 1;
          final List<LangUidAndName> _result = new ArrayList<LangUidAndName>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final LangUidAndName _item;
            _item = new LangUidAndName();
            final long _tmpLangUid;
            _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
            _item.setLangUid(_tmpLangUid);
            final String _tmpLangName;
            if (_cursor.isNull(_cursorIndexOfLangName)) {
              _tmpLangName = null;
            } else {
              _tmpLangName = _cursor.getString(_cursorIndexOfLangName);
            }
            _item.setLangName(_tmpLangName);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidAsync(final long entryUid,
      final Continuation<? super ContentEntry> continuation) {
    final String _sql = "SELECT * FROM ContentEntry WHERE contentEntryUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntry>() {
      @Override
      public ContentEntry call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final ContentEntry _result;
          if(_cursor.moveToFirst()) {
            _result = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidWithLanguageAsync(final long uid,
      final Continuation<? super ContentEntryWithLanguage> continuation) {
    final String _sql = "\n"
            + "        SELECT ContentEntry.*, Language.*\n"
            + "          FROM ContentEntry\n"
            + "               LEFT JOIN Language \n"
            + "                      ON Language.langUid = ContentEntry.primaryLanguageUid \n"
            + "         WHERE ContentEntry.contentEntryUid = ?              \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryWithLanguage>() {
      @Override
      public ContentEntryWithLanguage call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
          final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
          final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
          final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
          final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
          final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
          final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
          final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
          final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
          final ContentEntryWithLanguage _result;
          if(_cursor.moveToFirst()) {
            final Language _tmpLanguage;
            if (! (_cursor.isNull(_cursorIndexOfLangUid) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfIso6391Standard) && _cursor.isNull(_cursorIndexOfIso6392Standard) && _cursor.isNull(_cursorIndexOfIso6393Standard) && _cursor.isNull(_cursorIndexOfLanguageType) && _cursor.isNull(_cursorIndexOfLanguageActive) && _cursor.isNull(_cursorIndexOfLangLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangLastChangedBy) && _cursor.isNull(_cursorIndexOfLangLct))) {
              _tmpLanguage = new Language();
              final long _tmpLangUid;
              _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
              _tmpLanguage.setLangUid(_tmpLangUid);
              final String _tmpName;
              if (_cursor.isNull(_cursorIndexOfName)) {
                _tmpName = null;
              } else {
                _tmpName = _cursor.getString(_cursorIndexOfName);
              }
              _tmpLanguage.setName(_tmpName);
              final String _tmpIso_639_1_standard;
              if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
                _tmpIso_639_1_standard = null;
              } else {
                _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
              }
              _tmpLanguage.setIso_639_1_standard(_tmpIso_639_1_standard);
              final String _tmpIso_639_2_standard;
              if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
                _tmpIso_639_2_standard = null;
              } else {
                _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
              }
              _tmpLanguage.setIso_639_2_standard(_tmpIso_639_2_standard);
              final String _tmpIso_639_3_standard;
              if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
                _tmpIso_639_3_standard = null;
              } else {
                _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
              }
              _tmpLanguage.setIso_639_3_standard(_tmpIso_639_3_standard);
              final String _tmpLanguage_Type;
              if (_cursor.isNull(_cursorIndexOfLanguageType)) {
                _tmpLanguage_Type = null;
              } else {
                _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
              }
              _tmpLanguage.setLanguage_Type(_tmpLanguage_Type);
              final boolean _tmpLanguageActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
              _tmpLanguageActive = _tmp != 0;
              _tmpLanguage.setLanguageActive(_tmpLanguageActive);
              final long _tmpLangLocalChangeSeqNum;
              _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
              _tmpLanguage.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
              final long _tmpLangMasterChangeSeqNum;
              _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
              _tmpLanguage.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
              final int _tmpLangLastChangedBy;
              _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
              _tmpLanguage.setLangLastChangedBy(_tmpLangLastChangedBy);
              final long _tmpLangLct;
              _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
              _tmpLanguage.setLangLct(_tmpLangLct);
            }  else  {
              _tmpLanguage = null;
            }
            _result = new ContentEntryWithLanguage();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp_1 != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_2 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_3 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
            _result.setLanguage(_tmpLanguage);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public ContentEntry findByUid(final long entryUid) {
    final String _sql = "SELECT * FROM ContentEntry WHERE contentEntryUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entryUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
      final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
      final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
      final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
      final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
      final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
      final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
      final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
      final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
      final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
      final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
      final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
      final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
      final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
      final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
      final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
      final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
      final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
      final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
      final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
      final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
      final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
      final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
      final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
      final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
      final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
      final ContentEntry _result;
      if(_cursor.moveToFirst()) {
        _result = new ContentEntry();
        final long _tmpContentEntryUid;
        _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
        _result.setContentEntryUid(_tmpContentEntryUid);
        final String _tmpTitle;
        if (_cursor.isNull(_cursorIndexOfTitle)) {
          _tmpTitle = null;
        } else {
          _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
        }
        _result.setTitle(_tmpTitle);
        final String _tmpDescription;
        if (_cursor.isNull(_cursorIndexOfDescription)) {
          _tmpDescription = null;
        } else {
          _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
        }
        _result.setDescription(_tmpDescription);
        final String _tmpEntryId;
        if (_cursor.isNull(_cursorIndexOfEntryId)) {
          _tmpEntryId = null;
        } else {
          _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
        }
        _result.setEntryId(_tmpEntryId);
        final String _tmpAuthor;
        if (_cursor.isNull(_cursorIndexOfAuthor)) {
          _tmpAuthor = null;
        } else {
          _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
        }
        _result.setAuthor(_tmpAuthor);
        final String _tmpPublisher;
        if (_cursor.isNull(_cursorIndexOfPublisher)) {
          _tmpPublisher = null;
        } else {
          _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
        }
        _result.setPublisher(_tmpPublisher);
        final int _tmpLicenseType;
        _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
        _result.setLicenseType(_tmpLicenseType);
        final String _tmpLicenseName;
        if (_cursor.isNull(_cursorIndexOfLicenseName)) {
          _tmpLicenseName = null;
        } else {
          _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
        }
        _result.setLicenseName(_tmpLicenseName);
        final String _tmpLicenseUrl;
        if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
          _tmpLicenseUrl = null;
        } else {
          _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
        }
        _result.setLicenseUrl(_tmpLicenseUrl);
        final String _tmpSourceUrl;
        if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
          _tmpSourceUrl = null;
        } else {
          _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
        }
        _result.setSourceUrl(_tmpSourceUrl);
        final String _tmpThumbnailUrl;
        if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
          _tmpThumbnailUrl = null;
        } else {
          _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
        }
        _result.setThumbnailUrl(_tmpThumbnailUrl);
        final long _tmpLastModified;
        _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
        _result.setLastModified(_tmpLastModified);
        final long _tmpPrimaryLanguageUid;
        _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
        _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
        final long _tmpLanguageVariantUid;
        _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
        _result.setLanguageVariantUid(_tmpLanguageVariantUid);
        final int _tmpContentFlags;
        _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
        _result.setContentFlags(_tmpContentFlags);
        final boolean _tmpLeaf;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfLeaf);
        _tmpLeaf = _tmp != 0;
        _result.setLeaf(_tmpLeaf);
        final boolean _tmpPublik;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
        _tmpPublik = _tmp_1 != 0;
        _result.setPublik(_tmpPublik);
        final boolean _tmpCeInactive;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
        _tmpCeInactive = _tmp_2 != 0;
        _result.setCeInactive(_tmpCeInactive);
        final int _tmpCompletionCriteria;
        _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
        _result.setCompletionCriteria(_tmpCompletionCriteria);
        final int _tmpMinScore;
        _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
        _result.setMinScore(_tmpMinScore);
        final int _tmpContentTypeFlag;
        _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
        _result.setContentTypeFlag(_tmpContentTypeFlag);
        final long _tmpContentOwner;
        _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
        _result.setContentOwner(_tmpContentOwner);
        final long _tmpContentEntryLocalChangeSeqNum;
        _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
        _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
        final long _tmpContentEntryMasterChangeSeqNum;
        _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
        _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
        final int _tmpContentEntryLastChangedBy;
        _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
        _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
        final long _tmpContentEntryLct;
        _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
        _result.setContentEntryLct(_tmpContentEntryLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public LiveData<ContentEntry> findByTitle(final String title) {
    final String _sql = "SELECT * FROM ContentEntry WHERE title = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (title == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, title);
    }
    return __db.getInvalidationTracker().createLiveData(new String[]{"ContentEntry"}, false, new Callable<ContentEntry>() {
      @Override
      public ContentEntry call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final ContentEntry _result;
          if(_cursor.moveToFirst()) {
            _result = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object isMeteredAllowedForEntry(final long contentEntryUid,
      final Continuation<? super Boolean> continuation) {
    final String _sql = "\n"
            + "       SELECT COALESCE((SELECT CAST(cjIsMeteredAllowed AS INTEGER) \n"
            + "                FROM ContentJobItem \n"
            + "                JOIN ContentJob\n"
            + "                    ON ContentJobItem.cjiJobUid = ContentJob.cjUid\n"
            + "               WHERE cjiContentEntryUid = ?\n"
            + "                AND cjiRecursiveStatus >= 4\n"
            + "                AND cjiRecursiveStatus <= 20 LIMIT 1),\n"
            + "                CAST(((SELECT connectivityState\n"
            + "                        FROM ConnectivityStatus\n"
            + "                       LIMIT 1) = 3) AS INTEGER),\n"
            + "                0) AS Status\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findBySourceUrlWithContentEntryStatusAsync(final String sourceUrl,
      final Continuation<? super ContentEntry> continuation) {
    final String _sql = "SELECT ContentEntry.* FROM ContentEntry WHERE ContentEntry.sourceUrl = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (sourceUrl == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, sourceUrl);
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntry>() {
      @Override
      public ContentEntry call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final ContentEntry _result;
          if(_cursor.moveToFirst()) {
            _result = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> getChildrenByParentUidWithCategoryFilterOrderByName(
      final long parentUid, final long langParam, final long categoryParam0, final long personUid,
      final boolean showHidden, final boolean onlyFolder, final int sortOrder) {
    final String _sql = "\n"
            + "            SELECT ContentEntry.*, ContentEntryParentChildJoin.*, Container.*, \n"
            + "                COALESCE(StatementEntity.resultScoreMax,0) AS resultMax, \n"
            + "                COALESCE(StatementEntity.resultScoreRaw,0) AS resultScore, \n"
            + "                COALESCE(StatementEntity.resultScoreScaled,0) AS resultScaled, \n"
            + "                COALESCE(StatementEntity.extensionProgress,0) AS progress, \n"
            + "                COALESCE(StatementEntity.resultCompletion,'FALSE') AS contentComplete,\n"
            + "                COALESCE(StatementEntity.resultSuccess, 0) AS success,\n"
            + "                COALESCE((CASE WHEN StatementEntity.resultCompletion \n"
            + "                THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n"
            + "                0 AS assignmentContentWeight,\n"
            + "                \n"
            + "                1 as totalContent, \n"
            + "                \n"
            + "                0 as penalty\n"
            + "            FROM ContentEntry \n"
            + "                    LEFT JOIN ContentEntryParentChildJoin \n"
            + "                    ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                    \n"
            + "                    LEFT JOIN StatementEntity\n"
            + "\t\t\t\t\t\t\tON StatementEntity.statementUid = \n"
            + "                                (SELECT statementUid \n"
            + "\t\t\t\t\t\t\t       FROM StatementEntity \n"
            + "                                  WHERE statementContentEntryUid = ContentEntry.contentEntryUid \n"
            + "\t\t\t\t\t\t\t        AND StatementEntity.statementPersonUid = ?\n"
            + "\t\t\t\t\t\t\t        AND contentEntryRoot \n"
            + "                               ORDER BY resultScoreScaled DESC, extensionProgress DESC, resultSuccess DESC LIMIT 1)\n"
            + "                    \n"
            + "                    LEFT JOIN Container \n"
            + "                    ON Container.containerUid = \n"
            + "                        (SELECT containerUid \n"
            + "                           FROM Container \n"
            + "                          WHERE containerContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                       ORDER BY cntLastModified DESC LIMIT 1)\n"
            + "            WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ? \n"
            + "            AND (? = 0 OR ContentEntry.primaryLanguageUid = ?) \n"
            + "            AND (NOT ContentEntry.ceInactive OR ContentEntry.ceInactive = ?) \n"
            + "            AND (NOT ContentEntry.leaf OR NOT ContentEntry.leaf = ?) \n"
            + "            AND (ContentEntry.publik \n"
            + "                 OR (SELECT username\n"
            + "                        FROM Person\n"
            + "                       WHERE personUid = ?) IS NOT NULL) \n"
            + "            AND \n"
            + "            (? = 0 OR ? \n"
            + "                IN (SELECT ceccjContentCategoryUid \n"
            + "                      FROM ContentEntryContentCategoryJoin \n"
            + "                     WHERE ceccjContentEntryUid = ContentEntry.contentEntryUid)) \n"
            + "            ORDER BY ContentEntryParentChildJoin.childIndex,\n"
            + "                     CASE(?)\n"
            + "                     WHEN 1 THEN ContentEntry.title\n"
            + "                     ELSE ''\n"
            + "                     END ASC,\n"
            + "                     CASE(?)\n"
            + "                     WHEN 2 THEN ContentEntry.title\n"
            + "                     ELSE ''\n"
            + "                     END DESC,             \n"
            + "                     ContentEntry.contentEntryUid";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 11);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, parentUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, langParam);
    _argIndex = 4;
    _statement.bindLong(_argIndex, langParam);
    _argIndex = 5;
    final int _tmp = showHidden ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 6;
    final int _tmp_1 = onlyFolder ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp_1);
    _argIndex = 7;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, categoryParam0);
    _argIndex = 9;
    _statement.bindLong(_argIndex, categoryParam0);
    _argIndex = 10;
    _statement.bindLong(_argIndex, sortOrder);
    _argIndex = 11;
    _statement.bindLong(_argIndex, sortOrder);
    return new DataSource.Factory<Integer, ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>() {
      @Override
      public LimitOffsetDataSource<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> create(
          ) {
        return new LimitOffsetDataSource<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>(__db, _statement, false, true , "ContentEntry", "ContentEntryParentChildJoin", "StatementEntity", "Container", "Person", "ContentEntryContentCategoryJoin") {
          @Override
          protected List<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> convertRows(
              Cursor cursor) {
            final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryUid");
            final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(cursor, "title");
            final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(cursor, "description");
            final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(cursor, "entryId");
            final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(cursor, "author");
            final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(cursor, "publisher");
            final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(cursor, "licenseType");
            final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(cursor, "licenseName");
            final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(cursor, "licenseUrl");
            final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(cursor, "sourceUrl");
            final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(cursor, "thumbnailUrl");
            final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "lastModified");
            final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(cursor, "primaryLanguageUid");
            final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(cursor, "languageVariantUid");
            final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(cursor, "contentFlags");
            final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(cursor, "leaf");
            final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(cursor, "publik");
            final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(cursor, "ceInactive");
            final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(cursor, "completionCriteria");
            final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(cursor, "minScore");
            final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(cursor, "contentTypeFlag");
            final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwner");
            final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLocalChangeSeqNum");
            final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryMasterChangeSeqNum");
            final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLastChangedBy");
            final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLct");
            final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjParentContentEntryUid");
            final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjChildContentEntryUid");
            final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(cursor, "childIndex");
            final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjUid");
            final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLocalChangeSeqNum");
            final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjMasterChangeSeqNum");
            final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLastChangedBy");
            final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLct");
            final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(cursor, "containerUid");
            final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(cursor, "cntLocalCsn");
            final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(cursor, "cntMasterCsn");
            final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(cursor, "cntLastModBy");
            final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(cursor, "cntLct");
            final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(cursor, "fileSize");
            final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "containerContentEntryUid");
            final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "cntLastModified");
            final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(cursor, "mimeType");
            final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(cursor, "remarks");
            final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(cursor, "mobileOptimized");
            final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(cursor, "cntNumEntries");
            final int _cursorIndexOfResultMax = CursorUtil.getColumnIndexOrThrow(cursor, "resultMax");
            final int _cursorIndexOfResultScore = CursorUtil.getColumnIndexOrThrow(cursor, "resultScore");
            final int _cursorIndexOfResultScaled = CursorUtil.getColumnIndexOrThrow(cursor, "resultScaled");
            final int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow(cursor, "progress");
            final int _cursorIndexOfContentComplete = CursorUtil.getColumnIndexOrThrow(cursor, "contentComplete");
            final int _cursorIndexOfSuccess = CursorUtil.getColumnIndexOrThrow(cursor, "success");
            final int _cursorIndexOfTotalCompletedContent = CursorUtil.getColumnIndexOrThrow(cursor, "totalCompletedContent");
            final int _cursorIndexOfAssignmentContentWeight = CursorUtil.getColumnIndexOrThrow(cursor, "assignmentContentWeight");
            final int _cursorIndexOfTotalContent = CursorUtil.getColumnIndexOrThrow(cursor, "totalContent");
            final int _cursorIndexOfPenalty = CursorUtil.getColumnIndexOrThrow(cursor, "penalty");
            final List<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> _res = new ArrayList<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>(cursor.getCount());
            while(cursor.moveToNext()) {
              final ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer _item;
              final ContentEntryParentChildJoin _tmpContentEntryParentChildJoin;
              if (! (cursor.isNull(_cursorIndexOfCepcjParentContentEntryUid) && cursor.isNull(_cursorIndexOfCepcjChildContentEntryUid) && cursor.isNull(_cursorIndexOfChildIndex) && cursor.isNull(_cursorIndexOfCepcjUid) && cursor.isNull(_cursorIndexOfCepcjLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjLastChangedBy) && cursor.isNull(_cursorIndexOfCepcjLct))) {
                final long _tmpCepcjParentContentEntryUid;
                _tmpCepcjParentContentEntryUid = cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                final long _tmpCepcjChildContentEntryUid;
                _tmpCepcjChildContentEntryUid = cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                final int _tmpChildIndex;
                _tmpChildIndex = cursor.getInt(_cursorIndexOfChildIndex);
                _tmpContentEntryParentChildJoin = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
                final long _tmpCepcjUid;
                _tmpCepcjUid = cursor.getLong(_cursorIndexOfCepcjUid);
                _tmpContentEntryParentChildJoin.setCepcjUid(_tmpCepcjUid);
                final long _tmpCepcjLocalChangeSeqNum;
                _tmpCepcjLocalChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                _tmpContentEntryParentChildJoin.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                final long _tmpCepcjMasterChangeSeqNum;
                _tmpCepcjMasterChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                _tmpContentEntryParentChildJoin.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                final int _tmpCepcjLastChangedBy;
                _tmpCepcjLastChangedBy = cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                _tmpContentEntryParentChildJoin.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                final long _tmpCepcjLct;
                _tmpCepcjLct = cursor.getLong(_cursorIndexOfCepcjLct);
                _tmpContentEntryParentChildJoin.setCepcjLct(_tmpCepcjLct);
              }  else  {
                _tmpContentEntryParentChildJoin = null;
              }
              final Container _tmpMostRecentContainer;
              if (! (cursor.isNull(_cursorIndexOfContainerUid) && cursor.isNull(_cursorIndexOfCntLocalCsn) && cursor.isNull(_cursorIndexOfCntMasterCsn) && cursor.isNull(_cursorIndexOfCntLastModBy) && cursor.isNull(_cursorIndexOfCntLct) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfContainerContentEntryUid) && cursor.isNull(_cursorIndexOfCntLastModified) && cursor.isNull(_cursorIndexOfMimeType) && cursor.isNull(_cursorIndexOfRemarks) && cursor.isNull(_cursorIndexOfMobileOptimized) && cursor.isNull(_cursorIndexOfCntNumEntries))) {
                _tmpMostRecentContainer = new Container();
                final long _tmpContainerUid;
                _tmpContainerUid = cursor.getLong(_cursorIndexOfContainerUid);
                _tmpMostRecentContainer.setContainerUid(_tmpContainerUid);
                final long _tmpCntLocalCsn;
                _tmpCntLocalCsn = cursor.getLong(_cursorIndexOfCntLocalCsn);
                _tmpMostRecentContainer.setCntLocalCsn(_tmpCntLocalCsn);
                final long _tmpCntMasterCsn;
                _tmpCntMasterCsn = cursor.getLong(_cursorIndexOfCntMasterCsn);
                _tmpMostRecentContainer.setCntMasterCsn(_tmpCntMasterCsn);
                final int _tmpCntLastModBy;
                _tmpCntLastModBy = cursor.getInt(_cursorIndexOfCntLastModBy);
                _tmpMostRecentContainer.setCntLastModBy(_tmpCntLastModBy);
                final long _tmpCntLct;
                _tmpCntLct = cursor.getLong(_cursorIndexOfCntLct);
                _tmpMostRecentContainer.setCntLct(_tmpCntLct);
                final long _tmpFileSize;
                _tmpFileSize = cursor.getLong(_cursorIndexOfFileSize);
                _tmpMostRecentContainer.setFileSize(_tmpFileSize);
                final long _tmpContainerContentEntryUid;
                _tmpContainerContentEntryUid = cursor.getLong(_cursorIndexOfContainerContentEntryUid);
                _tmpMostRecentContainer.setContainerContentEntryUid(_tmpContainerContentEntryUid);
                final long _tmpCntLastModified;
                _tmpCntLastModified = cursor.getLong(_cursorIndexOfCntLastModified);
                _tmpMostRecentContainer.setCntLastModified(_tmpCntLastModified);
                final String _tmpMimeType;
                if (cursor.isNull(_cursorIndexOfMimeType)) {
                  _tmpMimeType = null;
                } else {
                  _tmpMimeType = cursor.getString(_cursorIndexOfMimeType);
                }
                _tmpMostRecentContainer.setMimeType(_tmpMimeType);
                final String _tmpRemarks;
                if (cursor.isNull(_cursorIndexOfRemarks)) {
                  _tmpRemarks = null;
                } else {
                  _tmpRemarks = cursor.getString(_cursorIndexOfRemarks);
                }
                _tmpMostRecentContainer.setRemarks(_tmpRemarks);
                final boolean _tmpMobileOptimized;
                final int _tmp_2;
                _tmp_2 = cursor.getInt(_cursorIndexOfMobileOptimized);
                _tmpMobileOptimized = _tmp_2 != 0;
                _tmpMostRecentContainer.setMobileOptimized(_tmpMobileOptimized);
                final int _tmpCntNumEntries;
                _tmpCntNumEntries = cursor.getInt(_cursorIndexOfCntNumEntries);
                _tmpMostRecentContainer.setCntNumEntries(_tmpCntNumEntries);
              }  else  {
                _tmpMostRecentContainer = null;
              }
              final ContentEntryStatementScoreProgress _tmpScoreProgress;
              if (! (cursor.isNull(_cursorIndexOfResultMax) && cursor.isNull(_cursorIndexOfResultScore) && cursor.isNull(_cursorIndexOfResultScaled) && cursor.isNull(_cursorIndexOfProgress) && cursor.isNull(_cursorIndexOfContentComplete) && cursor.isNull(_cursorIndexOfSuccess) && cursor.isNull(_cursorIndexOfTotalCompletedContent) && cursor.isNull(_cursorIndexOfTotalContent) && cursor.isNull(_cursorIndexOfPenalty))) {
                _tmpScoreProgress = new ContentEntryStatementScoreProgress();
                final int _tmpResultMax;
                _tmpResultMax = cursor.getInt(_cursorIndexOfResultMax);
                _tmpScoreProgress.setResultMax(_tmpResultMax);
                final int _tmpResultScore;
                _tmpResultScore = cursor.getInt(_cursorIndexOfResultScore);
                _tmpScoreProgress.setResultScore(_tmpResultScore);
                final float _tmpResultScaled;
                _tmpResultScaled = cursor.getFloat(_cursorIndexOfResultScaled);
                _tmpScoreProgress.setResultScaled(_tmpResultScaled);
                final int _tmpProgress;
                _tmpProgress = cursor.getInt(_cursorIndexOfProgress);
                _tmpScoreProgress.setProgress(_tmpProgress);
                final boolean _tmpContentComplete;
                final int _tmp_3;
                _tmp_3 = cursor.getInt(_cursorIndexOfContentComplete);
                _tmpContentComplete = _tmp_3 != 0;
                _tmpScoreProgress.setContentComplete(_tmpContentComplete);
                final byte _tmpSuccess;
                _tmpSuccess = (byte) cursor.getShort(_cursorIndexOfSuccess);
                _tmpScoreProgress.setSuccess(_tmpSuccess);
                final int _tmpTotalCompletedContent;
                _tmpTotalCompletedContent = cursor.getInt(_cursorIndexOfTotalCompletedContent);
                _tmpScoreProgress.setTotalCompletedContent(_tmpTotalCompletedContent);
                final int _tmpTotalContent;
                _tmpTotalContent = cursor.getInt(_cursorIndexOfTotalContent);
                _tmpScoreProgress.setTotalContent(_tmpTotalContent);
                final int _tmpPenalty;
                _tmpPenalty = cursor.getInt(_cursorIndexOfPenalty);
                _tmpScoreProgress.setPenalty(_tmpPenalty);
              }  else  {
                _tmpScoreProgress = null;
              }
              _item = new ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer();
              final long _tmpContentEntryUid;
              _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
              _item.setContentEntryUid(_tmpContentEntryUid);
              final String _tmpTitle;
              if (cursor.isNull(_cursorIndexOfTitle)) {
                _tmpTitle = null;
              } else {
                _tmpTitle = cursor.getString(_cursorIndexOfTitle);
              }
              _item.setTitle(_tmpTitle);
              final String _tmpDescription;
              if (cursor.isNull(_cursorIndexOfDescription)) {
                _tmpDescription = null;
              } else {
                _tmpDescription = cursor.getString(_cursorIndexOfDescription);
              }
              _item.setDescription(_tmpDescription);
              final String _tmpEntryId;
              if (cursor.isNull(_cursorIndexOfEntryId)) {
                _tmpEntryId = null;
              } else {
                _tmpEntryId = cursor.getString(_cursorIndexOfEntryId);
              }
              _item.setEntryId(_tmpEntryId);
              final String _tmpAuthor;
              if (cursor.isNull(_cursorIndexOfAuthor)) {
                _tmpAuthor = null;
              } else {
                _tmpAuthor = cursor.getString(_cursorIndexOfAuthor);
              }
              _item.setAuthor(_tmpAuthor);
              final String _tmpPublisher;
              if (cursor.isNull(_cursorIndexOfPublisher)) {
                _tmpPublisher = null;
              } else {
                _tmpPublisher = cursor.getString(_cursorIndexOfPublisher);
              }
              _item.setPublisher(_tmpPublisher);
              final int _tmpLicenseType;
              _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
              _item.setLicenseType(_tmpLicenseType);
              final String _tmpLicenseName;
              if (cursor.isNull(_cursorIndexOfLicenseName)) {
                _tmpLicenseName = null;
              } else {
                _tmpLicenseName = cursor.getString(_cursorIndexOfLicenseName);
              }
              _item.setLicenseName(_tmpLicenseName);
              final String _tmpLicenseUrl;
              if (cursor.isNull(_cursorIndexOfLicenseUrl)) {
                _tmpLicenseUrl = null;
              } else {
                _tmpLicenseUrl = cursor.getString(_cursorIndexOfLicenseUrl);
              }
              _item.setLicenseUrl(_tmpLicenseUrl);
              final String _tmpSourceUrl;
              if (cursor.isNull(_cursorIndexOfSourceUrl)) {
                _tmpSourceUrl = null;
              } else {
                _tmpSourceUrl = cursor.getString(_cursorIndexOfSourceUrl);
              }
              _item.setSourceUrl(_tmpSourceUrl);
              final String _tmpThumbnailUrl;
              if (cursor.isNull(_cursorIndexOfThumbnailUrl)) {
                _tmpThumbnailUrl = null;
              } else {
                _tmpThumbnailUrl = cursor.getString(_cursorIndexOfThumbnailUrl);
              }
              _item.setThumbnailUrl(_tmpThumbnailUrl);
              final long _tmpLastModified;
              _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
              _item.setLastModified(_tmpLastModified);
              final long _tmpPrimaryLanguageUid;
              _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
              _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
              final long _tmpLanguageVariantUid;
              _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
              _item.setLanguageVariantUid(_tmpLanguageVariantUid);
              final int _tmpContentFlags;
              _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
              _item.setContentFlags(_tmpContentFlags);
              final boolean _tmpLeaf;
              final int _tmp_4;
              _tmp_4 = cursor.getInt(_cursorIndexOfLeaf);
              _tmpLeaf = _tmp_4 != 0;
              _item.setLeaf(_tmpLeaf);
              final boolean _tmpPublik;
              final int _tmp_5;
              _tmp_5 = cursor.getInt(_cursorIndexOfPublik);
              _tmpPublik = _tmp_5 != 0;
              _item.setPublik(_tmpPublik);
              final boolean _tmpCeInactive;
              final int _tmp_6;
              _tmp_6 = cursor.getInt(_cursorIndexOfCeInactive);
              _tmpCeInactive = _tmp_6 != 0;
              _item.setCeInactive(_tmpCeInactive);
              final int _tmpCompletionCriteria;
              _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
              _item.setCompletionCriteria(_tmpCompletionCriteria);
              final int _tmpMinScore;
              _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
              _item.setMinScore(_tmpMinScore);
              final int _tmpContentTypeFlag;
              _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
              _item.setContentTypeFlag(_tmpContentTypeFlag);
              final long _tmpContentOwner;
              _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
              _item.setContentOwner(_tmpContentOwner);
              final long _tmpContentEntryLocalChangeSeqNum;
              _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
              _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
              final long _tmpContentEntryMasterChangeSeqNum;
              _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
              _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
              final int _tmpContentEntryLastChangedBy;
              _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
              _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
              final long _tmpContentEntryLct;
              _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
              _item.setContentEntryLct(_tmpContentEntryLct);
              final int _tmpAssignmentContentWeight;
              _tmpAssignmentContentWeight = cursor.getInt(_cursorIndexOfAssignmentContentWeight);
              _item.setAssignmentContentWeight(_tmpAssignmentContentWeight);
              _item.setContentEntryParentChildJoin(_tmpContentEntryParentChildJoin);
              _item.setMostRecentContainer(_tmpMostRecentContainer);
              _item.setScoreProgress(_tmpScoreProgress);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public DataSource.Factory<Integer, ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> getContentFromMyCourses(
      final long personUid) {
    final String _sql = "\n"
            + "        SELECT ContentEntry.*, ContentEntryParentChildJoin.*, Container.*, \n"
            + "                COALESCE(StatementEntity.resultScoreMax,0) AS resultMax, \n"
            + "                COALESCE(StatementEntity.resultScoreRaw,0) AS resultScore, \n"
            + "                COALESCE(StatementEntity.resultScoreScaled,0) AS resultScaled, \n"
            + "                COALESCE(StatementEntity.extensionProgress,0) AS progress, \n"
            + "                COALESCE(StatementEntity.resultCompletion,'FALSE') AS contentComplete,\n"
            + "                COALESCE(StatementEntity.resultSuccess, 0) AS success,\n"
            + "                COALESCE((CASE WHEN StatementEntity.resultCompletion \n"
            + "                THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n"
            + "                0 AS assignmentContentWeight,\n"
            + "                \n"
            + "                1 as totalContent, \n"
            + "                \n"
            + "                0 as penalty\n"
            + "          FROM CourseBlock\n"
            + "               JOIN ContentEntry \n"
            + "                    ON CourseBlock.cbType = 104\n"
            + "                       AND ContentEntry.contentEntryUid = CourseBlock.cbEntityUid\n"
            + "                       AND CAST(CourseBlock.cbActive AS INTEGER) = 1\n"
            + "               LEFT JOIN ContentEntryParentChildJoin \n"
            + "                    ON ContentEntryParentChildJoin.cepcjUid = 0 \n"
            + "               LEFT JOIN StatementEntity\n"
            + "\t\t\t\t\t\t\tON StatementEntity.statementUid = \n"
            + "                                (SELECT statementUid \n"
            + "\t\t\t\t\t\t\t       FROM StatementEntity \n"
            + "                                  WHERE statementContentEntryUid = ContentEntry.contentEntryUid \n"
            + "\t\t\t\t\t\t\t        AND StatementEntity.statementPersonUid = ?\n"
            + "\t\t\t\t\t\t\t        AND contentEntryRoot \n"
            + "                               ORDER BY resultScoreScaled DESC, extensionProgress DESC, resultSuccess DESC LIMIT 1)     \n"
            + "               LEFT JOIN Container \n"
            + "                    ON Container.containerUid = \n"
            + "                        (SELECT containerUid \n"
            + "                           FROM Container \n"
            + "                          WHERE containerContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                       ORDER BY cntLastModified DESC LIMIT 1)  \n"
            + "                               \n"
            + "         WHERE CourseBlock.cbClazzUid IN\n"
            + "               (SELECT ClazzEnrolment.clazzEnrolmentClazzUid\n"
            + "                  FROM ClazzEnrolment\n"
            + "                 WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, personUid);
    return new DataSource.Factory<Integer, ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>() {
      @Override
      public LimitOffsetDataSource<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> create(
          ) {
        return new LimitOffsetDataSource<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>(__db, _statement, false, true , "CourseBlock", "ContentEntry", "ContentEntryParentChildJoin", "StatementEntity", "Container", "ClazzEnrolment") {
          @Override
          protected List<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> convertRows(
              Cursor cursor) {
            final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryUid");
            final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(cursor, "title");
            final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(cursor, "description");
            final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(cursor, "entryId");
            final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(cursor, "author");
            final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(cursor, "publisher");
            final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(cursor, "licenseType");
            final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(cursor, "licenseName");
            final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(cursor, "licenseUrl");
            final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(cursor, "sourceUrl");
            final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(cursor, "thumbnailUrl");
            final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "lastModified");
            final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(cursor, "primaryLanguageUid");
            final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(cursor, "languageVariantUid");
            final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(cursor, "contentFlags");
            final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(cursor, "leaf");
            final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(cursor, "publik");
            final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(cursor, "ceInactive");
            final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(cursor, "completionCriteria");
            final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(cursor, "minScore");
            final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(cursor, "contentTypeFlag");
            final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwner");
            final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLocalChangeSeqNum");
            final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryMasterChangeSeqNum");
            final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLastChangedBy");
            final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLct");
            final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjParentContentEntryUid");
            final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjChildContentEntryUid");
            final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(cursor, "childIndex");
            final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjUid");
            final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLocalChangeSeqNum");
            final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjMasterChangeSeqNum");
            final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLastChangedBy");
            final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLct");
            final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(cursor, "containerUid");
            final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(cursor, "cntLocalCsn");
            final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(cursor, "cntMasterCsn");
            final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(cursor, "cntLastModBy");
            final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(cursor, "cntLct");
            final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(cursor, "fileSize");
            final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "containerContentEntryUid");
            final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "cntLastModified");
            final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(cursor, "mimeType");
            final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(cursor, "remarks");
            final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(cursor, "mobileOptimized");
            final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(cursor, "cntNumEntries");
            final int _cursorIndexOfResultMax = CursorUtil.getColumnIndexOrThrow(cursor, "resultMax");
            final int _cursorIndexOfResultScore = CursorUtil.getColumnIndexOrThrow(cursor, "resultScore");
            final int _cursorIndexOfResultScaled = CursorUtil.getColumnIndexOrThrow(cursor, "resultScaled");
            final int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow(cursor, "progress");
            final int _cursorIndexOfContentComplete = CursorUtil.getColumnIndexOrThrow(cursor, "contentComplete");
            final int _cursorIndexOfSuccess = CursorUtil.getColumnIndexOrThrow(cursor, "success");
            final int _cursorIndexOfTotalCompletedContent = CursorUtil.getColumnIndexOrThrow(cursor, "totalCompletedContent");
            final int _cursorIndexOfAssignmentContentWeight = CursorUtil.getColumnIndexOrThrow(cursor, "assignmentContentWeight");
            final int _cursorIndexOfTotalContent = CursorUtil.getColumnIndexOrThrow(cursor, "totalContent");
            final int _cursorIndexOfPenalty = CursorUtil.getColumnIndexOrThrow(cursor, "penalty");
            final List<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> _res = new ArrayList<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>(cursor.getCount());
            while(cursor.moveToNext()) {
              final ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer _item;
              final ContentEntryParentChildJoin _tmpContentEntryParentChildJoin;
              if (! (cursor.isNull(_cursorIndexOfCepcjParentContentEntryUid) && cursor.isNull(_cursorIndexOfCepcjChildContentEntryUid) && cursor.isNull(_cursorIndexOfChildIndex) && cursor.isNull(_cursorIndexOfCepcjUid) && cursor.isNull(_cursorIndexOfCepcjLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjLastChangedBy) && cursor.isNull(_cursorIndexOfCepcjLct))) {
                final long _tmpCepcjParentContentEntryUid;
                _tmpCepcjParentContentEntryUid = cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                final long _tmpCepcjChildContentEntryUid;
                _tmpCepcjChildContentEntryUid = cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                final int _tmpChildIndex;
                _tmpChildIndex = cursor.getInt(_cursorIndexOfChildIndex);
                _tmpContentEntryParentChildJoin = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
                final long _tmpCepcjUid;
                _tmpCepcjUid = cursor.getLong(_cursorIndexOfCepcjUid);
                _tmpContentEntryParentChildJoin.setCepcjUid(_tmpCepcjUid);
                final long _tmpCepcjLocalChangeSeqNum;
                _tmpCepcjLocalChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                _tmpContentEntryParentChildJoin.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                final long _tmpCepcjMasterChangeSeqNum;
                _tmpCepcjMasterChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                _tmpContentEntryParentChildJoin.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                final int _tmpCepcjLastChangedBy;
                _tmpCepcjLastChangedBy = cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                _tmpContentEntryParentChildJoin.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                final long _tmpCepcjLct;
                _tmpCepcjLct = cursor.getLong(_cursorIndexOfCepcjLct);
                _tmpContentEntryParentChildJoin.setCepcjLct(_tmpCepcjLct);
              }  else  {
                _tmpContentEntryParentChildJoin = null;
              }
              final Container _tmpMostRecentContainer;
              if (! (cursor.isNull(_cursorIndexOfContainerUid) && cursor.isNull(_cursorIndexOfCntLocalCsn) && cursor.isNull(_cursorIndexOfCntMasterCsn) && cursor.isNull(_cursorIndexOfCntLastModBy) && cursor.isNull(_cursorIndexOfCntLct) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfContainerContentEntryUid) && cursor.isNull(_cursorIndexOfCntLastModified) && cursor.isNull(_cursorIndexOfMimeType) && cursor.isNull(_cursorIndexOfRemarks) && cursor.isNull(_cursorIndexOfMobileOptimized) && cursor.isNull(_cursorIndexOfCntNumEntries))) {
                _tmpMostRecentContainer = new Container();
                final long _tmpContainerUid;
                _tmpContainerUid = cursor.getLong(_cursorIndexOfContainerUid);
                _tmpMostRecentContainer.setContainerUid(_tmpContainerUid);
                final long _tmpCntLocalCsn;
                _tmpCntLocalCsn = cursor.getLong(_cursorIndexOfCntLocalCsn);
                _tmpMostRecentContainer.setCntLocalCsn(_tmpCntLocalCsn);
                final long _tmpCntMasterCsn;
                _tmpCntMasterCsn = cursor.getLong(_cursorIndexOfCntMasterCsn);
                _tmpMostRecentContainer.setCntMasterCsn(_tmpCntMasterCsn);
                final int _tmpCntLastModBy;
                _tmpCntLastModBy = cursor.getInt(_cursorIndexOfCntLastModBy);
                _tmpMostRecentContainer.setCntLastModBy(_tmpCntLastModBy);
                final long _tmpCntLct;
                _tmpCntLct = cursor.getLong(_cursorIndexOfCntLct);
                _tmpMostRecentContainer.setCntLct(_tmpCntLct);
                final long _tmpFileSize;
                _tmpFileSize = cursor.getLong(_cursorIndexOfFileSize);
                _tmpMostRecentContainer.setFileSize(_tmpFileSize);
                final long _tmpContainerContentEntryUid;
                _tmpContainerContentEntryUid = cursor.getLong(_cursorIndexOfContainerContentEntryUid);
                _tmpMostRecentContainer.setContainerContentEntryUid(_tmpContainerContentEntryUid);
                final long _tmpCntLastModified;
                _tmpCntLastModified = cursor.getLong(_cursorIndexOfCntLastModified);
                _tmpMostRecentContainer.setCntLastModified(_tmpCntLastModified);
                final String _tmpMimeType;
                if (cursor.isNull(_cursorIndexOfMimeType)) {
                  _tmpMimeType = null;
                } else {
                  _tmpMimeType = cursor.getString(_cursorIndexOfMimeType);
                }
                _tmpMostRecentContainer.setMimeType(_tmpMimeType);
                final String _tmpRemarks;
                if (cursor.isNull(_cursorIndexOfRemarks)) {
                  _tmpRemarks = null;
                } else {
                  _tmpRemarks = cursor.getString(_cursorIndexOfRemarks);
                }
                _tmpMostRecentContainer.setRemarks(_tmpRemarks);
                final boolean _tmpMobileOptimized;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfMobileOptimized);
                _tmpMobileOptimized = _tmp != 0;
                _tmpMostRecentContainer.setMobileOptimized(_tmpMobileOptimized);
                final int _tmpCntNumEntries;
                _tmpCntNumEntries = cursor.getInt(_cursorIndexOfCntNumEntries);
                _tmpMostRecentContainer.setCntNumEntries(_tmpCntNumEntries);
              }  else  {
                _tmpMostRecentContainer = null;
              }
              final ContentEntryStatementScoreProgress _tmpScoreProgress;
              if (! (cursor.isNull(_cursorIndexOfResultMax) && cursor.isNull(_cursorIndexOfResultScore) && cursor.isNull(_cursorIndexOfResultScaled) && cursor.isNull(_cursorIndexOfProgress) && cursor.isNull(_cursorIndexOfContentComplete) && cursor.isNull(_cursorIndexOfSuccess) && cursor.isNull(_cursorIndexOfTotalCompletedContent) && cursor.isNull(_cursorIndexOfTotalContent) && cursor.isNull(_cursorIndexOfPenalty))) {
                _tmpScoreProgress = new ContentEntryStatementScoreProgress();
                final int _tmpResultMax;
                _tmpResultMax = cursor.getInt(_cursorIndexOfResultMax);
                _tmpScoreProgress.setResultMax(_tmpResultMax);
                final int _tmpResultScore;
                _tmpResultScore = cursor.getInt(_cursorIndexOfResultScore);
                _tmpScoreProgress.setResultScore(_tmpResultScore);
                final float _tmpResultScaled;
                _tmpResultScaled = cursor.getFloat(_cursorIndexOfResultScaled);
                _tmpScoreProgress.setResultScaled(_tmpResultScaled);
                final int _tmpProgress;
                _tmpProgress = cursor.getInt(_cursorIndexOfProgress);
                _tmpScoreProgress.setProgress(_tmpProgress);
                final boolean _tmpContentComplete;
                final int _tmp_1;
                _tmp_1 = cursor.getInt(_cursorIndexOfContentComplete);
                _tmpContentComplete = _tmp_1 != 0;
                _tmpScoreProgress.setContentComplete(_tmpContentComplete);
                final byte _tmpSuccess;
                _tmpSuccess = (byte) cursor.getShort(_cursorIndexOfSuccess);
                _tmpScoreProgress.setSuccess(_tmpSuccess);
                final int _tmpTotalCompletedContent;
                _tmpTotalCompletedContent = cursor.getInt(_cursorIndexOfTotalCompletedContent);
                _tmpScoreProgress.setTotalCompletedContent(_tmpTotalCompletedContent);
                final int _tmpTotalContent;
                _tmpTotalContent = cursor.getInt(_cursorIndexOfTotalContent);
                _tmpScoreProgress.setTotalContent(_tmpTotalContent);
                final int _tmpPenalty;
                _tmpPenalty = cursor.getInt(_cursorIndexOfPenalty);
                _tmpScoreProgress.setPenalty(_tmpPenalty);
              }  else  {
                _tmpScoreProgress = null;
              }
              _item = new ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer();
              final long _tmpContentEntryUid;
              _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
              _item.setContentEntryUid(_tmpContentEntryUid);
              final String _tmpTitle;
              if (cursor.isNull(_cursorIndexOfTitle)) {
                _tmpTitle = null;
              } else {
                _tmpTitle = cursor.getString(_cursorIndexOfTitle);
              }
              _item.setTitle(_tmpTitle);
              final String _tmpDescription;
              if (cursor.isNull(_cursorIndexOfDescription)) {
                _tmpDescription = null;
              } else {
                _tmpDescription = cursor.getString(_cursorIndexOfDescription);
              }
              _item.setDescription(_tmpDescription);
              final String _tmpEntryId;
              if (cursor.isNull(_cursorIndexOfEntryId)) {
                _tmpEntryId = null;
              } else {
                _tmpEntryId = cursor.getString(_cursorIndexOfEntryId);
              }
              _item.setEntryId(_tmpEntryId);
              final String _tmpAuthor;
              if (cursor.isNull(_cursorIndexOfAuthor)) {
                _tmpAuthor = null;
              } else {
                _tmpAuthor = cursor.getString(_cursorIndexOfAuthor);
              }
              _item.setAuthor(_tmpAuthor);
              final String _tmpPublisher;
              if (cursor.isNull(_cursorIndexOfPublisher)) {
                _tmpPublisher = null;
              } else {
                _tmpPublisher = cursor.getString(_cursorIndexOfPublisher);
              }
              _item.setPublisher(_tmpPublisher);
              final int _tmpLicenseType;
              _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
              _item.setLicenseType(_tmpLicenseType);
              final String _tmpLicenseName;
              if (cursor.isNull(_cursorIndexOfLicenseName)) {
                _tmpLicenseName = null;
              } else {
                _tmpLicenseName = cursor.getString(_cursorIndexOfLicenseName);
              }
              _item.setLicenseName(_tmpLicenseName);
              final String _tmpLicenseUrl;
              if (cursor.isNull(_cursorIndexOfLicenseUrl)) {
                _tmpLicenseUrl = null;
              } else {
                _tmpLicenseUrl = cursor.getString(_cursorIndexOfLicenseUrl);
              }
              _item.setLicenseUrl(_tmpLicenseUrl);
              final String _tmpSourceUrl;
              if (cursor.isNull(_cursorIndexOfSourceUrl)) {
                _tmpSourceUrl = null;
              } else {
                _tmpSourceUrl = cursor.getString(_cursorIndexOfSourceUrl);
              }
              _item.setSourceUrl(_tmpSourceUrl);
              final String _tmpThumbnailUrl;
              if (cursor.isNull(_cursorIndexOfThumbnailUrl)) {
                _tmpThumbnailUrl = null;
              } else {
                _tmpThumbnailUrl = cursor.getString(_cursorIndexOfThumbnailUrl);
              }
              _item.setThumbnailUrl(_tmpThumbnailUrl);
              final long _tmpLastModified;
              _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
              _item.setLastModified(_tmpLastModified);
              final long _tmpPrimaryLanguageUid;
              _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
              _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
              final long _tmpLanguageVariantUid;
              _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
              _item.setLanguageVariantUid(_tmpLanguageVariantUid);
              final int _tmpContentFlags;
              _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
              _item.setContentFlags(_tmpContentFlags);
              final boolean _tmpLeaf;
              final int _tmp_2;
              _tmp_2 = cursor.getInt(_cursorIndexOfLeaf);
              _tmpLeaf = _tmp_2 != 0;
              _item.setLeaf(_tmpLeaf);
              final boolean _tmpPublik;
              final int _tmp_3;
              _tmp_3 = cursor.getInt(_cursorIndexOfPublik);
              _tmpPublik = _tmp_3 != 0;
              _item.setPublik(_tmpPublik);
              final boolean _tmpCeInactive;
              final int _tmp_4;
              _tmp_4 = cursor.getInt(_cursorIndexOfCeInactive);
              _tmpCeInactive = _tmp_4 != 0;
              _item.setCeInactive(_tmpCeInactive);
              final int _tmpCompletionCriteria;
              _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
              _item.setCompletionCriteria(_tmpCompletionCriteria);
              final int _tmpMinScore;
              _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
              _item.setMinScore(_tmpMinScore);
              final int _tmpContentTypeFlag;
              _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
              _item.setContentTypeFlag(_tmpContentTypeFlag);
              final long _tmpContentOwner;
              _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
              _item.setContentOwner(_tmpContentOwner);
              final long _tmpContentEntryLocalChangeSeqNum;
              _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
              _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
              final long _tmpContentEntryMasterChangeSeqNum;
              _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
              _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
              final int _tmpContentEntryLastChangedBy;
              _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
              _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
              final long _tmpContentEntryLct;
              _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
              _item.setContentEntryLct(_tmpContentEntryLct);
              final int _tmpAssignmentContentWeight;
              _tmpAssignmentContentWeight = cursor.getInt(_cursorIndexOfAssignmentContentWeight);
              _item.setAssignmentContentWeight(_tmpAssignmentContentWeight);
              _item.setContentEntryParentChildJoin(_tmpContentEntryParentChildJoin);
              _item.setMostRecentContainer(_tmpMostRecentContainer);
              _item.setScoreProgress(_tmpScoreProgress);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public DataSource.Factory<Integer, ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> getContentByOwner(
      final long personUid) {
    final String _sql = "\n"
            + "        SELECT ContentEntry.*, ContentEntryParentChildJoin.*, Container.*, \n"
            + "                COALESCE(StatementEntity.resultScoreMax,0) AS resultMax, \n"
            + "                COALESCE(StatementEntity.resultScoreRaw,0) AS resultScore, \n"
            + "                COALESCE(StatementEntity.resultScoreScaled,0) AS resultScaled, \n"
            + "                COALESCE(StatementEntity.extensionProgress,0) AS progress, \n"
            + "                COALESCE(StatementEntity.resultCompletion,'FALSE') AS contentComplete,\n"
            + "                COALESCE(StatementEntity.resultSuccess, 0) AS success,\n"
            + "                COALESCE((CASE WHEN StatementEntity.resultCompletion \n"
            + "                THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n"
            + "                0 AS assignmentContentWeight,\n"
            + "                \n"
            + "                1 as totalContent, \n"
            + "                \n"
            + "                0 as penalty\n"
            + "          FROM ContentEntry\n"
            + "               LEFT JOIN ContentEntryParentChildJoin \n"
            + "                    ON ContentEntryParentChildJoin.cepcjUid = 0 \n"
            + "               LEFT JOIN StatementEntity\n"
            + "\t\t\t\t\t\t\tON StatementEntity.statementUid = \n"
            + "                                (SELECT statementUid \n"
            + "\t\t\t\t\t\t\t       FROM StatementEntity \n"
            + "                                  WHERE statementContentEntryUid = ContentEntry.contentEntryUid \n"
            + "\t\t\t\t\t\t\t        AND StatementEntity.statementPersonUid = ?\n"
            + "\t\t\t\t\t\t\t        AND contentEntryRoot \n"
            + "                               ORDER BY resultScoreScaled DESC, extensionProgress DESC, resultSuccess DESC LIMIT 1)     \n"
            + "               LEFT JOIN Container \n"
            + "                    ON Container.containerUid = \n"
            + "                        (SELECT containerUid \n"
            + "                           FROM Container \n"
            + "                          WHERE containerContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                       ORDER BY cntLastModified DESC LIMIT 1)  \n"
            + "         WHERE ContentEntry.contentOwner = ?\n"
            + "           AND NOT EXISTS(\n"
            + "               SELECT ContentEntryParentChildJoin.cepcjUid \n"
            + "                 FROM ContentEntryParentChildJoin\n"
            + "                WHERE ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, personUid);
    return new DataSource.Factory<Integer, ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>() {
      @Override
      public LimitOffsetDataSource<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> create(
          ) {
        return new LimitOffsetDataSource<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>(__db, _statement, false, true , "ContentEntry", "ContentEntryParentChildJoin", "StatementEntity", "Container") {
          @Override
          protected List<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> convertRows(
              Cursor cursor) {
            final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryUid");
            final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(cursor, "title");
            final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(cursor, "description");
            final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(cursor, "entryId");
            final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(cursor, "author");
            final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(cursor, "publisher");
            final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(cursor, "licenseType");
            final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(cursor, "licenseName");
            final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(cursor, "licenseUrl");
            final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(cursor, "sourceUrl");
            final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(cursor, "thumbnailUrl");
            final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "lastModified");
            final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(cursor, "primaryLanguageUid");
            final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(cursor, "languageVariantUid");
            final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(cursor, "contentFlags");
            final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(cursor, "leaf");
            final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(cursor, "publik");
            final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(cursor, "ceInactive");
            final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(cursor, "completionCriteria");
            final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(cursor, "minScore");
            final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(cursor, "contentTypeFlag");
            final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwner");
            final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLocalChangeSeqNum");
            final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryMasterChangeSeqNum");
            final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLastChangedBy");
            final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLct");
            final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjParentContentEntryUid");
            final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjChildContentEntryUid");
            final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(cursor, "childIndex");
            final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjUid");
            final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLocalChangeSeqNum");
            final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjMasterChangeSeqNum");
            final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLastChangedBy");
            final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLct");
            final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(cursor, "containerUid");
            final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(cursor, "cntLocalCsn");
            final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(cursor, "cntMasterCsn");
            final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(cursor, "cntLastModBy");
            final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(cursor, "cntLct");
            final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(cursor, "fileSize");
            final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "containerContentEntryUid");
            final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "cntLastModified");
            final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(cursor, "mimeType");
            final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(cursor, "remarks");
            final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(cursor, "mobileOptimized");
            final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(cursor, "cntNumEntries");
            final int _cursorIndexOfResultMax = CursorUtil.getColumnIndexOrThrow(cursor, "resultMax");
            final int _cursorIndexOfResultScore = CursorUtil.getColumnIndexOrThrow(cursor, "resultScore");
            final int _cursorIndexOfResultScaled = CursorUtil.getColumnIndexOrThrow(cursor, "resultScaled");
            final int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow(cursor, "progress");
            final int _cursorIndexOfContentComplete = CursorUtil.getColumnIndexOrThrow(cursor, "contentComplete");
            final int _cursorIndexOfSuccess = CursorUtil.getColumnIndexOrThrow(cursor, "success");
            final int _cursorIndexOfTotalCompletedContent = CursorUtil.getColumnIndexOrThrow(cursor, "totalCompletedContent");
            final int _cursorIndexOfAssignmentContentWeight = CursorUtil.getColumnIndexOrThrow(cursor, "assignmentContentWeight");
            final int _cursorIndexOfTotalContent = CursorUtil.getColumnIndexOrThrow(cursor, "totalContent");
            final int _cursorIndexOfPenalty = CursorUtil.getColumnIndexOrThrow(cursor, "penalty");
            final List<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> _res = new ArrayList<ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>(cursor.getCount());
            while(cursor.moveToNext()) {
              final ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer _item;
              final ContentEntryParentChildJoin _tmpContentEntryParentChildJoin;
              if (! (cursor.isNull(_cursorIndexOfCepcjParentContentEntryUid) && cursor.isNull(_cursorIndexOfCepcjChildContentEntryUid) && cursor.isNull(_cursorIndexOfChildIndex) && cursor.isNull(_cursorIndexOfCepcjUid) && cursor.isNull(_cursorIndexOfCepcjLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjLastChangedBy) && cursor.isNull(_cursorIndexOfCepcjLct))) {
                final long _tmpCepcjParentContentEntryUid;
                _tmpCepcjParentContentEntryUid = cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                final long _tmpCepcjChildContentEntryUid;
                _tmpCepcjChildContentEntryUid = cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                final int _tmpChildIndex;
                _tmpChildIndex = cursor.getInt(_cursorIndexOfChildIndex);
                _tmpContentEntryParentChildJoin = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
                final long _tmpCepcjUid;
                _tmpCepcjUid = cursor.getLong(_cursorIndexOfCepcjUid);
                _tmpContentEntryParentChildJoin.setCepcjUid(_tmpCepcjUid);
                final long _tmpCepcjLocalChangeSeqNum;
                _tmpCepcjLocalChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                _tmpContentEntryParentChildJoin.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                final long _tmpCepcjMasterChangeSeqNum;
                _tmpCepcjMasterChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                _tmpContentEntryParentChildJoin.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                final int _tmpCepcjLastChangedBy;
                _tmpCepcjLastChangedBy = cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                _tmpContentEntryParentChildJoin.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                final long _tmpCepcjLct;
                _tmpCepcjLct = cursor.getLong(_cursorIndexOfCepcjLct);
                _tmpContentEntryParentChildJoin.setCepcjLct(_tmpCepcjLct);
              }  else  {
                _tmpContentEntryParentChildJoin = null;
              }
              final Container _tmpMostRecentContainer;
              if (! (cursor.isNull(_cursorIndexOfContainerUid) && cursor.isNull(_cursorIndexOfCntLocalCsn) && cursor.isNull(_cursorIndexOfCntMasterCsn) && cursor.isNull(_cursorIndexOfCntLastModBy) && cursor.isNull(_cursorIndexOfCntLct) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfContainerContentEntryUid) && cursor.isNull(_cursorIndexOfCntLastModified) && cursor.isNull(_cursorIndexOfMimeType) && cursor.isNull(_cursorIndexOfRemarks) && cursor.isNull(_cursorIndexOfMobileOptimized) && cursor.isNull(_cursorIndexOfCntNumEntries))) {
                _tmpMostRecentContainer = new Container();
                final long _tmpContainerUid;
                _tmpContainerUid = cursor.getLong(_cursorIndexOfContainerUid);
                _tmpMostRecentContainer.setContainerUid(_tmpContainerUid);
                final long _tmpCntLocalCsn;
                _tmpCntLocalCsn = cursor.getLong(_cursorIndexOfCntLocalCsn);
                _tmpMostRecentContainer.setCntLocalCsn(_tmpCntLocalCsn);
                final long _tmpCntMasterCsn;
                _tmpCntMasterCsn = cursor.getLong(_cursorIndexOfCntMasterCsn);
                _tmpMostRecentContainer.setCntMasterCsn(_tmpCntMasterCsn);
                final int _tmpCntLastModBy;
                _tmpCntLastModBy = cursor.getInt(_cursorIndexOfCntLastModBy);
                _tmpMostRecentContainer.setCntLastModBy(_tmpCntLastModBy);
                final long _tmpCntLct;
                _tmpCntLct = cursor.getLong(_cursorIndexOfCntLct);
                _tmpMostRecentContainer.setCntLct(_tmpCntLct);
                final long _tmpFileSize;
                _tmpFileSize = cursor.getLong(_cursorIndexOfFileSize);
                _tmpMostRecentContainer.setFileSize(_tmpFileSize);
                final long _tmpContainerContentEntryUid;
                _tmpContainerContentEntryUid = cursor.getLong(_cursorIndexOfContainerContentEntryUid);
                _tmpMostRecentContainer.setContainerContentEntryUid(_tmpContainerContentEntryUid);
                final long _tmpCntLastModified;
                _tmpCntLastModified = cursor.getLong(_cursorIndexOfCntLastModified);
                _tmpMostRecentContainer.setCntLastModified(_tmpCntLastModified);
                final String _tmpMimeType;
                if (cursor.isNull(_cursorIndexOfMimeType)) {
                  _tmpMimeType = null;
                } else {
                  _tmpMimeType = cursor.getString(_cursorIndexOfMimeType);
                }
                _tmpMostRecentContainer.setMimeType(_tmpMimeType);
                final String _tmpRemarks;
                if (cursor.isNull(_cursorIndexOfRemarks)) {
                  _tmpRemarks = null;
                } else {
                  _tmpRemarks = cursor.getString(_cursorIndexOfRemarks);
                }
                _tmpMostRecentContainer.setRemarks(_tmpRemarks);
                final boolean _tmpMobileOptimized;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfMobileOptimized);
                _tmpMobileOptimized = _tmp != 0;
                _tmpMostRecentContainer.setMobileOptimized(_tmpMobileOptimized);
                final int _tmpCntNumEntries;
                _tmpCntNumEntries = cursor.getInt(_cursorIndexOfCntNumEntries);
                _tmpMostRecentContainer.setCntNumEntries(_tmpCntNumEntries);
              }  else  {
                _tmpMostRecentContainer = null;
              }
              final ContentEntryStatementScoreProgress _tmpScoreProgress;
              if (! (cursor.isNull(_cursorIndexOfResultMax) && cursor.isNull(_cursorIndexOfResultScore) && cursor.isNull(_cursorIndexOfResultScaled) && cursor.isNull(_cursorIndexOfProgress) && cursor.isNull(_cursorIndexOfContentComplete) && cursor.isNull(_cursorIndexOfSuccess) && cursor.isNull(_cursorIndexOfTotalCompletedContent) && cursor.isNull(_cursorIndexOfTotalContent) && cursor.isNull(_cursorIndexOfPenalty))) {
                _tmpScoreProgress = new ContentEntryStatementScoreProgress();
                final int _tmpResultMax;
                _tmpResultMax = cursor.getInt(_cursorIndexOfResultMax);
                _tmpScoreProgress.setResultMax(_tmpResultMax);
                final int _tmpResultScore;
                _tmpResultScore = cursor.getInt(_cursorIndexOfResultScore);
                _tmpScoreProgress.setResultScore(_tmpResultScore);
                final float _tmpResultScaled;
                _tmpResultScaled = cursor.getFloat(_cursorIndexOfResultScaled);
                _tmpScoreProgress.setResultScaled(_tmpResultScaled);
                final int _tmpProgress;
                _tmpProgress = cursor.getInt(_cursorIndexOfProgress);
                _tmpScoreProgress.setProgress(_tmpProgress);
                final boolean _tmpContentComplete;
                final int _tmp_1;
                _tmp_1 = cursor.getInt(_cursorIndexOfContentComplete);
                _tmpContentComplete = _tmp_1 != 0;
                _tmpScoreProgress.setContentComplete(_tmpContentComplete);
                final byte _tmpSuccess;
                _tmpSuccess = (byte) cursor.getShort(_cursorIndexOfSuccess);
                _tmpScoreProgress.setSuccess(_tmpSuccess);
                final int _tmpTotalCompletedContent;
                _tmpTotalCompletedContent = cursor.getInt(_cursorIndexOfTotalCompletedContent);
                _tmpScoreProgress.setTotalCompletedContent(_tmpTotalCompletedContent);
                final int _tmpTotalContent;
                _tmpTotalContent = cursor.getInt(_cursorIndexOfTotalContent);
                _tmpScoreProgress.setTotalContent(_tmpTotalContent);
                final int _tmpPenalty;
                _tmpPenalty = cursor.getInt(_cursorIndexOfPenalty);
                _tmpScoreProgress.setPenalty(_tmpPenalty);
              }  else  {
                _tmpScoreProgress = null;
              }
              _item = new ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer();
              final long _tmpContentEntryUid;
              _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
              _item.setContentEntryUid(_tmpContentEntryUid);
              final String _tmpTitle;
              if (cursor.isNull(_cursorIndexOfTitle)) {
                _tmpTitle = null;
              } else {
                _tmpTitle = cursor.getString(_cursorIndexOfTitle);
              }
              _item.setTitle(_tmpTitle);
              final String _tmpDescription;
              if (cursor.isNull(_cursorIndexOfDescription)) {
                _tmpDescription = null;
              } else {
                _tmpDescription = cursor.getString(_cursorIndexOfDescription);
              }
              _item.setDescription(_tmpDescription);
              final String _tmpEntryId;
              if (cursor.isNull(_cursorIndexOfEntryId)) {
                _tmpEntryId = null;
              } else {
                _tmpEntryId = cursor.getString(_cursorIndexOfEntryId);
              }
              _item.setEntryId(_tmpEntryId);
              final String _tmpAuthor;
              if (cursor.isNull(_cursorIndexOfAuthor)) {
                _tmpAuthor = null;
              } else {
                _tmpAuthor = cursor.getString(_cursorIndexOfAuthor);
              }
              _item.setAuthor(_tmpAuthor);
              final String _tmpPublisher;
              if (cursor.isNull(_cursorIndexOfPublisher)) {
                _tmpPublisher = null;
              } else {
                _tmpPublisher = cursor.getString(_cursorIndexOfPublisher);
              }
              _item.setPublisher(_tmpPublisher);
              final int _tmpLicenseType;
              _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
              _item.setLicenseType(_tmpLicenseType);
              final String _tmpLicenseName;
              if (cursor.isNull(_cursorIndexOfLicenseName)) {
                _tmpLicenseName = null;
              } else {
                _tmpLicenseName = cursor.getString(_cursorIndexOfLicenseName);
              }
              _item.setLicenseName(_tmpLicenseName);
              final String _tmpLicenseUrl;
              if (cursor.isNull(_cursorIndexOfLicenseUrl)) {
                _tmpLicenseUrl = null;
              } else {
                _tmpLicenseUrl = cursor.getString(_cursorIndexOfLicenseUrl);
              }
              _item.setLicenseUrl(_tmpLicenseUrl);
              final String _tmpSourceUrl;
              if (cursor.isNull(_cursorIndexOfSourceUrl)) {
                _tmpSourceUrl = null;
              } else {
                _tmpSourceUrl = cursor.getString(_cursorIndexOfSourceUrl);
              }
              _item.setSourceUrl(_tmpSourceUrl);
              final String _tmpThumbnailUrl;
              if (cursor.isNull(_cursorIndexOfThumbnailUrl)) {
                _tmpThumbnailUrl = null;
              } else {
                _tmpThumbnailUrl = cursor.getString(_cursorIndexOfThumbnailUrl);
              }
              _item.setThumbnailUrl(_tmpThumbnailUrl);
              final long _tmpLastModified;
              _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
              _item.setLastModified(_tmpLastModified);
              final long _tmpPrimaryLanguageUid;
              _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
              _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
              final long _tmpLanguageVariantUid;
              _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
              _item.setLanguageVariantUid(_tmpLanguageVariantUid);
              final int _tmpContentFlags;
              _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
              _item.setContentFlags(_tmpContentFlags);
              final boolean _tmpLeaf;
              final int _tmp_2;
              _tmp_2 = cursor.getInt(_cursorIndexOfLeaf);
              _tmpLeaf = _tmp_2 != 0;
              _item.setLeaf(_tmpLeaf);
              final boolean _tmpPublik;
              final int _tmp_3;
              _tmp_3 = cursor.getInt(_cursorIndexOfPublik);
              _tmpPublik = _tmp_3 != 0;
              _item.setPublik(_tmpPublik);
              final boolean _tmpCeInactive;
              final int _tmp_4;
              _tmp_4 = cursor.getInt(_cursorIndexOfCeInactive);
              _tmpCeInactive = _tmp_4 != 0;
              _item.setCeInactive(_tmpCeInactive);
              final int _tmpCompletionCriteria;
              _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
              _item.setCompletionCriteria(_tmpCompletionCriteria);
              final int _tmpMinScore;
              _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
              _item.setMinScore(_tmpMinScore);
              final int _tmpContentTypeFlag;
              _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
              _item.setContentTypeFlag(_tmpContentTypeFlag);
              final long _tmpContentOwner;
              _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
              _item.setContentOwner(_tmpContentOwner);
              final long _tmpContentEntryLocalChangeSeqNum;
              _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
              _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
              final long _tmpContentEntryMasterChangeSeqNum;
              _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
              _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
              final int _tmpContentEntryLastChangedBy;
              _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
              _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
              final long _tmpContentEntryLct;
              _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
              _item.setContentEntryLct(_tmpContentEntryLct);
              final int _tmpAssignmentContentWeight;
              _tmpAssignmentContentWeight = cursor.getInt(_cursorIndexOfAssignmentContentWeight);
              _item.setAssignmentContentWeight(_tmpAssignmentContentWeight);
              _item.setContentEntryParentChildJoin(_tmpContentEntryParentChildJoin);
              _item.setMostRecentContainer(_tmpMostRecentContainer);
              _item.setScoreProgress(_tmpScoreProgress);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public List<ContentEntry> getChildrenByAll(final long parentUid) {
    final String _sql = "SELECT ContentEntry.* FROM ContentEntry LEFT JOIN ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
      final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
      final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
      final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
      final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
      final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
      final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
      final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
      final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
      final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
      final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
      final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
      final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
      final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
      final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
      final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
      final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
      final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
      final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
      final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
      final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
      final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
      final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
      final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
      final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
      final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
      final List<ContentEntry> _result = new ArrayList<ContentEntry>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContentEntry _item;
        _item = new ContentEntry();
        final long _tmpContentEntryUid;
        _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
        _item.setContentEntryUid(_tmpContentEntryUid);
        final String _tmpTitle;
        if (_cursor.isNull(_cursorIndexOfTitle)) {
          _tmpTitle = null;
        } else {
          _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
        }
        _item.setTitle(_tmpTitle);
        final String _tmpDescription;
        if (_cursor.isNull(_cursorIndexOfDescription)) {
          _tmpDescription = null;
        } else {
          _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
        }
        _item.setDescription(_tmpDescription);
        final String _tmpEntryId;
        if (_cursor.isNull(_cursorIndexOfEntryId)) {
          _tmpEntryId = null;
        } else {
          _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
        }
        _item.setEntryId(_tmpEntryId);
        final String _tmpAuthor;
        if (_cursor.isNull(_cursorIndexOfAuthor)) {
          _tmpAuthor = null;
        } else {
          _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
        }
        _item.setAuthor(_tmpAuthor);
        final String _tmpPublisher;
        if (_cursor.isNull(_cursorIndexOfPublisher)) {
          _tmpPublisher = null;
        } else {
          _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
        }
        _item.setPublisher(_tmpPublisher);
        final int _tmpLicenseType;
        _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
        _item.setLicenseType(_tmpLicenseType);
        final String _tmpLicenseName;
        if (_cursor.isNull(_cursorIndexOfLicenseName)) {
          _tmpLicenseName = null;
        } else {
          _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
        }
        _item.setLicenseName(_tmpLicenseName);
        final String _tmpLicenseUrl;
        if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
          _tmpLicenseUrl = null;
        } else {
          _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
        }
        _item.setLicenseUrl(_tmpLicenseUrl);
        final String _tmpSourceUrl;
        if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
          _tmpSourceUrl = null;
        } else {
          _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
        }
        _item.setSourceUrl(_tmpSourceUrl);
        final String _tmpThumbnailUrl;
        if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
          _tmpThumbnailUrl = null;
        } else {
          _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
        }
        _item.setThumbnailUrl(_tmpThumbnailUrl);
        final long _tmpLastModified;
        _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
        _item.setLastModified(_tmpLastModified);
        final long _tmpPrimaryLanguageUid;
        _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
        _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
        final long _tmpLanguageVariantUid;
        _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
        _item.setLanguageVariantUid(_tmpLanguageVariantUid);
        final int _tmpContentFlags;
        _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
        _item.setContentFlags(_tmpContentFlags);
        final boolean _tmpLeaf;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfLeaf);
        _tmpLeaf = _tmp != 0;
        _item.setLeaf(_tmpLeaf);
        final boolean _tmpPublik;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
        _tmpPublik = _tmp_1 != 0;
        _item.setPublik(_tmpPublik);
        final boolean _tmpCeInactive;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
        _tmpCeInactive = _tmp_2 != 0;
        _item.setCeInactive(_tmpCeInactive);
        final int _tmpCompletionCriteria;
        _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
        _item.setCompletionCriteria(_tmpCompletionCriteria);
        final int _tmpMinScore;
        _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
        _item.setMinScore(_tmpMinScore);
        final int _tmpContentTypeFlag;
        _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
        _item.setContentTypeFlag(_tmpContentTypeFlag);
        final long _tmpContentOwner;
        _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
        _item.setContentOwner(_tmpContentOwner);
        final long _tmpContentEntryLocalChangeSeqNum;
        _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
        _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
        final long _tmpContentEntryMasterChangeSeqNum;
        _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
        _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
        final int _tmpContentEntryLastChangedBy;
        _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
        _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
        final long _tmpContentEntryLct;
        _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
        _item.setContentEntryLct(_tmpContentEntryLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public LiveData<ContentEntry> findLiveContentEntry(final long parentUid) {
    final String _sql = "SELECT * FROM ContentEntry where contentEntryUid = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ContentEntry"}, false, new Callable<ContentEntry>() {
      @Override
      public ContentEntry call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final ContentEntry _result;
          if(_cursor.moveToFirst()) {
            _result = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _result.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _result.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _result.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _result.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _result.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _result.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _result.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _result.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _result.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _result.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _result.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _result.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _result.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _result.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _result.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _result.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _result.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _result.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _result.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _result.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _result.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _result.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _result.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _result.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _result.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _result.setContentEntryLct(_tmpContentEntryLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public long getContentEntryUidFromXapiObjectId(final String objectId) {
    final String _sql = "SELECT COALESCE((SELECT contentEntryUid \n"
            + "                                      FROM ContentEntry \n"
            + "                                     WHERE entryId = ? \n"
            + "                                     LIMIT 1),0) AS ID";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (objectId == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, objectId);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final long _result;
      if(_cursor.moveToFirst()) {
        _result = _cursor.getLong(0);
      } else {
        _result = 0L;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<ContentEntry> findSimilarIdEntryForKhan(final String sourceUrl) {
    final String _sql = "SELECT * FROM ContentEntry WHERE sourceUrl LIKE ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (sourceUrl == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, sourceUrl);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
      final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
      final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
      final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
      final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
      final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
      final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
      final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
      final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
      final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
      final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
      final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
      final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
      final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
      final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
      final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
      final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
      final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
      final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
      final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
      final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
      final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
      final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
      final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
      final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
      final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
      final List<ContentEntry> _result = new ArrayList<ContentEntry>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContentEntry _item;
        _item = new ContentEntry();
        final long _tmpContentEntryUid;
        _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
        _item.setContentEntryUid(_tmpContentEntryUid);
        final String _tmpTitle;
        if (_cursor.isNull(_cursorIndexOfTitle)) {
          _tmpTitle = null;
        } else {
          _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
        }
        _item.setTitle(_tmpTitle);
        final String _tmpDescription;
        if (_cursor.isNull(_cursorIndexOfDescription)) {
          _tmpDescription = null;
        } else {
          _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
        }
        _item.setDescription(_tmpDescription);
        final String _tmpEntryId;
        if (_cursor.isNull(_cursorIndexOfEntryId)) {
          _tmpEntryId = null;
        } else {
          _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
        }
        _item.setEntryId(_tmpEntryId);
        final String _tmpAuthor;
        if (_cursor.isNull(_cursorIndexOfAuthor)) {
          _tmpAuthor = null;
        } else {
          _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
        }
        _item.setAuthor(_tmpAuthor);
        final String _tmpPublisher;
        if (_cursor.isNull(_cursorIndexOfPublisher)) {
          _tmpPublisher = null;
        } else {
          _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
        }
        _item.setPublisher(_tmpPublisher);
        final int _tmpLicenseType;
        _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
        _item.setLicenseType(_tmpLicenseType);
        final String _tmpLicenseName;
        if (_cursor.isNull(_cursorIndexOfLicenseName)) {
          _tmpLicenseName = null;
        } else {
          _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
        }
        _item.setLicenseName(_tmpLicenseName);
        final String _tmpLicenseUrl;
        if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
          _tmpLicenseUrl = null;
        } else {
          _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
        }
        _item.setLicenseUrl(_tmpLicenseUrl);
        final String _tmpSourceUrl;
        if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
          _tmpSourceUrl = null;
        } else {
          _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
        }
        _item.setSourceUrl(_tmpSourceUrl);
        final String _tmpThumbnailUrl;
        if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
          _tmpThumbnailUrl = null;
        } else {
          _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
        }
        _item.setThumbnailUrl(_tmpThumbnailUrl);
        final long _tmpLastModified;
        _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
        _item.setLastModified(_tmpLastModified);
        final long _tmpPrimaryLanguageUid;
        _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
        _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
        final long _tmpLanguageVariantUid;
        _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
        _item.setLanguageVariantUid(_tmpLanguageVariantUid);
        final int _tmpContentFlags;
        _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
        _item.setContentFlags(_tmpContentFlags);
        final boolean _tmpLeaf;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfLeaf);
        _tmpLeaf = _tmp != 0;
        _item.setLeaf(_tmpLeaf);
        final boolean _tmpPublik;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
        _tmpPublik = _tmp_1 != 0;
        _item.setPublik(_tmpPublik);
        final boolean _tmpCeInactive;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
        _tmpCeInactive = _tmp_2 != 0;
        _item.setCeInactive(_tmpCeInactive);
        final int _tmpCompletionCriteria;
        _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
        _item.setCompletionCriteria(_tmpCompletionCriteria);
        final int _tmpMinScore;
        _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
        _item.setMinScore(_tmpMinScore);
        final int _tmpContentTypeFlag;
        _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
        _item.setContentTypeFlag(_tmpContentTypeFlag);
        final long _tmpContentOwner;
        _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
        _item.setContentOwner(_tmpContentOwner);
        final long _tmpContentEntryLocalChangeSeqNum;
        _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
        _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
        final long _tmpContentEntryMasterChangeSeqNum;
        _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
        _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
        final int _tmpContentEntryLastChangedBy;
        _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
        _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
        final long _tmpContentEntryLct;
        _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
        _item.setContentEntryLct(_tmpContentEntryLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object getRecursiveDownloadTotals(final long contentEntryUid,
      final Continuation<? super DownloadJobSizeInfo> continuation) {
    final String _sql = "\n"
            + "        WITH RECURSIVE \n"
            + "               ContentEntry_recursive(contentEntryUid, containerSize) AS (\n"
            + "               SELECT contentEntryUid, \n"
            + "                            (SELECT COALESCE((SELECT fileSize \n"
            + "                                           FROM Container \n"
            + "                                          WHERE containerContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                                       ORDER BY cntLastModified DESC LIMIT 1), 0)) AS containerSize \n"
            + "                 FROM ContentEntry \n"
            + "                WHERE contentEntryUid = ?\n"
            + "                  AND NOT ceInactive\n"
            + "        UNION \n"
            + "            SELECT ContentEntry.contentEntryUid, \n"
            + "                (SELECT COALESCE((SELECT fileSize \n"
            + "                                    FROM Container \n"
            + "                                   WHERE containerContentEntryUid = ContentEntry.contentEntryUid \n"
            + "                                ORDER BY cntLastModified DESC LIMIT 1), 0)) AS containerSize  \n"
            + "                  FROM ContentEntry\n"
            + "             LEFT JOIN ContentEntryParentChildJoin \n"
            + "                    ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid,\n"
            + "                            ContentEntry_recursive\n"
            + "                  WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ContentEntry_recursive.contentEntryUid\n"
            + "                    AND NOT ceInactive)\n"
            + "        SELECT COUNT(*) AS numEntries, \n"
            + "               SUM(containerSize) AS totalSize \n"
            + "          FROM ContentEntry_recursive";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<DownloadJobSizeInfo>() {
      @Override
      public DownloadJobSizeInfo call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfNumEntries = 0;
          final int _cursorIndexOfTotalSize = 1;
          final DownloadJobSizeInfo _result;
          if(_cursor.moveToFirst()) {
            final int _tmpNumEntries;
            _tmpNumEntries = _cursor.getInt(_cursorIndexOfNumEntries);
            final long _tmpTotalSize;
            _tmpTotalSize = _cursor.getLong(_cursorIndexOfTotalSize);
            _result = new DownloadJobSizeInfo(_tmpNumEntries,_tmpTotalSize);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, ContentEntryWithParentChildJoinAndMostRecentContainer> getAllEntriesRecursively(
      final long contentEntryUid) {
    final String _sql = "WITH RECURSIVE ContentEntry_recursive(\n"
            + "            contentEntryUid, title, ceInactive, contentFlags, description, entryId, author, publisher, licenseType, licenseName, licenseUrl, sourceUrl, thumbnailUrl, lastModified, primaryLanguageUid, languageVariantUid, leaf, publik,  completionCriteria, minScore, contentOwner, contentTypeFlag, contentEntryLocalChangeSeqNum, contentEntryMasterChangeSeqNum, contentEntryLastChangedBy, contentEntryLct,\n"
            + "            \n"
            + "            cepcjUid, cepcjChildContentEntryUid, cepcjParentContentEntryUid, childIndex, cepcjLocalChangeSeqNum, cepcjMasterChangeSeqNum, cepcjLastChangedBy, cepcjLct,\n"
            + "            \n"
            + "            containerUid, cntLocalCsn, cntMasterCsn, cntLastModBy, fileSize, containerContentEntryUid, cntLastModified, mimeType, remarks, mobileOptimized, cntNumEntries, cntLct\n"
            + "            ) AS (\n"
            + "            SELECT ContentEntry.contentEntryUid, ContentEntry.title, ContentEntry.ceInactive, ContentEntry.contentFlags, ContentEntry.description, ContentEntry.entryId, ContentEntry.author, ContentEntry.publisher, ContentEntry.licenseType, ContentEntry.licenseName, ContentEntry.licenseUrl, ContentEntry.sourceUrl, ContentEntry.thumbnailUrl, ContentEntry.lastModified, ContentEntry.primaryLanguageUid, ContentEntry.languageVariantUid, ContentEntry.leaf, ContentEntry.publik, ContentEntry.completionCriteria, ContentEntry.minScore, ContentEntry.contentOwner, ContentEntry.contentTypeFlag, ContentEntry.contentEntryLocalChangeSeqNum, ContentEntry.contentEntryMasterChangeSeqNum, ContentEntry.contentEntryLastChangedBy, ContentEntry.contentEntryLct,\n"
            + "            ContentEntryParentChildJoin.cepcjUid, ContentEntryParentChildJoin.cepcjChildContentEntryUid, ContentEntryParentChildJoin.cepcjParentContentEntryUid, ContentEntryParentChildJoin.childIndex, ContentEntryParentChildJoin.cepcjLocalChangeSeqNum, ContentEntryParentChildJoin.cepcjMasterChangeSeqNum, ContentEntryParentChildJoin.cepcjLastChangedBy, ContentEntryParentChildJoin.cepcjLct,\n"
            + "            Container.containerUid, Container.cntLocalCsn, Container.cntMasterCsn, Container.cntLastModBy, Container.fileSize, Container.containerContentEntryUid, Container.cntLastModified, Container.mimeType, Container.remarks, Container.mobileOptimized, Container.cntNumEntries, Container.cntLct\n"
            + "            FROM \n"
            + "            ContentEntry\n"
            + "            LEFT JOIN ContentEntryParentChildJoin ON ContentEntry.contentEntryUid = ContentEntryParentChildJoin.cepcjChildContentEntryUid \n"
            + "            LEFT JOIN Container ON Container.containerUid = (SELECT COALESCE((SELECT containerUid FROM Container WHERE containerContentEntryUid = ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1), 0))\n"
            + "            WHERE ContentEntry.contentEntryUid = ?\n"
            + "            UNION\n"
            + "            SELECT ContentEntry.contentEntryUid, ContentEntry.title, ContentEntry.ceInactive, ContentEntry.contentFlags, ContentEntry.description, ContentEntry.entryId, ContentEntry.author, ContentEntry.publisher, ContentEntry.licenseType, ContentEntry.licenseName, ContentEntry.licenseUrl, ContentEntry.sourceUrl, ContentEntry.thumbnailUrl, ContentEntry.lastModified, ContentEntry.primaryLanguageUid, ContentEntry.languageVariantUid, ContentEntry.leaf, ContentEntry.publik, ContentEntry.completionCriteria, ContentEntry.minScore, ContentEntry.contentOwner, ContentEntry.contentTypeFlag, ContentEntry.contentEntryLocalChangeSeqNum, ContentEntry.contentEntryMasterChangeSeqNum, ContentEntry.contentEntryLastChangedBy, ContentEntry.contentEntryLct,\n"
            + "            ContentEntryParentChildJoin.cepcjUid, ContentEntryParentChildJoin.cepcjChildContentEntryUid, ContentEntryParentChildJoin.cepcjParentContentEntryUid, ContentEntryParentChildJoin.childIndex, ContentEntryParentChildJoin.cepcjLocalChangeSeqNum, ContentEntryParentChildJoin.cepcjMasterChangeSeqNum, ContentEntryParentChildJoin.cepcjLastChangedBy, ContentEntryParentChildJoin.cepcjLct, \n"
            + "            Container.containerUid, Container.cntLocalCsn, Container.cntMasterCsn, Container.cntLastModBy, Container.fileSize, Container.containerContentEntryUid, Container.cntLastModified, Container.mimeType, Container.remarks, Container.mobileOptimized, Container.cntNumEntries, Container.cntLct\n"
            + "            FROM \n"
            + "            ContentEntry\n"
            + "            LEFT JOIN ContentEntryParentChildJoin ON ContentEntry.contentEntryUid = ContentEntryParentChildJoin.cepcjChildContentEntryUid \n"
            + "            LEFT JOIN Container ON Container.containerUid = (SELECT COALESCE((SELECT containerUid FROM Container WHERE containerContentEntryUid = ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1), 0)),\n"
            + "            ContentEntry_recursive\n"
            + "            WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ContentEntry_recursive.contentEntryUid)\n"
            + "            SELECT * FROM ContentEntry_recursive";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    return new DataSource.Factory<Integer, ContentEntryWithParentChildJoinAndMostRecentContainer>() {
      @Override
      public LimitOffsetDataSource<ContentEntryWithParentChildJoinAndMostRecentContainer> create() {
        return new LimitOffsetDataSource<ContentEntryWithParentChildJoinAndMostRecentContainer>(__db, _statement, false, true , "ContentEntry", "ContentEntryParentChildJoin", "Container") {
          @Override
          protected List<ContentEntryWithParentChildJoinAndMostRecentContainer> convertRows(
              Cursor cursor) {
            final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryUid");
            final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(cursor, "title");
            final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(cursor, "ceInactive");
            final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(cursor, "contentFlags");
            final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(cursor, "description");
            final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(cursor, "entryId");
            final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(cursor, "author");
            final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(cursor, "publisher");
            final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(cursor, "licenseType");
            final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(cursor, "licenseName");
            final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(cursor, "licenseUrl");
            final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(cursor, "sourceUrl");
            final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(cursor, "thumbnailUrl");
            final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "lastModified");
            final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(cursor, "primaryLanguageUid");
            final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(cursor, "languageVariantUid");
            final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(cursor, "leaf");
            final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(cursor, "publik");
            final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(cursor, "completionCriteria");
            final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(cursor, "minScore");
            final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(cursor, "contentOwner");
            final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(cursor, "contentTypeFlag");
            final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLocalChangeSeqNum");
            final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryMasterChangeSeqNum");
            final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLastChangedBy");
            final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(cursor, "contentEntryLct");
            final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjUid");
            final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjChildContentEntryUid");
            final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjParentContentEntryUid");
            final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(cursor, "childIndex");
            final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLocalChangeSeqNum");
            final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjMasterChangeSeqNum");
            final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLastChangedBy");
            final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(cursor, "cepcjLct");
            final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(cursor, "containerUid");
            final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(cursor, "cntLocalCsn");
            final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(cursor, "cntMasterCsn");
            final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(cursor, "cntLastModBy");
            final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(cursor, "fileSize");
            final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(cursor, "containerContentEntryUid");
            final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(cursor, "cntLastModified");
            final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(cursor, "mimeType");
            final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(cursor, "remarks");
            final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(cursor, "mobileOptimized");
            final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(cursor, "cntNumEntries");
            final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(cursor, "cntLct");
            final List<ContentEntryWithParentChildJoinAndMostRecentContainer> _res = new ArrayList<ContentEntryWithParentChildJoinAndMostRecentContainer>(cursor.getCount());
            while(cursor.moveToNext()) {
              final ContentEntryWithParentChildJoinAndMostRecentContainer _item;
              final ContentEntryParentChildJoin _tmpContentEntryParentChildJoin;
              if (! (cursor.isNull(_cursorIndexOfCepcjUid) && cursor.isNull(_cursorIndexOfCepcjChildContentEntryUid) && cursor.isNull(_cursorIndexOfCepcjParentContentEntryUid) && cursor.isNull(_cursorIndexOfChildIndex) && cursor.isNull(_cursorIndexOfCepcjLocalChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjMasterChangeSeqNum) && cursor.isNull(_cursorIndexOfCepcjLastChangedBy) && cursor.isNull(_cursorIndexOfCepcjLct))) {
                final long _tmpCepcjChildContentEntryUid;
                _tmpCepcjChildContentEntryUid = cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
                final long _tmpCepcjParentContentEntryUid;
                _tmpCepcjParentContentEntryUid = cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
                final int _tmpChildIndex;
                _tmpChildIndex = cursor.getInt(_cursorIndexOfChildIndex);
                _tmpContentEntryParentChildJoin = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
                final long _tmpCepcjUid;
                _tmpCepcjUid = cursor.getLong(_cursorIndexOfCepcjUid);
                _tmpContentEntryParentChildJoin.setCepcjUid(_tmpCepcjUid);
                final long _tmpCepcjLocalChangeSeqNum;
                _tmpCepcjLocalChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
                _tmpContentEntryParentChildJoin.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
                final long _tmpCepcjMasterChangeSeqNum;
                _tmpCepcjMasterChangeSeqNum = cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
                _tmpContentEntryParentChildJoin.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
                final int _tmpCepcjLastChangedBy;
                _tmpCepcjLastChangedBy = cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
                _tmpContentEntryParentChildJoin.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
                final long _tmpCepcjLct;
                _tmpCepcjLct = cursor.getLong(_cursorIndexOfCepcjLct);
                _tmpContentEntryParentChildJoin.setCepcjLct(_tmpCepcjLct);
              }  else  {
                _tmpContentEntryParentChildJoin = null;
              }
              final Container _tmpMostRecentContainer;
              if (! (cursor.isNull(_cursorIndexOfContainerUid) && cursor.isNull(_cursorIndexOfCntLocalCsn) && cursor.isNull(_cursorIndexOfCntMasterCsn) && cursor.isNull(_cursorIndexOfCntLastModBy) && cursor.isNull(_cursorIndexOfFileSize) && cursor.isNull(_cursorIndexOfContainerContentEntryUid) && cursor.isNull(_cursorIndexOfCntLastModified) && cursor.isNull(_cursorIndexOfMimeType) && cursor.isNull(_cursorIndexOfRemarks) && cursor.isNull(_cursorIndexOfMobileOptimized) && cursor.isNull(_cursorIndexOfCntNumEntries) && cursor.isNull(_cursorIndexOfCntLct))) {
                _tmpMostRecentContainer = new Container();
                final long _tmpContainerUid;
                _tmpContainerUid = cursor.getLong(_cursorIndexOfContainerUid);
                _tmpMostRecentContainer.setContainerUid(_tmpContainerUid);
                final long _tmpCntLocalCsn;
                _tmpCntLocalCsn = cursor.getLong(_cursorIndexOfCntLocalCsn);
                _tmpMostRecentContainer.setCntLocalCsn(_tmpCntLocalCsn);
                final long _tmpCntMasterCsn;
                _tmpCntMasterCsn = cursor.getLong(_cursorIndexOfCntMasterCsn);
                _tmpMostRecentContainer.setCntMasterCsn(_tmpCntMasterCsn);
                final int _tmpCntLastModBy;
                _tmpCntLastModBy = cursor.getInt(_cursorIndexOfCntLastModBy);
                _tmpMostRecentContainer.setCntLastModBy(_tmpCntLastModBy);
                final long _tmpFileSize;
                _tmpFileSize = cursor.getLong(_cursorIndexOfFileSize);
                _tmpMostRecentContainer.setFileSize(_tmpFileSize);
                final long _tmpContainerContentEntryUid;
                _tmpContainerContentEntryUid = cursor.getLong(_cursorIndexOfContainerContentEntryUid);
                _tmpMostRecentContainer.setContainerContentEntryUid(_tmpContainerContentEntryUid);
                final long _tmpCntLastModified;
                _tmpCntLastModified = cursor.getLong(_cursorIndexOfCntLastModified);
                _tmpMostRecentContainer.setCntLastModified(_tmpCntLastModified);
                final String _tmpMimeType;
                if (cursor.isNull(_cursorIndexOfMimeType)) {
                  _tmpMimeType = null;
                } else {
                  _tmpMimeType = cursor.getString(_cursorIndexOfMimeType);
                }
                _tmpMostRecentContainer.setMimeType(_tmpMimeType);
                final String _tmpRemarks;
                if (cursor.isNull(_cursorIndexOfRemarks)) {
                  _tmpRemarks = null;
                } else {
                  _tmpRemarks = cursor.getString(_cursorIndexOfRemarks);
                }
                _tmpMostRecentContainer.setRemarks(_tmpRemarks);
                final boolean _tmpMobileOptimized;
                final int _tmp;
                _tmp = cursor.getInt(_cursorIndexOfMobileOptimized);
                _tmpMobileOptimized = _tmp != 0;
                _tmpMostRecentContainer.setMobileOptimized(_tmpMobileOptimized);
                final int _tmpCntNumEntries;
                _tmpCntNumEntries = cursor.getInt(_cursorIndexOfCntNumEntries);
                _tmpMostRecentContainer.setCntNumEntries(_tmpCntNumEntries);
                final long _tmpCntLct;
                _tmpCntLct = cursor.getLong(_cursorIndexOfCntLct);
                _tmpMostRecentContainer.setCntLct(_tmpCntLct);
              }  else  {
                _tmpMostRecentContainer = null;
              }
              _item = new ContentEntryWithParentChildJoinAndMostRecentContainer();
              final long _tmpContentEntryUid;
              _tmpContentEntryUid = cursor.getLong(_cursorIndexOfContentEntryUid);
              _item.setContentEntryUid(_tmpContentEntryUid);
              final String _tmpTitle;
              if (cursor.isNull(_cursorIndexOfTitle)) {
                _tmpTitle = null;
              } else {
                _tmpTitle = cursor.getString(_cursorIndexOfTitle);
              }
              _item.setTitle(_tmpTitle);
              final boolean _tmpCeInactive;
              final int _tmp_1;
              _tmp_1 = cursor.getInt(_cursorIndexOfCeInactive);
              _tmpCeInactive = _tmp_1 != 0;
              _item.setCeInactive(_tmpCeInactive);
              final int _tmpContentFlags;
              _tmpContentFlags = cursor.getInt(_cursorIndexOfContentFlags);
              _item.setContentFlags(_tmpContentFlags);
              final String _tmpDescription;
              if (cursor.isNull(_cursorIndexOfDescription)) {
                _tmpDescription = null;
              } else {
                _tmpDescription = cursor.getString(_cursorIndexOfDescription);
              }
              _item.setDescription(_tmpDescription);
              final String _tmpEntryId;
              if (cursor.isNull(_cursorIndexOfEntryId)) {
                _tmpEntryId = null;
              } else {
                _tmpEntryId = cursor.getString(_cursorIndexOfEntryId);
              }
              _item.setEntryId(_tmpEntryId);
              final String _tmpAuthor;
              if (cursor.isNull(_cursorIndexOfAuthor)) {
                _tmpAuthor = null;
              } else {
                _tmpAuthor = cursor.getString(_cursorIndexOfAuthor);
              }
              _item.setAuthor(_tmpAuthor);
              final String _tmpPublisher;
              if (cursor.isNull(_cursorIndexOfPublisher)) {
                _tmpPublisher = null;
              } else {
                _tmpPublisher = cursor.getString(_cursorIndexOfPublisher);
              }
              _item.setPublisher(_tmpPublisher);
              final int _tmpLicenseType;
              _tmpLicenseType = cursor.getInt(_cursorIndexOfLicenseType);
              _item.setLicenseType(_tmpLicenseType);
              final String _tmpLicenseName;
              if (cursor.isNull(_cursorIndexOfLicenseName)) {
                _tmpLicenseName = null;
              } else {
                _tmpLicenseName = cursor.getString(_cursorIndexOfLicenseName);
              }
              _item.setLicenseName(_tmpLicenseName);
              final String _tmpLicenseUrl;
              if (cursor.isNull(_cursorIndexOfLicenseUrl)) {
                _tmpLicenseUrl = null;
              } else {
                _tmpLicenseUrl = cursor.getString(_cursorIndexOfLicenseUrl);
              }
              _item.setLicenseUrl(_tmpLicenseUrl);
              final String _tmpSourceUrl;
              if (cursor.isNull(_cursorIndexOfSourceUrl)) {
                _tmpSourceUrl = null;
              } else {
                _tmpSourceUrl = cursor.getString(_cursorIndexOfSourceUrl);
              }
              _item.setSourceUrl(_tmpSourceUrl);
              final String _tmpThumbnailUrl;
              if (cursor.isNull(_cursorIndexOfThumbnailUrl)) {
                _tmpThumbnailUrl = null;
              } else {
                _tmpThumbnailUrl = cursor.getString(_cursorIndexOfThumbnailUrl);
              }
              _item.setThumbnailUrl(_tmpThumbnailUrl);
              final long _tmpLastModified;
              _tmpLastModified = cursor.getLong(_cursorIndexOfLastModified);
              _item.setLastModified(_tmpLastModified);
              final long _tmpPrimaryLanguageUid;
              _tmpPrimaryLanguageUid = cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
              _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
              final long _tmpLanguageVariantUid;
              _tmpLanguageVariantUid = cursor.getLong(_cursorIndexOfLanguageVariantUid);
              _item.setLanguageVariantUid(_tmpLanguageVariantUid);
              final boolean _tmpLeaf;
              final int _tmp_2;
              _tmp_2 = cursor.getInt(_cursorIndexOfLeaf);
              _tmpLeaf = _tmp_2 != 0;
              _item.setLeaf(_tmpLeaf);
              final boolean _tmpPublik;
              final int _tmp_3;
              _tmp_3 = cursor.getInt(_cursorIndexOfPublik);
              _tmpPublik = _tmp_3 != 0;
              _item.setPublik(_tmpPublik);
              final int _tmpCompletionCriteria;
              _tmpCompletionCriteria = cursor.getInt(_cursorIndexOfCompletionCriteria);
              _item.setCompletionCriteria(_tmpCompletionCriteria);
              final int _tmpMinScore;
              _tmpMinScore = cursor.getInt(_cursorIndexOfMinScore);
              _item.setMinScore(_tmpMinScore);
              final long _tmpContentOwner;
              _tmpContentOwner = cursor.getLong(_cursorIndexOfContentOwner);
              _item.setContentOwner(_tmpContentOwner);
              final int _tmpContentTypeFlag;
              _tmpContentTypeFlag = cursor.getInt(_cursorIndexOfContentTypeFlag);
              _item.setContentTypeFlag(_tmpContentTypeFlag);
              final long _tmpContentEntryLocalChangeSeqNum;
              _tmpContentEntryLocalChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
              _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
              final long _tmpContentEntryMasterChangeSeqNum;
              _tmpContentEntryMasterChangeSeqNum = cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
              _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
              final int _tmpContentEntryLastChangedBy;
              _tmpContentEntryLastChangedBy = cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
              _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
              final long _tmpContentEntryLct;
              _tmpContentEntryLct = cursor.getLong(_cursorIndexOfContentEntryLct);
              _item.setContentEntryLct(_tmpContentEntryLct);
              _item.setContentEntryParentChildJoin(_tmpContentEntryParentChildJoin);
              _item.setMostRecentContainer(_tmpMostRecentContainer);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public List<ContentEntryWithParentChildJoinAndMostRecentContainer> getAllEntriesRecursivelyAsList(
      final long contentEntryUid) {
    final String _sql = "WITH RECURSIVE ContentEntry_recursive(\n"
            + "            contentEntryUid, title, ceInactive, contentFlags, description, entryId, author, publisher, licenseType, licenseName, licenseUrl, sourceUrl, thumbnailUrl, lastModified, primaryLanguageUid, languageVariantUid, leaf, publik,  completionCriteria, minScore, contentOwner, contentTypeFlag, contentEntryLocalChangeSeqNum, contentEntryMasterChangeSeqNum, contentEntryLastChangedBy, contentEntryLct,\n"
            + "            \n"
            + "            cepcjUid, cepcjChildContentEntryUid, cepcjParentContentEntryUid, childIndex, cepcjLocalChangeSeqNum, cepcjMasterChangeSeqNum, cepcjLastChangedBy, cepcjLct,\n"
            + "            \n"
            + "            containerUid, cntLocalCsn, cntMasterCsn, cntLastModBy, fileSize, containerContentEntryUid, cntLastModified, mimeType, remarks, mobileOptimized, cntNumEntries, cntLct\n"
            + "            ) AS (\n"
            + "            SELECT ContentEntry.contentEntryUid, ContentEntry.title, ContentEntry.ceInactive, ContentEntry.contentFlags, ContentEntry.description, ContentEntry.entryId, ContentEntry.author, ContentEntry.publisher, ContentEntry.licenseType, ContentEntry.licenseName, ContentEntry.licenseUrl, ContentEntry.sourceUrl, ContentEntry.thumbnailUrl, ContentEntry.lastModified, ContentEntry.primaryLanguageUid, ContentEntry.languageVariantUid, ContentEntry.leaf, ContentEntry.publik, ContentEntry.completionCriteria, ContentEntry.minScore, ContentEntry.contentOwner, ContentEntry.contentTypeFlag, ContentEntry.contentEntryLocalChangeSeqNum, ContentEntry.contentEntryMasterChangeSeqNum, ContentEntry.contentEntryLastChangedBy, ContentEntry.contentEntryLct,\n"
            + "            ContentEntryParentChildJoin.cepcjUid, ContentEntryParentChildJoin.cepcjChildContentEntryUid, ContentEntryParentChildJoin.cepcjParentContentEntryUid, ContentEntryParentChildJoin.childIndex, ContentEntryParentChildJoin.cepcjLocalChangeSeqNum, ContentEntryParentChildJoin.cepcjMasterChangeSeqNum, ContentEntryParentChildJoin.cepcjLastChangedBy, ContentEntryParentChildJoin.cepcjLct,\n"
            + "            Container.containerUid, Container.cntLocalCsn, Container.cntMasterCsn, Container.cntLastModBy, Container.fileSize, Container.containerContentEntryUid, Container.cntLastModified, Container.mimeType, Container.remarks, Container.mobileOptimized, Container.cntNumEntries, Container.cntLct\n"
            + "            FROM \n"
            + "            ContentEntry\n"
            + "            LEFT JOIN ContentEntryParentChildJoin ON ContentEntry.contentEntryUid = ContentEntryParentChildJoin.cepcjChildContentEntryUid \n"
            + "            LEFT JOIN Container ON Container.containerUid = (SELECT COALESCE((SELECT containerUid FROM Container WHERE containerContentEntryUid = ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1), 0))\n"
            + "            WHERE ContentEntry.contentEntryUid = ?\n"
            + "            UNION\n"
            + "            SELECT ContentEntry.contentEntryUid, ContentEntry.title, ContentEntry.ceInactive, ContentEntry.contentFlags, ContentEntry.description, ContentEntry.entryId, ContentEntry.author, ContentEntry.publisher, ContentEntry.licenseType, ContentEntry.licenseName, ContentEntry.licenseUrl, ContentEntry.sourceUrl, ContentEntry.thumbnailUrl, ContentEntry.lastModified, ContentEntry.primaryLanguageUid, ContentEntry.languageVariantUid, ContentEntry.leaf, ContentEntry.publik, ContentEntry.completionCriteria, ContentEntry.minScore, ContentEntry.contentOwner, ContentEntry.contentTypeFlag, ContentEntry.contentEntryLocalChangeSeqNum, ContentEntry.contentEntryMasterChangeSeqNum, ContentEntry.contentEntryLastChangedBy, ContentEntry.contentEntryLct,\n"
            + "            ContentEntryParentChildJoin.cepcjUid, ContentEntryParentChildJoin.cepcjChildContentEntryUid, ContentEntryParentChildJoin.cepcjParentContentEntryUid, ContentEntryParentChildJoin.childIndex, ContentEntryParentChildJoin.cepcjLocalChangeSeqNum, ContentEntryParentChildJoin.cepcjMasterChangeSeqNum, ContentEntryParentChildJoin.cepcjLastChangedBy, ContentEntryParentChildJoin.cepcjLct, \n"
            + "            Container.containerUid, Container.cntLocalCsn, Container.cntMasterCsn, Container.cntLastModBy, Container.fileSize, Container.containerContentEntryUid, Container.cntLastModified, Container.mimeType, Container.remarks, Container.mobileOptimized, Container.cntNumEntries, Container.cntLct\n"
            + "            FROM \n"
            + "            ContentEntry\n"
            + "            LEFT JOIN ContentEntryParentChildJoin ON ContentEntry.contentEntryUid = ContentEntryParentChildJoin.cepcjChildContentEntryUid \n"
            + "            LEFT JOIN Container ON Container.containerUid = (SELECT COALESCE((SELECT containerUid FROM Container WHERE containerContentEntryUid = ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1), 0)),\n"
            + "            ContentEntry_recursive\n"
            + "            WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ContentEntry_recursive.contentEntryUid)\n"
            + "            SELECT * FROM ContentEntry_recursive";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
      final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
      final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
      final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
      final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
      final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
      final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
      final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
      final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
      final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
      final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
      final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
      final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
      final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
      final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
      final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
      final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
      final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
      final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
      final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
      final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
      final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
      final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
      final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
      final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
      final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
      final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjUid");
      final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjChildContentEntryUid");
      final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjParentContentEntryUid");
      final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "childIndex");
      final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLocalChangeSeqNum");
      final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjMasterChangeSeqNum");
      final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLastChangedBy");
      final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLct");
      final int _cursorIndexOfContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerUid");
      final int _cursorIndexOfCntLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLocalCsn");
      final int _cursorIndexOfCntMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "cntMasterCsn");
      final int _cursorIndexOfCntLastModBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModBy");
      final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
      final int _cursorIndexOfContainerContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "containerContentEntryUid");
      final int _cursorIndexOfCntLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLastModified");
      final int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "mimeType");
      final int _cursorIndexOfRemarks = CursorUtil.getColumnIndexOrThrow(_cursor, "remarks");
      final int _cursorIndexOfMobileOptimized = CursorUtil.getColumnIndexOrThrow(_cursor, "mobileOptimized");
      final int _cursorIndexOfCntNumEntries = CursorUtil.getColumnIndexOrThrow(_cursor, "cntNumEntries");
      final int _cursorIndexOfCntLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cntLct");
      final List<ContentEntryWithParentChildJoinAndMostRecentContainer> _result = new ArrayList<ContentEntryWithParentChildJoinAndMostRecentContainer>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContentEntryWithParentChildJoinAndMostRecentContainer _item;
        final ContentEntryParentChildJoin _tmpContentEntryParentChildJoin;
        if (! (_cursor.isNull(_cursorIndexOfCepcjUid) && _cursor.isNull(_cursorIndexOfCepcjChildContentEntryUid) && _cursor.isNull(_cursorIndexOfCepcjParentContentEntryUid) && _cursor.isNull(_cursorIndexOfChildIndex) && _cursor.isNull(_cursorIndexOfCepcjLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfCepcjMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfCepcjLastChangedBy) && _cursor.isNull(_cursorIndexOfCepcjLct))) {
          final long _tmpCepcjChildContentEntryUid;
          _tmpCepcjChildContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
          final long _tmpCepcjParentContentEntryUid;
          _tmpCepcjParentContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
          final int _tmpChildIndex;
          _tmpChildIndex = _cursor.getInt(_cursorIndexOfChildIndex);
          _tmpContentEntryParentChildJoin = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
          final long _tmpCepcjUid;
          _tmpCepcjUid = _cursor.getLong(_cursorIndexOfCepcjUid);
          _tmpContentEntryParentChildJoin.setCepcjUid(_tmpCepcjUid);
          final long _tmpCepcjLocalChangeSeqNum;
          _tmpCepcjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
          _tmpContentEntryParentChildJoin.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
          final long _tmpCepcjMasterChangeSeqNum;
          _tmpCepcjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
          _tmpContentEntryParentChildJoin.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
          final int _tmpCepcjLastChangedBy;
          _tmpCepcjLastChangedBy = _cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
          _tmpContentEntryParentChildJoin.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
          final long _tmpCepcjLct;
          _tmpCepcjLct = _cursor.getLong(_cursorIndexOfCepcjLct);
          _tmpContentEntryParentChildJoin.setCepcjLct(_tmpCepcjLct);
        }  else  {
          _tmpContentEntryParentChildJoin = null;
        }
        final Container _tmpMostRecentContainer;
        if (! (_cursor.isNull(_cursorIndexOfContainerUid) && _cursor.isNull(_cursorIndexOfCntLocalCsn) && _cursor.isNull(_cursorIndexOfCntMasterCsn) && _cursor.isNull(_cursorIndexOfCntLastModBy) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfContainerContentEntryUid) && _cursor.isNull(_cursorIndexOfCntLastModified) && _cursor.isNull(_cursorIndexOfMimeType) && _cursor.isNull(_cursorIndexOfRemarks) && _cursor.isNull(_cursorIndexOfMobileOptimized) && _cursor.isNull(_cursorIndexOfCntNumEntries) && _cursor.isNull(_cursorIndexOfCntLct))) {
          _tmpMostRecentContainer = new Container();
          final long _tmpContainerUid;
          _tmpContainerUid = _cursor.getLong(_cursorIndexOfContainerUid);
          _tmpMostRecentContainer.setContainerUid(_tmpContainerUid);
          final long _tmpCntLocalCsn;
          _tmpCntLocalCsn = _cursor.getLong(_cursorIndexOfCntLocalCsn);
          _tmpMostRecentContainer.setCntLocalCsn(_tmpCntLocalCsn);
          final long _tmpCntMasterCsn;
          _tmpCntMasterCsn = _cursor.getLong(_cursorIndexOfCntMasterCsn);
          _tmpMostRecentContainer.setCntMasterCsn(_tmpCntMasterCsn);
          final int _tmpCntLastModBy;
          _tmpCntLastModBy = _cursor.getInt(_cursorIndexOfCntLastModBy);
          _tmpMostRecentContainer.setCntLastModBy(_tmpCntLastModBy);
          final long _tmpFileSize;
          _tmpFileSize = _cursor.getLong(_cursorIndexOfFileSize);
          _tmpMostRecentContainer.setFileSize(_tmpFileSize);
          final long _tmpContainerContentEntryUid;
          _tmpContainerContentEntryUid = _cursor.getLong(_cursorIndexOfContainerContentEntryUid);
          _tmpMostRecentContainer.setContainerContentEntryUid(_tmpContainerContentEntryUid);
          final long _tmpCntLastModified;
          _tmpCntLastModified = _cursor.getLong(_cursorIndexOfCntLastModified);
          _tmpMostRecentContainer.setCntLastModified(_tmpCntLastModified);
          final String _tmpMimeType;
          if (_cursor.isNull(_cursorIndexOfMimeType)) {
            _tmpMimeType = null;
          } else {
            _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
          }
          _tmpMostRecentContainer.setMimeType(_tmpMimeType);
          final String _tmpRemarks;
          if (_cursor.isNull(_cursorIndexOfRemarks)) {
            _tmpRemarks = null;
          } else {
            _tmpRemarks = _cursor.getString(_cursorIndexOfRemarks);
          }
          _tmpMostRecentContainer.setRemarks(_tmpRemarks);
          final boolean _tmpMobileOptimized;
          final int _tmp;
          _tmp = _cursor.getInt(_cursorIndexOfMobileOptimized);
          _tmpMobileOptimized = _tmp != 0;
          _tmpMostRecentContainer.setMobileOptimized(_tmpMobileOptimized);
          final int _tmpCntNumEntries;
          _tmpCntNumEntries = _cursor.getInt(_cursorIndexOfCntNumEntries);
          _tmpMostRecentContainer.setCntNumEntries(_tmpCntNumEntries);
          final long _tmpCntLct;
          _tmpCntLct = _cursor.getLong(_cursorIndexOfCntLct);
          _tmpMostRecentContainer.setCntLct(_tmpCntLct);
        }  else  {
          _tmpMostRecentContainer = null;
        }
        _item = new ContentEntryWithParentChildJoinAndMostRecentContainer();
        final long _tmpContentEntryUid;
        _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
        _item.setContentEntryUid(_tmpContentEntryUid);
        final String _tmpTitle;
        if (_cursor.isNull(_cursorIndexOfTitle)) {
          _tmpTitle = null;
        } else {
          _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
        }
        _item.setTitle(_tmpTitle);
        final boolean _tmpCeInactive;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfCeInactive);
        _tmpCeInactive = _tmp_1 != 0;
        _item.setCeInactive(_tmpCeInactive);
        final int _tmpContentFlags;
        _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
        _item.setContentFlags(_tmpContentFlags);
        final String _tmpDescription;
        if (_cursor.isNull(_cursorIndexOfDescription)) {
          _tmpDescription = null;
        } else {
          _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
        }
        _item.setDescription(_tmpDescription);
        final String _tmpEntryId;
        if (_cursor.isNull(_cursorIndexOfEntryId)) {
          _tmpEntryId = null;
        } else {
          _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
        }
        _item.setEntryId(_tmpEntryId);
        final String _tmpAuthor;
        if (_cursor.isNull(_cursorIndexOfAuthor)) {
          _tmpAuthor = null;
        } else {
          _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
        }
        _item.setAuthor(_tmpAuthor);
        final String _tmpPublisher;
        if (_cursor.isNull(_cursorIndexOfPublisher)) {
          _tmpPublisher = null;
        } else {
          _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
        }
        _item.setPublisher(_tmpPublisher);
        final int _tmpLicenseType;
        _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
        _item.setLicenseType(_tmpLicenseType);
        final String _tmpLicenseName;
        if (_cursor.isNull(_cursorIndexOfLicenseName)) {
          _tmpLicenseName = null;
        } else {
          _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
        }
        _item.setLicenseName(_tmpLicenseName);
        final String _tmpLicenseUrl;
        if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
          _tmpLicenseUrl = null;
        } else {
          _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
        }
        _item.setLicenseUrl(_tmpLicenseUrl);
        final String _tmpSourceUrl;
        if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
          _tmpSourceUrl = null;
        } else {
          _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
        }
        _item.setSourceUrl(_tmpSourceUrl);
        final String _tmpThumbnailUrl;
        if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
          _tmpThumbnailUrl = null;
        } else {
          _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
        }
        _item.setThumbnailUrl(_tmpThumbnailUrl);
        final long _tmpLastModified;
        _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
        _item.setLastModified(_tmpLastModified);
        final long _tmpPrimaryLanguageUid;
        _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
        _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
        final long _tmpLanguageVariantUid;
        _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
        _item.setLanguageVariantUid(_tmpLanguageVariantUid);
        final boolean _tmpLeaf;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfLeaf);
        _tmpLeaf = _tmp_2 != 0;
        _item.setLeaf(_tmpLeaf);
        final boolean _tmpPublik;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfPublik);
        _tmpPublik = _tmp_3 != 0;
        _item.setPublik(_tmpPublik);
        final int _tmpCompletionCriteria;
        _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
        _item.setCompletionCriteria(_tmpCompletionCriteria);
        final int _tmpMinScore;
        _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
        _item.setMinScore(_tmpMinScore);
        final long _tmpContentOwner;
        _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
        _item.setContentOwner(_tmpContentOwner);
        final int _tmpContentTypeFlag;
        _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
        _item.setContentTypeFlag(_tmpContentTypeFlag);
        final long _tmpContentEntryLocalChangeSeqNum;
        _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
        _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
        final long _tmpContentEntryMasterChangeSeqNum;
        _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
        _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
        final int _tmpContentEntryLastChangedBy;
        _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
        _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
        final long _tmpContentEntryLct;
        _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
        _item.setContentEntryLct(_tmpContentEntryLct);
        _item.setContentEntryParentChildJoin(_tmpContentEntryParentChildJoin);
        _item.setMostRecentContainer(_tmpMostRecentContainer);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object getContentEntryFromUids(final List<Long> contentEntryUids,
      final Continuation<? super List<UidAndLabel>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("Select ContentEntry.contentEntryUid AS uid, ContentEntry.title As labelName ");
    _stringBuilder.append("\n");
    _stringBuilder.append("                    from ContentEntry WHERE contentEntryUid IN (");
    final int _inputSize = contentEntryUids.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : contentEntryUids) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<UidAndLabel>>() {
      @Override
      public List<UidAndLabel> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUid = 0;
          final int _cursorIndexOfLabelName = 1;
          final List<UidAndLabel> _result = new ArrayList<UidAndLabel>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final UidAndLabel _item_1;
            _item_1 = new UidAndLabel();
            final long _tmpUid;
            _tmpUid = _cursor.getLong(_cursorIndexOfUid);
            _item_1.setUid(_tmpUid);
            final String _tmpLabelName;
            if (_cursor.isNull(_cursorIndexOfLabelName)) {
              _tmpLabelName = null;
            } else {
              _tmpLabelName = _cursor.getString(_cursorIndexOfLabelName);
            }
            _item_1.setLabelName(_tmpLabelName);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<List<ContentEntryWithLanguage>> findAllLive() {
    final String _sql = "SELECT ContentEntry.*, Language.* FROM ContentEntry LEFT JOIN Language ON Language.langUid = ContentEntry.primaryLanguageUid";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ContentEntry","Language"}, false, new Callable<List<ContentEntryWithLanguage>>() {
      @Override
      public List<ContentEntryWithLanguage> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
          final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
          final int _cursorIndexOfIso6391Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_1_standard");
          final int _cursorIndexOfIso6392Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_2_standard");
          final int _cursorIndexOfIso6393Standard = CursorUtil.getColumnIndexOrThrow(_cursor, "iso_639_3_standard");
          final int _cursorIndexOfLanguageType = CursorUtil.getColumnIndexOrThrow(_cursor, "Language_Type");
          final int _cursorIndexOfLanguageActive = CursorUtil.getColumnIndexOrThrow(_cursor, "languageActive");
          final int _cursorIndexOfLangLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langLocalChangeSeqNum");
          final int _cursorIndexOfLangMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langMasterChangeSeqNum");
          final int _cursorIndexOfLangLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langLastChangedBy");
          final int _cursorIndexOfLangLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langLct");
          final List<ContentEntryWithLanguage> _result = new ArrayList<ContentEntryWithLanguage>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContentEntryWithLanguage _item;
            final Language _tmpLanguage;
            if (! (_cursor.isNull(_cursorIndexOfLangUid) && _cursor.isNull(_cursorIndexOfName) && _cursor.isNull(_cursorIndexOfIso6391Standard) && _cursor.isNull(_cursorIndexOfIso6392Standard) && _cursor.isNull(_cursorIndexOfIso6393Standard) && _cursor.isNull(_cursorIndexOfLanguageType) && _cursor.isNull(_cursorIndexOfLanguageActive) && _cursor.isNull(_cursorIndexOfLangLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfLangLastChangedBy) && _cursor.isNull(_cursorIndexOfLangLct))) {
              _tmpLanguage = new Language();
              final long _tmpLangUid;
              _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
              _tmpLanguage.setLangUid(_tmpLangUid);
              final String _tmpName;
              if (_cursor.isNull(_cursorIndexOfName)) {
                _tmpName = null;
              } else {
                _tmpName = _cursor.getString(_cursorIndexOfName);
              }
              _tmpLanguage.setName(_tmpName);
              final String _tmpIso_639_1_standard;
              if (_cursor.isNull(_cursorIndexOfIso6391Standard)) {
                _tmpIso_639_1_standard = null;
              } else {
                _tmpIso_639_1_standard = _cursor.getString(_cursorIndexOfIso6391Standard);
              }
              _tmpLanguage.setIso_639_1_standard(_tmpIso_639_1_standard);
              final String _tmpIso_639_2_standard;
              if (_cursor.isNull(_cursorIndexOfIso6392Standard)) {
                _tmpIso_639_2_standard = null;
              } else {
                _tmpIso_639_2_standard = _cursor.getString(_cursorIndexOfIso6392Standard);
              }
              _tmpLanguage.setIso_639_2_standard(_tmpIso_639_2_standard);
              final String _tmpIso_639_3_standard;
              if (_cursor.isNull(_cursorIndexOfIso6393Standard)) {
                _tmpIso_639_3_standard = null;
              } else {
                _tmpIso_639_3_standard = _cursor.getString(_cursorIndexOfIso6393Standard);
              }
              _tmpLanguage.setIso_639_3_standard(_tmpIso_639_3_standard);
              final String _tmpLanguage_Type;
              if (_cursor.isNull(_cursorIndexOfLanguageType)) {
                _tmpLanguage_Type = null;
              } else {
                _tmpLanguage_Type = _cursor.getString(_cursorIndexOfLanguageType);
              }
              _tmpLanguage.setLanguage_Type(_tmpLanguage_Type);
              final boolean _tmpLanguageActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfLanguageActive);
              _tmpLanguageActive = _tmp != 0;
              _tmpLanguage.setLanguageActive(_tmpLanguageActive);
              final long _tmpLangLocalChangeSeqNum;
              _tmpLangLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangLocalChangeSeqNum);
              _tmpLanguage.setLangLocalChangeSeqNum(_tmpLangLocalChangeSeqNum);
              final long _tmpLangMasterChangeSeqNum;
              _tmpLangMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangMasterChangeSeqNum);
              _tmpLanguage.setLangMasterChangeSeqNum(_tmpLangMasterChangeSeqNum);
              final int _tmpLangLastChangedBy;
              _tmpLangLastChangedBy = _cursor.getInt(_cursorIndexOfLangLastChangedBy);
              _tmpLanguage.setLangLastChangedBy(_tmpLangLastChangedBy);
              final long _tmpLangLct;
              _tmpLangLct = _cursor.getLong(_cursorIndexOfLangLct);
              _tmpLanguage.setLangLct(_tmpLangLct);
            }  else  {
              _tmpLanguage = null;
            }
            _item = new ContentEntryWithLanguage();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _item.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _item.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _item.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _item.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _item.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _item.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _item.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _item.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _item.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _item.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _item.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _item.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _item.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _item.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp_1 != 0;
            _item.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_2 != 0;
            _item.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_3 != 0;
            _item.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _item.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _item.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _item.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _item.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _item.setContentEntryLct(_tmpContentEntryLct);
            _item.setLanguage(_tmpLanguage);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object personHasPermissionWithContentEntry(final long accountPersonUid,
      final long contentEntryUid, final long permission,
      final Continuation<? super Boolean> continuation) {
    final String _sql = "SELECT EXISTS(SELECT 1 FROM ContentEntry WHERE ContentEntry.contentEntryUid = ? AND ? IN (\n"
            + "            SELECT DISTINCT Person.PersonUid FROM Person\n"
            + "            LEFT JOIN PersonGroupMember ON Person.personUid = PersonGroupMember.groupMemberPersonUid\n"
            + "            LEFT JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n"
            + "            LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid\n"
            + "            WHERE \n"
            + "            CAST(Person.admin AS INTEGER) = 1\n"
            + "            OR \n"
            + "            (EntityRole.ertableId = 42 AND \n"
            + "            EntityRole.erEntityUid = ContentEntry.contentEntryUid AND\n"
            + "            (Role.rolePermissions &  \n"
            + "         ? ) > 0)))";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, permission);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findContentEntriesWhereIsLeafAndLatestContainerHasNoEntriesOrHasZeroFileSize(
      final Continuation<? super List<? extends ContentEntry>> continuation) {
    final String _sql = "\n"
            + "SELECT ContentEntry.*\n"
            + "  FROM ContentEntry\n"
            + "       JOIN Container ON Container.containerUid = \n"
            + "       (SELECT containerUid \n"
            + "          FROM Container\n"
            + "         WHERE Container.containercontententryUid = ContentEntry.contentEntryUid\n"
            + "           AND Container.cntLastModified = \n"
            + "               (SELECT MAX(ContainerInternal.cntLastModified)\n"
            + "                  FROM Container ContainerInternal\n"
            + "                 WHERE ContainerInternal.containercontententryUid = ContentEntry.contentEntryUid))\n"
            + " WHERE ContentEntry.leaf \n"
            + "   AND NOT ContentEntry.ceInactive\n"
            + "   AND (NOT EXISTS \n"
            + "       (SELECT ContainerEntry.ceUid\n"
            + "          FROM ContainerEntry\n"
            + "         WHERE ContainerEntry.ceContainerUid = Container.containerUid)\n"
            + "        OR Container.fileSize = 0)   \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContentEntry>>() {
      @Override
      public List<ContentEntry> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final List<ContentEntry> _result = new ArrayList<ContentEntry>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContentEntry _item;
            _item = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _item.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _item.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _item.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _item.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _item.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _item.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _item.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _item.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _item.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _item.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _item.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _item.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _item.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _item.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _item.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _item.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _item.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _item.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _item.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _item.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _item.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _item.setContentEntryLct(_tmpContentEntryLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object buttonsToShowForContentEntry(final long contentEntryUid,
      final boolean platformDownloadEnabled,
      final Continuation<? super ContentEntryButtonModel> continuation) {
    final String _sql = "\n"
            + "        WITH ContentEntryContainerUids AS \n"
            + "             (SELECT Container.containerUid\n"
            + "                FROM Container\n"
            + "               WHERE Container.containerContentEntryUid = ?\n"
            + "                   AND Container.fileSize > 0),\n"
            + "                   \n"
            + "             \n"
            + "            LatestDownloadedContainer(containerUid) AS\n"
            + "             (SELECT COALESCE(\n"
            + "                     (SELECT containerUid\n"
            + "                        FROM Container\n"
            + "                       WHERE Container.containerContentEntryUid = ? \n"
            + "                         AND EXISTS(\n"
            + "                             SELECT 1\n"
            + "                               FROM ContainerEntry\n"
            + "                              WHERE ContainerEntry.ceContainerUid = Container.containerUid)\n"
            + "                    ORDER BY cntLastModified DESC\n"
            + "                       LIMIT 1), 0))\n"
            + "        ,\n"
            + "                            \n"
            + "             \n"
            + "            ActiveContentJobItems(cjiRecursiveStatus, cjiPluginId) AS\n"
            + "             (SELECT cjiRecursiveStatus, cjiPluginId\n"
            + "                FROM ContentJobItem\n"
            + "               WHERE cjiContentEntryUid = ?\n"
            + "                 AND cjiStatus BETWEEN 4 AND 20)\n"
            + "        ,\n"
            + "                  \n"
            + "            ShowDownload(showDownload) AS \n"
            + "            (SELECT CAST(? AS INTEGER) = 1\n"
            + "                AND (SELECT containerUid FROM LatestDownloadedContainer) = 0\n"
            + "                AND (SELECT COUNT(*) FROM ActiveContentJobItems) = 0\n"
            + "                AND (SELECT COUNT(*) FROM ContentEntryContainerUids) > 0)\n"
            + "                   \n"
            + "        SELECT (SELECT showDownload FROM ShowDownload)\n"
            + "               AS showDownloadButton,\n"
            + "        \n"
            + "               CAST(? AS INTEGER) = 0\n"
            + "               OR (SELECT containerUid FROM LatestDownloadedContainer) != 0          \n"
            + "               AS showOpenButton,\n"
            + "       \n"
            + "               (SELECT NOT showDownload FROM ShowDownload)\n"
            + "           AND (SELECT COUNT(*) FROM ActiveContentJobItems) = 0    \n"
            + "           AND (SELECT COALESCE(\n"
            + "                       (SELECT cntLastModified\n"
            + "                          FROM Container\n"
            + "                         WHERE containerContentEntryUid = ?\n"
            + "                           AND fileSize > 0\n"
            + "                      ORDER BY cntLastModified DESC), 0)) \n"
            + "               > (SELECT COALESCE(\n"
            + "                         (SELECT cntLastModified\n"
            + "                            FROM Container\n"
            + "                           WHERE Container.containerUid = \n"
            + "                                 (SELECT LatestDownloadedContainer.containerUid\n"
            + "                                    FROM LatestDownloadedContainer)), 0)) \n"
            + "               AS showUpdateButton,\n"
            + "               \n"
            + "               CAST(? AS INTEGER) = 1\n"
            + "           AND (SELECT containerUid FROM LatestDownloadedContainer) != 0\n"
            + "           AND (SELECT COUNT(*) FROM ActiveContentJobItems) = 0    \n"
            + "               AS showDeleteButton,\n"
            + "               \n"
            + "               (SELECT COUNT(*) \n"
            + "                  FROM ActiveContentJobItems \n"
            + "                 WHERE cjiPluginId = 10) > 0\n"
            + "               AS showManageDownloadButton\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 7);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 4;
    final int _tmp = platformDownloadEnabled ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    _argIndex = 5;
    final int _tmp_1 = platformDownloadEnabled ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp_1);
    _argIndex = 6;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 7;
    final int _tmp_2 = platformDownloadEnabled ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp_2);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryButtonModel>() {
      @Override
      public ContentEntryButtonModel call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfShowDownloadButton = 0;
          final int _cursorIndexOfShowOpenButton = 1;
          final int _cursorIndexOfShowUpdateButton = 2;
          final int _cursorIndexOfShowDeleteButton = 3;
          final int _cursorIndexOfShowManageDownloadButton = 4;
          final ContentEntryButtonModel _result;
          if(_cursor.moveToFirst()) {
            _result = new ContentEntryButtonModel();
            final boolean _tmpShowDownloadButton;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfShowDownloadButton);
            _tmpShowDownloadButton = _tmp_3 != 0;
            _result.setShowDownloadButton(_tmpShowDownloadButton);
            final boolean _tmpShowOpenButton;
            final int _tmp_4;
            _tmp_4 = _cursor.getInt(_cursorIndexOfShowOpenButton);
            _tmpShowOpenButton = _tmp_4 != 0;
            _result.setShowOpenButton(_tmpShowOpenButton);
            final boolean _tmpShowUpdateButton;
            final int _tmp_5;
            _tmp_5 = _cursor.getInt(_cursorIndexOfShowUpdateButton);
            _tmpShowUpdateButton = _tmp_5 != 0;
            _result.setShowUpdateButton(_tmpShowUpdateButton);
            final boolean _tmpShowDeleteButton;
            final int _tmp_6;
            _tmp_6 = _cursor.getInt(_cursorIndexOfShowDeleteButton);
            _tmpShowDeleteButton = _tmp_6 != 0;
            _result.setShowDeleteButton(_tmpShowDeleteButton);
            final boolean _tmpShowManageDownloadButton;
            final int _tmp_7;
            _tmp_7 = _cursor.getInt(_cursorIndexOfShowManageDownloadButton);
            _tmpShowManageDownloadButton = _tmp_7 != 0;
            _result.setShowManageDownloadButton(_tmpShowManageDownloadButton);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object statusForDownloadDialog(final long contentEntryUid,
      final Continuation<? super Integer> continuation) {
    final String _sql = "\n"
            + "        SELECT ContentJobItem.cjiRecursiveStatus AS status\n"
            + "         FROM ContentJobItem\n"
            + "        WHERE ContentJobItem.cjiContentEntryUid = ?\n"
            + "          AND ContentJobItem.cjiPluginId != 14\n"
            + "          AND ContentJobItem.cjiStatus BETWEEN 4 AND 25\n"
            + "          AND NOT EXISTS(\n"
            + "              SELECT 1\n"
            + "                FROM ContentJobItem ContentJobItemInternal\n"
            + "               WHERE ContentJobItemInternal.cjiContentEntryUid = ?\n"
            + "                 AND ContentJobItemInternal.cjiPluginId = 14\n"
            + "                 AND ContentJobItemInternal.cjiFinishTime > ContentJobItem.cjiStartTime)\n"
            + "     ORDER BY ContentJobItem.cjiFinishTime DESC\n"
            + "        LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _result;
          if(_cursor.moveToFirst()) {
            _result = _cursor.getInt(0);
          } else {
            _result = 0;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object statusForContentEntryList(final long contentEntryUid,
      final Continuation<? super ContentJobItemProgressAndStatus> continuation) {
    final String _sql = "\n"
            + "        SELECT ContentJobItem.cjiRecursiveStatus AS status, \n"
            + "               ContentJobItem.cjiRecursiveProgress AS progress,\n"
            + "               ContentJobItem.cjiRecursiveTotal AS total\n"
            + "         FROM ContentJobItem\n"
            + "        WHERE ContentJobItem.cjiContentEntryUid = ?\n"
            + "          AND ContentJobItem.cjiPluginId != 14\n"
            + "          AND ContentJobItem.cjiStatus BETWEEN 4 AND 25\n"
            + "          AND NOT EXISTS(\n"
            + "              SELECT 1\n"
            + "                FROM ContentJobItem ContentJobItemInternal\n"
            + "               WHERE ContentJobItemInternal.cjiContentEntryUid = ?\n"
            + "                 AND ContentJobItemInternal.cjiPluginId = 14\n"
            + "                 AND ContentJobItemInternal.cjiFinishTime > ContentJobItem.cjiStartTime)\n"
            + "     ORDER BY ContentJobItem.cjiFinishTime DESC\n"
            + "        LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentJobItemProgressAndStatus>() {
      @Override
      public ContentJobItemProgressAndStatus call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfStatus = 0;
          final int _cursorIndexOfProgress = 1;
          final int _cursorIndexOfTotal = 2;
          final ContentJobItemProgressAndStatus _result;
          if(_cursor.moveToFirst()) {
            final int _tmpStatus;
            _tmpStatus = _cursor.getInt(_cursorIndexOfStatus);
            final long _tmpProgress;
            _tmpProgress = _cursor.getLong(_cursorIndexOfProgress);
            final long _tmpTotal;
            _tmpTotal = _cursor.getLong(_cursorIndexOfTotal);
            _result = new ContentJobItemProgressAndStatus(_tmpStatus,_tmpProgress,_tmpTotal);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object toggleVisibilityContentEntryItems(final boolean toggleVisibility,
      final List<Long> selectedItem, final long changedTime,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        UPDATE ContentEntry ");
        _stringBuilder.append("\n");
        _stringBuilder.append("           SET ceInactive = ");
        _stringBuilder.append("?");
        _stringBuilder.append(", ");
        _stringBuilder.append("\n");
        _stringBuilder.append("               contentEntryLct = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" ");
        _stringBuilder.append("\n");
        _stringBuilder.append("         WHERE contentEntryUid IN (");
        final int _inputSize = selectedItem.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        final int _tmp = toggleVisibility ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changedTime);
        _argIndex = 3;
        for (long _item : selectedItem) {
          _stmt.bindLong(_argIndex, _item);
          _argIndex ++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
