package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ContentEntryParentChildJoinDao_Impl extends ContentEntryParentChildJoinDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContentEntryParentChildJoin> __insertionAdapterOfContentEntryParentChildJoin;

  private final EntityInsertionAdapter<ContentEntryParentChildJoin> __insertionAdapterOfContentEntryParentChildJoin_1;

  private final EntityDeletionOrUpdateAdapter<ContentEntryParentChildJoin> __updateAdapterOfContentEntryParentChildJoin;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public ContentEntryParentChildJoinDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContentEntryParentChildJoin = new EntityInsertionAdapter<ContentEntryParentChildJoin>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ContentEntryParentChildJoin` (`cepcjParentContentEntryUid`,`cepcjChildContentEntryUid`,`childIndex`,`cepcjUid`,`cepcjLocalChangeSeqNum`,`cepcjMasterChangeSeqNum`,`cepcjLastChangedBy`,`cepcjLct`) VALUES (?,?,?,nullif(?, 0),?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentEntryParentChildJoin value) {
        stmt.bindLong(1, value.getCepcjParentContentEntryUid());
        stmt.bindLong(2, value.getCepcjChildContentEntryUid());
        stmt.bindLong(3, value.getChildIndex());
        stmt.bindLong(4, value.getCepcjUid());
        stmt.bindLong(5, value.getCepcjLocalChangeSeqNum());
        stmt.bindLong(6, value.getCepcjMasterChangeSeqNum());
        stmt.bindLong(7, value.getCepcjLastChangedBy());
        stmt.bindLong(8, value.getCepcjLct());
      }
    };
    this.__insertionAdapterOfContentEntryParentChildJoin_1 = new EntityInsertionAdapter<ContentEntryParentChildJoin>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `ContentEntryParentChildJoin` (`cepcjParentContentEntryUid`,`cepcjChildContentEntryUid`,`childIndex`,`cepcjUid`,`cepcjLocalChangeSeqNum`,`cepcjMasterChangeSeqNum`,`cepcjLastChangedBy`,`cepcjLct`) VALUES (?,?,?,nullif(?, 0),?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentEntryParentChildJoin value) {
        stmt.bindLong(1, value.getCepcjParentContentEntryUid());
        stmt.bindLong(2, value.getCepcjChildContentEntryUid());
        stmt.bindLong(3, value.getChildIndex());
        stmt.bindLong(4, value.getCepcjUid());
        stmt.bindLong(5, value.getCepcjLocalChangeSeqNum());
        stmt.bindLong(6, value.getCepcjMasterChangeSeqNum());
        stmt.bindLong(7, value.getCepcjLastChangedBy());
        stmt.bindLong(8, value.getCepcjLct());
      }
    };
    this.__updateAdapterOfContentEntryParentChildJoin = new EntityDeletionOrUpdateAdapter<ContentEntryParentChildJoin>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ContentEntryParentChildJoin` SET `cepcjParentContentEntryUid` = ?,`cepcjChildContentEntryUid` = ?,`childIndex` = ?,`cepcjUid` = ?,`cepcjLocalChangeSeqNum` = ?,`cepcjMasterChangeSeqNum` = ?,`cepcjLastChangedBy` = ?,`cepcjLct` = ? WHERE `cepcjUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentEntryParentChildJoin value) {
        stmt.bindLong(1, value.getCepcjParentContentEntryUid());
        stmt.bindLong(2, value.getCepcjChildContentEntryUid());
        stmt.bindLong(3, value.getChildIndex());
        stmt.bindLong(4, value.getCepcjUid());
        stmt.bindLong(5, value.getCepcjLocalChangeSeqNum());
        stmt.bindLong(6, value.getCepcjMasterChangeSeqNum());
        stmt.bindLong(7, value.getCepcjLastChangedBy());
        stmt.bindLong(8, value.getCepcjLct());
        stmt.bindLong(9, value.getCepcjUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO ContentEntryParentChildJoinReplicate(cepcjPk, cepcjDestination)\n"
                + "      SELECT DISTINCT ContentEntryParentChildJoin.cepcjUid AS cepcjUid,\n"
                + "             ? AS cepcjDestination\n"
                + "        FROM ContentEntryParentChildJoin\n"
                + "       WHERE ContentEntryParentChildJoin.cepcjLct != COALESCE(\n"
                + "             (SELECT cepcjVersionId\n"
                + "                FROM ContentEntryParentChildJoinReplicate\n"
                + "               WHERE cepcjPk = ContentEntryParentChildJoin.cepcjUid\n"
                + "                 AND cepcjDestination = ?), -1) \n"
                + "      /*psql ON CONFLICT(cepcjPk, cepcjDestination) DO UPDATE\n"
                + "             SET cepcjPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "    REPLACE INTO ContentEntryParentChildJoinReplicate(cepcjPk, cepcjDestination)\n"
                + "    SELECT DISTINCT ContentEntryParentChildJoin.cepcjUid AS cepcjUid,\n"
                + "         UserSession.usClientNodeId AS cepcjDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN ContentEntryParentChildJoin\n"
                + "             ON ChangeLog.chTableId = 7\n"
                + "                AND ChangeLog.chEntityPk = ContentEntryParentChildJoin.cepcjUid\n"
                + "         JOIN UserSession ON UserSession.usStatus = 1\n"
                + "    WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND ContentEntryParentChildJoin.cepcjLct != COALESCE(\n"
                + "         (SELECT cepcjVersionId\n"
                + "            FROM ContentEntryParentChildJoinReplicate\n"
                + "           WHERE cepcjPk = ContentEntryParentChildJoin.cepcjUid\n"
                + "             AND cepcjDestination = UserSession.usClientNodeId), 0)\n"
                + "    /*psql ON CONFLICT(cepcjPk, cepcjDestination) DO UPDATE\n"
                + "     SET cepcjPending = true\n"
                + "    */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ContentEntryParentChildJoin entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfContentEntryParentChildJoin.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContentEntryParentChildJoin entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfContentEntryParentChildJoin.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ContentEntryParentChildJoin> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContentEntryParentChildJoin.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<ContentEntryParentChildJoin> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfContentEntryParentChildJoin.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void replaceList(final List<ContentEntryParentChildJoin> entries) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContentEntryParentChildJoin_1.insert(entries);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void insertWithReplace(final ContentEntryParentChildJoin parentChildJoinDao) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContentEntryParentChildJoin_1.insert(parentChildJoinDao);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ContentEntryParentChildJoin> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentEntryParentChildJoin.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ContentEntryParentChildJoin entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentEntryParentChildJoin.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public List<ContentEntryParentChildJoin> publicContentEntryParentChildJoins() {
    final String _sql = "SELECT ContentEntryParentChildJoin.* FROM ContentEntryParentChildJoin LEFT JOIN ContentEntry parentEntry ON ContentEntryParentChildJoin.cepcjParentContentEntryUid = parentEntry.contentEntryUid LEFT JOIN ContentEntry childEntry ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = childEntry.contentEntryUid WHERE parentEntry.publik AND childEntry.publik";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjParentContentEntryUid");
      final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjChildContentEntryUid");
      final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "childIndex");
      final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjUid");
      final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLocalChangeSeqNum");
      final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjMasterChangeSeqNum");
      final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLastChangedBy");
      final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLct");
      final List<ContentEntryParentChildJoin> _result = new ArrayList<ContentEntryParentChildJoin>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContentEntryParentChildJoin _item;
        final long _tmpCepcjParentContentEntryUid;
        _tmpCepcjParentContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
        final long _tmpCepcjChildContentEntryUid;
        _tmpCepcjChildContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
        final int _tmpChildIndex;
        _tmpChildIndex = _cursor.getInt(_cursorIndexOfChildIndex);
        _item = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
        final long _tmpCepcjUid;
        _tmpCepcjUid = _cursor.getLong(_cursorIndexOfCepcjUid);
        _item.setCepcjUid(_tmpCepcjUid);
        final long _tmpCepcjLocalChangeSeqNum;
        _tmpCepcjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
        _item.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
        final long _tmpCepcjMasterChangeSeqNum;
        _tmpCepcjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
        _item.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
        final int _tmpCepcjLastChangedBy;
        _tmpCepcjLastChangedBy = _cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
        _item.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
        final long _tmpCepcjLct;
        _tmpCepcjLct = _cursor.getLong(_cursorIndexOfCepcjLct);
        _item.setCepcjLct(_tmpCepcjLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<ContentEntryParentChildJoin> all() {
    final String _sql = "SELECT * FROM ContentEntryParentChildJoin";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjParentContentEntryUid");
      final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjChildContentEntryUid");
      final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "childIndex");
      final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjUid");
      final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLocalChangeSeqNum");
      final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjMasterChangeSeqNum");
      final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLastChangedBy");
      final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLct");
      final List<ContentEntryParentChildJoin> _result = new ArrayList<ContentEntryParentChildJoin>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContentEntryParentChildJoin _item;
        final long _tmpCepcjParentContentEntryUid;
        _tmpCepcjParentContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
        final long _tmpCepcjChildContentEntryUid;
        _tmpCepcjChildContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
        final int _tmpChildIndex;
        _tmpChildIndex = _cursor.getInt(_cursorIndexOfChildIndex);
        _item = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
        final long _tmpCepcjUid;
        _tmpCepcjUid = _cursor.getLong(_cursorIndexOfCepcjUid);
        _item.setCepcjUid(_tmpCepcjUid);
        final long _tmpCepcjLocalChangeSeqNum;
        _tmpCepcjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
        _item.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
        final long _tmpCepcjMasterChangeSeqNum;
        _tmpCepcjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
        _item.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
        final int _tmpCepcjLastChangedBy;
        _tmpCepcjLastChangedBy = _cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
        _item.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
        final long _tmpCepcjLct;
        _tmpCepcjLct = _cursor.getLong(_cursorIndexOfCepcjLct);
        _item.setCepcjLct(_tmpCepcjLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public ContentEntryParentChildJoin findParentByChildUuids(final long childEntryContentUid) {
    final String _sql = "SELECT * FROM ContentEntryParentChildJoin WHERE cepcjChildContentEntryUid = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, childEntryContentUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjParentContentEntryUid");
      final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjChildContentEntryUid");
      final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "childIndex");
      final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjUid");
      final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLocalChangeSeqNum");
      final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjMasterChangeSeqNum");
      final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLastChangedBy");
      final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLct");
      final ContentEntryParentChildJoin _result;
      if(_cursor.moveToFirst()) {
        final long _tmpCepcjParentContentEntryUid;
        _tmpCepcjParentContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
        final long _tmpCepcjChildContentEntryUid;
        _tmpCepcjChildContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
        final int _tmpChildIndex;
        _tmpChildIndex = _cursor.getInt(_cursorIndexOfChildIndex);
        _result = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
        final long _tmpCepcjUid;
        _tmpCepcjUid = _cursor.getLong(_cursorIndexOfCepcjUid);
        _result.setCepcjUid(_tmpCepcjUid);
        final long _tmpCepcjLocalChangeSeqNum;
        _tmpCepcjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
        _result.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
        final long _tmpCepcjMasterChangeSeqNum;
        _tmpCepcjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
        _result.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
        final int _tmpCepcjLastChangedBy;
        _tmpCepcjLastChangedBy = _cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
        _result.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
        final long _tmpCepcjLct;
        _tmpCepcjLct = _cursor.getLong(_cursorIndexOfCepcjLct);
        _result.setCepcjLct(_tmpCepcjLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<ContentEntryParentChildJoin> findListOfParentsByChildUuid(
      final long childEntryContentUid) {
    final String _sql = "SELECT * FROM ContentEntryParentChildJoin WHERE cepcjChildContentEntryUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, childEntryContentUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjParentContentEntryUid");
      final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjChildContentEntryUid");
      final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "childIndex");
      final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjUid");
      final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLocalChangeSeqNum");
      final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjMasterChangeSeqNum");
      final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLastChangedBy");
      final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLct");
      final List<ContentEntryParentChildJoin> _result = new ArrayList<ContentEntryParentChildJoin>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContentEntryParentChildJoin _item;
        final long _tmpCepcjParentContentEntryUid;
        _tmpCepcjParentContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
        final long _tmpCepcjChildContentEntryUid;
        _tmpCepcjChildContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
        final int _tmpChildIndex;
        _tmpChildIndex = _cursor.getInt(_cursorIndexOfChildIndex);
        _item = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
        final long _tmpCepcjUid;
        _tmpCepcjUid = _cursor.getLong(_cursorIndexOfCepcjUid);
        _item.setCepcjUid(_tmpCepcjUid);
        final long _tmpCepcjLocalChangeSeqNum;
        _tmpCepcjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
        _item.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
        final long _tmpCepcjMasterChangeSeqNum;
        _tmpCepcjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
        _item.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
        final int _tmpCepcjLastChangedBy;
        _tmpCepcjLastChangedBy = _cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
        _item.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
        final long _tmpCepcjLct;
        _tmpCepcjLct = _cursor.getLong(_cursorIndexOfCepcjLct);
        _item.setCepcjLct(_tmpCepcjLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public List<ContentEntryParentChildJoin> findListOfChildsByParentUuid(final long parentUid) {
    final String _sql = "SELECT * FROM ContentEntryParentChildJoin WHERE cepcjParentContentEntryUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjParentContentEntryUid");
      final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjChildContentEntryUid");
      final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "childIndex");
      final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjUid");
      final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLocalChangeSeqNum");
      final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjMasterChangeSeqNum");
      final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLastChangedBy");
      final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLct");
      final List<ContentEntryParentChildJoin> _result = new ArrayList<ContentEntryParentChildJoin>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContentEntryParentChildJoin _item;
        final long _tmpCepcjParentContentEntryUid;
        _tmpCepcjParentContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
        final long _tmpCepcjChildContentEntryUid;
        _tmpCepcjChildContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
        final int _tmpChildIndex;
        _tmpChildIndex = _cursor.getInt(_cursorIndexOfChildIndex);
        _item = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
        final long _tmpCepcjUid;
        _tmpCepcjUid = _cursor.getLong(_cursorIndexOfCepcjUid);
        _item.setCepcjUid(_tmpCepcjUid);
        final long _tmpCepcjLocalChangeSeqNum;
        _tmpCepcjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
        _item.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
        final long _tmpCepcjMasterChangeSeqNum;
        _tmpCepcjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
        _item.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
        final int _tmpCepcjLastChangedBy;
        _tmpCepcjLastChangedBy = _cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
        _item.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
        final long _tmpCepcjLct;
        _tmpCepcjLct = _cursor.getLong(_cursorIndexOfCepcjLct);
        _item.setCepcjLct(_tmpCepcjLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public ContentEntryParentChildJoin findJoinByParentChildUuids(final long parentUid,
      final long childUid) {
    final String _sql = "SELECT * FROM ContentEntryParentChildJoin WHERE cepcjParentContentEntryUid = ? AND cepcjChildContentEntryUid = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, parentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, childUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCepcjParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjParentContentEntryUid");
      final int _cursorIndexOfCepcjChildContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjChildContentEntryUid");
      final int _cursorIndexOfChildIndex = CursorUtil.getColumnIndexOrThrow(_cursor, "childIndex");
      final int _cursorIndexOfCepcjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjUid");
      final int _cursorIndexOfCepcjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLocalChangeSeqNum");
      final int _cursorIndexOfCepcjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjMasterChangeSeqNum");
      final int _cursorIndexOfCepcjLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLastChangedBy");
      final int _cursorIndexOfCepcjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "cepcjLct");
      final ContentEntryParentChildJoin _result;
      if(_cursor.moveToFirst()) {
        final long _tmpCepcjParentContentEntryUid;
        _tmpCepcjParentContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjParentContentEntryUid);
        final long _tmpCepcjChildContentEntryUid;
        _tmpCepcjChildContentEntryUid = _cursor.getLong(_cursorIndexOfCepcjChildContentEntryUid);
        final int _tmpChildIndex;
        _tmpChildIndex = _cursor.getInt(_cursorIndexOfChildIndex);
        _result = new ContentEntryParentChildJoin(_tmpCepcjParentContentEntryUid,_tmpCepcjChildContentEntryUid,_tmpChildIndex);
        final long _tmpCepcjUid;
        _tmpCepcjUid = _cursor.getLong(_cursorIndexOfCepcjUid);
        _result.setCepcjUid(_tmpCepcjUid);
        final long _tmpCepcjLocalChangeSeqNum;
        _tmpCepcjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjLocalChangeSeqNum);
        _result.setCepcjLocalChangeSeqNum(_tmpCepcjLocalChangeSeqNum);
        final long _tmpCepcjMasterChangeSeqNum;
        _tmpCepcjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCepcjMasterChangeSeqNum);
        _result.setCepcjMasterChangeSeqNum(_tmpCepcjMasterChangeSeqNum);
        final int _tmpCepcjLastChangedBy;
        _tmpCepcjLastChangedBy = _cursor.getInt(_cursorIndexOfCepcjLastChangedBy);
        _result.setCepcjLastChangedBy(_tmpCepcjLastChangedBy);
        final long _tmpCepcjLct;
        _tmpCepcjLct = _cursor.getLong(_cursorIndexOfCepcjLct);
        _result.setCepcjLct(_tmpCepcjLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object selectTopEntries(
      final Continuation<? super List<? extends ContentEntry>> continuation) {
    final String _sql = "SELECT ContentEntry.* FROM ContentEntry WHERE NOT EXISTS(SELECT cepcjUid FROM ContentEntryParentChildJoin WHERE cepcjChildContentEntryUid = ContentEntry.contentEntryUid) AND EXISTS(SELECT cepcjUid FROM ContentEntryParentChildJoin WHERE cepcjParentContentEntryUid = ContentEntry.contentEntryUid)";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContentEntry>>() {
      @Override
      public List<ContentEntry> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryUid");
          final int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "title");
          final int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow(_cursor, "description");
          final int _cursorIndexOfEntryId = CursorUtil.getColumnIndexOrThrow(_cursor, "entryId");
          final int _cursorIndexOfAuthor = CursorUtil.getColumnIndexOrThrow(_cursor, "author");
          final int _cursorIndexOfPublisher = CursorUtil.getColumnIndexOrThrow(_cursor, "publisher");
          final int _cursorIndexOfLicenseType = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseType");
          final int _cursorIndexOfLicenseName = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseName");
          final int _cursorIndexOfLicenseUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "licenseUrl");
          final int _cursorIndexOfSourceUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUrl");
          final int _cursorIndexOfThumbnailUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "thumbnailUrl");
          final int _cursorIndexOfLastModified = CursorUtil.getColumnIndexOrThrow(_cursor, "lastModified");
          final int _cursorIndexOfPrimaryLanguageUid = CursorUtil.getColumnIndexOrThrow(_cursor, "primaryLanguageUid");
          final int _cursorIndexOfLanguageVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "languageVariantUid");
          final int _cursorIndexOfContentFlags = CursorUtil.getColumnIndexOrThrow(_cursor, "contentFlags");
          final int _cursorIndexOfLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "leaf");
          final int _cursorIndexOfPublik = CursorUtil.getColumnIndexOrThrow(_cursor, "publik");
          final int _cursorIndexOfCeInactive = CursorUtil.getColumnIndexOrThrow(_cursor, "ceInactive");
          final int _cursorIndexOfCompletionCriteria = CursorUtil.getColumnIndexOrThrow(_cursor, "completionCriteria");
          final int _cursorIndexOfMinScore = CursorUtil.getColumnIndexOrThrow(_cursor, "minScore");
          final int _cursorIndexOfContentTypeFlag = CursorUtil.getColumnIndexOrThrow(_cursor, "contentTypeFlag");
          final int _cursorIndexOfContentOwner = CursorUtil.getColumnIndexOrThrow(_cursor, "contentOwner");
          final int _cursorIndexOfContentEntryLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLocalChangeSeqNum");
          final int _cursorIndexOfContentEntryMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryMasterChangeSeqNum");
          final int _cursorIndexOfContentEntryLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLastChangedBy");
          final int _cursorIndexOfContentEntryLct = CursorUtil.getColumnIndexOrThrow(_cursor, "contentEntryLct");
          final List<ContentEntry> _result = new ArrayList<ContentEntry>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContentEntry _item;
            _item = new ContentEntry();
            final long _tmpContentEntryUid;
            _tmpContentEntryUid = _cursor.getLong(_cursorIndexOfContentEntryUid);
            _item.setContentEntryUid(_tmpContentEntryUid);
            final String _tmpTitle;
            if (_cursor.isNull(_cursorIndexOfTitle)) {
              _tmpTitle = null;
            } else {
              _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
            }
            _item.setTitle(_tmpTitle);
            final String _tmpDescription;
            if (_cursor.isNull(_cursorIndexOfDescription)) {
              _tmpDescription = null;
            } else {
              _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
            }
            _item.setDescription(_tmpDescription);
            final String _tmpEntryId;
            if (_cursor.isNull(_cursorIndexOfEntryId)) {
              _tmpEntryId = null;
            } else {
              _tmpEntryId = _cursor.getString(_cursorIndexOfEntryId);
            }
            _item.setEntryId(_tmpEntryId);
            final String _tmpAuthor;
            if (_cursor.isNull(_cursorIndexOfAuthor)) {
              _tmpAuthor = null;
            } else {
              _tmpAuthor = _cursor.getString(_cursorIndexOfAuthor);
            }
            _item.setAuthor(_tmpAuthor);
            final String _tmpPublisher;
            if (_cursor.isNull(_cursorIndexOfPublisher)) {
              _tmpPublisher = null;
            } else {
              _tmpPublisher = _cursor.getString(_cursorIndexOfPublisher);
            }
            _item.setPublisher(_tmpPublisher);
            final int _tmpLicenseType;
            _tmpLicenseType = _cursor.getInt(_cursorIndexOfLicenseType);
            _item.setLicenseType(_tmpLicenseType);
            final String _tmpLicenseName;
            if (_cursor.isNull(_cursorIndexOfLicenseName)) {
              _tmpLicenseName = null;
            } else {
              _tmpLicenseName = _cursor.getString(_cursorIndexOfLicenseName);
            }
            _item.setLicenseName(_tmpLicenseName);
            final String _tmpLicenseUrl;
            if (_cursor.isNull(_cursorIndexOfLicenseUrl)) {
              _tmpLicenseUrl = null;
            } else {
              _tmpLicenseUrl = _cursor.getString(_cursorIndexOfLicenseUrl);
            }
            _item.setLicenseUrl(_tmpLicenseUrl);
            final String _tmpSourceUrl;
            if (_cursor.isNull(_cursorIndexOfSourceUrl)) {
              _tmpSourceUrl = null;
            } else {
              _tmpSourceUrl = _cursor.getString(_cursorIndexOfSourceUrl);
            }
            _item.setSourceUrl(_tmpSourceUrl);
            final String _tmpThumbnailUrl;
            if (_cursor.isNull(_cursorIndexOfThumbnailUrl)) {
              _tmpThumbnailUrl = null;
            } else {
              _tmpThumbnailUrl = _cursor.getString(_cursorIndexOfThumbnailUrl);
            }
            _item.setThumbnailUrl(_tmpThumbnailUrl);
            final long _tmpLastModified;
            _tmpLastModified = _cursor.getLong(_cursorIndexOfLastModified);
            _item.setLastModified(_tmpLastModified);
            final long _tmpPrimaryLanguageUid;
            _tmpPrimaryLanguageUid = _cursor.getLong(_cursorIndexOfPrimaryLanguageUid);
            _item.setPrimaryLanguageUid(_tmpPrimaryLanguageUid);
            final long _tmpLanguageVariantUid;
            _tmpLanguageVariantUid = _cursor.getLong(_cursorIndexOfLanguageVariantUid);
            _item.setLanguageVariantUid(_tmpLanguageVariantUid);
            final int _tmpContentFlags;
            _tmpContentFlags = _cursor.getInt(_cursorIndexOfContentFlags);
            _item.setContentFlags(_tmpContentFlags);
            final boolean _tmpLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfLeaf);
            _tmpLeaf = _tmp != 0;
            _item.setLeaf(_tmpLeaf);
            final boolean _tmpPublik;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfPublik);
            _tmpPublik = _tmp_1 != 0;
            _item.setPublik(_tmpPublik);
            final boolean _tmpCeInactive;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCeInactive);
            _tmpCeInactive = _tmp_2 != 0;
            _item.setCeInactive(_tmpCeInactive);
            final int _tmpCompletionCriteria;
            _tmpCompletionCriteria = _cursor.getInt(_cursorIndexOfCompletionCriteria);
            _item.setCompletionCriteria(_tmpCompletionCriteria);
            final int _tmpMinScore;
            _tmpMinScore = _cursor.getInt(_cursorIndexOfMinScore);
            _item.setMinScore(_tmpMinScore);
            final int _tmpContentTypeFlag;
            _tmpContentTypeFlag = _cursor.getInt(_cursorIndexOfContentTypeFlag);
            _item.setContentTypeFlag(_tmpContentTypeFlag);
            final long _tmpContentOwner;
            _tmpContentOwner = _cursor.getLong(_cursorIndexOfContentOwner);
            _item.setContentOwner(_tmpContentOwner);
            final long _tmpContentEntryLocalChangeSeqNum;
            _tmpContentEntryLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryLocalChangeSeqNum);
            _item.setContentEntryLocalChangeSeqNum(_tmpContentEntryLocalChangeSeqNum);
            final long _tmpContentEntryMasterChangeSeqNum;
            _tmpContentEntryMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfContentEntryMasterChangeSeqNum);
            _item.setContentEntryMasterChangeSeqNum(_tmpContentEntryMasterChangeSeqNum);
            final int _tmpContentEntryLastChangedBy;
            _tmpContentEntryLastChangedBy = _cursor.getInt(_cursorIndexOfContentEntryLastChangedBy);
            _item.setContentEntryLastChangedBy(_tmpContentEntryLastChangedBy);
            final long _tmpContentEntryLct;
            _tmpContentEntryLct = _cursor.getLong(_cursorIndexOfContentEntryLct);
            _item.setContentEntryLct(_tmpContentEntryLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object moveListOfEntriesToNewParent(final long contentEntryUid,
      final List<Long> selectedItems, final long updateTime,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        UPDATE ContentEntryParentChildJoin ");
        _stringBuilder.append("\n");
        _stringBuilder.append("           SET cepcjParentContentEntryUid = ");
        _stringBuilder.append("?");
        _stringBuilder.append(", ");
        _stringBuilder.append("\n");
        _stringBuilder.append("               cepcjLct = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" ");
        _stringBuilder.append("\n");
        _stringBuilder.append("               WHERE cepcjUid IN (");
        final int _inputSize = selectedItems.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, contentEntryUid);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        for (long _item : selectedItems) {
          _stmt.bindLong(_argIndex, _item);
          _argIndex ++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
