package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContentJob;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ContentJobDao_Impl extends ContentJobDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContentJob> __insertionAdapterOfContentJob;

  private final SharedSQLiteStatement __preparedStmtOfUpdateDestinationDir;

  private final SharedSQLiteStatement __preparedStmtOfUpdateMeteredAllowedForEntry;

  public ContentJobDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContentJob = new EntityInsertionAdapter<ContentJob>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ContentJob` (`cjUid`,`toUri`,`cjProgress`,`cjTotal`,`cjNotificationTitle`,`cjIsMeteredAllowed`,`params`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentJob value) {
        stmt.bindLong(1, value.getCjUid());
        if (value.getToUri() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getToUri());
        }
        stmt.bindLong(3, value.getCjProgress());
        stmt.bindLong(4, value.getCjTotal());
        if (value.getCjNotificationTitle() == null) {
          stmt.bindNull(5);
        } else {
          stmt.bindString(5, value.getCjNotificationTitle());
        }
        final int _tmp = value.getCjIsMeteredAllowed() ? 1 : 0;
        stmt.bindLong(6, _tmp);
        if (value.getParams() == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, value.getParams());
        }
      }
    };
    this.__preparedStmtOfUpdateDestinationDir = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentJob\n"
                + "           SET toUri = ?\n"
                + "         WHERE cjUid = ?\n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateMeteredAllowedForEntry = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentJob \n"
                + "           SET cjIsMeteredAllowed = ?\n"
                + "         WHERE cjUid IN (SELECT cjiJobUid \n"
                + "                           FROM ContentJobItem\n"
                + "                          WHERE cjiContentEntryUid = ?\n"
                + "                             OR cjiParentContentEntryUid = ?)\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertAsync(final ContentJob contentJob,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfContentJob.insertAndReturnId(contentJob);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object updateDestinationDir(final long cjUid, final String toUri,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateDestinationDir.acquire();
        int _argIndex = 1;
        if (toUri == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, toUri);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, cjUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateDestinationDir.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateMeteredAllowedForEntry(final long contentEntryUid,
      final boolean meteredAllowed, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateMeteredAllowedForEntry.acquire();
        int _argIndex = 1;
        final int _tmp = meteredAllowed ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, contentEntryUid);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, contentEntryUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateMeteredAllowedForEntry.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public ContentJob findByUid(final long cjUid) {
    final String _sql = "\n"
            + "        SELECT ContentJob.*\n"
            + "          FROM ContentJob\n"
            + "         WHERE cjUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, cjUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjUid");
      final int _cursorIndexOfToUri = CursorUtil.getColumnIndexOrThrow(_cursor, "toUri");
      final int _cursorIndexOfCjProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjProgress");
      final int _cursorIndexOfCjTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjTotal");
      final int _cursorIndexOfCjNotificationTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cjNotificationTitle");
      final int _cursorIndexOfCjIsMeteredAllowed = CursorUtil.getColumnIndexOrThrow(_cursor, "cjIsMeteredAllowed");
      final int _cursorIndexOfParams = CursorUtil.getColumnIndexOrThrow(_cursor, "params");
      final ContentJob _result;
      if(_cursor.moveToFirst()) {
        final long _tmpCjUid;
        _tmpCjUid = _cursor.getLong(_cursorIndexOfCjUid);
        final String _tmpToUri;
        if (_cursor.isNull(_cursorIndexOfToUri)) {
          _tmpToUri = null;
        } else {
          _tmpToUri = _cursor.getString(_cursorIndexOfToUri);
        }
        final long _tmpCjProgress;
        _tmpCjProgress = _cursor.getLong(_cursorIndexOfCjProgress);
        final long _tmpCjTotal;
        _tmpCjTotal = _cursor.getLong(_cursorIndexOfCjTotal);
        final String _tmpCjNotificationTitle;
        if (_cursor.isNull(_cursorIndexOfCjNotificationTitle)) {
          _tmpCjNotificationTitle = null;
        } else {
          _tmpCjNotificationTitle = _cursor.getString(_cursorIndexOfCjNotificationTitle);
        }
        final boolean _tmpCjIsMeteredAllowed;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfCjIsMeteredAllowed);
        _tmpCjIsMeteredAllowed = _tmp != 0;
        final String _tmpParams;
        if (_cursor.isNull(_cursorIndexOfParams)) {
          _tmpParams = null;
        } else {
          _tmpParams = _cursor.getString(_cursorIndexOfParams);
        }
        _result = new ContentJob(_tmpCjUid,_tmpToUri,_tmpCjProgress,_tmpCjTotal,_tmpCjNotificationTitle,_tmpCjIsMeteredAllowed,_tmpParams);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByUidAsync(final long cjUid,
      final Continuation<? super ContentJob> continuation) {
    final String _sql = "\n"
            + "        SELECT ContentJob.*\n"
            + "          FROM ContentJob\n"
            + "         WHERE cjUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, cjUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentJob>() {
      @Override
      public ContentJob call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjUid");
          final int _cursorIndexOfToUri = CursorUtil.getColumnIndexOrThrow(_cursor, "toUri");
          final int _cursorIndexOfCjProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjProgress");
          final int _cursorIndexOfCjTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjTotal");
          final int _cursorIndexOfCjNotificationTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cjNotificationTitle");
          final int _cursorIndexOfCjIsMeteredAllowed = CursorUtil.getColumnIndexOrThrow(_cursor, "cjIsMeteredAllowed");
          final int _cursorIndexOfParams = CursorUtil.getColumnIndexOrThrow(_cursor, "params");
          final ContentJob _result;
          if(_cursor.moveToFirst()) {
            final long _tmpCjUid;
            _tmpCjUid = _cursor.getLong(_cursorIndexOfCjUid);
            final String _tmpToUri;
            if (_cursor.isNull(_cursorIndexOfToUri)) {
              _tmpToUri = null;
            } else {
              _tmpToUri = _cursor.getString(_cursorIndexOfToUri);
            }
            final long _tmpCjProgress;
            _tmpCjProgress = _cursor.getLong(_cursorIndexOfCjProgress);
            final long _tmpCjTotal;
            _tmpCjTotal = _cursor.getLong(_cursorIndexOfCjTotal);
            final String _tmpCjNotificationTitle;
            if (_cursor.isNull(_cursorIndexOfCjNotificationTitle)) {
              _tmpCjNotificationTitle = null;
            } else {
              _tmpCjNotificationTitle = _cursor.getString(_cursorIndexOfCjNotificationTitle);
            }
            final boolean _tmpCjIsMeteredAllowed;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCjIsMeteredAllowed);
            _tmpCjIsMeteredAllowed = _tmp != 0;
            final String _tmpParams;
            if (_cursor.isNull(_cursorIndexOfParams)) {
              _tmpParams = null;
            } else {
              _tmpParams = _cursor.getString(_cursorIndexOfParams);
            }
            _result = new ContentJob(_tmpCjUid,_tmpToUri,_tmpCjProgress,_tmpCjTotal,_tmpCjNotificationTitle,_tmpCjIsMeteredAllowed,_tmpParams);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<ContentJob> findLiveDataByUid(final long cjUid) {
    final String _sql = "\n"
            + "        SELECT ContentJob.*\n"
            + "          FROM ContentJob\n"
            + "         WHERE cjUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, cjUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ContentJob"}, false, new Callable<ContentJob>() {
      @Override
      public ContentJob call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjUid");
          final int _cursorIndexOfToUri = CursorUtil.getColumnIndexOrThrow(_cursor, "toUri");
          final int _cursorIndexOfCjProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjProgress");
          final int _cursorIndexOfCjTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjTotal");
          final int _cursorIndexOfCjNotificationTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cjNotificationTitle");
          final int _cursorIndexOfCjIsMeteredAllowed = CursorUtil.getColumnIndexOrThrow(_cursor, "cjIsMeteredAllowed");
          final int _cursorIndexOfParams = CursorUtil.getColumnIndexOrThrow(_cursor, "params");
          final ContentJob _result;
          if(_cursor.moveToFirst()) {
            final long _tmpCjUid;
            _tmpCjUid = _cursor.getLong(_cursorIndexOfCjUid);
            final String _tmpToUri;
            if (_cursor.isNull(_cursorIndexOfToUri)) {
              _tmpToUri = null;
            } else {
              _tmpToUri = _cursor.getString(_cursorIndexOfToUri);
            }
            final long _tmpCjProgress;
            _tmpCjProgress = _cursor.getLong(_cursorIndexOfCjProgress);
            final long _tmpCjTotal;
            _tmpCjTotal = _cursor.getLong(_cursorIndexOfCjTotal);
            final String _tmpCjNotificationTitle;
            if (_cursor.isNull(_cursorIndexOfCjNotificationTitle)) {
              _tmpCjNotificationTitle = null;
            } else {
              _tmpCjNotificationTitle = _cursor.getString(_cursorIndexOfCjNotificationTitle);
            }
            final boolean _tmpCjIsMeteredAllowed;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCjIsMeteredAllowed);
            _tmpCjIsMeteredAllowed = _tmp != 0;
            final String _tmpParams;
            if (_cursor.isNull(_cursorIndexOfParams)) {
              _tmpParams = null;
            } else {
              _tmpParams = _cursor.getString(_cursorIndexOfParams);
            }
            _result = new ContentJob(_tmpCjUid,_tmpToUri,_tmpCjProgress,_tmpCjTotal,_tmpCjNotificationTitle,_tmpCjIsMeteredAllowed,_tmpParams);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public LiveData<Boolean> findMeteredAllowedLiveData(final long contentJobId) {
    final String _sql = "\n"
            + "        SELECT COALESCE((SELECT ContentJob.cjIsMeteredAllowed\n"
            + "          FROM ContentJob\n"
            + "         WHERE cjUid = ?\n"
            + "         LIMIT 1), 0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentJobId);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ContentJob"}, false, new Callable<Boolean>() {
      @Override
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object isConnectivityAcceptableForJob(final long jobId,
      final Continuation<? super Boolean> continuation) {
    final String _sql = "\n"
            + "          WITH ConnectivityStateCte(state) AS \n"
            + "             (SELECT COALESCE(\n"
            + "                     (SELECT connectivityState \n"
            + "                        FROM ConnectivityStatus \n"
            + "                       LIMIT 1), 0))\n"
            + "   \n"
            + "           SELECT COALESCE((\n"
            + "                  SELECT 1 \n"
            + "                    FROM ContentJob \n"
            + "                   WHERE cjUid = ?\n"
            + "                    AND ((cjIsMeteredAllowed \n"
            + "                         AND (SELECT state FROM ConnectivityStateCte) = 3)\n"
            + "\t\t\t             OR (SELECT state FROM ConnectivityStateCte) = 4)\n"
            + "                  ) ,0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, jobId);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
