package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.LanguageVariant;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class LanguageVariantDao_Impl extends LanguageVariantDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<LanguageVariant> __insertionAdapterOfLanguageVariant;

  private final EntityDeletionOrUpdateAdapter<LanguageVariant> __updateAdapterOfLanguageVariant;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public LanguageVariantDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfLanguageVariant = new EntityInsertionAdapter<LanguageVariant>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `LanguageVariant` (`langVariantUid`,`langUid`,`countryCode`,`name`,`langVariantLocalChangeSeqNum`,`langVariantMasterChangeSeqNum`,`langVariantLastChangedBy`,`langVariantLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, LanguageVariant value) {
        stmt.bindLong(1, value.getLangVariantUid());
        stmt.bindLong(2, value.getLangUid());
        if (value.getCountryCode() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCountryCode());
        }
        if (value.getName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getName());
        }
        stmt.bindLong(5, value.getLangVariantLocalChangeSeqNum());
        stmt.bindLong(6, value.getLangVariantMasterChangeSeqNum());
        stmt.bindLong(7, value.getLangVariantLastChangedBy());
        stmt.bindLong(8, value.getLangVariantLct());
      }
    };
    this.__updateAdapterOfLanguageVariant = new EntityDeletionOrUpdateAdapter<LanguageVariant>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `LanguageVariant` SET `langVariantUid` = ?,`langUid` = ?,`countryCode` = ?,`name` = ?,`langVariantLocalChangeSeqNum` = ?,`langVariantMasterChangeSeqNum` = ?,`langVariantLastChangedBy` = ?,`langVariantLct` = ? WHERE `langVariantUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, LanguageVariant value) {
        stmt.bindLong(1, value.getLangVariantUid());
        stmt.bindLong(2, value.getLangUid());
        if (value.getCountryCode() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCountryCode());
        }
        if (value.getName() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getName());
        }
        stmt.bindLong(5, value.getLangVariantLocalChangeSeqNum());
        stmt.bindLong(6, value.getLangVariantMasterChangeSeqNum());
        stmt.bindLong(7, value.getLangVariantLastChangedBy());
        stmt.bindLong(8, value.getLangVariantLct());
        stmt.bindLong(9, value.getLangVariantUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO LanguageVariantReplicate(lvPk, lvDestination)\n"
                + "      SELECT DISTINCT LanguageVariant.langVariantUid AS lvPk,\n"
                + "             ? AS lvDestination\n"
                + "        FROM LanguageVariant\n"
                + "       WHERE LanguageVariant.langVariantLct != COALESCE(\n"
                + "             (SELECT lvVersionId\n"
                + "                FROM LanguageVariantReplicate\n"
                + "               WHERE lvPk = LanguageVariant.langVariantUid\n"
                + "                 AND lvDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(lvPk, lvDestination) DO UPDATE\n"
                + "             SET lvPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO LanguageVariantReplicate(lvPk, lvDestination)\n"
                + "  SELECT DISTINCT LanguageVariant.langVariantUid AS lvUid,\n"
                + "         UserSession.usClientNodeId AS lvDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN LanguageVariant\n"
                + "             ON ChangeLog.chTableId = 10\n"
                + "                AND ChangeLog.chEntityPk = LanguageVariant.langVariantUid\n"
                + "         JOIN UserSession ON UserSession.usStatus = 1\n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND LanguageVariant.langVariantLct != COALESCE(\n"
                + "         (SELECT lvVersionId\n"
                + "            FROM LanguageVariantReplicate\n"
                + "           WHERE lvPk = LanguageVariant.langVariantUid\n"
                + "             AND lvDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(lvPk, lvDestination) DO UPDATE\n"
                + "     SET lvPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final LanguageVariant entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfLanguageVariant.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final LanguageVariant entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfLanguageVariant.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends LanguageVariant> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfLanguageVariant.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends LanguageVariant> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfLanguageVariant.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final LanguageVariant entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfLanguageVariant.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public LanguageVariant findByCode(final String countryCode) {
    final String _sql = "SELECT * FROM LanguageVariant WHERE countryCode = ? LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (countryCode == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, countryCode);
    }
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfLangVariantUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langVariantUid");
      final int _cursorIndexOfLangUid = CursorUtil.getColumnIndexOrThrow(_cursor, "langUid");
      final int _cursorIndexOfCountryCode = CursorUtil.getColumnIndexOrThrow(_cursor, "countryCode");
      final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
      final int _cursorIndexOfLangVariantLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langVariantLocalChangeSeqNum");
      final int _cursorIndexOfLangVariantMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "langVariantMasterChangeSeqNum");
      final int _cursorIndexOfLangVariantLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "langVariantLastChangedBy");
      final int _cursorIndexOfLangVariantLct = CursorUtil.getColumnIndexOrThrow(_cursor, "langVariantLct");
      final LanguageVariant _result;
      if(_cursor.moveToFirst()) {
        _result = new LanguageVariant();
        final long _tmpLangVariantUid;
        _tmpLangVariantUid = _cursor.getLong(_cursorIndexOfLangVariantUid);
        _result.setLangVariantUid(_tmpLangVariantUid);
        final long _tmpLangUid;
        _tmpLangUid = _cursor.getLong(_cursorIndexOfLangUid);
        _result.setLangUid(_tmpLangUid);
        final String _tmpCountryCode;
        if (_cursor.isNull(_cursorIndexOfCountryCode)) {
          _tmpCountryCode = null;
        } else {
          _tmpCountryCode = _cursor.getString(_cursorIndexOfCountryCode);
        }
        _result.setCountryCode(_tmpCountryCode);
        final String _tmpName;
        if (_cursor.isNull(_cursorIndexOfName)) {
          _tmpName = null;
        } else {
          _tmpName = _cursor.getString(_cursorIndexOfName);
        }
        _result.setName(_tmpName);
        final long _tmpLangVariantLocalChangeSeqNum;
        _tmpLangVariantLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfLangVariantLocalChangeSeqNum);
        _result.setLangVariantLocalChangeSeqNum(_tmpLangVariantLocalChangeSeqNum);
        final long _tmpLangVariantMasterChangeSeqNum;
        _tmpLangVariantMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfLangVariantMasterChangeSeqNum);
        _result.setLangVariantMasterChangeSeqNum(_tmpLangVariantMasterChangeSeqNum);
        final int _tmpLangVariantLastChangedBy;
        _tmpLangVariantLastChangedBy = _cursor.getInt(_cursorIndexOfLangVariantLastChangedBy);
        _result.setLangVariantLastChangedBy(_tmpLangVariantLastChangedBy);
        final long _tmpLangVariantLct;
        _tmpLangVariantLct = _cursor.getLong(_cursorIndexOfLangVariantLct);
        _result.setLangVariantLct(_tmpLangVariantLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
