package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.LeavingReason;
import com.ustadmobile.lib.db.entities.UidAndLabel;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class LeavingReasonDao_Impl extends LeavingReasonDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<LeavingReason> __insertionAdapterOfLeavingReason;

  private final EntityInsertionAdapter<LeavingReason> __insertionAdapterOfLeavingReason_1;

  private final EntityDeletionOrUpdateAdapter<LeavingReason> __updateAdapterOfLeavingReason;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public LeavingReasonDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfLeavingReason = new EntityInsertionAdapter<LeavingReason>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `LeavingReason` (`leavingReasonUid`,`leavingReasonTitle`,`leavingReasonMCSN`,`leavingReasonCSN`,`leavingReasonLCB`,`leavingReasonLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, LeavingReason value) {
        stmt.bindLong(1, value.getLeavingReasonUid());
        if (value.getLeavingReasonTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getLeavingReasonTitle());
        }
        stmt.bindLong(3, value.getLeavingReasonMCSN());
        stmt.bindLong(4, value.getLeavingReasonCSN());
        stmt.bindLong(5, value.getLeavingReasonLCB());
        stmt.bindLong(6, value.getLeavingReasonLct());
      }
    };
    this.__insertionAdapterOfLeavingReason_1 = new EntityInsertionAdapter<LeavingReason>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `LeavingReason` (`leavingReasonUid`,`leavingReasonTitle`,`leavingReasonMCSN`,`leavingReasonCSN`,`leavingReasonLCB`,`leavingReasonLct`) VALUES (nullif(?, 0),?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, LeavingReason value) {
        stmt.bindLong(1, value.getLeavingReasonUid());
        if (value.getLeavingReasonTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getLeavingReasonTitle());
        }
        stmt.bindLong(3, value.getLeavingReasonMCSN());
        stmt.bindLong(4, value.getLeavingReasonCSN());
        stmt.bindLong(5, value.getLeavingReasonLCB());
        stmt.bindLong(6, value.getLeavingReasonLct());
      }
    };
    this.__updateAdapterOfLeavingReason = new EntityDeletionOrUpdateAdapter<LeavingReason>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `LeavingReason` SET `leavingReasonUid` = ?,`leavingReasonTitle` = ?,`leavingReasonMCSN` = ?,`leavingReasonCSN` = ?,`leavingReasonLCB` = ?,`leavingReasonLct` = ? WHERE `leavingReasonUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, LeavingReason value) {
        stmt.bindLong(1, value.getLeavingReasonUid());
        if (value.getLeavingReasonTitle() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getLeavingReasonTitle());
        }
        stmt.bindLong(3, value.getLeavingReasonMCSN());
        stmt.bindLong(4, value.getLeavingReasonCSN());
        stmt.bindLong(5, value.getLeavingReasonLCB());
        stmt.bindLong(6, value.getLeavingReasonLct());
        stmt.bindLong(7, value.getLeavingReasonUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "         REPLACE INTO LeavingReasonReplicate(lrPk, lrDestination)\n"
                + "          SELECT DISTINCT LeavingReason.leavingReasonUid AS lrPk,\n"
                + "                 ? AS lrDestination\n"
                + "            FROM LeavingReason\n"
                + "           WHERE LeavingReason.leavingReasonLct != COALESCE(\n"
                + "                 (SELECT lrVersionId\n"
                + "                    FROM LeavingReasonReplicate\n"
                + "                   WHERE lrPk = LeavingReason.leavingReasonUid\n"
                + "                     AND lrDestination = ?), 0) \n"
                + "          /*psql ON CONFLICT(lrPk, lrDestination) DO UPDATE\n"
                + "                 SET lrPending = true\n"
                + "          */       \n"
                + "     ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO LeavingReasonReplicate(lrPk, lrDestination)\n"
                + "  SELECT DISTINCT LeavingReason.leavingReasonUid AS lrUid,\n"
                + "         UserSession.usClientNodeId AS lrDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN LeavingReason\n"
                + "              ON ChangeLog.chTableId = 410\n"
                + "                 AND ChangeLog.chEntityPk = LeavingReason.leavingReasonUid\n"
                + "         JOIN UserSession \n"
                + "              ON UserSession.usStatus = 1\n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND LeavingReason.leavingReasonLct != COALESCE(\n"
                + "         (SELECT lrVersionId\n"
                + "            FROM LeavingReasonReplicate\n"
                + "           WHERE lrPk = LeavingReason.leavingReasonUid\n"
                + "             AND lrDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(lrPk, lrDestination) DO UPDATE\n"
                + "     SET lrPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final LeavingReason entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfLeavingReason.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final LeavingReason entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfLeavingReason.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends LeavingReason> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfLeavingReason.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replaceList(final List<LeavingReason> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfLeavingReason_1.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void updateList(final List<? extends LeavingReason> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfLeavingReason.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final LeavingReason entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfLeavingReason.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final LeavingReason entity,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfLeavingReason.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, LeavingReason> findAllReasons() {
    final String _sql = "SELECT * FROM LeavingReason";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return new DataSource.Factory<Integer, LeavingReason>() {
      @Override
      public LimitOffsetDataSource<LeavingReason> create() {
        return new LimitOffsetDataSource<LeavingReason>(__db, _statement, false, true , "LeavingReason") {
          @Override
          protected List<LeavingReason> convertRows(Cursor cursor) {
            final int _cursorIndexOfLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonUid");
            final int _cursorIndexOfLeavingReasonTitle = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonTitle");
            final int _cursorIndexOfLeavingReasonMCSN = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonMCSN");
            final int _cursorIndexOfLeavingReasonCSN = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonCSN");
            final int _cursorIndexOfLeavingReasonLCB = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonLCB");
            final int _cursorIndexOfLeavingReasonLct = CursorUtil.getColumnIndexOrThrow(cursor, "leavingReasonLct");
            final List<LeavingReason> _res = new ArrayList<LeavingReason>(cursor.getCount());
            while(cursor.moveToNext()) {
              final LeavingReason _item;
              _item = new LeavingReason();
              final long _tmpLeavingReasonUid;
              _tmpLeavingReasonUid = cursor.getLong(_cursorIndexOfLeavingReasonUid);
              _item.setLeavingReasonUid(_tmpLeavingReasonUid);
              final String _tmpLeavingReasonTitle;
              if (cursor.isNull(_cursorIndexOfLeavingReasonTitle)) {
                _tmpLeavingReasonTitle = null;
              } else {
                _tmpLeavingReasonTitle = cursor.getString(_cursorIndexOfLeavingReasonTitle);
              }
              _item.setLeavingReasonTitle(_tmpLeavingReasonTitle);
              final long _tmpLeavingReasonMCSN;
              _tmpLeavingReasonMCSN = cursor.getLong(_cursorIndexOfLeavingReasonMCSN);
              _item.setLeavingReasonMCSN(_tmpLeavingReasonMCSN);
              final long _tmpLeavingReasonCSN;
              _tmpLeavingReasonCSN = cursor.getLong(_cursorIndexOfLeavingReasonCSN);
              _item.setLeavingReasonCSN(_tmpLeavingReasonCSN);
              final int _tmpLeavingReasonLCB;
              _tmpLeavingReasonLCB = cursor.getInt(_cursorIndexOfLeavingReasonLCB);
              _item.setLeavingReasonLCB(_tmpLeavingReasonLCB);
              final long _tmpLeavingReasonLct;
              _tmpLeavingReasonLct = cursor.getLong(_cursorIndexOfLeavingReasonLct);
              _item.setLeavingReasonLct(_tmpLeavingReasonLct);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public List<LeavingReason> findAllReasonsLive() {
    final String _sql = "SELECT * FROM LeavingReason";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonUid");
      final int _cursorIndexOfLeavingReasonTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonTitle");
      final int _cursorIndexOfLeavingReasonMCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonMCSN");
      final int _cursorIndexOfLeavingReasonCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonCSN");
      final int _cursorIndexOfLeavingReasonLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLCB");
      final int _cursorIndexOfLeavingReasonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLct");
      final List<LeavingReason> _result = new ArrayList<LeavingReason>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final LeavingReason _item;
        _item = new LeavingReason();
        final long _tmpLeavingReasonUid;
        _tmpLeavingReasonUid = _cursor.getLong(_cursorIndexOfLeavingReasonUid);
        _item.setLeavingReasonUid(_tmpLeavingReasonUid);
        final String _tmpLeavingReasonTitle;
        if (_cursor.isNull(_cursorIndexOfLeavingReasonTitle)) {
          _tmpLeavingReasonTitle = null;
        } else {
          _tmpLeavingReasonTitle = _cursor.getString(_cursorIndexOfLeavingReasonTitle);
        }
        _item.setLeavingReasonTitle(_tmpLeavingReasonTitle);
        final long _tmpLeavingReasonMCSN;
        _tmpLeavingReasonMCSN = _cursor.getLong(_cursorIndexOfLeavingReasonMCSN);
        _item.setLeavingReasonMCSN(_tmpLeavingReasonMCSN);
        final long _tmpLeavingReasonCSN;
        _tmpLeavingReasonCSN = _cursor.getLong(_cursorIndexOfLeavingReasonCSN);
        _item.setLeavingReasonCSN(_tmpLeavingReasonCSN);
        final int _tmpLeavingReasonLCB;
        _tmpLeavingReasonLCB = _cursor.getInt(_cursorIndexOfLeavingReasonLCB);
        _item.setLeavingReasonLCB(_tmpLeavingReasonLCB);
        final long _tmpLeavingReasonLct;
        _tmpLeavingReasonLct = _cursor.getLong(_cursorIndexOfLeavingReasonLct);
        _item.setLeavingReasonLct(_tmpLeavingReasonLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super LeavingReason> continuation) {
    final String _sql = "SELECT * FROM LeavingReason WHERE leavingReasonUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<LeavingReason>() {
      @Override
      public LeavingReason call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonUid");
          final int _cursorIndexOfLeavingReasonTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonTitle");
          final int _cursorIndexOfLeavingReasonMCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonMCSN");
          final int _cursorIndexOfLeavingReasonCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonCSN");
          final int _cursorIndexOfLeavingReasonLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLCB");
          final int _cursorIndexOfLeavingReasonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLct");
          final LeavingReason _result;
          if(_cursor.moveToFirst()) {
            _result = new LeavingReason();
            final long _tmpLeavingReasonUid;
            _tmpLeavingReasonUid = _cursor.getLong(_cursorIndexOfLeavingReasonUid);
            _result.setLeavingReasonUid(_tmpLeavingReasonUid);
            final String _tmpLeavingReasonTitle;
            if (_cursor.isNull(_cursorIndexOfLeavingReasonTitle)) {
              _tmpLeavingReasonTitle = null;
            } else {
              _tmpLeavingReasonTitle = _cursor.getString(_cursorIndexOfLeavingReasonTitle);
            }
            _result.setLeavingReasonTitle(_tmpLeavingReasonTitle);
            final long _tmpLeavingReasonMCSN;
            _tmpLeavingReasonMCSN = _cursor.getLong(_cursorIndexOfLeavingReasonMCSN);
            _result.setLeavingReasonMCSN(_tmpLeavingReasonMCSN);
            final long _tmpLeavingReasonCSN;
            _tmpLeavingReasonCSN = _cursor.getLong(_cursorIndexOfLeavingReasonCSN);
            _result.setLeavingReasonCSN(_tmpLeavingReasonCSN);
            final int _tmpLeavingReasonLCB;
            _tmpLeavingReasonLCB = _cursor.getInt(_cursorIndexOfLeavingReasonLCB);
            _result.setLeavingReasonLCB(_tmpLeavingReasonLCB);
            final long _tmpLeavingReasonLct;
            _tmpLeavingReasonLct = _cursor.getLong(_cursorIndexOfLeavingReasonLct);
            _result.setLeavingReasonLct(_tmpLeavingReasonLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidList(final List<Long> uidList,
      final Continuation<? super List<Long>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT leavingReasonUid FROM LeavingReason WHERE leavingReasonUid IN (");
    final int _inputSize = uidList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : uidList) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Long>>() {
      @Override
      public List<Long> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Long _item_1;
            _item_1 = _cursor.getLong(0);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<LeavingReason> findByUidLive(final long uid) {
    final String _sql = "SELECT * FROM LeavingReason WHERE leavingReasonUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"LeavingReason"}, false, new Callable<LeavingReason>() {
      @Override
      public LeavingReason call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfLeavingReasonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonUid");
          final int _cursorIndexOfLeavingReasonTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonTitle");
          final int _cursorIndexOfLeavingReasonMCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonMCSN");
          final int _cursorIndexOfLeavingReasonCSN = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonCSN");
          final int _cursorIndexOfLeavingReasonLCB = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLCB");
          final int _cursorIndexOfLeavingReasonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "leavingReasonLct");
          final LeavingReason _result;
          if(_cursor.moveToFirst()) {
            _result = new LeavingReason();
            final long _tmpLeavingReasonUid;
            _tmpLeavingReasonUid = _cursor.getLong(_cursorIndexOfLeavingReasonUid);
            _result.setLeavingReasonUid(_tmpLeavingReasonUid);
            final String _tmpLeavingReasonTitle;
            if (_cursor.isNull(_cursorIndexOfLeavingReasonTitle)) {
              _tmpLeavingReasonTitle = null;
            } else {
              _tmpLeavingReasonTitle = _cursor.getString(_cursorIndexOfLeavingReasonTitle);
            }
            _result.setLeavingReasonTitle(_tmpLeavingReasonTitle);
            final long _tmpLeavingReasonMCSN;
            _tmpLeavingReasonMCSN = _cursor.getLong(_cursorIndexOfLeavingReasonMCSN);
            _result.setLeavingReasonMCSN(_tmpLeavingReasonMCSN);
            final long _tmpLeavingReasonCSN;
            _tmpLeavingReasonCSN = _cursor.getLong(_cursorIndexOfLeavingReasonCSN);
            _result.setLeavingReasonCSN(_tmpLeavingReasonCSN);
            final int _tmpLeavingReasonLCB;
            _tmpLeavingReasonLCB = _cursor.getInt(_cursorIndexOfLeavingReasonLCB);
            _result.setLeavingReasonLCB(_tmpLeavingReasonLCB);
            final long _tmpLeavingReasonLct;
            _tmpLeavingReasonLct = _cursor.getLong(_cursorIndexOfLeavingReasonLct);
            _result.setLeavingReasonLct(_tmpLeavingReasonLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getReasonsFromUids(final List<Long> uidList,
      final Continuation<? super List<UidAndLabel>> continuation) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT LeavingReason.leavingReasonUid AS uid, ");
    _stringBuilder.append("\n");
    _stringBuilder.append("            LeavingReason.leavingReasonTitle As labelName  ");
    _stringBuilder.append("\n");
    _stringBuilder.append("            FROM LeavingReason WHERE leavingReasonUid IN (");
    final int _inputSize = uidList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : uidList) {
      _statement.bindLong(_argIndex, _item);
      _argIndex ++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<UidAndLabel>>() {
      @Override
      public List<UidAndLabel> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfUid = 0;
          final int _cursorIndexOfLabelName = 1;
          final List<UidAndLabel> _result = new ArrayList<UidAndLabel>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final UidAndLabel _item_1;
            _item_1 = new UidAndLabel();
            final long _tmpUid;
            _tmpUid = _cursor.getLong(_cursorIndexOfUid);
            _item_1.setUid(_tmpUid);
            final String _tmpLabelName;
            if (_cursor.isNull(_cursorIndexOfLabelName)) {
              _tmpLabelName = null;
            } else {
              _tmpLabelName = _cursor.getString(_cursorIndexOfLabelName);
            }
            _item_1.setLabelName(_tmpLabelName);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
