package com.ustadmobile.core.db.dao

import com.ustadmobile.door.attachments.storeAttachment
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionAttachment
import com.ustadmobile.lib.db.entities.asEntityWithAttachment
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List
import kotlinx.coroutines.runBlocking

public class CourseAssignmentSubmissionAttachmentDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: CourseAssignmentSubmissionAttachmentDao,
) : CourseAssignmentSubmissionAttachmentDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override suspend
      fun insertListAsync(entityList: List<CourseAssignmentSubmissionAttachment>): Unit {
    entityList.forEach {
      _db.storeAttachment(it.asEntityWithAttachment())
    }
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.casaUid == 0L) {
        val _newPk = _pkManager.nextIdAsync(90)
        it.casaUid = _newPk
        _generatedPks += _newPk
      }
      it.casaTimestamp = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertListAsync(entityList)
  }

  public override fun insert(entity: CourseAssignmentSubmissionAttachment): Long {
    runBlocking {
      _db.storeAttachment(entity.asEntityWithAttachment())
    }
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.casaUid == 0L) {
      val _newPk = _pkManager.nextId(90)
      entity.casaUid = _newPk
    }
    entity.casaTimestamp = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.casaUid
  }

  public override suspend fun insertAsync(entity: CourseAssignmentSubmissionAttachment): Long {
    _db.storeAttachment(entity.asEntityWithAttachment())
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.casaUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(90)
      entity.casaUid = _newPk
    }
    entity.casaTimestamp = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.casaUid
  }

  public override fun insertList(entityList: List<CourseAssignmentSubmissionAttachment>): Unit {
    runBlocking {
      entityList.forEach {
        _db.storeAttachment(it.asEntityWithAttachment())
      }
    }
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.casaUid == 0L) {
        val _newPk = _pkManager.nextId(90)
        it.casaUid = _newPk
        _generatedPks += _newPk
      }
      it.casaTimestamp = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<CourseAssignmentSubmissionAttachment>): Unit {
    runBlocking {
      entityList.forEach {
        _db.storeAttachment(it.asEntityWithAttachment())
      }
    }
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.casaTimestamp = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: CourseAssignmentSubmissionAttachment): Unit {
    runBlocking {
      _db.storeAttachment(entity.asEntityWithAttachment())
    }
    entity.casaTimestamp = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
