package com.ustadmobile.core.db.dao

import androidx.paging.DataSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.LearnerGroup
import kotlin.Int
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

public class LearnerGroupDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: LearnerGroupDao,
) : LearnerGroupDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun findGroupsForEntryAsync(contentEntryUid: Long):
      DataSource.Factory<Int, LearnerGroup> = _dao.findGroupsForEntryAsync(contentEntryUid)

  public override fun findGroupListForEntry(contentEntryUid: Long): List<LearnerGroup> =
      _dao.findGroupListForEntry(contentEntryUid)

  public override fun insert(entity: LearnerGroup): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.learnerGroupUid == 0L) {
      val _newPk = _pkManager.nextId(301)
      entity.learnerGroupUid = _newPk
    }
    entity.learnerGroupLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.learnerGroupUid
  }

  public override suspend fun insertAsync(entity: LearnerGroup): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.learnerGroupUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(301)
      entity.learnerGroupUid = _newPk
    }
    entity.learnerGroupLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.learnerGroupUid
  }

  public override fun insertList(entityList: List<LearnerGroup>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.learnerGroupUid == 0L) {
        val _newPk = _pkManager.nextId(301)
        it.learnerGroupUid = _newPk
        _generatedPks += _newPk
      }
      it.learnerGroupLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<LearnerGroup>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.learnerGroupLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: LearnerGroup): Unit {
    entity.learnerGroupLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
