package com.ustadmobile.core.db.dao

import androidx.paging.DataSource
import com.ustadmobile.door.DoorDatabaseRepository
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.lib.db.entities.LearnerGroupMember
import com.ustadmobile.lib.db.entities.LearnerGroupMemberWithPerson
import io.ktor.client.HttpClient
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

@Suppress("REDUNDANT_PROJECTION", "LocalVariableName", "ClassName")
public class LearnerGroupMemberDao_Repo(
  public val _db: RoomDatabase,
  public val _repo: DoorDatabaseRepository,
  public val _dao: LearnerGroupMemberDao,
  public val _httpClient: HttpClient,
  public val _clientId: Long,
  public val _endpoint: String,
) : LearnerGroupMemberDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun findLearnerGroupMembersByGroupIdAndEntry(learnerGroupUid: Long,
      contentEntryUid: Long): DataSource.Factory<Int, LearnerGroupMemberWithPerson> {
    val _result = _dao.findLearnerGroupMembersByGroupIdAndEntry(learnerGroupUid, contentEntryUid)
    return _result
  }

  public override suspend fun findLearnerGroupMembersByGroupIdAndEntryList(learnerGroupUid: Long,
      contentEntryUid: Long): List<LearnerGroupMemberWithPerson> {
    val _result = _dao.findLearnerGroupMembersByGroupIdAndEntryList(learnerGroupUid,
        contentEntryUid)
    return _result
  }

  public override fun insert(entity: LearnerGroupMember): Long {
    val _result = _dao.insert(entity)
    return _result
  }

  public override suspend fun insertAsync(entity: LearnerGroupMember): Long {
    val _result = _dao.insertAsync(entity)
    return _result
  }

  public override fun insertList(entityList: List<LearnerGroupMember>): Unit {
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<LearnerGroupMember>): Unit {
    _dao.updateList(entityList)
  }

  public override fun update(entity: LearnerGroupMember): Unit {
    _dao.update(entity)
  }
}
