package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Query
import com.ustadmobile.lib.db.entities.MessageRead
import kotlin.Long
import kotlin.Unit

@Dao
public actual abstract class MessageReadDao : BaseDao<MessageRead> {
  @Query(`value` =
      "\n     REPLACE INTO MessageReadReplicate(messageReadPk, messageReadDestination)\n      SELECT DISTINCT MessageRead.messageReadUid AS messageReadPk,\n             :newNodeId AS messageReadDestination\n        FROM UserSession \n              JOIN Message ON\n                  ((    Message.messageTableId = 127\n                    AND Message.messageEntityUid IN\n                        (SELECT ChatMember.chatMemberChatUid \n                          FROM ChatMember\n                         WHERE ChatMember.chatMemberPersonUid = UserSession.usPersonUid))\n                  OR UserSession.usSessionType = 2)\n                  \n              JOIN MessageRead \n                   ON MessageRead.messageReadMessageUid = Message.messageUid\n                   \n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND MessageRead.messageReadLct != COALESCE(\n             (SELECT messageReadVersionId\n                FROM MessageReadReplicate\n               WHERE messageReadPk = MessageRead.messageReadUid\n                 AND messageReadDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(messageReadPk, messageReadDestination) DO UPDATE\n             SET messageReadPending = true\n      */       \n    ")
  public actual abstract suspend fun replicateOnNewNodeChats(newNodeId: Long): Unit

  @Query(`value` =
      "\n         REPLACE INTO MessageReadReplicate(messageReadPk, messageReadDestination)\n          SELECT DISTINCT MessageRead.messageReadUid AS messageReadUid,\n                 UserSession.usClientNodeId AS messageReadDestination\n            FROM ChangeLog\n            \n                 JOIN MessageRead \n                      ON MessageRead.messageReadUid = ChangeLog.chEntityPk\n                         AND ChangeLog.chTableId = 129\n                         \n\n                 JOIN UserSession ON\n                      ((UserSession.usPersonUid IN \n                           (SELECT ChatMember.chatMemberPersonUid\n                              FROM ChatMember\n                             WHERE ChatMember.chatMemberChatUid = MessageRead.messageReadEntityUid))\n                       OR UserSession.usSessionType = 2)\n                   \n           WHERE UserSession.usStatus = 1\n             AND UserSession.usClientNodeId != (\n                 SELECT nodeClientId \n                   FROM SyncNode\n                  LIMIT 1)\n             AND MessageRead.messageReadLct != COALESCE(\n                 (SELECT messageReadVersionId\n                    FROM MessageReadReplicate\n                   WHERE messageReadPk = MessageRead.messageReadUid\n                     AND messageReadDestination = UserSession.usClientNodeId), 0)\n         /*psql ON CONFLICT(messageReadPk, messageReadDestination) DO UPDATE\n             SET messageReadPending = true\n          */               \n    ")
  public actual abstract suspend fun replicateOnChange(): Unit
}
