package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.door.SyncNode
import kotlin.Long
import kotlin.Unit

@Dao
public actual abstract class SyncNodeDao {
  @Insert(onConflict = 1)
  public actual abstract fun replace(syncNode: SyncNode): Unit

  @Query(`value` =
      "\n        SELECT COALESCE(\n               (SELECT nodeClientId \n                  FROM SyncNode \n                 LIMIT 1), 0)\n    ")
  public actual abstract suspend fun getLocalNodeClientId(): Long
}
