package com.ustadmobile.core.db;

import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomOpenHelper;
import androidx.room.RoomOpenHelper.Delegate;
import androidx.room.RoomOpenHelper.ValidationResult;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.room.util.TableInfo.Column;
import androidx.room.util.TableInfo.ForeignKey;
import androidx.room.util.TableInfo.Index;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.SupportSQLiteOpenHelper.Callback;
import androidx.sqlite.db.SupportSQLiteOpenHelper.Configuration;
import com.ustadmobile.core.db.dao.AgentDao;
import com.ustadmobile.core.db.dao.AgentDao_Impl;
import com.ustadmobile.core.db.dao.ChatDao;
import com.ustadmobile.core.db.dao.ChatDao_Impl;
import com.ustadmobile.core.db.dao.ChatMemberDao;
import com.ustadmobile.core.db.dao.ChatMemberDao_Impl;
import com.ustadmobile.core.db.dao.ClazzAssignmentContentJoinDao;
import com.ustadmobile.core.db.dao.ClazzAssignmentContentJoinDao_Impl;
import com.ustadmobile.core.db.dao.ClazzAssignmentDao;
import com.ustadmobile.core.db.dao.ClazzAssignmentDao_Impl;
import com.ustadmobile.core.db.dao.ClazzAssignmentRollUpDao;
import com.ustadmobile.core.db.dao.ClazzAssignmentRollUpDao_Impl;
import com.ustadmobile.core.db.dao.ClazzContentJoinDao;
import com.ustadmobile.core.db.dao.ClazzContentJoinDao_Impl;
import com.ustadmobile.core.db.dao.ClazzDao;
import com.ustadmobile.core.db.dao.ClazzDao_Impl;
import com.ustadmobile.core.db.dao.ClazzEnrolmentDao;
import com.ustadmobile.core.db.dao.ClazzEnrolmentDao_Impl;
import com.ustadmobile.core.db.dao.ClazzLogAttendanceRecordDao;
import com.ustadmobile.core.db.dao.ClazzLogAttendanceRecordDao_Impl;
import com.ustadmobile.core.db.dao.ClazzLogDao;
import com.ustadmobile.core.db.dao.ClazzLogDao_Impl;
import com.ustadmobile.core.db.dao.CommentsDao;
import com.ustadmobile.core.db.dao.CommentsDao_Impl;
import com.ustadmobile.core.db.dao.ConnectivityStatusDao;
import com.ustadmobile.core.db.dao.ConnectivityStatusDao_Impl;
import com.ustadmobile.core.db.dao.ContainerDao;
import com.ustadmobile.core.db.dao.ContainerDao_Impl;
import com.ustadmobile.core.db.dao.ContainerETagDao;
import com.ustadmobile.core.db.dao.ContainerETagDao_Impl;
import com.ustadmobile.core.db.dao.ContainerEntryDao;
import com.ustadmobile.core.db.dao.ContainerEntryDao_Impl;
import com.ustadmobile.core.db.dao.ContainerEntryFileDao;
import com.ustadmobile.core.db.dao.ContainerEntryFileDao_Impl;
import com.ustadmobile.core.db.dao.ContainerImportJobDao;
import com.ustadmobile.core.db.dao.ContainerImportJobDao_Impl;
import com.ustadmobile.core.db.dao.ContentCategoryDao;
import com.ustadmobile.core.db.dao.ContentCategoryDao_Impl;
import com.ustadmobile.core.db.dao.ContentCategorySchemaDao;
import com.ustadmobile.core.db.dao.ContentCategorySchemaDao_Impl;
import com.ustadmobile.core.db.dao.ContentEntryContentCategoryJoinDao;
import com.ustadmobile.core.db.dao.ContentEntryContentCategoryJoinDao_Impl;
import com.ustadmobile.core.db.dao.ContentEntryDao;
import com.ustadmobile.core.db.dao.ContentEntryDao_Impl;
import com.ustadmobile.core.db.dao.ContentEntryParentChildJoinDao;
import com.ustadmobile.core.db.dao.ContentEntryParentChildJoinDao_Impl;
import com.ustadmobile.core.db.dao.ContentEntryPictureDao;
import com.ustadmobile.core.db.dao.ContentEntryPictureDao_Impl;
import com.ustadmobile.core.db.dao.ContentEntryRelatedEntryJoinDao;
import com.ustadmobile.core.db.dao.ContentEntryRelatedEntryJoinDao_Impl;
import com.ustadmobile.core.db.dao.ContentJobDao;
import com.ustadmobile.core.db.dao.ContentJobDao_Impl;
import com.ustadmobile.core.db.dao.ContentJobItemDao;
import com.ustadmobile.core.db.dao.ContentJobItemDao_Impl;
import com.ustadmobile.core.db.dao.ContextXObjectStatementJoinDao;
import com.ustadmobile.core.db.dao.ContextXObjectStatementJoinDao_Impl;
import com.ustadmobile.core.db.dao.CourseAssignmentMarkDao;
import com.ustadmobile.core.db.dao.CourseAssignmentMarkDao_Impl;
import com.ustadmobile.core.db.dao.CourseAssignmentSubmissionAttachmentDao;
import com.ustadmobile.core.db.dao.CourseAssignmentSubmissionAttachmentDao_Impl;
import com.ustadmobile.core.db.dao.CourseAssignmentSubmissionDao;
import com.ustadmobile.core.db.dao.CourseAssignmentSubmissionDao_Impl;
import com.ustadmobile.core.db.dao.CourseBlockDao;
import com.ustadmobile.core.db.dao.CourseBlockDao_Impl;
import com.ustadmobile.core.db.dao.CourseDiscussionDao;
import com.ustadmobile.core.db.dao.CourseDiscussionDao_Impl;
import com.ustadmobile.core.db.dao.CourseGroupMemberDao;
import com.ustadmobile.core.db.dao.CourseGroupMemberDao_Impl;
import com.ustadmobile.core.db.dao.CourseGroupSetDao;
import com.ustadmobile.core.db.dao.CourseGroupSetDao_Impl;
import com.ustadmobile.core.db.dao.CoursePictureDao;
import com.ustadmobile.core.db.dao.CoursePictureDao_Impl;
import com.ustadmobile.core.db.dao.CourseTerminologyDao;
import com.ustadmobile.core.db.dao.CourseTerminologyDao_Impl;
import com.ustadmobile.core.db.dao.DiscussionPostDao;
import com.ustadmobile.core.db.dao.DiscussionPostDao_Impl;
import com.ustadmobile.core.db.dao.DiscussionTopicDao;
import com.ustadmobile.core.db.dao.DiscussionTopicDao_Impl;
import com.ustadmobile.core.db.dao.EntityRoleDao;
import com.ustadmobile.core.db.dao.EntityRoleDao_Impl;
import com.ustadmobile.core.db.dao.ErrorReportDao;
import com.ustadmobile.core.db.dao.ErrorReportDao_Impl;
import com.ustadmobile.core.db.dao.GroupLearningSessionDao;
import com.ustadmobile.core.db.dao.GroupLearningSessionDao_Impl;
import com.ustadmobile.core.db.dao.HolidayCalendarDao;
import com.ustadmobile.core.db.dao.HolidayCalendarDao_Impl;
import com.ustadmobile.core.db.dao.HolidayDao;
import com.ustadmobile.core.db.dao.HolidayDao_Impl;
import com.ustadmobile.core.db.dao.LanguageDao;
import com.ustadmobile.core.db.dao.LanguageDao_Impl;
import com.ustadmobile.core.db.dao.LanguageVariantDao;
import com.ustadmobile.core.db.dao.LanguageVariantDao_Impl;
import com.ustadmobile.core.db.dao.LearnerGroupDao;
import com.ustadmobile.core.db.dao.LearnerGroupDao_Impl;
import com.ustadmobile.core.db.dao.LearnerGroupMemberDao;
import com.ustadmobile.core.db.dao.LearnerGroupMemberDao_Impl;
import com.ustadmobile.core.db.dao.LeavingReasonDao;
import com.ustadmobile.core.db.dao.LeavingReasonDao_Impl;
import com.ustadmobile.core.db.dao.LocallyAvailableContainerDao;
import com.ustadmobile.core.db.dao.LocallyAvailableContainerDao_Impl;
import com.ustadmobile.core.db.dao.MessageDao;
import com.ustadmobile.core.db.dao.MessageDao_Impl;
import com.ustadmobile.core.db.dao.MessageReadDao;
import com.ustadmobile.core.db.dao.MessageReadDao_Impl;
import com.ustadmobile.core.db.dao.NetworkNodeDao;
import com.ustadmobile.core.db.dao.NetworkNodeDao_Impl;
import com.ustadmobile.core.db.dao.PersonAuth2Dao;
import com.ustadmobile.core.db.dao.PersonAuth2Dao_Impl;
import com.ustadmobile.core.db.dao.PersonAuthDao;
import com.ustadmobile.core.db.dao.PersonAuthDao_Impl;
import com.ustadmobile.core.db.dao.PersonDao;
import com.ustadmobile.core.db.dao.PersonDao_Impl;
import com.ustadmobile.core.db.dao.PersonGroupDao;
import com.ustadmobile.core.db.dao.PersonGroupDao_Impl;
import com.ustadmobile.core.db.dao.PersonGroupMemberDao;
import com.ustadmobile.core.db.dao.PersonGroupMemberDao_Impl;
import com.ustadmobile.core.db.dao.PersonParentJoinDao;
import com.ustadmobile.core.db.dao.PersonParentJoinDao_Impl;
import com.ustadmobile.core.db.dao.PersonPictureDao;
import com.ustadmobile.core.db.dao.PersonPictureDao_Impl;
import com.ustadmobile.core.db.dao.ReportDao;
import com.ustadmobile.core.db.dao.ReportDao_Impl;
import com.ustadmobile.core.db.dao.ScheduleDao;
import com.ustadmobile.core.db.dao.ScheduleDao_Impl;
import com.ustadmobile.core.db.dao.SchoolDao;
import com.ustadmobile.core.db.dao.SchoolDao_Impl;
import com.ustadmobile.core.db.dao.SchoolMemberDao;
import com.ustadmobile.core.db.dao.SchoolMemberDao_Impl;
import com.ustadmobile.core.db.dao.ScopedGrantDao;
import com.ustadmobile.core.db.dao.ScopedGrantDao_Impl;
import com.ustadmobile.core.db.dao.ScrapeQueueItemDao;
import com.ustadmobile.core.db.dao.ScrapeQueueItemDao_Impl;
import com.ustadmobile.core.db.dao.SiteDao;
import com.ustadmobile.core.db.dao.SiteDao_Impl;
import com.ustadmobile.core.db.dao.SiteTermsDao;
import com.ustadmobile.core.db.dao.SiteTermsDao_Impl;
import com.ustadmobile.core.db.dao.StateContentDao;
import com.ustadmobile.core.db.dao.StateContentDao_Impl;
import com.ustadmobile.core.db.dao.StateDao;
import com.ustadmobile.core.db.dao.StateDao_Impl;
import com.ustadmobile.core.db.dao.StatementDao;
import com.ustadmobile.core.db.dao.StatementDao_Impl;
import com.ustadmobile.core.db.dao.SyncNodeDao;
import com.ustadmobile.core.db.dao.SyncNodeDao_Impl;
import com.ustadmobile.core.db.dao.UserSessionDao;
import com.ustadmobile.core.db.dao.UserSessionDao_Impl;
import com.ustadmobile.core.db.dao.VerbDao;
import com.ustadmobile.core.db.dao.VerbDao_Impl;
import com.ustadmobile.core.db.dao.XLangMapEntryDao;
import com.ustadmobile.core.db.dao.XLangMapEntryDao_Impl;
import com.ustadmobile.core.db.dao.XObjectDao;
import com.ustadmobile.core.db.dao.XObjectDao_Impl;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SuppressWarnings({"unchecked", "deprecation"})
public final class UmAppDatabase_Impl extends UmAppDatabase {
  private volatile NetworkNodeDao _networkNodeDao;

  private volatile PersonDao _personDao;

  private volatile ClazzDao _clazzDao;

  private volatile CourseBlockDao _courseBlockDao;

  private volatile CourseTerminologyDao _courseTerminologyDao;

  private volatile CourseGroupSetDao _courseGroupSetDao;

  private volatile CourseGroupMemberDao _courseGroupMemberDao;

  private volatile ClazzEnrolmentDao _clazzEnrolmentDao;

  private volatile LeavingReasonDao _leavingReasonDao;

  private volatile ContentEntryDao _contentEntryDao;

  private volatile ContentEntryContentCategoryJoinDao _contentEntryContentCategoryJoinDao;

  private volatile ContentEntryParentChildJoinDao _contentEntryParentChildJoinDao;

  private volatile ContentEntryRelatedEntryJoinDao _contentEntryRelatedEntryJoinDao;

  private volatile ClazzContentJoinDao _clazzContentJoinDao;

  private volatile ContentCategorySchemaDao _contentCategorySchemaDao;

  private volatile ContentCategoryDao _contentCategoryDao;

  private volatile LanguageDao _languageDao;

  private volatile LanguageVariantDao _languageVariantDao;

  private volatile ScrapeQueueItemDao _scrapeQueueItemDao;

  private volatile PersonAuthDao _personAuthDao;

  private volatile PersonGroupDao _personGroupDao;

  private volatile PersonGroupMemberDao _personGroupMemberDao;

  private volatile EntityRoleDao _entityRoleDao;

  private volatile PersonPictureDao _personPictureDao;

  private volatile ConnectivityStatusDao _connectivityStatusDao;

  private volatile ContainerDao _containerDao;

  private volatile ContainerEntryDao _containerEntryDao;

  private volatile ContainerEntryFileDao _containerEntryFileDao;

  private volatile ContainerETagDao _containerETagDao;

  private volatile VerbDao _verbDao;

  private volatile XObjectDao _xObjectDao;

  private volatile ReportDao _reportDao;

  private volatile ContainerImportJobDao _containerImportJobDao;

  private volatile StatementDao _statementDao;

  private volatile ContextXObjectStatementJoinDao _contextXObjectStatementJoinDao;

  private volatile StateDao _stateDao;

  private volatile StateContentDao _stateContentDao;

  private volatile AgentDao _agentDao;

  private volatile LearnerGroupDao _learnerGroupDao;

  private volatile LearnerGroupMemberDao _learnerGroupMemberDao;

  private volatile GroupLearningSessionDao _groupLearningSessionDao;

  private volatile ClazzLogAttendanceRecordDao _clazzLogAttendanceRecordDao;

  private volatile ClazzLogDao _clazzLogDao;

  private volatile ScheduleDao _scheduleDao;

  private volatile HolidayCalendarDao _holidayCalendarDao;

  private volatile HolidayDao _holidayDao;

  private volatile SchoolDao _schoolDao;

  private volatile XLangMapEntryDao _xLangMapEntryDao;

  private volatile LocallyAvailableContainerDao _locallyAvailableContainerDao;

  private volatile SchoolMemberDao _schoolMemberDao;

  private volatile ClazzAssignmentDao _clazzAssignmentDao;

  private volatile ClazzAssignmentContentJoinDao _clazzAssignmentContentJoinDao;

  private volatile ClazzAssignmentRollUpDao _clazzAssignmentRollUpDao;

  private volatile CourseAssignmentSubmissionDao _courseAssignmentSubmissionDao;

  private volatile CourseAssignmentSubmissionAttachmentDao _courseAssignmentSubmissionAttachmentDao;

  private volatile CourseAssignmentMarkDao _courseAssignmentMarkDao;

  private volatile CommentsDao _commentsDao;

  private volatile SyncNodeDao _syncNodeDao;

  private volatile SiteDao _siteDao;

  private volatile SiteTermsDao _siteTermsDao;

  private volatile PersonParentJoinDao _personParentJoinDao;

  private volatile ScopedGrantDao _scopedGrantDao;

  private volatile ErrorReportDao _errorReportDao;

  private volatile PersonAuth2Dao _personAuth2Dao;

  private volatile UserSessionDao _userSessionDao;

  private volatile ContentJobItemDao _contentJobItemDao;

  private volatile ContentJobDao _contentJobDao;

  private volatile CoursePictureDao _coursePictureDao;

  private volatile ContentEntryPictureDao _contentEntryPictureDao;

  private volatile ChatDao _chatDao;

  private volatile ChatMemberDao _chatMemberDao;

  private volatile MessageDao _messageDao;

  private volatile MessageReadDao _messageReadDao;

  private volatile CourseDiscussionDao _courseDiscussionDao;

  private volatile DiscussionTopicDao _discussionTopicDao;

  private volatile DiscussionPostDao _discussionPostDao;

  @Override
  protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
    final SupportSQLiteOpenHelper.Callback _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(107) {
      @Override
      public void createAllTables(SupportSQLiteDatabase _db) {
        _db.execSQL("CREATE TABLE IF NOT EXISTS `NetworkNode` (`nodeId` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `bluetoothMacAddress` TEXT, `ipAddress` TEXT, `wifiDirectMacAddress` TEXT, `deviceWifiDirectName` TEXT, `endpointUrl` TEXT, `lastUpdateTimeStamp` INTEGER NOT NULL, `networkServiceLastUpdated` INTEGER NOT NULL, `nsdServiceName` TEXT, `port` INTEGER NOT NULL, `numFailureCount` INTEGER NOT NULL, `wifiDirectDeviceStatus` INTEGER NOT NULL, `groupSsid` TEXT)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_NetworkNode_bluetoothMacAddress` ON `NetworkNode` (`bluetoothMacAddress`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_NetworkNode_lastUpdateTimeStamp` ON `NetworkNode` (`lastUpdateTimeStamp`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ClazzLog` (`clazzLogUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `clazzLogClazzUid` INTEGER NOT NULL, `logDate` INTEGER NOT NULL, `timeRecorded` INTEGER NOT NULL, `clazzLogDone` INTEGER NOT NULL, `cancellationNote` TEXT, `clazzLogCancelled` INTEGER NOT NULL, `clazzLogNumPresent` INTEGER NOT NULL, `clazzLogNumAbsent` INTEGER NOT NULL, `clazzLogNumPartial` INTEGER NOT NULL, `clazzLogScheduleUid` INTEGER NOT NULL, `clazzLogStatusFlag` INTEGER NOT NULL, `clazzLogMSQN` INTEGER NOT NULL, `clazzLogLCSN` INTEGER NOT NULL, `clazzLogLCB` INTEGER NOT NULL, `clazzLogLastChangedTime` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ClazzLogAttendanceRecord` (`clazzLogAttendanceRecordUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `clazzLogAttendanceRecordClazzLogUid` INTEGER NOT NULL, `clazzLogAttendanceRecordPersonUid` INTEGER NOT NULL, `attendanceStatus` INTEGER NOT NULL, `clazzLogAttendanceRecordMasterChangeSeqNum` INTEGER NOT NULL, `clazzLogAttendanceRecordLocalChangeSeqNum` INTEGER NOT NULL, `clazzLogAttendanceRecordLastChangedBy` INTEGER NOT NULL, `clazzLogAttendanceRecordLastChangedTime` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `Schedule` (`scheduleUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `sceduleStartTime` INTEGER NOT NULL, `scheduleEndTime` INTEGER NOT NULL, `scheduleDay` INTEGER NOT NULL, `scheduleMonth` INTEGER NOT NULL, `scheduleFrequency` INTEGER NOT NULL, `umCalendarUid` INTEGER NOT NULL, `scheduleClazzUid` INTEGER NOT NULL, `scheduleMasterChangeSeqNum` INTEGER NOT NULL, `scheduleLocalChangeSeqNum` INTEGER NOT NULL, `scheduleLastChangedBy` INTEGER NOT NULL, `scheduleLastChangedTime` INTEGER NOT NULL, `scheduleActive` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `DateRange` (`dateRangeUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `dateRangeLocalChangeSeqNum` INTEGER NOT NULL, `dateRangeMasterChangeSeqNum` INTEGER NOT NULL, `dateRangLastChangedBy` INTEGER NOT NULL, `dateRangeLct` INTEGER NOT NULL, `dateRangeFromDate` INTEGER NOT NULL, `dateRangeToDate` INTEGER NOT NULL, `dateRangeUMCalendarUid` INTEGER NOT NULL, `dateRangeName` TEXT, `dateRangeDesc` TEXT, `dateRangeActive` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `HolidayCalendar` (`umCalendarUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `umCalendarName` TEXT, `umCalendarCategory` INTEGER NOT NULL, `umCalendarActive` INTEGER NOT NULL, `umCalendarMasterChangeSeqNum` INTEGER NOT NULL, `umCalendarLocalChangeSeqNum` INTEGER NOT NULL, `umCalendarLastChangedBy` INTEGER NOT NULL, `umCalendarLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `Holiday` (`holUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `holMasterCsn` INTEGER NOT NULL, `holLocalCsn` INTEGER NOT NULL, `holLastModBy` INTEGER NOT NULL, `holLct` INTEGER NOT NULL, `holActive` INTEGER NOT NULL, `holHolidayCalendarUid` INTEGER NOT NULL, `holStartTime` INTEGER NOT NULL, `holEndTime` INTEGER NOT NULL, `holName` TEXT)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ScheduledCheck` (`scheduledCheckUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `checkTime` INTEGER NOT NULL, `checkType` INTEGER NOT NULL, `checkUuid` TEXT, `checkParameters` TEXT, `scClazzLogUid` INTEGER NOT NULL, `scheduledCheckMasterCsn` INTEGER NOT NULL, `scheduledCheckLocalCsn` INTEGER NOT NULL, `scheduledCheckLastChangedBy` INTEGER NOT NULL, `scheduledCheckLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `AuditLog` (`auditLogUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `auditLogMasterChangeSeqNum` INTEGER NOT NULL, `auditLogLocalChangeSeqNum` INTEGER NOT NULL, `auditLogLastChangedBy` INTEGER NOT NULL, `auditLogLct` INTEGER NOT NULL, `auditLogActorPersonUid` INTEGER NOT NULL, `auditLogTableUid` INTEGER NOT NULL, `auditLogEntityUid` INTEGER NOT NULL, `auditLogDate` INTEGER NOT NULL, `notes` TEXT)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CustomField` (`customFieldUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `customFieldName` TEXT, `customFieldNameAlt` TEXT, `customFieldLabelMessageID` INTEGER NOT NULL, `customFieldIcon` TEXT, `customFieldIconId` INTEGER NOT NULL, `actionOnClick` TEXT, `customFieldType` INTEGER NOT NULL, `customFieldEntityType` INTEGER NOT NULL, `customFieldActive` INTEGER NOT NULL, `customFieldDefaultValue` TEXT, `customFieldMCSN` INTEGER NOT NULL, `customFieldLCSN` INTEGER NOT NULL, `customFieldLCB` INTEGER NOT NULL, `customFieldLct` INTEGER NOT NULL, `customFieldInputType` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CustomFieldValue` (`customFieldValueUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `customFieldValueFieldUid` INTEGER NOT NULL, `customFieldValueEntityUid` INTEGER NOT NULL, `customFieldValueValue` TEXT, `customFieldValueCustomFieldValueOptionUid` INTEGER NOT NULL, `customFieldValueMCSN` INTEGER NOT NULL, `customFieldValueLCSN` INTEGER NOT NULL, `customFieldValueLCB` INTEGER NOT NULL, `customFieldLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CustomFieldValueOption` (`customFieldValueOptionUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `customFieldValueOptionName` TEXT, `customFieldValueOptionFieldUid` INTEGER NOT NULL, `customFieldValueOptionIcon` TEXT, `customFieldValueOptionMessageId` INTEGER NOT NULL, `customFieldValueOptionActive` INTEGER NOT NULL, `customFieldValueOptionMCSN` INTEGER NOT NULL, `customFieldValueOptionLCSN` INTEGER NOT NULL, `customFieldValueOptionLCB` INTEGER NOT NULL, `customFieldValueLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `Person` (`personUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `username` TEXT, `firstNames` TEXT, `lastName` TEXT, `emailAddr` TEXT, `phoneNum` TEXT, `gender` INTEGER NOT NULL, `active` INTEGER NOT NULL, `admin` INTEGER NOT NULL, `personNotes` TEXT, `fatherName` TEXT, `fatherNumber` TEXT, `motherName` TEXT, `motherNum` TEXT, `dateOfBirth` INTEGER NOT NULL, `personAddress` TEXT, `personOrgId` TEXT, `personGroupUid` INTEGER NOT NULL, `personMasterChangeSeqNum` INTEGER NOT NULL, `personLocalChangeSeqNum` INTEGER NOT NULL, `personLastChangedBy` INTEGER NOT NULL, `personLct` INTEGER NOT NULL, `personCountry` TEXT, `personType` INTEGER NOT NULL DEFAULT 0)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `Clazz` (`clazzUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `clazzName` TEXT, `clazzDesc` TEXT, `attendanceAverage` REAL NOT NULL, `clazzHolidayUMCalendarUid` INTEGER NOT NULL, `clazzScheuleUMCalendarUid` INTEGER NOT NULL, `isClazzActive` INTEGER NOT NULL, `clazzLocationUid` INTEGER NOT NULL, `clazzStartTime` INTEGER NOT NULL, `clazzEndTime` INTEGER NOT NULL, `clazzFeatures` INTEGER NOT NULL, `clazzSchoolUid` INTEGER NOT NULL, `clazzEnrolmentPolicy` INTEGER NOT NULL DEFAULT 102, `clazzTerminologyUid` INTEGER NOT NULL DEFAULT 25966, `clazzMasterChangeSeqNum` INTEGER NOT NULL, `clazzLocalChangeSeqNum` INTEGER NOT NULL, `clazzLastChangedBy` INTEGER NOT NULL, `clazzLct` INTEGER NOT NULL, `clazzTimeZone` TEXT, `clazzStudentsPersonGroupUid` INTEGER NOT NULL, `clazzTeachersPersonGroupUid` INTEGER NOT NULL, `clazzPendingStudentsPersonGroupUid` INTEGER NOT NULL, `clazzParentsPersonGroupUid` INTEGER NOT NULL, `clazzCode` TEXT)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ClazzEnrolment` (`clazzEnrolmentUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `clazzEnrolmentPersonUid` INTEGER NOT NULL, `clazzEnrolmentClazzUid` INTEGER NOT NULL, `clazzEnrolmentDateJoined` INTEGER NOT NULL, `clazzEnrolmentDateLeft` INTEGER NOT NULL, `clazzEnrolmentRole` INTEGER NOT NULL, `clazzEnrolmentAttendancePercentage` REAL NOT NULL, `clazzEnrolmentActive` INTEGER NOT NULL, `clazzEnrolmentLeavingReasonUid` INTEGER NOT NULL, `clazzEnrolmentOutcome` INTEGER NOT NULL, `clazzEnrolmentLocalChangeSeqNum` INTEGER NOT NULL, `clazzEnrolmentMasterChangeSeqNum` INTEGER NOT NULL, `clazzEnrolmentLastChangedBy` INTEGER NOT NULL, `clazzEnrolmentLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzEnrolment_clazzEnrolmentPersonUid_clazzEnrolmentClazzUid` ON `ClazzEnrolment` (`clazzEnrolmentPersonUid`, `clazzEnrolmentClazzUid`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzEnrolment_clazzEnrolmentClazzUid_clazzEnrolmentPersonUid` ON `ClazzEnrolment` (`clazzEnrolmentClazzUid`, `clazzEnrolmentPersonUid`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzEnrolment_clazzEnrolmentClazzUid_clazzEnrolmentRole` ON `ClazzEnrolment` (`clazzEnrolmentClazzUid`, `clazzEnrolmentRole`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzEnrolment_clazzEnrolmentPersonUid` ON `ClazzEnrolment` (`clazzEnrolmentPersonUid`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzEnrolment_clazzEnrolmentClazzUid` ON `ClazzEnrolment` (`clazzEnrolmentClazzUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `LeavingReason` (`leavingReasonUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `leavingReasonTitle` TEXT, `leavingReasonMCSN` INTEGER NOT NULL, `leavingReasonCSN` INTEGER NOT NULL, `leavingReasonLCB` INTEGER NOT NULL, `leavingReasonLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentEntry` (`contentEntryUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `title` TEXT, `description` TEXT, `entryId` TEXT, `author` TEXT, `publisher` TEXT, `licenseType` INTEGER NOT NULL, `licenseName` TEXT, `licenseUrl` TEXT, `sourceUrl` TEXT, `thumbnailUrl` TEXT, `lastModified` INTEGER NOT NULL, `primaryLanguageUid` INTEGER NOT NULL, `languageVariantUid` INTEGER NOT NULL, `contentFlags` INTEGER NOT NULL, `leaf` INTEGER NOT NULL, `publik` INTEGER NOT NULL, `ceInactive` INTEGER NOT NULL, `completionCriteria` INTEGER NOT NULL, `minScore` INTEGER NOT NULL, `contentTypeFlag` INTEGER NOT NULL, `contentOwner` INTEGER NOT NULL, `contentEntryLocalChangeSeqNum` INTEGER NOT NULL, `contentEntryMasterChangeSeqNum` INTEGER NOT NULL, `contentEntryLastChangedBy` INTEGER NOT NULL, `contentEntryLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentEntry_primaryLanguageUid` ON `ContentEntry` (`primaryLanguageUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentEntryContentCategoryJoin` (`ceccjUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `ceccjContentEntryUid` INTEGER NOT NULL, `ceccjContentCategoryUid` INTEGER NOT NULL, `ceccjLocalChangeSeqNum` INTEGER NOT NULL, `ceccjMasterChangeSeqNum` INTEGER NOT NULL, `ceccjLastChangedBy` INTEGER NOT NULL, `ceccjLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentEntryContentCategoryJoin_ceccjContentEntryUid` ON `ContentEntryContentCategoryJoin` (`ceccjContentEntryUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentEntryParentChildJoin` (`cepcjParentContentEntryUid` INTEGER NOT NULL, `cepcjChildContentEntryUid` INTEGER NOT NULL, `childIndex` INTEGER NOT NULL, `cepcjUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cepcjLocalChangeSeqNum` INTEGER NOT NULL, `cepcjMasterChangeSeqNum` INTEGER NOT NULL, `cepcjLastChangedBy` INTEGER NOT NULL, `cepcjLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `parent_child` ON `ContentEntryParentChildJoin` (`cepcjChildContentEntryUid`, `cepcjParentContentEntryUid`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentEntryParentChildJoin_cepcjParentContentEntryUid` ON `ContentEntryParentChildJoin` (`cepcjParentContentEntryUid`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentEntryParentChildJoin_cepcjChildContentEntryUid` ON `ContentEntryParentChildJoin` (`cepcjChildContentEntryUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentEntryRelatedEntryJoin` (`cerejUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cerejContentEntryUid` INTEGER NOT NULL, `cerejRelatedEntryUid` INTEGER NOT NULL, `cerejLastChangedBy` INTEGER NOT NULL, `relType` INTEGER NOT NULL, `comment` TEXT, `cerejRelLanguageUid` INTEGER NOT NULL, `cerejLocalChangeSeqNum` INTEGER NOT NULL, `cerejMasterChangeSeqNum` INTEGER NOT NULL, `cerejLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentCategorySchema` (`contentCategorySchemaUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `schemaName` TEXT, `schemaUrl` TEXT, `contentCategorySchemaLocalChangeSeqNum` INTEGER NOT NULL, `contentCategorySchemaMasterChangeSeqNum` INTEGER NOT NULL, `contentCategorySchemaLastChangedBy` INTEGER NOT NULL, `contentCategorySchemaLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentCategory` (`contentCategoryUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `ctnCatContentCategorySchemaUid` INTEGER NOT NULL, `name` TEXT, `contentCategoryLocalChangeSeqNum` INTEGER NOT NULL, `contentCategoryMasterChangeSeqNum` INTEGER NOT NULL, `contentCategoryLastChangedBy` INTEGER NOT NULL, `contentCategoryLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `Language` (`langUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `name` TEXT, `iso_639_1_standard` TEXT, `iso_639_2_standard` TEXT, `iso_639_3_standard` TEXT, `Language_Type` TEXT, `languageActive` INTEGER NOT NULL, `langLocalChangeSeqNum` INTEGER NOT NULL, `langMasterChangeSeqNum` INTEGER NOT NULL, `langLastChangedBy` INTEGER NOT NULL, `langLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `LanguageVariant` (`langVariantUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `langUid` INTEGER NOT NULL, `countryCode` TEXT, `name` TEXT, `langVariantLocalChangeSeqNum` INTEGER NOT NULL, `langVariantMasterChangeSeqNum` INTEGER NOT NULL, `langVariantLastChangedBy` INTEGER NOT NULL, `langVariantLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `AccessToken` (`token` TEXT NOT NULL, `accessTokenPersonUid` INTEGER NOT NULL, `expires` INTEGER NOT NULL, PRIMARY KEY(`token`))");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `PersonAuth` (`personAuthUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `passwordHash` TEXT, `personAuthStatus` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `Role` (`roleUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `roleName` TEXT, `roleActive` INTEGER NOT NULL, `roleMasterCsn` INTEGER NOT NULL, `roleLocalCsn` INTEGER NOT NULL, `roleLastChangedBy` INTEGER NOT NULL, `roleLct` INTEGER NOT NULL, `rolePermissions` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_Role_rolePermissions` ON `Role` (`rolePermissions`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `EntityRole` (`erUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `erMasterCsn` INTEGER NOT NULL, `erLocalCsn` INTEGER NOT NULL, `erLastChangedBy` INTEGER NOT NULL, `erLct` INTEGER NOT NULL, `erTableId` INTEGER NOT NULL, `erEntityUid` INTEGER NOT NULL, `erGroupUid` INTEGER NOT NULL, `erRoleUid` INTEGER NOT NULL, `erActive` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_EntityRole_erGroupUid_erRoleUid_erTableId` ON `EntityRole` (`erGroupUid`, `erRoleUid`, `erTableId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_EntityRole_erTableId` ON `EntityRole` (`erTableId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_EntityRole_erEntityUid` ON `EntityRole` (`erEntityUid`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_EntityRole_erGroupUid` ON `EntityRole` (`erGroupUid`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_EntityRole_erRoleUid` ON `EntityRole` (`erRoleUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `PersonGroup` (`groupUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `groupMasterCsn` INTEGER NOT NULL, `groupLocalCsn` INTEGER NOT NULL, `groupLastChangedBy` INTEGER NOT NULL, `groupLct` INTEGER NOT NULL, `groupName` TEXT, `groupActive` INTEGER NOT NULL, `personGroupFlag` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `PersonGroupMember` (`groupMemberUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `groupMemberActive` INTEGER NOT NULL, `groupMemberPersonUid` INTEGER NOT NULL, `groupMemberGroupUid` INTEGER NOT NULL, `groupMemberMasterCsn` INTEGER NOT NULL, `groupMemberLocalCsn` INTEGER NOT NULL, `groupMemberLastChangedBy` INTEGER NOT NULL, `groupMemberLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PersonGroupMember_groupMemberPersonUid` ON `PersonGroupMember` (`groupMemberPersonUid`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PersonGroupMember_groupMemberGroupUid` ON `PersonGroupMember` (`groupMemberGroupUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `PersonPicture` (`personPictureUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `personPicturePersonUid` INTEGER NOT NULL, `personPictureMasterCsn` INTEGER NOT NULL, `personPictureLocalCsn` INTEGER NOT NULL, `personPictureLastChangedBy` INTEGER NOT NULL, `personPictureLct` INTEGER NOT NULL, `personPictureUri` TEXT, `personPictureMd5` TEXT, `fileSize` INTEGER NOT NULL, `picTimestamp` INTEGER NOT NULL, `mimeType` TEXT, `personPictureActive` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ScrapeQueueItem` (`sqiUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `sqiContentEntryParentUid` INTEGER NOT NULL, `sqiContentEntryUid` INTEGER NOT NULL, `destDir` TEXT, `scrapeUrl` TEXT, `status` INTEGER NOT NULL, `runId` INTEGER NOT NULL, `itemType` INTEGER NOT NULL, `errorCode` INTEGER NOT NULL, `contentType` TEXT, `timeAdded` INTEGER NOT NULL, `timeStarted` INTEGER NOT NULL, `timeFinished` INTEGER NOT NULL, `priority` INTEGER NOT NULL, `overrideEntry` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ScrapeQueueItem_status_itemType` ON `ScrapeQueueItem` (`status`, `itemType`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ScrapeRun` (`scrapeRunUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `scrapeType` TEXT, `scrapeRunStatus` INTEGER NOT NULL, `conversionParams` TEXT)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ConnectivityStatus` (`csUid` INTEGER NOT NULL, `connectivityState` INTEGER NOT NULL, `wifiSsid` TEXT, `connectedOrConnecting` INTEGER NOT NULL, PRIMARY KEY(`csUid`))");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `Container` (`containerUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cntLocalCsn` INTEGER NOT NULL, `cntMasterCsn` INTEGER NOT NULL, `cntLastModBy` INTEGER NOT NULL, `cntLct` INTEGER NOT NULL, `fileSize` INTEGER NOT NULL, `containerContentEntryUid` INTEGER NOT NULL, `cntLastModified` INTEGER NOT NULL, `mimeType` TEXT, `remarks` TEXT, `mobileOptimized` INTEGER NOT NULL, `cntNumEntries` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `cnt_uid_to_most_recent` ON `Container` (`containerContentEntryUid`, `cntLastModified`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_Container_cntLastModified` ON `Container` (`cntLastModified`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContainerEntry` (`ceUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `ceContainerUid` INTEGER NOT NULL, `cePath` TEXT, `ceCefUid` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContainerEntry_ceContainerUid` ON `ContainerEntry` (`ceContainerUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContainerEntryFile` (`cefUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cefMd5` TEXT, `cefPath` TEXT, `ceTotalSize` INTEGER NOT NULL, `ceCompressedSize` INTEGER NOT NULL, `compression` INTEGER NOT NULL, `lastModified` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContainerEntryFile_cefMd5` ON `ContainerEntryFile` (`cefMd5`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `VerbEntity` (`verbUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `urlId` TEXT, `verbInActive` INTEGER NOT NULL, `verbMasterChangeSeqNum` INTEGER NOT NULL, `verbLocalChangeSeqNum` INTEGER NOT NULL, `verbLastChangedBy` INTEGER NOT NULL, `verbLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `XObjectEntity` (`xObjectUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `objectType` TEXT, `objectId` TEXT, `definitionType` TEXT, `interactionType` TEXT, `correctResponsePattern` TEXT, `objectContentEntryUid` INTEGER NOT NULL, `objectStatementRefUid` INTEGER NOT NULL DEFAULT 0, `xObjectMasterChangeSeqNum` INTEGER NOT NULL, `xObjectocalChangeSeqNum` INTEGER NOT NULL, `xObjectLastChangedBy` INTEGER NOT NULL, `xObjectLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `StatementEntity` (`statementUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `statementId` TEXT, `statementPersonUid` INTEGER NOT NULL, `statementVerbUid` INTEGER NOT NULL, `xObjectUid` INTEGER NOT NULL, `subStatementActorUid` INTEGER NOT NULL, `substatementVerbUid` INTEGER NOT NULL, `subStatementObjectUid` INTEGER NOT NULL, `agentUid` INTEGER NOT NULL, `instructorUid` INTEGER NOT NULL, `authorityUid` INTEGER NOT NULL, `teamUid` INTEGER NOT NULL, `resultCompletion` INTEGER NOT NULL, `resultSuccess` INTEGER NOT NULL, `resultScoreScaled` REAL NOT NULL, `resultScoreRaw` INTEGER NOT NULL, `resultScoreMin` INTEGER NOT NULL, `resultScoreMax` INTEGER NOT NULL, `resultDuration` INTEGER NOT NULL, `resultResponse` TEXT, `timestamp` INTEGER NOT NULL, `stored` INTEGER NOT NULL, `contextRegistration` TEXT, `contextPlatform` TEXT, `contextStatementId` TEXT, `fullStatement` TEXT, `statementMasterChangeSeqNum` INTEGER NOT NULL, `statementLocalChangeSeqNum` INTEGER NOT NULL, `statementLastChangedBy` INTEGER NOT NULL, `statementLct` INTEGER NOT NULL, `extensionProgress` INTEGER NOT NULL, `contentEntryRoot` INTEGER NOT NULL, `statementContentEntryUid` INTEGER NOT NULL, `statementLearnerGroupUid` INTEGER NOT NULL, `statementClazzUid` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_StatementEntity_statementContentEntryUid_statementPersonUid_contentEntryRoot_timestamp_statementLocalChangeSeqNum` ON `StatementEntity` (`statementContentEntryUid`, `statementPersonUid`, `contentEntryRoot`, `timestamp`, `statementLocalChangeSeqNum`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_StatementEntity_statementPersonUid` ON `StatementEntity` (`statementPersonUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContextXObjectStatementJoin` (`contextXObjectStatementJoinUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `contextActivityFlag` INTEGER NOT NULL, `contextStatementUid` INTEGER NOT NULL, `contextXObjectUid` INTEGER NOT NULL, `verbMasterChangeSeqNum` INTEGER NOT NULL, `verbLocalChangeSeqNum` INTEGER NOT NULL, `verbLastChangedBy` INTEGER NOT NULL, `contextXObjectLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `AgentEntity` (`agentUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `agentMbox` TEXT, `agentMbox_sha1sum` TEXT, `agentOpenid` TEXT, `agentAccountName` TEXT, `agentHomePage` TEXT, `agentPersonUid` INTEGER NOT NULL, `statementMasterChangeSeqNum` INTEGER NOT NULL, `statementLocalChangeSeqNum` INTEGER NOT NULL, `statementLastChangedBy` INTEGER NOT NULL, `agentLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `StateEntity` (`stateUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `stateId` TEXT, `agentUid` INTEGER NOT NULL, `activityId` TEXT, `registration` TEXT, `isIsactive` INTEGER NOT NULL, `timestamp` INTEGER NOT NULL, `stateMasterChangeSeqNum` INTEGER NOT NULL, `stateLocalChangeSeqNum` INTEGER NOT NULL, `stateLastChangedBy` INTEGER NOT NULL, `stateLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `StateContentEntity` (`stateContentUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `stateContentStateUid` INTEGER NOT NULL, `stateContentKey` TEXT, `stateContentValue` TEXT, `isIsactive` INTEGER NOT NULL, `stateContentMasterChangeSeqNum` INTEGER NOT NULL, `stateContentLocalChangeSeqNum` INTEGER NOT NULL, `stateContentLastChangedBy` INTEGER NOT NULL, `stateContentLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `XLangMapEntry` (`verbLangMapUid` INTEGER NOT NULL, `objectLangMapUid` INTEGER NOT NULL, `languageLangMapUid` INTEGER NOT NULL, `languageVariantLangMapUid` INTEGER NOT NULL, `valueLangMap` TEXT, `statementLangMapMasterCsn` INTEGER NOT NULL, `statementLangMapLocalCsn` INTEGER NOT NULL, `statementLangMapLcb` INTEGER NOT NULL, `statementLangMapLct` INTEGER NOT NULL, `statementLangMapUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_XLangMapEntry_verbLangMapUid` ON `XLangMapEntry` (`verbLangMapUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `SyncNode` (`nodeClientId` INTEGER NOT NULL, PRIMARY KEY(`nodeClientId`))");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `LocallyAvailableContainer` (`laContainerUid` INTEGER NOT NULL, PRIMARY KEY(`laContainerUid`))");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContainerETag` (`ceContainerUid` INTEGER NOT NULL, `cetag` TEXT, PRIMARY KEY(`ceContainerUid`))");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `School` (`schoolUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `schoolName` TEXT, `schoolDesc` TEXT, `schoolAddress` TEXT, `schoolActive` INTEGER NOT NULL, `schoolPhoneNumber` TEXT, `schoolGender` INTEGER NOT NULL, `schoolHolidayCalendarUid` INTEGER NOT NULL, `schoolFeatures` INTEGER NOT NULL, `schoolLocationLong` REAL NOT NULL, `schoolLocationLatt` REAL NOT NULL, `schoolEmailAddress` TEXT, `schoolTeachersPersonGroupUid` INTEGER NOT NULL, `schoolStudentsPersonGroupUid` INTEGER NOT NULL, `schoolPendingStudentsPersonGroupUid` INTEGER NOT NULL, `schoolCode` TEXT, `schoolMasterChangeSeqNum` INTEGER NOT NULL, `schoolLocalChangeSeqNum` INTEGER NOT NULL, `schoolLastChangedBy` INTEGER NOT NULL, `schoolLct` INTEGER NOT NULL, `schoolTimeZone` TEXT)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `SchoolMember` (`schoolMemberUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `schoolMemberPersonUid` INTEGER NOT NULL, `schoolMemberSchoolUid` INTEGER NOT NULL, `schoolMemberJoinDate` INTEGER NOT NULL, `schoolMemberLeftDate` INTEGER NOT NULL, `schoolMemberRole` INTEGER NOT NULL, `schoolMemberActive` INTEGER NOT NULL, `schoolMemberLocalChangeSeqNum` INTEGER NOT NULL, `schoolMemberMasterChangeSeqNum` INTEGER NOT NULL, `schoolMemberLastChangedBy` INTEGER NOT NULL, `schoolMemberLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_SchoolMember_schoolMemberSchoolUid_schoolMemberActive_schoolMemberRole` ON `SchoolMember` (`schoolMemberSchoolUid`, `schoolMemberActive`, `schoolMemberRole`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_SchoolMember_schoolMemberPersonUid` ON `SchoolMember` (`schoolMemberPersonUid`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_SchoolMember_schoolMemberSchoolUid` ON `SchoolMember` (`schoolMemberSchoolUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `Comments` (`commentsUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `commentsText` TEXT, `commentsEntityType` INTEGER NOT NULL, `commentsEntityUid` INTEGER NOT NULL, `commentsPublic` INTEGER NOT NULL, `commentsStatus` INTEGER NOT NULL, `commentsPersonUid` INTEGER NOT NULL, `commentsToPersonUid` INTEGER NOT NULL, `commentSubmitterUid` INTEGER NOT NULL, `commentsFlagged` INTEGER NOT NULL, `commentsInActive` INTEGER NOT NULL, `commentsDateTimeAdded` INTEGER NOT NULL, `commentsDateTimeUpdated` INTEGER NOT NULL, `commentsMCSN` INTEGER NOT NULL, `commentsLCSN` INTEGER NOT NULL, `commentsLCB` INTEGER NOT NULL, `commentsLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `Report` (`reportUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `reportOwnerUid` INTEGER NOT NULL, `xAxis` INTEGER NOT NULL, `reportDateRangeSelection` INTEGER NOT NULL, `fromDate` INTEGER NOT NULL, `fromRelTo` INTEGER NOT NULL, `fromRelOffSet` INTEGER NOT NULL, `fromRelUnit` INTEGER NOT NULL, `toDate` INTEGER NOT NULL, `toRelTo` INTEGER NOT NULL, `toRelOffSet` INTEGER NOT NULL, `toRelUnit` INTEGER NOT NULL, `reportTitle` TEXT, `reportDescription` TEXT, `reportSeries` TEXT, `reportInactive` INTEGER NOT NULL, `isTemplate` INTEGER NOT NULL, `priority` INTEGER NOT NULL, `reportTitleId` INTEGER NOT NULL, `reportDescId` INTEGER NOT NULL, `reportMasterChangeSeqNum` INTEGER NOT NULL, `reportLocalChangeSeqNum` INTEGER NOT NULL, `reportLastChangedBy` INTEGER NOT NULL, `reportLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `Site` (`siteUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `sitePcsn` INTEGER NOT NULL, `siteLcsn` INTEGER NOT NULL, `siteLcb` INTEGER NOT NULL, `siteLct` INTEGER NOT NULL, `siteName` TEXT, `guestLogin` INTEGER NOT NULL, `registrationAllowed` INTEGER NOT NULL, `authSalt` TEXT)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContainerImportJob` (`cijUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cijContainerUid` INTEGER NOT NULL, `cijUri` TEXT, `cijImportMode` INTEGER NOT NULL, `cijContainerBaseDir` TEXT, `cijContentEntryUid` INTEGER NOT NULL, `cijMimeType` TEXT, `cijSessionId` TEXT, `cijJobStatus` INTEGER NOT NULL, `cijBytesSoFar` INTEGER NOT NULL, `cijImportCompleted` INTEGER NOT NULL, `cijContentLength` INTEGER NOT NULL, `cijContainerEntryFileUids` TEXT, `cijConversionParams` TEXT)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `LearnerGroup` (`learnerGroupUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `learnerGroupName` TEXT, `learnerGroupDescription` TEXT, `learnerGroupActive` INTEGER NOT NULL, `learnerGroupMCSN` INTEGER NOT NULL, `learnerGroupCSN` INTEGER NOT NULL, `learnerGroupLCB` INTEGER NOT NULL, `learnerGroupLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `LearnerGroupMember` (`learnerGroupMemberUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `learnerGroupMemberPersonUid` INTEGER NOT NULL, `learnerGroupMemberLgUid` INTEGER NOT NULL, `learnerGroupMemberRole` INTEGER NOT NULL, `learnerGroupMemberActive` INTEGER NOT NULL, `learnerGroupMemberMCSN` INTEGER NOT NULL, `learnerGroupMemberCSN` INTEGER NOT NULL, `learnerGroupMemberLCB` INTEGER NOT NULL, `learnerGroupMemberLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `GroupLearningSession` (`groupLearningSessionUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `groupLearningSessionContentUid` INTEGER NOT NULL, `groupLearningSessionLearnerGroupUid` INTEGER NOT NULL, `groupLearningSessionInactive` INTEGER NOT NULL, `groupLearningSessionMCSN` INTEGER NOT NULL, `groupLearningSessionCSN` INTEGER NOT NULL, `groupLearningSessionLCB` INTEGER NOT NULL, `groupLearningSessionLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `SiteTerms` (`sTermsUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `termsHtml` TEXT, `sTermsLang` TEXT, `sTermsLangUid` INTEGER NOT NULL, `sTermsActive` INTEGER NOT NULL, `sTermsLastChangedBy` INTEGER NOT NULL, `sTermsPrimaryCsn` INTEGER NOT NULL, `sTermsLocalCsn` INTEGER NOT NULL, `sTermsLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ClazzContentJoin` (`ccjUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `ccjContentEntryUid` INTEGER NOT NULL, `ccjClazzUid` INTEGER NOT NULL, `ccjActive` INTEGER NOT NULL, `ccjLocalChangeSeqNum` INTEGER NOT NULL, `ccjMasterChangeSeqNum` INTEGER NOT NULL, `ccjLastChangedBy` INTEGER NOT NULL, `ccjLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzContentJoin_ccjContentEntryUid` ON `ClazzContentJoin` (`ccjContentEntryUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `PersonParentJoin` (`ppjUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `ppjPcsn` INTEGER NOT NULL, `ppjLcsn` INTEGER NOT NULL, `ppjLcb` INTEGER NOT NULL, `ppjLct` INTEGER NOT NULL, `ppjParentPersonUid` INTEGER NOT NULL, `ppjMinorPersonUid` INTEGER NOT NULL, `ppjRelationship` INTEGER NOT NULL, `ppjEmail` TEXT, `ppjPhone` TEXT, `ppjInactive` INTEGER NOT NULL, `ppjStatus` INTEGER NOT NULL, `ppjApprovalTiemstamp` INTEGER NOT NULL, `ppjApprovalIpAddr` TEXT)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ScopedGrant` (`sgUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `sgPcsn` INTEGER NOT NULL, `sgLcsn` INTEGER NOT NULL, `sgLcb` INTEGER NOT NULL, `sgLct` INTEGER NOT NULL, `sgTableId` INTEGER NOT NULL, `sgEntityUid` INTEGER NOT NULL, `sgPermissions` INTEGER NOT NULL, `sgGroupUid` INTEGER NOT NULL, `sgIndex` INTEGER NOT NULL, `sgFlags` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `idx_group_to_entity` ON `ScopedGrant` (`sgGroupUid`, `sgPermissions`, `sgTableId`, `sgEntityUid`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `idx_entity_to_group` ON `ScopedGrant` (`sgTableId`, `sgEntityUid`, `sgPermissions`, `sgGroupUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ErrorReport` (`errUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `errPcsn` INTEGER NOT NULL, `errLcsn` INTEGER NOT NULL, `errLcb` INTEGER NOT NULL, `errLct` INTEGER NOT NULL, `severity` INTEGER NOT NULL, `timestamp` INTEGER NOT NULL, `presenterUri` TEXT, `appVersion` TEXT, `versionCode` INTEGER NOT NULL, `errorCode` INTEGER NOT NULL, `operatingSys` TEXT, `osVersion` TEXT, `stackTrace` TEXT, `message` TEXT)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ClazzAssignment` (`caUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `caTitle` TEXT, `caDescription` TEXT, `caGroupUid` INTEGER NOT NULL DEFAULT 0, `caActive` INTEGER NOT NULL, `caClassCommentEnabled` INTEGER NOT NULL, `caPrivateCommentsEnabled` INTEGER NOT NULL DEFAULT 1, `caCompletionCriteria` INTEGER NOT NULL DEFAULT 100, `caRequireFileSubmission` INTEGER NOT NULL DEFAULT 1, `caFileType` INTEGER NOT NULL DEFAULT 0, `caSizeLimit` INTEGER NOT NULL DEFAULT 50, `caNumberOfFiles` INTEGER NOT NULL DEFAULT 1, `caSubmissionPolicy` INTEGER NOT NULL DEFAULT 1, `caMarkingType` INTEGER NOT NULL DEFAULT 1, `caRequireTextSubmission` INTEGER NOT NULL DEFAULT 1, `caTextLimitType` INTEGER NOT NULL DEFAULT 1, `caTextLimit` INTEGER NOT NULL DEFAULT 500, `caXObjectUid` INTEGER NOT NULL DEFAULT 0, `caClazzUid` INTEGER NOT NULL, `caLocalChangeSeqNum` INTEGER NOT NULL, `caMasterChangeSeqNum` INTEGER NOT NULL, `caLastChangedBy` INTEGER NOT NULL, `caLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzAssignment_caClazzUid` ON `ClazzAssignment` (`caClazzUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ClazzAssignmentContentJoin` (`cacjUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cacjContentUid` INTEGER NOT NULL, `cacjAssignmentUid` INTEGER NOT NULL, `cacjActive` INTEGER NOT NULL, `cacjWeight` INTEGER NOT NULL DEFAULT 0, `cacjMCSN` INTEGER NOT NULL, `cacjLCSN` INTEGER NOT NULL, `cacjLCB` INTEGER NOT NULL, `cacjLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseAssignmentSubmission` (`casUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `casAssignmentUid` INTEGER NOT NULL, `casSubmitterUid` INTEGER NOT NULL, `casSubmitterPersonUid` INTEGER NOT NULL, `casText` TEXT, `casType` INTEGER NOT NULL, `casTimestamp` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseAssignmentSubmissionAttachment` (`casaUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `casaSubmissionUid` INTEGER NOT NULL, `casaMimeType` TEXT, `casaFileName` TEXT, `casaUri` TEXT, `casaMd5` TEXT, `casaSize` INTEGER NOT NULL, `casaTimestamp` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseAssignmentMark` (`camUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `camAssignmentUid` INTEGER NOT NULL, `camSubmitterUid` INTEGER NOT NULL, `camMark` REAL NOT NULL, `camPenalty` INTEGER NOT NULL, `camLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ClazzAssignmentRollUp` (`cacheUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cachePersonUid` INTEGER NOT NULL, `cacheContentEntryUid` INTEGER NOT NULL, `cacheClazzAssignmentUid` INTEGER NOT NULL, `cacheStudentScore` INTEGER NOT NULL, `cacheMaxScore` INTEGER NOT NULL, `cacheFinalWeightScoreWithPenalty` REAL NOT NULL DEFAULT 0, `cacheWeight` INTEGER NOT NULL DEFAULT 0, `cacheProgress` INTEGER NOT NULL, `cacheContentComplete` INTEGER NOT NULL, `cacheSuccess` INTEGER NOT NULL, `cachePenalty` INTEGER NOT NULL, `lastCsnChecked` INTEGER NOT NULL)");
        _db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS `index_ClazzAssignmentRollUp_cachePersonUid_cacheContentEntryUid_cacheClazzAssignmentUid` ON `ClazzAssignmentRollUp` (`cachePersonUid`, `cacheContentEntryUid`, `cacheClazzAssignmentUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `PersonAuth2` (`pauthUid` INTEGER NOT NULL, `pauthMechanism` TEXT, `pauthAuth` TEXT, `pauthLcsn` INTEGER NOT NULL, `pauthPcsn` INTEGER NOT NULL, `pauthLcb` INTEGER NOT NULL, `pauthLct` INTEGER NOT NULL, PRIMARY KEY(`pauthUid`))");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `UserSession` (`usUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `usPcsn` INTEGER NOT NULL, `usLcsn` INTEGER NOT NULL, `usLcb` INTEGER NOT NULL, `usLct` INTEGER NOT NULL, `usPersonUid` INTEGER NOT NULL, `usClientNodeId` INTEGER NOT NULL, `usStartTime` INTEGER NOT NULL, `usEndTime` INTEGER NOT NULL, `usStatus` INTEGER NOT NULL, `usReason` INTEGER NOT NULL, `usAuth` TEXT, `usSessionType` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `person_status_node_idx` ON `UserSession` (`usPersonUid`, `usStatus`, `usClientNodeId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `node_status_person_idx` ON `UserSession` (`usClientNodeId`, `usStatus`, `usPersonUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentJob` (`cjUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `toUri` TEXT, `cjProgress` INTEGER NOT NULL, `cjTotal` INTEGER NOT NULL, `cjNotificationTitle` TEXT, `cjIsMeteredAllowed` INTEGER NOT NULL, `params` TEXT)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentJobItem` (`cjiUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cjiJobUid` INTEGER NOT NULL, `sourceUri` TEXT, `cjiIsLeaf` INTEGER NOT NULL, `cjiContentEntryUid` INTEGER NOT NULL, `cjiParentContentEntryUid` INTEGER NOT NULL, `cjiContainerUid` INTEGER NOT NULL, `cjiItemProgress` INTEGER NOT NULL, `cjiItemTotal` INTEGER NOT NULL, `cjiRecursiveProgress` INTEGER NOT NULL, `cjiRecursiveTotal` INTEGER NOT NULL, `cjiStatus` INTEGER NOT NULL, `cjiRecursiveStatus` INTEGER NOT NULL, `cjiConnectivityNeeded` INTEGER NOT NULL, `cjiPluginId` INTEGER NOT NULL, `cjiAttemptCount` INTEGER NOT NULL, `cjiParentCjiUid` INTEGER NOT NULL, `cjiServerJobId` INTEGER NOT NULL, `cjiStartTime` INTEGER NOT NULL, `cjiFinishTime` INTEGER NOT NULL, `cjiUploadSessionUid` TEXT, `cjiContentDeletedOnCancellation` INTEGER NOT NULL, `cjiContainerProcessed` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentJobItem_cjiContentEntryUid_cjiFinishTime` ON `ContentJobItem` (`cjiContentEntryUid`, `cjiFinishTime`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseBlock` (`cbUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cbType` INTEGER NOT NULL, `cbIndentLevel` INTEGER NOT NULL, `cbModuleParentBlockUid` INTEGER NOT NULL, `cbTitle` TEXT, `cbDescription` TEXT, `cbCompletionCriteria` INTEGER NOT NULL, `cbHideUntilDate` INTEGER NOT NULL, `cbDeadlineDate` INTEGER NOT NULL, `cbLateSubmissionPenalty` INTEGER NOT NULL, `cbGracePeriodDate` INTEGER NOT NULL, `cbMaxPoints` INTEGER NOT NULL, `cbMinPoints` INTEGER NOT NULL, `cbIndex` INTEGER NOT NULL, `cbClazzUid` INTEGER NOT NULL, `cbActive` INTEGER NOT NULL, `cbHidden` INTEGER NOT NULL, `cbEntityUid` INTEGER NOT NULL, `cbLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseBlock_cbClazzUid` ON `CourseBlock` (`cbClazzUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseTerminology` (`ctUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `ctTitle` TEXT, `ctTerminology` TEXT, `ctLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseGroupSet` (`cgsUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cgsName` TEXT, `cgsTotalGroups` INTEGER NOT NULL, `cgsActive` INTEGER NOT NULL, `cgsClazzUid` INTEGER NOT NULL, `cgsLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseGroupSet_cgsClazzUid` ON `CourseGroupSet` (`cgsClazzUid`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseGroupMember` (`cgmUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cgmSetUid` INTEGER NOT NULL, `cgmGroupNumber` INTEGER NOT NULL, `cgmPersonUid` INTEGER NOT NULL, `cgmLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ChangeLog` (`chTableId` INTEGER NOT NULL, `chEntityPk` INTEGER NOT NULL, `chType` INTEGER NOT NULL, PRIMARY KEY(`chTableId`, `chEntityPk`))");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ZombieAttachmentData` (`zaUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `zaUri` TEXT)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `DoorNode` (`nodeId` INTEGER NOT NULL, `auth` TEXT, `rel` INTEGER NOT NULL DEFAULT 2, PRIMARY KEY(`nodeId`))");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ReplicationStatus` (`repStatusId` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `tableId` INTEGER NOT NULL, `priority` INTEGER NOT NULL, `nodeId` INTEGER NOT NULL, `lastRemoteChangeTime` INTEGER NOT NULL, `lastFetchReplicationCompleteTime` INTEGER NOT NULL, `lastLocalChangeTime` INTEGER NOT NULL, `lastSendReplicationCompleteTime` INTEGER NOT NULL)");
        _db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS `table_node_idx` ON `ReplicationStatus` (`tableId`, `nodeId`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ClazzLogReplicate` (`clPk` INTEGER NOT NULL, `clVersionId` INTEGER NOT NULL DEFAULT 0, `clDestination` INTEGER NOT NULL, `clPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`clPk`, `clDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzLogReplicate_clPk_clDestination_clVersionId` ON `ClazzLogReplicate` (`clPk`, `clDestination`, `clVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzLogReplicate_clDestination_clPending` ON `ClazzLogReplicate` (`clDestination`, `clPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ClazzLogAttendanceRecordReplicate` (`clarPk` INTEGER NOT NULL, `clarVersionId` INTEGER NOT NULL DEFAULT 0, `clarDestination` INTEGER NOT NULL, `clarPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`clarPk`, `clarDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzLogAttendanceRecordReplicate_clarPk_clarDestination_clarVersionId` ON `ClazzLogAttendanceRecordReplicate` (`clarPk`, `clarDestination`, `clarVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzLogAttendanceRecordReplicate_clarDestination_clarPending` ON `ClazzLogAttendanceRecordReplicate` (`clarDestination`, `clarPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseAssignmentSubmissionReplicate` (`casPk` INTEGER NOT NULL, `casVersionId` INTEGER NOT NULL DEFAULT 0, `casDestination` INTEGER NOT NULL, `casPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`casPk`, `casDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseAssignmentSubmissionReplicate_casPk_casDestination_casVersionId` ON `CourseAssignmentSubmissionReplicate` (`casPk`, `casDestination`, `casVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseAssignmentSubmissionReplicate_casDestination_casPending` ON `CourseAssignmentSubmissionReplicate` (`casDestination`, `casPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseAssignmentSubmissionAttachmentReplicate` (`casaPk` INTEGER NOT NULL, `casaVersionId` INTEGER NOT NULL DEFAULT 0, `casaDestination` INTEGER NOT NULL, `casaPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`casaPk`, `casaDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseAssignmentSubmissionAttachmentReplicate_casaPk_casaDestination_casaVersionId` ON `CourseAssignmentSubmissionAttachmentReplicate` (`casaPk`, `casaDestination`, `casaVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseAssignmentSubmissionAttachmentReplicate_casaDestination_casaPending` ON `CourseAssignmentSubmissionAttachmentReplicate` (`casaDestination`, `casaPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseAssignmentMarkReplicate` (`camPk` INTEGER NOT NULL, `camVersionId` INTEGER NOT NULL DEFAULT 0, `camDestination` INTEGER NOT NULL, `camPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`camPk`, `camDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseAssignmentMarkReplicate_camPk_camDestination_camVersionId` ON `CourseAssignmentMarkReplicate` (`camPk`, `camDestination`, `camVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseAssignmentMarkReplicate_camDestination_camPending` ON `CourseAssignmentMarkReplicate` (`camDestination`, `camPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseBlockReplicate` (`cbPk` INTEGER NOT NULL, `cbVersionId` INTEGER NOT NULL DEFAULT 0, `cbDestination` INTEGER NOT NULL, `cbPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`cbPk`, `cbDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseBlockReplicate_cbPk_cbDestination_cbVersionId` ON `CourseBlockReplicate` (`cbPk`, `cbDestination`, `cbVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseBlockReplicate_cbDestination_cbPending` ON `CourseBlockReplicate` (`cbDestination`, `cbPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseTerminologyReplicate` (`ctPk` INTEGER NOT NULL, `ctVersionId` INTEGER NOT NULL DEFAULT 0, `ctDestination` INTEGER NOT NULL, `ctPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`ctPk`, `ctDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseTerminologyReplicate_ctPk_ctDestination_ctVersionId` ON `CourseTerminologyReplicate` (`ctPk`, `ctDestination`, `ctVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseTerminologyReplicate_ctDestination_ctPending` ON `CourseTerminologyReplicate` (`ctDestination`, `ctPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseGroupSetReplicate` (`cgsPk` INTEGER NOT NULL, `cgsVersionId` INTEGER NOT NULL DEFAULT 0, `cgsDestination` INTEGER NOT NULL, `cgsPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`cgsPk`, `cgsDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseGroupSetReplicate_cgsPk_cgsDestination_cgsVersionId` ON `CourseGroupSetReplicate` (`cgsPk`, `cgsDestination`, `cgsVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseGroupSetReplicate_cgsDestination_cgsPending` ON `CourseGroupSetReplicate` (`cgsDestination`, `cgsPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseGroupMemberReplicate` (`cgmPk` INTEGER NOT NULL, `cgmVersionId` INTEGER NOT NULL DEFAULT 0, `cgmDestination` INTEGER NOT NULL, `cgmPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`cgmPk`, `cgmDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseGroupMemberReplicate_cgmPk_cgmDestination_cgmVersionId` ON `CourseGroupMemberReplicate` (`cgmPk`, `cgmDestination`, `cgmVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseGroupMemberReplicate_cgmDestination_cgmPending` ON `CourseGroupMemberReplicate` (`cgmDestination`, `cgmPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ScheduleReplicate` (`schedulePk` INTEGER NOT NULL, `scheduleVersionId` INTEGER NOT NULL DEFAULT 0, `scheduleDestination` INTEGER NOT NULL, `schedulePending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`schedulePk`, `scheduleDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ScheduleReplicate_schedulePk_scheduleDestination_scheduleVersionId` ON `ScheduleReplicate` (`schedulePk`, `scheduleDestination`, `scheduleVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ScheduleReplicate_scheduleDestination_schedulePending` ON `ScheduleReplicate` (`scheduleDestination`, `schedulePending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `HolidayCalendarReplicate` (`hcPk` INTEGER NOT NULL, `hcVersionId` INTEGER NOT NULL DEFAULT 0, `hcDestination` INTEGER NOT NULL, `hcPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`hcPk`, `hcDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_HolidayCalendarReplicate_hcPk_hcDestination_hcVersionId` ON `HolidayCalendarReplicate` (`hcPk`, `hcDestination`, `hcVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_HolidayCalendarReplicate_hcDestination_hcPending` ON `HolidayCalendarReplicate` (`hcDestination`, `hcPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `HolidayReplicate` (`holidayPk` INTEGER NOT NULL, `holidayVersionId` INTEGER NOT NULL DEFAULT 0, `holidayDestination` INTEGER NOT NULL, `holidayPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`holidayPk`, `holidayDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_HolidayReplicate_holidayPk_holidayDestination_holidayVersionId` ON `HolidayReplicate` (`holidayPk`, `holidayDestination`, `holidayVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_HolidayReplicate_holidayDestination_holidayPending` ON `HolidayReplicate` (`holidayDestination`, `holidayPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `PersonReplicate` (`personPk` INTEGER NOT NULL, `personVersionId` INTEGER NOT NULL DEFAULT 0, `personDestination` INTEGER NOT NULL, `personPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`personPk`, `personDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PersonReplicate_personPk_personDestination_personVersionId` ON `PersonReplicate` (`personPk`, `personDestination`, `personVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PersonReplicate_personDestination_personPending` ON `PersonReplicate` (`personDestination`, `personPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ClazzReplicate` (`clazzPk` INTEGER NOT NULL, `clazzVersionId` INTEGER NOT NULL DEFAULT 0, `clazzDestination` INTEGER NOT NULL, `clazzPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`clazzPk`, `clazzDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzReplicate_clazzPk_clazzDestination_clazzVersionId` ON `ClazzReplicate` (`clazzPk`, `clazzDestination`, `clazzVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzReplicate_clazzDestination_clazzPending` ON `ClazzReplicate` (`clazzDestination`, `clazzPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ClazzEnrolmentReplicate` (`cePk` INTEGER NOT NULL, `ceVersionId` INTEGER NOT NULL DEFAULT 0, `ceDestination` INTEGER NOT NULL, `cePending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`cePk`, `ceDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzEnrolmentReplicate_cePk_ceDestination_ceVersionId` ON `ClazzEnrolmentReplicate` (`cePk`, `ceDestination`, `ceVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzEnrolmentReplicate_ceDestination_cePending` ON `ClazzEnrolmentReplicate` (`ceDestination`, `cePending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `LeavingReasonReplicate` (`lrPk` INTEGER NOT NULL, `lrVersionId` INTEGER NOT NULL DEFAULT 0, `lrDestination` INTEGER NOT NULL, `lrPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`lrPk`, `lrDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_LeavingReasonReplicate_lrPk_lrDestination_lrVersionId` ON `LeavingReasonReplicate` (`lrPk`, `lrDestination`, `lrVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_LeavingReasonReplicate_lrDestination_lrPending` ON `LeavingReasonReplicate` (`lrDestination`, `lrPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentEntryReplicate` (`cePk` INTEGER NOT NULL, `ceVersionId` INTEGER NOT NULL DEFAULT 0, `ceDestination` INTEGER NOT NULL, `cePending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`cePk`, `ceDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentEntryReplicate_cePk_ceDestination_ceVersionId` ON `ContentEntryReplicate` (`cePk`, `ceDestination`, `ceVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentEntryReplicate_ceDestination_cePending` ON `ContentEntryReplicate` (`ceDestination`, `cePending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentEntryContentCategoryJoinReplicate` (`ceccjPk` INTEGER NOT NULL, `ceccjVersionId` INTEGER NOT NULL DEFAULT 0, `ceccjDestination` INTEGER NOT NULL, `ceccjPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`ceccjPk`, `ceccjDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentEntryContentCategoryJoinReplicate_ceccjPk_ceccjDestination_ceccjVersionId` ON `ContentEntryContentCategoryJoinReplicate` (`ceccjPk`, `ceccjDestination`, `ceccjVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentEntryContentCategoryJoinReplicate_ceccjDestination_ceccjPending` ON `ContentEntryContentCategoryJoinReplicate` (`ceccjDestination`, `ceccjPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentEntryParentChildJoinReplicate` (`cepcjPk` INTEGER NOT NULL, `cepcjVersionId` INTEGER NOT NULL DEFAULT 0, `cepcjDestination` INTEGER NOT NULL, `cepcjPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`cepcjPk`, `cepcjDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentEntryParentChildJoinReplicate_cepcjPk_cepcjDestination_cepcjVersionId` ON `ContentEntryParentChildJoinReplicate` (`cepcjPk`, `cepcjDestination`, `cepcjVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentEntryParentChildJoinReplicate_cepcjDestination_cepcjPending` ON `ContentEntryParentChildJoinReplicate` (`cepcjDestination`, `cepcjPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentEntryRelatedEntryJoinReplicate` (`cerejPk` INTEGER NOT NULL, `cerejVersionId` INTEGER NOT NULL DEFAULT 0, `cerejDestination` INTEGER NOT NULL, `cerejPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`cerejPk`, `cerejDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentEntryRelatedEntryJoinReplicate_cerejPk_cerejDestination_cerejVersionId` ON `ContentEntryRelatedEntryJoinReplicate` (`cerejPk`, `cerejDestination`, `cerejVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentEntryRelatedEntryJoinReplicate_cerejDestination_cerejPending` ON `ContentEntryRelatedEntryJoinReplicate` (`cerejDestination`, `cerejPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentCategorySchemaReplicate` (`ccsPk` INTEGER NOT NULL, `ccsVersionId` INTEGER NOT NULL DEFAULT 0, `ccsDestination` INTEGER NOT NULL, `ccsPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`ccsPk`, `ccsDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentCategorySchemaReplicate_ccsPk_ccsDestination_ccsVersionId` ON `ContentCategorySchemaReplicate` (`ccsPk`, `ccsDestination`, `ccsVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentCategorySchemaReplicate_ccsDestination_ccsPending` ON `ContentCategorySchemaReplicate` (`ccsDestination`, `ccsPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentCategoryReplicate` (`ccPk` INTEGER NOT NULL, `ccVersionId` INTEGER NOT NULL DEFAULT 0, `ccDestination` INTEGER NOT NULL, `ccPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`ccPk`, `ccDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentCategoryReplicate_ccPk_ccDestination_ccVersionId` ON `ContentCategoryReplicate` (`ccPk`, `ccDestination`, `ccVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentCategoryReplicate_ccDestination_ccPending` ON `ContentCategoryReplicate` (`ccDestination`, `ccPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `LanguageReplicate` (`languagePk` INTEGER NOT NULL, `languageVersionId` INTEGER NOT NULL DEFAULT 0, `languageDestination` INTEGER NOT NULL, `languagePending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`languagePk`, `languageDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_LanguageReplicate_languagePk_languageDestination_languageVersionId` ON `LanguageReplicate` (`languagePk`, `languageDestination`, `languageVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_LanguageReplicate_languageDestination_languagePending` ON `LanguageReplicate` (`languageDestination`, `languagePending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `LanguageVariantReplicate` (`lvPk` INTEGER NOT NULL, `lvVersionId` INTEGER NOT NULL DEFAULT 0, `lvDestination` INTEGER NOT NULL, `lvPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`lvPk`, `lvDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_LanguageVariantReplicate_lvPk_lvDestination_lvVersionId` ON `LanguageVariantReplicate` (`lvPk`, `lvDestination`, `lvVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_LanguageVariantReplicate_lvDestination_lvPending` ON `LanguageVariantReplicate` (`lvDestination`, `lvPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `PersonGroupReplicate` (`pgPk` INTEGER NOT NULL, `pgVersionId` INTEGER NOT NULL DEFAULT 0, `pgDestination` INTEGER NOT NULL, `pgPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`pgPk`, `pgDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PersonGroupReplicate_pgPk_pgDestination_pgVersionId` ON `PersonGroupReplicate` (`pgPk`, `pgDestination`, `pgVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PersonGroupReplicate_pgDestination_pgPending` ON `PersonGroupReplicate` (`pgDestination`, `pgPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `PersonGroupMemberReplicate` (`pgmPk` INTEGER NOT NULL, `pgmVersionId` INTEGER NOT NULL DEFAULT 0, `pgmDestination` INTEGER NOT NULL, `pgmPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`pgmPk`, `pgmDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PersonGroupMemberReplicate_pgmPk_pgmDestination_pgmVersionId` ON `PersonGroupMemberReplicate` (`pgmPk`, `pgmDestination`, `pgmVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PersonGroupMemberReplicate_pgmDestination_pgmPending` ON `PersonGroupMemberReplicate` (`pgmDestination`, `pgmPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `PersonPictureReplicate` (`ppPk` INTEGER NOT NULL, `ppVersionId` INTEGER NOT NULL DEFAULT 0, `ppDestination` INTEGER NOT NULL, `ppPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`ppPk`, `ppDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PersonPictureReplicate_ppPk_ppDestination_ppVersionId` ON `PersonPictureReplicate` (`ppPk`, `ppDestination`, `ppVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PersonPictureReplicate_ppDestination_ppPending` ON `PersonPictureReplicate` (`ppDestination`, `ppPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContainerReplicate` (`containerPk` INTEGER NOT NULL, `containerVersionId` INTEGER NOT NULL DEFAULT 0, `containerDestination` INTEGER NOT NULL, `containerPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`containerPk`, `containerDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContainerReplicate_containerPk_containerDestination_containerVersionId` ON `ContainerReplicate` (`containerPk`, `containerDestination`, `containerVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContainerReplicate_containerDestination_containerPending` ON `ContainerReplicate` (`containerDestination`, `containerPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `VerbEntityReplicate` (`vePk` INTEGER NOT NULL, `veVersionId` INTEGER NOT NULL DEFAULT 0, `veDestination` INTEGER NOT NULL, `vePending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`vePk`, `veDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_VerbEntityReplicate_vePk_veDestination_veVersionId` ON `VerbEntityReplicate` (`vePk`, `veDestination`, `veVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_VerbEntityReplicate_veDestination_vePending` ON `VerbEntityReplicate` (`veDestination`, `vePending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `XObjectEntityReplicate` (`xoePk` INTEGER NOT NULL, `xoeVersionId` INTEGER NOT NULL DEFAULT 0, `xoeDestination` INTEGER NOT NULL, `xoePending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`xoePk`, `xoeDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_XObjectEntityReplicate_xoePk_xoeDestination_xoeVersionId` ON `XObjectEntityReplicate` (`xoePk`, `xoeDestination`, `xoeVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_XObjectEntityReplicate_xoeDestination_xoePending` ON `XObjectEntityReplicate` (`xoeDestination`, `xoePending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `StatementEntityReplicate` (`sePk` INTEGER NOT NULL, `seVersionId` INTEGER NOT NULL DEFAULT 0, `seDestination` INTEGER NOT NULL, `sePending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`sePk`, `seDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_StatementEntityReplicate_sePk_seDestination_seVersionId` ON `StatementEntityReplicate` (`sePk`, `seDestination`, `seVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_StatementEntityReplicate_seDestination_sePending` ON `StatementEntityReplicate` (`seDestination`, `sePending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContextXObjectStatementJoinReplicate` (`cxosjPk` INTEGER NOT NULL, `cxosjVersionId` INTEGER NOT NULL DEFAULT 0, `cxosjDestination` INTEGER NOT NULL, `cxosjPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`cxosjPk`, `cxosjDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContextXObjectStatementJoinReplicate_cxosjPk_cxosjDestination_cxosjVersionId` ON `ContextXObjectStatementJoinReplicate` (`cxosjPk`, `cxosjDestination`, `cxosjVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContextXObjectStatementJoinReplicate_cxosjDestination_cxosjPending` ON `ContextXObjectStatementJoinReplicate` (`cxosjDestination`, `cxosjPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `AgentEntityReplicate` (`aePk` INTEGER NOT NULL, `aeVersionId` INTEGER NOT NULL DEFAULT 0, `aeDestination` INTEGER NOT NULL, `aePending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`aePk`, `aeDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_AgentEntityReplicate_aePk_aeDestination_aeVersionId` ON `AgentEntityReplicate` (`aePk`, `aeDestination`, `aeVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_AgentEntityReplicate_aeDestination_aePending` ON `AgentEntityReplicate` (`aeDestination`, `aePending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `StateEntityReplicate` (`sePk` INTEGER NOT NULL, `seVersionId` INTEGER NOT NULL DEFAULT 0, `seDestination` INTEGER NOT NULL, `sePending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`sePk`, `seDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_StateEntityReplicate_sePk_seDestination_seVersionId` ON `StateEntityReplicate` (`sePk`, `seDestination`, `seVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_StateEntityReplicate_seDestination_sePending` ON `StateEntityReplicate` (`seDestination`, `sePending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `StateContentEntityReplicate` (`scePk` INTEGER NOT NULL, `sceVersionId` INTEGER NOT NULL DEFAULT 0, `sceDestination` INTEGER NOT NULL, `scePending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`scePk`, `sceDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_StateContentEntityReplicate_scePk_sceDestination_sceVersionId` ON `StateContentEntityReplicate` (`scePk`, `sceDestination`, `sceVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_StateContentEntityReplicate_sceDestination_scePending` ON `StateContentEntityReplicate` (`sceDestination`, `scePending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `XLangMapEntryReplicate` (`xlmePk` INTEGER NOT NULL, `xlmeVersionId` INTEGER NOT NULL DEFAULT 0, `xlmeDestination` INTEGER NOT NULL, `xlmePending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`xlmePk`, `xlmeDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_XLangMapEntryReplicate_xlmePk_xlmeDestination_xlmeVersionId` ON `XLangMapEntryReplicate` (`xlmePk`, `xlmeDestination`, `xlmeVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_XLangMapEntryReplicate_xlmeDestination_xlmePending` ON `XLangMapEntryReplicate` (`xlmeDestination`, `xlmePending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `SchoolReplicate` (`schoolPk` INTEGER NOT NULL, `schoolVersionId` INTEGER NOT NULL DEFAULT 0, `schoolDestination` INTEGER NOT NULL, `schoolPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`schoolPk`, `schoolDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_SchoolReplicate_schoolPk_schoolDestination_schoolVersionId` ON `SchoolReplicate` (`schoolPk`, `schoolDestination`, `schoolVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_SchoolReplicate_schoolDestination_schoolPending` ON `SchoolReplicate` (`schoolDestination`, `schoolPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `SchoolMemberReplicate` (`smPk` INTEGER NOT NULL, `smVersionId` INTEGER NOT NULL DEFAULT 0, `smDestination` INTEGER NOT NULL, `smPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`smPk`, `smDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_SchoolMemberReplicate_smPk_smDestination_smVersionId` ON `SchoolMemberReplicate` (`smPk`, `smDestination`, `smVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_SchoolMemberReplicate_smDestination_smPending` ON `SchoolMemberReplicate` (`smDestination`, `smPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CommentsReplicate` (`commentsPk` INTEGER NOT NULL, `commentsVersionId` INTEGER NOT NULL DEFAULT 0, `commentsDestination` INTEGER NOT NULL, `commentsPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`commentsPk`, `commentsDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CommentsReplicate_commentsPk_commentsDestination_commentsVersionId` ON `CommentsReplicate` (`commentsPk`, `commentsDestination`, `commentsVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CommentsReplicate_commentsDestination_commentsPending` ON `CommentsReplicate` (`commentsDestination`, `commentsPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ReportReplicate` (`reportPk` INTEGER NOT NULL, `reportVersionId` INTEGER NOT NULL DEFAULT 0, `reportDestination` INTEGER NOT NULL, `reportPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`reportPk`, `reportDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ReportReplicate_reportPk_reportDestination_reportVersionId` ON `ReportReplicate` (`reportPk`, `reportDestination`, `reportVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ReportReplicate_reportDestination_reportPending` ON `ReportReplicate` (`reportDestination`, `reportPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `SiteReplicate` (`sitePk` INTEGER NOT NULL, `siteVersionId` INTEGER NOT NULL DEFAULT 0, `siteDestination` INTEGER NOT NULL, `sitePending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`sitePk`, `siteDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_SiteReplicate_sitePk_siteDestination_siteVersionId` ON `SiteReplicate` (`sitePk`, `siteDestination`, `siteVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_SiteReplicate_siteDestination_sitePending` ON `SiteReplicate` (`siteDestination`, `sitePending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `LearnerGroupReplicate` (`lgPk` INTEGER NOT NULL, `lgVersionId` INTEGER NOT NULL DEFAULT 0, `lgDestination` INTEGER NOT NULL, `lgPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`lgPk`, `lgDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_LearnerGroupReplicate_lgPk_lgDestination_lgVersionId` ON `LearnerGroupReplicate` (`lgPk`, `lgDestination`, `lgVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_LearnerGroupReplicate_lgDestination_lgPending` ON `LearnerGroupReplicate` (`lgDestination`, `lgPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `LearnerGroupMemberReplicate` (`lgmPk` INTEGER NOT NULL, `lgmVersionId` INTEGER NOT NULL DEFAULT 0, `lgmDestination` INTEGER NOT NULL, `lgmPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`lgmPk`, `lgmDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_LearnerGroupMemberReplicate_lgmPk_lgmDestination_lgmVersionId` ON `LearnerGroupMemberReplicate` (`lgmPk`, `lgmDestination`, `lgmVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_LearnerGroupMemberReplicate_lgmDestination_lgmPending` ON `LearnerGroupMemberReplicate` (`lgmDestination`, `lgmPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `GroupLearningSessionReplicate` (`glsPk` INTEGER NOT NULL, `glsVersionId` INTEGER NOT NULL DEFAULT 0, `glsDestination` INTEGER NOT NULL, `glsPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`glsPk`, `glsDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_GroupLearningSessionReplicate_glsPk_glsDestination_glsVersionId` ON `GroupLearningSessionReplicate` (`glsPk`, `glsDestination`, `glsVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_GroupLearningSessionReplicate_glsDestination_glsPending` ON `GroupLearningSessionReplicate` (`glsDestination`, `glsPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `SiteTermsReplicate` (`stPk` INTEGER NOT NULL, `stVersionId` INTEGER NOT NULL DEFAULT 0, `stDestination` INTEGER NOT NULL, `stPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`stPk`, `stDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_SiteTermsReplicate_stPk_stDestination_stVersionId` ON `SiteTermsReplicate` (`stPk`, `stDestination`, `stVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_SiteTermsReplicate_stDestination_stPending` ON `SiteTermsReplicate` (`stDestination`, `stPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ClazzContentJoinReplicate` (`ccjPk` INTEGER NOT NULL, `ccjVersionId` INTEGER NOT NULL DEFAULT 0, `ccjDestination` INTEGER NOT NULL, `ccjPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`ccjPk`, `ccjDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzContentJoinReplicate_ccjPk_ccjDestination_ccjVersionId` ON `ClazzContentJoinReplicate` (`ccjPk`, `ccjDestination`, `ccjVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzContentJoinReplicate_ccjDestination_ccjPending` ON `ClazzContentJoinReplicate` (`ccjDestination`, `ccjPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `PersonParentJoinReplicate` (`ppjPk` INTEGER NOT NULL, `ppjVersionId` INTEGER NOT NULL DEFAULT 0, `ppjDestination` INTEGER NOT NULL, `ppjPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`ppjPk`, `ppjDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PersonParentJoinReplicate_ppjPk_ppjDestination_ppjVersionId` ON `PersonParentJoinReplicate` (`ppjPk`, `ppjDestination`, `ppjVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PersonParentJoinReplicate_ppjDestination_ppjPending` ON `PersonParentJoinReplicate` (`ppjDestination`, `ppjPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ScopedGrantReplicate` (`sgPk` INTEGER NOT NULL, `sgVersionId` INTEGER NOT NULL DEFAULT 0, `sgDestination` INTEGER NOT NULL, `sgPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`sgPk`, `sgDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ScopedGrantReplicate_sgPk_sgDestination_sgVersionId` ON `ScopedGrantReplicate` (`sgPk`, `sgDestination`, `sgVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ScopedGrantReplicate_sgDestination_sgPending` ON `ScopedGrantReplicate` (`sgDestination`, `sgPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ErrorReportReplicate` (`erPk` INTEGER NOT NULL, `erVersionId` INTEGER NOT NULL DEFAULT 0, `erDestination` INTEGER NOT NULL, `erPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`erPk`, `erDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ErrorReportReplicate_erPk_erDestination_erVersionId` ON `ErrorReportReplicate` (`erPk`, `erDestination`, `erVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ErrorReportReplicate_erDestination_erPending` ON `ErrorReportReplicate` (`erDestination`, `erPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ClazzAssignmentReplicate` (`caPk` INTEGER NOT NULL, `caVersionId` INTEGER NOT NULL DEFAULT 0, `caDestination` INTEGER NOT NULL, `caPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`caPk`, `caDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzAssignmentReplicate_caPk_caDestination_caVersionId` ON `ClazzAssignmentReplicate` (`caPk`, `caDestination`, `caVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzAssignmentReplicate_caDestination_caPending` ON `ClazzAssignmentReplicate` (`caDestination`, `caPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ClazzAssignmentContentJoinReplicate` (`cacjPk` INTEGER NOT NULL, `cacjVersionId` INTEGER NOT NULL DEFAULT 0, `cacjDestination` INTEGER NOT NULL, `cacjPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`cacjPk`, `cacjDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzAssignmentContentJoinReplicate_cacjPk_cacjDestination_cacjVersionId` ON `ClazzAssignmentContentJoinReplicate` (`cacjPk`, `cacjDestination`, `cacjVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ClazzAssignmentContentJoinReplicate_cacjDestination_cacjPending` ON `ClazzAssignmentContentJoinReplicate` (`cacjDestination`, `cacjPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `PersonAuth2Replicate` (`paPk` INTEGER NOT NULL, `paVersionId` INTEGER NOT NULL DEFAULT 0, `paDestination` INTEGER NOT NULL, `paPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`paPk`, `paDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PersonAuth2Replicate_paPk_paDestination_paVersionId` ON `PersonAuth2Replicate` (`paPk`, `paDestination`, `paVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PersonAuth2Replicate_paDestination_paPending` ON `PersonAuth2Replicate` (`paDestination`, `paPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `UserSessionReplicate` (`usPk` INTEGER NOT NULL, `usVersionId` INTEGER NOT NULL DEFAULT 0, `usDestination` INTEGER NOT NULL, `usPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`usPk`, `usDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_UserSessionReplicate_usPk_usDestination_usVersionId` ON `UserSessionReplicate` (`usPk`, `usDestination`, `usVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_UserSessionReplicate_usDestination_usPending` ON `UserSessionReplicate` (`usDestination`, `usPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CoursePicture` (`coursePictureUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `coursePictureClazzUid` INTEGER NOT NULL, `coursePictureMasterCsn` INTEGER NOT NULL, `coursePictureLocalCsn` INTEGER NOT NULL, `coursePictureLastChangedBy` INTEGER NOT NULL, `coursePictureLct` INTEGER NOT NULL, `coursePictureUri` TEXT, `coursePictureMd5` TEXT, `coursePictureFileSize` INTEGER NOT NULL, `coursePictureTimestamp` INTEGER NOT NULL, `coursePictureMimeType` TEXT, `coursePictureActive` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CoursePictureReplicate` (`cpPk` INTEGER NOT NULL, `cpVersionId` INTEGER NOT NULL DEFAULT 0, `cpDestination` INTEGER NOT NULL, `cpPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`cpPk`, `cpDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CoursePictureReplicate_cpPk_cpDestination_cpVersionId` ON `CoursePictureReplicate` (`cpPk`, `cpDestination`, `cpVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CoursePictureReplicate_cpDestination_cpPending` ON `CoursePictureReplicate` (`cpDestination`, `cpPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentEntryPicture` (`cepUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `cepContentEntryUid` INTEGER NOT NULL, `cepUri` TEXT, `cepMd5` TEXT, `cepFileSize` INTEGER NOT NULL, `cepTimestamp` INTEGER NOT NULL, `cepMimeType` TEXT, `cepActive` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ContentEntryPictureReplicate` (`cepPk` INTEGER NOT NULL, `cepVersionId` INTEGER NOT NULL DEFAULT 0, `cepDestination` INTEGER NOT NULL, `cepPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`cepPk`, `cepDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentEntryPictureReplicate_cepPk_cepDestination_cepVersionId` ON `ContentEntryPictureReplicate` (`cepPk`, `cepDestination`, `cepVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ContentEntryPictureReplicate_cepDestination_cepPending` ON `ContentEntryPictureReplicate` (`cepDestination`, `cepPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `Chat` (`chatUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `chatStartDate` INTEGER NOT NULL, `chatTitle` TEXT, `chatGroup` INTEGER NOT NULL, `chatLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ChatMember` (`chatMemberUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `chatMemberChatUid` INTEGER NOT NULL, `chatMemberPersonUid` INTEGER NOT NULL, `chatMemberJoinedDate` INTEGER NOT NULL, `chatMemberLeftDate` INTEGER NOT NULL, `chatMemberLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `Message` (`messageUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `messageSenderPersonUid` INTEGER NOT NULL, `messageTableId` INTEGER NOT NULL, `messageEntityUid` INTEGER NOT NULL, `messageText` TEXT, `messageTimestamp` INTEGER NOT NULL, `messageClazzUid` INTEGER NOT NULL, `messageLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `MessageReplicate` (`messagePk` INTEGER NOT NULL, `messageVersionId` INTEGER NOT NULL DEFAULT 0, `messageDestination` INTEGER NOT NULL, `messagePending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`messagePk`, `messageDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_MessageReplicate_messagePk_messageDestination_messageVersionId` ON `MessageReplicate` (`messagePk`, `messageDestination`, `messageVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_MessageReplicate_messageDestination_messagePending` ON `MessageReplicate` (`messageDestination`, `messagePending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ChatReplicate` (`chatPk` INTEGER NOT NULL, `chatVersionId` INTEGER NOT NULL DEFAULT 0, `chatDestination` INTEGER NOT NULL, `chatPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`chatPk`, `chatDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ChatReplicate_chatPk_chatDestination_chatVersionId` ON `ChatReplicate` (`chatPk`, `chatDestination`, `chatVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ChatReplicate_chatDestination_chatPending` ON `ChatReplicate` (`chatDestination`, `chatPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `ChatMemberReplicate` (`chatMemberPk` INTEGER NOT NULL, `chatMemberVersionId` INTEGER NOT NULL DEFAULT 0, `chatMemberDestination` INTEGER NOT NULL, `chatMemberPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`chatMemberPk`, `chatMemberDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ChatMemberReplicate_chatMemberPk_chatMemberDestination_chatMemberVersionId` ON `ChatMemberReplicate` (`chatMemberPk`, `chatMemberDestination`, `chatMemberVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_ChatMemberReplicate_chatMemberDestination_chatMemberPending` ON `ChatMemberReplicate` (`chatMemberDestination`, `chatMemberPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `MessageRead` (`messageReadUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `messageReadPersonUid` INTEGER NOT NULL, `messageReadMessageUid` INTEGER NOT NULL, `messageReadEntityUid` INTEGER NOT NULL, `messageReadLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `MessageReadReplicate` (`messageReadPk` INTEGER NOT NULL, `messageReadVersionId` INTEGER NOT NULL DEFAULT 0, `messageReadDestination` INTEGER NOT NULL, `messageReadPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`messageReadPk`, `messageReadDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_MessageReadReplicate_messageReadPk_messageReadDestination_messageReadVersionId` ON `MessageReadReplicate` (`messageReadPk`, `messageReadDestination`, `messageReadVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_MessageReadReplicate_messageReadDestination_messageReadPending` ON `MessageReadReplicate` (`messageReadDestination`, `messageReadPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseDiscussion` (`courseDiscussionUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `courseDiscussionTitle` TEXT, `courseDiscussionDesc` TEXT, `courseDiscussionClazzUid` INTEGER NOT NULL, `courseDiscussionActive` INTEGER NOT NULL, `courseDiscussionLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `CourseDiscussionReplicate` (`courseDiscussionPk` INTEGER NOT NULL, `courseDiscussionVersionId` INTEGER NOT NULL DEFAULT 0, `courseDiscussionDestination` INTEGER NOT NULL, `courseDiscussionPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`courseDiscussionPk`, `courseDiscussionDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseDiscussionReplicate_courseDiscussionPk_courseDiscussionDestination_courseDiscussionVersionId` ON `CourseDiscussionReplicate` (`courseDiscussionPk`, `courseDiscussionDestination`, `courseDiscussionVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_CourseDiscussionReplicate_courseDiscussionDestination_courseDiscussionPending` ON `CourseDiscussionReplicate` (`courseDiscussionDestination`, `courseDiscussionPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `DiscussionTopic` (`discussionTopicUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `discussionTopicTitle` TEXT, `discussionTopicDesc` TEXT, `discussionTopicStartDate` INTEGER NOT NULL, `discussionTopicCourseDiscussionUid` INTEGER NOT NULL, `discussionTopicVisible` INTEGER NOT NULL, `discussionTopicArchive` INTEGER NOT NULL, `discussionTopicIndex` INTEGER NOT NULL, `discussionTopicClazzUid` INTEGER NOT NULL, `discussionTopicLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `DiscussionTopicReplicate` (`discussionTopicPk` INTEGER NOT NULL, `discussionTopicVersionId` INTEGER NOT NULL DEFAULT 0, `discussionTopicDestination` INTEGER NOT NULL, `discussionTopicPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`discussionTopicPk`, `discussionTopicDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_DiscussionTopicReplicate_discussionTopicPk_discussionTopicDestination_discussionTopicVersionId` ON `DiscussionTopicReplicate` (`discussionTopicPk`, `discussionTopicDestination`, `discussionTopicVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_DiscussionTopicReplicate_discussionTopicDestination_discussionTopicPending` ON `DiscussionTopicReplicate` (`discussionTopicDestination`, `discussionTopicPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `DiscussionPost` (`discussionPostUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `discussionPostTitle` TEXT, `discussionPostMessage` TEXT, `discussionPostStartDate` INTEGER NOT NULL, `discussionPostDiscussionTopicUid` INTEGER NOT NULL, `discussionPostVisible` INTEGER NOT NULL, `discussionPostArchive` INTEGER NOT NULL, `discussionPostStartedPersonUid` INTEGER NOT NULL, `discussionPostClazzUid` INTEGER NOT NULL, `discussionPostLct` INTEGER NOT NULL)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `DiscussionPostReplicate` (`discussionPostPk` INTEGER NOT NULL, `discussionPostVersionId` INTEGER NOT NULL DEFAULT 0, `discussionPostDestination` INTEGER NOT NULL, `discussionPostPending` INTEGER NOT NULL DEFAULT 1, PRIMARY KEY(`discussionPostPk`, `discussionPostDestination`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_DiscussionPostReplicate_discussionPostPk_discussionPostDestination_discussionPostVersionId` ON `DiscussionPostReplicate` (`discussionPostPk`, `discussionPostDestination`, `discussionPostVersionId`)");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_DiscussionPostReplicate_discussionPostDestination_discussionPostPending` ON `DiscussionPostReplicate` (`discussionPostDestination`, `discussionPostPending`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
        _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'c4bdb0bd24b59faab1b3d90846470bdf')");
      }

      @Override
      public void dropAllTables(SupportSQLiteDatabase _db) {
        _db.execSQL("DROP TABLE IF EXISTS `NetworkNode`");
        _db.execSQL("DROP TABLE IF EXISTS `ClazzLog`");
        _db.execSQL("DROP TABLE IF EXISTS `ClazzLogAttendanceRecord`");
        _db.execSQL("DROP TABLE IF EXISTS `Schedule`");
        _db.execSQL("DROP TABLE IF EXISTS `DateRange`");
        _db.execSQL("DROP TABLE IF EXISTS `HolidayCalendar`");
        _db.execSQL("DROP TABLE IF EXISTS `Holiday`");
        _db.execSQL("DROP TABLE IF EXISTS `ScheduledCheck`");
        _db.execSQL("DROP TABLE IF EXISTS `AuditLog`");
        _db.execSQL("DROP TABLE IF EXISTS `CustomField`");
        _db.execSQL("DROP TABLE IF EXISTS `CustomFieldValue`");
        _db.execSQL("DROP TABLE IF EXISTS `CustomFieldValueOption`");
        _db.execSQL("DROP TABLE IF EXISTS `Person`");
        _db.execSQL("DROP TABLE IF EXISTS `Clazz`");
        _db.execSQL("DROP TABLE IF EXISTS `ClazzEnrolment`");
        _db.execSQL("DROP TABLE IF EXISTS `LeavingReason`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentEntry`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentEntryContentCategoryJoin`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentEntryParentChildJoin`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentEntryRelatedEntryJoin`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentCategorySchema`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentCategory`");
        _db.execSQL("DROP TABLE IF EXISTS `Language`");
        _db.execSQL("DROP TABLE IF EXISTS `LanguageVariant`");
        _db.execSQL("DROP TABLE IF EXISTS `AccessToken`");
        _db.execSQL("DROP TABLE IF EXISTS `PersonAuth`");
        _db.execSQL("DROP TABLE IF EXISTS `Role`");
        _db.execSQL("DROP TABLE IF EXISTS `EntityRole`");
        _db.execSQL("DROP TABLE IF EXISTS `PersonGroup`");
        _db.execSQL("DROP TABLE IF EXISTS `PersonGroupMember`");
        _db.execSQL("DROP TABLE IF EXISTS `PersonPicture`");
        _db.execSQL("DROP TABLE IF EXISTS `ScrapeQueueItem`");
        _db.execSQL("DROP TABLE IF EXISTS `ScrapeRun`");
        _db.execSQL("DROP TABLE IF EXISTS `ConnectivityStatus`");
        _db.execSQL("DROP TABLE IF EXISTS `Container`");
        _db.execSQL("DROP TABLE IF EXISTS `ContainerEntry`");
        _db.execSQL("DROP TABLE IF EXISTS `ContainerEntryFile`");
        _db.execSQL("DROP TABLE IF EXISTS `VerbEntity`");
        _db.execSQL("DROP TABLE IF EXISTS `XObjectEntity`");
        _db.execSQL("DROP TABLE IF EXISTS `StatementEntity`");
        _db.execSQL("DROP TABLE IF EXISTS `ContextXObjectStatementJoin`");
        _db.execSQL("DROP TABLE IF EXISTS `AgentEntity`");
        _db.execSQL("DROP TABLE IF EXISTS `StateEntity`");
        _db.execSQL("DROP TABLE IF EXISTS `StateContentEntity`");
        _db.execSQL("DROP TABLE IF EXISTS `XLangMapEntry`");
        _db.execSQL("DROP TABLE IF EXISTS `SyncNode`");
        _db.execSQL("DROP TABLE IF EXISTS `LocallyAvailableContainer`");
        _db.execSQL("DROP TABLE IF EXISTS `ContainerETag`");
        _db.execSQL("DROP TABLE IF EXISTS `School`");
        _db.execSQL("DROP TABLE IF EXISTS `SchoolMember`");
        _db.execSQL("DROP TABLE IF EXISTS `Comments`");
        _db.execSQL("DROP TABLE IF EXISTS `Report`");
        _db.execSQL("DROP TABLE IF EXISTS `Site`");
        _db.execSQL("DROP TABLE IF EXISTS `ContainerImportJob`");
        _db.execSQL("DROP TABLE IF EXISTS `LearnerGroup`");
        _db.execSQL("DROP TABLE IF EXISTS `LearnerGroupMember`");
        _db.execSQL("DROP TABLE IF EXISTS `GroupLearningSession`");
        _db.execSQL("DROP TABLE IF EXISTS `SiteTerms`");
        _db.execSQL("DROP TABLE IF EXISTS `ClazzContentJoin`");
        _db.execSQL("DROP TABLE IF EXISTS `PersonParentJoin`");
        _db.execSQL("DROP TABLE IF EXISTS `ScopedGrant`");
        _db.execSQL("DROP TABLE IF EXISTS `ErrorReport`");
        _db.execSQL("DROP TABLE IF EXISTS `ClazzAssignment`");
        _db.execSQL("DROP TABLE IF EXISTS `ClazzAssignmentContentJoin`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseAssignmentSubmission`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseAssignmentSubmissionAttachment`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseAssignmentMark`");
        _db.execSQL("DROP TABLE IF EXISTS `ClazzAssignmentRollUp`");
        _db.execSQL("DROP TABLE IF EXISTS `PersonAuth2`");
        _db.execSQL("DROP TABLE IF EXISTS `UserSession`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentJob`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentJobItem`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseBlock`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseTerminology`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseGroupSet`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseGroupMember`");
        _db.execSQL("DROP TABLE IF EXISTS `ChangeLog`");
        _db.execSQL("DROP TABLE IF EXISTS `ZombieAttachmentData`");
        _db.execSQL("DROP TABLE IF EXISTS `DoorNode`");
        _db.execSQL("DROP TABLE IF EXISTS `ReplicationStatus`");
        _db.execSQL("DROP TABLE IF EXISTS `ClazzLogReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ClazzLogAttendanceRecordReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseAssignmentSubmissionReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseAssignmentSubmissionAttachmentReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseAssignmentMarkReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseBlockReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseTerminologyReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseGroupSetReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseGroupMemberReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ScheduleReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `HolidayCalendarReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `HolidayReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `PersonReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ClazzReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ClazzEnrolmentReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `LeavingReasonReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentEntryReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentEntryContentCategoryJoinReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentEntryParentChildJoinReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentEntryRelatedEntryJoinReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentCategorySchemaReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentCategoryReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `LanguageReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `LanguageVariantReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `PersonGroupReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `PersonGroupMemberReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `PersonPictureReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ContainerReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `VerbEntityReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `XObjectEntityReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `StatementEntityReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ContextXObjectStatementJoinReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `AgentEntityReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `StateEntityReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `StateContentEntityReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `XLangMapEntryReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `SchoolReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `SchoolMemberReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `CommentsReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ReportReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `SiteReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `LearnerGroupReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `LearnerGroupMemberReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `GroupLearningSessionReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `SiteTermsReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ClazzContentJoinReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `PersonParentJoinReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ScopedGrantReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ErrorReportReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ClazzAssignmentReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ClazzAssignmentContentJoinReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `PersonAuth2Replicate`");
        _db.execSQL("DROP TABLE IF EXISTS `UserSessionReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `CoursePicture`");
        _db.execSQL("DROP TABLE IF EXISTS `CoursePictureReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentEntryPicture`");
        _db.execSQL("DROP TABLE IF EXISTS `ContentEntryPictureReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `Chat`");
        _db.execSQL("DROP TABLE IF EXISTS `ChatMember`");
        _db.execSQL("DROP TABLE IF EXISTS `Message`");
        _db.execSQL("DROP TABLE IF EXISTS `MessageReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ChatReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `ChatMemberReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `MessageRead`");
        _db.execSQL("DROP TABLE IF EXISTS `MessageReadReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseDiscussion`");
        _db.execSQL("DROP TABLE IF EXISTS `CourseDiscussionReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `DiscussionTopic`");
        _db.execSQL("DROP TABLE IF EXISTS `DiscussionTopicReplicate`");
        _db.execSQL("DROP TABLE IF EXISTS `DiscussionPost`");
        _db.execSQL("DROP TABLE IF EXISTS `DiscussionPostReplicate`");
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onDestructiveMigration(_db);
          }
        }
      }

      @Override
      protected void onCreate(SupportSQLiteDatabase _db) {
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onCreate(_db);
          }
        }
      }

      @Override
      public void onOpen(SupportSQLiteDatabase _db) {
        mDatabase = _db;
        internalInitInvalidationTracker(_db);
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onOpen(_db);
          }
        }
      }

      @Override
      public void onPreMigrate(SupportSQLiteDatabase _db) {
        DBUtil.dropFtsSyncTriggers(_db);
      }

      @Override
      public void onPostMigrate(SupportSQLiteDatabase _db) {
      }

      @Override
      protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
        final HashMap<String, TableInfo.Column> _columnsNetworkNode = new HashMap<String, TableInfo.Column>(13);
        _columnsNetworkNode.put("nodeId", new TableInfo.Column("nodeId", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNetworkNode.put("bluetoothMacAddress", new TableInfo.Column("bluetoothMacAddress", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNetworkNode.put("ipAddress", new TableInfo.Column("ipAddress", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNetworkNode.put("wifiDirectMacAddress", new TableInfo.Column("wifiDirectMacAddress", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNetworkNode.put("deviceWifiDirectName", new TableInfo.Column("deviceWifiDirectName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNetworkNode.put("endpointUrl", new TableInfo.Column("endpointUrl", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNetworkNode.put("lastUpdateTimeStamp", new TableInfo.Column("lastUpdateTimeStamp", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNetworkNode.put("networkServiceLastUpdated", new TableInfo.Column("networkServiceLastUpdated", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNetworkNode.put("nsdServiceName", new TableInfo.Column("nsdServiceName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNetworkNode.put("port", new TableInfo.Column("port", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNetworkNode.put("numFailureCount", new TableInfo.Column("numFailureCount", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNetworkNode.put("wifiDirectDeviceStatus", new TableInfo.Column("wifiDirectDeviceStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsNetworkNode.put("groupSsid", new TableInfo.Column("groupSsid", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysNetworkNode = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesNetworkNode = new HashSet<TableInfo.Index>(2);
        _indicesNetworkNode.add(new TableInfo.Index("index_NetworkNode_bluetoothMacAddress", false, Arrays.asList("bluetoothMacAddress"), Arrays.asList("ASC")));
        _indicesNetworkNode.add(new TableInfo.Index("index_NetworkNode_lastUpdateTimeStamp", false, Arrays.asList("lastUpdateTimeStamp"), Arrays.asList("ASC")));
        final TableInfo _infoNetworkNode = new TableInfo("NetworkNode", _columnsNetworkNode, _foreignKeysNetworkNode, _indicesNetworkNode);
        final TableInfo _existingNetworkNode = TableInfo.read(_db, "NetworkNode");
        if (! _infoNetworkNode.equals(_existingNetworkNode)) {
          return new RoomOpenHelper.ValidationResult(false, "NetworkNode(com.ustadmobile.lib.db.entities.NetworkNode).\n"
                  + " Expected:\n" + _infoNetworkNode + "\n"
                  + " Found:\n" + _existingNetworkNode);
        }
        final HashMap<String, TableInfo.Column> _columnsClazzLog = new HashMap<String, TableInfo.Column>(16);
        _columnsClazzLog.put("clazzLogUid", new TableInfo.Column("clazzLogUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLog.put("clazzLogClazzUid", new TableInfo.Column("clazzLogClazzUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLog.put("logDate", new TableInfo.Column("logDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLog.put("timeRecorded", new TableInfo.Column("timeRecorded", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLog.put("clazzLogDone", new TableInfo.Column("clazzLogDone", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLog.put("cancellationNote", new TableInfo.Column("cancellationNote", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLog.put("clazzLogCancelled", new TableInfo.Column("clazzLogCancelled", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLog.put("clazzLogNumPresent", new TableInfo.Column("clazzLogNumPresent", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLog.put("clazzLogNumAbsent", new TableInfo.Column("clazzLogNumAbsent", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLog.put("clazzLogNumPartial", new TableInfo.Column("clazzLogNumPartial", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLog.put("clazzLogScheduleUid", new TableInfo.Column("clazzLogScheduleUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLog.put("clazzLogStatusFlag", new TableInfo.Column("clazzLogStatusFlag", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLog.put("clazzLogMSQN", new TableInfo.Column("clazzLogMSQN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLog.put("clazzLogLCSN", new TableInfo.Column("clazzLogLCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLog.put("clazzLogLCB", new TableInfo.Column("clazzLogLCB", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLog.put("clazzLogLastChangedTime", new TableInfo.Column("clazzLogLastChangedTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysClazzLog = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesClazzLog = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoClazzLog = new TableInfo("ClazzLog", _columnsClazzLog, _foreignKeysClazzLog, _indicesClazzLog);
        final TableInfo _existingClazzLog = TableInfo.read(_db, "ClazzLog");
        if (! _infoClazzLog.equals(_existingClazzLog)) {
          return new RoomOpenHelper.ValidationResult(false, "ClazzLog(com.ustadmobile.lib.db.entities.ClazzLog).\n"
                  + " Expected:\n" + _infoClazzLog + "\n"
                  + " Found:\n" + _existingClazzLog);
        }
        final HashMap<String, TableInfo.Column> _columnsClazzLogAttendanceRecord = new HashMap<String, TableInfo.Column>(8);
        _columnsClazzLogAttendanceRecord.put("clazzLogAttendanceRecordUid", new TableInfo.Column("clazzLogAttendanceRecordUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLogAttendanceRecord.put("clazzLogAttendanceRecordClazzLogUid", new TableInfo.Column("clazzLogAttendanceRecordClazzLogUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLogAttendanceRecord.put("clazzLogAttendanceRecordPersonUid", new TableInfo.Column("clazzLogAttendanceRecordPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLogAttendanceRecord.put("attendanceStatus", new TableInfo.Column("attendanceStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLogAttendanceRecord.put("clazzLogAttendanceRecordMasterChangeSeqNum", new TableInfo.Column("clazzLogAttendanceRecordMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLogAttendanceRecord.put("clazzLogAttendanceRecordLocalChangeSeqNum", new TableInfo.Column("clazzLogAttendanceRecordLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLogAttendanceRecord.put("clazzLogAttendanceRecordLastChangedBy", new TableInfo.Column("clazzLogAttendanceRecordLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLogAttendanceRecord.put("clazzLogAttendanceRecordLastChangedTime", new TableInfo.Column("clazzLogAttendanceRecordLastChangedTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysClazzLogAttendanceRecord = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesClazzLogAttendanceRecord = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoClazzLogAttendanceRecord = new TableInfo("ClazzLogAttendanceRecord", _columnsClazzLogAttendanceRecord, _foreignKeysClazzLogAttendanceRecord, _indicesClazzLogAttendanceRecord);
        final TableInfo _existingClazzLogAttendanceRecord = TableInfo.read(_db, "ClazzLogAttendanceRecord");
        if (! _infoClazzLogAttendanceRecord.equals(_existingClazzLogAttendanceRecord)) {
          return new RoomOpenHelper.ValidationResult(false, "ClazzLogAttendanceRecord(com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecord).\n"
                  + " Expected:\n" + _infoClazzLogAttendanceRecord + "\n"
                  + " Found:\n" + _existingClazzLogAttendanceRecord);
        }
        final HashMap<String, TableInfo.Column> _columnsSchedule = new HashMap<String, TableInfo.Column>(13);
        _columnsSchedule.put("scheduleUid", new TableInfo.Column("scheduleUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchedule.put("sceduleStartTime", new TableInfo.Column("sceduleStartTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchedule.put("scheduleEndTime", new TableInfo.Column("scheduleEndTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchedule.put("scheduleDay", new TableInfo.Column("scheduleDay", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchedule.put("scheduleMonth", new TableInfo.Column("scheduleMonth", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchedule.put("scheduleFrequency", new TableInfo.Column("scheduleFrequency", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchedule.put("umCalendarUid", new TableInfo.Column("umCalendarUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchedule.put("scheduleClazzUid", new TableInfo.Column("scheduleClazzUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchedule.put("scheduleMasterChangeSeqNum", new TableInfo.Column("scheduleMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchedule.put("scheduleLocalChangeSeqNum", new TableInfo.Column("scheduleLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchedule.put("scheduleLastChangedBy", new TableInfo.Column("scheduleLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchedule.put("scheduleLastChangedTime", new TableInfo.Column("scheduleLastChangedTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchedule.put("scheduleActive", new TableInfo.Column("scheduleActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysSchedule = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesSchedule = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoSchedule = new TableInfo("Schedule", _columnsSchedule, _foreignKeysSchedule, _indicesSchedule);
        final TableInfo _existingSchedule = TableInfo.read(_db, "Schedule");
        if (! _infoSchedule.equals(_existingSchedule)) {
          return new RoomOpenHelper.ValidationResult(false, "Schedule(com.ustadmobile.lib.db.entities.Schedule).\n"
                  + " Expected:\n" + _infoSchedule + "\n"
                  + " Found:\n" + _existingSchedule);
        }
        final HashMap<String, TableInfo.Column> _columnsDateRange = new HashMap<String, TableInfo.Column>(11);
        _columnsDateRange.put("dateRangeUid", new TableInfo.Column("dateRangeUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDateRange.put("dateRangeLocalChangeSeqNum", new TableInfo.Column("dateRangeLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDateRange.put("dateRangeMasterChangeSeqNum", new TableInfo.Column("dateRangeMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDateRange.put("dateRangLastChangedBy", new TableInfo.Column("dateRangLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDateRange.put("dateRangeLct", new TableInfo.Column("dateRangeLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDateRange.put("dateRangeFromDate", new TableInfo.Column("dateRangeFromDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDateRange.put("dateRangeToDate", new TableInfo.Column("dateRangeToDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDateRange.put("dateRangeUMCalendarUid", new TableInfo.Column("dateRangeUMCalendarUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDateRange.put("dateRangeName", new TableInfo.Column("dateRangeName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDateRange.put("dateRangeDesc", new TableInfo.Column("dateRangeDesc", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDateRange.put("dateRangeActive", new TableInfo.Column("dateRangeActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysDateRange = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesDateRange = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoDateRange = new TableInfo("DateRange", _columnsDateRange, _foreignKeysDateRange, _indicesDateRange);
        final TableInfo _existingDateRange = TableInfo.read(_db, "DateRange");
        if (! _infoDateRange.equals(_existingDateRange)) {
          return new RoomOpenHelper.ValidationResult(false, "DateRange(com.ustadmobile.lib.db.entities.DateRange).\n"
                  + " Expected:\n" + _infoDateRange + "\n"
                  + " Found:\n" + _existingDateRange);
        }
        final HashMap<String, TableInfo.Column> _columnsHolidayCalendar = new HashMap<String, TableInfo.Column>(8);
        _columnsHolidayCalendar.put("umCalendarUid", new TableInfo.Column("umCalendarUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHolidayCalendar.put("umCalendarName", new TableInfo.Column("umCalendarName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHolidayCalendar.put("umCalendarCategory", new TableInfo.Column("umCalendarCategory", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHolidayCalendar.put("umCalendarActive", new TableInfo.Column("umCalendarActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHolidayCalendar.put("umCalendarMasterChangeSeqNum", new TableInfo.Column("umCalendarMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHolidayCalendar.put("umCalendarLocalChangeSeqNum", new TableInfo.Column("umCalendarLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHolidayCalendar.put("umCalendarLastChangedBy", new TableInfo.Column("umCalendarLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHolidayCalendar.put("umCalendarLct", new TableInfo.Column("umCalendarLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysHolidayCalendar = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesHolidayCalendar = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoHolidayCalendar = new TableInfo("HolidayCalendar", _columnsHolidayCalendar, _foreignKeysHolidayCalendar, _indicesHolidayCalendar);
        final TableInfo _existingHolidayCalendar = TableInfo.read(_db, "HolidayCalendar");
        if (! _infoHolidayCalendar.equals(_existingHolidayCalendar)) {
          return new RoomOpenHelper.ValidationResult(false, "HolidayCalendar(com.ustadmobile.lib.db.entities.HolidayCalendar).\n"
                  + " Expected:\n" + _infoHolidayCalendar + "\n"
                  + " Found:\n" + _existingHolidayCalendar);
        }
        final HashMap<String, TableInfo.Column> _columnsHoliday = new HashMap<String, TableInfo.Column>(10);
        _columnsHoliday.put("holUid", new TableInfo.Column("holUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHoliday.put("holMasterCsn", new TableInfo.Column("holMasterCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHoliday.put("holLocalCsn", new TableInfo.Column("holLocalCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHoliday.put("holLastModBy", new TableInfo.Column("holLastModBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHoliday.put("holLct", new TableInfo.Column("holLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHoliday.put("holActive", new TableInfo.Column("holActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHoliday.put("holHolidayCalendarUid", new TableInfo.Column("holHolidayCalendarUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHoliday.put("holStartTime", new TableInfo.Column("holStartTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHoliday.put("holEndTime", new TableInfo.Column("holEndTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHoliday.put("holName", new TableInfo.Column("holName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysHoliday = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesHoliday = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoHoliday = new TableInfo("Holiday", _columnsHoliday, _foreignKeysHoliday, _indicesHoliday);
        final TableInfo _existingHoliday = TableInfo.read(_db, "Holiday");
        if (! _infoHoliday.equals(_existingHoliday)) {
          return new RoomOpenHelper.ValidationResult(false, "Holiday(com.ustadmobile.lib.db.entities.Holiday).\n"
                  + " Expected:\n" + _infoHoliday + "\n"
                  + " Found:\n" + _existingHoliday);
        }
        final HashMap<String, TableInfo.Column> _columnsScheduledCheck = new HashMap<String, TableInfo.Column>(10);
        _columnsScheduledCheck.put("scheduledCheckUid", new TableInfo.Column("scheduledCheckUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScheduledCheck.put("checkTime", new TableInfo.Column("checkTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScheduledCheck.put("checkType", new TableInfo.Column("checkType", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScheduledCheck.put("checkUuid", new TableInfo.Column("checkUuid", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScheduledCheck.put("checkParameters", new TableInfo.Column("checkParameters", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScheduledCheck.put("scClazzLogUid", new TableInfo.Column("scClazzLogUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScheduledCheck.put("scheduledCheckMasterCsn", new TableInfo.Column("scheduledCheckMasterCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScheduledCheck.put("scheduledCheckLocalCsn", new TableInfo.Column("scheduledCheckLocalCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScheduledCheck.put("scheduledCheckLastChangedBy", new TableInfo.Column("scheduledCheckLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScheduledCheck.put("scheduledCheckLct", new TableInfo.Column("scheduledCheckLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysScheduledCheck = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesScheduledCheck = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoScheduledCheck = new TableInfo("ScheduledCheck", _columnsScheduledCheck, _foreignKeysScheduledCheck, _indicesScheduledCheck);
        final TableInfo _existingScheduledCheck = TableInfo.read(_db, "ScheduledCheck");
        if (! _infoScheduledCheck.equals(_existingScheduledCheck)) {
          return new RoomOpenHelper.ValidationResult(false, "ScheduledCheck(com.ustadmobile.lib.db.entities.ScheduledCheck).\n"
                  + " Expected:\n" + _infoScheduledCheck + "\n"
                  + " Found:\n" + _existingScheduledCheck);
        }
        final HashMap<String, TableInfo.Column> _columnsAuditLog = new HashMap<String, TableInfo.Column>(10);
        _columnsAuditLog.put("auditLogUid", new TableInfo.Column("auditLogUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAuditLog.put("auditLogMasterChangeSeqNum", new TableInfo.Column("auditLogMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAuditLog.put("auditLogLocalChangeSeqNum", new TableInfo.Column("auditLogLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAuditLog.put("auditLogLastChangedBy", new TableInfo.Column("auditLogLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAuditLog.put("auditLogLct", new TableInfo.Column("auditLogLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAuditLog.put("auditLogActorPersonUid", new TableInfo.Column("auditLogActorPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAuditLog.put("auditLogTableUid", new TableInfo.Column("auditLogTableUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAuditLog.put("auditLogEntityUid", new TableInfo.Column("auditLogEntityUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAuditLog.put("auditLogDate", new TableInfo.Column("auditLogDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAuditLog.put("notes", new TableInfo.Column("notes", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAuditLog = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesAuditLog = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoAuditLog = new TableInfo("AuditLog", _columnsAuditLog, _foreignKeysAuditLog, _indicesAuditLog);
        final TableInfo _existingAuditLog = TableInfo.read(_db, "AuditLog");
        if (! _infoAuditLog.equals(_existingAuditLog)) {
          return new RoomOpenHelper.ValidationResult(false, "AuditLog(com.ustadmobile.lib.db.entities.AuditLog).\n"
                  + " Expected:\n" + _infoAuditLog + "\n"
                  + " Found:\n" + _existingAuditLog);
        }
        final HashMap<String, TableInfo.Column> _columnsCustomField = new HashMap<String, TableInfo.Column>(16);
        _columnsCustomField.put("customFieldUid", new TableInfo.Column("customFieldUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomField.put("customFieldName", new TableInfo.Column("customFieldName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomField.put("customFieldNameAlt", new TableInfo.Column("customFieldNameAlt", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomField.put("customFieldLabelMessageID", new TableInfo.Column("customFieldLabelMessageID", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomField.put("customFieldIcon", new TableInfo.Column("customFieldIcon", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomField.put("customFieldIconId", new TableInfo.Column("customFieldIconId", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomField.put("actionOnClick", new TableInfo.Column("actionOnClick", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomField.put("customFieldType", new TableInfo.Column("customFieldType", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomField.put("customFieldEntityType", new TableInfo.Column("customFieldEntityType", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomField.put("customFieldActive", new TableInfo.Column("customFieldActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomField.put("customFieldDefaultValue", new TableInfo.Column("customFieldDefaultValue", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomField.put("customFieldMCSN", new TableInfo.Column("customFieldMCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomField.put("customFieldLCSN", new TableInfo.Column("customFieldLCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomField.put("customFieldLCB", new TableInfo.Column("customFieldLCB", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomField.put("customFieldLct", new TableInfo.Column("customFieldLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomField.put("customFieldInputType", new TableInfo.Column("customFieldInputType", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCustomField = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCustomField = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoCustomField = new TableInfo("CustomField", _columnsCustomField, _foreignKeysCustomField, _indicesCustomField);
        final TableInfo _existingCustomField = TableInfo.read(_db, "CustomField");
        if (! _infoCustomField.equals(_existingCustomField)) {
          return new RoomOpenHelper.ValidationResult(false, "CustomField(com.ustadmobile.lib.db.entities.CustomField).\n"
                  + " Expected:\n" + _infoCustomField + "\n"
                  + " Found:\n" + _existingCustomField);
        }
        final HashMap<String, TableInfo.Column> _columnsCustomFieldValue = new HashMap<String, TableInfo.Column>(9);
        _columnsCustomFieldValue.put("customFieldValueUid", new TableInfo.Column("customFieldValueUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValue.put("customFieldValueFieldUid", new TableInfo.Column("customFieldValueFieldUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValue.put("customFieldValueEntityUid", new TableInfo.Column("customFieldValueEntityUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValue.put("customFieldValueValue", new TableInfo.Column("customFieldValueValue", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValue.put("customFieldValueCustomFieldValueOptionUid", new TableInfo.Column("customFieldValueCustomFieldValueOptionUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValue.put("customFieldValueMCSN", new TableInfo.Column("customFieldValueMCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValue.put("customFieldValueLCSN", new TableInfo.Column("customFieldValueLCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValue.put("customFieldValueLCB", new TableInfo.Column("customFieldValueLCB", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValue.put("customFieldLct", new TableInfo.Column("customFieldLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCustomFieldValue = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCustomFieldValue = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoCustomFieldValue = new TableInfo("CustomFieldValue", _columnsCustomFieldValue, _foreignKeysCustomFieldValue, _indicesCustomFieldValue);
        final TableInfo _existingCustomFieldValue = TableInfo.read(_db, "CustomFieldValue");
        if (! _infoCustomFieldValue.equals(_existingCustomFieldValue)) {
          return new RoomOpenHelper.ValidationResult(false, "CustomFieldValue(com.ustadmobile.lib.db.entities.CustomFieldValue).\n"
                  + " Expected:\n" + _infoCustomFieldValue + "\n"
                  + " Found:\n" + _existingCustomFieldValue);
        }
        final HashMap<String, TableInfo.Column> _columnsCustomFieldValueOption = new HashMap<String, TableInfo.Column>(10);
        _columnsCustomFieldValueOption.put("customFieldValueOptionUid", new TableInfo.Column("customFieldValueOptionUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValueOption.put("customFieldValueOptionName", new TableInfo.Column("customFieldValueOptionName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValueOption.put("customFieldValueOptionFieldUid", new TableInfo.Column("customFieldValueOptionFieldUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValueOption.put("customFieldValueOptionIcon", new TableInfo.Column("customFieldValueOptionIcon", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValueOption.put("customFieldValueOptionMessageId", new TableInfo.Column("customFieldValueOptionMessageId", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValueOption.put("customFieldValueOptionActive", new TableInfo.Column("customFieldValueOptionActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValueOption.put("customFieldValueOptionMCSN", new TableInfo.Column("customFieldValueOptionMCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValueOption.put("customFieldValueOptionLCSN", new TableInfo.Column("customFieldValueOptionLCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValueOption.put("customFieldValueOptionLCB", new TableInfo.Column("customFieldValueOptionLCB", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCustomFieldValueOption.put("customFieldValueLct", new TableInfo.Column("customFieldValueLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCustomFieldValueOption = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCustomFieldValueOption = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoCustomFieldValueOption = new TableInfo("CustomFieldValueOption", _columnsCustomFieldValueOption, _foreignKeysCustomFieldValueOption, _indicesCustomFieldValueOption);
        final TableInfo _existingCustomFieldValueOption = TableInfo.read(_db, "CustomFieldValueOption");
        if (! _infoCustomFieldValueOption.equals(_existingCustomFieldValueOption)) {
          return new RoomOpenHelper.ValidationResult(false, "CustomFieldValueOption(com.ustadmobile.lib.db.entities.CustomFieldValueOption).\n"
                  + " Expected:\n" + _infoCustomFieldValueOption + "\n"
                  + " Found:\n" + _existingCustomFieldValueOption);
        }
        final HashMap<String, TableInfo.Column> _columnsPerson = new HashMap<String, TableInfo.Column>(24);
        _columnsPerson.put("personUid", new TableInfo.Column("personUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("username", new TableInfo.Column("username", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("firstNames", new TableInfo.Column("firstNames", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("lastName", new TableInfo.Column("lastName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("emailAddr", new TableInfo.Column("emailAddr", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("phoneNum", new TableInfo.Column("phoneNum", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("gender", new TableInfo.Column("gender", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("active", new TableInfo.Column("active", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("admin", new TableInfo.Column("admin", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("personNotes", new TableInfo.Column("personNotes", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("fatherName", new TableInfo.Column("fatherName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("fatherNumber", new TableInfo.Column("fatherNumber", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("motherName", new TableInfo.Column("motherName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("motherNum", new TableInfo.Column("motherNum", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("dateOfBirth", new TableInfo.Column("dateOfBirth", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("personAddress", new TableInfo.Column("personAddress", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("personOrgId", new TableInfo.Column("personOrgId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("personGroupUid", new TableInfo.Column("personGroupUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("personMasterChangeSeqNum", new TableInfo.Column("personMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("personLocalChangeSeqNum", new TableInfo.Column("personLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("personLastChangedBy", new TableInfo.Column("personLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("personLct", new TableInfo.Column("personLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("personCountry", new TableInfo.Column("personCountry", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPerson.put("personType", new TableInfo.Column("personType", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPerson = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPerson = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoPerson = new TableInfo("Person", _columnsPerson, _foreignKeysPerson, _indicesPerson);
        final TableInfo _existingPerson = TableInfo.read(_db, "Person");
        if (! _infoPerson.equals(_existingPerson)) {
          return new RoomOpenHelper.ValidationResult(false, "Person(com.ustadmobile.lib.db.entities.Person).\n"
                  + " Expected:\n" + _infoPerson + "\n"
                  + " Found:\n" + _existingPerson);
        }
        final HashMap<String, TableInfo.Column> _columnsClazz = new HashMap<String, TableInfo.Column>(24);
        _columnsClazz.put("clazzUid", new TableInfo.Column("clazzUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzName", new TableInfo.Column("clazzName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzDesc", new TableInfo.Column("clazzDesc", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("attendanceAverage", new TableInfo.Column("attendanceAverage", "REAL", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzHolidayUMCalendarUid", new TableInfo.Column("clazzHolidayUMCalendarUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzScheuleUMCalendarUid", new TableInfo.Column("clazzScheuleUMCalendarUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("isClazzActive", new TableInfo.Column("isClazzActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzLocationUid", new TableInfo.Column("clazzLocationUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzStartTime", new TableInfo.Column("clazzStartTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzEndTime", new TableInfo.Column("clazzEndTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzFeatures", new TableInfo.Column("clazzFeatures", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzSchoolUid", new TableInfo.Column("clazzSchoolUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzEnrolmentPolicy", new TableInfo.Column("clazzEnrolmentPolicy", "INTEGER", true, 0, "102", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzTerminologyUid", new TableInfo.Column("clazzTerminologyUid", "INTEGER", true, 0, "25966", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzMasterChangeSeqNum", new TableInfo.Column("clazzMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzLocalChangeSeqNum", new TableInfo.Column("clazzLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzLastChangedBy", new TableInfo.Column("clazzLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzLct", new TableInfo.Column("clazzLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzTimeZone", new TableInfo.Column("clazzTimeZone", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzStudentsPersonGroupUid", new TableInfo.Column("clazzStudentsPersonGroupUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzTeachersPersonGroupUid", new TableInfo.Column("clazzTeachersPersonGroupUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzPendingStudentsPersonGroupUid", new TableInfo.Column("clazzPendingStudentsPersonGroupUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzParentsPersonGroupUid", new TableInfo.Column("clazzParentsPersonGroupUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazz.put("clazzCode", new TableInfo.Column("clazzCode", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysClazz = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesClazz = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoClazz = new TableInfo("Clazz", _columnsClazz, _foreignKeysClazz, _indicesClazz);
        final TableInfo _existingClazz = TableInfo.read(_db, "Clazz");
        if (! _infoClazz.equals(_existingClazz)) {
          return new RoomOpenHelper.ValidationResult(false, "Clazz(com.ustadmobile.lib.db.entities.Clazz).\n"
                  + " Expected:\n" + _infoClazz + "\n"
                  + " Found:\n" + _existingClazz);
        }
        final HashMap<String, TableInfo.Column> _columnsClazzEnrolment = new HashMap<String, TableInfo.Column>(14);
        _columnsClazzEnrolment.put("clazzEnrolmentUid", new TableInfo.Column("clazzEnrolmentUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolment.put("clazzEnrolmentPersonUid", new TableInfo.Column("clazzEnrolmentPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolment.put("clazzEnrolmentClazzUid", new TableInfo.Column("clazzEnrolmentClazzUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolment.put("clazzEnrolmentDateJoined", new TableInfo.Column("clazzEnrolmentDateJoined", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolment.put("clazzEnrolmentDateLeft", new TableInfo.Column("clazzEnrolmentDateLeft", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolment.put("clazzEnrolmentRole", new TableInfo.Column("clazzEnrolmentRole", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolment.put("clazzEnrolmentAttendancePercentage", new TableInfo.Column("clazzEnrolmentAttendancePercentage", "REAL", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolment.put("clazzEnrolmentActive", new TableInfo.Column("clazzEnrolmentActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolment.put("clazzEnrolmentLeavingReasonUid", new TableInfo.Column("clazzEnrolmentLeavingReasonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolment.put("clazzEnrolmentOutcome", new TableInfo.Column("clazzEnrolmentOutcome", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolment.put("clazzEnrolmentLocalChangeSeqNum", new TableInfo.Column("clazzEnrolmentLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolment.put("clazzEnrolmentMasterChangeSeqNum", new TableInfo.Column("clazzEnrolmentMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolment.put("clazzEnrolmentLastChangedBy", new TableInfo.Column("clazzEnrolmentLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolment.put("clazzEnrolmentLct", new TableInfo.Column("clazzEnrolmentLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysClazzEnrolment = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesClazzEnrolment = new HashSet<TableInfo.Index>(5);
        _indicesClazzEnrolment.add(new TableInfo.Index("index_ClazzEnrolment_clazzEnrolmentPersonUid_clazzEnrolmentClazzUid", false, Arrays.asList("clazzEnrolmentPersonUid","clazzEnrolmentClazzUid"), Arrays.asList("ASC","ASC")));
        _indicesClazzEnrolment.add(new TableInfo.Index("index_ClazzEnrolment_clazzEnrolmentClazzUid_clazzEnrolmentPersonUid", false, Arrays.asList("clazzEnrolmentClazzUid","clazzEnrolmentPersonUid"), Arrays.asList("ASC","ASC")));
        _indicesClazzEnrolment.add(new TableInfo.Index("index_ClazzEnrolment_clazzEnrolmentClazzUid_clazzEnrolmentRole", false, Arrays.asList("clazzEnrolmentClazzUid","clazzEnrolmentRole"), Arrays.asList("ASC","ASC")));
        _indicesClazzEnrolment.add(new TableInfo.Index("index_ClazzEnrolment_clazzEnrolmentPersonUid", false, Arrays.asList("clazzEnrolmentPersonUid"), Arrays.asList("ASC")));
        _indicesClazzEnrolment.add(new TableInfo.Index("index_ClazzEnrolment_clazzEnrolmentClazzUid", false, Arrays.asList("clazzEnrolmentClazzUid"), Arrays.asList("ASC")));
        final TableInfo _infoClazzEnrolment = new TableInfo("ClazzEnrolment", _columnsClazzEnrolment, _foreignKeysClazzEnrolment, _indicesClazzEnrolment);
        final TableInfo _existingClazzEnrolment = TableInfo.read(_db, "ClazzEnrolment");
        if (! _infoClazzEnrolment.equals(_existingClazzEnrolment)) {
          return new RoomOpenHelper.ValidationResult(false, "ClazzEnrolment(com.ustadmobile.lib.db.entities.ClazzEnrolment).\n"
                  + " Expected:\n" + _infoClazzEnrolment + "\n"
                  + " Found:\n" + _existingClazzEnrolment);
        }
        final HashMap<String, TableInfo.Column> _columnsLeavingReason = new HashMap<String, TableInfo.Column>(6);
        _columnsLeavingReason.put("leavingReasonUid", new TableInfo.Column("leavingReasonUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLeavingReason.put("leavingReasonTitle", new TableInfo.Column("leavingReasonTitle", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLeavingReason.put("leavingReasonMCSN", new TableInfo.Column("leavingReasonMCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLeavingReason.put("leavingReasonCSN", new TableInfo.Column("leavingReasonCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLeavingReason.put("leavingReasonLCB", new TableInfo.Column("leavingReasonLCB", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLeavingReason.put("leavingReasonLct", new TableInfo.Column("leavingReasonLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysLeavingReason = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesLeavingReason = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoLeavingReason = new TableInfo("LeavingReason", _columnsLeavingReason, _foreignKeysLeavingReason, _indicesLeavingReason);
        final TableInfo _existingLeavingReason = TableInfo.read(_db, "LeavingReason");
        if (! _infoLeavingReason.equals(_existingLeavingReason)) {
          return new RoomOpenHelper.ValidationResult(false, "LeavingReason(com.ustadmobile.lib.db.entities.LeavingReason).\n"
                  + " Expected:\n" + _infoLeavingReason + "\n"
                  + " Found:\n" + _existingLeavingReason);
        }
        final HashMap<String, TableInfo.Column> _columnsContentEntry = new HashMap<String, TableInfo.Column>(26);
        _columnsContentEntry.put("contentEntryUid", new TableInfo.Column("contentEntryUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("title", new TableInfo.Column("title", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("description", new TableInfo.Column("description", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("entryId", new TableInfo.Column("entryId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("author", new TableInfo.Column("author", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("publisher", new TableInfo.Column("publisher", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("licenseType", new TableInfo.Column("licenseType", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("licenseName", new TableInfo.Column("licenseName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("licenseUrl", new TableInfo.Column("licenseUrl", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("sourceUrl", new TableInfo.Column("sourceUrl", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("thumbnailUrl", new TableInfo.Column("thumbnailUrl", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("lastModified", new TableInfo.Column("lastModified", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("primaryLanguageUid", new TableInfo.Column("primaryLanguageUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("languageVariantUid", new TableInfo.Column("languageVariantUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("contentFlags", new TableInfo.Column("contentFlags", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("leaf", new TableInfo.Column("leaf", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("publik", new TableInfo.Column("publik", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("ceInactive", new TableInfo.Column("ceInactive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("completionCriteria", new TableInfo.Column("completionCriteria", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("minScore", new TableInfo.Column("minScore", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("contentTypeFlag", new TableInfo.Column("contentTypeFlag", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("contentOwner", new TableInfo.Column("contentOwner", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("contentEntryLocalChangeSeqNum", new TableInfo.Column("contentEntryLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("contentEntryMasterChangeSeqNum", new TableInfo.Column("contentEntryMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("contentEntryLastChangedBy", new TableInfo.Column("contentEntryLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntry.put("contentEntryLct", new TableInfo.Column("contentEntryLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentEntry = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentEntry = new HashSet<TableInfo.Index>(1);
        _indicesContentEntry.add(new TableInfo.Index("index_ContentEntry_primaryLanguageUid", false, Arrays.asList("primaryLanguageUid"), Arrays.asList("ASC")));
        final TableInfo _infoContentEntry = new TableInfo("ContentEntry", _columnsContentEntry, _foreignKeysContentEntry, _indicesContentEntry);
        final TableInfo _existingContentEntry = TableInfo.read(_db, "ContentEntry");
        if (! _infoContentEntry.equals(_existingContentEntry)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentEntry(com.ustadmobile.lib.db.entities.ContentEntry).\n"
                  + " Expected:\n" + _infoContentEntry + "\n"
                  + " Found:\n" + _existingContentEntry);
        }
        final HashMap<String, TableInfo.Column> _columnsContentEntryContentCategoryJoin = new HashMap<String, TableInfo.Column>(7);
        _columnsContentEntryContentCategoryJoin.put("ceccjUid", new TableInfo.Column("ceccjUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryContentCategoryJoin.put("ceccjContentEntryUid", new TableInfo.Column("ceccjContentEntryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryContentCategoryJoin.put("ceccjContentCategoryUid", new TableInfo.Column("ceccjContentCategoryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryContentCategoryJoin.put("ceccjLocalChangeSeqNum", new TableInfo.Column("ceccjLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryContentCategoryJoin.put("ceccjMasterChangeSeqNum", new TableInfo.Column("ceccjMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryContentCategoryJoin.put("ceccjLastChangedBy", new TableInfo.Column("ceccjLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryContentCategoryJoin.put("ceccjLct", new TableInfo.Column("ceccjLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentEntryContentCategoryJoin = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentEntryContentCategoryJoin = new HashSet<TableInfo.Index>(1);
        _indicesContentEntryContentCategoryJoin.add(new TableInfo.Index("index_ContentEntryContentCategoryJoin_ceccjContentEntryUid", false, Arrays.asList("ceccjContentEntryUid"), Arrays.asList("ASC")));
        final TableInfo _infoContentEntryContentCategoryJoin = new TableInfo("ContentEntryContentCategoryJoin", _columnsContentEntryContentCategoryJoin, _foreignKeysContentEntryContentCategoryJoin, _indicesContentEntryContentCategoryJoin);
        final TableInfo _existingContentEntryContentCategoryJoin = TableInfo.read(_db, "ContentEntryContentCategoryJoin");
        if (! _infoContentEntryContentCategoryJoin.equals(_existingContentEntryContentCategoryJoin)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentEntryContentCategoryJoin(com.ustadmobile.lib.db.entities.ContentEntryContentCategoryJoin).\n"
                  + " Expected:\n" + _infoContentEntryContentCategoryJoin + "\n"
                  + " Found:\n" + _existingContentEntryContentCategoryJoin);
        }
        final HashMap<String, TableInfo.Column> _columnsContentEntryParentChildJoin = new HashMap<String, TableInfo.Column>(8);
        _columnsContentEntryParentChildJoin.put("cepcjParentContentEntryUid", new TableInfo.Column("cepcjParentContentEntryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryParentChildJoin.put("cepcjChildContentEntryUid", new TableInfo.Column("cepcjChildContentEntryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryParentChildJoin.put("childIndex", new TableInfo.Column("childIndex", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryParentChildJoin.put("cepcjUid", new TableInfo.Column("cepcjUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryParentChildJoin.put("cepcjLocalChangeSeqNum", new TableInfo.Column("cepcjLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryParentChildJoin.put("cepcjMasterChangeSeqNum", new TableInfo.Column("cepcjMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryParentChildJoin.put("cepcjLastChangedBy", new TableInfo.Column("cepcjLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryParentChildJoin.put("cepcjLct", new TableInfo.Column("cepcjLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentEntryParentChildJoin = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentEntryParentChildJoin = new HashSet<TableInfo.Index>(3);
        _indicesContentEntryParentChildJoin.add(new TableInfo.Index("parent_child", false, Arrays.asList("cepcjChildContentEntryUid","cepcjParentContentEntryUid"), Arrays.asList("ASC","ASC")));
        _indicesContentEntryParentChildJoin.add(new TableInfo.Index("index_ContentEntryParentChildJoin_cepcjParentContentEntryUid", false, Arrays.asList("cepcjParentContentEntryUid"), Arrays.asList("ASC")));
        _indicesContentEntryParentChildJoin.add(new TableInfo.Index("index_ContentEntryParentChildJoin_cepcjChildContentEntryUid", false, Arrays.asList("cepcjChildContentEntryUid"), Arrays.asList("ASC")));
        final TableInfo _infoContentEntryParentChildJoin = new TableInfo("ContentEntryParentChildJoin", _columnsContentEntryParentChildJoin, _foreignKeysContentEntryParentChildJoin, _indicesContentEntryParentChildJoin);
        final TableInfo _existingContentEntryParentChildJoin = TableInfo.read(_db, "ContentEntryParentChildJoin");
        if (! _infoContentEntryParentChildJoin.equals(_existingContentEntryParentChildJoin)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentEntryParentChildJoin(com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin).\n"
                  + " Expected:\n" + _infoContentEntryParentChildJoin + "\n"
                  + " Found:\n" + _existingContentEntryParentChildJoin);
        }
        final HashMap<String, TableInfo.Column> _columnsContentEntryRelatedEntryJoin = new HashMap<String, TableInfo.Column>(10);
        _columnsContentEntryRelatedEntryJoin.put("cerejUid", new TableInfo.Column("cerejUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryRelatedEntryJoin.put("cerejContentEntryUid", new TableInfo.Column("cerejContentEntryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryRelatedEntryJoin.put("cerejRelatedEntryUid", new TableInfo.Column("cerejRelatedEntryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryRelatedEntryJoin.put("cerejLastChangedBy", new TableInfo.Column("cerejLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryRelatedEntryJoin.put("relType", new TableInfo.Column("relType", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryRelatedEntryJoin.put("comment", new TableInfo.Column("comment", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryRelatedEntryJoin.put("cerejRelLanguageUid", new TableInfo.Column("cerejRelLanguageUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryRelatedEntryJoin.put("cerejLocalChangeSeqNum", new TableInfo.Column("cerejLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryRelatedEntryJoin.put("cerejMasterChangeSeqNum", new TableInfo.Column("cerejMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryRelatedEntryJoin.put("cerejLct", new TableInfo.Column("cerejLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentEntryRelatedEntryJoin = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentEntryRelatedEntryJoin = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoContentEntryRelatedEntryJoin = new TableInfo("ContentEntryRelatedEntryJoin", _columnsContentEntryRelatedEntryJoin, _foreignKeysContentEntryRelatedEntryJoin, _indicesContentEntryRelatedEntryJoin);
        final TableInfo _existingContentEntryRelatedEntryJoin = TableInfo.read(_db, "ContentEntryRelatedEntryJoin");
        if (! _infoContentEntryRelatedEntryJoin.equals(_existingContentEntryRelatedEntryJoin)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentEntryRelatedEntryJoin(com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin).\n"
                  + " Expected:\n" + _infoContentEntryRelatedEntryJoin + "\n"
                  + " Found:\n" + _existingContentEntryRelatedEntryJoin);
        }
        final HashMap<String, TableInfo.Column> _columnsContentCategorySchema = new HashMap<String, TableInfo.Column>(7);
        _columnsContentCategorySchema.put("contentCategorySchemaUid", new TableInfo.Column("contentCategorySchemaUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategorySchema.put("schemaName", new TableInfo.Column("schemaName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategorySchema.put("schemaUrl", new TableInfo.Column("schemaUrl", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategorySchema.put("contentCategorySchemaLocalChangeSeqNum", new TableInfo.Column("contentCategorySchemaLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategorySchema.put("contentCategorySchemaMasterChangeSeqNum", new TableInfo.Column("contentCategorySchemaMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategorySchema.put("contentCategorySchemaLastChangedBy", new TableInfo.Column("contentCategorySchemaLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategorySchema.put("contentCategorySchemaLct", new TableInfo.Column("contentCategorySchemaLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentCategorySchema = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentCategorySchema = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoContentCategorySchema = new TableInfo("ContentCategorySchema", _columnsContentCategorySchema, _foreignKeysContentCategorySchema, _indicesContentCategorySchema);
        final TableInfo _existingContentCategorySchema = TableInfo.read(_db, "ContentCategorySchema");
        if (! _infoContentCategorySchema.equals(_existingContentCategorySchema)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentCategorySchema(com.ustadmobile.lib.db.entities.ContentCategorySchema).\n"
                  + " Expected:\n" + _infoContentCategorySchema + "\n"
                  + " Found:\n" + _existingContentCategorySchema);
        }
        final HashMap<String, TableInfo.Column> _columnsContentCategory = new HashMap<String, TableInfo.Column>(7);
        _columnsContentCategory.put("contentCategoryUid", new TableInfo.Column("contentCategoryUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategory.put("ctnCatContentCategorySchemaUid", new TableInfo.Column("ctnCatContentCategorySchemaUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategory.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategory.put("contentCategoryLocalChangeSeqNum", new TableInfo.Column("contentCategoryLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategory.put("contentCategoryMasterChangeSeqNum", new TableInfo.Column("contentCategoryMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategory.put("contentCategoryLastChangedBy", new TableInfo.Column("contentCategoryLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategory.put("contentCategoryLct", new TableInfo.Column("contentCategoryLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentCategory = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentCategory = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoContentCategory = new TableInfo("ContentCategory", _columnsContentCategory, _foreignKeysContentCategory, _indicesContentCategory);
        final TableInfo _existingContentCategory = TableInfo.read(_db, "ContentCategory");
        if (! _infoContentCategory.equals(_existingContentCategory)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentCategory(com.ustadmobile.lib.db.entities.ContentCategory).\n"
                  + " Expected:\n" + _infoContentCategory + "\n"
                  + " Found:\n" + _existingContentCategory);
        }
        final HashMap<String, TableInfo.Column> _columnsLanguage = new HashMap<String, TableInfo.Column>(11);
        _columnsLanguage.put("langUid", new TableInfo.Column("langUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguage.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguage.put("iso_639_1_standard", new TableInfo.Column("iso_639_1_standard", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguage.put("iso_639_2_standard", new TableInfo.Column("iso_639_2_standard", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguage.put("iso_639_3_standard", new TableInfo.Column("iso_639_3_standard", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguage.put("Language_Type", new TableInfo.Column("Language_Type", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguage.put("languageActive", new TableInfo.Column("languageActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguage.put("langLocalChangeSeqNum", new TableInfo.Column("langLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguage.put("langMasterChangeSeqNum", new TableInfo.Column("langMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguage.put("langLastChangedBy", new TableInfo.Column("langLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguage.put("langLct", new TableInfo.Column("langLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysLanguage = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesLanguage = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoLanguage = new TableInfo("Language", _columnsLanguage, _foreignKeysLanguage, _indicesLanguage);
        final TableInfo _existingLanguage = TableInfo.read(_db, "Language");
        if (! _infoLanguage.equals(_existingLanguage)) {
          return new RoomOpenHelper.ValidationResult(false, "Language(com.ustadmobile.lib.db.entities.Language).\n"
                  + " Expected:\n" + _infoLanguage + "\n"
                  + " Found:\n" + _existingLanguage);
        }
        final HashMap<String, TableInfo.Column> _columnsLanguageVariant = new HashMap<String, TableInfo.Column>(8);
        _columnsLanguageVariant.put("langVariantUid", new TableInfo.Column("langVariantUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguageVariant.put("langUid", new TableInfo.Column("langUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguageVariant.put("countryCode", new TableInfo.Column("countryCode", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguageVariant.put("name", new TableInfo.Column("name", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguageVariant.put("langVariantLocalChangeSeqNum", new TableInfo.Column("langVariantLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguageVariant.put("langVariantMasterChangeSeqNum", new TableInfo.Column("langVariantMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguageVariant.put("langVariantLastChangedBy", new TableInfo.Column("langVariantLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguageVariant.put("langVariantLct", new TableInfo.Column("langVariantLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysLanguageVariant = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesLanguageVariant = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoLanguageVariant = new TableInfo("LanguageVariant", _columnsLanguageVariant, _foreignKeysLanguageVariant, _indicesLanguageVariant);
        final TableInfo _existingLanguageVariant = TableInfo.read(_db, "LanguageVariant");
        if (! _infoLanguageVariant.equals(_existingLanguageVariant)) {
          return new RoomOpenHelper.ValidationResult(false, "LanguageVariant(com.ustadmobile.lib.db.entities.LanguageVariant).\n"
                  + " Expected:\n" + _infoLanguageVariant + "\n"
                  + " Found:\n" + _existingLanguageVariant);
        }
        final HashMap<String, TableInfo.Column> _columnsAccessToken = new HashMap<String, TableInfo.Column>(3);
        _columnsAccessToken.put("token", new TableInfo.Column("token", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAccessToken.put("accessTokenPersonUid", new TableInfo.Column("accessTokenPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAccessToken.put("expires", new TableInfo.Column("expires", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAccessToken = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesAccessToken = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoAccessToken = new TableInfo("AccessToken", _columnsAccessToken, _foreignKeysAccessToken, _indicesAccessToken);
        final TableInfo _existingAccessToken = TableInfo.read(_db, "AccessToken");
        if (! _infoAccessToken.equals(_existingAccessToken)) {
          return new RoomOpenHelper.ValidationResult(false, "AccessToken(com.ustadmobile.lib.db.entities.AccessToken).\n"
                  + " Expected:\n" + _infoAccessToken + "\n"
                  + " Found:\n" + _existingAccessToken);
        }
        final HashMap<String, TableInfo.Column> _columnsPersonAuth = new HashMap<String, TableInfo.Column>(3);
        _columnsPersonAuth.put("personAuthUid", new TableInfo.Column("personAuthUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonAuth.put("passwordHash", new TableInfo.Column("passwordHash", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonAuth.put("personAuthStatus", new TableInfo.Column("personAuthStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPersonAuth = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPersonAuth = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoPersonAuth = new TableInfo("PersonAuth", _columnsPersonAuth, _foreignKeysPersonAuth, _indicesPersonAuth);
        final TableInfo _existingPersonAuth = TableInfo.read(_db, "PersonAuth");
        if (! _infoPersonAuth.equals(_existingPersonAuth)) {
          return new RoomOpenHelper.ValidationResult(false, "PersonAuth(com.ustadmobile.lib.db.entities.PersonAuth).\n"
                  + " Expected:\n" + _infoPersonAuth + "\n"
                  + " Found:\n" + _existingPersonAuth);
        }
        final HashMap<String, TableInfo.Column> _columnsRole = new HashMap<String, TableInfo.Column>(8);
        _columnsRole.put("roleUid", new TableInfo.Column("roleUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRole.put("roleName", new TableInfo.Column("roleName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRole.put("roleActive", new TableInfo.Column("roleActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRole.put("roleMasterCsn", new TableInfo.Column("roleMasterCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRole.put("roleLocalCsn", new TableInfo.Column("roleLocalCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRole.put("roleLastChangedBy", new TableInfo.Column("roleLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRole.put("roleLct", new TableInfo.Column("roleLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsRole.put("rolePermissions", new TableInfo.Column("rolePermissions", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysRole = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesRole = new HashSet<TableInfo.Index>(1);
        _indicesRole.add(new TableInfo.Index("index_Role_rolePermissions", false, Arrays.asList("rolePermissions"), Arrays.asList("ASC")));
        final TableInfo _infoRole = new TableInfo("Role", _columnsRole, _foreignKeysRole, _indicesRole);
        final TableInfo _existingRole = TableInfo.read(_db, "Role");
        if (! _infoRole.equals(_existingRole)) {
          return new RoomOpenHelper.ValidationResult(false, "Role(com.ustadmobile.lib.db.entities.Role).\n"
                  + " Expected:\n" + _infoRole + "\n"
                  + " Found:\n" + _existingRole);
        }
        final HashMap<String, TableInfo.Column> _columnsEntityRole = new HashMap<String, TableInfo.Column>(10);
        _columnsEntityRole.put("erUid", new TableInfo.Column("erUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEntityRole.put("erMasterCsn", new TableInfo.Column("erMasterCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEntityRole.put("erLocalCsn", new TableInfo.Column("erLocalCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEntityRole.put("erLastChangedBy", new TableInfo.Column("erLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEntityRole.put("erLct", new TableInfo.Column("erLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEntityRole.put("erTableId", new TableInfo.Column("erTableId", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEntityRole.put("erEntityUid", new TableInfo.Column("erEntityUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEntityRole.put("erGroupUid", new TableInfo.Column("erGroupUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEntityRole.put("erRoleUid", new TableInfo.Column("erRoleUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsEntityRole.put("erActive", new TableInfo.Column("erActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysEntityRole = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesEntityRole = new HashSet<TableInfo.Index>(5);
        _indicesEntityRole.add(new TableInfo.Index("index_EntityRole_erGroupUid_erRoleUid_erTableId", false, Arrays.asList("erGroupUid","erRoleUid","erTableId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesEntityRole.add(new TableInfo.Index("index_EntityRole_erTableId", false, Arrays.asList("erTableId"), Arrays.asList("ASC")));
        _indicesEntityRole.add(new TableInfo.Index("index_EntityRole_erEntityUid", false, Arrays.asList("erEntityUid"), Arrays.asList("ASC")));
        _indicesEntityRole.add(new TableInfo.Index("index_EntityRole_erGroupUid", false, Arrays.asList("erGroupUid"), Arrays.asList("ASC")));
        _indicesEntityRole.add(new TableInfo.Index("index_EntityRole_erRoleUid", false, Arrays.asList("erRoleUid"), Arrays.asList("ASC")));
        final TableInfo _infoEntityRole = new TableInfo("EntityRole", _columnsEntityRole, _foreignKeysEntityRole, _indicesEntityRole);
        final TableInfo _existingEntityRole = TableInfo.read(_db, "EntityRole");
        if (! _infoEntityRole.equals(_existingEntityRole)) {
          return new RoomOpenHelper.ValidationResult(false, "EntityRole(com.ustadmobile.lib.db.entities.EntityRole).\n"
                  + " Expected:\n" + _infoEntityRole + "\n"
                  + " Found:\n" + _existingEntityRole);
        }
        final HashMap<String, TableInfo.Column> _columnsPersonGroup = new HashMap<String, TableInfo.Column>(8);
        _columnsPersonGroup.put("groupUid", new TableInfo.Column("groupUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroup.put("groupMasterCsn", new TableInfo.Column("groupMasterCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroup.put("groupLocalCsn", new TableInfo.Column("groupLocalCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroup.put("groupLastChangedBy", new TableInfo.Column("groupLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroup.put("groupLct", new TableInfo.Column("groupLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroup.put("groupName", new TableInfo.Column("groupName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroup.put("groupActive", new TableInfo.Column("groupActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroup.put("personGroupFlag", new TableInfo.Column("personGroupFlag", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPersonGroup = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPersonGroup = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoPersonGroup = new TableInfo("PersonGroup", _columnsPersonGroup, _foreignKeysPersonGroup, _indicesPersonGroup);
        final TableInfo _existingPersonGroup = TableInfo.read(_db, "PersonGroup");
        if (! _infoPersonGroup.equals(_existingPersonGroup)) {
          return new RoomOpenHelper.ValidationResult(false, "PersonGroup(com.ustadmobile.lib.db.entities.PersonGroup).\n"
                  + " Expected:\n" + _infoPersonGroup + "\n"
                  + " Found:\n" + _existingPersonGroup);
        }
        final HashMap<String, TableInfo.Column> _columnsPersonGroupMember = new HashMap<String, TableInfo.Column>(8);
        _columnsPersonGroupMember.put("groupMemberUid", new TableInfo.Column("groupMemberUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroupMember.put("groupMemberActive", new TableInfo.Column("groupMemberActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroupMember.put("groupMemberPersonUid", new TableInfo.Column("groupMemberPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroupMember.put("groupMemberGroupUid", new TableInfo.Column("groupMemberGroupUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroupMember.put("groupMemberMasterCsn", new TableInfo.Column("groupMemberMasterCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroupMember.put("groupMemberLocalCsn", new TableInfo.Column("groupMemberLocalCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroupMember.put("groupMemberLastChangedBy", new TableInfo.Column("groupMemberLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroupMember.put("groupMemberLct", new TableInfo.Column("groupMemberLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPersonGroupMember = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPersonGroupMember = new HashSet<TableInfo.Index>(2);
        _indicesPersonGroupMember.add(new TableInfo.Index("index_PersonGroupMember_groupMemberPersonUid", false, Arrays.asList("groupMemberPersonUid"), Arrays.asList("ASC")));
        _indicesPersonGroupMember.add(new TableInfo.Index("index_PersonGroupMember_groupMemberGroupUid", false, Arrays.asList("groupMemberGroupUid"), Arrays.asList("ASC")));
        final TableInfo _infoPersonGroupMember = new TableInfo("PersonGroupMember", _columnsPersonGroupMember, _foreignKeysPersonGroupMember, _indicesPersonGroupMember);
        final TableInfo _existingPersonGroupMember = TableInfo.read(_db, "PersonGroupMember");
        if (! _infoPersonGroupMember.equals(_existingPersonGroupMember)) {
          return new RoomOpenHelper.ValidationResult(false, "PersonGroupMember(com.ustadmobile.lib.db.entities.PersonGroupMember).\n"
                  + " Expected:\n" + _infoPersonGroupMember + "\n"
                  + " Found:\n" + _existingPersonGroupMember);
        }
        final HashMap<String, TableInfo.Column> _columnsPersonPicture = new HashMap<String, TableInfo.Column>(12);
        _columnsPersonPicture.put("personPictureUid", new TableInfo.Column("personPictureUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonPicture.put("personPicturePersonUid", new TableInfo.Column("personPicturePersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonPicture.put("personPictureMasterCsn", new TableInfo.Column("personPictureMasterCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonPicture.put("personPictureLocalCsn", new TableInfo.Column("personPictureLocalCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonPicture.put("personPictureLastChangedBy", new TableInfo.Column("personPictureLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonPicture.put("personPictureLct", new TableInfo.Column("personPictureLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonPicture.put("personPictureUri", new TableInfo.Column("personPictureUri", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonPicture.put("personPictureMd5", new TableInfo.Column("personPictureMd5", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonPicture.put("fileSize", new TableInfo.Column("fileSize", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonPicture.put("picTimestamp", new TableInfo.Column("picTimestamp", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonPicture.put("mimeType", new TableInfo.Column("mimeType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonPicture.put("personPictureActive", new TableInfo.Column("personPictureActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPersonPicture = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPersonPicture = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoPersonPicture = new TableInfo("PersonPicture", _columnsPersonPicture, _foreignKeysPersonPicture, _indicesPersonPicture);
        final TableInfo _existingPersonPicture = TableInfo.read(_db, "PersonPicture");
        if (! _infoPersonPicture.equals(_existingPersonPicture)) {
          return new RoomOpenHelper.ValidationResult(false, "PersonPicture(com.ustadmobile.lib.db.entities.PersonPicture).\n"
                  + " Expected:\n" + _infoPersonPicture + "\n"
                  + " Found:\n" + _existingPersonPicture);
        }
        final HashMap<String, TableInfo.Column> _columnsScrapeQueueItem = new HashMap<String, TableInfo.Column>(15);
        _columnsScrapeQueueItem.put("sqiUid", new TableInfo.Column("sqiUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeQueueItem.put("sqiContentEntryParentUid", new TableInfo.Column("sqiContentEntryParentUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeQueueItem.put("sqiContentEntryUid", new TableInfo.Column("sqiContentEntryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeQueueItem.put("destDir", new TableInfo.Column("destDir", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeQueueItem.put("scrapeUrl", new TableInfo.Column("scrapeUrl", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeQueueItem.put("status", new TableInfo.Column("status", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeQueueItem.put("runId", new TableInfo.Column("runId", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeQueueItem.put("itemType", new TableInfo.Column("itemType", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeQueueItem.put("errorCode", new TableInfo.Column("errorCode", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeQueueItem.put("contentType", new TableInfo.Column("contentType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeQueueItem.put("timeAdded", new TableInfo.Column("timeAdded", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeQueueItem.put("timeStarted", new TableInfo.Column("timeStarted", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeQueueItem.put("timeFinished", new TableInfo.Column("timeFinished", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeQueueItem.put("priority", new TableInfo.Column("priority", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeQueueItem.put("overrideEntry", new TableInfo.Column("overrideEntry", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysScrapeQueueItem = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesScrapeQueueItem = new HashSet<TableInfo.Index>(1);
        _indicesScrapeQueueItem.add(new TableInfo.Index("index_ScrapeQueueItem_status_itemType", false, Arrays.asList("status","itemType"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoScrapeQueueItem = new TableInfo("ScrapeQueueItem", _columnsScrapeQueueItem, _foreignKeysScrapeQueueItem, _indicesScrapeQueueItem);
        final TableInfo _existingScrapeQueueItem = TableInfo.read(_db, "ScrapeQueueItem");
        if (! _infoScrapeQueueItem.equals(_existingScrapeQueueItem)) {
          return new RoomOpenHelper.ValidationResult(false, "ScrapeQueueItem(com.ustadmobile.lib.db.entities.ScrapeQueueItem).\n"
                  + " Expected:\n" + _infoScrapeQueueItem + "\n"
                  + " Found:\n" + _existingScrapeQueueItem);
        }
        final HashMap<String, TableInfo.Column> _columnsScrapeRun = new HashMap<String, TableInfo.Column>(4);
        _columnsScrapeRun.put("scrapeRunUid", new TableInfo.Column("scrapeRunUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeRun.put("scrapeType", new TableInfo.Column("scrapeType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeRun.put("scrapeRunStatus", new TableInfo.Column("scrapeRunStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScrapeRun.put("conversionParams", new TableInfo.Column("conversionParams", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysScrapeRun = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesScrapeRun = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoScrapeRun = new TableInfo("ScrapeRun", _columnsScrapeRun, _foreignKeysScrapeRun, _indicesScrapeRun);
        final TableInfo _existingScrapeRun = TableInfo.read(_db, "ScrapeRun");
        if (! _infoScrapeRun.equals(_existingScrapeRun)) {
          return new RoomOpenHelper.ValidationResult(false, "ScrapeRun(com.ustadmobile.lib.db.entities.ScrapeRun).\n"
                  + " Expected:\n" + _infoScrapeRun + "\n"
                  + " Found:\n" + _existingScrapeRun);
        }
        final HashMap<String, TableInfo.Column> _columnsConnectivityStatus = new HashMap<String, TableInfo.Column>(4);
        _columnsConnectivityStatus.put("csUid", new TableInfo.Column("csUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsConnectivityStatus.put("connectivityState", new TableInfo.Column("connectivityState", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsConnectivityStatus.put("wifiSsid", new TableInfo.Column("wifiSsid", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsConnectivityStatus.put("connectedOrConnecting", new TableInfo.Column("connectedOrConnecting", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysConnectivityStatus = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesConnectivityStatus = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoConnectivityStatus = new TableInfo("ConnectivityStatus", _columnsConnectivityStatus, _foreignKeysConnectivityStatus, _indicesConnectivityStatus);
        final TableInfo _existingConnectivityStatus = TableInfo.read(_db, "ConnectivityStatus");
        if (! _infoConnectivityStatus.equals(_existingConnectivityStatus)) {
          return new RoomOpenHelper.ValidationResult(false, "ConnectivityStatus(com.ustadmobile.lib.db.entities.ConnectivityStatus).\n"
                  + " Expected:\n" + _infoConnectivityStatus + "\n"
                  + " Found:\n" + _existingConnectivityStatus);
        }
        final HashMap<String, TableInfo.Column> _columnsContainer = new HashMap<String, TableInfo.Column>(12);
        _columnsContainer.put("containerUid", new TableInfo.Column("containerUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainer.put("cntLocalCsn", new TableInfo.Column("cntLocalCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainer.put("cntMasterCsn", new TableInfo.Column("cntMasterCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainer.put("cntLastModBy", new TableInfo.Column("cntLastModBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainer.put("cntLct", new TableInfo.Column("cntLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainer.put("fileSize", new TableInfo.Column("fileSize", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainer.put("containerContentEntryUid", new TableInfo.Column("containerContentEntryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainer.put("cntLastModified", new TableInfo.Column("cntLastModified", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainer.put("mimeType", new TableInfo.Column("mimeType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainer.put("remarks", new TableInfo.Column("remarks", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainer.put("mobileOptimized", new TableInfo.Column("mobileOptimized", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainer.put("cntNumEntries", new TableInfo.Column("cntNumEntries", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContainer = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContainer = new HashSet<TableInfo.Index>(2);
        _indicesContainer.add(new TableInfo.Index("cnt_uid_to_most_recent", false, Arrays.asList("containerContentEntryUid","cntLastModified"), Arrays.asList("ASC","ASC")));
        _indicesContainer.add(new TableInfo.Index("index_Container_cntLastModified", false, Arrays.asList("cntLastModified"), Arrays.asList("ASC")));
        final TableInfo _infoContainer = new TableInfo("Container", _columnsContainer, _foreignKeysContainer, _indicesContainer);
        final TableInfo _existingContainer = TableInfo.read(_db, "Container");
        if (! _infoContainer.equals(_existingContainer)) {
          return new RoomOpenHelper.ValidationResult(false, "Container(com.ustadmobile.lib.db.entities.Container).\n"
                  + " Expected:\n" + _infoContainer + "\n"
                  + " Found:\n" + _existingContainer);
        }
        final HashMap<String, TableInfo.Column> _columnsContainerEntry = new HashMap<String, TableInfo.Column>(4);
        _columnsContainerEntry.put("ceUid", new TableInfo.Column("ceUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerEntry.put("ceContainerUid", new TableInfo.Column("ceContainerUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerEntry.put("cePath", new TableInfo.Column("cePath", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerEntry.put("ceCefUid", new TableInfo.Column("ceCefUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContainerEntry = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContainerEntry = new HashSet<TableInfo.Index>(1);
        _indicesContainerEntry.add(new TableInfo.Index("index_ContainerEntry_ceContainerUid", false, Arrays.asList("ceContainerUid"), Arrays.asList("ASC")));
        final TableInfo _infoContainerEntry = new TableInfo("ContainerEntry", _columnsContainerEntry, _foreignKeysContainerEntry, _indicesContainerEntry);
        final TableInfo _existingContainerEntry = TableInfo.read(_db, "ContainerEntry");
        if (! _infoContainerEntry.equals(_existingContainerEntry)) {
          return new RoomOpenHelper.ValidationResult(false, "ContainerEntry(com.ustadmobile.lib.db.entities.ContainerEntry).\n"
                  + " Expected:\n" + _infoContainerEntry + "\n"
                  + " Found:\n" + _existingContainerEntry);
        }
        final HashMap<String, TableInfo.Column> _columnsContainerEntryFile = new HashMap<String, TableInfo.Column>(7);
        _columnsContainerEntryFile.put("cefUid", new TableInfo.Column("cefUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerEntryFile.put("cefMd5", new TableInfo.Column("cefMd5", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerEntryFile.put("cefPath", new TableInfo.Column("cefPath", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerEntryFile.put("ceTotalSize", new TableInfo.Column("ceTotalSize", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerEntryFile.put("ceCompressedSize", new TableInfo.Column("ceCompressedSize", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerEntryFile.put("compression", new TableInfo.Column("compression", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerEntryFile.put("lastModified", new TableInfo.Column("lastModified", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContainerEntryFile = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContainerEntryFile = new HashSet<TableInfo.Index>(1);
        _indicesContainerEntryFile.add(new TableInfo.Index("index_ContainerEntryFile_cefMd5", false, Arrays.asList("cefMd5"), Arrays.asList("ASC")));
        final TableInfo _infoContainerEntryFile = new TableInfo("ContainerEntryFile", _columnsContainerEntryFile, _foreignKeysContainerEntryFile, _indicesContainerEntryFile);
        final TableInfo _existingContainerEntryFile = TableInfo.read(_db, "ContainerEntryFile");
        if (! _infoContainerEntryFile.equals(_existingContainerEntryFile)) {
          return new RoomOpenHelper.ValidationResult(false, "ContainerEntryFile(com.ustadmobile.lib.db.entities.ContainerEntryFile).\n"
                  + " Expected:\n" + _infoContainerEntryFile + "\n"
                  + " Found:\n" + _existingContainerEntryFile);
        }
        final HashMap<String, TableInfo.Column> _columnsVerbEntity = new HashMap<String, TableInfo.Column>(7);
        _columnsVerbEntity.put("verbUid", new TableInfo.Column("verbUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsVerbEntity.put("urlId", new TableInfo.Column("urlId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsVerbEntity.put("verbInActive", new TableInfo.Column("verbInActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsVerbEntity.put("verbMasterChangeSeqNum", new TableInfo.Column("verbMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsVerbEntity.put("verbLocalChangeSeqNum", new TableInfo.Column("verbLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsVerbEntity.put("verbLastChangedBy", new TableInfo.Column("verbLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsVerbEntity.put("verbLct", new TableInfo.Column("verbLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysVerbEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesVerbEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoVerbEntity = new TableInfo("VerbEntity", _columnsVerbEntity, _foreignKeysVerbEntity, _indicesVerbEntity);
        final TableInfo _existingVerbEntity = TableInfo.read(_db, "VerbEntity");
        if (! _infoVerbEntity.equals(_existingVerbEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "VerbEntity(com.ustadmobile.lib.db.entities.VerbEntity).\n"
                  + " Expected:\n" + _infoVerbEntity + "\n"
                  + " Found:\n" + _existingVerbEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsXObjectEntity = new HashMap<String, TableInfo.Column>(12);
        _columnsXObjectEntity.put("xObjectUid", new TableInfo.Column("xObjectUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXObjectEntity.put("objectType", new TableInfo.Column("objectType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXObjectEntity.put("objectId", new TableInfo.Column("objectId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXObjectEntity.put("definitionType", new TableInfo.Column("definitionType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXObjectEntity.put("interactionType", new TableInfo.Column("interactionType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXObjectEntity.put("correctResponsePattern", new TableInfo.Column("correctResponsePattern", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXObjectEntity.put("objectContentEntryUid", new TableInfo.Column("objectContentEntryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXObjectEntity.put("objectStatementRefUid", new TableInfo.Column("objectStatementRefUid", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsXObjectEntity.put("xObjectMasterChangeSeqNum", new TableInfo.Column("xObjectMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXObjectEntity.put("xObjectocalChangeSeqNum", new TableInfo.Column("xObjectocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXObjectEntity.put("xObjectLastChangedBy", new TableInfo.Column("xObjectLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXObjectEntity.put("xObjectLct", new TableInfo.Column("xObjectLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysXObjectEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesXObjectEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoXObjectEntity = new TableInfo("XObjectEntity", _columnsXObjectEntity, _foreignKeysXObjectEntity, _indicesXObjectEntity);
        final TableInfo _existingXObjectEntity = TableInfo.read(_db, "XObjectEntity");
        if (! _infoXObjectEntity.equals(_existingXObjectEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "XObjectEntity(com.ustadmobile.lib.db.entities.XObjectEntity).\n"
                  + " Expected:\n" + _infoXObjectEntity + "\n"
                  + " Found:\n" + _existingXObjectEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsStatementEntity = new HashMap<String, TableInfo.Column>(35);
        _columnsStatementEntity.put("statementUid", new TableInfo.Column("statementUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("statementId", new TableInfo.Column("statementId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("statementPersonUid", new TableInfo.Column("statementPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("statementVerbUid", new TableInfo.Column("statementVerbUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("xObjectUid", new TableInfo.Column("xObjectUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("subStatementActorUid", new TableInfo.Column("subStatementActorUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("substatementVerbUid", new TableInfo.Column("substatementVerbUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("subStatementObjectUid", new TableInfo.Column("subStatementObjectUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("agentUid", new TableInfo.Column("agentUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("instructorUid", new TableInfo.Column("instructorUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("authorityUid", new TableInfo.Column("authorityUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("teamUid", new TableInfo.Column("teamUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("resultCompletion", new TableInfo.Column("resultCompletion", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("resultSuccess", new TableInfo.Column("resultSuccess", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("resultScoreScaled", new TableInfo.Column("resultScoreScaled", "REAL", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("resultScoreRaw", new TableInfo.Column("resultScoreRaw", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("resultScoreMin", new TableInfo.Column("resultScoreMin", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("resultScoreMax", new TableInfo.Column("resultScoreMax", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("resultDuration", new TableInfo.Column("resultDuration", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("resultResponse", new TableInfo.Column("resultResponse", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("stored", new TableInfo.Column("stored", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("contextRegistration", new TableInfo.Column("contextRegistration", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("contextPlatform", new TableInfo.Column("contextPlatform", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("contextStatementId", new TableInfo.Column("contextStatementId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("fullStatement", new TableInfo.Column("fullStatement", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("statementMasterChangeSeqNum", new TableInfo.Column("statementMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("statementLocalChangeSeqNum", new TableInfo.Column("statementLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("statementLastChangedBy", new TableInfo.Column("statementLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("statementLct", new TableInfo.Column("statementLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("extensionProgress", new TableInfo.Column("extensionProgress", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("contentEntryRoot", new TableInfo.Column("contentEntryRoot", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("statementContentEntryUid", new TableInfo.Column("statementContentEntryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("statementLearnerGroupUid", new TableInfo.Column("statementLearnerGroupUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntity.put("statementClazzUid", new TableInfo.Column("statementClazzUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysStatementEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesStatementEntity = new HashSet<TableInfo.Index>(2);
        _indicesStatementEntity.add(new TableInfo.Index("index_StatementEntity_statementContentEntryUid_statementPersonUid_contentEntryRoot_timestamp_statementLocalChangeSeqNum", false, Arrays.asList("statementContentEntryUid","statementPersonUid","contentEntryRoot","timestamp","statementLocalChangeSeqNum"), Arrays.asList("ASC","ASC","ASC","ASC","ASC")));
        _indicesStatementEntity.add(new TableInfo.Index("index_StatementEntity_statementPersonUid", false, Arrays.asList("statementPersonUid"), Arrays.asList("ASC")));
        final TableInfo _infoStatementEntity = new TableInfo("StatementEntity", _columnsStatementEntity, _foreignKeysStatementEntity, _indicesStatementEntity);
        final TableInfo _existingStatementEntity = TableInfo.read(_db, "StatementEntity");
        if (! _infoStatementEntity.equals(_existingStatementEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "StatementEntity(com.ustadmobile.lib.db.entities.StatementEntity).\n"
                  + " Expected:\n" + _infoStatementEntity + "\n"
                  + " Found:\n" + _existingStatementEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsContextXObjectStatementJoin = new HashMap<String, TableInfo.Column>(8);
        _columnsContextXObjectStatementJoin.put("contextXObjectStatementJoinUid", new TableInfo.Column("contextXObjectStatementJoinUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContextXObjectStatementJoin.put("contextActivityFlag", new TableInfo.Column("contextActivityFlag", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContextXObjectStatementJoin.put("contextStatementUid", new TableInfo.Column("contextStatementUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContextXObjectStatementJoin.put("contextXObjectUid", new TableInfo.Column("contextXObjectUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContextXObjectStatementJoin.put("verbMasterChangeSeqNum", new TableInfo.Column("verbMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContextXObjectStatementJoin.put("verbLocalChangeSeqNum", new TableInfo.Column("verbLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContextXObjectStatementJoin.put("verbLastChangedBy", new TableInfo.Column("verbLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContextXObjectStatementJoin.put("contextXObjectLct", new TableInfo.Column("contextXObjectLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContextXObjectStatementJoin = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContextXObjectStatementJoin = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoContextXObjectStatementJoin = new TableInfo("ContextXObjectStatementJoin", _columnsContextXObjectStatementJoin, _foreignKeysContextXObjectStatementJoin, _indicesContextXObjectStatementJoin);
        final TableInfo _existingContextXObjectStatementJoin = TableInfo.read(_db, "ContextXObjectStatementJoin");
        if (! _infoContextXObjectStatementJoin.equals(_existingContextXObjectStatementJoin)) {
          return new RoomOpenHelper.ValidationResult(false, "ContextXObjectStatementJoin(com.ustadmobile.lib.db.entities.ContextXObjectStatementJoin).\n"
                  + " Expected:\n" + _infoContextXObjectStatementJoin + "\n"
                  + " Found:\n" + _existingContextXObjectStatementJoin);
        }
        final HashMap<String, TableInfo.Column> _columnsAgentEntity = new HashMap<String, TableInfo.Column>(11);
        _columnsAgentEntity.put("agentUid", new TableInfo.Column("agentUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAgentEntity.put("agentMbox", new TableInfo.Column("agentMbox", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAgentEntity.put("agentMbox_sha1sum", new TableInfo.Column("agentMbox_sha1sum", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAgentEntity.put("agentOpenid", new TableInfo.Column("agentOpenid", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAgentEntity.put("agentAccountName", new TableInfo.Column("agentAccountName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAgentEntity.put("agentHomePage", new TableInfo.Column("agentHomePage", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAgentEntity.put("agentPersonUid", new TableInfo.Column("agentPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAgentEntity.put("statementMasterChangeSeqNum", new TableInfo.Column("statementMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAgentEntity.put("statementLocalChangeSeqNum", new TableInfo.Column("statementLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAgentEntity.put("statementLastChangedBy", new TableInfo.Column("statementLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAgentEntity.put("agentLct", new TableInfo.Column("agentLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAgentEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesAgentEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoAgentEntity = new TableInfo("AgentEntity", _columnsAgentEntity, _foreignKeysAgentEntity, _indicesAgentEntity);
        final TableInfo _existingAgentEntity = TableInfo.read(_db, "AgentEntity");
        if (! _infoAgentEntity.equals(_existingAgentEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "AgentEntity(com.ustadmobile.lib.db.entities.AgentEntity).\n"
                  + " Expected:\n" + _infoAgentEntity + "\n"
                  + " Found:\n" + _existingAgentEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsStateEntity = new HashMap<String, TableInfo.Column>(11);
        _columnsStateEntity.put("stateUid", new TableInfo.Column("stateUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateEntity.put("stateId", new TableInfo.Column("stateId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateEntity.put("agentUid", new TableInfo.Column("agentUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateEntity.put("activityId", new TableInfo.Column("activityId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateEntity.put("registration", new TableInfo.Column("registration", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateEntity.put("isIsactive", new TableInfo.Column("isIsactive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateEntity.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateEntity.put("stateMasterChangeSeqNum", new TableInfo.Column("stateMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateEntity.put("stateLocalChangeSeqNum", new TableInfo.Column("stateLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateEntity.put("stateLastChangedBy", new TableInfo.Column("stateLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateEntity.put("stateLct", new TableInfo.Column("stateLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysStateEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesStateEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoStateEntity = new TableInfo("StateEntity", _columnsStateEntity, _foreignKeysStateEntity, _indicesStateEntity);
        final TableInfo _existingStateEntity = TableInfo.read(_db, "StateEntity");
        if (! _infoStateEntity.equals(_existingStateEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "StateEntity(com.ustadmobile.lib.db.entities.StateEntity).\n"
                  + " Expected:\n" + _infoStateEntity + "\n"
                  + " Found:\n" + _existingStateEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsStateContentEntity = new HashMap<String, TableInfo.Column>(9);
        _columnsStateContentEntity.put("stateContentUid", new TableInfo.Column("stateContentUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateContentEntity.put("stateContentStateUid", new TableInfo.Column("stateContentStateUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateContentEntity.put("stateContentKey", new TableInfo.Column("stateContentKey", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateContentEntity.put("stateContentValue", new TableInfo.Column("stateContentValue", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateContentEntity.put("isIsactive", new TableInfo.Column("isIsactive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateContentEntity.put("stateContentMasterChangeSeqNum", new TableInfo.Column("stateContentMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateContentEntity.put("stateContentLocalChangeSeqNum", new TableInfo.Column("stateContentLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateContentEntity.put("stateContentLastChangedBy", new TableInfo.Column("stateContentLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateContentEntity.put("stateContentLct", new TableInfo.Column("stateContentLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysStateContentEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesStateContentEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoStateContentEntity = new TableInfo("StateContentEntity", _columnsStateContentEntity, _foreignKeysStateContentEntity, _indicesStateContentEntity);
        final TableInfo _existingStateContentEntity = TableInfo.read(_db, "StateContentEntity");
        if (! _infoStateContentEntity.equals(_existingStateContentEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "StateContentEntity(com.ustadmobile.lib.db.entities.StateContentEntity).\n"
                  + " Expected:\n" + _infoStateContentEntity + "\n"
                  + " Found:\n" + _existingStateContentEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsXLangMapEntry = new HashMap<String, TableInfo.Column>(10);
        _columnsXLangMapEntry.put("verbLangMapUid", new TableInfo.Column("verbLangMapUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXLangMapEntry.put("objectLangMapUid", new TableInfo.Column("objectLangMapUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXLangMapEntry.put("languageLangMapUid", new TableInfo.Column("languageLangMapUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXLangMapEntry.put("languageVariantLangMapUid", new TableInfo.Column("languageVariantLangMapUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXLangMapEntry.put("valueLangMap", new TableInfo.Column("valueLangMap", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXLangMapEntry.put("statementLangMapMasterCsn", new TableInfo.Column("statementLangMapMasterCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXLangMapEntry.put("statementLangMapLocalCsn", new TableInfo.Column("statementLangMapLocalCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXLangMapEntry.put("statementLangMapLcb", new TableInfo.Column("statementLangMapLcb", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXLangMapEntry.put("statementLangMapLct", new TableInfo.Column("statementLangMapLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXLangMapEntry.put("statementLangMapUid", new TableInfo.Column("statementLangMapUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysXLangMapEntry = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesXLangMapEntry = new HashSet<TableInfo.Index>(1);
        _indicesXLangMapEntry.add(new TableInfo.Index("index_XLangMapEntry_verbLangMapUid", false, Arrays.asList("verbLangMapUid"), Arrays.asList("ASC")));
        final TableInfo _infoXLangMapEntry = new TableInfo("XLangMapEntry", _columnsXLangMapEntry, _foreignKeysXLangMapEntry, _indicesXLangMapEntry);
        final TableInfo _existingXLangMapEntry = TableInfo.read(_db, "XLangMapEntry");
        if (! _infoXLangMapEntry.equals(_existingXLangMapEntry)) {
          return new RoomOpenHelper.ValidationResult(false, "XLangMapEntry(com.ustadmobile.lib.db.entities.XLangMapEntry).\n"
                  + " Expected:\n" + _infoXLangMapEntry + "\n"
                  + " Found:\n" + _existingXLangMapEntry);
        }
        final HashMap<String, TableInfo.Column> _columnsSyncNode = new HashMap<String, TableInfo.Column>(1);
        _columnsSyncNode.put("nodeClientId", new TableInfo.Column("nodeClientId", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysSyncNode = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesSyncNode = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoSyncNode = new TableInfo("SyncNode", _columnsSyncNode, _foreignKeysSyncNode, _indicesSyncNode);
        final TableInfo _existingSyncNode = TableInfo.read(_db, "SyncNode");
        if (! _infoSyncNode.equals(_existingSyncNode)) {
          return new RoomOpenHelper.ValidationResult(false, "SyncNode(com.ustadmobile.door.SyncNode).\n"
                  + " Expected:\n" + _infoSyncNode + "\n"
                  + " Found:\n" + _existingSyncNode);
        }
        final HashMap<String, TableInfo.Column> _columnsLocallyAvailableContainer = new HashMap<String, TableInfo.Column>(1);
        _columnsLocallyAvailableContainer.put("laContainerUid", new TableInfo.Column("laContainerUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysLocallyAvailableContainer = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesLocallyAvailableContainer = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoLocallyAvailableContainer = new TableInfo("LocallyAvailableContainer", _columnsLocallyAvailableContainer, _foreignKeysLocallyAvailableContainer, _indicesLocallyAvailableContainer);
        final TableInfo _existingLocallyAvailableContainer = TableInfo.read(_db, "LocallyAvailableContainer");
        if (! _infoLocallyAvailableContainer.equals(_existingLocallyAvailableContainer)) {
          return new RoomOpenHelper.ValidationResult(false, "LocallyAvailableContainer(com.ustadmobile.lib.db.entities.LocallyAvailableContainer).\n"
                  + " Expected:\n" + _infoLocallyAvailableContainer + "\n"
                  + " Found:\n" + _existingLocallyAvailableContainer);
        }
        final HashMap<String, TableInfo.Column> _columnsContainerETag = new HashMap<String, TableInfo.Column>(2);
        _columnsContainerETag.put("ceContainerUid", new TableInfo.Column("ceContainerUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerETag.put("cetag", new TableInfo.Column("cetag", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContainerETag = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContainerETag = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoContainerETag = new TableInfo("ContainerETag", _columnsContainerETag, _foreignKeysContainerETag, _indicesContainerETag);
        final TableInfo _existingContainerETag = TableInfo.read(_db, "ContainerETag");
        if (! _infoContainerETag.equals(_existingContainerETag)) {
          return new RoomOpenHelper.ValidationResult(false, "ContainerETag(com.ustadmobile.lib.db.entities.ContainerETag).\n"
                  + " Expected:\n" + _infoContainerETag + "\n"
                  + " Found:\n" + _existingContainerETag);
        }
        final HashMap<String, TableInfo.Column> _columnsSchool = new HashMap<String, TableInfo.Column>(21);
        _columnsSchool.put("schoolUid", new TableInfo.Column("schoolUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolName", new TableInfo.Column("schoolName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolDesc", new TableInfo.Column("schoolDesc", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolAddress", new TableInfo.Column("schoolAddress", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolActive", new TableInfo.Column("schoolActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolPhoneNumber", new TableInfo.Column("schoolPhoneNumber", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolGender", new TableInfo.Column("schoolGender", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolHolidayCalendarUid", new TableInfo.Column("schoolHolidayCalendarUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolFeatures", new TableInfo.Column("schoolFeatures", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolLocationLong", new TableInfo.Column("schoolLocationLong", "REAL", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolLocationLatt", new TableInfo.Column("schoolLocationLatt", "REAL", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolEmailAddress", new TableInfo.Column("schoolEmailAddress", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolTeachersPersonGroupUid", new TableInfo.Column("schoolTeachersPersonGroupUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolStudentsPersonGroupUid", new TableInfo.Column("schoolStudentsPersonGroupUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolPendingStudentsPersonGroupUid", new TableInfo.Column("schoolPendingStudentsPersonGroupUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolCode", new TableInfo.Column("schoolCode", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolMasterChangeSeqNum", new TableInfo.Column("schoolMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolLocalChangeSeqNum", new TableInfo.Column("schoolLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolLastChangedBy", new TableInfo.Column("schoolLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolLct", new TableInfo.Column("schoolLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchool.put("schoolTimeZone", new TableInfo.Column("schoolTimeZone", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysSchool = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesSchool = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoSchool = new TableInfo("School", _columnsSchool, _foreignKeysSchool, _indicesSchool);
        final TableInfo _existingSchool = TableInfo.read(_db, "School");
        if (! _infoSchool.equals(_existingSchool)) {
          return new RoomOpenHelper.ValidationResult(false, "School(com.ustadmobile.lib.db.entities.School).\n"
                  + " Expected:\n" + _infoSchool + "\n"
                  + " Found:\n" + _existingSchool);
        }
        final HashMap<String, TableInfo.Column> _columnsSchoolMember = new HashMap<String, TableInfo.Column>(11);
        _columnsSchoolMember.put("schoolMemberUid", new TableInfo.Column("schoolMemberUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolMember.put("schoolMemberPersonUid", new TableInfo.Column("schoolMemberPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolMember.put("schoolMemberSchoolUid", new TableInfo.Column("schoolMemberSchoolUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolMember.put("schoolMemberJoinDate", new TableInfo.Column("schoolMemberJoinDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolMember.put("schoolMemberLeftDate", new TableInfo.Column("schoolMemberLeftDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolMember.put("schoolMemberRole", new TableInfo.Column("schoolMemberRole", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolMember.put("schoolMemberActive", new TableInfo.Column("schoolMemberActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolMember.put("schoolMemberLocalChangeSeqNum", new TableInfo.Column("schoolMemberLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolMember.put("schoolMemberMasterChangeSeqNum", new TableInfo.Column("schoolMemberMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolMember.put("schoolMemberLastChangedBy", new TableInfo.Column("schoolMemberLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolMember.put("schoolMemberLct", new TableInfo.Column("schoolMemberLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysSchoolMember = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesSchoolMember = new HashSet<TableInfo.Index>(3);
        _indicesSchoolMember.add(new TableInfo.Index("index_SchoolMember_schoolMemberSchoolUid_schoolMemberActive_schoolMemberRole", false, Arrays.asList("schoolMemberSchoolUid","schoolMemberActive","schoolMemberRole"), Arrays.asList("ASC","ASC","ASC")));
        _indicesSchoolMember.add(new TableInfo.Index("index_SchoolMember_schoolMemberPersonUid", false, Arrays.asList("schoolMemberPersonUid"), Arrays.asList("ASC")));
        _indicesSchoolMember.add(new TableInfo.Index("index_SchoolMember_schoolMemberSchoolUid", false, Arrays.asList("schoolMemberSchoolUid"), Arrays.asList("ASC")));
        final TableInfo _infoSchoolMember = new TableInfo("SchoolMember", _columnsSchoolMember, _foreignKeysSchoolMember, _indicesSchoolMember);
        final TableInfo _existingSchoolMember = TableInfo.read(_db, "SchoolMember");
        if (! _infoSchoolMember.equals(_existingSchoolMember)) {
          return new RoomOpenHelper.ValidationResult(false, "SchoolMember(com.ustadmobile.lib.db.entities.SchoolMember).\n"
                  + " Expected:\n" + _infoSchoolMember + "\n"
                  + " Found:\n" + _existingSchoolMember);
        }
        final HashMap<String, TableInfo.Column> _columnsComments = new HashMap<String, TableInfo.Column>(17);
        _columnsComments.put("commentsUid", new TableInfo.Column("commentsUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentsText", new TableInfo.Column("commentsText", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentsEntityType", new TableInfo.Column("commentsEntityType", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentsEntityUid", new TableInfo.Column("commentsEntityUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentsPublic", new TableInfo.Column("commentsPublic", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentsStatus", new TableInfo.Column("commentsStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentsPersonUid", new TableInfo.Column("commentsPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentsToPersonUid", new TableInfo.Column("commentsToPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentSubmitterUid", new TableInfo.Column("commentSubmitterUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentsFlagged", new TableInfo.Column("commentsFlagged", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentsInActive", new TableInfo.Column("commentsInActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentsDateTimeAdded", new TableInfo.Column("commentsDateTimeAdded", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentsDateTimeUpdated", new TableInfo.Column("commentsDateTimeUpdated", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentsMCSN", new TableInfo.Column("commentsMCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentsLCSN", new TableInfo.Column("commentsLCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentsLCB", new TableInfo.Column("commentsLCB", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsComments.put("commentsLct", new TableInfo.Column("commentsLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysComments = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesComments = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoComments = new TableInfo("Comments", _columnsComments, _foreignKeysComments, _indicesComments);
        final TableInfo _existingComments = TableInfo.read(_db, "Comments");
        if (! _infoComments.equals(_existingComments)) {
          return new RoomOpenHelper.ValidationResult(false, "Comments(com.ustadmobile.lib.db.entities.Comments).\n"
                  + " Expected:\n" + _infoComments + "\n"
                  + " Found:\n" + _existingComments);
        }
        final HashMap<String, TableInfo.Column> _columnsReport = new HashMap<String, TableInfo.Column>(24);
        _columnsReport.put("reportUid", new TableInfo.Column("reportUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("reportOwnerUid", new TableInfo.Column("reportOwnerUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("xAxis", new TableInfo.Column("xAxis", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("reportDateRangeSelection", new TableInfo.Column("reportDateRangeSelection", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("fromDate", new TableInfo.Column("fromDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("fromRelTo", new TableInfo.Column("fromRelTo", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("fromRelOffSet", new TableInfo.Column("fromRelOffSet", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("fromRelUnit", new TableInfo.Column("fromRelUnit", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("toDate", new TableInfo.Column("toDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("toRelTo", new TableInfo.Column("toRelTo", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("toRelOffSet", new TableInfo.Column("toRelOffSet", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("toRelUnit", new TableInfo.Column("toRelUnit", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("reportTitle", new TableInfo.Column("reportTitle", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("reportDescription", new TableInfo.Column("reportDescription", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("reportSeries", new TableInfo.Column("reportSeries", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("reportInactive", new TableInfo.Column("reportInactive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("isTemplate", new TableInfo.Column("isTemplate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("priority", new TableInfo.Column("priority", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("reportTitleId", new TableInfo.Column("reportTitleId", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("reportDescId", new TableInfo.Column("reportDescId", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("reportMasterChangeSeqNum", new TableInfo.Column("reportMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("reportLocalChangeSeqNum", new TableInfo.Column("reportLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("reportLastChangedBy", new TableInfo.Column("reportLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReport.put("reportLct", new TableInfo.Column("reportLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysReport = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesReport = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoReport = new TableInfo("Report", _columnsReport, _foreignKeysReport, _indicesReport);
        final TableInfo _existingReport = TableInfo.read(_db, "Report");
        if (! _infoReport.equals(_existingReport)) {
          return new RoomOpenHelper.ValidationResult(false, "Report(com.ustadmobile.lib.db.entities.Report).\n"
                  + " Expected:\n" + _infoReport + "\n"
                  + " Found:\n" + _existingReport);
        }
        final HashMap<String, TableInfo.Column> _columnsSite = new HashMap<String, TableInfo.Column>(9);
        _columnsSite.put("siteUid", new TableInfo.Column("siteUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSite.put("sitePcsn", new TableInfo.Column("sitePcsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSite.put("siteLcsn", new TableInfo.Column("siteLcsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSite.put("siteLcb", new TableInfo.Column("siteLcb", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSite.put("siteLct", new TableInfo.Column("siteLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSite.put("siteName", new TableInfo.Column("siteName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSite.put("guestLogin", new TableInfo.Column("guestLogin", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSite.put("registrationAllowed", new TableInfo.Column("registrationAllowed", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSite.put("authSalt", new TableInfo.Column("authSalt", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysSite = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesSite = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoSite = new TableInfo("Site", _columnsSite, _foreignKeysSite, _indicesSite);
        final TableInfo _existingSite = TableInfo.read(_db, "Site");
        if (! _infoSite.equals(_existingSite)) {
          return new RoomOpenHelper.ValidationResult(false, "Site(com.ustadmobile.lib.db.entities.Site).\n"
                  + " Expected:\n" + _infoSite + "\n"
                  + " Found:\n" + _existingSite);
        }
        final HashMap<String, TableInfo.Column> _columnsContainerImportJob = new HashMap<String, TableInfo.Column>(14);
        _columnsContainerImportJob.put("cijUid", new TableInfo.Column("cijUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerImportJob.put("cijContainerUid", new TableInfo.Column("cijContainerUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerImportJob.put("cijUri", new TableInfo.Column("cijUri", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerImportJob.put("cijImportMode", new TableInfo.Column("cijImportMode", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerImportJob.put("cijContainerBaseDir", new TableInfo.Column("cijContainerBaseDir", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerImportJob.put("cijContentEntryUid", new TableInfo.Column("cijContentEntryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerImportJob.put("cijMimeType", new TableInfo.Column("cijMimeType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerImportJob.put("cijSessionId", new TableInfo.Column("cijSessionId", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerImportJob.put("cijJobStatus", new TableInfo.Column("cijJobStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerImportJob.put("cijBytesSoFar", new TableInfo.Column("cijBytesSoFar", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerImportJob.put("cijImportCompleted", new TableInfo.Column("cijImportCompleted", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerImportJob.put("cijContentLength", new TableInfo.Column("cijContentLength", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerImportJob.put("cijContainerEntryFileUids", new TableInfo.Column("cijContainerEntryFileUids", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerImportJob.put("cijConversionParams", new TableInfo.Column("cijConversionParams", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContainerImportJob = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContainerImportJob = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoContainerImportJob = new TableInfo("ContainerImportJob", _columnsContainerImportJob, _foreignKeysContainerImportJob, _indicesContainerImportJob);
        final TableInfo _existingContainerImportJob = TableInfo.read(_db, "ContainerImportJob");
        if (! _infoContainerImportJob.equals(_existingContainerImportJob)) {
          return new RoomOpenHelper.ValidationResult(false, "ContainerImportJob(com.ustadmobile.lib.db.entities.ContainerImportJob).\n"
                  + " Expected:\n" + _infoContainerImportJob + "\n"
                  + " Found:\n" + _existingContainerImportJob);
        }
        final HashMap<String, TableInfo.Column> _columnsLearnerGroup = new HashMap<String, TableInfo.Column>(8);
        _columnsLearnerGroup.put("learnerGroupUid", new TableInfo.Column("learnerGroupUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroup.put("learnerGroupName", new TableInfo.Column("learnerGroupName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroup.put("learnerGroupDescription", new TableInfo.Column("learnerGroupDescription", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroup.put("learnerGroupActive", new TableInfo.Column("learnerGroupActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroup.put("learnerGroupMCSN", new TableInfo.Column("learnerGroupMCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroup.put("learnerGroupCSN", new TableInfo.Column("learnerGroupCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroup.put("learnerGroupLCB", new TableInfo.Column("learnerGroupLCB", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroup.put("learnerGroupLct", new TableInfo.Column("learnerGroupLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysLearnerGroup = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesLearnerGroup = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoLearnerGroup = new TableInfo("LearnerGroup", _columnsLearnerGroup, _foreignKeysLearnerGroup, _indicesLearnerGroup);
        final TableInfo _existingLearnerGroup = TableInfo.read(_db, "LearnerGroup");
        if (! _infoLearnerGroup.equals(_existingLearnerGroup)) {
          return new RoomOpenHelper.ValidationResult(false, "LearnerGroup(com.ustadmobile.lib.db.entities.LearnerGroup).\n"
                  + " Expected:\n" + _infoLearnerGroup + "\n"
                  + " Found:\n" + _existingLearnerGroup);
        }
        RoomOpenHelper.ValidationResult _result;
        _result = onValidateSchema2(_db);
        if (!_result.isValid) {
          return _result;
        }
        _result = onValidateSchema3(_db);
        if (!_result.isValid) {
          return _result;
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }

      private RoomOpenHelper.ValidationResult onValidateSchema2(SupportSQLiteDatabase _db) {
        final HashMap<String, TableInfo.Column> _columnsLearnerGroupMember = new HashMap<String, TableInfo.Column>(9);
        _columnsLearnerGroupMember.put("learnerGroupMemberUid", new TableInfo.Column("learnerGroupMemberUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroupMember.put("learnerGroupMemberPersonUid", new TableInfo.Column("learnerGroupMemberPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroupMember.put("learnerGroupMemberLgUid", new TableInfo.Column("learnerGroupMemberLgUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroupMember.put("learnerGroupMemberRole", new TableInfo.Column("learnerGroupMemberRole", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroupMember.put("learnerGroupMemberActive", new TableInfo.Column("learnerGroupMemberActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroupMember.put("learnerGroupMemberMCSN", new TableInfo.Column("learnerGroupMemberMCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroupMember.put("learnerGroupMemberCSN", new TableInfo.Column("learnerGroupMemberCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroupMember.put("learnerGroupMemberLCB", new TableInfo.Column("learnerGroupMemberLCB", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroupMember.put("learnerGroupMemberLct", new TableInfo.Column("learnerGroupMemberLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysLearnerGroupMember = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesLearnerGroupMember = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoLearnerGroupMember = new TableInfo("LearnerGroupMember", _columnsLearnerGroupMember, _foreignKeysLearnerGroupMember, _indicesLearnerGroupMember);
        final TableInfo _existingLearnerGroupMember = TableInfo.read(_db, "LearnerGroupMember");
        if (! _infoLearnerGroupMember.equals(_existingLearnerGroupMember)) {
          return new RoomOpenHelper.ValidationResult(false, "LearnerGroupMember(com.ustadmobile.lib.db.entities.LearnerGroupMember).\n"
                  + " Expected:\n" + _infoLearnerGroupMember + "\n"
                  + " Found:\n" + _existingLearnerGroupMember);
        }
        final HashMap<String, TableInfo.Column> _columnsGroupLearningSession = new HashMap<String, TableInfo.Column>(8);
        _columnsGroupLearningSession.put("groupLearningSessionUid", new TableInfo.Column("groupLearningSessionUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsGroupLearningSession.put("groupLearningSessionContentUid", new TableInfo.Column("groupLearningSessionContentUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsGroupLearningSession.put("groupLearningSessionLearnerGroupUid", new TableInfo.Column("groupLearningSessionLearnerGroupUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsGroupLearningSession.put("groupLearningSessionInactive", new TableInfo.Column("groupLearningSessionInactive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsGroupLearningSession.put("groupLearningSessionMCSN", new TableInfo.Column("groupLearningSessionMCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsGroupLearningSession.put("groupLearningSessionCSN", new TableInfo.Column("groupLearningSessionCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsGroupLearningSession.put("groupLearningSessionLCB", new TableInfo.Column("groupLearningSessionLCB", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsGroupLearningSession.put("groupLearningSessionLct", new TableInfo.Column("groupLearningSessionLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysGroupLearningSession = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesGroupLearningSession = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoGroupLearningSession = new TableInfo("GroupLearningSession", _columnsGroupLearningSession, _foreignKeysGroupLearningSession, _indicesGroupLearningSession);
        final TableInfo _existingGroupLearningSession = TableInfo.read(_db, "GroupLearningSession");
        if (! _infoGroupLearningSession.equals(_existingGroupLearningSession)) {
          return new RoomOpenHelper.ValidationResult(false, "GroupLearningSession(com.ustadmobile.lib.db.entities.GroupLearningSession).\n"
                  + " Expected:\n" + _infoGroupLearningSession + "\n"
                  + " Found:\n" + _existingGroupLearningSession);
        }
        final HashMap<String, TableInfo.Column> _columnsSiteTerms = new HashMap<String, TableInfo.Column>(9);
        _columnsSiteTerms.put("sTermsUid", new TableInfo.Column("sTermsUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSiteTerms.put("termsHtml", new TableInfo.Column("termsHtml", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSiteTerms.put("sTermsLang", new TableInfo.Column("sTermsLang", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSiteTerms.put("sTermsLangUid", new TableInfo.Column("sTermsLangUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSiteTerms.put("sTermsActive", new TableInfo.Column("sTermsActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSiteTerms.put("sTermsLastChangedBy", new TableInfo.Column("sTermsLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSiteTerms.put("sTermsPrimaryCsn", new TableInfo.Column("sTermsPrimaryCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSiteTerms.put("sTermsLocalCsn", new TableInfo.Column("sTermsLocalCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSiteTerms.put("sTermsLct", new TableInfo.Column("sTermsLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysSiteTerms = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesSiteTerms = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoSiteTerms = new TableInfo("SiteTerms", _columnsSiteTerms, _foreignKeysSiteTerms, _indicesSiteTerms);
        final TableInfo _existingSiteTerms = TableInfo.read(_db, "SiteTerms");
        if (! _infoSiteTerms.equals(_existingSiteTerms)) {
          return new RoomOpenHelper.ValidationResult(false, "SiteTerms(com.ustadmobile.lib.db.entities.SiteTerms).\n"
                  + " Expected:\n" + _infoSiteTerms + "\n"
                  + " Found:\n" + _existingSiteTerms);
        }
        final HashMap<String, TableInfo.Column> _columnsClazzContentJoin = new HashMap<String, TableInfo.Column>(8);
        _columnsClazzContentJoin.put("ccjUid", new TableInfo.Column("ccjUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzContentJoin.put("ccjContentEntryUid", new TableInfo.Column("ccjContentEntryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzContentJoin.put("ccjClazzUid", new TableInfo.Column("ccjClazzUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzContentJoin.put("ccjActive", new TableInfo.Column("ccjActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzContentJoin.put("ccjLocalChangeSeqNum", new TableInfo.Column("ccjLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzContentJoin.put("ccjMasterChangeSeqNum", new TableInfo.Column("ccjMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzContentJoin.put("ccjLastChangedBy", new TableInfo.Column("ccjLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzContentJoin.put("ccjLct", new TableInfo.Column("ccjLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysClazzContentJoin = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesClazzContentJoin = new HashSet<TableInfo.Index>(1);
        _indicesClazzContentJoin.add(new TableInfo.Index("index_ClazzContentJoin_ccjContentEntryUid", false, Arrays.asList("ccjContentEntryUid"), Arrays.asList("ASC")));
        final TableInfo _infoClazzContentJoin = new TableInfo("ClazzContentJoin", _columnsClazzContentJoin, _foreignKeysClazzContentJoin, _indicesClazzContentJoin);
        final TableInfo _existingClazzContentJoin = TableInfo.read(_db, "ClazzContentJoin");
        if (! _infoClazzContentJoin.equals(_existingClazzContentJoin)) {
          return new RoomOpenHelper.ValidationResult(false, "ClazzContentJoin(com.ustadmobile.lib.db.entities.ClazzContentJoin).\n"
                  + " Expected:\n" + _infoClazzContentJoin + "\n"
                  + " Found:\n" + _existingClazzContentJoin);
        }
        final HashMap<String, TableInfo.Column> _columnsPersonParentJoin = new HashMap<String, TableInfo.Column>(14);
        _columnsPersonParentJoin.put("ppjUid", new TableInfo.Column("ppjUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoin.put("ppjPcsn", new TableInfo.Column("ppjPcsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoin.put("ppjLcsn", new TableInfo.Column("ppjLcsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoin.put("ppjLcb", new TableInfo.Column("ppjLcb", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoin.put("ppjLct", new TableInfo.Column("ppjLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoin.put("ppjParentPersonUid", new TableInfo.Column("ppjParentPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoin.put("ppjMinorPersonUid", new TableInfo.Column("ppjMinorPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoin.put("ppjRelationship", new TableInfo.Column("ppjRelationship", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoin.put("ppjEmail", new TableInfo.Column("ppjEmail", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoin.put("ppjPhone", new TableInfo.Column("ppjPhone", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoin.put("ppjInactive", new TableInfo.Column("ppjInactive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoin.put("ppjStatus", new TableInfo.Column("ppjStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoin.put("ppjApprovalTiemstamp", new TableInfo.Column("ppjApprovalTiemstamp", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoin.put("ppjApprovalIpAddr", new TableInfo.Column("ppjApprovalIpAddr", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPersonParentJoin = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPersonParentJoin = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoPersonParentJoin = new TableInfo("PersonParentJoin", _columnsPersonParentJoin, _foreignKeysPersonParentJoin, _indicesPersonParentJoin);
        final TableInfo _existingPersonParentJoin = TableInfo.read(_db, "PersonParentJoin");
        if (! _infoPersonParentJoin.equals(_existingPersonParentJoin)) {
          return new RoomOpenHelper.ValidationResult(false, "PersonParentJoin(com.ustadmobile.lib.db.entities.PersonParentJoin).\n"
                  + " Expected:\n" + _infoPersonParentJoin + "\n"
                  + " Found:\n" + _existingPersonParentJoin);
        }
        final HashMap<String, TableInfo.Column> _columnsScopedGrant = new HashMap<String, TableInfo.Column>(11);
        _columnsScopedGrant.put("sgUid", new TableInfo.Column("sgUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScopedGrant.put("sgPcsn", new TableInfo.Column("sgPcsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScopedGrant.put("sgLcsn", new TableInfo.Column("sgLcsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScopedGrant.put("sgLcb", new TableInfo.Column("sgLcb", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScopedGrant.put("sgLct", new TableInfo.Column("sgLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScopedGrant.put("sgTableId", new TableInfo.Column("sgTableId", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScopedGrant.put("sgEntityUid", new TableInfo.Column("sgEntityUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScopedGrant.put("sgPermissions", new TableInfo.Column("sgPermissions", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScopedGrant.put("sgGroupUid", new TableInfo.Column("sgGroupUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScopedGrant.put("sgIndex", new TableInfo.Column("sgIndex", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScopedGrant.put("sgFlags", new TableInfo.Column("sgFlags", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysScopedGrant = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesScopedGrant = new HashSet<TableInfo.Index>(2);
        _indicesScopedGrant.add(new TableInfo.Index("idx_group_to_entity", false, Arrays.asList("sgGroupUid","sgPermissions","sgTableId","sgEntityUid"), Arrays.asList("ASC","ASC","ASC","ASC")));
        _indicesScopedGrant.add(new TableInfo.Index("idx_entity_to_group", false, Arrays.asList("sgTableId","sgEntityUid","sgPermissions","sgGroupUid"), Arrays.asList("ASC","ASC","ASC","ASC")));
        final TableInfo _infoScopedGrant = new TableInfo("ScopedGrant", _columnsScopedGrant, _foreignKeysScopedGrant, _indicesScopedGrant);
        final TableInfo _existingScopedGrant = TableInfo.read(_db, "ScopedGrant");
        if (! _infoScopedGrant.equals(_existingScopedGrant)) {
          return new RoomOpenHelper.ValidationResult(false, "ScopedGrant(com.ustadmobile.lib.db.entities.ScopedGrant).\n"
                  + " Expected:\n" + _infoScopedGrant + "\n"
                  + " Found:\n" + _existingScopedGrant);
        }
        final HashMap<String, TableInfo.Column> _columnsErrorReport = new HashMap<String, TableInfo.Column>(15);
        _columnsErrorReport.put("errUid", new TableInfo.Column("errUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReport.put("errPcsn", new TableInfo.Column("errPcsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReport.put("errLcsn", new TableInfo.Column("errLcsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReport.put("errLcb", new TableInfo.Column("errLcb", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReport.put("errLct", new TableInfo.Column("errLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReport.put("severity", new TableInfo.Column("severity", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReport.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReport.put("presenterUri", new TableInfo.Column("presenterUri", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReport.put("appVersion", new TableInfo.Column("appVersion", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReport.put("versionCode", new TableInfo.Column("versionCode", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReport.put("errorCode", new TableInfo.Column("errorCode", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReport.put("operatingSys", new TableInfo.Column("operatingSys", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReport.put("osVersion", new TableInfo.Column("osVersion", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReport.put("stackTrace", new TableInfo.Column("stackTrace", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReport.put("message", new TableInfo.Column("message", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysErrorReport = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesErrorReport = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoErrorReport = new TableInfo("ErrorReport", _columnsErrorReport, _foreignKeysErrorReport, _indicesErrorReport);
        final TableInfo _existingErrorReport = TableInfo.read(_db, "ErrorReport");
        if (! _infoErrorReport.equals(_existingErrorReport)) {
          return new RoomOpenHelper.ValidationResult(false, "ErrorReport(com.ustadmobile.lib.db.entities.ErrorReport).\n"
                  + " Expected:\n" + _infoErrorReport + "\n"
                  + " Found:\n" + _existingErrorReport);
        }
        final HashMap<String, TableInfo.Column> _columnsClazzAssignment = new HashMap<String, TableInfo.Column>(23);
        _columnsClazzAssignment.put("caUid", new TableInfo.Column("caUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caTitle", new TableInfo.Column("caTitle", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caDescription", new TableInfo.Column("caDescription", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caGroupUid", new TableInfo.Column("caGroupUid", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caActive", new TableInfo.Column("caActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caClassCommentEnabled", new TableInfo.Column("caClassCommentEnabled", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caPrivateCommentsEnabled", new TableInfo.Column("caPrivateCommentsEnabled", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caCompletionCriteria", new TableInfo.Column("caCompletionCriteria", "INTEGER", true, 0, "100", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caRequireFileSubmission", new TableInfo.Column("caRequireFileSubmission", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caFileType", new TableInfo.Column("caFileType", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caSizeLimit", new TableInfo.Column("caSizeLimit", "INTEGER", true, 0, "50", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caNumberOfFiles", new TableInfo.Column("caNumberOfFiles", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caSubmissionPolicy", new TableInfo.Column("caSubmissionPolicy", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caMarkingType", new TableInfo.Column("caMarkingType", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caRequireTextSubmission", new TableInfo.Column("caRequireTextSubmission", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caTextLimitType", new TableInfo.Column("caTextLimitType", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caTextLimit", new TableInfo.Column("caTextLimit", "INTEGER", true, 0, "500", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caXObjectUid", new TableInfo.Column("caXObjectUid", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caClazzUid", new TableInfo.Column("caClazzUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caLocalChangeSeqNum", new TableInfo.Column("caLocalChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caMasterChangeSeqNum", new TableInfo.Column("caMasterChangeSeqNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caLastChangedBy", new TableInfo.Column("caLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignment.put("caLct", new TableInfo.Column("caLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysClazzAssignment = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesClazzAssignment = new HashSet<TableInfo.Index>(1);
        _indicesClazzAssignment.add(new TableInfo.Index("index_ClazzAssignment_caClazzUid", false, Arrays.asList("caClazzUid"), Arrays.asList("ASC")));
        final TableInfo _infoClazzAssignment = new TableInfo("ClazzAssignment", _columnsClazzAssignment, _foreignKeysClazzAssignment, _indicesClazzAssignment);
        final TableInfo _existingClazzAssignment = TableInfo.read(_db, "ClazzAssignment");
        if (! _infoClazzAssignment.equals(_existingClazzAssignment)) {
          return new RoomOpenHelper.ValidationResult(false, "ClazzAssignment(com.ustadmobile.lib.db.entities.ClazzAssignment).\n"
                  + " Expected:\n" + _infoClazzAssignment + "\n"
                  + " Found:\n" + _existingClazzAssignment);
        }
        final HashMap<String, TableInfo.Column> _columnsClazzAssignmentContentJoin = new HashMap<String, TableInfo.Column>(9);
        _columnsClazzAssignmentContentJoin.put("cacjUid", new TableInfo.Column("cacjUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentContentJoin.put("cacjContentUid", new TableInfo.Column("cacjContentUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentContentJoin.put("cacjAssignmentUid", new TableInfo.Column("cacjAssignmentUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentContentJoin.put("cacjActive", new TableInfo.Column("cacjActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentContentJoin.put("cacjWeight", new TableInfo.Column("cacjWeight", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentContentJoin.put("cacjMCSN", new TableInfo.Column("cacjMCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentContentJoin.put("cacjLCSN", new TableInfo.Column("cacjLCSN", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentContentJoin.put("cacjLCB", new TableInfo.Column("cacjLCB", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentContentJoin.put("cacjLct", new TableInfo.Column("cacjLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysClazzAssignmentContentJoin = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesClazzAssignmentContentJoin = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoClazzAssignmentContentJoin = new TableInfo("ClazzAssignmentContentJoin", _columnsClazzAssignmentContentJoin, _foreignKeysClazzAssignmentContentJoin, _indicesClazzAssignmentContentJoin);
        final TableInfo _existingClazzAssignmentContentJoin = TableInfo.read(_db, "ClazzAssignmentContentJoin");
        if (! _infoClazzAssignmentContentJoin.equals(_existingClazzAssignmentContentJoin)) {
          return new RoomOpenHelper.ValidationResult(false, "ClazzAssignmentContentJoin(com.ustadmobile.lib.db.entities.ClazzAssignmentContentJoin).\n"
                  + " Expected:\n" + _infoClazzAssignmentContentJoin + "\n"
                  + " Found:\n" + _existingClazzAssignmentContentJoin);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseAssignmentSubmission = new HashMap<String, TableInfo.Column>(7);
        _columnsCourseAssignmentSubmission.put("casUid", new TableInfo.Column("casUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmission.put("casAssignmentUid", new TableInfo.Column("casAssignmentUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmission.put("casSubmitterUid", new TableInfo.Column("casSubmitterUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmission.put("casSubmitterPersonUid", new TableInfo.Column("casSubmitterPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmission.put("casText", new TableInfo.Column("casText", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmission.put("casType", new TableInfo.Column("casType", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmission.put("casTimestamp", new TableInfo.Column("casTimestamp", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseAssignmentSubmission = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseAssignmentSubmission = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoCourseAssignmentSubmission = new TableInfo("CourseAssignmentSubmission", _columnsCourseAssignmentSubmission, _foreignKeysCourseAssignmentSubmission, _indicesCourseAssignmentSubmission);
        final TableInfo _existingCourseAssignmentSubmission = TableInfo.read(_db, "CourseAssignmentSubmission");
        if (! _infoCourseAssignmentSubmission.equals(_existingCourseAssignmentSubmission)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseAssignmentSubmission(com.ustadmobile.lib.db.entities.CourseAssignmentSubmission).\n"
                  + " Expected:\n" + _infoCourseAssignmentSubmission + "\n"
                  + " Found:\n" + _existingCourseAssignmentSubmission);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseAssignmentSubmissionAttachment = new HashMap<String, TableInfo.Column>(8);
        _columnsCourseAssignmentSubmissionAttachment.put("casaUid", new TableInfo.Column("casaUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmissionAttachment.put("casaSubmissionUid", new TableInfo.Column("casaSubmissionUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmissionAttachment.put("casaMimeType", new TableInfo.Column("casaMimeType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmissionAttachment.put("casaFileName", new TableInfo.Column("casaFileName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmissionAttachment.put("casaUri", new TableInfo.Column("casaUri", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmissionAttachment.put("casaMd5", new TableInfo.Column("casaMd5", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmissionAttachment.put("casaSize", new TableInfo.Column("casaSize", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmissionAttachment.put("casaTimestamp", new TableInfo.Column("casaTimestamp", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseAssignmentSubmissionAttachment = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseAssignmentSubmissionAttachment = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoCourseAssignmentSubmissionAttachment = new TableInfo("CourseAssignmentSubmissionAttachment", _columnsCourseAssignmentSubmissionAttachment, _foreignKeysCourseAssignmentSubmissionAttachment, _indicesCourseAssignmentSubmissionAttachment);
        final TableInfo _existingCourseAssignmentSubmissionAttachment = TableInfo.read(_db, "CourseAssignmentSubmissionAttachment");
        if (! _infoCourseAssignmentSubmissionAttachment.equals(_existingCourseAssignmentSubmissionAttachment)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseAssignmentSubmissionAttachment(com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionAttachment).\n"
                  + " Expected:\n" + _infoCourseAssignmentSubmissionAttachment + "\n"
                  + " Found:\n" + _existingCourseAssignmentSubmissionAttachment);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseAssignmentMark = new HashMap<String, TableInfo.Column>(6);
        _columnsCourseAssignmentMark.put("camUid", new TableInfo.Column("camUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentMark.put("camAssignmentUid", new TableInfo.Column("camAssignmentUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentMark.put("camSubmitterUid", new TableInfo.Column("camSubmitterUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentMark.put("camMark", new TableInfo.Column("camMark", "REAL", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentMark.put("camPenalty", new TableInfo.Column("camPenalty", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentMark.put("camLct", new TableInfo.Column("camLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseAssignmentMark = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseAssignmentMark = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoCourseAssignmentMark = new TableInfo("CourseAssignmentMark", _columnsCourseAssignmentMark, _foreignKeysCourseAssignmentMark, _indicesCourseAssignmentMark);
        final TableInfo _existingCourseAssignmentMark = TableInfo.read(_db, "CourseAssignmentMark");
        if (! _infoCourseAssignmentMark.equals(_existingCourseAssignmentMark)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseAssignmentMark(com.ustadmobile.lib.db.entities.CourseAssignmentMark).\n"
                  + " Expected:\n" + _infoCourseAssignmentMark + "\n"
                  + " Found:\n" + _existingCourseAssignmentMark);
        }
        final HashMap<String, TableInfo.Column> _columnsClazzAssignmentRollUp = new HashMap<String, TableInfo.Column>(13);
        _columnsClazzAssignmentRollUp.put("cacheUid", new TableInfo.Column("cacheUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentRollUp.put("cachePersonUid", new TableInfo.Column("cachePersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentRollUp.put("cacheContentEntryUid", new TableInfo.Column("cacheContentEntryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentRollUp.put("cacheClazzAssignmentUid", new TableInfo.Column("cacheClazzAssignmentUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentRollUp.put("cacheStudentScore", new TableInfo.Column("cacheStudentScore", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentRollUp.put("cacheMaxScore", new TableInfo.Column("cacheMaxScore", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentRollUp.put("cacheFinalWeightScoreWithPenalty", new TableInfo.Column("cacheFinalWeightScoreWithPenalty", "REAL", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentRollUp.put("cacheWeight", new TableInfo.Column("cacheWeight", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentRollUp.put("cacheProgress", new TableInfo.Column("cacheProgress", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentRollUp.put("cacheContentComplete", new TableInfo.Column("cacheContentComplete", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentRollUp.put("cacheSuccess", new TableInfo.Column("cacheSuccess", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentRollUp.put("cachePenalty", new TableInfo.Column("cachePenalty", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentRollUp.put("lastCsnChecked", new TableInfo.Column("lastCsnChecked", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysClazzAssignmentRollUp = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesClazzAssignmentRollUp = new HashSet<TableInfo.Index>(1);
        _indicesClazzAssignmentRollUp.add(new TableInfo.Index("index_ClazzAssignmentRollUp_cachePersonUid_cacheContentEntryUid_cacheClazzAssignmentUid", true, Arrays.asList("cachePersonUid","cacheContentEntryUid","cacheClazzAssignmentUid"), Arrays.asList("ASC","ASC","ASC")));
        final TableInfo _infoClazzAssignmentRollUp = new TableInfo("ClazzAssignmentRollUp", _columnsClazzAssignmentRollUp, _foreignKeysClazzAssignmentRollUp, _indicesClazzAssignmentRollUp);
        final TableInfo _existingClazzAssignmentRollUp = TableInfo.read(_db, "ClazzAssignmentRollUp");
        if (! _infoClazzAssignmentRollUp.equals(_existingClazzAssignmentRollUp)) {
          return new RoomOpenHelper.ValidationResult(false, "ClazzAssignmentRollUp(com.ustadmobile.lib.db.entities.ClazzAssignmentRollUp).\n"
                  + " Expected:\n" + _infoClazzAssignmentRollUp + "\n"
                  + " Found:\n" + _existingClazzAssignmentRollUp);
        }
        final HashMap<String, TableInfo.Column> _columnsPersonAuth2 = new HashMap<String, TableInfo.Column>(7);
        _columnsPersonAuth2.put("pauthUid", new TableInfo.Column("pauthUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonAuth2.put("pauthMechanism", new TableInfo.Column("pauthMechanism", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonAuth2.put("pauthAuth", new TableInfo.Column("pauthAuth", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonAuth2.put("pauthLcsn", new TableInfo.Column("pauthLcsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonAuth2.put("pauthPcsn", new TableInfo.Column("pauthPcsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonAuth2.put("pauthLcb", new TableInfo.Column("pauthLcb", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonAuth2.put("pauthLct", new TableInfo.Column("pauthLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPersonAuth2 = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPersonAuth2 = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoPersonAuth2 = new TableInfo("PersonAuth2", _columnsPersonAuth2, _foreignKeysPersonAuth2, _indicesPersonAuth2);
        final TableInfo _existingPersonAuth2 = TableInfo.read(_db, "PersonAuth2");
        if (! _infoPersonAuth2.equals(_existingPersonAuth2)) {
          return new RoomOpenHelper.ValidationResult(false, "PersonAuth2(com.ustadmobile.lib.db.entities.PersonAuth2).\n"
                  + " Expected:\n" + _infoPersonAuth2 + "\n"
                  + " Found:\n" + _existingPersonAuth2);
        }
        final HashMap<String, TableInfo.Column> _columnsUserSession = new HashMap<String, TableInfo.Column>(13);
        _columnsUserSession.put("usUid", new TableInfo.Column("usUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSession.put("usPcsn", new TableInfo.Column("usPcsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSession.put("usLcsn", new TableInfo.Column("usLcsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSession.put("usLcb", new TableInfo.Column("usLcb", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSession.put("usLct", new TableInfo.Column("usLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSession.put("usPersonUid", new TableInfo.Column("usPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSession.put("usClientNodeId", new TableInfo.Column("usClientNodeId", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSession.put("usStartTime", new TableInfo.Column("usStartTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSession.put("usEndTime", new TableInfo.Column("usEndTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSession.put("usStatus", new TableInfo.Column("usStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSession.put("usReason", new TableInfo.Column("usReason", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSession.put("usAuth", new TableInfo.Column("usAuth", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSession.put("usSessionType", new TableInfo.Column("usSessionType", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysUserSession = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesUserSession = new HashSet<TableInfo.Index>(2);
        _indicesUserSession.add(new TableInfo.Index("person_status_node_idx", false, Arrays.asList("usPersonUid","usStatus","usClientNodeId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesUserSession.add(new TableInfo.Index("node_status_person_idx", false, Arrays.asList("usClientNodeId","usStatus","usPersonUid"), Arrays.asList("ASC","ASC","ASC")));
        final TableInfo _infoUserSession = new TableInfo("UserSession", _columnsUserSession, _foreignKeysUserSession, _indicesUserSession);
        final TableInfo _existingUserSession = TableInfo.read(_db, "UserSession");
        if (! _infoUserSession.equals(_existingUserSession)) {
          return new RoomOpenHelper.ValidationResult(false, "UserSession(com.ustadmobile.lib.db.entities.UserSession).\n"
                  + " Expected:\n" + _infoUserSession + "\n"
                  + " Found:\n" + _existingUserSession);
        }
        final HashMap<String, TableInfo.Column> _columnsContentJob = new HashMap<String, TableInfo.Column>(7);
        _columnsContentJob.put("cjUid", new TableInfo.Column("cjUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJob.put("toUri", new TableInfo.Column("toUri", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJob.put("cjProgress", new TableInfo.Column("cjProgress", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJob.put("cjTotal", new TableInfo.Column("cjTotal", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJob.put("cjNotificationTitle", new TableInfo.Column("cjNotificationTitle", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJob.put("cjIsMeteredAllowed", new TableInfo.Column("cjIsMeteredAllowed", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJob.put("params", new TableInfo.Column("params", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentJob = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentJob = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoContentJob = new TableInfo("ContentJob", _columnsContentJob, _foreignKeysContentJob, _indicesContentJob);
        final TableInfo _existingContentJob = TableInfo.read(_db, "ContentJob");
        if (! _infoContentJob.equals(_existingContentJob)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentJob(com.ustadmobile.lib.db.entities.ContentJob).\n"
                  + " Expected:\n" + _infoContentJob + "\n"
                  + " Found:\n" + _existingContentJob);
        }
        final HashMap<String, TableInfo.Column> _columnsContentJobItem = new HashMap<String, TableInfo.Column>(23);
        _columnsContentJobItem.put("cjiUid", new TableInfo.Column("cjiUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiJobUid", new TableInfo.Column("cjiJobUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("sourceUri", new TableInfo.Column("sourceUri", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiIsLeaf", new TableInfo.Column("cjiIsLeaf", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiContentEntryUid", new TableInfo.Column("cjiContentEntryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiParentContentEntryUid", new TableInfo.Column("cjiParentContentEntryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiContainerUid", new TableInfo.Column("cjiContainerUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiItemProgress", new TableInfo.Column("cjiItemProgress", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiItemTotal", new TableInfo.Column("cjiItemTotal", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiRecursiveProgress", new TableInfo.Column("cjiRecursiveProgress", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiRecursiveTotal", new TableInfo.Column("cjiRecursiveTotal", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiStatus", new TableInfo.Column("cjiStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiRecursiveStatus", new TableInfo.Column("cjiRecursiveStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiConnectivityNeeded", new TableInfo.Column("cjiConnectivityNeeded", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiPluginId", new TableInfo.Column("cjiPluginId", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiAttemptCount", new TableInfo.Column("cjiAttemptCount", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiParentCjiUid", new TableInfo.Column("cjiParentCjiUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiServerJobId", new TableInfo.Column("cjiServerJobId", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiStartTime", new TableInfo.Column("cjiStartTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiFinishTime", new TableInfo.Column("cjiFinishTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiUploadSessionUid", new TableInfo.Column("cjiUploadSessionUid", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiContentDeletedOnCancellation", new TableInfo.Column("cjiContentDeletedOnCancellation", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentJobItem.put("cjiContainerProcessed", new TableInfo.Column("cjiContainerProcessed", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentJobItem = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentJobItem = new HashSet<TableInfo.Index>(1);
        _indicesContentJobItem.add(new TableInfo.Index("index_ContentJobItem_cjiContentEntryUid_cjiFinishTime", false, Arrays.asList("cjiContentEntryUid","cjiFinishTime"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoContentJobItem = new TableInfo("ContentJobItem", _columnsContentJobItem, _foreignKeysContentJobItem, _indicesContentJobItem);
        final TableInfo _existingContentJobItem = TableInfo.read(_db, "ContentJobItem");
        if (! _infoContentJobItem.equals(_existingContentJobItem)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentJobItem(com.ustadmobile.lib.db.entities.ContentJobItem).\n"
                  + " Expected:\n" + _infoContentJobItem + "\n"
                  + " Found:\n" + _existingContentJobItem);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseBlock = new HashMap<String, TableInfo.Column>(19);
        _columnsCourseBlock.put("cbUid", new TableInfo.Column("cbUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbType", new TableInfo.Column("cbType", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbIndentLevel", new TableInfo.Column("cbIndentLevel", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbModuleParentBlockUid", new TableInfo.Column("cbModuleParentBlockUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbTitle", new TableInfo.Column("cbTitle", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbDescription", new TableInfo.Column("cbDescription", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbCompletionCriteria", new TableInfo.Column("cbCompletionCriteria", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbHideUntilDate", new TableInfo.Column("cbHideUntilDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbDeadlineDate", new TableInfo.Column("cbDeadlineDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbLateSubmissionPenalty", new TableInfo.Column("cbLateSubmissionPenalty", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbGracePeriodDate", new TableInfo.Column("cbGracePeriodDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbMaxPoints", new TableInfo.Column("cbMaxPoints", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbMinPoints", new TableInfo.Column("cbMinPoints", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbIndex", new TableInfo.Column("cbIndex", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbClazzUid", new TableInfo.Column("cbClazzUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbActive", new TableInfo.Column("cbActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbHidden", new TableInfo.Column("cbHidden", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbEntityUid", new TableInfo.Column("cbEntityUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlock.put("cbLct", new TableInfo.Column("cbLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseBlock = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseBlock = new HashSet<TableInfo.Index>(1);
        _indicesCourseBlock.add(new TableInfo.Index("index_CourseBlock_cbClazzUid", false, Arrays.asList("cbClazzUid"), Arrays.asList("ASC")));
        final TableInfo _infoCourseBlock = new TableInfo("CourseBlock", _columnsCourseBlock, _foreignKeysCourseBlock, _indicesCourseBlock);
        final TableInfo _existingCourseBlock = TableInfo.read(_db, "CourseBlock");
        if (! _infoCourseBlock.equals(_existingCourseBlock)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseBlock(com.ustadmobile.lib.db.entities.CourseBlock).\n"
                  + " Expected:\n" + _infoCourseBlock + "\n"
                  + " Found:\n" + _existingCourseBlock);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseTerminology = new HashMap<String, TableInfo.Column>(4);
        _columnsCourseTerminology.put("ctUid", new TableInfo.Column("ctUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseTerminology.put("ctTitle", new TableInfo.Column("ctTitle", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseTerminology.put("ctTerminology", new TableInfo.Column("ctTerminology", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseTerminology.put("ctLct", new TableInfo.Column("ctLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseTerminology = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseTerminology = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoCourseTerminology = new TableInfo("CourseTerminology", _columnsCourseTerminology, _foreignKeysCourseTerminology, _indicesCourseTerminology);
        final TableInfo _existingCourseTerminology = TableInfo.read(_db, "CourseTerminology");
        if (! _infoCourseTerminology.equals(_existingCourseTerminology)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseTerminology(com.ustadmobile.lib.db.entities.CourseTerminology).\n"
                  + " Expected:\n" + _infoCourseTerminology + "\n"
                  + " Found:\n" + _existingCourseTerminology);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseGroupSet = new HashMap<String, TableInfo.Column>(6);
        _columnsCourseGroupSet.put("cgsUid", new TableInfo.Column("cgsUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseGroupSet.put("cgsName", new TableInfo.Column("cgsName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseGroupSet.put("cgsTotalGroups", new TableInfo.Column("cgsTotalGroups", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseGroupSet.put("cgsActive", new TableInfo.Column("cgsActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseGroupSet.put("cgsClazzUid", new TableInfo.Column("cgsClazzUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseGroupSet.put("cgsLct", new TableInfo.Column("cgsLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseGroupSet = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseGroupSet = new HashSet<TableInfo.Index>(1);
        _indicesCourseGroupSet.add(new TableInfo.Index("index_CourseGroupSet_cgsClazzUid", false, Arrays.asList("cgsClazzUid"), Arrays.asList("ASC")));
        final TableInfo _infoCourseGroupSet = new TableInfo("CourseGroupSet", _columnsCourseGroupSet, _foreignKeysCourseGroupSet, _indicesCourseGroupSet);
        final TableInfo _existingCourseGroupSet = TableInfo.read(_db, "CourseGroupSet");
        if (! _infoCourseGroupSet.equals(_existingCourseGroupSet)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseGroupSet(com.ustadmobile.lib.db.entities.CourseGroupSet).\n"
                  + " Expected:\n" + _infoCourseGroupSet + "\n"
                  + " Found:\n" + _existingCourseGroupSet);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseGroupMember = new HashMap<String, TableInfo.Column>(5);
        _columnsCourseGroupMember.put("cgmUid", new TableInfo.Column("cgmUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseGroupMember.put("cgmSetUid", new TableInfo.Column("cgmSetUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseGroupMember.put("cgmGroupNumber", new TableInfo.Column("cgmGroupNumber", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseGroupMember.put("cgmPersonUid", new TableInfo.Column("cgmPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseGroupMember.put("cgmLct", new TableInfo.Column("cgmLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseGroupMember = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseGroupMember = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoCourseGroupMember = new TableInfo("CourseGroupMember", _columnsCourseGroupMember, _foreignKeysCourseGroupMember, _indicesCourseGroupMember);
        final TableInfo _existingCourseGroupMember = TableInfo.read(_db, "CourseGroupMember");
        if (! _infoCourseGroupMember.equals(_existingCourseGroupMember)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseGroupMember(com.ustadmobile.lib.db.entities.CourseGroupMember).\n"
                  + " Expected:\n" + _infoCourseGroupMember + "\n"
                  + " Found:\n" + _existingCourseGroupMember);
        }
        final HashMap<String, TableInfo.Column> _columnsChangeLog = new HashMap<String, TableInfo.Column>(3);
        _columnsChangeLog.put("chTableId", new TableInfo.Column("chTableId", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChangeLog.put("chEntityPk", new TableInfo.Column("chEntityPk", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChangeLog.put("chType", new TableInfo.Column("chType", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysChangeLog = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesChangeLog = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoChangeLog = new TableInfo("ChangeLog", _columnsChangeLog, _foreignKeysChangeLog, _indicesChangeLog);
        final TableInfo _existingChangeLog = TableInfo.read(_db, "ChangeLog");
        if (! _infoChangeLog.equals(_existingChangeLog)) {
          return new RoomOpenHelper.ValidationResult(false, "ChangeLog(com.ustadmobile.door.entities.ChangeLog).\n"
                  + " Expected:\n" + _infoChangeLog + "\n"
                  + " Found:\n" + _existingChangeLog);
        }
        final HashMap<String, TableInfo.Column> _columnsZombieAttachmentData = new HashMap<String, TableInfo.Column>(2);
        _columnsZombieAttachmentData.put("zaUid", new TableInfo.Column("zaUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsZombieAttachmentData.put("zaUri", new TableInfo.Column("zaUri", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysZombieAttachmentData = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesZombieAttachmentData = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoZombieAttachmentData = new TableInfo("ZombieAttachmentData", _columnsZombieAttachmentData, _foreignKeysZombieAttachmentData, _indicesZombieAttachmentData);
        final TableInfo _existingZombieAttachmentData = TableInfo.read(_db, "ZombieAttachmentData");
        if (! _infoZombieAttachmentData.equals(_existingZombieAttachmentData)) {
          return new RoomOpenHelper.ValidationResult(false, "ZombieAttachmentData(com.ustadmobile.door.entities.ZombieAttachmentData).\n"
                  + " Expected:\n" + _infoZombieAttachmentData + "\n"
                  + " Found:\n" + _existingZombieAttachmentData);
        }
        final HashMap<String, TableInfo.Column> _columnsDoorNode = new HashMap<String, TableInfo.Column>(3);
        _columnsDoorNode.put("nodeId", new TableInfo.Column("nodeId", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDoorNode.put("auth", new TableInfo.Column("auth", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDoorNode.put("rel", new TableInfo.Column("rel", "INTEGER", true, 0, "2", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysDoorNode = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesDoorNode = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoDoorNode = new TableInfo("DoorNode", _columnsDoorNode, _foreignKeysDoorNode, _indicesDoorNode);
        final TableInfo _existingDoorNode = TableInfo.read(_db, "DoorNode");
        if (! _infoDoorNode.equals(_existingDoorNode)) {
          return new RoomOpenHelper.ValidationResult(false, "DoorNode(com.ustadmobile.door.entities.DoorNode).\n"
                  + " Expected:\n" + _infoDoorNode + "\n"
                  + " Found:\n" + _existingDoorNode);
        }
        final HashMap<String, TableInfo.Column> _columnsReplicationStatus = new HashMap<String, TableInfo.Column>(8);
        _columnsReplicationStatus.put("repStatusId", new TableInfo.Column("repStatusId", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplicationStatus.put("tableId", new TableInfo.Column("tableId", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplicationStatus.put("priority", new TableInfo.Column("priority", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplicationStatus.put("nodeId", new TableInfo.Column("nodeId", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplicationStatus.put("lastRemoteChangeTime", new TableInfo.Column("lastRemoteChangeTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplicationStatus.put("lastFetchReplicationCompleteTime", new TableInfo.Column("lastFetchReplicationCompleteTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplicationStatus.put("lastLocalChangeTime", new TableInfo.Column("lastLocalChangeTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReplicationStatus.put("lastSendReplicationCompleteTime", new TableInfo.Column("lastSendReplicationCompleteTime", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysReplicationStatus = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesReplicationStatus = new HashSet<TableInfo.Index>(1);
        _indicesReplicationStatus.add(new TableInfo.Index("table_node_idx", true, Arrays.asList("tableId","nodeId"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoReplicationStatus = new TableInfo("ReplicationStatus", _columnsReplicationStatus, _foreignKeysReplicationStatus, _indicesReplicationStatus);
        final TableInfo _existingReplicationStatus = TableInfo.read(_db, "ReplicationStatus");
        if (! _infoReplicationStatus.equals(_existingReplicationStatus)) {
          return new RoomOpenHelper.ValidationResult(false, "ReplicationStatus(com.ustadmobile.door.entities.ReplicationStatus).\n"
                  + " Expected:\n" + _infoReplicationStatus + "\n"
                  + " Found:\n" + _existingReplicationStatus);
        }
        final HashMap<String, TableInfo.Column> _columnsClazzLogReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsClazzLogReplicate.put("clPk", new TableInfo.Column("clPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLogReplicate.put("clVersionId", new TableInfo.Column("clVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLogReplicate.put("clDestination", new TableInfo.Column("clDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLogReplicate.put("clPending", new TableInfo.Column("clPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysClazzLogReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesClazzLogReplicate = new HashSet<TableInfo.Index>(2);
        _indicesClazzLogReplicate.add(new TableInfo.Index("index_ClazzLogReplicate_clPk_clDestination_clVersionId", false, Arrays.asList("clPk","clDestination","clVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesClazzLogReplicate.add(new TableInfo.Index("index_ClazzLogReplicate_clDestination_clPending", false, Arrays.asList("clDestination","clPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoClazzLogReplicate = new TableInfo("ClazzLogReplicate", _columnsClazzLogReplicate, _foreignKeysClazzLogReplicate, _indicesClazzLogReplicate);
        final TableInfo _existingClazzLogReplicate = TableInfo.read(_db, "ClazzLogReplicate");
        if (! _infoClazzLogReplicate.equals(_existingClazzLogReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ClazzLogReplicate(com.ustadmobile.lib.db.entities.ClazzLogReplicate).\n"
                  + " Expected:\n" + _infoClazzLogReplicate + "\n"
                  + " Found:\n" + _existingClazzLogReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsClazzLogAttendanceRecordReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsClazzLogAttendanceRecordReplicate.put("clarPk", new TableInfo.Column("clarPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLogAttendanceRecordReplicate.put("clarVersionId", new TableInfo.Column("clarVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLogAttendanceRecordReplicate.put("clarDestination", new TableInfo.Column("clarDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzLogAttendanceRecordReplicate.put("clarPending", new TableInfo.Column("clarPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysClazzLogAttendanceRecordReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesClazzLogAttendanceRecordReplicate = new HashSet<TableInfo.Index>(2);
        _indicesClazzLogAttendanceRecordReplicate.add(new TableInfo.Index("index_ClazzLogAttendanceRecordReplicate_clarPk_clarDestination_clarVersionId", false, Arrays.asList("clarPk","clarDestination","clarVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesClazzLogAttendanceRecordReplicate.add(new TableInfo.Index("index_ClazzLogAttendanceRecordReplicate_clarDestination_clarPending", false, Arrays.asList("clarDestination","clarPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoClazzLogAttendanceRecordReplicate = new TableInfo("ClazzLogAttendanceRecordReplicate", _columnsClazzLogAttendanceRecordReplicate, _foreignKeysClazzLogAttendanceRecordReplicate, _indicesClazzLogAttendanceRecordReplicate);
        final TableInfo _existingClazzLogAttendanceRecordReplicate = TableInfo.read(_db, "ClazzLogAttendanceRecordReplicate");
        if (! _infoClazzLogAttendanceRecordReplicate.equals(_existingClazzLogAttendanceRecordReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ClazzLogAttendanceRecordReplicate(com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecordReplicate).\n"
                  + " Expected:\n" + _infoClazzLogAttendanceRecordReplicate + "\n"
                  + " Found:\n" + _existingClazzLogAttendanceRecordReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseAssignmentSubmissionReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsCourseAssignmentSubmissionReplicate.put("casPk", new TableInfo.Column("casPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmissionReplicate.put("casVersionId", new TableInfo.Column("casVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmissionReplicate.put("casDestination", new TableInfo.Column("casDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmissionReplicate.put("casPending", new TableInfo.Column("casPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseAssignmentSubmissionReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseAssignmentSubmissionReplicate = new HashSet<TableInfo.Index>(2);
        _indicesCourseAssignmentSubmissionReplicate.add(new TableInfo.Index("index_CourseAssignmentSubmissionReplicate_casPk_casDestination_casVersionId", false, Arrays.asList("casPk","casDestination","casVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesCourseAssignmentSubmissionReplicate.add(new TableInfo.Index("index_CourseAssignmentSubmissionReplicate_casDestination_casPending", false, Arrays.asList("casDestination","casPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoCourseAssignmentSubmissionReplicate = new TableInfo("CourseAssignmentSubmissionReplicate", _columnsCourseAssignmentSubmissionReplicate, _foreignKeysCourseAssignmentSubmissionReplicate, _indicesCourseAssignmentSubmissionReplicate);
        final TableInfo _existingCourseAssignmentSubmissionReplicate = TableInfo.read(_db, "CourseAssignmentSubmissionReplicate");
        if (! _infoCourseAssignmentSubmissionReplicate.equals(_existingCourseAssignmentSubmissionReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseAssignmentSubmissionReplicate(com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionReplicate).\n"
                  + " Expected:\n" + _infoCourseAssignmentSubmissionReplicate + "\n"
                  + " Found:\n" + _existingCourseAssignmentSubmissionReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseAssignmentSubmissionAttachmentReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsCourseAssignmentSubmissionAttachmentReplicate.put("casaPk", new TableInfo.Column("casaPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmissionAttachmentReplicate.put("casaVersionId", new TableInfo.Column("casaVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmissionAttachmentReplicate.put("casaDestination", new TableInfo.Column("casaDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentSubmissionAttachmentReplicate.put("casaPending", new TableInfo.Column("casaPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseAssignmentSubmissionAttachmentReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseAssignmentSubmissionAttachmentReplicate = new HashSet<TableInfo.Index>(2);
        _indicesCourseAssignmentSubmissionAttachmentReplicate.add(new TableInfo.Index("index_CourseAssignmentSubmissionAttachmentReplicate_casaPk_casaDestination_casaVersionId", false, Arrays.asList("casaPk","casaDestination","casaVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesCourseAssignmentSubmissionAttachmentReplicate.add(new TableInfo.Index("index_CourseAssignmentSubmissionAttachmentReplicate_casaDestination_casaPending", false, Arrays.asList("casaDestination","casaPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoCourseAssignmentSubmissionAttachmentReplicate = new TableInfo("CourseAssignmentSubmissionAttachmentReplicate", _columnsCourseAssignmentSubmissionAttachmentReplicate, _foreignKeysCourseAssignmentSubmissionAttachmentReplicate, _indicesCourseAssignmentSubmissionAttachmentReplicate);
        final TableInfo _existingCourseAssignmentSubmissionAttachmentReplicate = TableInfo.read(_db, "CourseAssignmentSubmissionAttachmentReplicate");
        if (! _infoCourseAssignmentSubmissionAttachmentReplicate.equals(_existingCourseAssignmentSubmissionAttachmentReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseAssignmentSubmissionAttachmentReplicate(com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionAttachmentReplicate).\n"
                  + " Expected:\n" + _infoCourseAssignmentSubmissionAttachmentReplicate + "\n"
                  + " Found:\n" + _existingCourseAssignmentSubmissionAttachmentReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseAssignmentMarkReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsCourseAssignmentMarkReplicate.put("camPk", new TableInfo.Column("camPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentMarkReplicate.put("camVersionId", new TableInfo.Column("camVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentMarkReplicate.put("camDestination", new TableInfo.Column("camDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseAssignmentMarkReplicate.put("camPending", new TableInfo.Column("camPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseAssignmentMarkReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseAssignmentMarkReplicate = new HashSet<TableInfo.Index>(2);
        _indicesCourseAssignmentMarkReplicate.add(new TableInfo.Index("index_CourseAssignmentMarkReplicate_camPk_camDestination_camVersionId", false, Arrays.asList("camPk","camDestination","camVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesCourseAssignmentMarkReplicate.add(new TableInfo.Index("index_CourseAssignmentMarkReplicate_camDestination_camPending", false, Arrays.asList("camDestination","camPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoCourseAssignmentMarkReplicate = new TableInfo("CourseAssignmentMarkReplicate", _columnsCourseAssignmentMarkReplicate, _foreignKeysCourseAssignmentMarkReplicate, _indicesCourseAssignmentMarkReplicate);
        final TableInfo _existingCourseAssignmentMarkReplicate = TableInfo.read(_db, "CourseAssignmentMarkReplicate");
        if (! _infoCourseAssignmentMarkReplicate.equals(_existingCourseAssignmentMarkReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseAssignmentMarkReplicate(com.ustadmobile.lib.db.entities.CourseAssignmentMarkReplicate).\n"
                  + " Expected:\n" + _infoCourseAssignmentMarkReplicate + "\n"
                  + " Found:\n" + _existingCourseAssignmentMarkReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseBlockReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsCourseBlockReplicate.put("cbPk", new TableInfo.Column("cbPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlockReplicate.put("cbVersionId", new TableInfo.Column("cbVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlockReplicate.put("cbDestination", new TableInfo.Column("cbDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseBlockReplicate.put("cbPending", new TableInfo.Column("cbPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseBlockReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseBlockReplicate = new HashSet<TableInfo.Index>(2);
        _indicesCourseBlockReplicate.add(new TableInfo.Index("index_CourseBlockReplicate_cbPk_cbDestination_cbVersionId", false, Arrays.asList("cbPk","cbDestination","cbVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesCourseBlockReplicate.add(new TableInfo.Index("index_CourseBlockReplicate_cbDestination_cbPending", false, Arrays.asList("cbDestination","cbPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoCourseBlockReplicate = new TableInfo("CourseBlockReplicate", _columnsCourseBlockReplicate, _foreignKeysCourseBlockReplicate, _indicesCourseBlockReplicate);
        final TableInfo _existingCourseBlockReplicate = TableInfo.read(_db, "CourseBlockReplicate");
        if (! _infoCourseBlockReplicate.equals(_existingCourseBlockReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseBlockReplicate(com.ustadmobile.lib.db.entities.CourseBlockReplicate).\n"
                  + " Expected:\n" + _infoCourseBlockReplicate + "\n"
                  + " Found:\n" + _existingCourseBlockReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseTerminologyReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsCourseTerminologyReplicate.put("ctPk", new TableInfo.Column("ctPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseTerminologyReplicate.put("ctVersionId", new TableInfo.Column("ctVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseTerminologyReplicate.put("ctDestination", new TableInfo.Column("ctDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseTerminologyReplicate.put("ctPending", new TableInfo.Column("ctPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseTerminologyReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseTerminologyReplicate = new HashSet<TableInfo.Index>(2);
        _indicesCourseTerminologyReplicate.add(new TableInfo.Index("index_CourseTerminologyReplicate_ctPk_ctDestination_ctVersionId", false, Arrays.asList("ctPk","ctDestination","ctVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesCourseTerminologyReplicate.add(new TableInfo.Index("index_CourseTerminologyReplicate_ctDestination_ctPending", false, Arrays.asList("ctDestination","ctPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoCourseTerminologyReplicate = new TableInfo("CourseTerminologyReplicate", _columnsCourseTerminologyReplicate, _foreignKeysCourseTerminologyReplicate, _indicesCourseTerminologyReplicate);
        final TableInfo _existingCourseTerminologyReplicate = TableInfo.read(_db, "CourseTerminologyReplicate");
        if (! _infoCourseTerminologyReplicate.equals(_existingCourseTerminologyReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseTerminologyReplicate(com.ustadmobile.lib.db.entities.CourseTerminologyReplicate).\n"
                  + " Expected:\n" + _infoCourseTerminologyReplicate + "\n"
                  + " Found:\n" + _existingCourseTerminologyReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseGroupSetReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsCourseGroupSetReplicate.put("cgsPk", new TableInfo.Column("cgsPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseGroupSetReplicate.put("cgsVersionId", new TableInfo.Column("cgsVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseGroupSetReplicate.put("cgsDestination", new TableInfo.Column("cgsDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseGroupSetReplicate.put("cgsPending", new TableInfo.Column("cgsPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseGroupSetReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseGroupSetReplicate = new HashSet<TableInfo.Index>(2);
        _indicesCourseGroupSetReplicate.add(new TableInfo.Index("index_CourseGroupSetReplicate_cgsPk_cgsDestination_cgsVersionId", false, Arrays.asList("cgsPk","cgsDestination","cgsVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesCourseGroupSetReplicate.add(new TableInfo.Index("index_CourseGroupSetReplicate_cgsDestination_cgsPending", false, Arrays.asList("cgsDestination","cgsPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoCourseGroupSetReplicate = new TableInfo("CourseGroupSetReplicate", _columnsCourseGroupSetReplicate, _foreignKeysCourseGroupSetReplicate, _indicesCourseGroupSetReplicate);
        final TableInfo _existingCourseGroupSetReplicate = TableInfo.read(_db, "CourseGroupSetReplicate");
        if (! _infoCourseGroupSetReplicate.equals(_existingCourseGroupSetReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseGroupSetReplicate(com.ustadmobile.lib.db.entities.CourseGroupSetReplicate).\n"
                  + " Expected:\n" + _infoCourseGroupSetReplicate + "\n"
                  + " Found:\n" + _existingCourseGroupSetReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseGroupMemberReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsCourseGroupMemberReplicate.put("cgmPk", new TableInfo.Column("cgmPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseGroupMemberReplicate.put("cgmVersionId", new TableInfo.Column("cgmVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseGroupMemberReplicate.put("cgmDestination", new TableInfo.Column("cgmDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseGroupMemberReplicate.put("cgmPending", new TableInfo.Column("cgmPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseGroupMemberReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseGroupMemberReplicate = new HashSet<TableInfo.Index>(2);
        _indicesCourseGroupMemberReplicate.add(new TableInfo.Index("index_CourseGroupMemberReplicate_cgmPk_cgmDestination_cgmVersionId", false, Arrays.asList("cgmPk","cgmDestination","cgmVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesCourseGroupMemberReplicate.add(new TableInfo.Index("index_CourseGroupMemberReplicate_cgmDestination_cgmPending", false, Arrays.asList("cgmDestination","cgmPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoCourseGroupMemberReplicate = new TableInfo("CourseGroupMemberReplicate", _columnsCourseGroupMemberReplicate, _foreignKeysCourseGroupMemberReplicate, _indicesCourseGroupMemberReplicate);
        final TableInfo _existingCourseGroupMemberReplicate = TableInfo.read(_db, "CourseGroupMemberReplicate");
        if (! _infoCourseGroupMemberReplicate.equals(_existingCourseGroupMemberReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseGroupMemberReplicate(com.ustadmobile.lib.db.entities.CourseGroupMemberReplicate).\n"
                  + " Expected:\n" + _infoCourseGroupMemberReplicate + "\n"
                  + " Found:\n" + _existingCourseGroupMemberReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsScheduleReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsScheduleReplicate.put("schedulePk", new TableInfo.Column("schedulePk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScheduleReplicate.put("scheduleVersionId", new TableInfo.Column("scheduleVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsScheduleReplicate.put("scheduleDestination", new TableInfo.Column("scheduleDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScheduleReplicate.put("schedulePending", new TableInfo.Column("schedulePending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysScheduleReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesScheduleReplicate = new HashSet<TableInfo.Index>(2);
        _indicesScheduleReplicate.add(new TableInfo.Index("index_ScheduleReplicate_schedulePk_scheduleDestination_scheduleVersionId", false, Arrays.asList("schedulePk","scheduleDestination","scheduleVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesScheduleReplicate.add(new TableInfo.Index("index_ScheduleReplicate_scheduleDestination_schedulePending", false, Arrays.asList("scheduleDestination","schedulePending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoScheduleReplicate = new TableInfo("ScheduleReplicate", _columnsScheduleReplicate, _foreignKeysScheduleReplicate, _indicesScheduleReplicate);
        final TableInfo _existingScheduleReplicate = TableInfo.read(_db, "ScheduleReplicate");
        if (! _infoScheduleReplicate.equals(_existingScheduleReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ScheduleReplicate(com.ustadmobile.lib.db.entities.ScheduleReplicate).\n"
                  + " Expected:\n" + _infoScheduleReplicate + "\n"
                  + " Found:\n" + _existingScheduleReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsHolidayCalendarReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsHolidayCalendarReplicate.put("hcPk", new TableInfo.Column("hcPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHolidayCalendarReplicate.put("hcVersionId", new TableInfo.Column("hcVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsHolidayCalendarReplicate.put("hcDestination", new TableInfo.Column("hcDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHolidayCalendarReplicate.put("hcPending", new TableInfo.Column("hcPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysHolidayCalendarReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesHolidayCalendarReplicate = new HashSet<TableInfo.Index>(2);
        _indicesHolidayCalendarReplicate.add(new TableInfo.Index("index_HolidayCalendarReplicate_hcPk_hcDestination_hcVersionId", false, Arrays.asList("hcPk","hcDestination","hcVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesHolidayCalendarReplicate.add(new TableInfo.Index("index_HolidayCalendarReplicate_hcDestination_hcPending", false, Arrays.asList("hcDestination","hcPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoHolidayCalendarReplicate = new TableInfo("HolidayCalendarReplicate", _columnsHolidayCalendarReplicate, _foreignKeysHolidayCalendarReplicate, _indicesHolidayCalendarReplicate);
        final TableInfo _existingHolidayCalendarReplicate = TableInfo.read(_db, "HolidayCalendarReplicate");
        if (! _infoHolidayCalendarReplicate.equals(_existingHolidayCalendarReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "HolidayCalendarReplicate(com.ustadmobile.lib.db.entities.HolidayCalendarReplicate).\n"
                  + " Expected:\n" + _infoHolidayCalendarReplicate + "\n"
                  + " Found:\n" + _existingHolidayCalendarReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsHolidayReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsHolidayReplicate.put("holidayPk", new TableInfo.Column("holidayPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHolidayReplicate.put("holidayVersionId", new TableInfo.Column("holidayVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsHolidayReplicate.put("holidayDestination", new TableInfo.Column("holidayDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsHolidayReplicate.put("holidayPending", new TableInfo.Column("holidayPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysHolidayReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesHolidayReplicate = new HashSet<TableInfo.Index>(2);
        _indicesHolidayReplicate.add(new TableInfo.Index("index_HolidayReplicate_holidayPk_holidayDestination_holidayVersionId", false, Arrays.asList("holidayPk","holidayDestination","holidayVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesHolidayReplicate.add(new TableInfo.Index("index_HolidayReplicate_holidayDestination_holidayPending", false, Arrays.asList("holidayDestination","holidayPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoHolidayReplicate = new TableInfo("HolidayReplicate", _columnsHolidayReplicate, _foreignKeysHolidayReplicate, _indicesHolidayReplicate);
        final TableInfo _existingHolidayReplicate = TableInfo.read(_db, "HolidayReplicate");
        if (! _infoHolidayReplicate.equals(_existingHolidayReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "HolidayReplicate(com.ustadmobile.lib.db.entities.HolidayReplicate).\n"
                  + " Expected:\n" + _infoHolidayReplicate + "\n"
                  + " Found:\n" + _existingHolidayReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsPersonReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsPersonReplicate.put("personPk", new TableInfo.Column("personPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonReplicate.put("personVersionId", new TableInfo.Column("personVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonReplicate.put("personDestination", new TableInfo.Column("personDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonReplicate.put("personPending", new TableInfo.Column("personPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPersonReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPersonReplicate = new HashSet<TableInfo.Index>(2);
        _indicesPersonReplicate.add(new TableInfo.Index("index_PersonReplicate_personPk_personDestination_personVersionId", false, Arrays.asList("personPk","personDestination","personVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesPersonReplicate.add(new TableInfo.Index("index_PersonReplicate_personDestination_personPending", false, Arrays.asList("personDestination","personPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoPersonReplicate = new TableInfo("PersonReplicate", _columnsPersonReplicate, _foreignKeysPersonReplicate, _indicesPersonReplicate);
        final TableInfo _existingPersonReplicate = TableInfo.read(_db, "PersonReplicate");
        if (! _infoPersonReplicate.equals(_existingPersonReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "PersonReplicate(com.ustadmobile.lib.db.entities.PersonReplicate).\n"
                  + " Expected:\n" + _infoPersonReplicate + "\n"
                  + " Found:\n" + _existingPersonReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsClazzReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsClazzReplicate.put("clazzPk", new TableInfo.Column("clazzPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzReplicate.put("clazzVersionId", new TableInfo.Column("clazzVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzReplicate.put("clazzDestination", new TableInfo.Column("clazzDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzReplicate.put("clazzPending", new TableInfo.Column("clazzPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysClazzReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesClazzReplicate = new HashSet<TableInfo.Index>(2);
        _indicesClazzReplicate.add(new TableInfo.Index("index_ClazzReplicate_clazzPk_clazzDestination_clazzVersionId", false, Arrays.asList("clazzPk","clazzDestination","clazzVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesClazzReplicate.add(new TableInfo.Index("index_ClazzReplicate_clazzDestination_clazzPending", false, Arrays.asList("clazzDestination","clazzPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoClazzReplicate = new TableInfo("ClazzReplicate", _columnsClazzReplicate, _foreignKeysClazzReplicate, _indicesClazzReplicate);
        final TableInfo _existingClazzReplicate = TableInfo.read(_db, "ClazzReplicate");
        if (! _infoClazzReplicate.equals(_existingClazzReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ClazzReplicate(com.ustadmobile.lib.db.entities.ClazzReplicate).\n"
                  + " Expected:\n" + _infoClazzReplicate + "\n"
                  + " Found:\n" + _existingClazzReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsClazzEnrolmentReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsClazzEnrolmentReplicate.put("cePk", new TableInfo.Column("cePk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolmentReplicate.put("ceVersionId", new TableInfo.Column("ceVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolmentReplicate.put("ceDestination", new TableInfo.Column("ceDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzEnrolmentReplicate.put("cePending", new TableInfo.Column("cePending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysClazzEnrolmentReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesClazzEnrolmentReplicate = new HashSet<TableInfo.Index>(2);
        _indicesClazzEnrolmentReplicate.add(new TableInfo.Index("index_ClazzEnrolmentReplicate_cePk_ceDestination_ceVersionId", false, Arrays.asList("cePk","ceDestination","ceVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesClazzEnrolmentReplicate.add(new TableInfo.Index("index_ClazzEnrolmentReplicate_ceDestination_cePending", false, Arrays.asList("ceDestination","cePending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoClazzEnrolmentReplicate = new TableInfo("ClazzEnrolmentReplicate", _columnsClazzEnrolmentReplicate, _foreignKeysClazzEnrolmentReplicate, _indicesClazzEnrolmentReplicate);
        final TableInfo _existingClazzEnrolmentReplicate = TableInfo.read(_db, "ClazzEnrolmentReplicate");
        if (! _infoClazzEnrolmentReplicate.equals(_existingClazzEnrolmentReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ClazzEnrolmentReplicate(com.ustadmobile.lib.db.entities.ClazzEnrolmentReplicate).\n"
                  + " Expected:\n" + _infoClazzEnrolmentReplicate + "\n"
                  + " Found:\n" + _existingClazzEnrolmentReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsLeavingReasonReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsLeavingReasonReplicate.put("lrPk", new TableInfo.Column("lrPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLeavingReasonReplicate.put("lrVersionId", new TableInfo.Column("lrVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsLeavingReasonReplicate.put("lrDestination", new TableInfo.Column("lrDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLeavingReasonReplicate.put("lrPending", new TableInfo.Column("lrPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysLeavingReasonReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesLeavingReasonReplicate = new HashSet<TableInfo.Index>(2);
        _indicesLeavingReasonReplicate.add(new TableInfo.Index("index_LeavingReasonReplicate_lrPk_lrDestination_lrVersionId", false, Arrays.asList("lrPk","lrDestination","lrVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesLeavingReasonReplicate.add(new TableInfo.Index("index_LeavingReasonReplicate_lrDestination_lrPending", false, Arrays.asList("lrDestination","lrPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoLeavingReasonReplicate = new TableInfo("LeavingReasonReplicate", _columnsLeavingReasonReplicate, _foreignKeysLeavingReasonReplicate, _indicesLeavingReasonReplicate);
        final TableInfo _existingLeavingReasonReplicate = TableInfo.read(_db, "LeavingReasonReplicate");
        if (! _infoLeavingReasonReplicate.equals(_existingLeavingReasonReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "LeavingReasonReplicate(com.ustadmobile.lib.db.entities.LeavingReasonReplicate).\n"
                  + " Expected:\n" + _infoLeavingReasonReplicate + "\n"
                  + " Found:\n" + _existingLeavingReasonReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsContentEntryReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsContentEntryReplicate.put("cePk", new TableInfo.Column("cePk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryReplicate.put("ceVersionId", new TableInfo.Column("ceVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryReplicate.put("ceDestination", new TableInfo.Column("ceDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryReplicate.put("cePending", new TableInfo.Column("cePending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentEntryReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentEntryReplicate = new HashSet<TableInfo.Index>(2);
        _indicesContentEntryReplicate.add(new TableInfo.Index("index_ContentEntryReplicate_cePk_ceDestination_ceVersionId", false, Arrays.asList("cePk","ceDestination","ceVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesContentEntryReplicate.add(new TableInfo.Index("index_ContentEntryReplicate_ceDestination_cePending", false, Arrays.asList("ceDestination","cePending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoContentEntryReplicate = new TableInfo("ContentEntryReplicate", _columnsContentEntryReplicate, _foreignKeysContentEntryReplicate, _indicesContentEntryReplicate);
        final TableInfo _existingContentEntryReplicate = TableInfo.read(_db, "ContentEntryReplicate");
        if (! _infoContentEntryReplicate.equals(_existingContentEntryReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentEntryReplicate(com.ustadmobile.lib.db.entities.ContentEntryReplicate).\n"
                  + " Expected:\n" + _infoContentEntryReplicate + "\n"
                  + " Found:\n" + _existingContentEntryReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsContentEntryContentCategoryJoinReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsContentEntryContentCategoryJoinReplicate.put("ceccjPk", new TableInfo.Column("ceccjPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryContentCategoryJoinReplicate.put("ceccjVersionId", new TableInfo.Column("ceccjVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryContentCategoryJoinReplicate.put("ceccjDestination", new TableInfo.Column("ceccjDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryContentCategoryJoinReplicate.put("ceccjPending", new TableInfo.Column("ceccjPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentEntryContentCategoryJoinReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentEntryContentCategoryJoinReplicate = new HashSet<TableInfo.Index>(2);
        _indicesContentEntryContentCategoryJoinReplicate.add(new TableInfo.Index("index_ContentEntryContentCategoryJoinReplicate_ceccjPk_ceccjDestination_ceccjVersionId", false, Arrays.asList("ceccjPk","ceccjDestination","ceccjVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesContentEntryContentCategoryJoinReplicate.add(new TableInfo.Index("index_ContentEntryContentCategoryJoinReplicate_ceccjDestination_ceccjPending", false, Arrays.asList("ceccjDestination","ceccjPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoContentEntryContentCategoryJoinReplicate = new TableInfo("ContentEntryContentCategoryJoinReplicate", _columnsContentEntryContentCategoryJoinReplicate, _foreignKeysContentEntryContentCategoryJoinReplicate, _indicesContentEntryContentCategoryJoinReplicate);
        final TableInfo _existingContentEntryContentCategoryJoinReplicate = TableInfo.read(_db, "ContentEntryContentCategoryJoinReplicate");
        if (! _infoContentEntryContentCategoryJoinReplicate.equals(_existingContentEntryContentCategoryJoinReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentEntryContentCategoryJoinReplicate(com.ustadmobile.lib.db.entities.ContentEntryContentCategoryJoinReplicate).\n"
                  + " Expected:\n" + _infoContentEntryContentCategoryJoinReplicate + "\n"
                  + " Found:\n" + _existingContentEntryContentCategoryJoinReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsContentEntryParentChildJoinReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsContentEntryParentChildJoinReplicate.put("cepcjPk", new TableInfo.Column("cepcjPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryParentChildJoinReplicate.put("cepcjVersionId", new TableInfo.Column("cepcjVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryParentChildJoinReplicate.put("cepcjDestination", new TableInfo.Column("cepcjDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryParentChildJoinReplicate.put("cepcjPending", new TableInfo.Column("cepcjPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentEntryParentChildJoinReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentEntryParentChildJoinReplicate = new HashSet<TableInfo.Index>(2);
        _indicesContentEntryParentChildJoinReplicate.add(new TableInfo.Index("index_ContentEntryParentChildJoinReplicate_cepcjPk_cepcjDestination_cepcjVersionId", false, Arrays.asList("cepcjPk","cepcjDestination","cepcjVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesContentEntryParentChildJoinReplicate.add(new TableInfo.Index("index_ContentEntryParentChildJoinReplicate_cepcjDestination_cepcjPending", false, Arrays.asList("cepcjDestination","cepcjPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoContentEntryParentChildJoinReplicate = new TableInfo("ContentEntryParentChildJoinReplicate", _columnsContentEntryParentChildJoinReplicate, _foreignKeysContentEntryParentChildJoinReplicate, _indicesContentEntryParentChildJoinReplicate);
        final TableInfo _existingContentEntryParentChildJoinReplicate = TableInfo.read(_db, "ContentEntryParentChildJoinReplicate");
        if (! _infoContentEntryParentChildJoinReplicate.equals(_existingContentEntryParentChildJoinReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentEntryParentChildJoinReplicate(com.ustadmobile.lib.db.entities.ContentEntryParentChildJoinReplicate).\n"
                  + " Expected:\n" + _infoContentEntryParentChildJoinReplicate + "\n"
                  + " Found:\n" + _existingContentEntryParentChildJoinReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsContentEntryRelatedEntryJoinReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsContentEntryRelatedEntryJoinReplicate.put("cerejPk", new TableInfo.Column("cerejPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryRelatedEntryJoinReplicate.put("cerejVersionId", new TableInfo.Column("cerejVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryRelatedEntryJoinReplicate.put("cerejDestination", new TableInfo.Column("cerejDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryRelatedEntryJoinReplicate.put("cerejPending", new TableInfo.Column("cerejPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentEntryRelatedEntryJoinReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentEntryRelatedEntryJoinReplicate = new HashSet<TableInfo.Index>(2);
        _indicesContentEntryRelatedEntryJoinReplicate.add(new TableInfo.Index("index_ContentEntryRelatedEntryJoinReplicate_cerejPk_cerejDestination_cerejVersionId", false, Arrays.asList("cerejPk","cerejDestination","cerejVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesContentEntryRelatedEntryJoinReplicate.add(new TableInfo.Index("index_ContentEntryRelatedEntryJoinReplicate_cerejDestination_cerejPending", false, Arrays.asList("cerejDestination","cerejPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoContentEntryRelatedEntryJoinReplicate = new TableInfo("ContentEntryRelatedEntryJoinReplicate", _columnsContentEntryRelatedEntryJoinReplicate, _foreignKeysContentEntryRelatedEntryJoinReplicate, _indicesContentEntryRelatedEntryJoinReplicate);
        final TableInfo _existingContentEntryRelatedEntryJoinReplicate = TableInfo.read(_db, "ContentEntryRelatedEntryJoinReplicate");
        if (! _infoContentEntryRelatedEntryJoinReplicate.equals(_existingContentEntryRelatedEntryJoinReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentEntryRelatedEntryJoinReplicate(com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoinReplicate).\n"
                  + " Expected:\n" + _infoContentEntryRelatedEntryJoinReplicate + "\n"
                  + " Found:\n" + _existingContentEntryRelatedEntryJoinReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsContentCategorySchemaReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsContentCategorySchemaReplicate.put("ccsPk", new TableInfo.Column("ccsPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategorySchemaReplicate.put("ccsVersionId", new TableInfo.Column("ccsVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategorySchemaReplicate.put("ccsDestination", new TableInfo.Column("ccsDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategorySchemaReplicate.put("ccsPending", new TableInfo.Column("ccsPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentCategorySchemaReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentCategorySchemaReplicate = new HashSet<TableInfo.Index>(2);
        _indicesContentCategorySchemaReplicate.add(new TableInfo.Index("index_ContentCategorySchemaReplicate_ccsPk_ccsDestination_ccsVersionId", false, Arrays.asList("ccsPk","ccsDestination","ccsVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesContentCategorySchemaReplicate.add(new TableInfo.Index("index_ContentCategorySchemaReplicate_ccsDestination_ccsPending", false, Arrays.asList("ccsDestination","ccsPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoContentCategorySchemaReplicate = new TableInfo("ContentCategorySchemaReplicate", _columnsContentCategorySchemaReplicate, _foreignKeysContentCategorySchemaReplicate, _indicesContentCategorySchemaReplicate);
        final TableInfo _existingContentCategorySchemaReplicate = TableInfo.read(_db, "ContentCategorySchemaReplicate");
        if (! _infoContentCategorySchemaReplicate.equals(_existingContentCategorySchemaReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentCategorySchemaReplicate(com.ustadmobile.lib.db.entities.ContentCategorySchemaReplicate).\n"
                  + " Expected:\n" + _infoContentCategorySchemaReplicate + "\n"
                  + " Found:\n" + _existingContentCategorySchemaReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsContentCategoryReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsContentCategoryReplicate.put("ccPk", new TableInfo.Column("ccPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategoryReplicate.put("ccVersionId", new TableInfo.Column("ccVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategoryReplicate.put("ccDestination", new TableInfo.Column("ccDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentCategoryReplicate.put("ccPending", new TableInfo.Column("ccPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentCategoryReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentCategoryReplicate = new HashSet<TableInfo.Index>(2);
        _indicesContentCategoryReplicate.add(new TableInfo.Index("index_ContentCategoryReplicate_ccPk_ccDestination_ccVersionId", false, Arrays.asList("ccPk","ccDestination","ccVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesContentCategoryReplicate.add(new TableInfo.Index("index_ContentCategoryReplicate_ccDestination_ccPending", false, Arrays.asList("ccDestination","ccPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoContentCategoryReplicate = new TableInfo("ContentCategoryReplicate", _columnsContentCategoryReplicate, _foreignKeysContentCategoryReplicate, _indicesContentCategoryReplicate);
        final TableInfo _existingContentCategoryReplicate = TableInfo.read(_db, "ContentCategoryReplicate");
        if (! _infoContentCategoryReplicate.equals(_existingContentCategoryReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentCategoryReplicate(com.ustadmobile.lib.db.entities.ContentCategoryReplicate).\n"
                  + " Expected:\n" + _infoContentCategoryReplicate + "\n"
                  + " Found:\n" + _existingContentCategoryReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsLanguageReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsLanguageReplicate.put("languagePk", new TableInfo.Column("languagePk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguageReplicate.put("languageVersionId", new TableInfo.Column("languageVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguageReplicate.put("languageDestination", new TableInfo.Column("languageDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguageReplicate.put("languagePending", new TableInfo.Column("languagePending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysLanguageReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesLanguageReplicate = new HashSet<TableInfo.Index>(2);
        _indicesLanguageReplicate.add(new TableInfo.Index("index_LanguageReplicate_languagePk_languageDestination_languageVersionId", false, Arrays.asList("languagePk","languageDestination","languageVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesLanguageReplicate.add(new TableInfo.Index("index_LanguageReplicate_languageDestination_languagePending", false, Arrays.asList("languageDestination","languagePending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoLanguageReplicate = new TableInfo("LanguageReplicate", _columnsLanguageReplicate, _foreignKeysLanguageReplicate, _indicesLanguageReplicate);
        final TableInfo _existingLanguageReplicate = TableInfo.read(_db, "LanguageReplicate");
        if (! _infoLanguageReplicate.equals(_existingLanguageReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "LanguageReplicate(com.ustadmobile.lib.db.entities.LanguageReplicate).\n"
                  + " Expected:\n" + _infoLanguageReplicate + "\n"
                  + " Found:\n" + _existingLanguageReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsLanguageVariantReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsLanguageVariantReplicate.put("lvPk", new TableInfo.Column("lvPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguageVariantReplicate.put("lvVersionId", new TableInfo.Column("lvVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguageVariantReplicate.put("lvDestination", new TableInfo.Column("lvDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLanguageVariantReplicate.put("lvPending", new TableInfo.Column("lvPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysLanguageVariantReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesLanguageVariantReplicate = new HashSet<TableInfo.Index>(2);
        _indicesLanguageVariantReplicate.add(new TableInfo.Index("index_LanguageVariantReplicate_lvPk_lvDestination_lvVersionId", false, Arrays.asList("lvPk","lvDestination","lvVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesLanguageVariantReplicate.add(new TableInfo.Index("index_LanguageVariantReplicate_lvDestination_lvPending", false, Arrays.asList("lvDestination","lvPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoLanguageVariantReplicate = new TableInfo("LanguageVariantReplicate", _columnsLanguageVariantReplicate, _foreignKeysLanguageVariantReplicate, _indicesLanguageVariantReplicate);
        final TableInfo _existingLanguageVariantReplicate = TableInfo.read(_db, "LanguageVariantReplicate");
        if (! _infoLanguageVariantReplicate.equals(_existingLanguageVariantReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "LanguageVariantReplicate(com.ustadmobile.lib.db.entities.LanguageVariantReplicate).\n"
                  + " Expected:\n" + _infoLanguageVariantReplicate + "\n"
                  + " Found:\n" + _existingLanguageVariantReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsPersonGroupReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsPersonGroupReplicate.put("pgPk", new TableInfo.Column("pgPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroupReplicate.put("pgVersionId", new TableInfo.Column("pgVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroupReplicate.put("pgDestination", new TableInfo.Column("pgDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroupReplicate.put("pgPending", new TableInfo.Column("pgPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPersonGroupReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPersonGroupReplicate = new HashSet<TableInfo.Index>(2);
        _indicesPersonGroupReplicate.add(new TableInfo.Index("index_PersonGroupReplicate_pgPk_pgDestination_pgVersionId", false, Arrays.asList("pgPk","pgDestination","pgVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesPersonGroupReplicate.add(new TableInfo.Index("index_PersonGroupReplicate_pgDestination_pgPending", false, Arrays.asList("pgDestination","pgPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoPersonGroupReplicate = new TableInfo("PersonGroupReplicate", _columnsPersonGroupReplicate, _foreignKeysPersonGroupReplicate, _indicesPersonGroupReplicate);
        final TableInfo _existingPersonGroupReplicate = TableInfo.read(_db, "PersonGroupReplicate");
        if (! _infoPersonGroupReplicate.equals(_existingPersonGroupReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "PersonGroupReplicate(com.ustadmobile.lib.db.entities.PersonGroupReplicate).\n"
                  + " Expected:\n" + _infoPersonGroupReplicate + "\n"
                  + " Found:\n" + _existingPersonGroupReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsPersonGroupMemberReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsPersonGroupMemberReplicate.put("pgmPk", new TableInfo.Column("pgmPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroupMemberReplicate.put("pgmVersionId", new TableInfo.Column("pgmVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroupMemberReplicate.put("pgmDestination", new TableInfo.Column("pgmDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonGroupMemberReplicate.put("pgmPending", new TableInfo.Column("pgmPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPersonGroupMemberReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPersonGroupMemberReplicate = new HashSet<TableInfo.Index>(2);
        _indicesPersonGroupMemberReplicate.add(new TableInfo.Index("index_PersonGroupMemberReplicate_pgmPk_pgmDestination_pgmVersionId", false, Arrays.asList("pgmPk","pgmDestination","pgmVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesPersonGroupMemberReplicate.add(new TableInfo.Index("index_PersonGroupMemberReplicate_pgmDestination_pgmPending", false, Arrays.asList("pgmDestination","pgmPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoPersonGroupMemberReplicate = new TableInfo("PersonGroupMemberReplicate", _columnsPersonGroupMemberReplicate, _foreignKeysPersonGroupMemberReplicate, _indicesPersonGroupMemberReplicate);
        final TableInfo _existingPersonGroupMemberReplicate = TableInfo.read(_db, "PersonGroupMemberReplicate");
        if (! _infoPersonGroupMemberReplicate.equals(_existingPersonGroupMemberReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "PersonGroupMemberReplicate(com.ustadmobile.lib.db.entities.PersonGroupMemberReplicate).\n"
                  + " Expected:\n" + _infoPersonGroupMemberReplicate + "\n"
                  + " Found:\n" + _existingPersonGroupMemberReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsPersonPictureReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsPersonPictureReplicate.put("ppPk", new TableInfo.Column("ppPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonPictureReplicate.put("ppVersionId", new TableInfo.Column("ppVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonPictureReplicate.put("ppDestination", new TableInfo.Column("ppDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonPictureReplicate.put("ppPending", new TableInfo.Column("ppPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPersonPictureReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPersonPictureReplicate = new HashSet<TableInfo.Index>(2);
        _indicesPersonPictureReplicate.add(new TableInfo.Index("index_PersonPictureReplicate_ppPk_ppDestination_ppVersionId", false, Arrays.asList("ppPk","ppDestination","ppVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesPersonPictureReplicate.add(new TableInfo.Index("index_PersonPictureReplicate_ppDestination_ppPending", false, Arrays.asList("ppDestination","ppPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoPersonPictureReplicate = new TableInfo("PersonPictureReplicate", _columnsPersonPictureReplicate, _foreignKeysPersonPictureReplicate, _indicesPersonPictureReplicate);
        final TableInfo _existingPersonPictureReplicate = TableInfo.read(_db, "PersonPictureReplicate");
        if (! _infoPersonPictureReplicate.equals(_existingPersonPictureReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "PersonPictureReplicate(com.ustadmobile.lib.db.entities.PersonPictureReplicate).\n"
                  + " Expected:\n" + _infoPersonPictureReplicate + "\n"
                  + " Found:\n" + _existingPersonPictureReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsContainerReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsContainerReplicate.put("containerPk", new TableInfo.Column("containerPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerReplicate.put("containerVersionId", new TableInfo.Column("containerVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerReplicate.put("containerDestination", new TableInfo.Column("containerDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContainerReplicate.put("containerPending", new TableInfo.Column("containerPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContainerReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContainerReplicate = new HashSet<TableInfo.Index>(2);
        _indicesContainerReplicate.add(new TableInfo.Index("index_ContainerReplicate_containerPk_containerDestination_containerVersionId", false, Arrays.asList("containerPk","containerDestination","containerVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesContainerReplicate.add(new TableInfo.Index("index_ContainerReplicate_containerDestination_containerPending", false, Arrays.asList("containerDestination","containerPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoContainerReplicate = new TableInfo("ContainerReplicate", _columnsContainerReplicate, _foreignKeysContainerReplicate, _indicesContainerReplicate);
        final TableInfo _existingContainerReplicate = TableInfo.read(_db, "ContainerReplicate");
        if (! _infoContainerReplicate.equals(_existingContainerReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ContainerReplicate(com.ustadmobile.lib.db.entities.ContainerReplicate).\n"
                  + " Expected:\n" + _infoContainerReplicate + "\n"
                  + " Found:\n" + _existingContainerReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsVerbEntityReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsVerbEntityReplicate.put("vePk", new TableInfo.Column("vePk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsVerbEntityReplicate.put("veVersionId", new TableInfo.Column("veVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsVerbEntityReplicate.put("veDestination", new TableInfo.Column("veDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsVerbEntityReplicate.put("vePending", new TableInfo.Column("vePending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysVerbEntityReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesVerbEntityReplicate = new HashSet<TableInfo.Index>(2);
        _indicesVerbEntityReplicate.add(new TableInfo.Index("index_VerbEntityReplicate_vePk_veDestination_veVersionId", false, Arrays.asList("vePk","veDestination","veVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesVerbEntityReplicate.add(new TableInfo.Index("index_VerbEntityReplicate_veDestination_vePending", false, Arrays.asList("veDestination","vePending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoVerbEntityReplicate = new TableInfo("VerbEntityReplicate", _columnsVerbEntityReplicate, _foreignKeysVerbEntityReplicate, _indicesVerbEntityReplicate);
        final TableInfo _existingVerbEntityReplicate = TableInfo.read(_db, "VerbEntityReplicate");
        if (! _infoVerbEntityReplicate.equals(_existingVerbEntityReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "VerbEntityReplicate(com.ustadmobile.lib.db.entities.VerbEntityReplicate).\n"
                  + " Expected:\n" + _infoVerbEntityReplicate + "\n"
                  + " Found:\n" + _existingVerbEntityReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsXObjectEntityReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsXObjectEntityReplicate.put("xoePk", new TableInfo.Column("xoePk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXObjectEntityReplicate.put("xoeVersionId", new TableInfo.Column("xoeVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsXObjectEntityReplicate.put("xoeDestination", new TableInfo.Column("xoeDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXObjectEntityReplicate.put("xoePending", new TableInfo.Column("xoePending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysXObjectEntityReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesXObjectEntityReplicate = new HashSet<TableInfo.Index>(2);
        _indicesXObjectEntityReplicate.add(new TableInfo.Index("index_XObjectEntityReplicate_xoePk_xoeDestination_xoeVersionId", false, Arrays.asList("xoePk","xoeDestination","xoeVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesXObjectEntityReplicate.add(new TableInfo.Index("index_XObjectEntityReplicate_xoeDestination_xoePending", false, Arrays.asList("xoeDestination","xoePending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoXObjectEntityReplicate = new TableInfo("XObjectEntityReplicate", _columnsXObjectEntityReplicate, _foreignKeysXObjectEntityReplicate, _indicesXObjectEntityReplicate);
        final TableInfo _existingXObjectEntityReplicate = TableInfo.read(_db, "XObjectEntityReplicate");
        if (! _infoXObjectEntityReplicate.equals(_existingXObjectEntityReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "XObjectEntityReplicate(com.ustadmobile.lib.db.entities.XObjectEntityReplicate).\n"
                  + " Expected:\n" + _infoXObjectEntityReplicate + "\n"
                  + " Found:\n" + _existingXObjectEntityReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsStatementEntityReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsStatementEntityReplicate.put("sePk", new TableInfo.Column("sePk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntityReplicate.put("seVersionId", new TableInfo.Column("seVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntityReplicate.put("seDestination", new TableInfo.Column("seDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStatementEntityReplicate.put("sePending", new TableInfo.Column("sePending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysStatementEntityReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesStatementEntityReplicate = new HashSet<TableInfo.Index>(2);
        _indicesStatementEntityReplicate.add(new TableInfo.Index("index_StatementEntityReplicate_sePk_seDestination_seVersionId", false, Arrays.asList("sePk","seDestination","seVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesStatementEntityReplicate.add(new TableInfo.Index("index_StatementEntityReplicate_seDestination_sePending", false, Arrays.asList("seDestination","sePending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoStatementEntityReplicate = new TableInfo("StatementEntityReplicate", _columnsStatementEntityReplicate, _foreignKeysStatementEntityReplicate, _indicesStatementEntityReplicate);
        final TableInfo _existingStatementEntityReplicate = TableInfo.read(_db, "StatementEntityReplicate");
        if (! _infoStatementEntityReplicate.equals(_existingStatementEntityReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "StatementEntityReplicate(com.ustadmobile.lib.db.entities.StatementEntityReplicate).\n"
                  + " Expected:\n" + _infoStatementEntityReplicate + "\n"
                  + " Found:\n" + _existingStatementEntityReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsContextXObjectStatementJoinReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsContextXObjectStatementJoinReplicate.put("cxosjPk", new TableInfo.Column("cxosjPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContextXObjectStatementJoinReplicate.put("cxosjVersionId", new TableInfo.Column("cxosjVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsContextXObjectStatementJoinReplicate.put("cxosjDestination", new TableInfo.Column("cxosjDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContextXObjectStatementJoinReplicate.put("cxosjPending", new TableInfo.Column("cxosjPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContextXObjectStatementJoinReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContextXObjectStatementJoinReplicate = new HashSet<TableInfo.Index>(2);
        _indicesContextXObjectStatementJoinReplicate.add(new TableInfo.Index("index_ContextXObjectStatementJoinReplicate_cxosjPk_cxosjDestination_cxosjVersionId", false, Arrays.asList("cxosjPk","cxosjDestination","cxosjVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesContextXObjectStatementJoinReplicate.add(new TableInfo.Index("index_ContextXObjectStatementJoinReplicate_cxosjDestination_cxosjPending", false, Arrays.asList("cxosjDestination","cxosjPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoContextXObjectStatementJoinReplicate = new TableInfo("ContextXObjectStatementJoinReplicate", _columnsContextXObjectStatementJoinReplicate, _foreignKeysContextXObjectStatementJoinReplicate, _indicesContextXObjectStatementJoinReplicate);
        final TableInfo _existingContextXObjectStatementJoinReplicate = TableInfo.read(_db, "ContextXObjectStatementJoinReplicate");
        if (! _infoContextXObjectStatementJoinReplicate.equals(_existingContextXObjectStatementJoinReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ContextXObjectStatementJoinReplicate(com.ustadmobile.lib.db.entities.ContextXObjectStatementJoinReplicate).\n"
                  + " Expected:\n" + _infoContextXObjectStatementJoinReplicate + "\n"
                  + " Found:\n" + _existingContextXObjectStatementJoinReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsAgentEntityReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsAgentEntityReplicate.put("aePk", new TableInfo.Column("aePk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAgentEntityReplicate.put("aeVersionId", new TableInfo.Column("aeVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsAgentEntityReplicate.put("aeDestination", new TableInfo.Column("aeDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsAgentEntityReplicate.put("aePending", new TableInfo.Column("aePending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysAgentEntityReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesAgentEntityReplicate = new HashSet<TableInfo.Index>(2);
        _indicesAgentEntityReplicate.add(new TableInfo.Index("index_AgentEntityReplicate_aePk_aeDestination_aeVersionId", false, Arrays.asList("aePk","aeDestination","aeVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesAgentEntityReplicate.add(new TableInfo.Index("index_AgentEntityReplicate_aeDestination_aePending", false, Arrays.asList("aeDestination","aePending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoAgentEntityReplicate = new TableInfo("AgentEntityReplicate", _columnsAgentEntityReplicate, _foreignKeysAgentEntityReplicate, _indicesAgentEntityReplicate);
        final TableInfo _existingAgentEntityReplicate = TableInfo.read(_db, "AgentEntityReplicate");
        if (! _infoAgentEntityReplicate.equals(_existingAgentEntityReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "AgentEntityReplicate(com.ustadmobile.lib.db.entities.AgentEntityReplicate).\n"
                  + " Expected:\n" + _infoAgentEntityReplicate + "\n"
                  + " Found:\n" + _existingAgentEntityReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsStateEntityReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsStateEntityReplicate.put("sePk", new TableInfo.Column("sePk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateEntityReplicate.put("seVersionId", new TableInfo.Column("seVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsStateEntityReplicate.put("seDestination", new TableInfo.Column("seDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateEntityReplicate.put("sePending", new TableInfo.Column("sePending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysStateEntityReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesStateEntityReplicate = new HashSet<TableInfo.Index>(2);
        _indicesStateEntityReplicate.add(new TableInfo.Index("index_StateEntityReplicate_sePk_seDestination_seVersionId", false, Arrays.asList("sePk","seDestination","seVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesStateEntityReplicate.add(new TableInfo.Index("index_StateEntityReplicate_seDestination_sePending", false, Arrays.asList("seDestination","sePending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoStateEntityReplicate = new TableInfo("StateEntityReplicate", _columnsStateEntityReplicate, _foreignKeysStateEntityReplicate, _indicesStateEntityReplicate);
        final TableInfo _existingStateEntityReplicate = TableInfo.read(_db, "StateEntityReplicate");
        if (! _infoStateEntityReplicate.equals(_existingStateEntityReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "StateEntityReplicate(com.ustadmobile.lib.db.entities.StateEntityReplicate).\n"
                  + " Expected:\n" + _infoStateEntityReplicate + "\n"
                  + " Found:\n" + _existingStateEntityReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsStateContentEntityReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsStateContentEntityReplicate.put("scePk", new TableInfo.Column("scePk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateContentEntityReplicate.put("sceVersionId", new TableInfo.Column("sceVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsStateContentEntityReplicate.put("sceDestination", new TableInfo.Column("sceDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsStateContentEntityReplicate.put("scePending", new TableInfo.Column("scePending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysStateContentEntityReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesStateContentEntityReplicate = new HashSet<TableInfo.Index>(2);
        _indicesStateContentEntityReplicate.add(new TableInfo.Index("index_StateContentEntityReplicate_scePk_sceDestination_sceVersionId", false, Arrays.asList("scePk","sceDestination","sceVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesStateContentEntityReplicate.add(new TableInfo.Index("index_StateContentEntityReplicate_sceDestination_scePending", false, Arrays.asList("sceDestination","scePending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoStateContentEntityReplicate = new TableInfo("StateContentEntityReplicate", _columnsStateContentEntityReplicate, _foreignKeysStateContentEntityReplicate, _indicesStateContentEntityReplicate);
        final TableInfo _existingStateContentEntityReplicate = TableInfo.read(_db, "StateContentEntityReplicate");
        if (! _infoStateContentEntityReplicate.equals(_existingStateContentEntityReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "StateContentEntityReplicate(com.ustadmobile.lib.db.entities.StateContentEntityReplicate).\n"
                  + " Expected:\n" + _infoStateContentEntityReplicate + "\n"
                  + " Found:\n" + _existingStateContentEntityReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsXLangMapEntryReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsXLangMapEntryReplicate.put("xlmePk", new TableInfo.Column("xlmePk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXLangMapEntryReplicate.put("xlmeVersionId", new TableInfo.Column("xlmeVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsXLangMapEntryReplicate.put("xlmeDestination", new TableInfo.Column("xlmeDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsXLangMapEntryReplicate.put("xlmePending", new TableInfo.Column("xlmePending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysXLangMapEntryReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesXLangMapEntryReplicate = new HashSet<TableInfo.Index>(2);
        _indicesXLangMapEntryReplicate.add(new TableInfo.Index("index_XLangMapEntryReplicate_xlmePk_xlmeDestination_xlmeVersionId", false, Arrays.asList("xlmePk","xlmeDestination","xlmeVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesXLangMapEntryReplicate.add(new TableInfo.Index("index_XLangMapEntryReplicate_xlmeDestination_xlmePending", false, Arrays.asList("xlmeDestination","xlmePending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoXLangMapEntryReplicate = new TableInfo("XLangMapEntryReplicate", _columnsXLangMapEntryReplicate, _foreignKeysXLangMapEntryReplicate, _indicesXLangMapEntryReplicate);
        final TableInfo _existingXLangMapEntryReplicate = TableInfo.read(_db, "XLangMapEntryReplicate");
        if (! _infoXLangMapEntryReplicate.equals(_existingXLangMapEntryReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "XLangMapEntryReplicate(com.ustadmobile.lib.db.entities.XLangMapEntryReplicate).\n"
                  + " Expected:\n" + _infoXLangMapEntryReplicate + "\n"
                  + " Found:\n" + _existingXLangMapEntryReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsSchoolReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsSchoolReplicate.put("schoolPk", new TableInfo.Column("schoolPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolReplicate.put("schoolVersionId", new TableInfo.Column("schoolVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolReplicate.put("schoolDestination", new TableInfo.Column("schoolDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolReplicate.put("schoolPending", new TableInfo.Column("schoolPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysSchoolReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesSchoolReplicate = new HashSet<TableInfo.Index>(2);
        _indicesSchoolReplicate.add(new TableInfo.Index("index_SchoolReplicate_schoolPk_schoolDestination_schoolVersionId", false, Arrays.asList("schoolPk","schoolDestination","schoolVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesSchoolReplicate.add(new TableInfo.Index("index_SchoolReplicate_schoolDestination_schoolPending", false, Arrays.asList("schoolDestination","schoolPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoSchoolReplicate = new TableInfo("SchoolReplicate", _columnsSchoolReplicate, _foreignKeysSchoolReplicate, _indicesSchoolReplicate);
        final TableInfo _existingSchoolReplicate = TableInfo.read(_db, "SchoolReplicate");
        if (! _infoSchoolReplicate.equals(_existingSchoolReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "SchoolReplicate(com.ustadmobile.lib.db.entities.SchoolReplicate).\n"
                  + " Expected:\n" + _infoSchoolReplicate + "\n"
                  + " Found:\n" + _existingSchoolReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsSchoolMemberReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsSchoolMemberReplicate.put("smPk", new TableInfo.Column("smPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolMemberReplicate.put("smVersionId", new TableInfo.Column("smVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolMemberReplicate.put("smDestination", new TableInfo.Column("smDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSchoolMemberReplicate.put("smPending", new TableInfo.Column("smPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysSchoolMemberReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesSchoolMemberReplicate = new HashSet<TableInfo.Index>(2);
        _indicesSchoolMemberReplicate.add(new TableInfo.Index("index_SchoolMemberReplicate_smPk_smDestination_smVersionId", false, Arrays.asList("smPk","smDestination","smVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesSchoolMemberReplicate.add(new TableInfo.Index("index_SchoolMemberReplicate_smDestination_smPending", false, Arrays.asList("smDestination","smPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoSchoolMemberReplicate = new TableInfo("SchoolMemberReplicate", _columnsSchoolMemberReplicate, _foreignKeysSchoolMemberReplicate, _indicesSchoolMemberReplicate);
        final TableInfo _existingSchoolMemberReplicate = TableInfo.read(_db, "SchoolMemberReplicate");
        if (! _infoSchoolMemberReplicate.equals(_existingSchoolMemberReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "SchoolMemberReplicate(com.ustadmobile.lib.db.entities.SchoolMemberReplicate).\n"
                  + " Expected:\n" + _infoSchoolMemberReplicate + "\n"
                  + " Found:\n" + _existingSchoolMemberReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsCommentsReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsCommentsReplicate.put("commentsPk", new TableInfo.Column("commentsPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCommentsReplicate.put("commentsVersionId", new TableInfo.Column("commentsVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsCommentsReplicate.put("commentsDestination", new TableInfo.Column("commentsDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCommentsReplicate.put("commentsPending", new TableInfo.Column("commentsPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCommentsReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCommentsReplicate = new HashSet<TableInfo.Index>(2);
        _indicesCommentsReplicate.add(new TableInfo.Index("index_CommentsReplicate_commentsPk_commentsDestination_commentsVersionId", false, Arrays.asList("commentsPk","commentsDestination","commentsVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesCommentsReplicate.add(new TableInfo.Index("index_CommentsReplicate_commentsDestination_commentsPending", false, Arrays.asList("commentsDestination","commentsPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoCommentsReplicate = new TableInfo("CommentsReplicate", _columnsCommentsReplicate, _foreignKeysCommentsReplicate, _indicesCommentsReplicate);
        final TableInfo _existingCommentsReplicate = TableInfo.read(_db, "CommentsReplicate");
        if (! _infoCommentsReplicate.equals(_existingCommentsReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "CommentsReplicate(com.ustadmobile.lib.db.entities.CommentsReplicate).\n"
                  + " Expected:\n" + _infoCommentsReplicate + "\n"
                  + " Found:\n" + _existingCommentsReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsReportReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsReportReplicate.put("reportPk", new TableInfo.Column("reportPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReportReplicate.put("reportVersionId", new TableInfo.Column("reportVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsReportReplicate.put("reportDestination", new TableInfo.Column("reportDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsReportReplicate.put("reportPending", new TableInfo.Column("reportPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysReportReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesReportReplicate = new HashSet<TableInfo.Index>(2);
        _indicesReportReplicate.add(new TableInfo.Index("index_ReportReplicate_reportPk_reportDestination_reportVersionId", false, Arrays.asList("reportPk","reportDestination","reportVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesReportReplicate.add(new TableInfo.Index("index_ReportReplicate_reportDestination_reportPending", false, Arrays.asList("reportDestination","reportPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoReportReplicate = new TableInfo("ReportReplicate", _columnsReportReplicate, _foreignKeysReportReplicate, _indicesReportReplicate);
        final TableInfo _existingReportReplicate = TableInfo.read(_db, "ReportReplicate");
        if (! _infoReportReplicate.equals(_existingReportReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ReportReplicate(com.ustadmobile.lib.db.entities.ReportReplicate).\n"
                  + " Expected:\n" + _infoReportReplicate + "\n"
                  + " Found:\n" + _existingReportReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsSiteReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsSiteReplicate.put("sitePk", new TableInfo.Column("sitePk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSiteReplicate.put("siteVersionId", new TableInfo.Column("siteVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsSiteReplicate.put("siteDestination", new TableInfo.Column("siteDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSiteReplicate.put("sitePending", new TableInfo.Column("sitePending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysSiteReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesSiteReplicate = new HashSet<TableInfo.Index>(2);
        _indicesSiteReplicate.add(new TableInfo.Index("index_SiteReplicate_sitePk_siteDestination_siteVersionId", false, Arrays.asList("sitePk","siteDestination","siteVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesSiteReplicate.add(new TableInfo.Index("index_SiteReplicate_siteDestination_sitePending", false, Arrays.asList("siteDestination","sitePending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoSiteReplicate = new TableInfo("SiteReplicate", _columnsSiteReplicate, _foreignKeysSiteReplicate, _indicesSiteReplicate);
        final TableInfo _existingSiteReplicate = TableInfo.read(_db, "SiteReplicate");
        if (! _infoSiteReplicate.equals(_existingSiteReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "SiteReplicate(com.ustadmobile.lib.db.entities.SiteReplicate).\n"
                  + " Expected:\n" + _infoSiteReplicate + "\n"
                  + " Found:\n" + _existingSiteReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsLearnerGroupReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsLearnerGroupReplicate.put("lgPk", new TableInfo.Column("lgPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroupReplicate.put("lgVersionId", new TableInfo.Column("lgVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroupReplicate.put("lgDestination", new TableInfo.Column("lgDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroupReplicate.put("lgPending", new TableInfo.Column("lgPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysLearnerGroupReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesLearnerGroupReplicate = new HashSet<TableInfo.Index>(2);
        _indicesLearnerGroupReplicate.add(new TableInfo.Index("index_LearnerGroupReplicate_lgPk_lgDestination_lgVersionId", false, Arrays.asList("lgPk","lgDestination","lgVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesLearnerGroupReplicate.add(new TableInfo.Index("index_LearnerGroupReplicate_lgDestination_lgPending", false, Arrays.asList("lgDestination","lgPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoLearnerGroupReplicate = new TableInfo("LearnerGroupReplicate", _columnsLearnerGroupReplicate, _foreignKeysLearnerGroupReplicate, _indicesLearnerGroupReplicate);
        final TableInfo _existingLearnerGroupReplicate = TableInfo.read(_db, "LearnerGroupReplicate");
        if (! _infoLearnerGroupReplicate.equals(_existingLearnerGroupReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "LearnerGroupReplicate(com.ustadmobile.lib.db.entities.LearnerGroupReplicate).\n"
                  + " Expected:\n" + _infoLearnerGroupReplicate + "\n"
                  + " Found:\n" + _existingLearnerGroupReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsLearnerGroupMemberReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsLearnerGroupMemberReplicate.put("lgmPk", new TableInfo.Column("lgmPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroupMemberReplicate.put("lgmVersionId", new TableInfo.Column("lgmVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroupMemberReplicate.put("lgmDestination", new TableInfo.Column("lgmDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsLearnerGroupMemberReplicate.put("lgmPending", new TableInfo.Column("lgmPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysLearnerGroupMemberReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesLearnerGroupMemberReplicate = new HashSet<TableInfo.Index>(2);
        _indicesLearnerGroupMemberReplicate.add(new TableInfo.Index("index_LearnerGroupMemberReplicate_lgmPk_lgmDestination_lgmVersionId", false, Arrays.asList("lgmPk","lgmDestination","lgmVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesLearnerGroupMemberReplicate.add(new TableInfo.Index("index_LearnerGroupMemberReplicate_lgmDestination_lgmPending", false, Arrays.asList("lgmDestination","lgmPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoLearnerGroupMemberReplicate = new TableInfo("LearnerGroupMemberReplicate", _columnsLearnerGroupMemberReplicate, _foreignKeysLearnerGroupMemberReplicate, _indicesLearnerGroupMemberReplicate);
        final TableInfo _existingLearnerGroupMemberReplicate = TableInfo.read(_db, "LearnerGroupMemberReplicate");
        if (! _infoLearnerGroupMemberReplicate.equals(_existingLearnerGroupMemberReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "LearnerGroupMemberReplicate(com.ustadmobile.lib.db.entities.LearnerGroupMemberReplicate).\n"
                  + " Expected:\n" + _infoLearnerGroupMemberReplicate + "\n"
                  + " Found:\n" + _existingLearnerGroupMemberReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsGroupLearningSessionReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsGroupLearningSessionReplicate.put("glsPk", new TableInfo.Column("glsPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsGroupLearningSessionReplicate.put("glsVersionId", new TableInfo.Column("glsVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsGroupLearningSessionReplicate.put("glsDestination", new TableInfo.Column("glsDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsGroupLearningSessionReplicate.put("glsPending", new TableInfo.Column("glsPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysGroupLearningSessionReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesGroupLearningSessionReplicate = new HashSet<TableInfo.Index>(2);
        _indicesGroupLearningSessionReplicate.add(new TableInfo.Index("index_GroupLearningSessionReplicate_glsPk_glsDestination_glsVersionId", false, Arrays.asList("glsPk","glsDestination","glsVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesGroupLearningSessionReplicate.add(new TableInfo.Index("index_GroupLearningSessionReplicate_glsDestination_glsPending", false, Arrays.asList("glsDestination","glsPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoGroupLearningSessionReplicate = new TableInfo("GroupLearningSessionReplicate", _columnsGroupLearningSessionReplicate, _foreignKeysGroupLearningSessionReplicate, _indicesGroupLearningSessionReplicate);
        final TableInfo _existingGroupLearningSessionReplicate = TableInfo.read(_db, "GroupLearningSessionReplicate");
        if (! _infoGroupLearningSessionReplicate.equals(_existingGroupLearningSessionReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "GroupLearningSessionReplicate(com.ustadmobile.lib.db.entities.GroupLearningSessionReplicate).\n"
                  + " Expected:\n" + _infoGroupLearningSessionReplicate + "\n"
                  + " Found:\n" + _existingGroupLearningSessionReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsSiteTermsReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsSiteTermsReplicate.put("stPk", new TableInfo.Column("stPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSiteTermsReplicate.put("stVersionId", new TableInfo.Column("stVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsSiteTermsReplicate.put("stDestination", new TableInfo.Column("stDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsSiteTermsReplicate.put("stPending", new TableInfo.Column("stPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysSiteTermsReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesSiteTermsReplicate = new HashSet<TableInfo.Index>(2);
        _indicesSiteTermsReplicate.add(new TableInfo.Index("index_SiteTermsReplicate_stPk_stDestination_stVersionId", false, Arrays.asList("stPk","stDestination","stVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesSiteTermsReplicate.add(new TableInfo.Index("index_SiteTermsReplicate_stDestination_stPending", false, Arrays.asList("stDestination","stPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoSiteTermsReplicate = new TableInfo("SiteTermsReplicate", _columnsSiteTermsReplicate, _foreignKeysSiteTermsReplicate, _indicesSiteTermsReplicate);
        final TableInfo _existingSiteTermsReplicate = TableInfo.read(_db, "SiteTermsReplicate");
        if (! _infoSiteTermsReplicate.equals(_existingSiteTermsReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "SiteTermsReplicate(com.ustadmobile.lib.db.entities.SiteTermsReplicate).\n"
                  + " Expected:\n" + _infoSiteTermsReplicate + "\n"
                  + " Found:\n" + _existingSiteTermsReplicate);
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }

      private RoomOpenHelper.ValidationResult onValidateSchema3(SupportSQLiteDatabase _db) {
        final HashMap<String, TableInfo.Column> _columnsClazzContentJoinReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsClazzContentJoinReplicate.put("ccjPk", new TableInfo.Column("ccjPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzContentJoinReplicate.put("ccjVersionId", new TableInfo.Column("ccjVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzContentJoinReplicate.put("ccjDestination", new TableInfo.Column("ccjDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzContentJoinReplicate.put("ccjPending", new TableInfo.Column("ccjPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysClazzContentJoinReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesClazzContentJoinReplicate = new HashSet<TableInfo.Index>(2);
        _indicesClazzContentJoinReplicate.add(new TableInfo.Index("index_ClazzContentJoinReplicate_ccjPk_ccjDestination_ccjVersionId", false, Arrays.asList("ccjPk","ccjDestination","ccjVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesClazzContentJoinReplicate.add(new TableInfo.Index("index_ClazzContentJoinReplicate_ccjDestination_ccjPending", false, Arrays.asList("ccjDestination","ccjPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoClazzContentJoinReplicate = new TableInfo("ClazzContentJoinReplicate", _columnsClazzContentJoinReplicate, _foreignKeysClazzContentJoinReplicate, _indicesClazzContentJoinReplicate);
        final TableInfo _existingClazzContentJoinReplicate = TableInfo.read(_db, "ClazzContentJoinReplicate");
        if (! _infoClazzContentJoinReplicate.equals(_existingClazzContentJoinReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ClazzContentJoinReplicate(com.ustadmobile.lib.db.entities.ClazzContentJoinReplicate).\n"
                  + " Expected:\n" + _infoClazzContentJoinReplicate + "\n"
                  + " Found:\n" + _existingClazzContentJoinReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsPersonParentJoinReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsPersonParentJoinReplicate.put("ppjPk", new TableInfo.Column("ppjPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoinReplicate.put("ppjVersionId", new TableInfo.Column("ppjVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoinReplicate.put("ppjDestination", new TableInfo.Column("ppjDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonParentJoinReplicate.put("ppjPending", new TableInfo.Column("ppjPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPersonParentJoinReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPersonParentJoinReplicate = new HashSet<TableInfo.Index>(2);
        _indicesPersonParentJoinReplicate.add(new TableInfo.Index("index_PersonParentJoinReplicate_ppjPk_ppjDestination_ppjVersionId", false, Arrays.asList("ppjPk","ppjDestination","ppjVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesPersonParentJoinReplicate.add(new TableInfo.Index("index_PersonParentJoinReplicate_ppjDestination_ppjPending", false, Arrays.asList("ppjDestination","ppjPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoPersonParentJoinReplicate = new TableInfo("PersonParentJoinReplicate", _columnsPersonParentJoinReplicate, _foreignKeysPersonParentJoinReplicate, _indicesPersonParentJoinReplicate);
        final TableInfo _existingPersonParentJoinReplicate = TableInfo.read(_db, "PersonParentJoinReplicate");
        if (! _infoPersonParentJoinReplicate.equals(_existingPersonParentJoinReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "PersonParentJoinReplicate(com.ustadmobile.lib.db.entities.PersonParentJoinReplicate).\n"
                  + " Expected:\n" + _infoPersonParentJoinReplicate + "\n"
                  + " Found:\n" + _existingPersonParentJoinReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsScopedGrantReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsScopedGrantReplicate.put("sgPk", new TableInfo.Column("sgPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScopedGrantReplicate.put("sgVersionId", new TableInfo.Column("sgVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsScopedGrantReplicate.put("sgDestination", new TableInfo.Column("sgDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsScopedGrantReplicate.put("sgPending", new TableInfo.Column("sgPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysScopedGrantReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesScopedGrantReplicate = new HashSet<TableInfo.Index>(2);
        _indicesScopedGrantReplicate.add(new TableInfo.Index("index_ScopedGrantReplicate_sgPk_sgDestination_sgVersionId", false, Arrays.asList("sgPk","sgDestination","sgVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesScopedGrantReplicate.add(new TableInfo.Index("index_ScopedGrantReplicate_sgDestination_sgPending", false, Arrays.asList("sgDestination","sgPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoScopedGrantReplicate = new TableInfo("ScopedGrantReplicate", _columnsScopedGrantReplicate, _foreignKeysScopedGrantReplicate, _indicesScopedGrantReplicate);
        final TableInfo _existingScopedGrantReplicate = TableInfo.read(_db, "ScopedGrantReplicate");
        if (! _infoScopedGrantReplicate.equals(_existingScopedGrantReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ScopedGrantReplicate(com.ustadmobile.lib.db.entities.ScopedGrantReplicate).\n"
                  + " Expected:\n" + _infoScopedGrantReplicate + "\n"
                  + " Found:\n" + _existingScopedGrantReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsErrorReportReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsErrorReportReplicate.put("erPk", new TableInfo.Column("erPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReportReplicate.put("erVersionId", new TableInfo.Column("erVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReportReplicate.put("erDestination", new TableInfo.Column("erDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsErrorReportReplicate.put("erPending", new TableInfo.Column("erPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysErrorReportReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesErrorReportReplicate = new HashSet<TableInfo.Index>(2);
        _indicesErrorReportReplicate.add(new TableInfo.Index("index_ErrorReportReplicate_erPk_erDestination_erVersionId", false, Arrays.asList("erPk","erDestination","erVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesErrorReportReplicate.add(new TableInfo.Index("index_ErrorReportReplicate_erDestination_erPending", false, Arrays.asList("erDestination","erPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoErrorReportReplicate = new TableInfo("ErrorReportReplicate", _columnsErrorReportReplicate, _foreignKeysErrorReportReplicate, _indicesErrorReportReplicate);
        final TableInfo _existingErrorReportReplicate = TableInfo.read(_db, "ErrorReportReplicate");
        if (! _infoErrorReportReplicate.equals(_existingErrorReportReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ErrorReportReplicate(com.ustadmobile.lib.db.entities.ErrorReportReplicate).\n"
                  + " Expected:\n" + _infoErrorReportReplicate + "\n"
                  + " Found:\n" + _existingErrorReportReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsClazzAssignmentReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsClazzAssignmentReplicate.put("caPk", new TableInfo.Column("caPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentReplicate.put("caVersionId", new TableInfo.Column("caVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentReplicate.put("caDestination", new TableInfo.Column("caDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentReplicate.put("caPending", new TableInfo.Column("caPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysClazzAssignmentReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesClazzAssignmentReplicate = new HashSet<TableInfo.Index>(2);
        _indicesClazzAssignmentReplicate.add(new TableInfo.Index("index_ClazzAssignmentReplicate_caPk_caDestination_caVersionId", false, Arrays.asList("caPk","caDestination","caVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesClazzAssignmentReplicate.add(new TableInfo.Index("index_ClazzAssignmentReplicate_caDestination_caPending", false, Arrays.asList("caDestination","caPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoClazzAssignmentReplicate = new TableInfo("ClazzAssignmentReplicate", _columnsClazzAssignmentReplicate, _foreignKeysClazzAssignmentReplicate, _indicesClazzAssignmentReplicate);
        final TableInfo _existingClazzAssignmentReplicate = TableInfo.read(_db, "ClazzAssignmentReplicate");
        if (! _infoClazzAssignmentReplicate.equals(_existingClazzAssignmentReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ClazzAssignmentReplicate(com.ustadmobile.lib.db.entities.ClazzAssignmentReplicate).\n"
                  + " Expected:\n" + _infoClazzAssignmentReplicate + "\n"
                  + " Found:\n" + _existingClazzAssignmentReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsClazzAssignmentContentJoinReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsClazzAssignmentContentJoinReplicate.put("cacjPk", new TableInfo.Column("cacjPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentContentJoinReplicate.put("cacjVersionId", new TableInfo.Column("cacjVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentContentJoinReplicate.put("cacjDestination", new TableInfo.Column("cacjDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsClazzAssignmentContentJoinReplicate.put("cacjPending", new TableInfo.Column("cacjPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysClazzAssignmentContentJoinReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesClazzAssignmentContentJoinReplicate = new HashSet<TableInfo.Index>(2);
        _indicesClazzAssignmentContentJoinReplicate.add(new TableInfo.Index("index_ClazzAssignmentContentJoinReplicate_cacjPk_cacjDestination_cacjVersionId", false, Arrays.asList("cacjPk","cacjDestination","cacjVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesClazzAssignmentContentJoinReplicate.add(new TableInfo.Index("index_ClazzAssignmentContentJoinReplicate_cacjDestination_cacjPending", false, Arrays.asList("cacjDestination","cacjPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoClazzAssignmentContentJoinReplicate = new TableInfo("ClazzAssignmentContentJoinReplicate", _columnsClazzAssignmentContentJoinReplicate, _foreignKeysClazzAssignmentContentJoinReplicate, _indicesClazzAssignmentContentJoinReplicate);
        final TableInfo _existingClazzAssignmentContentJoinReplicate = TableInfo.read(_db, "ClazzAssignmentContentJoinReplicate");
        if (! _infoClazzAssignmentContentJoinReplicate.equals(_existingClazzAssignmentContentJoinReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ClazzAssignmentContentJoinReplicate(com.ustadmobile.lib.db.entities.ClazzAssignmentContentJoinReplicate).\n"
                  + " Expected:\n" + _infoClazzAssignmentContentJoinReplicate + "\n"
                  + " Found:\n" + _existingClazzAssignmentContentJoinReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsPersonAuth2Replicate = new HashMap<String, TableInfo.Column>(4);
        _columnsPersonAuth2Replicate.put("paPk", new TableInfo.Column("paPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonAuth2Replicate.put("paVersionId", new TableInfo.Column("paVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonAuth2Replicate.put("paDestination", new TableInfo.Column("paDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPersonAuth2Replicate.put("paPending", new TableInfo.Column("paPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPersonAuth2Replicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPersonAuth2Replicate = new HashSet<TableInfo.Index>(2);
        _indicesPersonAuth2Replicate.add(new TableInfo.Index("index_PersonAuth2Replicate_paPk_paDestination_paVersionId", false, Arrays.asList("paPk","paDestination","paVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesPersonAuth2Replicate.add(new TableInfo.Index("index_PersonAuth2Replicate_paDestination_paPending", false, Arrays.asList("paDestination","paPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoPersonAuth2Replicate = new TableInfo("PersonAuth2Replicate", _columnsPersonAuth2Replicate, _foreignKeysPersonAuth2Replicate, _indicesPersonAuth2Replicate);
        final TableInfo _existingPersonAuth2Replicate = TableInfo.read(_db, "PersonAuth2Replicate");
        if (! _infoPersonAuth2Replicate.equals(_existingPersonAuth2Replicate)) {
          return new RoomOpenHelper.ValidationResult(false, "PersonAuth2Replicate(com.ustadmobile.lib.db.entities.PersonAuth2Replicate).\n"
                  + " Expected:\n" + _infoPersonAuth2Replicate + "\n"
                  + " Found:\n" + _existingPersonAuth2Replicate);
        }
        final HashMap<String, TableInfo.Column> _columnsUserSessionReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsUserSessionReplicate.put("usPk", new TableInfo.Column("usPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSessionReplicate.put("usVersionId", new TableInfo.Column("usVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSessionReplicate.put("usDestination", new TableInfo.Column("usDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsUserSessionReplicate.put("usPending", new TableInfo.Column("usPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysUserSessionReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesUserSessionReplicate = new HashSet<TableInfo.Index>(2);
        _indicesUserSessionReplicate.add(new TableInfo.Index("index_UserSessionReplicate_usPk_usDestination_usVersionId", false, Arrays.asList("usPk","usDestination","usVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesUserSessionReplicate.add(new TableInfo.Index("index_UserSessionReplicate_usDestination_usPending", false, Arrays.asList("usDestination","usPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoUserSessionReplicate = new TableInfo("UserSessionReplicate", _columnsUserSessionReplicate, _foreignKeysUserSessionReplicate, _indicesUserSessionReplicate);
        final TableInfo _existingUserSessionReplicate = TableInfo.read(_db, "UserSessionReplicate");
        if (! _infoUserSessionReplicate.equals(_existingUserSessionReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "UserSessionReplicate(com.ustadmobile.lib.db.entities.UserSessionReplicate).\n"
                  + " Expected:\n" + _infoUserSessionReplicate + "\n"
                  + " Found:\n" + _existingUserSessionReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsCoursePicture = new HashMap<String, TableInfo.Column>(12);
        _columnsCoursePicture.put("coursePictureUid", new TableInfo.Column("coursePictureUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoursePicture.put("coursePictureClazzUid", new TableInfo.Column("coursePictureClazzUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoursePicture.put("coursePictureMasterCsn", new TableInfo.Column("coursePictureMasterCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoursePicture.put("coursePictureLocalCsn", new TableInfo.Column("coursePictureLocalCsn", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoursePicture.put("coursePictureLastChangedBy", new TableInfo.Column("coursePictureLastChangedBy", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoursePicture.put("coursePictureLct", new TableInfo.Column("coursePictureLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoursePicture.put("coursePictureUri", new TableInfo.Column("coursePictureUri", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoursePicture.put("coursePictureMd5", new TableInfo.Column("coursePictureMd5", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoursePicture.put("coursePictureFileSize", new TableInfo.Column("coursePictureFileSize", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoursePicture.put("coursePictureTimestamp", new TableInfo.Column("coursePictureTimestamp", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoursePicture.put("coursePictureMimeType", new TableInfo.Column("coursePictureMimeType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoursePicture.put("coursePictureActive", new TableInfo.Column("coursePictureActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCoursePicture = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCoursePicture = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoCoursePicture = new TableInfo("CoursePicture", _columnsCoursePicture, _foreignKeysCoursePicture, _indicesCoursePicture);
        final TableInfo _existingCoursePicture = TableInfo.read(_db, "CoursePicture");
        if (! _infoCoursePicture.equals(_existingCoursePicture)) {
          return new RoomOpenHelper.ValidationResult(false, "CoursePicture(com.ustadmobile.lib.db.entities.CoursePicture).\n"
                  + " Expected:\n" + _infoCoursePicture + "\n"
                  + " Found:\n" + _existingCoursePicture);
        }
        final HashMap<String, TableInfo.Column> _columnsCoursePictureReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsCoursePictureReplicate.put("cpPk", new TableInfo.Column("cpPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoursePictureReplicate.put("cpVersionId", new TableInfo.Column("cpVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsCoursePictureReplicate.put("cpDestination", new TableInfo.Column("cpDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCoursePictureReplicate.put("cpPending", new TableInfo.Column("cpPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCoursePictureReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCoursePictureReplicate = new HashSet<TableInfo.Index>(2);
        _indicesCoursePictureReplicate.add(new TableInfo.Index("index_CoursePictureReplicate_cpPk_cpDestination_cpVersionId", false, Arrays.asList("cpPk","cpDestination","cpVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesCoursePictureReplicate.add(new TableInfo.Index("index_CoursePictureReplicate_cpDestination_cpPending", false, Arrays.asList("cpDestination","cpPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoCoursePictureReplicate = new TableInfo("CoursePictureReplicate", _columnsCoursePictureReplicate, _foreignKeysCoursePictureReplicate, _indicesCoursePictureReplicate);
        final TableInfo _existingCoursePictureReplicate = TableInfo.read(_db, "CoursePictureReplicate");
        if (! _infoCoursePictureReplicate.equals(_existingCoursePictureReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "CoursePictureReplicate(com.ustadmobile.lib.db.entities.CoursePictureReplicate).\n"
                  + " Expected:\n" + _infoCoursePictureReplicate + "\n"
                  + " Found:\n" + _existingCoursePictureReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsContentEntryPicture = new HashMap<String, TableInfo.Column>(8);
        _columnsContentEntryPicture.put("cepUid", new TableInfo.Column("cepUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryPicture.put("cepContentEntryUid", new TableInfo.Column("cepContentEntryUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryPicture.put("cepUri", new TableInfo.Column("cepUri", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryPicture.put("cepMd5", new TableInfo.Column("cepMd5", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryPicture.put("cepFileSize", new TableInfo.Column("cepFileSize", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryPicture.put("cepTimestamp", new TableInfo.Column("cepTimestamp", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryPicture.put("cepMimeType", new TableInfo.Column("cepMimeType", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryPicture.put("cepActive", new TableInfo.Column("cepActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentEntryPicture = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentEntryPicture = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoContentEntryPicture = new TableInfo("ContentEntryPicture", _columnsContentEntryPicture, _foreignKeysContentEntryPicture, _indicesContentEntryPicture);
        final TableInfo _existingContentEntryPicture = TableInfo.read(_db, "ContentEntryPicture");
        if (! _infoContentEntryPicture.equals(_existingContentEntryPicture)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentEntryPicture(com.ustadmobile.lib.db.entities.ContentEntryPicture).\n"
                  + " Expected:\n" + _infoContentEntryPicture + "\n"
                  + " Found:\n" + _existingContentEntryPicture);
        }
        final HashMap<String, TableInfo.Column> _columnsContentEntryPictureReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsContentEntryPictureReplicate.put("cepPk", new TableInfo.Column("cepPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryPictureReplicate.put("cepVersionId", new TableInfo.Column("cepVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryPictureReplicate.put("cepDestination", new TableInfo.Column("cepDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsContentEntryPictureReplicate.put("cepPending", new TableInfo.Column("cepPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysContentEntryPictureReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesContentEntryPictureReplicate = new HashSet<TableInfo.Index>(2);
        _indicesContentEntryPictureReplicate.add(new TableInfo.Index("index_ContentEntryPictureReplicate_cepPk_cepDestination_cepVersionId", false, Arrays.asList("cepPk","cepDestination","cepVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesContentEntryPictureReplicate.add(new TableInfo.Index("index_ContentEntryPictureReplicate_cepDestination_cepPending", false, Arrays.asList("cepDestination","cepPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoContentEntryPictureReplicate = new TableInfo("ContentEntryPictureReplicate", _columnsContentEntryPictureReplicate, _foreignKeysContentEntryPictureReplicate, _indicesContentEntryPictureReplicate);
        final TableInfo _existingContentEntryPictureReplicate = TableInfo.read(_db, "ContentEntryPictureReplicate");
        if (! _infoContentEntryPictureReplicate.equals(_existingContentEntryPictureReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ContentEntryPictureReplicate(com.ustadmobile.lib.db.entities.ContentEntryPictureReplicate).\n"
                  + " Expected:\n" + _infoContentEntryPictureReplicate + "\n"
                  + " Found:\n" + _existingContentEntryPictureReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsChat = new HashMap<String, TableInfo.Column>(5);
        _columnsChat.put("chatUid", new TableInfo.Column("chatUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChat.put("chatStartDate", new TableInfo.Column("chatStartDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChat.put("chatTitle", new TableInfo.Column("chatTitle", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChat.put("chatGroup", new TableInfo.Column("chatGroup", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChat.put("chatLct", new TableInfo.Column("chatLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysChat = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesChat = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoChat = new TableInfo("Chat", _columnsChat, _foreignKeysChat, _indicesChat);
        final TableInfo _existingChat = TableInfo.read(_db, "Chat");
        if (! _infoChat.equals(_existingChat)) {
          return new RoomOpenHelper.ValidationResult(false, "Chat(com.ustadmobile.lib.db.entities.Chat).\n"
                  + " Expected:\n" + _infoChat + "\n"
                  + " Found:\n" + _existingChat);
        }
        final HashMap<String, TableInfo.Column> _columnsChatMember = new HashMap<String, TableInfo.Column>(6);
        _columnsChatMember.put("chatMemberUid", new TableInfo.Column("chatMemberUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChatMember.put("chatMemberChatUid", new TableInfo.Column("chatMemberChatUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChatMember.put("chatMemberPersonUid", new TableInfo.Column("chatMemberPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChatMember.put("chatMemberJoinedDate", new TableInfo.Column("chatMemberJoinedDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChatMember.put("chatMemberLeftDate", new TableInfo.Column("chatMemberLeftDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChatMember.put("chatMemberLct", new TableInfo.Column("chatMemberLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysChatMember = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesChatMember = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoChatMember = new TableInfo("ChatMember", _columnsChatMember, _foreignKeysChatMember, _indicesChatMember);
        final TableInfo _existingChatMember = TableInfo.read(_db, "ChatMember");
        if (! _infoChatMember.equals(_existingChatMember)) {
          return new RoomOpenHelper.ValidationResult(false, "ChatMember(com.ustadmobile.lib.db.entities.ChatMember).\n"
                  + " Expected:\n" + _infoChatMember + "\n"
                  + " Found:\n" + _existingChatMember);
        }
        final HashMap<String, TableInfo.Column> _columnsMessage = new HashMap<String, TableInfo.Column>(8);
        _columnsMessage.put("messageUid", new TableInfo.Column("messageUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMessage.put("messageSenderPersonUid", new TableInfo.Column("messageSenderPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMessage.put("messageTableId", new TableInfo.Column("messageTableId", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMessage.put("messageEntityUid", new TableInfo.Column("messageEntityUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMessage.put("messageText", new TableInfo.Column("messageText", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMessage.put("messageTimestamp", new TableInfo.Column("messageTimestamp", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMessage.put("messageClazzUid", new TableInfo.Column("messageClazzUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMessage.put("messageLct", new TableInfo.Column("messageLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysMessage = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesMessage = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoMessage = new TableInfo("Message", _columnsMessage, _foreignKeysMessage, _indicesMessage);
        final TableInfo _existingMessage = TableInfo.read(_db, "Message");
        if (! _infoMessage.equals(_existingMessage)) {
          return new RoomOpenHelper.ValidationResult(false, "Message(com.ustadmobile.lib.db.entities.Message).\n"
                  + " Expected:\n" + _infoMessage + "\n"
                  + " Found:\n" + _existingMessage);
        }
        final HashMap<String, TableInfo.Column> _columnsMessageReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsMessageReplicate.put("messagePk", new TableInfo.Column("messagePk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMessageReplicate.put("messageVersionId", new TableInfo.Column("messageVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsMessageReplicate.put("messageDestination", new TableInfo.Column("messageDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMessageReplicate.put("messagePending", new TableInfo.Column("messagePending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysMessageReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesMessageReplicate = new HashSet<TableInfo.Index>(2);
        _indicesMessageReplicate.add(new TableInfo.Index("index_MessageReplicate_messagePk_messageDestination_messageVersionId", false, Arrays.asList("messagePk","messageDestination","messageVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesMessageReplicate.add(new TableInfo.Index("index_MessageReplicate_messageDestination_messagePending", false, Arrays.asList("messageDestination","messagePending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoMessageReplicate = new TableInfo("MessageReplicate", _columnsMessageReplicate, _foreignKeysMessageReplicate, _indicesMessageReplicate);
        final TableInfo _existingMessageReplicate = TableInfo.read(_db, "MessageReplicate");
        if (! _infoMessageReplicate.equals(_existingMessageReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "MessageReplicate(com.ustadmobile.lib.db.entities.MessageReplicate).\n"
                  + " Expected:\n" + _infoMessageReplicate + "\n"
                  + " Found:\n" + _existingMessageReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsChatReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsChatReplicate.put("chatPk", new TableInfo.Column("chatPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChatReplicate.put("chatVersionId", new TableInfo.Column("chatVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsChatReplicate.put("chatDestination", new TableInfo.Column("chatDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChatReplicate.put("chatPending", new TableInfo.Column("chatPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysChatReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesChatReplicate = new HashSet<TableInfo.Index>(2);
        _indicesChatReplicate.add(new TableInfo.Index("index_ChatReplicate_chatPk_chatDestination_chatVersionId", false, Arrays.asList("chatPk","chatDestination","chatVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesChatReplicate.add(new TableInfo.Index("index_ChatReplicate_chatDestination_chatPending", false, Arrays.asList("chatDestination","chatPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoChatReplicate = new TableInfo("ChatReplicate", _columnsChatReplicate, _foreignKeysChatReplicate, _indicesChatReplicate);
        final TableInfo _existingChatReplicate = TableInfo.read(_db, "ChatReplicate");
        if (! _infoChatReplicate.equals(_existingChatReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ChatReplicate(com.ustadmobile.lib.db.entities.ChatReplicate).\n"
                  + " Expected:\n" + _infoChatReplicate + "\n"
                  + " Found:\n" + _existingChatReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsChatMemberReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsChatMemberReplicate.put("chatMemberPk", new TableInfo.Column("chatMemberPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChatMemberReplicate.put("chatMemberVersionId", new TableInfo.Column("chatMemberVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsChatMemberReplicate.put("chatMemberDestination", new TableInfo.Column("chatMemberDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsChatMemberReplicate.put("chatMemberPending", new TableInfo.Column("chatMemberPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysChatMemberReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesChatMemberReplicate = new HashSet<TableInfo.Index>(2);
        _indicesChatMemberReplicate.add(new TableInfo.Index("index_ChatMemberReplicate_chatMemberPk_chatMemberDestination_chatMemberVersionId", false, Arrays.asList("chatMemberPk","chatMemberDestination","chatMemberVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesChatMemberReplicate.add(new TableInfo.Index("index_ChatMemberReplicate_chatMemberDestination_chatMemberPending", false, Arrays.asList("chatMemberDestination","chatMemberPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoChatMemberReplicate = new TableInfo("ChatMemberReplicate", _columnsChatMemberReplicate, _foreignKeysChatMemberReplicate, _indicesChatMemberReplicate);
        final TableInfo _existingChatMemberReplicate = TableInfo.read(_db, "ChatMemberReplicate");
        if (! _infoChatMemberReplicate.equals(_existingChatMemberReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "ChatMemberReplicate(com.ustadmobile.lib.db.entities.ChatMemberReplicate).\n"
                  + " Expected:\n" + _infoChatMemberReplicate + "\n"
                  + " Found:\n" + _existingChatMemberReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsMessageRead = new HashMap<String, TableInfo.Column>(5);
        _columnsMessageRead.put("messageReadUid", new TableInfo.Column("messageReadUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMessageRead.put("messageReadPersonUid", new TableInfo.Column("messageReadPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMessageRead.put("messageReadMessageUid", new TableInfo.Column("messageReadMessageUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMessageRead.put("messageReadEntityUid", new TableInfo.Column("messageReadEntityUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMessageRead.put("messageReadLct", new TableInfo.Column("messageReadLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysMessageRead = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesMessageRead = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoMessageRead = new TableInfo("MessageRead", _columnsMessageRead, _foreignKeysMessageRead, _indicesMessageRead);
        final TableInfo _existingMessageRead = TableInfo.read(_db, "MessageRead");
        if (! _infoMessageRead.equals(_existingMessageRead)) {
          return new RoomOpenHelper.ValidationResult(false, "MessageRead(com.ustadmobile.lib.db.entities.MessageRead).\n"
                  + " Expected:\n" + _infoMessageRead + "\n"
                  + " Found:\n" + _existingMessageRead);
        }
        final HashMap<String, TableInfo.Column> _columnsMessageReadReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsMessageReadReplicate.put("messageReadPk", new TableInfo.Column("messageReadPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMessageReadReplicate.put("messageReadVersionId", new TableInfo.Column("messageReadVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsMessageReadReplicate.put("messageReadDestination", new TableInfo.Column("messageReadDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMessageReadReplicate.put("messageReadPending", new TableInfo.Column("messageReadPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysMessageReadReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesMessageReadReplicate = new HashSet<TableInfo.Index>(2);
        _indicesMessageReadReplicate.add(new TableInfo.Index("index_MessageReadReplicate_messageReadPk_messageReadDestination_messageReadVersionId", false, Arrays.asList("messageReadPk","messageReadDestination","messageReadVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesMessageReadReplicate.add(new TableInfo.Index("index_MessageReadReplicate_messageReadDestination_messageReadPending", false, Arrays.asList("messageReadDestination","messageReadPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoMessageReadReplicate = new TableInfo("MessageReadReplicate", _columnsMessageReadReplicate, _foreignKeysMessageReadReplicate, _indicesMessageReadReplicate);
        final TableInfo _existingMessageReadReplicate = TableInfo.read(_db, "MessageReadReplicate");
        if (! _infoMessageReadReplicate.equals(_existingMessageReadReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "MessageReadReplicate(com.ustadmobile.lib.db.entities.MessageReadReplicate).\n"
                  + " Expected:\n" + _infoMessageReadReplicate + "\n"
                  + " Found:\n" + _existingMessageReadReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseDiscussion = new HashMap<String, TableInfo.Column>(6);
        _columnsCourseDiscussion.put("courseDiscussionUid", new TableInfo.Column("courseDiscussionUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseDiscussion.put("courseDiscussionTitle", new TableInfo.Column("courseDiscussionTitle", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseDiscussion.put("courseDiscussionDesc", new TableInfo.Column("courseDiscussionDesc", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseDiscussion.put("courseDiscussionClazzUid", new TableInfo.Column("courseDiscussionClazzUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseDiscussion.put("courseDiscussionActive", new TableInfo.Column("courseDiscussionActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseDiscussion.put("courseDiscussionLct", new TableInfo.Column("courseDiscussionLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseDiscussion = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseDiscussion = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoCourseDiscussion = new TableInfo("CourseDiscussion", _columnsCourseDiscussion, _foreignKeysCourseDiscussion, _indicesCourseDiscussion);
        final TableInfo _existingCourseDiscussion = TableInfo.read(_db, "CourseDiscussion");
        if (! _infoCourseDiscussion.equals(_existingCourseDiscussion)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseDiscussion(com.ustadmobile.lib.db.entities.CourseDiscussion).\n"
                  + " Expected:\n" + _infoCourseDiscussion + "\n"
                  + " Found:\n" + _existingCourseDiscussion);
        }
        final HashMap<String, TableInfo.Column> _columnsCourseDiscussionReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsCourseDiscussionReplicate.put("courseDiscussionPk", new TableInfo.Column("courseDiscussionPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseDiscussionReplicate.put("courseDiscussionVersionId", new TableInfo.Column("courseDiscussionVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseDiscussionReplicate.put("courseDiscussionDestination", new TableInfo.Column("courseDiscussionDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsCourseDiscussionReplicate.put("courseDiscussionPending", new TableInfo.Column("courseDiscussionPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysCourseDiscussionReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesCourseDiscussionReplicate = new HashSet<TableInfo.Index>(2);
        _indicesCourseDiscussionReplicate.add(new TableInfo.Index("index_CourseDiscussionReplicate_courseDiscussionPk_courseDiscussionDestination_courseDiscussionVersionId", false, Arrays.asList("courseDiscussionPk","courseDiscussionDestination","courseDiscussionVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesCourseDiscussionReplicate.add(new TableInfo.Index("index_CourseDiscussionReplicate_courseDiscussionDestination_courseDiscussionPending", false, Arrays.asList("courseDiscussionDestination","courseDiscussionPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoCourseDiscussionReplicate = new TableInfo("CourseDiscussionReplicate", _columnsCourseDiscussionReplicate, _foreignKeysCourseDiscussionReplicate, _indicesCourseDiscussionReplicate);
        final TableInfo _existingCourseDiscussionReplicate = TableInfo.read(_db, "CourseDiscussionReplicate");
        if (! _infoCourseDiscussionReplicate.equals(_existingCourseDiscussionReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "CourseDiscussionReplicate(com.ustadmobile.lib.db.entities.CourseDiscussionReplicate).\n"
                  + " Expected:\n" + _infoCourseDiscussionReplicate + "\n"
                  + " Found:\n" + _existingCourseDiscussionReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsDiscussionTopic = new HashMap<String, TableInfo.Column>(10);
        _columnsDiscussionTopic.put("discussionTopicUid", new TableInfo.Column("discussionTopicUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionTopic.put("discussionTopicTitle", new TableInfo.Column("discussionTopicTitle", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionTopic.put("discussionTopicDesc", new TableInfo.Column("discussionTopicDesc", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionTopic.put("discussionTopicStartDate", new TableInfo.Column("discussionTopicStartDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionTopic.put("discussionTopicCourseDiscussionUid", new TableInfo.Column("discussionTopicCourseDiscussionUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionTopic.put("discussionTopicVisible", new TableInfo.Column("discussionTopicVisible", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionTopic.put("discussionTopicArchive", new TableInfo.Column("discussionTopicArchive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionTopic.put("discussionTopicIndex", new TableInfo.Column("discussionTopicIndex", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionTopic.put("discussionTopicClazzUid", new TableInfo.Column("discussionTopicClazzUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionTopic.put("discussionTopicLct", new TableInfo.Column("discussionTopicLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysDiscussionTopic = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesDiscussionTopic = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoDiscussionTopic = new TableInfo("DiscussionTopic", _columnsDiscussionTopic, _foreignKeysDiscussionTopic, _indicesDiscussionTopic);
        final TableInfo _existingDiscussionTopic = TableInfo.read(_db, "DiscussionTopic");
        if (! _infoDiscussionTopic.equals(_existingDiscussionTopic)) {
          return new RoomOpenHelper.ValidationResult(false, "DiscussionTopic(com.ustadmobile.lib.db.entities.DiscussionTopic).\n"
                  + " Expected:\n" + _infoDiscussionTopic + "\n"
                  + " Found:\n" + _existingDiscussionTopic);
        }
        final HashMap<String, TableInfo.Column> _columnsDiscussionTopicReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsDiscussionTopicReplicate.put("discussionTopicPk", new TableInfo.Column("discussionTopicPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionTopicReplicate.put("discussionTopicVersionId", new TableInfo.Column("discussionTopicVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionTopicReplicate.put("discussionTopicDestination", new TableInfo.Column("discussionTopicDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionTopicReplicate.put("discussionTopicPending", new TableInfo.Column("discussionTopicPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysDiscussionTopicReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesDiscussionTopicReplicate = new HashSet<TableInfo.Index>(2);
        _indicesDiscussionTopicReplicate.add(new TableInfo.Index("index_DiscussionTopicReplicate_discussionTopicPk_discussionTopicDestination_discussionTopicVersionId", false, Arrays.asList("discussionTopicPk","discussionTopicDestination","discussionTopicVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesDiscussionTopicReplicate.add(new TableInfo.Index("index_DiscussionTopicReplicate_discussionTopicDestination_discussionTopicPending", false, Arrays.asList("discussionTopicDestination","discussionTopicPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoDiscussionTopicReplicate = new TableInfo("DiscussionTopicReplicate", _columnsDiscussionTopicReplicate, _foreignKeysDiscussionTopicReplicate, _indicesDiscussionTopicReplicate);
        final TableInfo _existingDiscussionTopicReplicate = TableInfo.read(_db, "DiscussionTopicReplicate");
        if (! _infoDiscussionTopicReplicate.equals(_existingDiscussionTopicReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "DiscussionTopicReplicate(com.ustadmobile.lib.db.entities.DiscussionTopicReplicate).\n"
                  + " Expected:\n" + _infoDiscussionTopicReplicate + "\n"
                  + " Found:\n" + _existingDiscussionTopicReplicate);
        }
        final HashMap<String, TableInfo.Column> _columnsDiscussionPost = new HashMap<String, TableInfo.Column>(10);
        _columnsDiscussionPost.put("discussionPostUid", new TableInfo.Column("discussionPostUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionPost.put("discussionPostTitle", new TableInfo.Column("discussionPostTitle", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionPost.put("discussionPostMessage", new TableInfo.Column("discussionPostMessage", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionPost.put("discussionPostStartDate", new TableInfo.Column("discussionPostStartDate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionPost.put("discussionPostDiscussionTopicUid", new TableInfo.Column("discussionPostDiscussionTopicUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionPost.put("discussionPostVisible", new TableInfo.Column("discussionPostVisible", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionPost.put("discussionPostArchive", new TableInfo.Column("discussionPostArchive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionPost.put("discussionPostStartedPersonUid", new TableInfo.Column("discussionPostStartedPersonUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionPost.put("discussionPostClazzUid", new TableInfo.Column("discussionPostClazzUid", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionPost.put("discussionPostLct", new TableInfo.Column("discussionPostLct", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysDiscussionPost = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesDiscussionPost = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoDiscussionPost = new TableInfo("DiscussionPost", _columnsDiscussionPost, _foreignKeysDiscussionPost, _indicesDiscussionPost);
        final TableInfo _existingDiscussionPost = TableInfo.read(_db, "DiscussionPost");
        if (! _infoDiscussionPost.equals(_existingDiscussionPost)) {
          return new RoomOpenHelper.ValidationResult(false, "DiscussionPost(com.ustadmobile.lib.db.entities.DiscussionPost).\n"
                  + " Expected:\n" + _infoDiscussionPost + "\n"
                  + " Found:\n" + _existingDiscussionPost);
        }
        final HashMap<String, TableInfo.Column> _columnsDiscussionPostReplicate = new HashMap<String, TableInfo.Column>(4);
        _columnsDiscussionPostReplicate.put("discussionPostPk", new TableInfo.Column("discussionPostPk", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionPostReplicate.put("discussionPostVersionId", new TableInfo.Column("discussionPostVersionId", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionPostReplicate.put("discussionPostDestination", new TableInfo.Column("discussionPostDestination", "INTEGER", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsDiscussionPostReplicate.put("discussionPostPending", new TableInfo.Column("discussionPostPending", "INTEGER", true, 0, "1", TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysDiscussionPostReplicate = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesDiscussionPostReplicate = new HashSet<TableInfo.Index>(2);
        _indicesDiscussionPostReplicate.add(new TableInfo.Index("index_DiscussionPostReplicate_discussionPostPk_discussionPostDestination_discussionPostVersionId", false, Arrays.asList("discussionPostPk","discussionPostDestination","discussionPostVersionId"), Arrays.asList("ASC","ASC","ASC")));
        _indicesDiscussionPostReplicate.add(new TableInfo.Index("index_DiscussionPostReplicate_discussionPostDestination_discussionPostPending", false, Arrays.asList("discussionPostDestination","discussionPostPending"), Arrays.asList("ASC","ASC")));
        final TableInfo _infoDiscussionPostReplicate = new TableInfo("DiscussionPostReplicate", _columnsDiscussionPostReplicate, _foreignKeysDiscussionPostReplicate, _indicesDiscussionPostReplicate);
        final TableInfo _existingDiscussionPostReplicate = TableInfo.read(_db, "DiscussionPostReplicate");
        if (! _infoDiscussionPostReplicate.equals(_existingDiscussionPostReplicate)) {
          return new RoomOpenHelper.ValidationResult(false, "DiscussionPostReplicate(com.ustadmobile.lib.db.entities.DiscussionPostReplicate).\n"
                  + " Expected:\n" + _infoDiscussionPostReplicate + "\n"
                  + " Found:\n" + _existingDiscussionPostReplicate);
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }
    }, "c4bdb0bd24b59faab1b3d90846470bdf", "771d12acf57229cb17bd9ed1de82830c");
    final SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder(configuration.context)
        .name(configuration.name)
        .callback(_openCallback)
        .build();
    final SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
    return _helper;
  }

  @Override
  protected InvalidationTracker createInvalidationTracker() {
    final HashMap<String, String> _shadowTablesMap = new HashMap<String, String>(0);
    HashMap<String, Set<String>> _viewTables = new HashMap<String, Set<String>>(0);
    return new InvalidationTracker(this, _shadowTablesMap, _viewTables, "NetworkNode","ClazzLog","ClazzLogAttendanceRecord","Schedule","DateRange","HolidayCalendar","Holiday","ScheduledCheck","AuditLog","CustomField","CustomFieldValue","CustomFieldValueOption","Person","Clazz","ClazzEnrolment","LeavingReason","ContentEntry","ContentEntryContentCategoryJoin","ContentEntryParentChildJoin","ContentEntryRelatedEntryJoin","ContentCategorySchema","ContentCategory","Language","LanguageVariant","AccessToken","PersonAuth","Role","EntityRole","PersonGroup","PersonGroupMember","PersonPicture","ScrapeQueueItem","ScrapeRun","ConnectivityStatus","Container","ContainerEntry","ContainerEntryFile","VerbEntity","XObjectEntity","StatementEntity","ContextXObjectStatementJoin","AgentEntity","StateEntity","StateContentEntity","XLangMapEntry","SyncNode","LocallyAvailableContainer","ContainerETag","School","SchoolMember","Comments","Report","Site","ContainerImportJob","LearnerGroup","LearnerGroupMember","GroupLearningSession","SiteTerms","ClazzContentJoin","PersonParentJoin","ScopedGrant","ErrorReport","ClazzAssignment","ClazzAssignmentContentJoin","CourseAssignmentSubmission","CourseAssignmentSubmissionAttachment","CourseAssignmentMark","ClazzAssignmentRollUp","PersonAuth2","UserSession","ContentJob","ContentJobItem","CourseBlock","CourseTerminology","CourseGroupSet","CourseGroupMember","ChangeLog","ZombieAttachmentData","DoorNode","ReplicationStatus","ClazzLogReplicate","ClazzLogAttendanceRecordReplicate","CourseAssignmentSubmissionReplicate","CourseAssignmentSubmissionAttachmentReplicate","CourseAssignmentMarkReplicate","CourseBlockReplicate","CourseTerminologyReplicate","CourseGroupSetReplicate","CourseGroupMemberReplicate","ScheduleReplicate","HolidayCalendarReplicate","HolidayReplicate","PersonReplicate","ClazzReplicate","ClazzEnrolmentReplicate","LeavingReasonReplicate","ContentEntryReplicate","ContentEntryContentCategoryJoinReplicate","ContentEntryParentChildJoinReplicate","ContentEntryRelatedEntryJoinReplicate","ContentCategorySchemaReplicate","ContentCategoryReplicate","LanguageReplicate","LanguageVariantReplicate","PersonGroupReplicate","PersonGroupMemberReplicate","PersonPictureReplicate","ContainerReplicate","VerbEntityReplicate","XObjectEntityReplicate","StatementEntityReplicate","ContextXObjectStatementJoinReplicate","AgentEntityReplicate","StateEntityReplicate","StateContentEntityReplicate","XLangMapEntryReplicate","SchoolReplicate","SchoolMemberReplicate","CommentsReplicate","ReportReplicate","SiteReplicate","LearnerGroupReplicate","LearnerGroupMemberReplicate","GroupLearningSessionReplicate","SiteTermsReplicate","ClazzContentJoinReplicate","PersonParentJoinReplicate","ScopedGrantReplicate","ErrorReportReplicate","ClazzAssignmentReplicate","ClazzAssignmentContentJoinReplicate","PersonAuth2Replicate","UserSessionReplicate","CoursePicture","CoursePictureReplicate","ContentEntryPicture","ContentEntryPictureReplicate","Chat","ChatMember","Message","MessageReplicate","ChatReplicate","ChatMemberReplicate","MessageRead","MessageReadReplicate","CourseDiscussion","CourseDiscussionReplicate","DiscussionTopic","DiscussionTopicReplicate","DiscussionPost","DiscussionPostReplicate");
  }

  @Override
  public void clearAllTables() {
    super.assertNotMainThread();
    final SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
    try {
      super.beginTransaction();
      _db.execSQL("DELETE FROM `NetworkNode`");
      _db.execSQL("DELETE FROM `ClazzLog`");
      _db.execSQL("DELETE FROM `ClazzLogAttendanceRecord`");
      _db.execSQL("DELETE FROM `Schedule`");
      _db.execSQL("DELETE FROM `DateRange`");
      _db.execSQL("DELETE FROM `HolidayCalendar`");
      _db.execSQL("DELETE FROM `Holiday`");
      _db.execSQL("DELETE FROM `ScheduledCheck`");
      _db.execSQL("DELETE FROM `AuditLog`");
      _db.execSQL("DELETE FROM `CustomField`");
      _db.execSQL("DELETE FROM `CustomFieldValue`");
      _db.execSQL("DELETE FROM `CustomFieldValueOption`");
      _db.execSQL("DELETE FROM `Person`");
      _db.execSQL("DELETE FROM `Clazz`");
      _db.execSQL("DELETE FROM `ClazzEnrolment`");
      _db.execSQL("DELETE FROM `LeavingReason`");
      _db.execSQL("DELETE FROM `ContentEntry`");
      _db.execSQL("DELETE FROM `ContentEntryContentCategoryJoin`");
      _db.execSQL("DELETE FROM `ContentEntryParentChildJoin`");
      _db.execSQL("DELETE FROM `ContentEntryRelatedEntryJoin`");
      _db.execSQL("DELETE FROM `ContentCategorySchema`");
      _db.execSQL("DELETE FROM `ContentCategory`");
      _db.execSQL("DELETE FROM `Language`");
      _db.execSQL("DELETE FROM `LanguageVariant`");
      _db.execSQL("DELETE FROM `AccessToken`");
      _db.execSQL("DELETE FROM `PersonAuth`");
      _db.execSQL("DELETE FROM `Role`");
      _db.execSQL("DELETE FROM `EntityRole`");
      _db.execSQL("DELETE FROM `PersonGroup`");
      _db.execSQL("DELETE FROM `PersonGroupMember`");
      _db.execSQL("DELETE FROM `PersonPicture`");
      _db.execSQL("DELETE FROM `ScrapeQueueItem`");
      _db.execSQL("DELETE FROM `ScrapeRun`");
      _db.execSQL("DELETE FROM `ConnectivityStatus`");
      _db.execSQL("DELETE FROM `Container`");
      _db.execSQL("DELETE FROM `ContainerEntry`");
      _db.execSQL("DELETE FROM `ContainerEntryFile`");
      _db.execSQL("DELETE FROM `VerbEntity`");
      _db.execSQL("DELETE FROM `XObjectEntity`");
      _db.execSQL("DELETE FROM `StatementEntity`");
      _db.execSQL("DELETE FROM `ContextXObjectStatementJoin`");
      _db.execSQL("DELETE FROM `AgentEntity`");
      _db.execSQL("DELETE FROM `StateEntity`");
      _db.execSQL("DELETE FROM `StateContentEntity`");
      _db.execSQL("DELETE FROM `XLangMapEntry`");
      _db.execSQL("DELETE FROM `SyncNode`");
      _db.execSQL("DELETE FROM `LocallyAvailableContainer`");
      _db.execSQL("DELETE FROM `ContainerETag`");
      _db.execSQL("DELETE FROM `School`");
      _db.execSQL("DELETE FROM `SchoolMember`");
      _db.execSQL("DELETE FROM `Comments`");
      _db.execSQL("DELETE FROM `Report`");
      _db.execSQL("DELETE FROM `Site`");
      _db.execSQL("DELETE FROM `ContainerImportJob`");
      _db.execSQL("DELETE FROM `LearnerGroup`");
      _db.execSQL("DELETE FROM `LearnerGroupMember`");
      _db.execSQL("DELETE FROM `GroupLearningSession`");
      _db.execSQL("DELETE FROM `SiteTerms`");
      _db.execSQL("DELETE FROM `ClazzContentJoin`");
      _db.execSQL("DELETE FROM `PersonParentJoin`");
      _db.execSQL("DELETE FROM `ScopedGrant`");
      _db.execSQL("DELETE FROM `ErrorReport`");
      _db.execSQL("DELETE FROM `ClazzAssignment`");
      _db.execSQL("DELETE FROM `ClazzAssignmentContentJoin`");
      _db.execSQL("DELETE FROM `CourseAssignmentSubmission`");
      _db.execSQL("DELETE FROM `CourseAssignmentSubmissionAttachment`");
      _db.execSQL("DELETE FROM `CourseAssignmentMark`");
      _db.execSQL("DELETE FROM `ClazzAssignmentRollUp`");
      _db.execSQL("DELETE FROM `PersonAuth2`");
      _db.execSQL("DELETE FROM `UserSession`");
      _db.execSQL("DELETE FROM `ContentJob`");
      _db.execSQL("DELETE FROM `ContentJobItem`");
      _db.execSQL("DELETE FROM `CourseBlock`");
      _db.execSQL("DELETE FROM `CourseTerminology`");
      _db.execSQL("DELETE FROM `CourseGroupSet`");
      _db.execSQL("DELETE FROM `CourseGroupMember`");
      _db.execSQL("DELETE FROM `ChangeLog`");
      _db.execSQL("DELETE FROM `ZombieAttachmentData`");
      _db.execSQL("DELETE FROM `DoorNode`");
      _db.execSQL("DELETE FROM `ReplicationStatus`");
      _db.execSQL("DELETE FROM `ClazzLogReplicate`");
      _db.execSQL("DELETE FROM `ClazzLogAttendanceRecordReplicate`");
      _db.execSQL("DELETE FROM `CourseAssignmentSubmissionReplicate`");
      _db.execSQL("DELETE FROM `CourseAssignmentSubmissionAttachmentReplicate`");
      _db.execSQL("DELETE FROM `CourseAssignmentMarkReplicate`");
      _db.execSQL("DELETE FROM `CourseBlockReplicate`");
      _db.execSQL("DELETE FROM `CourseTerminologyReplicate`");
      _db.execSQL("DELETE FROM `CourseGroupSetReplicate`");
      _db.execSQL("DELETE FROM `CourseGroupMemberReplicate`");
      _db.execSQL("DELETE FROM `ScheduleReplicate`");
      _db.execSQL("DELETE FROM `HolidayCalendarReplicate`");
      _db.execSQL("DELETE FROM `HolidayReplicate`");
      _db.execSQL("DELETE FROM `PersonReplicate`");
      _db.execSQL("DELETE FROM `ClazzReplicate`");
      _db.execSQL("DELETE FROM `ClazzEnrolmentReplicate`");
      _db.execSQL("DELETE FROM `LeavingReasonReplicate`");
      _db.execSQL("DELETE FROM `ContentEntryReplicate`");
      _db.execSQL("DELETE FROM `ContentEntryContentCategoryJoinReplicate`");
      _db.execSQL("DELETE FROM `ContentEntryParentChildJoinReplicate`");
      _db.execSQL("DELETE FROM `ContentEntryRelatedEntryJoinReplicate`");
      _db.execSQL("DELETE FROM `ContentCategorySchemaReplicate`");
      _db.execSQL("DELETE FROM `ContentCategoryReplicate`");
      _db.execSQL("DELETE FROM `LanguageReplicate`");
      _db.execSQL("DELETE FROM `LanguageVariantReplicate`");
      _db.execSQL("DELETE FROM `PersonGroupReplicate`");
      _db.execSQL("DELETE FROM `PersonGroupMemberReplicate`");
      _db.execSQL("DELETE FROM `PersonPictureReplicate`");
      _db.execSQL("DELETE FROM `ContainerReplicate`");
      _db.execSQL("DELETE FROM `VerbEntityReplicate`");
      _db.execSQL("DELETE FROM `XObjectEntityReplicate`");
      _db.execSQL("DELETE FROM `StatementEntityReplicate`");
      _db.execSQL("DELETE FROM `ContextXObjectStatementJoinReplicate`");
      _db.execSQL("DELETE FROM `AgentEntityReplicate`");
      _db.execSQL("DELETE FROM `StateEntityReplicate`");
      _db.execSQL("DELETE FROM `StateContentEntityReplicate`");
      _db.execSQL("DELETE FROM `XLangMapEntryReplicate`");
      _db.execSQL("DELETE FROM `SchoolReplicate`");
      _db.execSQL("DELETE FROM `SchoolMemberReplicate`");
      _db.execSQL("DELETE FROM `CommentsReplicate`");
      _db.execSQL("DELETE FROM `ReportReplicate`");
      _db.execSQL("DELETE FROM `SiteReplicate`");
      _db.execSQL("DELETE FROM `LearnerGroupReplicate`");
      _db.execSQL("DELETE FROM `LearnerGroupMemberReplicate`");
      _db.execSQL("DELETE FROM `GroupLearningSessionReplicate`");
      _db.execSQL("DELETE FROM `SiteTermsReplicate`");
      _db.execSQL("DELETE FROM `ClazzContentJoinReplicate`");
      _db.execSQL("DELETE FROM `PersonParentJoinReplicate`");
      _db.execSQL("DELETE FROM `ScopedGrantReplicate`");
      _db.execSQL("DELETE FROM `ErrorReportReplicate`");
      _db.execSQL("DELETE FROM `ClazzAssignmentReplicate`");
      _db.execSQL("DELETE FROM `ClazzAssignmentContentJoinReplicate`");
      _db.execSQL("DELETE FROM `PersonAuth2Replicate`");
      _db.execSQL("DELETE FROM `UserSessionReplicate`");
      _db.execSQL("DELETE FROM `CoursePicture`");
      _db.execSQL("DELETE FROM `CoursePictureReplicate`");
      _db.execSQL("DELETE FROM `ContentEntryPicture`");
      _db.execSQL("DELETE FROM `ContentEntryPictureReplicate`");
      _db.execSQL("DELETE FROM `Chat`");
      _db.execSQL("DELETE FROM `ChatMember`");
      _db.execSQL("DELETE FROM `Message`");
      _db.execSQL("DELETE FROM `MessageReplicate`");
      _db.execSQL("DELETE FROM `ChatReplicate`");
      _db.execSQL("DELETE FROM `ChatMemberReplicate`");
      _db.execSQL("DELETE FROM `MessageRead`");
      _db.execSQL("DELETE FROM `MessageReadReplicate`");
      _db.execSQL("DELETE FROM `CourseDiscussion`");
      _db.execSQL("DELETE FROM `CourseDiscussionReplicate`");
      _db.execSQL("DELETE FROM `DiscussionTopic`");
      _db.execSQL("DELETE FROM `DiscussionTopicReplicate`");
      _db.execSQL("DELETE FROM `DiscussionPost`");
      _db.execSQL("DELETE FROM `DiscussionPostReplicate`");
      super.setTransactionSuccessful();
    } finally {
      super.endTransaction();
      _db.query("PRAGMA wal_checkpoint(FULL)").close();
      if (!_db.inTransaction()) {
        _db.execSQL("VACUUM");
      }
    }
  }

  @Override
  protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
    final HashMap<Class<?>, List<Class<?>>> _typeConvertersMap = new HashMap<Class<?>, List<Class<?>>>();
    _typeConvertersMap.put(NetworkNodeDao.class, NetworkNodeDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(PersonDao.class, PersonDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ClazzDao.class, ClazzDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(CourseBlockDao.class, CourseBlockDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(CourseTerminologyDao.class, CourseTerminologyDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(CourseGroupSetDao.class, CourseGroupSetDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(CourseGroupMemberDao.class, CourseGroupMemberDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ClazzEnrolmentDao.class, ClazzEnrolmentDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(LeavingReasonDao.class, LeavingReasonDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContentEntryDao.class, ContentEntryDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContentEntryContentCategoryJoinDao.class, ContentEntryContentCategoryJoinDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContentEntryParentChildJoinDao.class, ContentEntryParentChildJoinDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContentEntryRelatedEntryJoinDao.class, ContentEntryRelatedEntryJoinDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ClazzContentJoinDao.class, ClazzContentJoinDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContentCategorySchemaDao.class, ContentCategorySchemaDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContentCategoryDao.class, ContentCategoryDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(LanguageDao.class, LanguageDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(LanguageVariantDao.class, LanguageVariantDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ScrapeQueueItemDao.class, ScrapeQueueItemDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(PersonAuthDao.class, PersonAuthDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(PersonGroupDao.class, PersonGroupDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(PersonGroupMemberDao.class, PersonGroupMemberDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(EntityRoleDao.class, EntityRoleDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(PersonPictureDao.class, PersonPictureDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ConnectivityStatusDao.class, ConnectivityStatusDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContainerDao.class, ContainerDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContainerEntryDao.class, ContainerEntryDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContainerEntryFileDao.class, ContainerEntryFileDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContainerETagDao.class, ContainerETagDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(VerbDao.class, VerbDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(XObjectDao.class, XObjectDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ReportDao.class, ReportDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContainerImportJobDao.class, ContainerImportJobDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(StatementDao.class, StatementDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContextXObjectStatementJoinDao.class, ContextXObjectStatementJoinDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(StateDao.class, StateDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(StateContentDao.class, StateContentDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(AgentDao.class, AgentDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(LearnerGroupDao.class, LearnerGroupDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(LearnerGroupMemberDao.class, LearnerGroupMemberDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(GroupLearningSessionDao.class, GroupLearningSessionDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ClazzLogAttendanceRecordDao.class, ClazzLogAttendanceRecordDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ClazzLogDao.class, ClazzLogDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ScheduleDao.class, ScheduleDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(HolidayCalendarDao.class, HolidayCalendarDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(HolidayDao.class, HolidayDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(SchoolDao.class, SchoolDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(XLangMapEntryDao.class, XLangMapEntryDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(LocallyAvailableContainerDao.class, LocallyAvailableContainerDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(SchoolMemberDao.class, SchoolMemberDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ClazzAssignmentDao.class, ClazzAssignmentDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ClazzAssignmentContentJoinDao.class, ClazzAssignmentContentJoinDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ClazzAssignmentRollUpDao.class, ClazzAssignmentRollUpDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(CourseAssignmentSubmissionDao.class, CourseAssignmentSubmissionDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(CourseAssignmentSubmissionAttachmentDao.class, CourseAssignmentSubmissionAttachmentDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(CourseAssignmentMarkDao.class, CourseAssignmentMarkDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(CommentsDao.class, CommentsDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(SyncNodeDao.class, SyncNodeDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(SiteDao.class, SiteDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(SiteTermsDao.class, SiteTermsDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(PersonParentJoinDao.class, PersonParentJoinDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ScopedGrantDao.class, ScopedGrantDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ErrorReportDao.class, ErrorReportDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(PersonAuth2Dao.class, PersonAuth2Dao_Impl.getRequiredConverters());
    _typeConvertersMap.put(UserSessionDao.class, UserSessionDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContentJobItemDao.class, ContentJobItemDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContentJobDao.class, ContentJobDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(CoursePictureDao.class, CoursePictureDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ContentEntryPictureDao.class, ContentEntryPictureDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ChatDao.class, ChatDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(ChatMemberDao.class, ChatMemberDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(MessageDao.class, MessageDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(MessageReadDao.class, MessageReadDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(CourseDiscussionDao.class, CourseDiscussionDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(DiscussionTopicDao.class, DiscussionTopicDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(DiscussionPostDao.class, DiscussionPostDao_Impl.getRequiredConverters());
    return _typeConvertersMap;
  }

  @Override
  public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
    final HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
    return _autoMigrationSpecsSet;
  }

  @Override
  public List<Migration> getAutoMigrations(
      @NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
    return Arrays.asList();
  }

  @Override
  public NetworkNodeDao getNetworkNodeDao() {
    if (_networkNodeDao != null) {
      return _networkNodeDao;
    } else {
      synchronized(this) {
        if(_networkNodeDao == null) {
          _networkNodeDao = new NetworkNodeDao_Impl(this);
        }
        return _networkNodeDao;
      }
    }
  }

  @Override
  public PersonDao getPersonDao() {
    if (_personDao != null) {
      return _personDao;
    } else {
      synchronized(this) {
        if(_personDao == null) {
          _personDao = new PersonDao_Impl(this);
        }
        return _personDao;
      }
    }
  }

  @Override
  public ClazzDao getClazzDao() {
    if (_clazzDao != null) {
      return _clazzDao;
    } else {
      synchronized(this) {
        if(_clazzDao == null) {
          _clazzDao = new ClazzDao_Impl(this);
        }
        return _clazzDao;
      }
    }
  }

  @Override
  public CourseBlockDao getCourseBlockDao() {
    if (_courseBlockDao != null) {
      return _courseBlockDao;
    } else {
      synchronized(this) {
        if(_courseBlockDao == null) {
          _courseBlockDao = new CourseBlockDao_Impl(this);
        }
        return _courseBlockDao;
      }
    }
  }

  @Override
  public CourseTerminologyDao getCourseTerminologyDao() {
    if (_courseTerminologyDao != null) {
      return _courseTerminologyDao;
    } else {
      synchronized(this) {
        if(_courseTerminologyDao == null) {
          _courseTerminologyDao = new CourseTerminologyDao_Impl(this);
        }
        return _courseTerminologyDao;
      }
    }
  }

  @Override
  public CourseGroupSetDao getCourseGroupSetDao() {
    if (_courseGroupSetDao != null) {
      return _courseGroupSetDao;
    } else {
      synchronized(this) {
        if(_courseGroupSetDao == null) {
          _courseGroupSetDao = new CourseGroupSetDao_Impl(this);
        }
        return _courseGroupSetDao;
      }
    }
  }

  @Override
  public CourseGroupMemberDao getCourseGroupMemberDao() {
    if (_courseGroupMemberDao != null) {
      return _courseGroupMemberDao;
    } else {
      synchronized(this) {
        if(_courseGroupMemberDao == null) {
          _courseGroupMemberDao = new CourseGroupMemberDao_Impl(this);
        }
        return _courseGroupMemberDao;
      }
    }
  }

  @Override
  public ClazzEnrolmentDao getClazzEnrolmentDao() {
    if (_clazzEnrolmentDao != null) {
      return _clazzEnrolmentDao;
    } else {
      synchronized(this) {
        if(_clazzEnrolmentDao == null) {
          _clazzEnrolmentDao = new ClazzEnrolmentDao_Impl(this);
        }
        return _clazzEnrolmentDao;
      }
    }
  }

  @Override
  public LeavingReasonDao getLeavingReasonDao() {
    if (_leavingReasonDao != null) {
      return _leavingReasonDao;
    } else {
      synchronized(this) {
        if(_leavingReasonDao == null) {
          _leavingReasonDao = new LeavingReasonDao_Impl(this);
        }
        return _leavingReasonDao;
      }
    }
  }

  @Override
  public ContentEntryDao getContentEntryDao() {
    if (_contentEntryDao != null) {
      return _contentEntryDao;
    } else {
      synchronized(this) {
        if(_contentEntryDao == null) {
          _contentEntryDao = new ContentEntryDao_Impl(this);
        }
        return _contentEntryDao;
      }
    }
  }

  @Override
  public ContentEntryContentCategoryJoinDao getContentEntryContentCategoryJoinDao() {
    if (_contentEntryContentCategoryJoinDao != null) {
      return _contentEntryContentCategoryJoinDao;
    } else {
      synchronized(this) {
        if(_contentEntryContentCategoryJoinDao == null) {
          _contentEntryContentCategoryJoinDao = new ContentEntryContentCategoryJoinDao_Impl(this);
        }
        return _contentEntryContentCategoryJoinDao;
      }
    }
  }

  @Override
  public ContentEntryParentChildJoinDao getContentEntryParentChildJoinDao() {
    if (_contentEntryParentChildJoinDao != null) {
      return _contentEntryParentChildJoinDao;
    } else {
      synchronized(this) {
        if(_contentEntryParentChildJoinDao == null) {
          _contentEntryParentChildJoinDao = new ContentEntryParentChildJoinDao_Impl(this);
        }
        return _contentEntryParentChildJoinDao;
      }
    }
  }

  @Override
  public ContentEntryRelatedEntryJoinDao getContentEntryRelatedEntryJoinDao() {
    if (_contentEntryRelatedEntryJoinDao != null) {
      return _contentEntryRelatedEntryJoinDao;
    } else {
      synchronized(this) {
        if(_contentEntryRelatedEntryJoinDao == null) {
          _contentEntryRelatedEntryJoinDao = new ContentEntryRelatedEntryJoinDao_Impl(this);
        }
        return _contentEntryRelatedEntryJoinDao;
      }
    }
  }

  @Override
  public ClazzContentJoinDao getClazzContentJoinDao() {
    if (_clazzContentJoinDao != null) {
      return _clazzContentJoinDao;
    } else {
      synchronized(this) {
        if(_clazzContentJoinDao == null) {
          _clazzContentJoinDao = new ClazzContentJoinDao_Impl(this);
        }
        return _clazzContentJoinDao;
      }
    }
  }

  @Override
  public ContentCategorySchemaDao getContentCategorySchemaDao() {
    if (_contentCategorySchemaDao != null) {
      return _contentCategorySchemaDao;
    } else {
      synchronized(this) {
        if(_contentCategorySchemaDao == null) {
          _contentCategorySchemaDao = new ContentCategorySchemaDao_Impl(this);
        }
        return _contentCategorySchemaDao;
      }
    }
  }

  @Override
  public ContentCategoryDao getContentCategoryDao() {
    if (_contentCategoryDao != null) {
      return _contentCategoryDao;
    } else {
      synchronized(this) {
        if(_contentCategoryDao == null) {
          _contentCategoryDao = new ContentCategoryDao_Impl(this);
        }
        return _contentCategoryDao;
      }
    }
  }

  @Override
  public LanguageDao getLanguageDao() {
    if (_languageDao != null) {
      return _languageDao;
    } else {
      synchronized(this) {
        if(_languageDao == null) {
          _languageDao = new LanguageDao_Impl(this);
        }
        return _languageDao;
      }
    }
  }

  @Override
  public LanguageVariantDao getLanguageVariantDao() {
    if (_languageVariantDao != null) {
      return _languageVariantDao;
    } else {
      synchronized(this) {
        if(_languageVariantDao == null) {
          _languageVariantDao = new LanguageVariantDao_Impl(this);
        }
        return _languageVariantDao;
      }
    }
  }

  @Override
  public ScrapeQueueItemDao getScrapeQueueItemDao() {
    if (_scrapeQueueItemDao != null) {
      return _scrapeQueueItemDao;
    } else {
      synchronized(this) {
        if(_scrapeQueueItemDao == null) {
          _scrapeQueueItemDao = new ScrapeQueueItemDao_Impl(this);
        }
        return _scrapeQueueItemDao;
      }
    }
  }

  @Override
  public PersonAuthDao getPersonAuthDao() {
    if (_personAuthDao != null) {
      return _personAuthDao;
    } else {
      synchronized(this) {
        if(_personAuthDao == null) {
          _personAuthDao = new PersonAuthDao_Impl(this);
        }
        return _personAuthDao;
      }
    }
  }

  @Override
  public PersonGroupDao getPersonGroupDao() {
    if (_personGroupDao != null) {
      return _personGroupDao;
    } else {
      synchronized(this) {
        if(_personGroupDao == null) {
          _personGroupDao = new PersonGroupDao_Impl(this);
        }
        return _personGroupDao;
      }
    }
  }

  @Override
  public PersonGroupMemberDao getPersonGroupMemberDao() {
    if (_personGroupMemberDao != null) {
      return _personGroupMemberDao;
    } else {
      synchronized(this) {
        if(_personGroupMemberDao == null) {
          _personGroupMemberDao = new PersonGroupMemberDao_Impl(this);
        }
        return _personGroupMemberDao;
      }
    }
  }

  @Override
  public EntityRoleDao getEntityRoleDao() {
    if (_entityRoleDao != null) {
      return _entityRoleDao;
    } else {
      synchronized(this) {
        if(_entityRoleDao == null) {
          _entityRoleDao = new EntityRoleDao_Impl(this);
        }
        return _entityRoleDao;
      }
    }
  }

  @Override
  public PersonPictureDao getPersonPictureDao() {
    if (_personPictureDao != null) {
      return _personPictureDao;
    } else {
      synchronized(this) {
        if(_personPictureDao == null) {
          _personPictureDao = new PersonPictureDao_Impl(this);
        }
        return _personPictureDao;
      }
    }
  }

  @Override
  public ConnectivityStatusDao getConnectivityStatusDao() {
    if (_connectivityStatusDao != null) {
      return _connectivityStatusDao;
    } else {
      synchronized(this) {
        if(_connectivityStatusDao == null) {
          _connectivityStatusDao = new ConnectivityStatusDao_Impl(this);
        }
        return _connectivityStatusDao;
      }
    }
  }

  @Override
  public ContainerDao getContainerDao() {
    if (_containerDao != null) {
      return _containerDao;
    } else {
      synchronized(this) {
        if(_containerDao == null) {
          _containerDao = new ContainerDao_Impl(this);
        }
        return _containerDao;
      }
    }
  }

  @Override
  public ContainerEntryDao getContainerEntryDao() {
    if (_containerEntryDao != null) {
      return _containerEntryDao;
    } else {
      synchronized(this) {
        if(_containerEntryDao == null) {
          _containerEntryDao = new ContainerEntryDao_Impl(this);
        }
        return _containerEntryDao;
      }
    }
  }

  @Override
  public ContainerEntryFileDao getContainerEntryFileDao() {
    if (_containerEntryFileDao != null) {
      return _containerEntryFileDao;
    } else {
      synchronized(this) {
        if(_containerEntryFileDao == null) {
          _containerEntryFileDao = new ContainerEntryFileDao_Impl(this);
        }
        return _containerEntryFileDao;
      }
    }
  }

  @Override
  public ContainerETagDao getContainerETagDao() {
    if (_containerETagDao != null) {
      return _containerETagDao;
    } else {
      synchronized(this) {
        if(_containerETagDao == null) {
          _containerETagDao = new ContainerETagDao_Impl(this);
        }
        return _containerETagDao;
      }
    }
  }

  @Override
  public VerbDao getVerbDao() {
    if (_verbDao != null) {
      return _verbDao;
    } else {
      synchronized(this) {
        if(_verbDao == null) {
          _verbDao = new VerbDao_Impl(this);
        }
        return _verbDao;
      }
    }
  }

  @Override
  public XObjectDao getXObjectDao() {
    if (_xObjectDao != null) {
      return _xObjectDao;
    } else {
      synchronized(this) {
        if(_xObjectDao == null) {
          _xObjectDao = new XObjectDao_Impl(this);
        }
        return _xObjectDao;
      }
    }
  }

  @Override
  public ReportDao getReportDao() {
    if (_reportDao != null) {
      return _reportDao;
    } else {
      synchronized(this) {
        if(_reportDao == null) {
          _reportDao = new ReportDao_Impl(this);
        }
        return _reportDao;
      }
    }
  }

  @Override
  public ContainerImportJobDao getContainerImportJobDao() {
    if (_containerImportJobDao != null) {
      return _containerImportJobDao;
    } else {
      synchronized(this) {
        if(_containerImportJobDao == null) {
          _containerImportJobDao = new ContainerImportJobDao_Impl(this);
        }
        return _containerImportJobDao;
      }
    }
  }

  @Override
  public StatementDao getStatementDao() {
    if (_statementDao != null) {
      return _statementDao;
    } else {
      synchronized(this) {
        if(_statementDao == null) {
          _statementDao = new StatementDao_Impl(this);
        }
        return _statementDao;
      }
    }
  }

  @Override
  public ContextXObjectStatementJoinDao getContextXObjectStatementJoinDao() {
    if (_contextXObjectStatementJoinDao != null) {
      return _contextXObjectStatementJoinDao;
    } else {
      synchronized(this) {
        if(_contextXObjectStatementJoinDao == null) {
          _contextXObjectStatementJoinDao = new ContextXObjectStatementJoinDao_Impl(this);
        }
        return _contextXObjectStatementJoinDao;
      }
    }
  }

  @Override
  public StateDao getStateDao() {
    if (_stateDao != null) {
      return _stateDao;
    } else {
      synchronized(this) {
        if(_stateDao == null) {
          _stateDao = new StateDao_Impl(this);
        }
        return _stateDao;
      }
    }
  }

  @Override
  public StateContentDao getStateContentDao() {
    if (_stateContentDao != null) {
      return _stateContentDao;
    } else {
      synchronized(this) {
        if(_stateContentDao == null) {
          _stateContentDao = new StateContentDao_Impl(this);
        }
        return _stateContentDao;
      }
    }
  }

  @Override
  public AgentDao getAgentDao() {
    if (_agentDao != null) {
      return _agentDao;
    } else {
      synchronized(this) {
        if(_agentDao == null) {
          _agentDao = new AgentDao_Impl(this);
        }
        return _agentDao;
      }
    }
  }

  @Override
  public LearnerGroupDao getLearnerGroupDao() {
    if (_learnerGroupDao != null) {
      return _learnerGroupDao;
    } else {
      synchronized(this) {
        if(_learnerGroupDao == null) {
          _learnerGroupDao = new LearnerGroupDao_Impl(this);
        }
        return _learnerGroupDao;
      }
    }
  }

  @Override
  public LearnerGroupMemberDao getLearnerGroupMemberDao() {
    if (_learnerGroupMemberDao != null) {
      return _learnerGroupMemberDao;
    } else {
      synchronized(this) {
        if(_learnerGroupMemberDao == null) {
          _learnerGroupMemberDao = new LearnerGroupMemberDao_Impl(this);
        }
        return _learnerGroupMemberDao;
      }
    }
  }

  @Override
  public GroupLearningSessionDao getGroupLearningSessionDao() {
    if (_groupLearningSessionDao != null) {
      return _groupLearningSessionDao;
    } else {
      synchronized(this) {
        if(_groupLearningSessionDao == null) {
          _groupLearningSessionDao = new GroupLearningSessionDao_Impl(this);
        }
        return _groupLearningSessionDao;
      }
    }
  }

  @Override
  public ClazzLogAttendanceRecordDao getClazzLogAttendanceRecordDao() {
    if (_clazzLogAttendanceRecordDao != null) {
      return _clazzLogAttendanceRecordDao;
    } else {
      synchronized(this) {
        if(_clazzLogAttendanceRecordDao == null) {
          _clazzLogAttendanceRecordDao = new ClazzLogAttendanceRecordDao_Impl(this);
        }
        return _clazzLogAttendanceRecordDao;
      }
    }
  }

  @Override
  public ClazzLogDao getClazzLogDao() {
    if (_clazzLogDao != null) {
      return _clazzLogDao;
    } else {
      synchronized(this) {
        if(_clazzLogDao == null) {
          _clazzLogDao = new ClazzLogDao_Impl(this);
        }
        return _clazzLogDao;
      }
    }
  }

  @Override
  public ScheduleDao getScheduleDao() {
    if (_scheduleDao != null) {
      return _scheduleDao;
    } else {
      synchronized(this) {
        if(_scheduleDao == null) {
          _scheduleDao = new ScheduleDao_Impl(this);
        }
        return _scheduleDao;
      }
    }
  }

  @Override
  public HolidayCalendarDao getHolidayCalendarDao() {
    if (_holidayCalendarDao != null) {
      return _holidayCalendarDao;
    } else {
      synchronized(this) {
        if(_holidayCalendarDao == null) {
          _holidayCalendarDao = new HolidayCalendarDao_Impl(this);
        }
        return _holidayCalendarDao;
      }
    }
  }

  @Override
  public HolidayDao getHolidayDao() {
    if (_holidayDao != null) {
      return _holidayDao;
    } else {
      synchronized(this) {
        if(_holidayDao == null) {
          _holidayDao = new HolidayDao_Impl(this);
        }
        return _holidayDao;
      }
    }
  }

  @Override
  public SchoolDao getSchoolDao() {
    if (_schoolDao != null) {
      return _schoolDao;
    } else {
      synchronized(this) {
        if(_schoolDao == null) {
          _schoolDao = new SchoolDao_Impl(this);
        }
        return _schoolDao;
      }
    }
  }

  @Override
  public XLangMapEntryDao getXLangMapEntryDao() {
    if (_xLangMapEntryDao != null) {
      return _xLangMapEntryDao;
    } else {
      synchronized(this) {
        if(_xLangMapEntryDao == null) {
          _xLangMapEntryDao = new XLangMapEntryDao_Impl(this);
        }
        return _xLangMapEntryDao;
      }
    }
  }

  @Override
  public LocallyAvailableContainerDao getLocallyAvailableContainerDao() {
    if (_locallyAvailableContainerDao != null) {
      return _locallyAvailableContainerDao;
    } else {
      synchronized(this) {
        if(_locallyAvailableContainerDao == null) {
          _locallyAvailableContainerDao = new LocallyAvailableContainerDao_Impl(this);
        }
        return _locallyAvailableContainerDao;
      }
    }
  }

  @Override
  public SchoolMemberDao getSchoolMemberDao() {
    if (_schoolMemberDao != null) {
      return _schoolMemberDao;
    } else {
      synchronized(this) {
        if(_schoolMemberDao == null) {
          _schoolMemberDao = new SchoolMemberDao_Impl(this);
        }
        return _schoolMemberDao;
      }
    }
  }

  @Override
  public ClazzAssignmentDao getClazzAssignmentDao() {
    if (_clazzAssignmentDao != null) {
      return _clazzAssignmentDao;
    } else {
      synchronized(this) {
        if(_clazzAssignmentDao == null) {
          _clazzAssignmentDao = new ClazzAssignmentDao_Impl(this);
        }
        return _clazzAssignmentDao;
      }
    }
  }

  @Override
  public ClazzAssignmentContentJoinDao getClazzAssignmentContentJoinDao() {
    if (_clazzAssignmentContentJoinDao != null) {
      return _clazzAssignmentContentJoinDao;
    } else {
      synchronized(this) {
        if(_clazzAssignmentContentJoinDao == null) {
          _clazzAssignmentContentJoinDao = new ClazzAssignmentContentJoinDao_Impl(this);
        }
        return _clazzAssignmentContentJoinDao;
      }
    }
  }

  @Override
  public ClazzAssignmentRollUpDao getClazzAssignmentRollUpDao() {
    if (_clazzAssignmentRollUpDao != null) {
      return _clazzAssignmentRollUpDao;
    } else {
      synchronized(this) {
        if(_clazzAssignmentRollUpDao == null) {
          _clazzAssignmentRollUpDao = new ClazzAssignmentRollUpDao_Impl(this);
        }
        return _clazzAssignmentRollUpDao;
      }
    }
  }

  @Override
  public CourseAssignmentSubmissionDao getCourseAssignmentSubmissionDao() {
    if (_courseAssignmentSubmissionDao != null) {
      return _courseAssignmentSubmissionDao;
    } else {
      synchronized(this) {
        if(_courseAssignmentSubmissionDao == null) {
          _courseAssignmentSubmissionDao = new CourseAssignmentSubmissionDao_Impl(this);
        }
        return _courseAssignmentSubmissionDao;
      }
    }
  }

  @Override
  public CourseAssignmentSubmissionAttachmentDao getCourseAssignmentSubmissionAttachmentDao() {
    if (_courseAssignmentSubmissionAttachmentDao != null) {
      return _courseAssignmentSubmissionAttachmentDao;
    } else {
      synchronized(this) {
        if(_courseAssignmentSubmissionAttachmentDao == null) {
          _courseAssignmentSubmissionAttachmentDao = new CourseAssignmentSubmissionAttachmentDao_Impl(this);
        }
        return _courseAssignmentSubmissionAttachmentDao;
      }
    }
  }

  @Override
  public CourseAssignmentMarkDao getCourseAssignmentMarkDao() {
    if (_courseAssignmentMarkDao != null) {
      return _courseAssignmentMarkDao;
    } else {
      synchronized(this) {
        if(_courseAssignmentMarkDao == null) {
          _courseAssignmentMarkDao = new CourseAssignmentMarkDao_Impl(this);
        }
        return _courseAssignmentMarkDao;
      }
    }
  }

  @Override
  public CommentsDao getCommentsDao() {
    if (_commentsDao != null) {
      return _commentsDao;
    } else {
      synchronized(this) {
        if(_commentsDao == null) {
          _commentsDao = new CommentsDao_Impl(this);
        }
        return _commentsDao;
      }
    }
  }

  @Override
  public SyncNodeDao getSyncNodeDao() {
    if (_syncNodeDao != null) {
      return _syncNodeDao;
    } else {
      synchronized(this) {
        if(_syncNodeDao == null) {
          _syncNodeDao = new SyncNodeDao_Impl(this);
        }
        return _syncNodeDao;
      }
    }
  }

  @Override
  public SiteDao getSiteDao() {
    if (_siteDao != null) {
      return _siteDao;
    } else {
      synchronized(this) {
        if(_siteDao == null) {
          _siteDao = new SiteDao_Impl(this);
        }
        return _siteDao;
      }
    }
  }

  @Override
  public SiteTermsDao getSiteTermsDao() {
    if (_siteTermsDao != null) {
      return _siteTermsDao;
    } else {
      synchronized(this) {
        if(_siteTermsDao == null) {
          _siteTermsDao = new SiteTermsDao_Impl(this);
        }
        return _siteTermsDao;
      }
    }
  }

  @Override
  public PersonParentJoinDao getPersonParentJoinDao() {
    if (_personParentJoinDao != null) {
      return _personParentJoinDao;
    } else {
      synchronized(this) {
        if(_personParentJoinDao == null) {
          _personParentJoinDao = new PersonParentJoinDao_Impl(this);
        }
        return _personParentJoinDao;
      }
    }
  }

  @Override
  public ScopedGrantDao getScopedGrantDao() {
    if (_scopedGrantDao != null) {
      return _scopedGrantDao;
    } else {
      synchronized(this) {
        if(_scopedGrantDao == null) {
          _scopedGrantDao = new ScopedGrantDao_Impl(this);
        }
        return _scopedGrantDao;
      }
    }
  }

  @Override
  public ErrorReportDao getErrorReportDao() {
    if (_errorReportDao != null) {
      return _errorReportDao;
    } else {
      synchronized(this) {
        if(_errorReportDao == null) {
          _errorReportDao = new ErrorReportDao_Impl(this);
        }
        return _errorReportDao;
      }
    }
  }

  @Override
  public PersonAuth2Dao getPersonAuth2Dao() {
    if (_personAuth2Dao != null) {
      return _personAuth2Dao;
    } else {
      synchronized(this) {
        if(_personAuth2Dao == null) {
          _personAuth2Dao = new PersonAuth2Dao_Impl(this);
        }
        return _personAuth2Dao;
      }
    }
  }

  @Override
  public UserSessionDao getUserSessionDao() {
    if (_userSessionDao != null) {
      return _userSessionDao;
    } else {
      synchronized(this) {
        if(_userSessionDao == null) {
          _userSessionDao = new UserSessionDao_Impl(this);
        }
        return _userSessionDao;
      }
    }
  }

  @Override
  public ContentJobItemDao getContentJobItemDao() {
    if (_contentJobItemDao != null) {
      return _contentJobItemDao;
    } else {
      synchronized(this) {
        if(_contentJobItemDao == null) {
          _contentJobItemDao = new ContentJobItemDao_Impl(this);
        }
        return _contentJobItemDao;
      }
    }
  }

  @Override
  public ContentJobDao getContentJobDao() {
    if (_contentJobDao != null) {
      return _contentJobDao;
    } else {
      synchronized(this) {
        if(_contentJobDao == null) {
          _contentJobDao = new ContentJobDao_Impl(this);
        }
        return _contentJobDao;
      }
    }
  }

  @Override
  public CoursePictureDao getCoursePictureDao() {
    if (_coursePictureDao != null) {
      return _coursePictureDao;
    } else {
      synchronized(this) {
        if(_coursePictureDao == null) {
          _coursePictureDao = new CoursePictureDao_Impl(this);
        }
        return _coursePictureDao;
      }
    }
  }

  @Override
  public ContentEntryPictureDao getContentEntryPictureDao() {
    if (_contentEntryPictureDao != null) {
      return _contentEntryPictureDao;
    } else {
      synchronized(this) {
        if(_contentEntryPictureDao == null) {
          _contentEntryPictureDao = new ContentEntryPictureDao_Impl(this);
        }
        return _contentEntryPictureDao;
      }
    }
  }

  @Override
  public ChatDao getChatDao() {
    if (_chatDao != null) {
      return _chatDao;
    } else {
      synchronized(this) {
        if(_chatDao == null) {
          _chatDao = new ChatDao_Impl(this);
        }
        return _chatDao;
      }
    }
  }

  @Override
  public ChatMemberDao getChatMemberDao() {
    if (_chatMemberDao != null) {
      return _chatMemberDao;
    } else {
      synchronized(this) {
        if(_chatMemberDao == null) {
          _chatMemberDao = new ChatMemberDao_Impl(this);
        }
        return _chatMemberDao;
      }
    }
  }

  @Override
  public MessageDao getMessageDao() {
    if (_messageDao != null) {
      return _messageDao;
    } else {
      synchronized(this) {
        if(_messageDao == null) {
          _messageDao = new MessageDao_Impl(this);
        }
        return _messageDao;
      }
    }
  }

  @Override
  public MessageReadDao getMessageReadDao() {
    if (_messageReadDao != null) {
      return _messageReadDao;
    } else {
      synchronized(this) {
        if(_messageReadDao == null) {
          _messageReadDao = new MessageReadDao_Impl(this);
        }
        return _messageReadDao;
      }
    }
  }

  @Override
  public CourseDiscussionDao getCourseDiscussionDao() {
    if (_courseDiscussionDao != null) {
      return _courseDiscussionDao;
    } else {
      synchronized(this) {
        if(_courseDiscussionDao == null) {
          _courseDiscussionDao = new CourseDiscussionDao_Impl(this);
        }
        return _courseDiscussionDao;
      }
    }
  }

  @Override
  public DiscussionTopicDao getDiscussionTopicDao() {
    if (_discussionTopicDao != null) {
      return _discussionTopicDao;
    } else {
      synchronized(this) {
        if(_discussionTopicDao == null) {
          _discussionTopicDao = new DiscussionTopicDao_Impl(this);
        }
        return _discussionTopicDao;
      }
    }
  }

  @Override
  public DiscussionPostDao getDiscussionPostDao() {
    if (_discussionPostDao != null) {
      return _discussionPostDao;
    } else {
      synchronized(this) {
        if(_discussionPostDao == null) {
          _discussionPostDao = new DiscussionPostDao_Impl(this);
        }
        return _discussionPostDao;
      }
    }
  }
}
