package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecord;
import com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecordWithPerson;
import com.ustadmobile.lib.db.entities.Person;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ClazzLogAttendanceRecordDao_Impl extends ClazzLogAttendanceRecordDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ClazzLogAttendanceRecord> __insertionAdapterOfClazzLogAttendanceRecord;

  private final EntityDeletionOrUpdateAdapter<ClazzLogAttendanceRecord> __updateAdapterOfClazzLogAttendanceRecord;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfUpdateRescheduledClazzLogUids;

  public ClazzLogAttendanceRecordDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfClazzLogAttendanceRecord = new EntityInsertionAdapter<ClazzLogAttendanceRecord>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ClazzLogAttendanceRecord` (`clazzLogAttendanceRecordUid`,`clazzLogAttendanceRecordClazzLogUid`,`clazzLogAttendanceRecordPersonUid`,`attendanceStatus`,`clazzLogAttendanceRecordMasterChangeSeqNum`,`clazzLogAttendanceRecordLocalChangeSeqNum`,`clazzLogAttendanceRecordLastChangedBy`,`clazzLogAttendanceRecordLastChangedTime`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ClazzLogAttendanceRecord value) {
        stmt.bindLong(1, value.getClazzLogAttendanceRecordUid());
        stmt.bindLong(2, value.getClazzLogAttendanceRecordClazzLogUid());
        stmt.bindLong(3, value.getClazzLogAttendanceRecordPersonUid());
        stmt.bindLong(4, value.getAttendanceStatus());
        stmt.bindLong(5, value.getClazzLogAttendanceRecordMasterChangeSeqNum());
        stmt.bindLong(6, value.getClazzLogAttendanceRecordLocalChangeSeqNum());
        stmt.bindLong(7, value.getClazzLogAttendanceRecordLastChangedBy());
        stmt.bindLong(8, value.getClazzLogAttendanceRecordLastChangedTime());
      }
    };
    this.__updateAdapterOfClazzLogAttendanceRecord = new EntityDeletionOrUpdateAdapter<ClazzLogAttendanceRecord>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ClazzLogAttendanceRecord` SET `clazzLogAttendanceRecordUid` = ?,`clazzLogAttendanceRecordClazzLogUid` = ?,`clazzLogAttendanceRecordPersonUid` = ?,`attendanceStatus` = ?,`clazzLogAttendanceRecordMasterChangeSeqNum` = ?,`clazzLogAttendanceRecordLocalChangeSeqNum` = ?,`clazzLogAttendanceRecordLastChangedBy` = ?,`clazzLogAttendanceRecordLastChangedTime` = ? WHERE `clazzLogAttendanceRecordUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ClazzLogAttendanceRecord value) {
        stmt.bindLong(1, value.getClazzLogAttendanceRecordUid());
        stmt.bindLong(2, value.getClazzLogAttendanceRecordClazzLogUid());
        stmt.bindLong(3, value.getClazzLogAttendanceRecordPersonUid());
        stmt.bindLong(4, value.getAttendanceStatus());
        stmt.bindLong(5, value.getClazzLogAttendanceRecordMasterChangeSeqNum());
        stmt.bindLong(6, value.getClazzLogAttendanceRecordLocalChangeSeqNum());
        stmt.bindLong(7, value.getClazzLogAttendanceRecordLastChangedBy());
        stmt.bindLong(8, value.getClazzLogAttendanceRecordLastChangedTime());
        stmt.bindLong(9, value.getClazzLogAttendanceRecordUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO ClazzLogAttendanceRecordReplicate(clarPk, clarDestination)\n"
                + "      SELECT DISTINCT ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid AS clarUid,\n"
                + "             ? AS clarDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember \n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                  2048 \n"
                + "                  \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "             JOIN ClazzLog\n"
                + "                  ON ClazzLog.clazzLogClazzUid = Clazz.clazzUid\n"
                + "             JOIN ClazzLogAttendanceRecord \n"
                + "                  ON ClazzLogAttendanceRecord.clazzLogAttendanceRecordClazzLogUid = ClazzLog.clazzLogUid\n"
                + "       WHERE ClazzLogAttendanceRecord.clazzLogAttendanceRecordLastChangedTime != COALESCE(\n"
                + "             (SELECT clarVersionId\n"
                + "                FROM ClazzLogAttendanceRecordReplicate\n"
                + "               WHERE clarPk = ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid\n"
                + "                 AND clarDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(clarPk, clarDestination) DO UPDATE\n"
                + "             SET clarPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ClazzLogAttendanceRecordReplicate(clarPk, clarDestination)\n"
                + "  SELECT DISTINCT ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid AS clarUid,\n"
                + "         UserSession.usClientNodeId AS clarDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN ClazzLogAttendanceRecord \n"
                + "              ON ChangeLog.chTableId = 15 \n"
                + "             AND ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid = ChangeLog.chEntityPk\n"
                + "         JOIN ClazzLog\n"
                + "              ON ClazzLog.clazzLogUid = ClazzLogAttendanceRecord.clazzLogAttendanceRecordClazzLogUid\n"
                + "         JOIN Clazz \n"
                + "              ON Clazz.clazzUid = ClazzLog.clazzLogClazzUid \n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              2\n"
                + "              \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND ClazzLogAttendanceRecord.clazzLogAttendanceRecordLastChangedTime != COALESCE(\n"
                + "             (SELECT clarVersionId\n"
                + "                FROM ClazzLogAttendanceRecordReplicate\n"
                + "               WHERE clarPk = ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid\n"
                + "                 AND clarDestination = UserSession.usClientNodeId), 0) \n"
                + " /*psql ON CONFLICT(clarPk, clarDestination) DO UPDATE\n"
                + "     SET clarPending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateRescheduledClazzLogUids = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ClazzLogAttendanceRecord\n"
                + "           SET clazzLogAttendanceRecordClazzLogUid = ?,\n"
                + "               clazzLogAttendanceRecordLastChangedTime = ?\n"
                + "        WHERE clazzLogAttendanceRecordClazzLogUid = ?\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ClazzLogAttendanceRecord entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfClazzLogAttendanceRecord.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ClazzLogAttendanceRecord entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfClazzLogAttendanceRecord.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ClazzLogAttendanceRecord> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfClazzLogAttendanceRecord.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends ClazzLogAttendanceRecord> entities,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfClazzLogAttendanceRecord.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void updateList(final List<? extends ClazzLogAttendanceRecord> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazzLogAttendanceRecord.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ClazzLogAttendanceRecord entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfClazzLogAttendanceRecord.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateListAsync(final List<? extends ClazzLogAttendanceRecord> entities,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfClazzLogAttendanceRecord.handleMultiple(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public void updateRescheduledClazzLogUids(final long oldClazzLogUid, final long newClazzLogUid,
      final long changedTime) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateRescheduledClazzLogUids.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, newClazzLogUid);
    _argIndex = 2;
    _stmt.bindLong(_argIndex, changedTime);
    _argIndex = 3;
    _stmt.bindLong(_argIndex, oldClazzLogUid);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfUpdateRescheduledClazzLogUids.release(_stmt);
    }
  }

  @Override
  public ClazzLogAttendanceRecord findByUid(final long uid) {
    final String _sql = "SELECT * from ClazzLogAttendanceRecord WHERE clazzLogAttendanceRecordUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfClazzLogAttendanceRecordUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordUid");
      final int _cursorIndexOfClazzLogAttendanceRecordClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordClazzLogUid");
      final int _cursorIndexOfClazzLogAttendanceRecordPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordPersonUid");
      final int _cursorIndexOfAttendanceStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceStatus");
      final int _cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordMasterChangeSeqNum");
      final int _cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordLocalChangeSeqNum");
      final int _cursorIndexOfClazzLogAttendanceRecordLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordLastChangedBy");
      final int _cursorIndexOfClazzLogAttendanceRecordLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordLastChangedTime");
      final ClazzLogAttendanceRecord _result;
      if(_cursor.moveToFirst()) {
        _result = new ClazzLogAttendanceRecord();
        final long _tmpClazzLogAttendanceRecordUid;
        _tmpClazzLogAttendanceRecordUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordUid);
        _result.setClazzLogAttendanceRecordUid(_tmpClazzLogAttendanceRecordUid);
        final long _tmpClazzLogAttendanceRecordClazzLogUid;
        _tmpClazzLogAttendanceRecordClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordClazzLogUid);
        _result.setClazzLogAttendanceRecordClazzLogUid(_tmpClazzLogAttendanceRecordClazzLogUid);
        final long _tmpClazzLogAttendanceRecordPersonUid;
        _tmpClazzLogAttendanceRecordPersonUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordPersonUid);
        _result.setClazzLogAttendanceRecordPersonUid(_tmpClazzLogAttendanceRecordPersonUid);
        final int _tmpAttendanceStatus;
        _tmpAttendanceStatus = _cursor.getInt(_cursorIndexOfAttendanceStatus);
        _result.setAttendanceStatus(_tmpAttendanceStatus);
        final long _tmpClazzLogAttendanceRecordMasterChangeSeqNum;
        _tmpClazzLogAttendanceRecordMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum);
        _result.setClazzLogAttendanceRecordMasterChangeSeqNum(_tmpClazzLogAttendanceRecordMasterChangeSeqNum);
        final long _tmpClazzLogAttendanceRecordLocalChangeSeqNum;
        _tmpClazzLogAttendanceRecordLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum);
        _result.setClazzLogAttendanceRecordLocalChangeSeqNum(_tmpClazzLogAttendanceRecordLocalChangeSeqNum);
        final int _tmpClazzLogAttendanceRecordLastChangedBy;
        _tmpClazzLogAttendanceRecordLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLogAttendanceRecordLastChangedBy);
        _result.setClazzLogAttendanceRecordLastChangedBy(_tmpClazzLogAttendanceRecordLastChangedBy);
        final long _tmpClazzLogAttendanceRecordLastChangedTime;
        _tmpClazzLogAttendanceRecordLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLastChangedTime);
        _result.setClazzLogAttendanceRecordLastChangedTime(_tmpClazzLogAttendanceRecordLastChangedTime);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByClazzLogUid(final long clazzLogUid,
      final Continuation<? super List<ClazzLogAttendanceRecordWithPerson>> continuation) {
    final String _sql = "SELECT ClazzLogAttendanceRecord.*, Person.*\n"
            + "         FROM ClazzLogAttendanceRecord \n"
            + "         LEFT JOIN Person ON ClazzLogAttendanceRecord.clazzLogAttendanceRecordPersonUid = Person.personUid\n"
            + "         WHERE clazzLogAttendanceRecordClazzLogUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzLogUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ClazzLogAttendanceRecordWithPerson>>() {
      @Override
      public List<ClazzLogAttendanceRecordWithPerson> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfClazzLogAttendanceRecordUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordUid");
          final int _cursorIndexOfClazzLogAttendanceRecordClazzLogUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordClazzLogUid");
          final int _cursorIndexOfClazzLogAttendanceRecordPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordPersonUid");
          final int _cursorIndexOfAttendanceStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "attendanceStatus");
          final int _cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordMasterChangeSeqNum");
          final int _cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordLocalChangeSeqNum");
          final int _cursorIndexOfClazzLogAttendanceRecordLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordLastChangedBy");
          final int _cursorIndexOfClazzLogAttendanceRecordLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "clazzLogAttendanceRecordLastChangedTime");
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final List<ClazzLogAttendanceRecordWithPerson> _result = new ArrayList<ClazzLogAttendanceRecordWithPerson>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ClazzLogAttendanceRecordWithPerson _item;
            final Person _tmpPerson;
            if (! (_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType))) {
              _tmpPerson = new Person();
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              _tmpPerson.setPersonUid(_tmpPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              _tmpPerson.setUsername(_tmpUsername);
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              _tmpPerson.setFirstNames(_tmpFirstNames);
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              _tmpPerson.setLastName(_tmpLastName);
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              _tmpPerson.setEmailAddr(_tmpEmailAddr);
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              _tmpPerson.setPhoneNum(_tmpPhoneNum);
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              _tmpPerson.setGender(_tmpGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              _tmpPerson.setActive(_tmpActive);
              final boolean _tmpAdmin;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_1 != 0;
              _tmpPerson.setAdmin(_tmpAdmin);
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              _tmpPerson.setPersonNotes(_tmpPersonNotes);
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              _tmpPerson.setFatherName(_tmpFatherName);
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              _tmpPerson.setFatherNumber(_tmpFatherNumber);
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              _tmpPerson.setMotherName(_tmpMotherName);
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson.setMotherNum(_tmpMotherNum);
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              _tmpPerson.setDateOfBirth(_tmpDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              _tmpPerson.setPersonAddress(_tmpPersonAddress);
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              _tmpPerson.setPersonOrgId(_tmpPersonOrgId);
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              _tmpPerson.setPersonGroupUid(_tmpPersonGroupUid);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              _tmpPerson.setPersonMasterChangeSeqNum(_tmpPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              _tmpPerson.setPersonLocalChangeSeqNum(_tmpPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              _tmpPerson.setPersonLastChangedBy(_tmpPersonLastChangedBy);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              _tmpPerson.setPersonLct(_tmpPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              _tmpPerson.setPersonCountry(_tmpPersonCountry);
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              _tmpPerson.setPersonType(_tmpPersonType);
            }  else  {
              _tmpPerson = null;
            }
            _item = new ClazzLogAttendanceRecordWithPerson();
            final long _tmpClazzLogAttendanceRecordUid;
            _tmpClazzLogAttendanceRecordUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordUid);
            _item.setClazzLogAttendanceRecordUid(_tmpClazzLogAttendanceRecordUid);
            final long _tmpClazzLogAttendanceRecordClazzLogUid;
            _tmpClazzLogAttendanceRecordClazzLogUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordClazzLogUid);
            _item.setClazzLogAttendanceRecordClazzLogUid(_tmpClazzLogAttendanceRecordClazzLogUid);
            final long _tmpClazzLogAttendanceRecordPersonUid;
            _tmpClazzLogAttendanceRecordPersonUid = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordPersonUid);
            _item.setClazzLogAttendanceRecordPersonUid(_tmpClazzLogAttendanceRecordPersonUid);
            final int _tmpAttendanceStatus;
            _tmpAttendanceStatus = _cursor.getInt(_cursorIndexOfAttendanceStatus);
            _item.setAttendanceStatus(_tmpAttendanceStatus);
            final long _tmpClazzLogAttendanceRecordMasterChangeSeqNum;
            _tmpClazzLogAttendanceRecordMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordMasterChangeSeqNum);
            _item.setClazzLogAttendanceRecordMasterChangeSeqNum(_tmpClazzLogAttendanceRecordMasterChangeSeqNum);
            final long _tmpClazzLogAttendanceRecordLocalChangeSeqNum;
            _tmpClazzLogAttendanceRecordLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLocalChangeSeqNum);
            _item.setClazzLogAttendanceRecordLocalChangeSeqNum(_tmpClazzLogAttendanceRecordLocalChangeSeqNum);
            final int _tmpClazzLogAttendanceRecordLastChangedBy;
            _tmpClazzLogAttendanceRecordLastChangedBy = _cursor.getInt(_cursorIndexOfClazzLogAttendanceRecordLastChangedBy);
            _item.setClazzLogAttendanceRecordLastChangedBy(_tmpClazzLogAttendanceRecordLastChangedBy);
            final long _tmpClazzLogAttendanceRecordLastChangedTime;
            _tmpClazzLogAttendanceRecordLastChangedTime = _cursor.getLong(_cursorIndexOfClazzLogAttendanceRecordLastChangedTime);
            _item.setClazzLogAttendanceRecordLastChangedTime(_tmpClazzLogAttendanceRecordLastChangedTime);
            _item.setPerson(_tmpPerson);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
