package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContentEntryPicture;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ContentEntryPictureDao_Impl extends ContentEntryPictureDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContentEntryPicture> __insertionAdapterOfContentEntryPicture;

  private final EntityDeletionOrUpdateAdapter<ContentEntryPicture> __updateAdapterOfContentEntryPicture;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public ContentEntryPictureDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContentEntryPicture = new EntityInsertionAdapter<ContentEntryPicture>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ContentEntryPicture` (`cepUid`,`cepContentEntryUid`,`cepUri`,`cepMd5`,`cepFileSize`,`cepTimestamp`,`cepMimeType`,`cepActive`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentEntryPicture value) {
        stmt.bindLong(1, value.getCepUid());
        stmt.bindLong(2, value.getCepContentEntryUid());
        if (value.getCepUri() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCepUri());
        }
        if (value.getCepMd5() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getCepMd5());
        }
        stmt.bindLong(5, value.getCepFileSize());
        stmt.bindLong(6, value.getCepTimestamp());
        if (value.getCepMimeType() == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, value.getCepMimeType());
        }
        final int _tmp = value.getCepActive() ? 1 : 0;
        stmt.bindLong(8, _tmp);
      }
    };
    this.__updateAdapterOfContentEntryPicture = new EntityDeletionOrUpdateAdapter<ContentEntryPicture>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `ContentEntryPicture` SET `cepUid` = ?,`cepContentEntryUid` = ?,`cepUri` = ?,`cepMd5` = ?,`cepFileSize` = ?,`cepTimestamp` = ?,`cepMimeType` = ?,`cepActive` = ? WHERE `cepUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentEntryPicture value) {
        stmt.bindLong(1, value.getCepUid());
        stmt.bindLong(2, value.getCepContentEntryUid());
        if (value.getCepUri() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getCepUri());
        }
        if (value.getCepMd5() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getCepMd5());
        }
        stmt.bindLong(5, value.getCepFileSize());
        stmt.bindLong(6, value.getCepTimestamp());
        if (value.getCepMimeType() == null) {
          stmt.bindNull(7);
        } else {
          stmt.bindString(7, value.getCepMimeType());
        }
        final int _tmp = value.getCepActive() ? 1 : 0;
        stmt.bindLong(8, _tmp);
        stmt.bindLong(9, value.getCepUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO ContentEntryPictureReplicate(cepPk, cepDestination)\n"
                + "         SELECT DISTINCT cepUid AS cepPK,\n"
                + "                ? AS siteDestination\n"
                + "           FROM ContentEntryPicture\n"
                + "          WHERE ContentEntryPicture.cepTimestamp != COALESCE(\n"
                + "                (SELECT cepVersionId\n"
                + "                   FROM ContentEntryPictureReplicate\n"
                + "                  WHERE cepPk = ContentEntryPicture.cepUid\n"
                + "                    AND cepDestination = ?), -1) \n"
                + "         /*psql ON CONFLICT(cepPk, cepDestination) DO UPDATE\n"
                + "                SET cepPending = true\n"
                + "         */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "  REPLACE INTO ContentEntryPictureReplicate(cepPk, cepDestination)\n"
                + "         SELECT DISTINCT ContentEntryPicture.cepUid AS cepPk,\n"
                + "                UserSession.usClientNodeId AS siteDestination\n"
                + "           FROM ChangeLog\n"
                + "                JOIN ContentEntryPicture\n"
                + "                    ON ChangeLog.chTableId = 138\n"
                + "                       AND ChangeLog.chEntityPk = ContentEntryPicture.cepUid\n"
                + "                JOIN UserSession ON UserSession.usStatus = 1\n"
                + "          WHERE UserSession.usClientNodeId != (\n"
                + "                SELECT nodeClientId \n"
                + "                  FROM SyncNode\n"
                + "                 LIMIT 1)\n"
                + "            AND ContentEntryPicture.cepTimestamp != COALESCE(\n"
                + "                (SELECT cepVersionId\n"
                + "                   FROM ContentEntryPictureReplicate\n"
                + "                  WHERE cepPk = ContentEntryPicture.cepUid\n"
                + "                    AND cepDestination = UserSession.usClientNodeId), 0)     \n"
                + "        /*psql ON CONFLICT(cepPk, cepDestination) DO UPDATE\n"
                + "            SET cepPending = true\n"
                + "         */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final ContentEntryPicture entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfContentEntryPicture.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContentEntryPicture entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfContentEntryPicture.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends ContentEntryPicture> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContentEntryPicture.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends ContentEntryPicture> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentEntryPicture.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ContentEntryPicture entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentEntryPicture.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final ContentEntryPicture ContentEntryPicture,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfContentEntryPicture.handle(ContentEntryPicture);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findByContentEntryUidAsync(final long entryUid,
      final Continuation<? super ContentEntryPicture> continuation) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM ContentEntryPicture \n"
            + "         WHERE cepContentEntryUid = ?\n"
            + "           AND cepActive\n"
            + "      ORDER BY cepTimestamp DESC \n"
            + "         LIMIT 1\n"
            + "         ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentEntryPicture>() {
      @Override
      public ContentEntryPicture call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepUid");
          final int _cursorIndexOfCepContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepContentEntryUid");
          final int _cursorIndexOfCepUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cepUri");
          final int _cursorIndexOfCepMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "cepMd5");
          final int _cursorIndexOfCepFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cepFileSize");
          final int _cursorIndexOfCepTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "cepTimestamp");
          final int _cursorIndexOfCepMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "cepMimeType");
          final int _cursorIndexOfCepActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cepActive");
          final ContentEntryPicture _result;
          if(_cursor.moveToFirst()) {
            _result = new ContentEntryPicture();
            final long _tmpCepUid;
            _tmpCepUid = _cursor.getLong(_cursorIndexOfCepUid);
            _result.setCepUid(_tmpCepUid);
            final long _tmpCepContentEntryUid;
            _tmpCepContentEntryUid = _cursor.getLong(_cursorIndexOfCepContentEntryUid);
            _result.setCepContentEntryUid(_tmpCepContentEntryUid);
            final String _tmpCepUri;
            if (_cursor.isNull(_cursorIndexOfCepUri)) {
              _tmpCepUri = null;
            } else {
              _tmpCepUri = _cursor.getString(_cursorIndexOfCepUri);
            }
            _result.setCepUri(_tmpCepUri);
            final String _tmpCepMd5;
            if (_cursor.isNull(_cursorIndexOfCepMd5)) {
              _tmpCepMd5 = null;
            } else {
              _tmpCepMd5 = _cursor.getString(_cursorIndexOfCepMd5);
            }
            _result.setCepMd5(_tmpCepMd5);
            final int _tmpCepFileSize;
            _tmpCepFileSize = _cursor.getInt(_cursorIndexOfCepFileSize);
            _result.setCepFileSize(_tmpCepFileSize);
            final long _tmpCepTimestamp;
            _tmpCepTimestamp = _cursor.getLong(_cursorIndexOfCepTimestamp);
            _result.setCepTimestamp(_tmpCepTimestamp);
            final String _tmpCepMimeType;
            if (_cursor.isNull(_cursorIndexOfCepMimeType)) {
              _tmpCepMimeType = null;
            } else {
              _tmpCepMimeType = _cursor.getString(_cursorIndexOfCepMimeType);
            }
            _result.setCepMimeType(_tmpCepMimeType);
            final boolean _tmpCepActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCepActive);
            _tmpCepActive = _tmp != 0;
            _result.setCepActive(_tmpCepActive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public LiveData<ContentEntryPicture> findByContentEntryUidLive(final long entryUid) {
    final String _sql = "\n"
            + "         SELECT * \n"
            + "          FROM ContentEntryPicture \n"
            + "         WHERE cepContentEntryUid = ?\n"
            + "           AND cepActive\n"
            + "      ORDER BY cepTimestamp DESC \n"
            + "         LIMIT 1\n"
            + "         ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, entryUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ContentEntryPicture"}, false, new Callable<ContentEntryPicture>() {
      @Override
      public ContentEntryPicture call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCepUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepUid");
          final int _cursorIndexOfCepContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cepContentEntryUid");
          final int _cursorIndexOfCepUri = CursorUtil.getColumnIndexOrThrow(_cursor, "cepUri");
          final int _cursorIndexOfCepMd5 = CursorUtil.getColumnIndexOrThrow(_cursor, "cepMd5");
          final int _cursorIndexOfCepFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "cepFileSize");
          final int _cursorIndexOfCepTimestamp = CursorUtil.getColumnIndexOrThrow(_cursor, "cepTimestamp");
          final int _cursorIndexOfCepMimeType = CursorUtil.getColumnIndexOrThrow(_cursor, "cepMimeType");
          final int _cursorIndexOfCepActive = CursorUtil.getColumnIndexOrThrow(_cursor, "cepActive");
          final ContentEntryPicture _result;
          if(_cursor.moveToFirst()) {
            _result = new ContentEntryPicture();
            final long _tmpCepUid;
            _tmpCepUid = _cursor.getLong(_cursorIndexOfCepUid);
            _result.setCepUid(_tmpCepUid);
            final long _tmpCepContentEntryUid;
            _tmpCepContentEntryUid = _cursor.getLong(_cursorIndexOfCepContentEntryUid);
            _result.setCepContentEntryUid(_tmpCepContentEntryUid);
            final String _tmpCepUri;
            if (_cursor.isNull(_cursorIndexOfCepUri)) {
              _tmpCepUri = null;
            } else {
              _tmpCepUri = _cursor.getString(_cursorIndexOfCepUri);
            }
            _result.setCepUri(_tmpCepUri);
            final String _tmpCepMd5;
            if (_cursor.isNull(_cursorIndexOfCepMd5)) {
              _tmpCepMd5 = null;
            } else {
              _tmpCepMd5 = _cursor.getString(_cursorIndexOfCepMd5);
            }
            _result.setCepMd5(_tmpCepMd5);
            final int _tmpCepFileSize;
            _tmpCepFileSize = _cursor.getInt(_cursorIndexOfCepFileSize);
            _result.setCepFileSize(_tmpCepFileSize);
            final long _tmpCepTimestamp;
            _tmpCepTimestamp = _cursor.getLong(_cursorIndexOfCepTimestamp);
            _result.setCepTimestamp(_tmpCepTimestamp);
            final String _tmpCepMimeType;
            if (_cursor.isNull(_cursorIndexOfCepMimeType)) {
              _tmpCepMimeType = null;
            } else {
              _tmpCepMimeType = _cursor.getString(_cursorIndexOfCepMimeType);
            }
            _result.setCepMimeType(_tmpCepMimeType);
            final boolean _tmpCepActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCepActive);
            _tmpCepActive = _tmp != 0;
            _result.setCepActive(_tmpCepActive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
