package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContentJob;
import com.ustadmobile.lib.db.entities.ContentJobItem;
import com.ustadmobile.lib.db.entities.ContentJobItemAndContentJob;
import com.ustadmobile.lib.db.entities.ContentJobItemProgress;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ContentJobItemDao_Impl extends ContentJobItemDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContentJobItem> __insertionAdapterOfContentJobItem;

  private final SharedSQLiteStatement __preparedStmtOfUpdateItemStatus;

  private final SharedSQLiteStatement __preparedStmtOfUpdateItemProgress;

  private final SharedSQLiteStatement __preparedStmtOfUpdateConnectivityNeeded;

  private final SharedSQLiteStatement __preparedStmtOfUpdateContainerProcessed;

  private final SharedSQLiteStatement __preparedStmtOfUpdateJobItemAttemptCountAndStatus;

  private final SharedSQLiteStatement __preparedStmtOfUpdateStartTimeForJob;

  private final SharedSQLiteStatement __preparedStmtOfUpdateFinishTimeForJob;

  private final SharedSQLiteStatement __preparedStmtOfUpdateContentEntryUid;

  private final SharedSQLiteStatement __preparedStmtOfUpdateContentJobItemContainer;

  private final SharedSQLiteStatement __preparedStmtOfUpdateUploadSessionUuid;

  private final SharedSQLiteStatement __preparedStmtOfUpdateAllStatusesByJobUid;

  public ContentJobItemDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContentJobItem = new EntityInsertionAdapter<ContentJobItem>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `ContentJobItem` (`cjiUid`,`cjiJobUid`,`sourceUri`,`cjiIsLeaf`,`cjiContentEntryUid`,`cjiParentContentEntryUid`,`cjiContainerUid`,`cjiItemProgress`,`cjiItemTotal`,`cjiRecursiveProgress`,`cjiRecursiveTotal`,`cjiStatus`,`cjiRecursiveStatus`,`cjiConnectivityNeeded`,`cjiPluginId`,`cjiAttemptCount`,`cjiParentCjiUid`,`cjiServerJobId`,`cjiStartTime`,`cjiFinishTime`,`cjiUploadSessionUid`,`cjiContentDeletedOnCancellation`,`cjiContainerProcessed`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, ContentJobItem value) {
        stmt.bindLong(1, value.getCjiUid());
        stmt.bindLong(2, value.getCjiJobUid());
        if (value.getSourceUri() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getSourceUri());
        }
        final int _tmp = value.getCjiIsLeaf() ? 1 : 0;
        stmt.bindLong(4, _tmp);
        stmt.bindLong(5, value.getCjiContentEntryUid());
        stmt.bindLong(6, value.getCjiParentContentEntryUid());
        stmt.bindLong(7, value.getCjiContainerUid());
        stmt.bindLong(8, value.getCjiItemProgress());
        stmt.bindLong(9, value.getCjiItemTotal());
        stmt.bindLong(10, value.getCjiRecursiveProgress());
        stmt.bindLong(11, value.getCjiRecursiveTotal());
        stmt.bindLong(12, value.getCjiStatus());
        stmt.bindLong(13, value.getCjiRecursiveStatus());
        final int _tmp_1 = value.getCjiConnectivityNeeded() ? 1 : 0;
        stmt.bindLong(14, _tmp_1);
        stmt.bindLong(15, value.getCjiPluginId());
        stmt.bindLong(16, value.getCjiAttemptCount());
        stmt.bindLong(17, value.getCjiParentCjiUid());
        stmt.bindLong(18, value.getCjiServerJobId());
        stmt.bindLong(19, value.getCjiStartTime());
        stmt.bindLong(20, value.getCjiFinishTime());
        if (value.getCjiUploadSessionUid() == null) {
          stmt.bindNull(21);
        } else {
          stmt.bindString(21, value.getCjiUploadSessionUid());
        }
        final int _tmp_2 = value.getCjiContentDeletedOnCancellation() ? 1 : 0;
        stmt.bindLong(22, _tmp_2);
        final int _tmp_3 = value.getCjiContainerProcessed() ? 1 : 0;
        stmt.bindLong(23, _tmp_3);
      }
    };
    this.__preparedStmtOfUpdateItemStatus = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentJobItem \n"
                + "           SET cjiStatus = ?\n"
                + "         WHERE cjiUid= ?  \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateItemProgress = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentJobItem\n"
                + "           SET cjiItemProgress = ?,\n"
                + "               cjiItemTotal = ?\n"
                + "         WHERE cjiUid = ?     \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateConnectivityNeeded = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentJobItem\n"
                + "           SET cjiConnectivityNeeded = ?\n"
                + "         WHERE cjiUid = ?     \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateContainerProcessed = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentJobItem\n"
                + "           SET cjiContainerProcessed = ?\n"
                + "         WHERE cjiUid = ?   \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateJobItemAttemptCountAndStatus = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentJobItem\n"
                + "           SET cjiStatus = ?,\n"
                + "               cjiAttemptCount = ?\n"
                + "         WHERE cjiUid = ?      \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateStartTimeForJob = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentJobItem\n"
                + "           SET cjiStartTime = ?\n"
                + "         WHERE cjiUid = ?      \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateFinishTimeForJob = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentJobItem\n"
                + "           SET cjiFinishTime = ?\n"
                + "         WHERE cjiUid = ?      \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateContentEntryUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentJobITem\n"
                + "           SET cjiContentEntryUid = ?\n"
                + "         WHERE cjiUid = ?  \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateContentJobItemContainer = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentJobItem\n"
                + "           SET cjiContainerUid = ?\n"
                + "         WHERE cjiUid = ?  \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateUploadSessionUuid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentJobItem\n"
                + "           SET cjiUploadSessionUid = ?\n"
                + "         WHERE cjiUid = ?  \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateAllStatusesByJobUid = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ContentJobItem\n"
                + "           SET cjiStatus = ?\n"
                + "         WHERE cjiJobUid = ?\n"
                + "           AND cjiStatus != ?\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertJobItem(final ContentJobItem jobItem,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfContentJobItem.insertAndReturnId(jobItem);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object insertJobItems(final List<ContentJobItem> jobItems,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfContentJobItem.insert(jobItems);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object updateItemStatus(final long cjiUid, final int status,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateItemStatus.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, status);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, cjiUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateItemStatus.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateItemProgress(final long cjiUid, final long cjiProgress, final long cjiTotal,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateItemProgress.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, cjiProgress);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, cjiTotal);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, cjiUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateItemProgress.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateConnectivityNeeded(final long contentJobItemId,
      final boolean connectivityNeeded, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateConnectivityNeeded.acquire();
        int _argIndex = 1;
        final int _tmp = connectivityNeeded ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, contentJobItemId);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateConnectivityNeeded.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateContainerProcessed(final long contentJobItemId,
      final boolean cjiContainerProcessed, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateContainerProcessed.acquire();
        int _argIndex = 1;
        final int _tmp = cjiContainerProcessed ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, contentJobItemId);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateContainerProcessed.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateJobItemAttemptCountAndStatus(final long cjiUid, final int attemptCount,
      final int status, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateJobItemAttemptCountAndStatus.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, status);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, attemptCount);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, cjiUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateJobItemAttemptCountAndStatus.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateStartTimeForJob(final long cjiUid, final long startTime,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateStartTimeForJob.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, startTime);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, cjiUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateStartTimeForJob.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateFinishTimeForJob(final long cjiUid, final long finishTime,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateFinishTimeForJob.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, finishTime);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, cjiUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateFinishTimeForJob.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateContentEntryUid(final long cjiUid, final long contentEntryUid,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateContentEntryUid.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, contentEntryUid);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, cjiUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateContentEntryUid.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateContentJobItemContainer(final long cjiUid, final long containerUid,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateContentJobItemContainer.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, containerUid);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, cjiUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateContentJobItemContainer.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateUploadSessionUuid(final long cjiUid, final String uploadSessionUuid,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateUploadSessionUuid.acquire();
        int _argIndex = 1;
        if (uploadSessionUuid == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, uploadSessionUuid);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, cjiUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateUploadSessionUuid.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateAllStatusesByJobUid(final long jobUid, final int newStatus,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateAllStatusesByJobUid.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newStatus);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, jobUid);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newStatus);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateAllStatusesByJobUid.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findNextItemsInQueue(final long contentJobUid, final int limit,
      final Continuation<? super List<ContentJobItemAndContentJob>> continuation) {
    final String _sql = "\n"
            + "        WITH ConnectivityStateCte(state) AS \n"
            + "             (SELECT COALESCE(\n"
            + "                     (SELECT connectivityState \n"
            + "                        FROM ConnectivityStatus \n"
            + "                       LIMIT 1), 0))\n"
            + "                       \n"
            + "        SELECT ContentJobItem.*, ContentJob.*\n"
            + "          FROM ContentJobItem\n"
            + "               JOIN ContentJob\n"
            + "               ON ContentJobItem.cjiJobUid = ContentJob.cjUid\n"
            + "         WHERE ContentJobItem.cjiJobUid = ?\n"
            + "           AND (ContentJobItem.cjiStatus = 4 OR \n"
            + "                ContentJobItem.cjiStatus = 5)\n"
            + "           AND (\n"
            + "                NOT cjiConnectivityNeeded \n"
            + "                OR ((SELECT state FROM ConnectivityStateCte) = 4) \n"
            + "                OR (cjIsMeteredAllowed \n"
            + "                    AND (SELECT state FROM ConnectivityStateCte) = 3)\n"
            + "                )\n"
            + "         LIMIT ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentJobUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, limit);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContentJobItemAndContentJob>>() {
      @Override
      public List<ContentJobItemAndContentJob> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiUid");
          final int _cursorIndexOfCjiJobUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiJobUid");
          final int _cursorIndexOfSourceUri = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUri");
          final int _cursorIndexOfCjiIsLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiIsLeaf");
          final int _cursorIndexOfCjiContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContentEntryUid");
          final int _cursorIndexOfCjiParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiParentContentEntryUid");
          final int _cursorIndexOfCjiContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContainerUid");
          final int _cursorIndexOfCjiItemProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiItemProgress");
          final int _cursorIndexOfCjiItemTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiItemTotal");
          final int _cursorIndexOfCjiRecursiveProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveProgress");
          final int _cursorIndexOfCjiRecursiveTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveTotal");
          final int _cursorIndexOfCjiStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiStatus");
          final int _cursorIndexOfCjiRecursiveStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveStatus");
          final int _cursorIndexOfCjiConnectivityNeeded = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiConnectivityNeeded");
          final int _cursorIndexOfCjiPluginId = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiPluginId");
          final int _cursorIndexOfCjiAttemptCount = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiAttemptCount");
          final int _cursorIndexOfCjiParentCjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiParentCjiUid");
          final int _cursorIndexOfCjiServerJobId = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiServerJobId");
          final int _cursorIndexOfCjiStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiStartTime");
          final int _cursorIndexOfCjiFinishTime = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiFinishTime");
          final int _cursorIndexOfCjiUploadSessionUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiUploadSessionUid");
          final int _cursorIndexOfCjiContentDeletedOnCancellation = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContentDeletedOnCancellation");
          final int _cursorIndexOfCjiContainerProcessed = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContainerProcessed");
          final int _cursorIndexOfCjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjUid");
          final int _cursorIndexOfToUri = CursorUtil.getColumnIndexOrThrow(_cursor, "toUri");
          final int _cursorIndexOfCjProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjProgress");
          final int _cursorIndexOfCjTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjTotal");
          final int _cursorIndexOfCjNotificationTitle = CursorUtil.getColumnIndexOrThrow(_cursor, "cjNotificationTitle");
          final int _cursorIndexOfCjIsMeteredAllowed = CursorUtil.getColumnIndexOrThrow(_cursor, "cjIsMeteredAllowed");
          final int _cursorIndexOfParams = CursorUtil.getColumnIndexOrThrow(_cursor, "params");
          final List<ContentJobItemAndContentJob> _result = new ArrayList<ContentJobItemAndContentJob>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContentJobItemAndContentJob _item;
            final ContentJobItem _tmpContentJobItem;
            if (! (_cursor.isNull(_cursorIndexOfCjiUid) && _cursor.isNull(_cursorIndexOfCjiJobUid) && _cursor.isNull(_cursorIndexOfSourceUri) && _cursor.isNull(_cursorIndexOfCjiIsLeaf) && _cursor.isNull(_cursorIndexOfCjiContentEntryUid) && _cursor.isNull(_cursorIndexOfCjiParentContentEntryUid) && _cursor.isNull(_cursorIndexOfCjiContainerUid) && _cursor.isNull(_cursorIndexOfCjiItemProgress) && _cursor.isNull(_cursorIndexOfCjiItemTotal) && _cursor.isNull(_cursorIndexOfCjiRecursiveProgress) && _cursor.isNull(_cursorIndexOfCjiRecursiveTotal) && _cursor.isNull(_cursorIndexOfCjiStatus) && _cursor.isNull(_cursorIndexOfCjiRecursiveStatus) && _cursor.isNull(_cursorIndexOfCjiConnectivityNeeded) && _cursor.isNull(_cursorIndexOfCjiPluginId) && _cursor.isNull(_cursorIndexOfCjiAttemptCount) && _cursor.isNull(_cursorIndexOfCjiParentCjiUid) && _cursor.isNull(_cursorIndexOfCjiServerJobId) && _cursor.isNull(_cursorIndexOfCjiStartTime) && _cursor.isNull(_cursorIndexOfCjiFinishTime) && _cursor.isNull(_cursorIndexOfCjiUploadSessionUid) && _cursor.isNull(_cursorIndexOfCjiContentDeletedOnCancellation) && _cursor.isNull(_cursorIndexOfCjiContainerProcessed))) {
              final long _tmpCjiUid;
              _tmpCjiUid = _cursor.getLong(_cursorIndexOfCjiUid);
              final long _tmpCjiJobUid;
              _tmpCjiJobUid = _cursor.getLong(_cursorIndexOfCjiJobUid);
              final String _tmpSourceUri;
              if (_cursor.isNull(_cursorIndexOfSourceUri)) {
                _tmpSourceUri = null;
              } else {
                _tmpSourceUri = _cursor.getString(_cursorIndexOfSourceUri);
              }
              final boolean _tmpCjiIsLeaf;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfCjiIsLeaf);
              _tmpCjiIsLeaf = _tmp != 0;
              final long _tmpCjiContentEntryUid;
              _tmpCjiContentEntryUid = _cursor.getLong(_cursorIndexOfCjiContentEntryUid);
              final long _tmpCjiParentContentEntryUid;
              _tmpCjiParentContentEntryUid = _cursor.getLong(_cursorIndexOfCjiParentContentEntryUid);
              final long _tmpCjiContainerUid;
              _tmpCjiContainerUid = _cursor.getLong(_cursorIndexOfCjiContainerUid);
              final long _tmpCjiItemProgress;
              _tmpCjiItemProgress = _cursor.getLong(_cursorIndexOfCjiItemProgress);
              final long _tmpCjiItemTotal;
              _tmpCjiItemTotal = _cursor.getLong(_cursorIndexOfCjiItemTotal);
              final long _tmpCjiRecursiveProgress;
              _tmpCjiRecursiveProgress = _cursor.getLong(_cursorIndexOfCjiRecursiveProgress);
              final long _tmpCjiRecursiveTotal;
              _tmpCjiRecursiveTotal = _cursor.getLong(_cursorIndexOfCjiRecursiveTotal);
              final int _tmpCjiStatus;
              _tmpCjiStatus = _cursor.getInt(_cursorIndexOfCjiStatus);
              final int _tmpCjiRecursiveStatus;
              _tmpCjiRecursiveStatus = _cursor.getInt(_cursorIndexOfCjiRecursiveStatus);
              final boolean _tmpCjiConnectivityNeeded;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfCjiConnectivityNeeded);
              _tmpCjiConnectivityNeeded = _tmp_1 != 0;
              final int _tmpCjiPluginId;
              _tmpCjiPluginId = _cursor.getInt(_cursorIndexOfCjiPluginId);
              final int _tmpCjiAttemptCount;
              _tmpCjiAttemptCount = _cursor.getInt(_cursorIndexOfCjiAttemptCount);
              final long _tmpCjiParentCjiUid;
              _tmpCjiParentCjiUid = _cursor.getLong(_cursorIndexOfCjiParentCjiUid);
              final long _tmpCjiServerJobId;
              _tmpCjiServerJobId = _cursor.getLong(_cursorIndexOfCjiServerJobId);
              final long _tmpCjiStartTime;
              _tmpCjiStartTime = _cursor.getLong(_cursorIndexOfCjiStartTime);
              final long _tmpCjiFinishTime;
              _tmpCjiFinishTime = _cursor.getLong(_cursorIndexOfCjiFinishTime);
              final String _tmpCjiUploadSessionUid;
              if (_cursor.isNull(_cursorIndexOfCjiUploadSessionUid)) {
                _tmpCjiUploadSessionUid = null;
              } else {
                _tmpCjiUploadSessionUid = _cursor.getString(_cursorIndexOfCjiUploadSessionUid);
              }
              final boolean _tmpCjiContentDeletedOnCancellation;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfCjiContentDeletedOnCancellation);
              _tmpCjiContentDeletedOnCancellation = _tmp_2 != 0;
              final boolean _tmpCjiContainerProcessed;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfCjiContainerProcessed);
              _tmpCjiContainerProcessed = _tmp_3 != 0;
              _tmpContentJobItem = new ContentJobItem(_tmpCjiUid,_tmpCjiJobUid,_tmpSourceUri,_tmpCjiIsLeaf,_tmpCjiContentEntryUid,_tmpCjiParentContentEntryUid,_tmpCjiContainerUid,_tmpCjiItemProgress,_tmpCjiItemTotal,_tmpCjiRecursiveProgress,_tmpCjiRecursiveTotal,_tmpCjiStatus,_tmpCjiRecursiveStatus,_tmpCjiConnectivityNeeded,_tmpCjiPluginId,_tmpCjiAttemptCount,_tmpCjiParentCjiUid,_tmpCjiServerJobId,_tmpCjiStartTime,_tmpCjiFinishTime,_tmpCjiUploadSessionUid,_tmpCjiContentDeletedOnCancellation,_tmpCjiContainerProcessed);
            }  else  {
              _tmpContentJobItem = null;
            }
            final ContentJob _tmpContentJob;
            if (! (_cursor.isNull(_cursorIndexOfCjUid) && _cursor.isNull(_cursorIndexOfToUri) && _cursor.isNull(_cursorIndexOfCjProgress) && _cursor.isNull(_cursorIndexOfCjTotal) && _cursor.isNull(_cursorIndexOfCjNotificationTitle) && _cursor.isNull(_cursorIndexOfCjIsMeteredAllowed) && _cursor.isNull(_cursorIndexOfParams))) {
              final long _tmpCjUid;
              _tmpCjUid = _cursor.getLong(_cursorIndexOfCjUid);
              final String _tmpToUri;
              if (_cursor.isNull(_cursorIndexOfToUri)) {
                _tmpToUri = null;
              } else {
                _tmpToUri = _cursor.getString(_cursorIndexOfToUri);
              }
              final long _tmpCjProgress;
              _tmpCjProgress = _cursor.getLong(_cursorIndexOfCjProgress);
              final long _tmpCjTotal;
              _tmpCjTotal = _cursor.getLong(_cursorIndexOfCjTotal);
              final String _tmpCjNotificationTitle;
              if (_cursor.isNull(_cursorIndexOfCjNotificationTitle)) {
                _tmpCjNotificationTitle = null;
              } else {
                _tmpCjNotificationTitle = _cursor.getString(_cursorIndexOfCjNotificationTitle);
              }
              final boolean _tmpCjIsMeteredAllowed;
              final int _tmp_4;
              _tmp_4 = _cursor.getInt(_cursorIndexOfCjIsMeteredAllowed);
              _tmpCjIsMeteredAllowed = _tmp_4 != 0;
              final String _tmpParams;
              if (_cursor.isNull(_cursorIndexOfParams)) {
                _tmpParams = null;
              } else {
                _tmpParams = _cursor.getString(_cursorIndexOfParams);
              }
              _tmpContentJob = new ContentJob(_tmpCjUid,_tmpToUri,_tmpCjProgress,_tmpCjTotal,_tmpCjNotificationTitle,_tmpCjIsMeteredAllowed,_tmpParams);
            }  else  {
              _tmpContentJob = null;
            }
            _item = new ContentJobItemAndContentJob();
            _item.setContentJobItem(_tmpContentJobItem);
            _item.setContentJob(_tmpContentJob);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findActiveContentJobItems(final long contentEntryUid,
      final Continuation<? super List<ContentJobItemProgress>> continuation) {
    final String _sql = "\n"
            + "        SELECT cjiRecursiveProgress AS progress, \n"
            + "               cjiRecursiveTotal AS total, \n"
            + "               cjNotificationTitle as progressTitle,\n"
            + "               ContentJobItem.cjiUid\n"
            + "          FROM ContentJobItem\n"
            + "          JOIN ContentJob\n"
            + "            ON ContentJob.cjUid = ContentJobItem.cjiJobUid\n"
            + "         WHERE cjiContentEntryUid = ?\n"
            + "           AND cjiRecursiveStatus >= 4\n"
            + "           AND cjiRecursiveStatus <= 20\n"
            + "      ORDER BY cjiStartTime DESC\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContentJobItemProgress>>() {
      @Override
      public List<ContentJobItemProgress> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfProgress = 0;
          final int _cursorIndexOfTotal = 1;
          final int _cursorIndexOfProgressTitle = 2;
          final int _cursorIndexOfCjiUid = 3;
          final List<ContentJobItemProgress> _result = new ArrayList<ContentJobItemProgress>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContentJobItemProgress _item;
            _item = new ContentJobItemProgress();
            final int _tmpProgress;
            _tmpProgress = _cursor.getInt(_cursorIndexOfProgress);
            _item.setProgress(_tmpProgress);
            final int _tmpTotal;
            _tmpTotal = _cursor.getInt(_cursorIndexOfTotal);
            _item.setTotal(_tmpTotal);
            final String _tmpProgressTitle;
            if (_cursor.isNull(_cursorIndexOfProgressTitle)) {
              _tmpProgressTitle = null;
            } else {
              _tmpProgressTitle = _cursor.getString(_cursorIndexOfProgressTitle);
            }
            _item.setProgressTitle(_tmpProgressTitle);
            final long _tmpCjiUid;
            _tmpCjiUid = _cursor.getLong(_cursorIndexOfCjiUid);
            _item.setCjiUid(_tmpCjiUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object isJobDone(final long jobUid, final Continuation<? super Boolean> continuation) {
    final String _sql = "\n"
            + "        SELECT NOT EXISTS(\n"
            + "               SELECT cjiUid \n"
            + "                 FROM ContentJobItem\n"
            + "                WHERE cjiJobUid = ?\n"
            + "                  AND cjiStatus < 21) \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, jobUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Boolean>() {
      @Override
      public Boolean call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Boolean _result;
          if(_cursor.moveToFirst()) {
            final int _tmp;
            _tmp = _cursor.getInt(0);
            _result = _tmp != 0;
          } else {
            _result = false;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public ContentJobItem findRootJobItemByJobId(final long jobUid) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM ContentJobItem\n"
            + "         WHERE cjiJobUid = ? \n"
            + "           AND cjiParentCjiUid = 0 \n"
            + "         LIMIT 1\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, jobUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiUid");
      final int _cursorIndexOfCjiJobUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiJobUid");
      final int _cursorIndexOfSourceUri = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUri");
      final int _cursorIndexOfCjiIsLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiIsLeaf");
      final int _cursorIndexOfCjiContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContentEntryUid");
      final int _cursorIndexOfCjiParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiParentContentEntryUid");
      final int _cursorIndexOfCjiContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContainerUid");
      final int _cursorIndexOfCjiItemProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiItemProgress");
      final int _cursorIndexOfCjiItemTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiItemTotal");
      final int _cursorIndexOfCjiRecursiveProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveProgress");
      final int _cursorIndexOfCjiRecursiveTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveTotal");
      final int _cursorIndexOfCjiStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiStatus");
      final int _cursorIndexOfCjiRecursiveStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveStatus");
      final int _cursorIndexOfCjiConnectivityNeeded = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiConnectivityNeeded");
      final int _cursorIndexOfCjiPluginId = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiPluginId");
      final int _cursorIndexOfCjiAttemptCount = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiAttemptCount");
      final int _cursorIndexOfCjiParentCjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiParentCjiUid");
      final int _cursorIndexOfCjiServerJobId = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiServerJobId");
      final int _cursorIndexOfCjiStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiStartTime");
      final int _cursorIndexOfCjiFinishTime = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiFinishTime");
      final int _cursorIndexOfCjiUploadSessionUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiUploadSessionUid");
      final int _cursorIndexOfCjiContentDeletedOnCancellation = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContentDeletedOnCancellation");
      final int _cursorIndexOfCjiContainerProcessed = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContainerProcessed");
      final ContentJobItem _result;
      if(_cursor.moveToFirst()) {
        final long _tmpCjiUid;
        _tmpCjiUid = _cursor.getLong(_cursorIndexOfCjiUid);
        final long _tmpCjiJobUid;
        _tmpCjiJobUid = _cursor.getLong(_cursorIndexOfCjiJobUid);
        final String _tmpSourceUri;
        if (_cursor.isNull(_cursorIndexOfSourceUri)) {
          _tmpSourceUri = null;
        } else {
          _tmpSourceUri = _cursor.getString(_cursorIndexOfSourceUri);
        }
        final boolean _tmpCjiIsLeaf;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfCjiIsLeaf);
        _tmpCjiIsLeaf = _tmp != 0;
        final long _tmpCjiContentEntryUid;
        _tmpCjiContentEntryUid = _cursor.getLong(_cursorIndexOfCjiContentEntryUid);
        final long _tmpCjiParentContentEntryUid;
        _tmpCjiParentContentEntryUid = _cursor.getLong(_cursorIndexOfCjiParentContentEntryUid);
        final long _tmpCjiContainerUid;
        _tmpCjiContainerUid = _cursor.getLong(_cursorIndexOfCjiContainerUid);
        final long _tmpCjiItemProgress;
        _tmpCjiItemProgress = _cursor.getLong(_cursorIndexOfCjiItemProgress);
        final long _tmpCjiItemTotal;
        _tmpCjiItemTotal = _cursor.getLong(_cursorIndexOfCjiItemTotal);
        final long _tmpCjiRecursiveProgress;
        _tmpCjiRecursiveProgress = _cursor.getLong(_cursorIndexOfCjiRecursiveProgress);
        final long _tmpCjiRecursiveTotal;
        _tmpCjiRecursiveTotal = _cursor.getLong(_cursorIndexOfCjiRecursiveTotal);
        final int _tmpCjiStatus;
        _tmpCjiStatus = _cursor.getInt(_cursorIndexOfCjiStatus);
        final int _tmpCjiRecursiveStatus;
        _tmpCjiRecursiveStatus = _cursor.getInt(_cursorIndexOfCjiRecursiveStatus);
        final boolean _tmpCjiConnectivityNeeded;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfCjiConnectivityNeeded);
        _tmpCjiConnectivityNeeded = _tmp_1 != 0;
        final int _tmpCjiPluginId;
        _tmpCjiPluginId = _cursor.getInt(_cursorIndexOfCjiPluginId);
        final int _tmpCjiAttemptCount;
        _tmpCjiAttemptCount = _cursor.getInt(_cursorIndexOfCjiAttemptCount);
        final long _tmpCjiParentCjiUid;
        _tmpCjiParentCjiUid = _cursor.getLong(_cursorIndexOfCjiParentCjiUid);
        final long _tmpCjiServerJobId;
        _tmpCjiServerJobId = _cursor.getLong(_cursorIndexOfCjiServerJobId);
        final long _tmpCjiStartTime;
        _tmpCjiStartTime = _cursor.getLong(_cursorIndexOfCjiStartTime);
        final long _tmpCjiFinishTime;
        _tmpCjiFinishTime = _cursor.getLong(_cursorIndexOfCjiFinishTime);
        final String _tmpCjiUploadSessionUid;
        if (_cursor.isNull(_cursorIndexOfCjiUploadSessionUid)) {
          _tmpCjiUploadSessionUid = null;
        } else {
          _tmpCjiUploadSessionUid = _cursor.getString(_cursorIndexOfCjiUploadSessionUid);
        }
        final boolean _tmpCjiContentDeletedOnCancellation;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfCjiContentDeletedOnCancellation);
        _tmpCjiContentDeletedOnCancellation = _tmp_2 != 0;
        final boolean _tmpCjiContainerProcessed;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfCjiContainerProcessed);
        _tmpCjiContainerProcessed = _tmp_3 != 0;
        _result = new ContentJobItem(_tmpCjiUid,_tmpCjiJobUid,_tmpSourceUri,_tmpCjiIsLeaf,_tmpCjiContentEntryUid,_tmpCjiParentContentEntryUid,_tmpCjiContainerUid,_tmpCjiItemProgress,_tmpCjiItemTotal,_tmpCjiRecursiveProgress,_tmpCjiRecursiveTotal,_tmpCjiStatus,_tmpCjiRecursiveStatus,_tmpCjiConnectivityNeeded,_tmpCjiPluginId,_tmpCjiAttemptCount,_tmpCjiParentCjiUid,_tmpCjiServerJobId,_tmpCjiStartTime,_tmpCjiFinishTime,_tmpCjiUploadSessionUid,_tmpCjiContentDeletedOnCancellation,_tmpCjiContainerProcessed);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findAll(final Continuation<? super List<ContentJobItem>> continuation) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM ContentJobItem\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ContentJobItem>>() {
      @Override
      public List<ContentJobItem> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiUid");
          final int _cursorIndexOfCjiJobUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiJobUid");
          final int _cursorIndexOfSourceUri = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUri");
          final int _cursorIndexOfCjiIsLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiIsLeaf");
          final int _cursorIndexOfCjiContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContentEntryUid");
          final int _cursorIndexOfCjiParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiParentContentEntryUid");
          final int _cursorIndexOfCjiContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContainerUid");
          final int _cursorIndexOfCjiItemProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiItemProgress");
          final int _cursorIndexOfCjiItemTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiItemTotal");
          final int _cursorIndexOfCjiRecursiveProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveProgress");
          final int _cursorIndexOfCjiRecursiveTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveTotal");
          final int _cursorIndexOfCjiStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiStatus");
          final int _cursorIndexOfCjiRecursiveStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveStatus");
          final int _cursorIndexOfCjiConnectivityNeeded = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiConnectivityNeeded");
          final int _cursorIndexOfCjiPluginId = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiPluginId");
          final int _cursorIndexOfCjiAttemptCount = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiAttemptCount");
          final int _cursorIndexOfCjiParentCjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiParentCjiUid");
          final int _cursorIndexOfCjiServerJobId = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiServerJobId");
          final int _cursorIndexOfCjiStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiStartTime");
          final int _cursorIndexOfCjiFinishTime = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiFinishTime");
          final int _cursorIndexOfCjiUploadSessionUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiUploadSessionUid");
          final int _cursorIndexOfCjiContentDeletedOnCancellation = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContentDeletedOnCancellation");
          final int _cursorIndexOfCjiContainerProcessed = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContainerProcessed");
          final List<ContentJobItem> _result = new ArrayList<ContentJobItem>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final ContentJobItem _item;
            final long _tmpCjiUid;
            _tmpCjiUid = _cursor.getLong(_cursorIndexOfCjiUid);
            final long _tmpCjiJobUid;
            _tmpCjiJobUid = _cursor.getLong(_cursorIndexOfCjiJobUid);
            final String _tmpSourceUri;
            if (_cursor.isNull(_cursorIndexOfSourceUri)) {
              _tmpSourceUri = null;
            } else {
              _tmpSourceUri = _cursor.getString(_cursorIndexOfSourceUri);
            }
            final boolean _tmpCjiIsLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCjiIsLeaf);
            _tmpCjiIsLeaf = _tmp != 0;
            final long _tmpCjiContentEntryUid;
            _tmpCjiContentEntryUid = _cursor.getLong(_cursorIndexOfCjiContentEntryUid);
            final long _tmpCjiParentContentEntryUid;
            _tmpCjiParentContentEntryUid = _cursor.getLong(_cursorIndexOfCjiParentContentEntryUid);
            final long _tmpCjiContainerUid;
            _tmpCjiContainerUid = _cursor.getLong(_cursorIndexOfCjiContainerUid);
            final long _tmpCjiItemProgress;
            _tmpCjiItemProgress = _cursor.getLong(_cursorIndexOfCjiItemProgress);
            final long _tmpCjiItemTotal;
            _tmpCjiItemTotal = _cursor.getLong(_cursorIndexOfCjiItemTotal);
            final long _tmpCjiRecursiveProgress;
            _tmpCjiRecursiveProgress = _cursor.getLong(_cursorIndexOfCjiRecursiveProgress);
            final long _tmpCjiRecursiveTotal;
            _tmpCjiRecursiveTotal = _cursor.getLong(_cursorIndexOfCjiRecursiveTotal);
            final int _tmpCjiStatus;
            _tmpCjiStatus = _cursor.getInt(_cursorIndexOfCjiStatus);
            final int _tmpCjiRecursiveStatus;
            _tmpCjiRecursiveStatus = _cursor.getInt(_cursorIndexOfCjiRecursiveStatus);
            final boolean _tmpCjiConnectivityNeeded;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCjiConnectivityNeeded);
            _tmpCjiConnectivityNeeded = _tmp_1 != 0;
            final int _tmpCjiPluginId;
            _tmpCjiPluginId = _cursor.getInt(_cursorIndexOfCjiPluginId);
            final int _tmpCjiAttemptCount;
            _tmpCjiAttemptCount = _cursor.getInt(_cursorIndexOfCjiAttemptCount);
            final long _tmpCjiParentCjiUid;
            _tmpCjiParentCjiUid = _cursor.getLong(_cursorIndexOfCjiParentCjiUid);
            final long _tmpCjiServerJobId;
            _tmpCjiServerJobId = _cursor.getLong(_cursorIndexOfCjiServerJobId);
            final long _tmpCjiStartTime;
            _tmpCjiStartTime = _cursor.getLong(_cursorIndexOfCjiStartTime);
            final long _tmpCjiFinishTime;
            _tmpCjiFinishTime = _cursor.getLong(_cursorIndexOfCjiFinishTime);
            final String _tmpCjiUploadSessionUid;
            if (_cursor.isNull(_cursorIndexOfCjiUploadSessionUid)) {
              _tmpCjiUploadSessionUid = null;
            } else {
              _tmpCjiUploadSessionUid = _cursor.getString(_cursorIndexOfCjiUploadSessionUid);
            }
            final boolean _tmpCjiContentDeletedOnCancellation;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCjiContentDeletedOnCancellation);
            _tmpCjiContentDeletedOnCancellation = _tmp_2 != 0;
            final boolean _tmpCjiContainerProcessed;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCjiContainerProcessed);
            _tmpCjiContainerProcessed = _tmp_3 != 0;
            _item = new ContentJobItem(_tmpCjiUid,_tmpCjiJobUid,_tmpSourceUri,_tmpCjiIsLeaf,_tmpCjiContentEntryUid,_tmpCjiParentContentEntryUid,_tmpCjiContainerUid,_tmpCjiItemProgress,_tmpCjiItemTotal,_tmpCjiRecursiveProgress,_tmpCjiRecursiveTotal,_tmpCjiStatus,_tmpCjiRecursiveStatus,_tmpCjiConnectivityNeeded,_tmpCjiPluginId,_tmpCjiAttemptCount,_tmpCjiParentCjiUid,_tmpCjiServerJobId,_tmpCjiStartTime,_tmpCjiFinishTime,_tmpCjiUploadSessionUid,_tmpCjiContentDeletedOnCancellation,_tmpCjiContainerProcessed);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByUidAsync(final long cjiUid,
      final Continuation<? super ContentJobItem> continuation) {
    final String _sql = "\n"
            + "        SELECT ContentJobItem.*\n"
            + "          FROM ContentJobItem\n"
            + "         WHERE cjiUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, cjiUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ContentJobItem>() {
      @Override
      public ContentJobItem call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiUid");
          final int _cursorIndexOfCjiJobUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiJobUid");
          final int _cursorIndexOfSourceUri = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUri");
          final int _cursorIndexOfCjiIsLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiIsLeaf");
          final int _cursorIndexOfCjiContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContentEntryUid");
          final int _cursorIndexOfCjiParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiParentContentEntryUid");
          final int _cursorIndexOfCjiContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContainerUid");
          final int _cursorIndexOfCjiItemProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiItemProgress");
          final int _cursorIndexOfCjiItemTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiItemTotal");
          final int _cursorIndexOfCjiRecursiveProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveProgress");
          final int _cursorIndexOfCjiRecursiveTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveTotal");
          final int _cursorIndexOfCjiStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiStatus");
          final int _cursorIndexOfCjiRecursiveStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveStatus");
          final int _cursorIndexOfCjiConnectivityNeeded = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiConnectivityNeeded");
          final int _cursorIndexOfCjiPluginId = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiPluginId");
          final int _cursorIndexOfCjiAttemptCount = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiAttemptCount");
          final int _cursorIndexOfCjiParentCjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiParentCjiUid");
          final int _cursorIndexOfCjiServerJobId = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiServerJobId");
          final int _cursorIndexOfCjiStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiStartTime");
          final int _cursorIndexOfCjiFinishTime = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiFinishTime");
          final int _cursorIndexOfCjiUploadSessionUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiUploadSessionUid");
          final int _cursorIndexOfCjiContentDeletedOnCancellation = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContentDeletedOnCancellation");
          final int _cursorIndexOfCjiContainerProcessed = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContainerProcessed");
          final ContentJobItem _result;
          if(_cursor.moveToFirst()) {
            final long _tmpCjiUid;
            _tmpCjiUid = _cursor.getLong(_cursorIndexOfCjiUid);
            final long _tmpCjiJobUid;
            _tmpCjiJobUid = _cursor.getLong(_cursorIndexOfCjiJobUid);
            final String _tmpSourceUri;
            if (_cursor.isNull(_cursorIndexOfSourceUri)) {
              _tmpSourceUri = null;
            } else {
              _tmpSourceUri = _cursor.getString(_cursorIndexOfSourceUri);
            }
            final boolean _tmpCjiIsLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCjiIsLeaf);
            _tmpCjiIsLeaf = _tmp != 0;
            final long _tmpCjiContentEntryUid;
            _tmpCjiContentEntryUid = _cursor.getLong(_cursorIndexOfCjiContentEntryUid);
            final long _tmpCjiParentContentEntryUid;
            _tmpCjiParentContentEntryUid = _cursor.getLong(_cursorIndexOfCjiParentContentEntryUid);
            final long _tmpCjiContainerUid;
            _tmpCjiContainerUid = _cursor.getLong(_cursorIndexOfCjiContainerUid);
            final long _tmpCjiItemProgress;
            _tmpCjiItemProgress = _cursor.getLong(_cursorIndexOfCjiItemProgress);
            final long _tmpCjiItemTotal;
            _tmpCjiItemTotal = _cursor.getLong(_cursorIndexOfCjiItemTotal);
            final long _tmpCjiRecursiveProgress;
            _tmpCjiRecursiveProgress = _cursor.getLong(_cursorIndexOfCjiRecursiveProgress);
            final long _tmpCjiRecursiveTotal;
            _tmpCjiRecursiveTotal = _cursor.getLong(_cursorIndexOfCjiRecursiveTotal);
            final int _tmpCjiStatus;
            _tmpCjiStatus = _cursor.getInt(_cursorIndexOfCjiStatus);
            final int _tmpCjiRecursiveStatus;
            _tmpCjiRecursiveStatus = _cursor.getInt(_cursorIndexOfCjiRecursiveStatus);
            final boolean _tmpCjiConnectivityNeeded;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCjiConnectivityNeeded);
            _tmpCjiConnectivityNeeded = _tmp_1 != 0;
            final int _tmpCjiPluginId;
            _tmpCjiPluginId = _cursor.getInt(_cursorIndexOfCjiPluginId);
            final int _tmpCjiAttemptCount;
            _tmpCjiAttemptCount = _cursor.getInt(_cursorIndexOfCjiAttemptCount);
            final long _tmpCjiParentCjiUid;
            _tmpCjiParentCjiUid = _cursor.getLong(_cursorIndexOfCjiParentCjiUid);
            final long _tmpCjiServerJobId;
            _tmpCjiServerJobId = _cursor.getLong(_cursorIndexOfCjiServerJobId);
            final long _tmpCjiStartTime;
            _tmpCjiStartTime = _cursor.getLong(_cursorIndexOfCjiStartTime);
            final long _tmpCjiFinishTime;
            _tmpCjiFinishTime = _cursor.getLong(_cursorIndexOfCjiFinishTime);
            final String _tmpCjiUploadSessionUid;
            if (_cursor.isNull(_cursorIndexOfCjiUploadSessionUid)) {
              _tmpCjiUploadSessionUid = null;
            } else {
              _tmpCjiUploadSessionUid = _cursor.getString(_cursorIndexOfCjiUploadSessionUid);
            }
            final boolean _tmpCjiContentDeletedOnCancellation;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCjiContentDeletedOnCancellation);
            _tmpCjiContentDeletedOnCancellation = _tmp_2 != 0;
            final boolean _tmpCjiContainerProcessed;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCjiContainerProcessed);
            _tmpCjiContainerProcessed = _tmp_3 != 0;
            _result = new ContentJobItem(_tmpCjiUid,_tmpCjiJobUid,_tmpSourceUri,_tmpCjiIsLeaf,_tmpCjiContentEntryUid,_tmpCjiParentContentEntryUid,_tmpCjiContainerUid,_tmpCjiItemProgress,_tmpCjiItemTotal,_tmpCjiRecursiveProgress,_tmpCjiRecursiveTotal,_tmpCjiStatus,_tmpCjiRecursiveStatus,_tmpCjiConnectivityNeeded,_tmpCjiPluginId,_tmpCjiAttemptCount,_tmpCjiParentCjiUid,_tmpCjiServerJobId,_tmpCjiStartTime,_tmpCjiFinishTime,_tmpCjiUploadSessionUid,_tmpCjiContentDeletedOnCancellation,_tmpCjiContainerProcessed);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object getActiveContentJobIdByContentEntryUid(final long contentEntryUid,
      final Continuation<? super Long> continuation) {
    final String _sql = "\n"
            + "        SELECT COALESCE(\n"
            + "               (SELECT ContentJobItem.cjiJobUid\n"
            + "                  FROM ContentJobItem\n"
            + "                 WHERE cjiContentEntryUid = ?\n"
            + "                   AND cjiStatus BETWEEN 4 AND 20\n"
            + "              ORDER BY cjiFinishTime DESC), 0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, contentEntryUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if(_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public List<ContentJobItem> findAllByJobId(final long jobId) {
    final String _sql = "\n"
            + "        SELECT * \n"
            + "          FROM ContentJobItem\n"
            + "         WHERE cjiJobUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, jobId);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiUid");
      final int _cursorIndexOfCjiJobUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiJobUid");
      final int _cursorIndexOfSourceUri = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUri");
      final int _cursorIndexOfCjiIsLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiIsLeaf");
      final int _cursorIndexOfCjiContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContentEntryUid");
      final int _cursorIndexOfCjiParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiParentContentEntryUid");
      final int _cursorIndexOfCjiContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContainerUid");
      final int _cursorIndexOfCjiItemProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiItemProgress");
      final int _cursorIndexOfCjiItemTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiItemTotal");
      final int _cursorIndexOfCjiRecursiveProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveProgress");
      final int _cursorIndexOfCjiRecursiveTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveTotal");
      final int _cursorIndexOfCjiStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiStatus");
      final int _cursorIndexOfCjiRecursiveStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveStatus");
      final int _cursorIndexOfCjiConnectivityNeeded = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiConnectivityNeeded");
      final int _cursorIndexOfCjiPluginId = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiPluginId");
      final int _cursorIndexOfCjiAttemptCount = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiAttemptCount");
      final int _cursorIndexOfCjiParentCjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiParentCjiUid");
      final int _cursorIndexOfCjiServerJobId = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiServerJobId");
      final int _cursorIndexOfCjiStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiStartTime");
      final int _cursorIndexOfCjiFinishTime = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiFinishTime");
      final int _cursorIndexOfCjiUploadSessionUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiUploadSessionUid");
      final int _cursorIndexOfCjiContentDeletedOnCancellation = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContentDeletedOnCancellation");
      final int _cursorIndexOfCjiContainerProcessed = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContainerProcessed");
      final List<ContentJobItem> _result = new ArrayList<ContentJobItem>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final ContentJobItem _item;
        final long _tmpCjiUid;
        _tmpCjiUid = _cursor.getLong(_cursorIndexOfCjiUid);
        final long _tmpCjiJobUid;
        _tmpCjiJobUid = _cursor.getLong(_cursorIndexOfCjiJobUid);
        final String _tmpSourceUri;
        if (_cursor.isNull(_cursorIndexOfSourceUri)) {
          _tmpSourceUri = null;
        } else {
          _tmpSourceUri = _cursor.getString(_cursorIndexOfSourceUri);
        }
        final boolean _tmpCjiIsLeaf;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfCjiIsLeaf);
        _tmpCjiIsLeaf = _tmp != 0;
        final long _tmpCjiContentEntryUid;
        _tmpCjiContentEntryUid = _cursor.getLong(_cursorIndexOfCjiContentEntryUid);
        final long _tmpCjiParentContentEntryUid;
        _tmpCjiParentContentEntryUid = _cursor.getLong(_cursorIndexOfCjiParentContentEntryUid);
        final long _tmpCjiContainerUid;
        _tmpCjiContainerUid = _cursor.getLong(_cursorIndexOfCjiContainerUid);
        final long _tmpCjiItemProgress;
        _tmpCjiItemProgress = _cursor.getLong(_cursorIndexOfCjiItemProgress);
        final long _tmpCjiItemTotal;
        _tmpCjiItemTotal = _cursor.getLong(_cursorIndexOfCjiItemTotal);
        final long _tmpCjiRecursiveProgress;
        _tmpCjiRecursiveProgress = _cursor.getLong(_cursorIndexOfCjiRecursiveProgress);
        final long _tmpCjiRecursiveTotal;
        _tmpCjiRecursiveTotal = _cursor.getLong(_cursorIndexOfCjiRecursiveTotal);
        final int _tmpCjiStatus;
        _tmpCjiStatus = _cursor.getInt(_cursorIndexOfCjiStatus);
        final int _tmpCjiRecursiveStatus;
        _tmpCjiRecursiveStatus = _cursor.getInt(_cursorIndexOfCjiRecursiveStatus);
        final boolean _tmpCjiConnectivityNeeded;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfCjiConnectivityNeeded);
        _tmpCjiConnectivityNeeded = _tmp_1 != 0;
        final int _tmpCjiPluginId;
        _tmpCjiPluginId = _cursor.getInt(_cursorIndexOfCjiPluginId);
        final int _tmpCjiAttemptCount;
        _tmpCjiAttemptCount = _cursor.getInt(_cursorIndexOfCjiAttemptCount);
        final long _tmpCjiParentCjiUid;
        _tmpCjiParentCjiUid = _cursor.getLong(_cursorIndexOfCjiParentCjiUid);
        final long _tmpCjiServerJobId;
        _tmpCjiServerJobId = _cursor.getLong(_cursorIndexOfCjiServerJobId);
        final long _tmpCjiStartTime;
        _tmpCjiStartTime = _cursor.getLong(_cursorIndexOfCjiStartTime);
        final long _tmpCjiFinishTime;
        _tmpCjiFinishTime = _cursor.getLong(_cursorIndexOfCjiFinishTime);
        final String _tmpCjiUploadSessionUid;
        if (_cursor.isNull(_cursorIndexOfCjiUploadSessionUid)) {
          _tmpCjiUploadSessionUid = null;
        } else {
          _tmpCjiUploadSessionUid = _cursor.getString(_cursorIndexOfCjiUploadSessionUid);
        }
        final boolean _tmpCjiContentDeletedOnCancellation;
        final int _tmp_2;
        _tmp_2 = _cursor.getInt(_cursorIndexOfCjiContentDeletedOnCancellation);
        _tmpCjiContentDeletedOnCancellation = _tmp_2 != 0;
        final boolean _tmpCjiContainerProcessed;
        final int _tmp_3;
        _tmp_3 = _cursor.getInt(_cursorIndexOfCjiContainerProcessed);
        _tmpCjiContainerProcessed = _tmp_3 != 0;
        _item = new ContentJobItem(_tmpCjiUid,_tmpCjiJobUid,_tmpSourceUri,_tmpCjiIsLeaf,_tmpCjiContentEntryUid,_tmpCjiParentContentEntryUid,_tmpCjiContainerUid,_tmpCjiItemProgress,_tmpCjiItemTotal,_tmpCjiRecursiveProgress,_tmpCjiRecursiveTotal,_tmpCjiStatus,_tmpCjiRecursiveStatus,_tmpCjiConnectivityNeeded,_tmpCjiPluginId,_tmpCjiAttemptCount,_tmpCjiParentCjiUid,_tmpCjiServerJobId,_tmpCjiStartTime,_tmpCjiFinishTime,_tmpCjiUploadSessionUid,_tmpCjiContentDeletedOnCancellation,_tmpCjiContainerProcessed);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public LiveData<ContentJobItem> getJobItemByUidLive(final long uid) {
    final String _sql = "\n"
            + "        SELECT *\n"
            + "          FROM ContentJobItem\n"
            + "         WHERE cjiUid = ?   \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"ContentJobItem"}, false, new Callable<ContentJobItem>() {
      @Override
      public ContentJobItem call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiUid");
          final int _cursorIndexOfCjiJobUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiJobUid");
          final int _cursorIndexOfSourceUri = CursorUtil.getColumnIndexOrThrow(_cursor, "sourceUri");
          final int _cursorIndexOfCjiIsLeaf = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiIsLeaf");
          final int _cursorIndexOfCjiContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContentEntryUid");
          final int _cursorIndexOfCjiParentContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiParentContentEntryUid");
          final int _cursorIndexOfCjiContainerUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContainerUid");
          final int _cursorIndexOfCjiItemProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiItemProgress");
          final int _cursorIndexOfCjiItemTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiItemTotal");
          final int _cursorIndexOfCjiRecursiveProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveProgress");
          final int _cursorIndexOfCjiRecursiveTotal = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveTotal");
          final int _cursorIndexOfCjiStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiStatus");
          final int _cursorIndexOfCjiRecursiveStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiRecursiveStatus");
          final int _cursorIndexOfCjiConnectivityNeeded = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiConnectivityNeeded");
          final int _cursorIndexOfCjiPluginId = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiPluginId");
          final int _cursorIndexOfCjiAttemptCount = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiAttemptCount");
          final int _cursorIndexOfCjiParentCjiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiParentCjiUid");
          final int _cursorIndexOfCjiServerJobId = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiServerJobId");
          final int _cursorIndexOfCjiStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiStartTime");
          final int _cursorIndexOfCjiFinishTime = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiFinishTime");
          final int _cursorIndexOfCjiUploadSessionUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiUploadSessionUid");
          final int _cursorIndexOfCjiContentDeletedOnCancellation = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContentDeletedOnCancellation");
          final int _cursorIndexOfCjiContainerProcessed = CursorUtil.getColumnIndexOrThrow(_cursor, "cjiContainerProcessed");
          final ContentJobItem _result;
          if(_cursor.moveToFirst()) {
            final long _tmpCjiUid;
            _tmpCjiUid = _cursor.getLong(_cursorIndexOfCjiUid);
            final long _tmpCjiJobUid;
            _tmpCjiJobUid = _cursor.getLong(_cursorIndexOfCjiJobUid);
            final String _tmpSourceUri;
            if (_cursor.isNull(_cursorIndexOfSourceUri)) {
              _tmpSourceUri = null;
            } else {
              _tmpSourceUri = _cursor.getString(_cursorIndexOfSourceUri);
            }
            final boolean _tmpCjiIsLeaf;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfCjiIsLeaf);
            _tmpCjiIsLeaf = _tmp != 0;
            final long _tmpCjiContentEntryUid;
            _tmpCjiContentEntryUid = _cursor.getLong(_cursorIndexOfCjiContentEntryUid);
            final long _tmpCjiParentContentEntryUid;
            _tmpCjiParentContentEntryUid = _cursor.getLong(_cursorIndexOfCjiParentContentEntryUid);
            final long _tmpCjiContainerUid;
            _tmpCjiContainerUid = _cursor.getLong(_cursorIndexOfCjiContainerUid);
            final long _tmpCjiItemProgress;
            _tmpCjiItemProgress = _cursor.getLong(_cursorIndexOfCjiItemProgress);
            final long _tmpCjiItemTotal;
            _tmpCjiItemTotal = _cursor.getLong(_cursorIndexOfCjiItemTotal);
            final long _tmpCjiRecursiveProgress;
            _tmpCjiRecursiveProgress = _cursor.getLong(_cursorIndexOfCjiRecursiveProgress);
            final long _tmpCjiRecursiveTotal;
            _tmpCjiRecursiveTotal = _cursor.getLong(_cursorIndexOfCjiRecursiveTotal);
            final int _tmpCjiStatus;
            _tmpCjiStatus = _cursor.getInt(_cursorIndexOfCjiStatus);
            final int _tmpCjiRecursiveStatus;
            _tmpCjiRecursiveStatus = _cursor.getInt(_cursorIndexOfCjiRecursiveStatus);
            final boolean _tmpCjiConnectivityNeeded;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfCjiConnectivityNeeded);
            _tmpCjiConnectivityNeeded = _tmp_1 != 0;
            final int _tmpCjiPluginId;
            _tmpCjiPluginId = _cursor.getInt(_cursorIndexOfCjiPluginId);
            final int _tmpCjiAttemptCount;
            _tmpCjiAttemptCount = _cursor.getInt(_cursorIndexOfCjiAttemptCount);
            final long _tmpCjiParentCjiUid;
            _tmpCjiParentCjiUid = _cursor.getLong(_cursorIndexOfCjiParentCjiUid);
            final long _tmpCjiServerJobId;
            _tmpCjiServerJobId = _cursor.getLong(_cursorIndexOfCjiServerJobId);
            final long _tmpCjiStartTime;
            _tmpCjiStartTime = _cursor.getLong(_cursorIndexOfCjiStartTime);
            final long _tmpCjiFinishTime;
            _tmpCjiFinishTime = _cursor.getLong(_cursorIndexOfCjiFinishTime);
            final String _tmpCjiUploadSessionUid;
            if (_cursor.isNull(_cursorIndexOfCjiUploadSessionUid)) {
              _tmpCjiUploadSessionUid = null;
            } else {
              _tmpCjiUploadSessionUid = _cursor.getString(_cursorIndexOfCjiUploadSessionUid);
            }
            final boolean _tmpCjiContentDeletedOnCancellation;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfCjiContentDeletedOnCancellation);
            _tmpCjiContentDeletedOnCancellation = _tmp_2 != 0;
            final boolean _tmpCjiContainerProcessed;
            final int _tmp_3;
            _tmp_3 = _cursor.getInt(_cursorIndexOfCjiContainerProcessed);
            _tmpCjiContainerProcessed = _tmp_3 != 0;
            _result = new ContentJobItem(_tmpCjiUid,_tmpCjiJobUid,_tmpSourceUri,_tmpCjiIsLeaf,_tmpCjiContentEntryUid,_tmpCjiParentContentEntryUid,_tmpCjiContainerUid,_tmpCjiItemProgress,_tmpCjiItemTotal,_tmpCjiRecursiveProgress,_tmpCjiRecursiveTotal,_tmpCjiStatus,_tmpCjiRecursiveStatus,_tmpCjiConnectivityNeeded,_tmpCjiPluginId,_tmpCjiAttemptCount,_tmpCjiParentCjiUid,_tmpCjiServerJobId,_tmpCjiStartTime,_tmpCjiFinishTime,_tmpCjiUploadSessionUid,_tmpCjiContentDeletedOnCancellation,_tmpCjiContainerProcessed);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getContainerUidByJobItemUid(final long uid,
      final Continuation<? super Long> continuation) {
    final String _sql = "\n"
            + "        SELECT cjiContainerUid\n"
            + "          FROM ContentJobItem\n"
            + "         WHERE cjiUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final long _result;
          if(_cursor.moveToFirst()) {
            _result = _cursor.getLong(0);
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findAllContainersByJobUid(final long jobUid,
      final Continuation<? super List<Long>> continuation) {
    final String _sql = "\n"
            + "        SELECT ContentJobItem.cjiContainerUid\n"
            + "          FROM ContentJobItem\n"
            + "         WHERE cjiJobUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, jobUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Long>>() {
      @Override
      public List<Long> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final List<Long> _result = new ArrayList<Long>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Long _item;
            _item = _cursor.getLong(0);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
