package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.PersonGroupMember;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class PersonGroupMemberDao_Impl extends PersonGroupMemberDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PersonGroupMember> __insertionAdapterOfPersonGroupMember;

  private final EntityDeletionOrUpdateAdapter<PersonGroupMember> __updateAdapterOfPersonGroupMember;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChangeClazzBased;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNodeClazzBased;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChangeSchoolBased;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNodeSchoolBased;

  private final SharedSQLiteStatement __preparedStmtOfMoveGroupAsync;

  private final SharedSQLiteStatement __preparedStmtOfUpdateGroupMemberActive;

  public PersonGroupMemberDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPersonGroupMember = new EntityInsertionAdapter<PersonGroupMember>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `PersonGroupMember` (`groupMemberUid`,`groupMemberActive`,`groupMemberPersonUid`,`groupMemberGroupUid`,`groupMemberMasterCsn`,`groupMemberLocalCsn`,`groupMemberLastChangedBy`,`groupMemberLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PersonGroupMember value) {
        stmt.bindLong(1, value.getGroupMemberUid());
        final int _tmp = value.getGroupMemberActive() ? 1 : 0;
        stmt.bindLong(2, _tmp);
        stmt.bindLong(3, value.getGroupMemberPersonUid());
        stmt.bindLong(4, value.getGroupMemberGroupUid());
        stmt.bindLong(5, value.getGroupMemberMasterCsn());
        stmt.bindLong(6, value.getGroupMemberLocalCsn());
        stmt.bindLong(7, value.getGroupMemberLastChangedBy());
        stmt.bindLong(8, value.getGroupMemberLct());
      }
    };
    this.__updateAdapterOfPersonGroupMember = new EntityDeletionOrUpdateAdapter<PersonGroupMember>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `PersonGroupMember` SET `groupMemberUid` = ?,`groupMemberActive` = ?,`groupMemberPersonUid` = ?,`groupMemberGroupUid` = ?,`groupMemberMasterCsn` = ?,`groupMemberLocalCsn` = ?,`groupMemberLastChangedBy` = ?,`groupMemberLct` = ? WHERE `groupMemberUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, PersonGroupMember value) {
        stmt.bindLong(1, value.getGroupMemberUid());
        final int _tmp = value.getGroupMemberActive() ? 1 : 0;
        stmt.bindLong(2, _tmp);
        stmt.bindLong(3, value.getGroupMemberPersonUid());
        stmt.bindLong(4, value.getGroupMemberGroupUid());
        stmt.bindLong(5, value.getGroupMemberMasterCsn());
        stmt.bindLong(6, value.getGroupMemberLocalCsn());
        stmt.bindLong(7, value.getGroupMemberLastChangedBy());
        stmt.bindLong(8, value.getGroupMemberLct());
        stmt.bindLong(9, value.getGroupMemberUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO PersonGroupMemberReplicate(pgmPk, pgmDestination)\n"
                + "      SELECT DISTINCT PersonGroupMember.groupMemberUid AS pgmUid,\n"
                + "             ? AS pgmDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember\n"
                + "                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                    AND (ScopedGrant.sgPermissions &\n"
                + "                    64\n"
                + "                    \n"
                + "                                                    ) > 0\n"
                + "            JOIN Person \n"
                + "                 ON \n"
                + "                ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentPersonUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND Person.personUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberPersonUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )    \n"
                + "        \n"
                + "        \n"
                + "             JOIN PersonGroupMember PersonsWithPerm_GroupMember\n"
                + "                    ON PersonsWithPerm_GroupMember.groupMemberPersonUid = Person.personUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND PersonGroupMember.groupMemberLct != COALESCE(\n"
                + "             (SELECT pgmVersionId\n"
                + "                FROM PersonGroupMemberReplicate\n"
                + "               WHERE pgmPk = PersonGroupMember.groupMemberUid\n"
                + "                 AND pgmDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(pgmPk, pgmDestination) DO UPDATE\n"
                + "             SET pgmPending = true\n"
                + "      */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonGroupMemberReplicate(pgmPk, pgmDestination)\n"
                + "  SELECT DISTINCT PersonGroupMember.groupMemberUid AS pgmUid,\n"
                + "         UserSession.usClientNodeId AS pgmDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN PersonGroupMember\n"
                + "             ON ChangeLog.chTableId = 44\n"
                + "                AND ChangeLog.chEntityPk = PersonGroupMember.groupMemberUid\n"
                + "         JOIN Person\n"
                + "              ON PersonGroupMember.groupMemberPersonUid = Person.personUid\n"
                + "         \n"
                + "            JOIN ScopedGrant \n"
                + "                   ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                 OR (ScopedGrant.sgTableId = 9\n"
                + "                    AND ScopedGrant.sgEntityUid = Person.personUid)\n"
                + "                 OR (ScopedGrant.sgTableId = 6       \n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT clazzEnrolmentClazzUid\n"
                + "                          FROM ClazzEnrolment\n"
                + "                         WHERE clazzEnrolmentPersonUid = Person.personUid \n"
                + "                           AND ClazzEnrolment.clazzEnrolmentActive))\n"
                + "                 OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid IN (\n"
                + "                        SELECT DISTINCT schoolMemberSchoolUid\n"
                + "                          FROM SchoolMember\n"
                + "                         WHERE schoolMemberPersonUid = Person.personUid\n"
                + "                           AND schoolMemberActive))\n"
                + "                           )\n"
                + "        \n"
                + "                   AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              64\n"
                + "              \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND PersonGroupMember.groupMemberLct != COALESCE(\n"
                + "         (SELECT pgmVersionId\n"
                + "            FROM PersonGroupMemberReplicate\n"
                + "           WHERE pgmPk = PersonGroupMember.groupMemberUid\n"
                + "             AND pgmDestination = UserSession.usClientNodeId), 0)\n"
                + "     /*psql ON CONFLICT(pgmPk, pgmDestination) DO UPDATE\n"
                + "         SET pgmPending = true\n"
                + "      */               \n"
                + "     ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChangeClazzBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonGroupMemberReplicate(pgmPk, pgmDestination)\n"
                + "  SELECT DISTINCT PersonGroupMember.groupMemberUid AS pgmUid,\n"
                + "         UserSession.usClientNodeId AS pgmDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN PersonGroupMember\n"
                + "             ON ChangeLog.chTableId = 44\n"
                + "                AND ChangeLog.chEntityPk = PersonGroupMember.groupMemberUid\n"
                + "         JOIN ScopedGrant ScopedGrantEntity\n"
                + "              ON PersonGroupMember.groupMemberUid = ScopedGrantEntity.sgGroupUid\n"
                + "         JOIN Clazz \n"
                + "              ON ScopedGrantEntity.sgTableId = 6\n"
                + "                 AND ScopedGrantEntity.sgEntityUid = Clazz.clazzUid\n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              2\n"
                + "              \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "              \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "                SELECT nodeClientId \n"
                + "                  FROM SyncNode\n"
                + "                 LIMIT 1)\n"
                + "     AND PersonGroupMember.groupMemberLct != COALESCE(\n"
                + "              (SELECT pgmVersionId\n"
                + "                 FROM PersonGroupMemberReplicate\n"
                + "                WHERE pgmPk = PersonGroupMember.groupMemberUid\n"
                + "                  AND pgmDestination = UserSession.usClientNodeId), 0)\n"
                + "  /*psql ON CONFLICT(pgmPk, pgmDestination) DO UPDATE\n"
                + "     SET pgmPending = true\n"
                + "    */                   \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnNewNodeClazzBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonGroupMemberReplicate(pgmPk, pgmDestination)\n"
                + "      SELECT DISTINCT PersonGroupMember.groupMemberUid AS pgmUid,\n"
                + "             ? AS pgmDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember\n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                  2 \n"
                + "                  \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "             JOIN ScopedGrant ScopedGrantEntity\n"
                + "                  ON Clazz.clazzUid = ScopedGrantEntity.sgEntityUid\n"
                + "                     AND ScopedGrantEntity.sgTableId = 6\n"
                + "             JOIN PersonGroupMember PersonGroupMemberEntity\n"
                + "                  ON PersonGroupMemberEntity.groupMemberGroupUid = ScopedGrantEntity.sgGroupUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1  \n"
                + "         AND PersonGroupMember.groupMemberLct != COALESCE(\n"
                + "             (SELECT pgmVersionId\n"
                + "                FROM PersonGroupMemberReplicate\n"
                + "               WHERE pgmPk = PersonGroupMember.groupMemberUid\n"
                + "                 AND pgmDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(pgmPk, pgmDestination) DO UPDATE\n"
                + "             SET pgmPending = true\n"
                + "      */                \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChangeSchoolBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonGroupMemberReplicate(pgmPk, pgmDestination)\n"
                + "  SELECT DISTINCT PersonGroupMember.groupMemberUid AS pgmUid,\n"
                + "         UserSession.usClientNodeId AS pgmDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN PersonGroupMember\n"
                + "             ON ChangeLog.chTableId = 44\n"
                + "                AND ChangeLog.chEntityPk = PersonGroupMember.groupMemberUid\n"
                + "         JOIN ScopedGrant ScopedGrantEntity\n"
                + "              ON PersonGroupMember.groupMemberUid = ScopedGrantEntity.sgGroupUid\n"
                + "         JOIN School \n"
                + "              ON ScopedGrantEntity.sgTableId = 164\n"
                + "                 AND ScopedGrantEntity.sgEntityUid = School.schoolUid\n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n"
                + "        \n"
                + "                        AND (SCopedGrant.sgPermissions &\n"
                + "        \n"
                + "              536870912\n"
                + "              \n"
                + "                                                     ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "                      \n"
                + "        \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "                SELECT nodeClientId \n"
                + "                  FROM SyncNode\n"
                + "                 LIMIT 1)\n"
                + "     AND PersonGroupMember.groupMemberLct != COALESCE(\n"
                + "              (SELECT pgmVersionId\n"
                + "                 FROM PersonGroupMemberReplicate\n"
                + "                WHERE pgmPk = PersonGroupMember.groupMemberUid\n"
                + "                  AND pgmDestination = UserSession.usClientNodeId), 0)\n"
                + "  /*psql ON CONFLICT(pgmPk, pgmDestination) DO UPDATE\n"
                + "     SET pgmPending = true\n"
                + "    */                   \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnNewNodeSchoolBased = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO PersonGroupMemberReplicate(pgmPk, pgmDestination)\n"
                + "      SELECT DISTINCT PersonGroupMember.groupMemberUid AS pgmUid,\n"
                + "             ? AS pgmDestination\n"
                + "        FROM UserSession\n"
                + "             JOIN PersonGroupMember\n"
                + "                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "             \n"
                + "            JOIN ScopedGrant \n"
                + "                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions &\n"
                + "                 \n"
                + "        \n"
                + "                  536870912\n"
                + "                  \n"
                + "                    ) > 0\n"
                + "            JOIN School\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                    AND ScopedGrant.sgEntityUid = -2)\n"
                + "                OR (ScopedGrant.sgTableId = 164\n"
                + "                    AND ScopedGrant.sgEntityUid = School.schoolUid))\n"
                + "        \n"
                + "        \n"
                + "             JOIN ScopedGrant ScopedGrantEntity\n"
                + "                  ON School.schoolUid = ScopedGrantEntity.sgEntityUid\n"
                + "                     AND ScopedGrantEntity.sgTableId = 164\n"
                + "             JOIN PersonGroupMember PersonGroupMemberEntity\n"
                + "                  ON PersonGroupMemberEntity.groupMemberGroupUid = ScopedGrantEntity.sgGroupUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1  \n"
                + "         AND PersonGroupMember.groupMemberLct != COALESCE(\n"
                + "             (SELECT pgmVersionId\n"
                + "                FROM PersonGroupMemberReplicate\n"
                + "               WHERE pgmPk = PersonGroupMember.groupMemberUid\n"
                + "                 AND pgmDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(pgmPk, pgmDestination) DO UPDATE\n"
                + "             SET pgmPending = true\n"
                + "      */                \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfMoveGroupAsync = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE PersonGroupMember \n"
                + "           SET groupMemberGroupUid = ?,\n"
                + "               groupMemberLct = ?\n"
                + "         WHERE groupMemberPersonUid = ? \n"
                + "           AND groupMemberGroupUid = ? \n"
                + "           AND PersonGroupMember.groupMemberActive";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateGroupMemberActive = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE PersonGroupMember \n"
                + "           SET groupMemberActive = ?,\n"
                + "               groupMemberLct = ?\n"
                + "        WHERE groupMemberPersonUid = ? \n"
                + "          AND groupMemberGroupUid = ? \n"
                + "          AND PersonGroupMember.groupMemberActive";
        return _query;
      }
    };
  }

  @Override
  public long insert(final PersonGroupMember entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfPersonGroupMember.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final PersonGroupMember entity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfPersonGroupMember.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends PersonGroupMember> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfPersonGroupMember.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void updateList(final List<? extends PersonGroupMember> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfPersonGroupMember.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final PersonGroupMember entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfPersonGroupMember.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChangeClazzBased(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChangeClazzBased.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChangeClazzBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNodeClazzBased(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNodeClazzBased.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNodeClazzBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChangeSchoolBased(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChangeSchoolBased.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChangeSchoolBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNodeSchoolBased(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNodeSchoolBased.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNodeSchoolBased.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object moveGroupAsync(final long personUid, final long newGroup, final long oldGroup,
      final long changeTime, final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfMoveGroupAsync.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newGroup);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, personUid);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, oldGroup);
        __db.beginTransaction();
        try {
          final java.lang.Integer _result = _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
          __preparedStmtOfMoveGroupAsync.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateGroupMemberActive(final boolean activeStatus, final long personUid,
      final long groupUid, final long updateTime, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateGroupMemberActive.acquire();
        int _argIndex = 1;
        final int _tmp = activeStatus ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, personUid);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, groupUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateGroupMemberActive.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object findAllGroupWherePersonIsIn(final long personUid,
      final Continuation<? super List<PersonGroupMember>> continuation) {
    final String _sql = "SELECT * FROM PersonGroupMember WHERE groupMemberPersonUid = ? AND PersonGroupMember.groupMemberActive";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PersonGroupMember>>() {
      @Override
      public List<PersonGroupMember> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfGroupMemberUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberUid");
          final int _cursorIndexOfGroupMemberActive = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberActive");
          final int _cursorIndexOfGroupMemberPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberPersonUid");
          final int _cursorIndexOfGroupMemberGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberGroupUid");
          final int _cursorIndexOfGroupMemberMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberMasterCsn");
          final int _cursorIndexOfGroupMemberLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLocalCsn");
          final int _cursorIndexOfGroupMemberLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLastChangedBy");
          final int _cursorIndexOfGroupMemberLct = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLct");
          final List<PersonGroupMember> _result = new ArrayList<PersonGroupMember>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final PersonGroupMember _item;
            _item = new PersonGroupMember();
            final long _tmpGroupMemberUid;
            _tmpGroupMemberUid = _cursor.getLong(_cursorIndexOfGroupMemberUid);
            _item.setGroupMemberUid(_tmpGroupMemberUid);
            final boolean _tmpGroupMemberActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfGroupMemberActive);
            _tmpGroupMemberActive = _tmp != 0;
            _item.setGroupMemberActive(_tmpGroupMemberActive);
            final long _tmpGroupMemberPersonUid;
            _tmpGroupMemberPersonUid = _cursor.getLong(_cursorIndexOfGroupMemberPersonUid);
            _item.setGroupMemberPersonUid(_tmpGroupMemberPersonUid);
            final long _tmpGroupMemberGroupUid;
            _tmpGroupMemberGroupUid = _cursor.getLong(_cursorIndexOfGroupMemberGroupUid);
            _item.setGroupMemberGroupUid(_tmpGroupMemberGroupUid);
            final long _tmpGroupMemberMasterCsn;
            _tmpGroupMemberMasterCsn = _cursor.getLong(_cursorIndexOfGroupMemberMasterCsn);
            _item.setGroupMemberMasterCsn(_tmpGroupMemberMasterCsn);
            final long _tmpGroupMemberLocalCsn;
            _tmpGroupMemberLocalCsn = _cursor.getLong(_cursorIndexOfGroupMemberLocalCsn);
            _item.setGroupMemberLocalCsn(_tmpGroupMemberLocalCsn);
            final int _tmpGroupMemberLastChangedBy;
            _tmpGroupMemberLastChangedBy = _cursor.getInt(_cursorIndexOfGroupMemberLastChangedBy);
            _item.setGroupMemberLastChangedBy(_tmpGroupMemberLastChangedBy);
            final long _tmpGroupMemberLct;
            _tmpGroupMemberLct = _cursor.getLong(_cursorIndexOfGroupMemberLct);
            _item.setGroupMemberLct(_tmpGroupMemberLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object checkPersonBelongsToGroup(final long groupUid, final long personUid,
      final Continuation<? super List<PersonGroupMember>> continuation) {
    final String _sql = "SELECT * FROM PersonGroupMember WHERE groupMemberGroupUid = ? \n"
            + "             AND groupMemberPersonUid = ? AND PersonGroupMember.groupMemberActive";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, groupUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, personUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PersonGroupMember>>() {
      @Override
      public List<PersonGroupMember> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfGroupMemberUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberUid");
          final int _cursorIndexOfGroupMemberActive = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberActive");
          final int _cursorIndexOfGroupMemberPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberPersonUid");
          final int _cursorIndexOfGroupMemberGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberGroupUid");
          final int _cursorIndexOfGroupMemberMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberMasterCsn");
          final int _cursorIndexOfGroupMemberLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLocalCsn");
          final int _cursorIndexOfGroupMemberLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLastChangedBy");
          final int _cursorIndexOfGroupMemberLct = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLct");
          final List<PersonGroupMember> _result = new ArrayList<PersonGroupMember>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final PersonGroupMember _item;
            _item = new PersonGroupMember();
            final long _tmpGroupMemberUid;
            _tmpGroupMemberUid = _cursor.getLong(_cursorIndexOfGroupMemberUid);
            _item.setGroupMemberUid(_tmpGroupMemberUid);
            final boolean _tmpGroupMemberActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfGroupMemberActive);
            _tmpGroupMemberActive = _tmp != 0;
            _item.setGroupMemberActive(_tmpGroupMemberActive);
            final long _tmpGroupMemberPersonUid;
            _tmpGroupMemberPersonUid = _cursor.getLong(_cursorIndexOfGroupMemberPersonUid);
            _item.setGroupMemberPersonUid(_tmpGroupMemberPersonUid);
            final long _tmpGroupMemberGroupUid;
            _tmpGroupMemberGroupUid = _cursor.getLong(_cursorIndexOfGroupMemberGroupUid);
            _item.setGroupMemberGroupUid(_tmpGroupMemberGroupUid);
            final long _tmpGroupMemberMasterCsn;
            _tmpGroupMemberMasterCsn = _cursor.getLong(_cursorIndexOfGroupMemberMasterCsn);
            _item.setGroupMemberMasterCsn(_tmpGroupMemberMasterCsn);
            final long _tmpGroupMemberLocalCsn;
            _tmpGroupMemberLocalCsn = _cursor.getLong(_cursorIndexOfGroupMemberLocalCsn);
            _item.setGroupMemberLocalCsn(_tmpGroupMemberLocalCsn);
            final int _tmpGroupMemberLastChangedBy;
            _tmpGroupMemberLastChangedBy = _cursor.getInt(_cursorIndexOfGroupMemberLastChangedBy);
            _item.setGroupMemberLastChangedBy(_tmpGroupMemberLastChangedBy);
            final long _tmpGroupMemberLct;
            _tmpGroupMemberLct = _cursor.getLong(_cursorIndexOfGroupMemberLct);
            _item.setGroupMemberLct(_tmpGroupMemberLct);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object findByPersonUidAndGroupUid(final long personUid, final long groupUid,
      final Continuation<? super PersonGroupMember> continuation) {
    final String _sql = "\n"
            + "        SELECT PersonGroupMember.*\n"
            + "          FROM PersonGroupMember\n"
            + "         WHERE PersonGroupMember.groupMemberPersonUid = ?\n"
            + "           AND PersonGroupMember.groupMemberGroupUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, groupUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<PersonGroupMember>() {
      @Override
      public PersonGroupMember call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfGroupMemberUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberUid");
          final int _cursorIndexOfGroupMemberActive = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberActive");
          final int _cursorIndexOfGroupMemberPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberPersonUid");
          final int _cursorIndexOfGroupMemberGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberGroupUid");
          final int _cursorIndexOfGroupMemberMasterCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberMasterCsn");
          final int _cursorIndexOfGroupMemberLocalCsn = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLocalCsn");
          final int _cursorIndexOfGroupMemberLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLastChangedBy");
          final int _cursorIndexOfGroupMemberLct = CursorUtil.getColumnIndexOrThrow(_cursor, "groupMemberLct");
          final PersonGroupMember _result;
          if(_cursor.moveToFirst()) {
            _result = new PersonGroupMember();
            final long _tmpGroupMemberUid;
            _tmpGroupMemberUid = _cursor.getLong(_cursorIndexOfGroupMemberUid);
            _result.setGroupMemberUid(_tmpGroupMemberUid);
            final boolean _tmpGroupMemberActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfGroupMemberActive);
            _tmpGroupMemberActive = _tmp != 0;
            _result.setGroupMemberActive(_tmpGroupMemberActive);
            final long _tmpGroupMemberPersonUid;
            _tmpGroupMemberPersonUid = _cursor.getLong(_cursorIndexOfGroupMemberPersonUid);
            _result.setGroupMemberPersonUid(_tmpGroupMemberPersonUid);
            final long _tmpGroupMemberGroupUid;
            _tmpGroupMemberGroupUid = _cursor.getLong(_cursorIndexOfGroupMemberGroupUid);
            _result.setGroupMemberGroupUid(_tmpGroupMemberGroupUid);
            final long _tmpGroupMemberMasterCsn;
            _tmpGroupMemberMasterCsn = _cursor.getLong(_cursorIndexOfGroupMemberMasterCsn);
            _result.setGroupMemberMasterCsn(_tmpGroupMemberMasterCsn);
            final long _tmpGroupMemberLocalCsn;
            _tmpGroupMemberLocalCsn = _cursor.getLong(_cursorIndexOfGroupMemberLocalCsn);
            _result.setGroupMemberLocalCsn(_tmpGroupMemberLocalCsn);
            final int _tmpGroupMemberLastChangedBy;
            _tmpGroupMemberLastChangedBy = _cursor.getInt(_cursorIndexOfGroupMemberLastChangedBy);
            _result.setGroupMemberLastChangedBy(_tmpGroupMemberLastChangedBy);
            final long _tmpGroupMemberLct;
            _tmpGroupMemberLct = _cursor.getLong(_cursorIndexOfGroupMemberLct);
            _result.setGroupMemberLct(_tmpGroupMemberLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
