package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.lifecycle.LiveData;
import androidx.paging.DataSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Schedule;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class ScheduleDao_Impl extends ScheduleDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Schedule> __insertionAdapterOfSchedule;

  private final EntityDeletionOrUpdateAdapter<Schedule> __updateAdapterOfSchedule;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  private final SharedSQLiteStatement __preparedStmtOfUpdateScheduleActivated;

  public ScheduleDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfSchedule = new EntityInsertionAdapter<Schedule>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `Schedule` (`scheduleUid`,`sceduleStartTime`,`scheduleEndTime`,`scheduleDay`,`scheduleMonth`,`scheduleFrequency`,`umCalendarUid`,`scheduleClazzUid`,`scheduleMasterChangeSeqNum`,`scheduleLocalChangeSeqNum`,`scheduleLastChangedBy`,`scheduleLastChangedTime`,`scheduleActive`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Schedule value) {
        stmt.bindLong(1, value.getScheduleUid());
        stmt.bindLong(2, value.getSceduleStartTime());
        stmt.bindLong(3, value.getScheduleEndTime());
        stmt.bindLong(4, value.getScheduleDay());
        stmt.bindLong(5, value.getScheduleMonth());
        stmt.bindLong(6, value.getScheduleFrequency());
        stmt.bindLong(7, value.getUmCalendarUid());
        stmt.bindLong(8, value.getScheduleClazzUid());
        stmt.bindLong(9, value.getScheduleMasterChangeSeqNum());
        stmt.bindLong(10, value.getScheduleLocalChangeSeqNum());
        stmt.bindLong(11, value.getScheduleLastChangedBy());
        stmt.bindLong(12, value.getScheduleLastChangedTime());
        final int _tmp = value.getScheduleActive() ? 1 : 0;
        stmt.bindLong(13, _tmp);
      }
    };
    this.__updateAdapterOfSchedule = new EntityDeletionOrUpdateAdapter<Schedule>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `Schedule` SET `scheduleUid` = ?,`sceduleStartTime` = ?,`scheduleEndTime` = ?,`scheduleDay` = ?,`scheduleMonth` = ?,`scheduleFrequency` = ?,`umCalendarUid` = ?,`scheduleClazzUid` = ?,`scheduleMasterChangeSeqNum` = ?,`scheduleLocalChangeSeqNum` = ?,`scheduleLastChangedBy` = ?,`scheduleLastChangedTime` = ?,`scheduleActive` = ? WHERE `scheduleUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Schedule value) {
        stmt.bindLong(1, value.getScheduleUid());
        stmt.bindLong(2, value.getSceduleStartTime());
        stmt.bindLong(3, value.getScheduleEndTime());
        stmt.bindLong(4, value.getScheduleDay());
        stmt.bindLong(5, value.getScheduleMonth());
        stmt.bindLong(6, value.getScheduleFrequency());
        stmt.bindLong(7, value.getUmCalendarUid());
        stmt.bindLong(8, value.getScheduleClazzUid());
        stmt.bindLong(9, value.getScheduleMasterChangeSeqNum());
        stmt.bindLong(10, value.getScheduleLocalChangeSeqNum());
        stmt.bindLong(11, value.getScheduleLastChangedBy());
        stmt.bindLong(12, value.getScheduleLastChangedTime());
        final int _tmp = value.getScheduleActive() ? 1 : 0;
        stmt.bindLong(13, _tmp);
        stmt.bindLong(14, value.getScheduleUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "     REPLACE INTO ScheduleReplicate(schedulePk, scheduleDestination)\n"
                + "      SELECT DISTINCT Schedule.scheduleUid AS schedulePk,\n"
                + "             ? AS scheduleDestination\n"
                + "        FROM UserSession\n"
                + "              JOIN PersonGroupMember\n"
                + "                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n"
                + "              \n"
                + "               JOIN ScopedGrant\n"
                + "                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n"
                + "                        AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "                    2\n"
                + "                    \n"
                + "                       ) > 0\n"
                + "               JOIN Clazz \n"
                + "                    ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "        \n"
                + "              JOIN Schedule\n"
                + "                   ON Schedule.scheduleClazzUid = Clazz.clazzUid\n"
                + "       WHERE UserSession.usClientNodeId = ?\n"
                + "         AND UserSession.usStatus = 1\n"
                + "         AND Schedule.scheduleLastChangedTime != COALESCE(\n"
                + "             (SELECT scheduleVersionId\n"
                + "                FROM ScheduleReplicate\n"
                + "               WHERE schedulePk = Schedule.scheduleUid\n"
                + "                 AND scheduleDestination = ?), 0) \n"
                + "      /*psql ON CONFLICT(schedulePk, scheduleDestination) DO UPDATE\n"
                + "             SET schedulePending = true\n"
                + "      */       \n"
                + " ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + " REPLACE INTO ScheduleReplicate(schedulePk, scheduleDestination)\n"
                + "  SELECT DISTINCT Schedule.scheduleUid AS scheduleUid,\n"
                + "         UserSession.usClientNodeId AS scheduleDestination\n"
                + "    FROM ChangeLog\n"
                + "         JOIN Schedule\n"
                + "              ON ChangeLog.chTableId = 21\n"
                + "                 AND Schedule.scheduleUid = ChangeLog.chEntityPk\n"
                + "         JOIN Clazz\n"
                + "              ON Clazz.clazzUid = Schedule.scheduleClazzUid\n"
                + "         \n"
                + "            JOIN ScopedGrant\n"
                + "                 ON \n"
                + "            ((ScopedGrant.sgTableId = -2\n"
                + "                                AND ScopedGrant.sgEntityUid = -2)\n"
                + "                            OR (ScopedGrant.sgTableId = 6\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n"
                + "                            OR (ScopedGrant.sgTableId = 164\n"
                + "                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n"
                + "        \n"
                + "                    AND (ScopedGrant.sgPermissions & \n"
                + "        \n"
                + "              2\n"
                + "              \n"
                + "              \n"
                + "                                                       ) > 0\n"
                + "             JOIN PersonGroupMember AS PrsGrpMbr\n"
                + "                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n"
                + "                                               \n"
                + "              JOIN UserSession\n"
                + "                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n"
                + "                      AND UserSession.usStatus = 1\n"
                + "        \n"
                + "   WHERE UserSession.usClientNodeId != (\n"
                + "         SELECT nodeClientId \n"
                + "           FROM SyncNode\n"
                + "          LIMIT 1)\n"
                + "     AND Schedule.scheduleLastChangedTime != COALESCE(\n"
                + "         (SELECT scheduleVersionId\n"
                + "            FROM ScheduleReplicate\n"
                + "           WHERE schedulePk = Schedule.scheduleUid\n"
                + "             AND scheduleDestination = UserSession.usClientNodeId), 0)\n"
                + " /*psql ON CONFLICT(schedulePk, scheduleDestination) DO UPDATE\n"
                + "     SET schedulePending = true\n"
                + "  */               \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateScheduleActivated = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE Schedule \n"
                + "           SET scheduleActive = ?,\n"
                + "               scheduleLastChangedTime = ?\n"
                + "         WHERE scheduleUid = ?\n"
                + "            ";
        return _query;
      }
    };
  }

  @Override
  public long insert(final Schedule entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfSchedule.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final Schedule entity, final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfSchedule.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void insertList(final List<? extends Schedule> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfSchedule.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertListAsync(final List<? extends Schedule> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfSchedule.insert(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public void updateList(final List<? extends Schedule> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfSchedule.handleMultiple(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final Schedule entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfSchedule.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateListAsync(final List<? extends Schedule> entityList,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfSchedule.handleMultiple(entityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object updateAsync(final Schedule entity,
      final Continuation<? super Integer> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Integer>() {
      @Override
      public Integer call() throws Exception {
        int _total = 0;
        __db.beginTransaction();
        try {
          _total +=__updateAdapterOfSchedule.handle(entity);
          __db.setTransactionSuccessful();
          return _total;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateScheduleActivated(final long scheduleUid, final boolean active,
      final long changeTime, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateScheduleActivated.acquire();
        int _argIndex = 1;
        final int _tmp = active ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, scheduleUid);
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateScheduleActivated.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Schedule findByUid(final long uid) {
    final String _sql = "SELECT * FROM Schedule WHERE scheduleUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleUid");
      final int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "sceduleStartTime");
      final int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleEndTime");
      final int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleDay");
      final int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMonth");
      final int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleFrequency");
      final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
      final int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleClazzUid");
      final int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMasterChangeSeqNum");
      final int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLocalChangeSeqNum");
      final int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedBy");
      final int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedTime");
      final int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleActive");
      final Schedule _result;
      if(_cursor.moveToFirst()) {
        _result = new Schedule();
        final long _tmpScheduleUid;
        _tmpScheduleUid = _cursor.getLong(_cursorIndexOfScheduleUid);
        _result.setScheduleUid(_tmpScheduleUid);
        final long _tmpSceduleStartTime;
        _tmpSceduleStartTime = _cursor.getLong(_cursorIndexOfSceduleStartTime);
        _result.setSceduleStartTime(_tmpSceduleStartTime);
        final long _tmpScheduleEndTime;
        _tmpScheduleEndTime = _cursor.getLong(_cursorIndexOfScheduleEndTime);
        _result.setScheduleEndTime(_tmpScheduleEndTime);
        final int _tmpScheduleDay;
        _tmpScheduleDay = _cursor.getInt(_cursorIndexOfScheduleDay);
        _result.setScheduleDay(_tmpScheduleDay);
        final int _tmpScheduleMonth;
        _tmpScheduleMonth = _cursor.getInt(_cursorIndexOfScheduleMonth);
        _result.setScheduleMonth(_tmpScheduleMonth);
        final int _tmpScheduleFrequency;
        _tmpScheduleFrequency = _cursor.getInt(_cursorIndexOfScheduleFrequency);
        _result.setScheduleFrequency(_tmpScheduleFrequency);
        final long _tmpUmCalendarUid;
        _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
        _result.setUmCalendarUid(_tmpUmCalendarUid);
        final long _tmpScheduleClazzUid;
        _tmpScheduleClazzUid = _cursor.getLong(_cursorIndexOfScheduleClazzUid);
        _result.setScheduleClazzUid(_tmpScheduleClazzUid);
        final long _tmpScheduleMasterChangeSeqNum;
        _tmpScheduleMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
        _result.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
        final long _tmpScheduleLocalChangeSeqNum;
        _tmpScheduleLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
        _result.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
        final int _tmpScheduleLastChangedBy;
        _tmpScheduleLastChangedBy = _cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
        _result.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
        final long _tmpScheduleLastChangedTime;
        _tmpScheduleLastChangedTime = _cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
        _result.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
        final boolean _tmpScheduleActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfScheduleActive);
        _tmpScheduleActive = _tmp != 0;
        _result.setScheduleActive(_tmpScheduleActive);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object findByUidAsync(final long uid, final Continuation<? super Schedule> continuation) {
    final String _sql = "SELECT * FROM Schedule WHERE scheduleUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Schedule>() {
      @Override
      public Schedule call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleUid");
          final int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "sceduleStartTime");
          final int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleEndTime");
          final int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleDay");
          final int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMonth");
          final int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleFrequency");
          final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
          final int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleClazzUid");
          final int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMasterChangeSeqNum");
          final int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLocalChangeSeqNum");
          final int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedBy");
          final int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedTime");
          final int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleActive");
          final Schedule _result;
          if(_cursor.moveToFirst()) {
            _result = new Schedule();
            final long _tmpScheduleUid;
            _tmpScheduleUid = _cursor.getLong(_cursorIndexOfScheduleUid);
            _result.setScheduleUid(_tmpScheduleUid);
            final long _tmpSceduleStartTime;
            _tmpSceduleStartTime = _cursor.getLong(_cursorIndexOfSceduleStartTime);
            _result.setSceduleStartTime(_tmpSceduleStartTime);
            final long _tmpScheduleEndTime;
            _tmpScheduleEndTime = _cursor.getLong(_cursorIndexOfScheduleEndTime);
            _result.setScheduleEndTime(_tmpScheduleEndTime);
            final int _tmpScheduleDay;
            _tmpScheduleDay = _cursor.getInt(_cursorIndexOfScheduleDay);
            _result.setScheduleDay(_tmpScheduleDay);
            final int _tmpScheduleMonth;
            _tmpScheduleMonth = _cursor.getInt(_cursorIndexOfScheduleMonth);
            _result.setScheduleMonth(_tmpScheduleMonth);
            final int _tmpScheduleFrequency;
            _tmpScheduleFrequency = _cursor.getInt(_cursorIndexOfScheduleFrequency);
            _result.setScheduleFrequency(_tmpScheduleFrequency);
            final long _tmpUmCalendarUid;
            _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
            _result.setUmCalendarUid(_tmpUmCalendarUid);
            final long _tmpScheduleClazzUid;
            _tmpScheduleClazzUid = _cursor.getLong(_cursorIndexOfScheduleClazzUid);
            _result.setScheduleClazzUid(_tmpScheduleClazzUid);
            final long _tmpScheduleMasterChangeSeqNum;
            _tmpScheduleMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
            _result.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
            final long _tmpScheduleLocalChangeSeqNum;
            _tmpScheduleLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
            _result.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
            final int _tmpScheduleLastChangedBy;
            _tmpScheduleLastChangedBy = _cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
            _result.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
            final long _tmpScheduleLastChangedTime;
            _tmpScheduleLastChangedTime = _cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
            _result.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
            final boolean _tmpScheduleActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfScheduleActive);
            _tmpScheduleActive = _tmp != 0;
            _result.setScheduleActive(_tmpScheduleActive);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public DataSource.Factory<Integer, Schedule> findAllSchedulesByClazzUid(final long clazzUid) {
    final String _sql = "SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1 ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    return new DataSource.Factory<Integer, Schedule>() {
      @Override
      public LimitOffsetDataSource<Schedule> create() {
        return new LimitOffsetDataSource<Schedule>(__db, _statement, false, true , "Schedule") {
          @Override
          protected List<Schedule> convertRows(Cursor cursor) {
            final int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleUid");
            final int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow(cursor, "sceduleStartTime");
            final int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleEndTime");
            final int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleDay");
            final int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleMonth");
            final int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleFrequency");
            final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(cursor, "umCalendarUid");
            final int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleClazzUid");
            final int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleMasterChangeSeqNum");
            final int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleLocalChangeSeqNum");
            final int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleLastChangedBy");
            final int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleLastChangedTime");
            final int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow(cursor, "scheduleActive");
            final List<Schedule> _res = new ArrayList<Schedule>(cursor.getCount());
            while(cursor.moveToNext()) {
              final Schedule _item;
              _item = new Schedule();
              final long _tmpScheduleUid;
              _tmpScheduleUid = cursor.getLong(_cursorIndexOfScheduleUid);
              _item.setScheduleUid(_tmpScheduleUid);
              final long _tmpSceduleStartTime;
              _tmpSceduleStartTime = cursor.getLong(_cursorIndexOfSceduleStartTime);
              _item.setSceduleStartTime(_tmpSceduleStartTime);
              final long _tmpScheduleEndTime;
              _tmpScheduleEndTime = cursor.getLong(_cursorIndexOfScheduleEndTime);
              _item.setScheduleEndTime(_tmpScheduleEndTime);
              final int _tmpScheduleDay;
              _tmpScheduleDay = cursor.getInt(_cursorIndexOfScheduleDay);
              _item.setScheduleDay(_tmpScheduleDay);
              final int _tmpScheduleMonth;
              _tmpScheduleMonth = cursor.getInt(_cursorIndexOfScheduleMonth);
              _item.setScheduleMonth(_tmpScheduleMonth);
              final int _tmpScheduleFrequency;
              _tmpScheduleFrequency = cursor.getInt(_cursorIndexOfScheduleFrequency);
              _item.setScheduleFrequency(_tmpScheduleFrequency);
              final long _tmpUmCalendarUid;
              _tmpUmCalendarUid = cursor.getLong(_cursorIndexOfUmCalendarUid);
              _item.setUmCalendarUid(_tmpUmCalendarUid);
              final long _tmpScheduleClazzUid;
              _tmpScheduleClazzUid = cursor.getLong(_cursorIndexOfScheduleClazzUid);
              _item.setScheduleClazzUid(_tmpScheduleClazzUid);
              final long _tmpScheduleMasterChangeSeqNum;
              _tmpScheduleMasterChangeSeqNum = cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
              _item.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
              final long _tmpScheduleLocalChangeSeqNum;
              _tmpScheduleLocalChangeSeqNum = cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
              _item.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
              final int _tmpScheduleLastChangedBy;
              _tmpScheduleLastChangedBy = cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
              _item.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
              final long _tmpScheduleLastChangedTime;
              _tmpScheduleLastChangedTime = cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
              _item.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
              final boolean _tmpScheduleActive;
              final int _tmp;
              _tmp = cursor.getInt(_cursorIndexOfScheduleActive);
              _tmpScheduleActive = _tmp != 0;
              _item.setScheduleActive(_tmpScheduleActive);
              _res.add(_item);
            }
            return _res;
          }
        };
      }
    };
  }

  @Override
  public List<Schedule> findAllSchedulesByClazzUidAsList(final long clazzUid) {
    final String _sql = "SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleUid");
      final int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "sceduleStartTime");
      final int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleEndTime");
      final int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleDay");
      final int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMonth");
      final int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleFrequency");
      final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
      final int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleClazzUid");
      final int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMasterChangeSeqNum");
      final int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLocalChangeSeqNum");
      final int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedBy");
      final int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedTime");
      final int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleActive");
      final List<Schedule> _result = new ArrayList<Schedule>(_cursor.getCount());
      while(_cursor.moveToNext()) {
        final Schedule _item;
        _item = new Schedule();
        final long _tmpScheduleUid;
        _tmpScheduleUid = _cursor.getLong(_cursorIndexOfScheduleUid);
        _item.setScheduleUid(_tmpScheduleUid);
        final long _tmpSceduleStartTime;
        _tmpSceduleStartTime = _cursor.getLong(_cursorIndexOfSceduleStartTime);
        _item.setSceduleStartTime(_tmpSceduleStartTime);
        final long _tmpScheduleEndTime;
        _tmpScheduleEndTime = _cursor.getLong(_cursorIndexOfScheduleEndTime);
        _item.setScheduleEndTime(_tmpScheduleEndTime);
        final int _tmpScheduleDay;
        _tmpScheduleDay = _cursor.getInt(_cursorIndexOfScheduleDay);
        _item.setScheduleDay(_tmpScheduleDay);
        final int _tmpScheduleMonth;
        _tmpScheduleMonth = _cursor.getInt(_cursorIndexOfScheduleMonth);
        _item.setScheduleMonth(_tmpScheduleMonth);
        final int _tmpScheduleFrequency;
        _tmpScheduleFrequency = _cursor.getInt(_cursorIndexOfScheduleFrequency);
        _item.setScheduleFrequency(_tmpScheduleFrequency);
        final long _tmpUmCalendarUid;
        _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
        _item.setUmCalendarUid(_tmpUmCalendarUid);
        final long _tmpScheduleClazzUid;
        _tmpScheduleClazzUid = _cursor.getLong(_cursorIndexOfScheduleClazzUid);
        _item.setScheduleClazzUid(_tmpScheduleClazzUid);
        final long _tmpScheduleMasterChangeSeqNum;
        _tmpScheduleMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
        _item.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
        final long _tmpScheduleLocalChangeSeqNum;
        _tmpScheduleLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
        _item.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
        final int _tmpScheduleLastChangedBy;
        _tmpScheduleLastChangedBy = _cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
        _item.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
        final long _tmpScheduleLastChangedTime;
        _tmpScheduleLastChangedTime = _cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
        _item.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
        final boolean _tmpScheduleActive;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfScheduleActive);
        _tmpScheduleActive = _tmp != 0;
        _item.setScheduleActive(_tmpScheduleActive);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public LiveData<List<Schedule>> findAllSchedulesByClazzUidAsLiveList(final long clazzUid) {
    final String _sql = "SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    return __db.getInvalidationTracker().createLiveData(new String[]{"Schedule"}, false, new Callable<List<Schedule>>() {
      @Override
      public List<Schedule> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleUid");
          final int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "sceduleStartTime");
          final int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleEndTime");
          final int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleDay");
          final int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMonth");
          final int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleFrequency");
          final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
          final int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleClazzUid");
          final int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMasterChangeSeqNum");
          final int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLocalChangeSeqNum");
          final int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedBy");
          final int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedTime");
          final int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleActive");
          final List<Schedule> _result = new ArrayList<Schedule>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Schedule _item;
            _item = new Schedule();
            final long _tmpScheduleUid;
            _tmpScheduleUid = _cursor.getLong(_cursorIndexOfScheduleUid);
            _item.setScheduleUid(_tmpScheduleUid);
            final long _tmpSceduleStartTime;
            _tmpSceduleStartTime = _cursor.getLong(_cursorIndexOfSceduleStartTime);
            _item.setSceduleStartTime(_tmpSceduleStartTime);
            final long _tmpScheduleEndTime;
            _tmpScheduleEndTime = _cursor.getLong(_cursorIndexOfScheduleEndTime);
            _item.setScheduleEndTime(_tmpScheduleEndTime);
            final int _tmpScheduleDay;
            _tmpScheduleDay = _cursor.getInt(_cursorIndexOfScheduleDay);
            _item.setScheduleDay(_tmpScheduleDay);
            final int _tmpScheduleMonth;
            _tmpScheduleMonth = _cursor.getInt(_cursorIndexOfScheduleMonth);
            _item.setScheduleMonth(_tmpScheduleMonth);
            final int _tmpScheduleFrequency;
            _tmpScheduleFrequency = _cursor.getInt(_cursorIndexOfScheduleFrequency);
            _item.setScheduleFrequency(_tmpScheduleFrequency);
            final long _tmpUmCalendarUid;
            _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
            _item.setUmCalendarUid(_tmpUmCalendarUid);
            final long _tmpScheduleClazzUid;
            _tmpScheduleClazzUid = _cursor.getLong(_cursorIndexOfScheduleClazzUid);
            _item.setScheduleClazzUid(_tmpScheduleClazzUid);
            final long _tmpScheduleMasterChangeSeqNum;
            _tmpScheduleMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
            _item.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
            final long _tmpScheduleLocalChangeSeqNum;
            _tmpScheduleLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
            _item.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
            final int _tmpScheduleLastChangedBy;
            _tmpScheduleLastChangedBy = _cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
            _item.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
            final long _tmpScheduleLastChangedTime;
            _tmpScheduleLastChangedTime = _cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
            _item.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
            final boolean _tmpScheduleActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfScheduleActive);
            _tmpScheduleActive = _tmp != 0;
            _item.setScheduleActive(_tmpScheduleActive);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object findAllSchedulesByClazzUidAsync(final long clazzUid,
      final Continuation<? super List<Schedule>> continuation) {
    final String _sql = "SELECT * FROM Schedule WHERE scheduleClazzUid = ? AND CAST(scheduleActive AS INTEGER) = 1 ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, clazzUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Schedule>>() {
      @Override
      public List<Schedule> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfScheduleUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleUid");
          final int _cursorIndexOfSceduleStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "sceduleStartTime");
          final int _cursorIndexOfScheduleEndTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleEndTime");
          final int _cursorIndexOfScheduleDay = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleDay");
          final int _cursorIndexOfScheduleMonth = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMonth");
          final int _cursorIndexOfScheduleFrequency = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleFrequency");
          final int _cursorIndexOfUmCalendarUid = CursorUtil.getColumnIndexOrThrow(_cursor, "umCalendarUid");
          final int _cursorIndexOfScheduleClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleClazzUid");
          final int _cursorIndexOfScheduleMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleMasterChangeSeqNum");
          final int _cursorIndexOfScheduleLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLocalChangeSeqNum");
          final int _cursorIndexOfScheduleLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedBy");
          final int _cursorIndexOfScheduleLastChangedTime = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleLastChangedTime");
          final int _cursorIndexOfScheduleActive = CursorUtil.getColumnIndexOrThrow(_cursor, "scheduleActive");
          final List<Schedule> _result = new ArrayList<Schedule>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final Schedule _item;
            _item = new Schedule();
            final long _tmpScheduleUid;
            _tmpScheduleUid = _cursor.getLong(_cursorIndexOfScheduleUid);
            _item.setScheduleUid(_tmpScheduleUid);
            final long _tmpSceduleStartTime;
            _tmpSceduleStartTime = _cursor.getLong(_cursorIndexOfSceduleStartTime);
            _item.setSceduleStartTime(_tmpSceduleStartTime);
            final long _tmpScheduleEndTime;
            _tmpScheduleEndTime = _cursor.getLong(_cursorIndexOfScheduleEndTime);
            _item.setScheduleEndTime(_tmpScheduleEndTime);
            final int _tmpScheduleDay;
            _tmpScheduleDay = _cursor.getInt(_cursorIndexOfScheduleDay);
            _item.setScheduleDay(_tmpScheduleDay);
            final int _tmpScheduleMonth;
            _tmpScheduleMonth = _cursor.getInt(_cursorIndexOfScheduleMonth);
            _item.setScheduleMonth(_tmpScheduleMonth);
            final int _tmpScheduleFrequency;
            _tmpScheduleFrequency = _cursor.getInt(_cursorIndexOfScheduleFrequency);
            _item.setScheduleFrequency(_tmpScheduleFrequency);
            final long _tmpUmCalendarUid;
            _tmpUmCalendarUid = _cursor.getLong(_cursorIndexOfUmCalendarUid);
            _item.setUmCalendarUid(_tmpUmCalendarUid);
            final long _tmpScheduleClazzUid;
            _tmpScheduleClazzUid = _cursor.getLong(_cursorIndexOfScheduleClazzUid);
            _item.setScheduleClazzUid(_tmpScheduleClazzUid);
            final long _tmpScheduleMasterChangeSeqNum;
            _tmpScheduleMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleMasterChangeSeqNum);
            _item.setScheduleMasterChangeSeqNum(_tmpScheduleMasterChangeSeqNum);
            final long _tmpScheduleLocalChangeSeqNum;
            _tmpScheduleLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfScheduleLocalChangeSeqNum);
            _item.setScheduleLocalChangeSeqNum(_tmpScheduleLocalChangeSeqNum);
            final int _tmpScheduleLastChangedBy;
            _tmpScheduleLastChangedBy = _cursor.getInt(_cursorIndexOfScheduleLastChangedBy);
            _item.setScheduleLastChangedBy(_tmpScheduleLastChangedBy);
            final long _tmpScheduleLastChangedTime;
            _tmpScheduleLastChangedTime = _cursor.getLong(_cursorIndexOfScheduleLastChangedTime);
            _item.setScheduleLastChangedTime(_tmpScheduleLastChangedTime);
            final boolean _tmpScheduleActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfScheduleActive);
            _tmpScheduleActive = _tmp != 0;
            _item.setScheduleActive(_tmpScheduleActive);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
