package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.Site;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@SuppressWarnings({"unchecked", "deprecation"})
public final class SiteDao_Impl extends SiteDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Site> __insertionAdapterOfSite;

  private final EntityInsertionAdapter<Site> __insertionAdapterOfSite_1;

  private final EntityDeletionOrUpdateAdapter<Site> __updateAdapterOfSite;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnNewNode;

  private final SharedSQLiteStatement __preparedStmtOfReplicateOnChange;

  public SiteDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfSite = new EntityInsertionAdapter<Site>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR REPLACE INTO `Site` (`siteUid`,`sitePcsn`,`siteLcsn`,`siteLcb`,`siteLct`,`siteName`,`guestLogin`,`registrationAllowed`,`authSalt`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Site value) {
        stmt.bindLong(1, value.getSiteUid());
        stmt.bindLong(2, value.getSitePcsn());
        stmt.bindLong(3, value.getSiteLcsn());
        stmt.bindLong(4, value.getSiteLcb());
        stmt.bindLong(5, value.getSiteLct());
        if (value.getSiteName() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getSiteName());
        }
        final int _tmp = value.getGuestLogin() ? 1 : 0;
        stmt.bindLong(7, _tmp);
        final int _tmp_1 = value.getRegistrationAllowed() ? 1 : 0;
        stmt.bindLong(8, _tmp_1);
        if (value.getAuthSalt() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getAuthSalt());
        }
      }
    };
    this.__insertionAdapterOfSite_1 = new EntityInsertionAdapter<Site>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `Site` (`siteUid`,`sitePcsn`,`siteLcsn`,`siteLcb`,`siteLct`,`siteName`,`guestLogin`,`registrationAllowed`,`authSalt`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Site value) {
        stmt.bindLong(1, value.getSiteUid());
        stmt.bindLong(2, value.getSitePcsn());
        stmt.bindLong(3, value.getSiteLcsn());
        stmt.bindLong(4, value.getSiteLcb());
        stmt.bindLong(5, value.getSiteLct());
        if (value.getSiteName() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getSiteName());
        }
        final int _tmp = value.getGuestLogin() ? 1 : 0;
        stmt.bindLong(7, _tmp);
        final int _tmp_1 = value.getRegistrationAllowed() ? 1 : 0;
        stmt.bindLong(8, _tmp_1);
        if (value.getAuthSalt() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getAuthSalt());
        }
      }
    };
    this.__updateAdapterOfSite = new EntityDeletionOrUpdateAdapter<Site>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `Site` SET `siteUid` = ?,`sitePcsn` = ?,`siteLcsn` = ?,`siteLcb` = ?,`siteLct` = ?,`siteName` = ?,`guestLogin` = ?,`registrationAllowed` = ?,`authSalt` = ? WHERE `siteUid` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Site value) {
        stmt.bindLong(1, value.getSiteUid());
        stmt.bindLong(2, value.getSitePcsn());
        stmt.bindLong(3, value.getSiteLcsn());
        stmt.bindLong(4, value.getSiteLcb());
        stmt.bindLong(5, value.getSiteLct());
        if (value.getSiteName() == null) {
          stmt.bindNull(6);
        } else {
          stmt.bindString(6, value.getSiteName());
        }
        final int _tmp = value.getGuestLogin() ? 1 : 0;
        stmt.bindLong(7, _tmp);
        final int _tmp_1 = value.getRegistrationAllowed() ? 1 : 0;
        stmt.bindLong(8, _tmp_1);
        if (value.getAuthSalt() == null) {
          stmt.bindNull(9);
        } else {
          stmt.bindString(9, value.getAuthSalt());
        }
        stmt.bindLong(10, value.getSiteUid());
      }
    };
    this.__preparedStmtOfReplicateOnNewNode = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        REPLACE INTO SiteReplicate(sitePk, siteDestination)\n"
                + "         SELECT DISTINCT Site.siteUid AS sitePk,\n"
                + "                ? AS siteDestination\n"
                + "           FROM Site\n"
                + "          WHERE Site.siteLct != COALESCE(\n"
                + "                (SELECT siteVersionId\n"
                + "                   FROM SiteReplicate\n"
                + "                  WHERE sitePk = Site.siteUid\n"
                + "                    AND siteDestination = ?), 0) \n"
                + "         /*psql ON CONFLICT(sitePk, siteDestination) DO UPDATE\n"
                + "                SET sitePending = true\n"
                + "         */       \n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfReplicateOnChange = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        REPLACE INTO SiteReplicate(sitePk, siteDestination)\n"
                + "         SELECT DISTINCT Site.siteUid AS sitePk,\n"
                + "                UserSession.usClientNodeId AS siteDestination\n"
                + "           FROM ChangeLog\n"
                + "                JOIN Site \n"
                + "                    ON ChangeLog.chTableId = 189 \n"
                + "                       AND ChangeLog.chEntityPk = Site.siteUid\n"
                + "                JOIN UserSession ON UserSession.usStatus = 1\n"
                + "          WHERE UserSession.usClientNodeId != (\n"
                + "                SELECT nodeClientId \n"
                + "                  FROM SyncNode\n"
                + "                 LIMIT 1)\n"
                + "            AND Site.siteLct != COALESCE(\n"
                + "                (SELECT siteVersionId\n"
                + "                   FROM SiteReplicate\n"
                + "                  WHERE sitePk = Site.siteUid\n"
                + "                    AND siteDestination = UserSession.usClientNodeId), 0)     \n"
                + "        /*psql  ON CONFLICT(sitePk, siteDestination) DO UPDATE\n"
                + "            SET sitePending = true\n"
                + "         */               \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object replaceAsync(final Site site, final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfSite.insertAndReturnId(site);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public long insert(final Site site) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfSite_1.insertAndReturnId(site);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object updateAsync(final Site workspace, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfSite.handle(workspace);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnNewNode(final long newNodeId,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnNewNode.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, newNodeId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, newNodeId);
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnNewNode.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object replicateOnChange(final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfReplicateOnChange.acquire();
        __db.beginTransaction();
        try {
          _stmt.executeInsert();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfReplicateOnChange.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Site getSite() {
    final String _sql = "SELECT * FROM Site LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfSiteUid = CursorUtil.getColumnIndexOrThrow(_cursor, "siteUid");
      final int _cursorIndexOfSitePcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sitePcsn");
      final int _cursorIndexOfSiteLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "siteLcsn");
      final int _cursorIndexOfSiteLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "siteLcb");
      final int _cursorIndexOfSiteLct = CursorUtil.getColumnIndexOrThrow(_cursor, "siteLct");
      final int _cursorIndexOfSiteName = CursorUtil.getColumnIndexOrThrow(_cursor, "siteName");
      final int _cursorIndexOfGuestLogin = CursorUtil.getColumnIndexOrThrow(_cursor, "guestLogin");
      final int _cursorIndexOfRegistrationAllowed = CursorUtil.getColumnIndexOrThrow(_cursor, "registrationAllowed");
      final int _cursorIndexOfAuthSalt = CursorUtil.getColumnIndexOrThrow(_cursor, "authSalt");
      final Site _result;
      if(_cursor.moveToFirst()) {
        _result = new Site();
        final long _tmpSiteUid;
        _tmpSiteUid = _cursor.getLong(_cursorIndexOfSiteUid);
        _result.setSiteUid(_tmpSiteUid);
        final long _tmpSitePcsn;
        _tmpSitePcsn = _cursor.getLong(_cursorIndexOfSitePcsn);
        _result.setSitePcsn(_tmpSitePcsn);
        final long _tmpSiteLcsn;
        _tmpSiteLcsn = _cursor.getLong(_cursorIndexOfSiteLcsn);
        _result.setSiteLcsn(_tmpSiteLcsn);
        final int _tmpSiteLcb;
        _tmpSiteLcb = _cursor.getInt(_cursorIndexOfSiteLcb);
        _result.setSiteLcb(_tmpSiteLcb);
        final long _tmpSiteLct;
        _tmpSiteLct = _cursor.getLong(_cursorIndexOfSiteLct);
        _result.setSiteLct(_tmpSiteLct);
        final String _tmpSiteName;
        if (_cursor.isNull(_cursorIndexOfSiteName)) {
          _tmpSiteName = null;
        } else {
          _tmpSiteName = _cursor.getString(_cursorIndexOfSiteName);
        }
        _result.setSiteName(_tmpSiteName);
        final boolean _tmpGuestLogin;
        final int _tmp;
        _tmp = _cursor.getInt(_cursorIndexOfGuestLogin);
        _tmpGuestLogin = _tmp != 0;
        _result.setGuestLogin(_tmpGuestLogin);
        final boolean _tmpRegistrationAllowed;
        final int _tmp_1;
        _tmp_1 = _cursor.getInt(_cursorIndexOfRegistrationAllowed);
        _tmpRegistrationAllowed = _tmp_1 != 0;
        _result.setRegistrationAllowed(_tmpRegistrationAllowed);
        final String _tmpAuthSalt;
        if (_cursor.isNull(_cursorIndexOfAuthSalt)) {
          _tmpAuthSalt = null;
        } else {
          _tmpAuthSalt = _cursor.getString(_cursorIndexOfAuthSalt);
        }
        _result.setAuthSalt(_tmpAuthSalt);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public Object getSiteAsync(final Continuation<? super Site> continuation) {
    final String _sql = "SELECT * FROM Site LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Site>() {
      @Override
      public Site call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfSiteUid = CursorUtil.getColumnIndexOrThrow(_cursor, "siteUid");
          final int _cursorIndexOfSitePcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "sitePcsn");
          final int _cursorIndexOfSiteLcsn = CursorUtil.getColumnIndexOrThrow(_cursor, "siteLcsn");
          final int _cursorIndexOfSiteLcb = CursorUtil.getColumnIndexOrThrow(_cursor, "siteLcb");
          final int _cursorIndexOfSiteLct = CursorUtil.getColumnIndexOrThrow(_cursor, "siteLct");
          final int _cursorIndexOfSiteName = CursorUtil.getColumnIndexOrThrow(_cursor, "siteName");
          final int _cursorIndexOfGuestLogin = CursorUtil.getColumnIndexOrThrow(_cursor, "guestLogin");
          final int _cursorIndexOfRegistrationAllowed = CursorUtil.getColumnIndexOrThrow(_cursor, "registrationAllowed");
          final int _cursorIndexOfAuthSalt = CursorUtil.getColumnIndexOrThrow(_cursor, "authSalt");
          final Site _result;
          if(_cursor.moveToFirst()) {
            _result = new Site();
            final long _tmpSiteUid;
            _tmpSiteUid = _cursor.getLong(_cursorIndexOfSiteUid);
            _result.setSiteUid(_tmpSiteUid);
            final long _tmpSitePcsn;
            _tmpSitePcsn = _cursor.getLong(_cursorIndexOfSitePcsn);
            _result.setSitePcsn(_tmpSitePcsn);
            final long _tmpSiteLcsn;
            _tmpSiteLcsn = _cursor.getLong(_cursorIndexOfSiteLcsn);
            _result.setSiteLcsn(_tmpSiteLcsn);
            final int _tmpSiteLcb;
            _tmpSiteLcb = _cursor.getInt(_cursorIndexOfSiteLcb);
            _result.setSiteLcb(_tmpSiteLcb);
            final long _tmpSiteLct;
            _tmpSiteLct = _cursor.getLong(_cursorIndexOfSiteLct);
            _result.setSiteLct(_tmpSiteLct);
            final String _tmpSiteName;
            if (_cursor.isNull(_cursorIndexOfSiteName)) {
              _tmpSiteName = null;
            } else {
              _tmpSiteName = _cursor.getString(_cursorIndexOfSiteName);
            }
            _result.setSiteName(_tmpSiteName);
            final boolean _tmpGuestLogin;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfGuestLogin);
            _tmpGuestLogin = _tmp != 0;
            _result.setGuestLogin(_tmpGuestLogin);
            final boolean _tmpRegistrationAllowed;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfRegistrationAllowed);
            _tmpRegistrationAllowed = _tmp_1 != 0;
            _result.setRegistrationAllowed(_tmpRegistrationAllowed);
            final String _tmpAuthSalt;
            if (_cursor.isNull(_cursorIndexOfAuthSalt)) {
              _tmpAuthSalt = null;
            } else {
              _tmpAuthSalt = _cursor.getString(_cursorIndexOfAuthSalt);
            }
            _result.setAuthSalt(_tmpAuthSalt);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object getSiteAuthSaltAsync(final Continuation<? super String> continuation) {
    final String _sql = "SELECT authSalt FROM Site LIMIT 1";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<String>() {
      @Override
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if(_cursor.moveToFirst()) {
            if (_cursor.isNull(0)) {
              _result = null;
            } else {
              _result = _cursor.getString(0);
            }
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
