package com.ustadmobile.core.db.dao

import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.ClazzContentJoin
import kotlin.Boolean
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

public class ClazzContentJoinDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: ClazzContentJoinDao,
) : ClazzContentJoinDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override suspend fun toggleVisibilityClazzContent(
    toggleVisibility: Boolean,
    selectedItem: List<Long>,
    changedTime: Long,
  ): Unit {
    _dao.toggleVisibilityClazzContent(toggleVisibility, selectedItem, changedTime)
  }

  public override suspend fun listOfEntriesInClazz(clazzUid: Long): List<Long> =
      _dao.listOfEntriesInClazz(clazzUid)

  public override fun insert(entity: ClazzContentJoin): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.ccjUid == 0L) {
      val _newPk = _pkManager.nextId(134)
      entity.ccjUid = _newPk
    }
    entity.ccjLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.ccjUid
  }

  public override suspend fun insertAsync(entity: ClazzContentJoin): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.ccjUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(134)
      entity.ccjUid = _newPk
    }
    entity.ccjLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.ccjUid
  }

  public override fun insertList(entityList: List<ClazzContentJoin>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.ccjUid == 0L) {
        val _newPk = _pkManager.nextId(134)
        it.ccjUid = _newPk
        _generatedPks += _newPk
      }
      it.ccjLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<ClazzContentJoin>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.ccjLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: ClazzContentJoin): Unit {
    entity.ccjLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
