package com.ustadmobile.core.db.dao

import androidx.lifecycle.LiveData
import androidx.paging.DataSource
import com.ustadmobile.door.ext.doorPrimaryKeyManager
import com.ustadmobile.door.ext.rootDatabase
import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.ClazzLog
import kotlin.Boolean
import kotlin.Int
import kotlin.Long
import kotlin.Unit
import kotlin.collections.List

public class ClazzLogDao_ReplicateWrapper(
  private val _db: RoomDatabase,
  private val _dao: ClazzLogDao,
) : ClazzLogDao() {
  public override suspend fun replicateOnNewNode(newNodeId: Long): Unit {
    _dao.replicateOnNewNode(newNodeId)
  }

  public override fun replace(entity: ClazzLog): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.clazzLogUid == 0L) {
      val _newPk = _pkManager.nextId(14)
      entity.clazzLogUid = _newPk
    }
    entity.clazzLogLastChangedTime = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.replace(entity)
    return entity.clazzLogUid
  }

  public override suspend fun replicateOnChange(): Unit {
    _dao.replicateOnChange()
  }

  public override fun findByUid(uid: Long): ClazzLog? = _dao.findByUid(uid)

  public override suspend fun findByUidAsync(uid: Long): ClazzLog? = _dao.findByUidAsync(uid)

  public override fun findByUidLive(uid: Long): LiveData<ClazzLog?> = _dao.findByUidLive(uid)

  public override fun findByClazzUidAsFactory(clazzUid: Long, excludeStatus: Int):
      DataSource.Factory<Int, ClazzLog> = _dao.findByClazzUidAsFactory(clazzUid, excludeStatus)

  public override suspend fun findByClazzUidAsync(clazzUid: Long, excludeStatus: Int):
      List<ClazzLog> = _dao.findByClazzUidAsync(clazzUid, excludeStatus)

  public override suspend fun findByClazzUidWithinTimeRangeAsync(
    clazzUid: Long,
    fromTime: Long,
    toTime: Long,
    excludeStatusFilter: Int,
    limit: Int,
  ): List<ClazzLog> = _dao.findByClazzUidWithinTimeRangeAsync(clazzUid, fromTime, toTime,
      excludeStatusFilter, limit)

  public override fun findByClazzUidWithinTimeRange(
    clazzUid: Long,
    fromTime: Long,
    toTime: Long,
    excludeStatusFilter: Int,
    limit: Int,
  ): List<ClazzLog> = _dao.findByClazzUidWithinTimeRange(clazzUid, fromTime, toTime,
      excludeStatusFilter, limit)

  public override fun findByClazzUidWithinTimeRangeLive(
    clazzUid: Long,
    fromTime: Long,
    toTime: Long,
    statusFilter: Int,
  ): LiveData<List<ClazzLog>> = _dao.findByClazzUidWithinTimeRangeLive(clazzUid, fromTime, toTime,
      statusFilter)

  public override fun clazzHasScheduleLive(clazzUid: Long, excludeStatusFilter: Int):
      LiveData<Boolean> = _dao.clazzHasScheduleLive(clazzUid, excludeStatusFilter)

  public override fun updateStatusByClazzLogUid(
    clazzLogUid: Long,
    newStatus: Int,
    timeChanged: Long,
  ): Unit {
    _dao.updateStatusByClazzLogUid(clazzLogUid, newStatus, timeChanged)
  }

  public override suspend fun updateAsync(clazzLog: ClazzLog): Unit {
    clazzLog.clazzLogLastChangedTime = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.updateAsync(clazzLog)
  }

  public override fun insert(entity: ClazzLog): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.clazzLogUid == 0L) {
      val _newPk = _pkManager.nextId(14)
      entity.clazzLogUid = _newPk
    }
    entity.clazzLogLastChangedTime = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insert(entity)
    return entity.clazzLogUid
  }

  public override suspend fun insertAsync(entity: ClazzLog): Long {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    if(entity.clazzLogUid == 0L) {
      val _newPk = _pkManager.nextIdAsync(14)
      entity.clazzLogUid = _newPk
    }
    entity.clazzLogLastChangedTime = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.insertAsync(entity)
    return entity.clazzLogUid
  }

  public override fun insertList(entityList: List<ClazzLog>): Unit {
    val _pkManager = _db.rootDatabase.doorPrimaryKeyManager
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      if(it.clazzLogUid == 0L) {
        val _newPk = _pkManager.nextId(14)
        it.clazzLogUid = _newPk
        _generatedPks += _newPk
      }
      it.clazzLogLastChangedTime = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertList(entityList)
  }

  public override fun updateList(entityList: List<ClazzLog>): Unit {
    val _generatedPks = mutableListOf<Long>()
    entityList.iterator().forEach  {
      it.clazzLogLastChangedTime = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.updateList(entityList)
  }

  public override fun update(entity: ClazzLog): Unit {
    entity.clazzLogLastChangedTime = systemTimeInMillis()
    //must set versionid and/or primary key here
    _dao.update(entity)
  }
}
